#ifndef THCALCMD5_H
#define THCALCMD5_H

#include <QThread>
#include <QQueue>

typedef struct StEventData {
    int id; // Event ID
    QString param; // param data, LCD output string
} EventData;

class ThCalcMD5 : public QThread
{
    Q_OBJECT
public:
    explicit ThCalcMD5(QObject *parent = 0);
    ~ThCalcMD5();
    void stop();

    void sendEvent_Start(QString filepath);
    void sendEvent_Stop();

signals:
    void notify_calc_progress(int progress);
    void notify_calc_end(QString md5);

public slots:

protected:
    void run();

private:
    volatile bool stopped;

    // Event ID
    enum {
        Ev_Nop = 0,
        Ev_Start,
        Ev_Stop
    };
    QQueue<EventData> *EvtQue; // EventQueue


};

#endif // THCALCMD5_H
