#ifndef PLAYMUSICTHREAD_H
#define PLAYMUSICTHREAD_H

#include <QWidget> // WId
#include <QThread>
#include <QString>

#include <bass.h>

class PlayMusicThread : public QThread
{
    Q_OBJECT

public:
    PlayMusicThread(WId);
    ~PlayMusicThread();
    void stop();
    void PlayMusic(const QString &filepath);
    void StopMusic();
    int GetPlayStatus();

signals:
    void MusicStarted(const QString &message);
    void MusicEnded();

protected:
    void run();

    int MusicStart(const QString &musicfilename);
    void MusicStop();
    int IsMusicPlaying();

private:
    volatile bool stopped;
    volatile bool playstopped;

    QString FilePath;
    enum { IDLE = 0, PLAYING } state;

    HSTREAM hStrm;

    // unsigned int Count; // DummyCounter
};

#endif // PLAYMUSICTHREAD_H
