#include <QDebug>

#include <QThread>

#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ui->lcdNumber->display(0.0);

    // Init & Start DAQ Thread
    DaqTh = new DAQThread(this);
    // connect signals
    connect(DaqTh, SIGNAL(GetData(double)),
            this, SLOT(GetData(double)));
    // DaqTh start
    DaqTh->start();
}

MainWindow::~MainWindow()
{
    // Final DaqTh
    DaqTh->stop();
    DaqTh->wait();
    delete DaqTh;

    delete ui;
}

void MainWindow::GetData(double data)
{
    ui->lcdNumber->display(data);
//    qDebug() << QString("data is %1").arg(data);
}
