#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QDebug>
#include <QMessageBox>

#include <QRegExp>
#include <QRegExpValidator>

#include <QtCore/qmath.h> // qPow()

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    QRegExp regexpDevName("Dev[1-9][0-9]*");
    ui->comboBox_DevName->setValidator(new QRegExpValidator(regexpDevName, this));
    ui->comboBox_DevName->setEditable(true);
    ui->comboBox_DevName->setEnabled(true);
    ui->comboBox_DevName->setCurrentIndex(0);
    DevName = "Dev1";

    ui->statusBar->showMessage("DaqmxBase Initialize...");
    ui->pushButton_Output->setEnabled(false);
    ui->pushButton_Output->setText("ON");

//    ui->doubleSpinBox_Freq->setValue(1.0);
//    ui->dial_Freq->setValue(1);

    ui->doubleSpinBox_Duty->setValue(50.0);
    ui->horizontalSlider_Duty->setValue(50);

    flag_output_status = false;

    // Init & Start DAQ Thread
    DaqTh = new DAQThread(this);
    // connect signals
    connect(DaqTh, SIGNAL(daqmxbase_ready()),
                this, SLOT(daqmxbase_ready()));
    connect(DaqTh, SIGNAL(daqmxbase_final()),
                this, SLOT(daqmxbase_final()));
    connect(DaqTh, SIGNAL(daqmxbase_error(QString)),
                this, SLOT(daqmxbase_error(QString)));
    connect(DaqTh, SIGNAL(pulse_output_started()),
                this, SLOT(pulse_output_started()));
    connect(DaqTh, SIGNAL(pulse_output_stopped()),
            this, SLOT(pulse_output_stopped()));
            // DaqTh start
    DaqTh->start();
}

MainWindow::~MainWindow()
{
    // Final DaqTh
    DaqTh->stop();
    DaqTh->wait();
    delete DaqTh;

    delete ui;
}

void MainWindow::on_comboBox_DevName_editTextChanged(const QString &arg1)
{
    DevName = arg1;
//    qDebug() << QString("combobox_Devname is %1").arg(DevName);
}

void MainWindow::on_pushButton_Output_clicked()
{
    if (flag_output_status) {
        DaqTh->stopPulseOutput();
//        ui->pushButton_Output->setText("ON");
//        ui->comboBox_DevName->setEnabled(true);
//        flag_output_status = false;
    } else {
        int mode = ui->checkBox_ContMode->isChecked() ? 1 : 0;
        DaqTh->startPulseOutput(DevName,
                                (float)ui->doubleSpinBox_Freq->value(),
                                (float)ui->doubleSpinBox_Duty->value(),
                                mode,
                                (unsigned long long int)ui->spinBox_PulseCount->value());
        ui->pushButton_Output->setText("OFF");
        ui->comboBox_DevName->setEnabled(false);
        flag_output_status = true;
    }
}

void MainWindow::on_dial_Freq_valueChanged(int value)
{
    ui->doubleSpinBox_Freq->setValue((double)(value * (qPow(10.0,  ui->comboBox_FreqScale->currentIndex()))));

    DaqTh->changePulseOutput((float)ui->doubleSpinBox_Freq->value(), (float)ui->doubleSpinBox_Duty->value());
}

void MainWindow::on_comboBox_FreqScale_currentIndexChanged(int index)
{
    ui->doubleSpinBox_Freq->setValue((double)(ui->dial_Freq->value() * qPow(10.0, index)));

    DaqTh->changePulseOutput((float)ui->doubleSpinBox_Freq->value(), (float)ui->doubleSpinBox_Duty->value());
}

void MainWindow::on_doubleSpinBox_Duty_valueChanged(double arg1)
{
    ui->horizontalSlider_Duty->setValue((int)arg1);

    DaqTh->changePulseOutput((float)ui->doubleSpinBox_Freq->value(), (float)ui->doubleSpinBox_Duty->value());
}

void MainWindow::on_horizontalSlider_Duty_valueChanged(int value)
{
    ui->doubleSpinBox_Duty->setValue((double)value);
}

void MainWindow::on_checkBox_ContMode_toggled(bool checked)
{
    if (checked) {
        ui->spinBox_PulseCount->setEnabled(false);
    } else {
        ui->spinBox_PulseCount->setEnabled(true);
    }
}

void MainWindow::daqmxbase_ready()
{
    ui->statusBar->showMessage("Idle...");
    ui->pushButton_Output->setEnabled(true);
}

void MainWindow::daqmxbase_final()
{
    ui->pushButton_Output->setEnabled(false);
    ui->statusBar->showMessage("DaqmxBase final.");
}

void MainWindow::daqmxbase_error(QString ErrMsg)
{
    // Dialog
    QMessageBox::critical(this, "DaqmxBase Error", ErrMsg);
}

void MainWindow::pulse_output_started()
{
    ui->statusBar->showMessage("Output pulse.");
}

void MainWindow::pulse_output_stopped()
{
    ui->pushButton_Output->setText("ON");
    ui->comboBox_DevName->setEnabled(true);
    flag_output_status = false;

    ui->statusBar->showMessage("Idle...");
}
