/*
 *  QtUSBRH - USBRH + Qt4  alucky4416@users.sourceforge.jp
 *
 *     USBRH:Strawberry Linux co.ltd. http://strawberry-linux.com/
 *     libusb:libusb project  http://libusb.sourceforge.net/
 *
 *    Special Thanks: USBRH on *BSD http://www.nk-home.net/~aoyama/usbrh/
 *                    USBRH on Linux/libusb Mar.14 2007 http://d.hatena.ne.jp/Briareos/
 *
 *  This program is FREESOFTWARE, by the GPLv2.
 */

#include "mainwindow.h"
#include "ui_mainwindow.h"

#include <QMessageBox>
#include <QDebug>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    ui->lcdNum_Tempr->display(0.0);
    ui->lcdNum_Humid->display(0.0);
    IntvlTimer = NULL;
    int rc;

    rhdev = new usbrh();
    rc = rhdev->open();
    if (rc) {
        QMessageBox::warning(this, tr("QtUSBRH"), tr("USBRH Device Not Found."));
        return;
    }
    rc = rhdev->config();
    if (rc) {
        QMessageBox::warning(this, tr("QtUSBRH"), tr("USBRH Device Failure Config."));
        return;
    }

    IntvlTimer = new QTimer(this);
    connect(IntvlTimer, SIGNAL(timeout()), this, SLOT(TimeoutDone()));
    IntvlTimer->setInterval(1000);
    IntvlTimer->start();

}

MainWindow::~MainWindow()
{
    if(IntvlTimer) {
        IntvlTimer->stop();
        delete IntvlTimer;
    }

    rhdev->close();
    delete rhdev;

    delete ui;
}

void MainWindow::TimeoutDone()
{
    int rc;
    double Tempr = 0.0, Humid = 0.0;

    rc = rhdev->get_tempr_humid(&Tempr, &Humid);
//    qDebug() << QString("Tempr = %1, Humid = %2").arg(Tempr).arg(Humid);

    if (rc < 0) {
        ;
    } else {
        ui->lcdNum_Tempr->display(Tempr);
        ui->lcdNum_Humid->display(Humid);
    }

}

void MainWindow::on_checkBox_LED_0_stateChanged(int arg1)
{
    int rc;
    rc = rhdev->set_led_status(0, (unsigned char)arg1);
}

void MainWindow::on_checkBox_LED_1_stateChanged(int arg1)
{
    int rc;
    rc = rhdev->set_led_status(1, (unsigned char)arg1);

}

void MainWindow::on_checkBox_HEATER_stateChanged(int arg1)
{
    int rc;
    rc = rhdev->set_heater_status((unsigned char)arg1);

}
