#include "logstartdialog.h"
#include "ui_logstartdialog.h"

#include <QFile>
#include <QFileDialog>
#include <QDesktopServices>

LogStartDialog::LogStartDialog(QString path, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::LogStartDialog)
{
    ui->setupUi(this);

    LogSaveFolderPath = "";
    ui->lineEdit_logpath->setText(path);
    if (path.isEmpty() ||  !(QFile::exists(path))) {
        ui->buttonBox->setStandardButtons(QDialogButtonBox::Cancel);
    } else {
        ui->buttonBox->setStandardButtons(QDialogButtonBox::Ok | QDialogButtonBox::Cancel);
    }
    ui->lineEdit_logpath->setFocus();
}

LogStartDialog::~LogStartDialog()
{
    delete ui;
}

QString LogStartDialog::getLogSaveFolderPath()
{
    return LogSaveFolderPath;
}

void LogStartDialog::on_pushButton_Select_clicked()
{
    QString startpath;
    if (ui->lineEdit_logpath->text().isEmpty() || !(QFile::exists(ui->lineEdit_logpath->text()))) {
        startpath = QDesktopServices::storageLocation(QDesktopServices::HomeLocation);
    }
    QFileDialog::Options options = QFileDialog::DontResolveSymlinks | QFileDialog::ShowDirsOnly;
    QString dirpath = QFileDialog::getExistingDirectory(this,
                                                        tr("Select Log Save Folder"),
                                                        startpath,
                                                        options);
    if (dirpath.isEmpty()) {
        ; // cancel?
    } else {
        ui->lineEdit_logpath->setText(dirpath);
    }
}

void LogStartDialog::on_buttonBox_accepted()
{
    LogSaveFolderPath = ui->lineEdit_logpath->text();
}

void LogStartDialog::on_lineEdit_logpath_textChanged(const QString &arg1)
{
    if (arg1.isEmpty() ||  !(QFile::exists(arg1))) {
        ui->buttonBox->setStandardButtons(QDialogButtonBox::Cancel);
    } else {
        ui->buttonBox->setStandardButtons(QDialogButtonBox::Ok | QDialogButtonBox::Cancel);
    }
}
