<?php

// Start of Reflection v.$Id: 4af6c4c676864b1c0bfa693845af0688645c37cf $

class ReflectionException extends Exception  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class Reflection  {

	/**
	 * 修飾子の名前を取得する
	 * @link http://www.php.net/manual/ja/reflection.getmodifiernames.php
	 * @param modifiers int <p>
	 * 取得したい修飾子。数値形式となります。
	 * </p>
	 * @return array 修飾子の名前の配列を返します。
	 */
	public static function getModifierNames ($modifiers) {}

	/**
	 * エクスポートする
	 * @link http://www.php.net/manual/ja/reflection.export.php
	 * @param reflector Reflector <p>
	 * エクスポートするリフレクション。
	 * </p>
	 * @param return bool[optional] <p>
	 * TRUE に設定すると、エクスポートを発行するのではなく返します。
	 * FALSE (デフォルト) の場合はその逆です。
	 * </p>
	 * @return string return パラメータを
	 * TRUE に設定すると、エクスポートを文字列で返します。それ以外の場合は
	 * NULL を返します。
	 */
	public static function export ($reflector, $return = null) {}

}

interface Reflector  {

	/**
	 * エクスポートする
	 * @link http://www.php.net/manual/ja/reflector.export.php
	 * @return string 
	 */
	abstract public static function export () {}

	/**
	 * 文字列に変換する
	 * @link http://www.php.net/manual/ja/reflector.tostring.php
	 * @return string 
	 */
	abstract public function __toString () {}

}

class ReflectionFunctionAbstract implements Reflector {
	abstract public $name;


	/**
	 * 関数のクローンを作成する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.clone.php
	 * @return void 
	 */
	final private function __clone () {}

	/**
	 * 文字列に変換する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.tostring.php
	 * @return void 文字列を返します。
	 */
	abstract public function __toString () {}

	/**
	 * 関数が名前空間内にあるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.innamespace.php
	 * @return bool 名前空間内にある場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function inNamespace () {}

	/**
	 * クロージャであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.isclosure.php
	 * @return bool クロージャである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isClosure () {}

	/**
	 * 非推奨であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.isdeprecated.php
	 * @return bool 非推奨である場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDeprecated () {}

	/**
	 * 内部関数かどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.isinternal.php
	 * @return bool 内部関数である場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isInternal () {}

	/**
	 * ユーザー定義関数であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.isuserdefined.php
	 * @return bool ユーザー定義関数である場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isUserDefined () {}

	/**
	 * ドキュメントコメントを取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getdoccomment.php
	 * @return string ドキュメントコメントが存在する場合はそれを返します。それ以外の場合は FALSE
	 * を返します。
	 */
	public function getDocComment () {}

	/**
	 * 終了行番号を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getendline.php
	 * @return int ユーザー定義関数の終了行番号を返します。不明な場合は FALSE を返します。
	 */
	public function getEndLine () {}

	/**
	 * 拡張モジュールの情報を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getextension.php
	 * @return ReflectionExtension 拡張モジュールの情報を ReflectionExtension
	 * オブジェクトで返します。
	 */
	public function getExtension () {}

	/**
	 * 拡張モジュールの名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getextensionname.php
	 * @return string 拡張モジュールの名前を返します。
	 */
	public function getExtensionName () {}

	/**
	 * ファイル名を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getfilename.php
	 * @return string ファイル名を返します。
	 */
	public function getFileName () {}

	/**
	 * 関数名を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getname.php
	 * @return string 関数の名前を返します。
	 */
	public function getName () {}

	/**
	 * 名前空間名を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getnamespacename.php
	 * @return string 名前空間名を返します。
	 */
	public function getNamespaceName () {}

	/**
	 * パラメータ数を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getnumberofparameters.php
	 * @return int パラメータの数を返します。
	 */
	public function getNumberOfParameters () {}

	/**
	 * 必須パラメータの数を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getnumberofrequiredparameters.php
	 * @return int 必須パラメータの数を返します。
	 */
	public function getNumberOfRequiredParameters () {}

	/**
	 * パラメータを取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getparameters.php
	 * @return array パラメータを ReflectionParameter オブジェクトの配列で返します。
	 */
	public function getParameters () {}

	/**
	 * 関数の短い名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getshortname.php
	 * @return string 関数の短い名前を返します。
	 */
	public function getShortName () {}

	/**
	 * 開始行番号を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getstartline.php
	 * @return int 開始行番号を返します。
	 */
	public function getStartLine () {}

	/**
	 * 静的変数を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getstaticvariables.php
	 * @return array 静的変数の配列を返します。
	 */
	public function getStaticVariables () {}

	/**
	 * 参照返しかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.returnsreference.php
	 * @return bool 参照返しである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function returnsReference () {}

}

class ReflectionFunction extends ReflectionFunctionAbstract implements Reflector {
	const IS_DEPRECATED = 262144;

	public $name;


	/**
	 * ReflectionFunction オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/reflectionfunction.construct.php
	 * @param name
	 */
	public function __construct ($name) {}

	/**
	 * 文字列に変換する
	 * @link http://www.php.net/manual/ja/reflectionfunction.tostring.php
	 * @return string その関数について、
	 * ReflectionFunction::export のような出力を返します。
	 */
	public function __toString () {}

	/**
	 * 関数をエクスポートする
	 * @link http://www.php.net/manual/ja/reflectionfunction.export.php
	 * @param name string <p>
	 * エクスポートするリフレクション。
	 * </p>
	 * @param return string[optional] <p>
	 * TRUE に設定すると、エクスポートを発行するのではなく返します。
	 * FALSE (デフォルト) の場合はその逆です。
	 * </p>
	 * @return string return パラメータを
	 * TRUE に設定すると、エクスポートを文字列で返します。それ以外の場合は
	 * NULL を返します。
	 */
	public static function export ($name, $return = null) {}

	/**
	 * 関数が無効になっているかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunction.isdisabled.php
	 * @return bool 無効になっている場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDisabled () {}

	/**
	 * 関数を起動する
	 * @link http://www.php.net/manual/ja/reflectionfunction.invoke.php
	 * @param parameter mixed[optional] 
	 * @param _ mixed[optional] 
	 * @return mixed 起動した関数の結果を返します。
	 */
	public function invoke ($parameter = null, $_ = null) {}

	/**
	 * 引数を指定して関数を起動する
	 * @link http://www.php.net/manual/ja/reflectionfunction.invokeargs.php
	 * @param args array <p>
	 * 関数に渡す引数を含む配列。
	 * call_user_func_array と同じように動作します。
	 * </p>
	 * @return mixed 起動した関数の結果を返します。
	 */
	public function invokeArgs (array $args) {}

	/**
	 * 関数のクローンを作成する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.clone.php
	 * @return void 
	 */
	final private function __clone () {}

	/**
	 * 関数が名前空間内にあるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.innamespace.php
	 * @return bool 名前空間内にある場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function inNamespace () {}

	/**
	 * クロージャであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.isclosure.php
	 * @return bool クロージャである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isClosure () {}

	/**
	 * 非推奨であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.isdeprecated.php
	 * @return bool 非推奨である場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDeprecated () {}

	/**
	 * 内部関数かどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.isinternal.php
	 * @return bool 内部関数である場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isInternal () {}

	/**
	 * ユーザー定義関数であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.isuserdefined.php
	 * @return bool ユーザー定義関数である場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isUserDefined () {}

	/**
	 * ドキュメントコメントを取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getdoccomment.php
	 * @return string ドキュメントコメントが存在する場合はそれを返します。それ以外の場合は FALSE
	 * を返します。
	 */
	public function getDocComment () {}

	/**
	 * 終了行番号を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getendline.php
	 * @return int ユーザー定義関数の終了行番号を返します。不明な場合は FALSE を返します。
	 */
	public function getEndLine () {}

	/**
	 * 拡張モジュールの情報を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getextension.php
	 * @return ReflectionExtension 拡張モジュールの情報を ReflectionExtension
	 * オブジェクトで返します。
	 */
	public function getExtension () {}

	/**
	 * 拡張モジュールの名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getextensionname.php
	 * @return string 拡張モジュールの名前を返します。
	 */
	public function getExtensionName () {}

	/**
	 * ファイル名を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getfilename.php
	 * @return string ファイル名を返します。
	 */
	public function getFileName () {}

	/**
	 * 関数名を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getname.php
	 * @return string 関数の名前を返します。
	 */
	public function getName () {}

	/**
	 * 名前空間名を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getnamespacename.php
	 * @return string 名前空間名を返します。
	 */
	public function getNamespaceName () {}

	/**
	 * パラメータ数を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getnumberofparameters.php
	 * @return int パラメータの数を返します。
	 */
	public function getNumberOfParameters () {}

	/**
	 * 必須パラメータの数を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getnumberofrequiredparameters.php
	 * @return int 必須パラメータの数を返します。
	 */
	public function getNumberOfRequiredParameters () {}

	/**
	 * パラメータを取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getparameters.php
	 * @return array パラメータを ReflectionParameter オブジェクトの配列で返します。
	 */
	public function getParameters () {}

	/**
	 * 関数の短い名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getshortname.php
	 * @return string 関数の短い名前を返します。
	 */
	public function getShortName () {}

	/**
	 * 開始行番号を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getstartline.php
	 * @return int 開始行番号を返します。
	 */
	public function getStartLine () {}

	/**
	 * 静的変数を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getstaticvariables.php
	 * @return array 静的変数の配列を返します。
	 */
	public function getStaticVariables () {}

	/**
	 * 参照返しかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.returnsreference.php
	 * @return bool 参照返しである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function returnsReference () {}

}

class ReflectionParameter implements Reflector {
	public $name;


	/**
	 * クローンする
	 * @link http://www.php.net/manual/ja/reflectionparameter.clone.php
	 * @return void 
	 */
	final private function __clone () {}

	/**
	 * エクスポートする
	 * @link http://www.php.net/manual/ja/reflectionparameter.export.php
	 * @param function string <p>
	 * 関数名。
	 * </p>
	 * @param parameter string <p>
	 * パラメータ名。
	 * </p>
	 * @param return bool[optional] <p>
	 * TRUE に設定すると、エクスポートを発行するのではなく返します。
	 * FALSE (デフォルト) の場合はその逆です。 
	 * </p>
	 * @return string エクスポート結果を返します。
	 */
	public static function export ($function, $parameter, $return = null) {}

	/**
	 * コンストラクタ
	 * @link http://www.php.net/manual/ja/reflectionparameter.construct.php
	 * @param function
	 * @param parameter
	 */
	public function __construct ($function, $parameter) {}

	/**
	 * 文字列に変換する
	 * @link http://www.php.net/manual/ja/reflectionparameter.tostring.php
	 * @return string 
	 */
	public function __toString () {}

	/**
	 * パラメータ名を取得する
	 * @link http://www.php.net/manual/ja/reflectionparameter.getname.php
	 * @return string パラメータ名を返します。
	 */
	public function getName () {}

	/**
	 * 参照渡しかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionparameter.ispassedbyreference.php
	 * @return bool パラメータが参照渡しである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isPassedByReference () {}

	/**
	 * 宣言している関数を取得する
	 * @link http://www.php.net/manual/ja/reflectionparameter.getdeclaringfunction.php
	 * @return ReflectionFunction ReflectionFunction オブジェクトを返します。
	 */
	public function getDeclaringFunction () {}

	/**
	 * 宣言しているクラスを取得する
	 * @link http://www.php.net/manual/ja/reflectionparameter.getdeclaringclass.php
	 * @return ReflectionClass ReflectionClass オブジェクトを返します。
	 */
	public function getDeclaringClass () {}

	/**
	 * クラスを取得する
	 * @link http://www.php.net/manual/ja/reflectionparameter.getclass.php
	 * @return ReflectionClass ReflectionClass オブジェクトを返します。
	 */
	public function getClass () {}

	/**
	 * 配列を受け取るパラメータであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionparameter.isarray.php
	 * @return bool 配列を受け取るパラメータである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isArray () {}

	/**
	 * null を許可するかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionparameter.allowsnull.php
	 * @return bool NULL を許可する場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function allowsNull () {}

	/**
	 * パラメータの位置を取得する
	 * @link http://www.php.net/manual/ja/reflectionparameter.getposition.php
	 * @return int パラメータの位置を取得します。左から右へ数え、最初のパラメータが 0 番目となります。
	 */
	public function getPosition () {}

	/**
	 * 省略可能であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionparameter.isoptional.php
	 * @return bool 省略可能である場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isOptional () {}

	/**
	 * デフォルト値が存在するかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionparameter.isdefaultvalueavailable.php
	 * @return bool デフォルト値が存在する場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDefaultValueAvailable () {}

	/**
	 * パラメータのデフォルト値を取得する
	 * @link http://www.php.net/manual/ja/reflectionparameter.getdefaultvalue.php
	 * @return mixed パラメータのデフォルト対を返します。
	 */
	public function getDefaultValue () {}

}

class ReflectionMethod extends ReflectionFunctionAbstract implements Reflector {
	const IS_STATIC = 1;
	const IS_PUBLIC = 256;
	const IS_PROTECTED = 512;
	const IS_PRIVATE = 1024;
	const IS_ABSTRACT = 2;
	const IS_FINAL = 4;

	public $name;
	public $class;


	/**
	 * メソッドをエクスポートする
	 * @link http://www.php.net/manual/ja/reflectionmethod.export.php
	 * @param class string <p>
	 * クラス名。
	 * </p>
	 * @param name string <p>
	 * メソッド名。
	 * </p>
	 * @param return bool[optional] <p>
	 * TRUE に設定すると、エクスポートを発行するのではなく返します。
	 * FALSE (デフォルト) の場合はその逆です。
	 * </p>
	 * @return string return パラメータを
	 * TRUE に設定すると、エクスポートを文字列で返します。それ以外の場合は
	 * NULL を返します。
	 */
	public static function export ($class, $name, $return = null) {}

	/**
	 * ReflectionMethod を作成する
	 * @link http://www.php.net/manual/ja/reflectionmethod.construct.php
	 * @param class_or_method
	 * @param name[optional]
	 */
	public function __construct ($class_or_method, $name) {}

	/**
	 * ReflectionMethod オブジェクトの文字列表現を返す
	 * @link http://www.php.net/manual/ja/reflectionmethod.tostring.php
	 * @return string ReflectionMethod のインスタンスの文字列表現を返します。
	 */
	public function __toString () {}

	/**
	 * public メソッドであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionmethod.ispublic.php
	 * @return bool public メソッドである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isPublic () {}

	/**
	 * private メソッドであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionmethod.isprivate.php
	 * @return bool private メソッドである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isPrivate () {}

	/**
	 * protected メソッドであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionmethod.isprotected.php
	 * @return bool protected メソッドである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isProtected () {}

	/**
	 * 抽象メソッドであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionmethod.isabstract.php
	 * @return bool 抽象メソッドである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isAbstract () {}

	/**
	 * final メソッドであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionmethod.isfinal.php
	 * @return bool final メソッドである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isFinal () {}

	/**
	 * 静的メソッドであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionmethod.isstatic.php
	 * @return bool 静的メソッドである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isStatic () {}

	/**
	 * コンストラクタであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionmethod.isconstructor.php
	 * @return bool コンストラクタである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isConstructor () {}

	/**
	 * デストラクタであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionmethod.isdestructor.php
	 * @return bool デストラクタである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDestructor () {}

	/**
	 * メソッドの修飾子を取得する
	 * @link http://www.php.net/manual/ja/reflectionmethod.getmodifiers.php
	 * @return int 修飾子をあらわす数値を返します。修飾子の一覧は以下のとおりです。
	 * これらの修飾子の実際の意味については
	 * 定義済みの定数 に説明があります。
	 */
	public function getModifiers () {}

	/**
	 * 実行する
	 * @link http://www.php.net/manual/ja/reflectionmethod.invoke.php
	 * @param object object <p>
	 * メソッドを実行するオブジェクト。静的メソッドを実行する場合は、このパラメータには
	 * null を渡すことができます。
	 * </p>
	 * @param parameter mixed[optional] <p>
	 * メソッドに渡すパラメータ。可変長のパラメータを渡すことができます。
	 * </p>
	 * @param _ mixed[optional] 
	 * @return mixed メソッドの結果を返します。
	 */
	public function invoke ($object, $parameter = null, $_ = null) {}

	/**
	 * 実行する
	 * @link http://www.php.net/manual/ja/reflectionmethod.invokeargs.php
	 * @param object object <p>
	 * メソッドを実行するオブジェクト。静的メソッドを実行する場合は、このパラメータには
	 * null を渡すことができます。
	 * </p>
	 * @param args array <p>
	 * メソッドに渡すパラメータを配列で指定します。
	 * </p>
	 * @return mixed メソッドの結果を返します。
	 */
	public function invokeArgs ($object, array $args) {}

	/**
	 * メソッドが宣言されているクラスを取得する
	 * @link http://www.php.net/manual/ja/reflectionmethod.getdeclaringclass.php
	 * @return ReflectionClass そのメソッドが属するクラスをあらわす ReflectionClass
	 * オブジェクトを返します。
	 */
	public function getDeclaringClass () {}

	/**
	 * メソッドのプロトタイプを (存在すれば) 取得する
	 * @link http://www.php.net/manual/ja/reflectionmethod.getprototype.php
	 * @return ReflectionMethod メソッドのプロトタイプの ReflectionMethod オブジェクトを返します。
	 */
	public function getPrototype () {}

	/**
	 * メソッドのアクセス範囲を設定する
	 * @link http://www.php.net/manual/ja/reflectionmethod.setaccessible.php
	 * @param accessible bool <p>
	 * TRUE を指定すると、アクセスできるようになります。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setAccessible ($accessible) {}

	/**
	 * 関数のクローンを作成する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.clone.php
	 * @return void 
	 */
	final private function __clone () {}

	/**
	 * 関数が名前空間内にあるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.innamespace.php
	 * @return bool 名前空間内にある場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function inNamespace () {}

	/**
	 * クロージャであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.isclosure.php
	 * @return bool クロージャである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isClosure () {}

	/**
	 * 非推奨であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.isdeprecated.php
	 * @return bool 非推奨である場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isDeprecated () {}

	/**
	 * 内部関数かどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.isinternal.php
	 * @return bool 内部関数である場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isInternal () {}

	/**
	 * ユーザー定義関数であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.isuserdefined.php
	 * @return bool ユーザー定義関数である場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isUserDefined () {}

	/**
	 * ドキュメントコメントを取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getdoccomment.php
	 * @return string ドキュメントコメントが存在する場合はそれを返します。それ以外の場合は FALSE
	 * を返します。
	 */
	public function getDocComment () {}

	/**
	 * 終了行番号を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getendline.php
	 * @return int ユーザー定義関数の終了行番号を返します。不明な場合は FALSE を返します。
	 */
	public function getEndLine () {}

	/**
	 * 拡張モジュールの情報を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getextension.php
	 * @return ReflectionExtension 拡張モジュールの情報を ReflectionExtension
	 * オブジェクトで返します。
	 */
	public function getExtension () {}

	/**
	 * 拡張モジュールの名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getextensionname.php
	 * @return string 拡張モジュールの名前を返します。
	 */
	public function getExtensionName () {}

	/**
	 * ファイル名を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getfilename.php
	 * @return string ファイル名を返します。
	 */
	public function getFileName () {}

	/**
	 * 関数名を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getname.php
	 * @return string 関数の名前を返します。
	 */
	public function getName () {}

	/**
	 * 名前空間名を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getnamespacename.php
	 * @return string 名前空間名を返します。
	 */
	public function getNamespaceName () {}

	/**
	 * パラメータ数を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getnumberofparameters.php
	 * @return int パラメータの数を返します。
	 */
	public function getNumberOfParameters () {}

	/**
	 * 必須パラメータの数を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getnumberofrequiredparameters.php
	 * @return int 必須パラメータの数を返します。
	 */
	public function getNumberOfRequiredParameters () {}

	/**
	 * パラメータを取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getparameters.php
	 * @return array パラメータを ReflectionParameter オブジェクトの配列で返します。
	 */
	public function getParameters () {}

	/**
	 * 関数の短い名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getshortname.php
	 * @return string 関数の短い名前を返します。
	 */
	public function getShortName () {}

	/**
	 * 開始行番号を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getstartline.php
	 * @return int 開始行番号を返します。
	 */
	public function getStartLine () {}

	/**
	 * 静的変数を取得する
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.getstaticvariables.php
	 * @return array 静的変数の配列を返します。
	 */
	public function getStaticVariables () {}

	/**
	 * 参照返しかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionfunctionabstract.returnsreference.php
	 * @return bool 参照返しである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function returnsReference () {}

}

class ReflectionClass implements Reflector {
	const IS_IMPLICIT_ABSTRACT = 16;
	const IS_EXPLICIT_ABSTRACT = 32;
	const IS_FINAL = 64;

	public $name;


	final private function __clone () {}

	/**
	 * クラスをエクスポートする
	 * @link http://www.php.net/manual/ja/reflectionclass.export.php
	 * @param argument mixed <p>
	 * エクスポートするリフレクション。
	 * </p>
	 * @param return bool[optional] <p>
	 * TRUE に設定すると、エクスポートを発行するのではなく返します。
	 * FALSE (デフォルト) の場合はその逆です。
	 * </p>
	 * @return string return パラメータを
	 * TRUE に設定すると、エクスポートを文字列で返します。それ以外の場合は
	 * NULL を返します。
	 */
	public static function export ($argument, $return = null) {}

	/**
	 * ReflectionClass を作成する
	 * @link http://www.php.net/manual/ja/reflectionclass.construct.php
	 * @param argument
	 */
	public function __construct ($argument) {}

	/**
	 * ReflectionClass オブジェクトの文字列表現を返す
	 * @link http://www.php.net/manual/ja/reflectionclass.tostring.php
	 * @return string この ReflectionClass インスタンスの文字列表現を返します。
	 */
	public function __toString () {}

	/**
	 * クラスの名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getname.php
	 * @return string クラスの名前を返します。
	 */
	public function getName () {}

	/**
	 * 拡張モジュールあるいはコアで定義された内部クラスであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isinternal.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isInternal () {}

	/**
	 * ユーザー定義であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isuserdefined.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isUserDefined () {}

	/**
	 * クラスのインスタンス化が可能であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isinstantiable.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isInstantiable () {}

	/**
	 * クラスが定義されているファイルのファイル名を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getfilename.php
	 * @return string クラスが定義されているファイルのファイル名を返します。
	 * そのクラスが PHP のコアあるいは PHP の拡張モジュール内で定義されている場合は
	 * FALSE を返します。
	 */
	public function getFileName () {}

	/**
	 * 開始行を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getstartline.php
	 * @return int 開始行を返します。
	 */
	public function getStartLine () {}

	/**
	 * 終了行を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getendline.php
	 * @return int ユーザー定義クラスの定義の終了行を返します。不明な場合は FALSE を返します。
	 */
	public function getEndLine () {}

	/**
	 * ドキュメントコメントを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getdoccomment.php
	 * @return string ドキュメントコメントが存在すればそれを返します。存在しなければ FALSE を返します。
	 */
	public function getDocComment () {}

	/**
	 * クラスのコンストラクタを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getconstructor.php
	 * @return object クラスのコンストラクタを表す ReflectionMethod オブジェクトを返します。
	 * クラスのコンストラクタがない場合は NULL を返します。
	 */
	public function getConstructor () {}

	/**
	 * メソッドが定義されているかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.hasmethod.php
	 * @param name string <p>
	 * 調べたいメソッドの名前。
	 * </p>
	 * @return bool メソッドが定義されている場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function hasMethod ($name) {}

	/**
	 * クラスメソッドの <classname>ReflectionMethod</classname> を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getmethod.php
	 * @param name string <p>
	 * 調べたいメソッドの名前。
	 * </p>
	 * @return ReflectionMethod ReflectionMethod を返します。
	 */
	public function getMethod ($name) {}

	/**
	 * メソッドの配列を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getmethods.php
	 * @param filter string[optional] <p>
	 * 結果をフィルタして、特定の属性を持つメソッドだけを含めるようにします。
	 * デフォルトは、何もフィルタしません。
	 * </p>
	 * <p>
	 * ReflectionMethod::IS_STATIC、
	 * ReflectionMethod::IS_PUBLIC、
	 * ReflectionMethod::IS_PROTECTED、
	 * ReflectionMethod::IS_PRIVATE、
	 * ReflectionMethod::IS_ABSTRACT、
	 * ReflectionMethod::IS_FINAL
	 * の任意の組み合わせ。
	 * </p>
	 * @return array 各メソッドを表す ReflectionMethod オブジェクトの配列を返します。
	 */
	public function getMethods ($filter = null) {}

	/**
	 * プロパティが定義されているかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.hasproperty.php
	 * @param name string <p>
	 * 調べたいプロパティの名前。
	 * </p>
	 * @return bool プロパティが定義されている場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function hasProperty ($name) {}

	/**
	 * クラスのプロパティを表す <classname>ReflectionProperty</classname> を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getproperty.php
	 * @param name string <p>
	 * プロパティの名前。
	 * </p>
	 * @return ReflectionProperty ReflectionProperty を返します。
	 */
	public function getProperty ($name) {}

	/**
	 * プロパティを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getproperties.php
	 * @param filter int[optional] <p>
	 * オプションのフィルタで、取得したいプロパティの型を絞り込みます。
	 * ReflectionProperty の定数
	 * で設定し、デフォルトではすべてのプロパティ型を取得します。
	 * </p>
	 * @return array ReflectionProperty オブジェクトの配列を返します。
	 */
	public function getProperties ($filter = null) {}

	/**
	 * 定数が定義されているかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.hasconstant.php
	 * @param name string <p>
	 * 調べたい定数の名前。
	 * </p>
	 * @return bool 定数が定義されている場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function hasConstant ($name) {}

	/**
	 * 定数を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getconstants.php
	 * @return array 定数の配列を返します。
	 * 定数名が配列のキー、定数の値が配列の値となります。
	 */
	public function getConstants () {}

	/**
	 * 定義されている定数を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getconstant.php
	 * @param name string <p>
	 * 定数の名前。
	 * </p>
	 * @return mixed 定数の値を返します。
	 */
	public function getConstant ($name) {}

	/**
	 * インターフェイスを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getinterfaces.php
	 * @return array インターフェイスの連想配列を返します。インターフェイス名が連想配列のキー、対応する値が
	 * ReflectionClass オブジェクトとなります。
	 */
	public function getInterfaces () {}

	/**
	 * インターフェイスの名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getinterfacenames.php
	 * @return array インターフェイス名の配列を返します。
	 */
	public function getInterfaceNames () {}

	/**
	 * このクラスがインターフェイスであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isinterface.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isInterface () {}

	/**
	 * 抽象クラスであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isabstract.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isAbstract () {}

	/**
	 * final クラスであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isfinal.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isFinal () {}

	/**
	 * 修飾子を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getmodifiers.php
	 * @return int 修飾子定数 のビットマスクを返します。
	 */
	public function getModifiers () {}

	/**
	 * クラスのインスタンスであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isinstance.php
	 * @param object object <p>
	 * 比べたいオブジェクト。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isInstance ($object) {}

	/**
	 * 指定した引数でクラスの新しいインスタンスを作成する
	 * @link http://www.php.net/manual/ja/reflectionclass.newinstance.php
	 * @param args mixed <p>
	 * 可変長の引数を受け付け、それを call_user_func
	 * と同じ方式でクラスのコンストラクタに渡します。
	 * </p>
	 * @param _ mixed[optional] 
	 * @return object 
	 */
	public function newInstance ($args, $_ = null) {}

	/**
	 * 指定した引数でクラスの新しいインスタンスを作成する
	 * @link http://www.php.net/manual/ja/reflectionclass.newinstanceargs.php
	 * @param args array[optional] <p>
	 * クラスのコンストラクタに渡すパラメータを配列で指定します。
	 * </p>
	 * @return object クラスの新しいインスタンスを返します。
	 */
	public function newInstanceArgs (array $args = null) {}

	/**
	 * 親クラスを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getparentclass.php
	 * @return object ReflectionClass を返します。
	 */
	public function getParentClass () {}

	/**
	 * サブクラスであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.issubclassof.php
	 * @param class string <p>
	 * 調べたいクラス。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSubclassOf ($class) {}

	/**
	 * 静的なプロパティを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getstaticproperties.php
	 * @return array 静的なプロパティを配列で返します。
	 */
	public function getStaticProperties () {}

	/**
	 * 静的なプロパティの値を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getstaticpropertyvalue.php
	 * @param name string <p>
	 * 値を返したい静的プロパティの名前。
	 * </p>
	 * @return mixed 静的プロパティの値を返します。
	 */
	public function getStaticPropertyValue ($name) {}

	/**
	 * 静的なプロパティの値を設定する
	 * @link http://www.php.net/manual/ja/reflectionclass.setstaticpropertyvalue.php
	 * @param name string <p>
	 * プロパティの名前。
	 * </p>
	 * @param value string <p>
	 * 新しいプロパティの値。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setStaticPropertyValue ($name, $value) {}

	/**
	 * デフォルトプロパティを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getdefaultproperties.php
	 * @return array デフォルトプロパティの配列を返します。プロパティ名が配列のキー、
	 * そしてそのプロパティのデフォルト値が配列の値 (デフォルト値が存在しない場合は NULL) となります。
	 * この関数は静的なプロパティとそうでないプロパティを区別せず、
	 * アクセス修飾子も考慮しません。
	 */
	public function getDefaultProperties () {}

	/**
	 * 反復処理が可能であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isiterateable.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isIterateable () {}

	/**
	 * インターフェイスの実装を調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.implementsinterface.php
	 * @param interface string <p>
	 * インターフェイスの名前。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function implementsInterface ($interface) {}

	/**
	 * クラスを定義する拡張モジュールを表す <classname>ReflectionExtension</classname> オブジェクトを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getextension.php
	 * @return ReflectionExtension クラスを定義する拡張モジュールを表す ReflectionExtension オブジェクトを返します。
	 * ユーザー定義のクラスの場合は NULL を返します。
	 */
	public function getExtension () {}

	/**
	 * クラスを定義する拡張モジュールの名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getextensionname.php
	 * @return string クラスを定義する拡張モジュールの名前を返します。
	 * ユーザー定義のクラスの場合は FALSE を返します。
	 */
	public function getExtensionName () {}

	/**
	 * 名前空間内にあるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.innamespace.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function inNamespace () {}

	/**
	 * 名前空間の名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getnamespacename.php
	 * @return string 名前空間の名前を返します。
	 */
	public function getNamespaceName () {}

	/**
	 * 短い名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getshortname.php
	 * @return string クラスの短い名前を返します。
	 */
	public function getShortName () {}

}

class ReflectionObject extends ReflectionClass implements Reflector {
	const IS_IMPLICIT_ABSTRACT = 16;
	const IS_EXPLICIT_ABSTRACT = 32;
	const IS_FINAL = 64;

	public $name;


	/**
	 * エクスポートする
	 * @link http://www.php.net/manual/ja/reflectionobject.export.php
	 * @param argument string <p>
	 * エクスポートするリフレクション。 
	 * </p>
	 * @param return bool[optional] <p>
	 * TRUE に設定すると、エクスポートを発行するのではなく返します。
	 * FALSE (デフォルト) の場合はその逆です。 
	 * </p>
	 * @return string return パラメータを
	 * TRUE に設定すると、エクスポートを文字列で返します。それ以外の場合は
	 * NULL を返します。
	 */
	public static function export ($argument, $return = null) {}

	/**
	 * ReflectionObject を作成する
	 * @link http://www.php.net/manual/ja/reflectionobject.construct.php
	 * @param argument
	 */
	public function __construct ($argument) {}

	final private function __clone () {}

	/**
	 * ReflectionClass オブジェクトの文字列表現を返す
	 * @link http://www.php.net/manual/ja/reflectionclass.tostring.php
	 * @return string この ReflectionClass インスタンスの文字列表現を返します。
	 */
	public function __toString () {}

	/**
	 * クラスの名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getname.php
	 * @return string クラスの名前を返します。
	 */
	public function getName () {}

	/**
	 * 拡張モジュールあるいはコアで定義された内部クラスであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isinternal.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isInternal () {}

	/**
	 * ユーザー定義であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isuserdefined.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isUserDefined () {}

	/**
	 * クラスのインスタンス化が可能であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isinstantiable.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isInstantiable () {}

	/**
	 * クラスが定義されているファイルのファイル名を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getfilename.php
	 * @return string クラスが定義されているファイルのファイル名を返します。
	 * そのクラスが PHP のコアあるいは PHP の拡張モジュール内で定義されている場合は
	 * FALSE を返します。
	 */
	public function getFileName () {}

	/**
	 * 開始行を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getstartline.php
	 * @return int 開始行を返します。
	 */
	public function getStartLine () {}

	/**
	 * 終了行を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getendline.php
	 * @return int ユーザー定義クラスの定義の終了行を返します。不明な場合は FALSE を返します。
	 */
	public function getEndLine () {}

	/**
	 * ドキュメントコメントを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getdoccomment.php
	 * @return string ドキュメントコメントが存在すればそれを返します。存在しなければ FALSE を返します。
	 */
	public function getDocComment () {}

	/**
	 * クラスのコンストラクタを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getconstructor.php
	 * @return object クラスのコンストラクタを表す ReflectionMethod オブジェクトを返します。
	 * クラスのコンストラクタがない場合は NULL を返します。
	 */
	public function getConstructor () {}

	/**
	 * メソッドが定義されているかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.hasmethod.php
	 * @param name string <p>
	 * 調べたいメソッドの名前。
	 * </p>
	 * @return bool メソッドが定義されている場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function hasMethod ($name) {}

	/**
	 * クラスメソッドの <classname>ReflectionMethod</classname> を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getmethod.php
	 * @param name string <p>
	 * 調べたいメソッドの名前。
	 * </p>
	 * @return ReflectionMethod ReflectionMethod を返します。
	 */
	public function getMethod ($name) {}

	/**
	 * メソッドの配列を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getmethods.php
	 * @param filter string[optional] <p>
	 * 結果をフィルタして、特定の属性を持つメソッドだけを含めるようにします。
	 * デフォルトは、何もフィルタしません。
	 * </p>
	 * <p>
	 * ReflectionMethod::IS_STATIC、
	 * ReflectionMethod::IS_PUBLIC、
	 * ReflectionMethod::IS_PROTECTED、
	 * ReflectionMethod::IS_PRIVATE、
	 * ReflectionMethod::IS_ABSTRACT、
	 * ReflectionMethod::IS_FINAL
	 * の任意の組み合わせ。
	 * </p>
	 * @return array 各メソッドを表す ReflectionMethod オブジェクトの配列を返します。
	 */
	public function getMethods ($filter = null) {}

	/**
	 * プロパティが定義されているかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.hasproperty.php
	 * @param name string <p>
	 * 調べたいプロパティの名前。
	 * </p>
	 * @return bool プロパティが定義されている場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function hasProperty ($name) {}

	/**
	 * クラスのプロパティを表す <classname>ReflectionProperty</classname> を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getproperty.php
	 * @param name string <p>
	 * プロパティの名前。
	 * </p>
	 * @return ReflectionProperty ReflectionProperty を返します。
	 */
	public function getProperty ($name) {}

	/**
	 * プロパティを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getproperties.php
	 * @param filter int[optional] <p>
	 * オプションのフィルタで、取得したいプロパティの型を絞り込みます。
	 * ReflectionProperty の定数
	 * で設定し、デフォルトではすべてのプロパティ型を取得します。
	 * </p>
	 * @return array ReflectionProperty オブジェクトの配列を返します。
	 */
	public function getProperties ($filter = null) {}

	/**
	 * 定数が定義されているかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.hasconstant.php
	 * @param name string <p>
	 * 調べたい定数の名前。
	 * </p>
	 * @return bool 定数が定義されている場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function hasConstant ($name) {}

	/**
	 * 定数を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getconstants.php
	 * @return array 定数の配列を返します。
	 * 定数名が配列のキー、定数の値が配列の値となります。
	 */
	public function getConstants () {}

	/**
	 * 定義されている定数を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getconstant.php
	 * @param name string <p>
	 * 定数の名前。
	 * </p>
	 * @return mixed 定数の値を返します。
	 */
	public function getConstant ($name) {}

	/**
	 * インターフェイスを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getinterfaces.php
	 * @return array インターフェイスの連想配列を返します。インターフェイス名が連想配列のキー、対応する値が
	 * ReflectionClass オブジェクトとなります。
	 */
	public function getInterfaces () {}

	/**
	 * インターフェイスの名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getinterfacenames.php
	 * @return array インターフェイス名の配列を返します。
	 */
	public function getInterfaceNames () {}

	/**
	 * このクラスがインターフェイスであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isinterface.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isInterface () {}

	/**
	 * 抽象クラスであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isabstract.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isAbstract () {}

	/**
	 * final クラスであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isfinal.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isFinal () {}

	/**
	 * 修飾子を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getmodifiers.php
	 * @return int 修飾子定数 のビットマスクを返します。
	 */
	public function getModifiers () {}

	/**
	 * クラスのインスタンスであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isinstance.php
	 * @param object object <p>
	 * 比べたいオブジェクト。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isInstance ($object) {}

	/**
	 * 指定した引数でクラスの新しいインスタンスを作成する
	 * @link http://www.php.net/manual/ja/reflectionclass.newinstance.php
	 * @param args mixed <p>
	 * 可変長の引数を受け付け、それを call_user_func
	 * と同じ方式でクラスのコンストラクタに渡します。
	 * </p>
	 * @param _ mixed[optional] 
	 * @return object 
	 */
	public function newInstance ($args, $_ = null) {}

	/**
	 * 指定した引数でクラスの新しいインスタンスを作成する
	 * @link http://www.php.net/manual/ja/reflectionclass.newinstanceargs.php
	 * @param args array[optional] <p>
	 * クラスのコンストラクタに渡すパラメータを配列で指定します。
	 * </p>
	 * @return object クラスの新しいインスタンスを返します。
	 */
	public function newInstanceArgs (array $args = null) {}

	/**
	 * 親クラスを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getparentclass.php
	 * @return object ReflectionClass を返します。
	 */
	public function getParentClass () {}

	/**
	 * サブクラスであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.issubclassof.php
	 * @param class string <p>
	 * 調べたいクラス。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isSubclassOf ($class) {}

	/**
	 * 静的なプロパティを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getstaticproperties.php
	 * @return array 静的なプロパティを配列で返します。
	 */
	public function getStaticProperties () {}

	/**
	 * 静的なプロパティの値を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getstaticpropertyvalue.php
	 * @param name string <p>
	 * 値を返したい静的プロパティの名前。
	 * </p>
	 * @return mixed 静的プロパティの値を返します。
	 */
	public function getStaticPropertyValue ($name) {}

	/**
	 * 静的なプロパティの値を設定する
	 * @link http://www.php.net/manual/ja/reflectionclass.setstaticpropertyvalue.php
	 * @param name string <p>
	 * プロパティの名前。
	 * </p>
	 * @param value string <p>
	 * 新しいプロパティの値。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setStaticPropertyValue ($name, $value) {}

	/**
	 * デフォルトプロパティを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getdefaultproperties.php
	 * @return array デフォルトプロパティの配列を返します。プロパティ名が配列のキー、
	 * そしてそのプロパティのデフォルト値が配列の値 (デフォルト値が存在しない場合は NULL) となります。
	 * この関数は静的なプロパティとそうでないプロパティを区別せず、
	 * アクセス修飾子も考慮しません。
	 */
	public function getDefaultProperties () {}

	/**
	 * 反復処理が可能であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.isiterateable.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function isIterateable () {}

	/**
	 * インターフェイスの実装を調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.implementsinterface.php
	 * @param interface string <p>
	 * インターフェイスの名前。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function implementsInterface ($interface) {}

	/**
	 * クラスを定義する拡張モジュールを表す <classname>ReflectionExtension</classname> オブジェクトを取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getextension.php
	 * @return ReflectionExtension クラスを定義する拡張モジュールを表す ReflectionExtension オブジェクトを返します。
	 * ユーザー定義のクラスの場合は NULL を返します。
	 */
	public function getExtension () {}

	/**
	 * クラスを定義する拡張モジュールの名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getextensionname.php
	 * @return string クラスを定義する拡張モジュールの名前を返します。
	 * ユーザー定義のクラスの場合は FALSE を返します。
	 */
	public function getExtensionName () {}

	/**
	 * 名前空間内にあるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionclass.innamespace.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function inNamespace () {}

	/**
	 * 名前空間の名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getnamespacename.php
	 * @return string 名前空間の名前を返します。
	 */
	public function getNamespaceName () {}

	/**
	 * 短い名前を取得する
	 * @link http://www.php.net/manual/ja/reflectionclass.getshortname.php
	 * @return string クラスの短い名前を返します。
	 */
	public function getShortName () {}

}

class ReflectionProperty implements Reflector {
	const IS_STATIC = 1;
	const IS_PUBLIC = 256;
	const IS_PROTECTED = 512;
	const IS_PRIVATE = 1024;

	public $name;
	public $class;


	/**
	 * クローンする
	 * @link http://www.php.net/manual/ja/reflectionproperty.clone.php
	 * @return void 
	 */
	final private function __clone () {}

	/**
	 * エクスポートする
	 * @link http://www.php.net/manual/ja/reflectionproperty.export.php
	 * @param class mixed 
	 * @param name string <p>
	 * プロパティ名。
	 * </p>
	 * @param return bool[optional] <p>
	 * TRUE に設定すると、エクスポートを発行するのではなく返します。
	 * FALSE (デフォルト) の場合はその逆です。 
	 * </p>
	 * @return string 
	 */
	public static function export ($class, $name, $return = null) {}

	/**
	 * ReflectionProperty オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/reflectionproperty.construct.php
	 * @param class
	 * @param name
	 */
	public function __construct ($class, $name) {}

	/**
	 * 文字列に変換する
	 * @link http://www.php.net/manual/ja/reflectionproperty.tostring.php
	 * @return string 
	 */
	public function __toString () {}

	/**
	 * プロパティ名を取得する
	 * @link http://www.php.net/manual/ja/reflectionproperty.getname.php
	 * @return string 調べているプロパティの名前を返します。
	 */
	public function getName () {}

	/**
	 * 値を取得する
	 * @link http://www.php.net/manual/ja/reflectionproperty.getvalue.php
	 * @param object object <p>
	 * 静的でないプロパティの場合は、プロパティを取得したいオブジェクトを指定しなければなりません。
	 * オブジェクトを指定せずにデフォルトのプロパティを取得したい場合は、かわりに
	 * ReflectionClass::getDefaultProperties
	 * を使います。
	 * </p>
	 * @return mixed プロパティの現在の値を返します。
	 */
	public function getValue ($object) {}

	/**
	 * プロパティの値を設定する
	 * @link http://www.php.net/manual/ja/reflectionproperty.setvalue.php
	 * @param object object <p>
	 * 静的でないプロパティの場合は、プロパティを変更したいオブジェクトを指定しなければなりません。
	 * 静的なプロパティの場合はこのパラメータを省略し、
	 * value だけを指定しなければなりません。
	 * </p>
	 * @param value mixed <p>
	 * 新しい値。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setValue ($object, $value) {}

	/**
	 * public プロパティであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionproperty.ispublic.php
	 * @return bool public プロパティである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isPublic () {}

	/**
	 * private プロパティであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionproperty.isprivate.php
	 * @return bool private プロパティである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isPrivate () {}

	/**
	 * protected プロパティであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionproperty.isprotected.php
	 * @return bool protected プロパティである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isProtected () {}

	/**
	 * 静的プロパティであるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionproperty.isstatic.php
	 * @return bool 静的プロパティである場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function isStatic () {}

	/**
	 * デフォルト値であるかどうかを調べる
	 * @link http://www.php.net/manual/ja/reflectionproperty.isdefault.php
	 * @return bool プロパティがコンパイル時に宣言された者である場合に TRUE、
	 * 実行時に作られたものである場合に FALSE を返します。
	 */
	public function isDefault () {}

	/**
	 * 修飾子を取得する
	 * @link http://www.php.net/manual/ja/reflectionproperty.getmodifiers.php
	 * @return int 修飾子を数値で返します。
	 */
	public function getModifiers () {}

	/**
	 * 宣言しているクラスを取得する
	 * @link http://www.php.net/manual/ja/reflectionproperty.getdeclaringclass.php
	 * @return ReflectionClass ReflectionClass オブジェクトを返します。
	 */
	public function getDeclaringClass () {}

	/**
	 * ドキュメントコメントを取得する
	 * @link http://www.php.net/manual/ja/reflectionproperty.getdoccomment.php
	 * @return string ドキュメントコメントを返します。
	 */
	public function getDocComment () {}

	/**
	 * プロパティのアクセス範囲を設定する
	 * @link http://www.php.net/manual/ja/reflectionproperty.setaccessible.php
	 * @param accessible bool <p>
	 * TRUE を指定すると、アクセスできるようになります。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function setAccessible ($accessible) {}

}

class ReflectionExtension implements Reflector {
	public $name;


	/**
	 * クローンする
	 * @link http://www.php.net/manual/ja/reflectionextension.clone.php
	 * @return void 値は返しません。もしコールされれば致命的なエラーとなります。
	 */
	final private function __clone () {}

	/**
	 * エクスポートする
	 * @link http://www.php.net/manual/ja/reflectionextension.export.php
	 * @param name string <p>
	 * エクスポートするリフレクション。
	 * </p>
	 * @param return string[optional] <p>
	 * TRUE に設定すると、エクスポートを発行するのではなく返します。
	 * FALSE (デフォルト) の場合はその逆です。
	 * </p>
	 * @return string return パラメータを
	 * TRUE に設定すると、エクスポートを文字列で返します。それ以外の場合は
	 * NULL を返します。
	 */
	public static function export ($name, $return = null) {}

	/**
	 * ReflectionExtension を作成する
	 * @link http://www.php.net/manual/ja/reflectionextension.construct.php
	 * @param name
	 */
	public function __construct ($name) {}

	/**
	 * 文字列に変換する
	 * @link http://www.php.net/manual/ja/reflectionextension.tostring.php
	 * @return string エクスポートした拡張モジュールを文字列で返します。
	 * ReflectionExtension::export
	 * と同じ形式となります。
	 */
	public function __toString () {}

	/**
	 * 拡張モジュール名を取得する
	 * @link http://www.php.net/manual/ja/reflectionextension.getname.php
	 * @return string 拡張モジュールの名前を返します。
	 */
	public function getName () {}

	/**
	 * 拡張モジュールのバージョンを取得する
	 * @link http://www.php.net/manual/ja/reflectionextension.getversion.php
	 * @return string 拡張モジュールのバージョンを返します。
	 */
	public function getVersion () {}

	/**
	 * 拡張モジュールの関数を取得する
	 * @link http://www.php.net/manual/ja/reflectionextension.getfunctions.php
	 * @return array ReflectionFunction オブジェクトの連想配列を返します。
	 * 拡張モジュール内で定義されている関数名がキーとなります。
	 * 関数が定義されていない場合は空の配列を返します。
	 */
	public function getFunctions () {}

	/**
	 * 定数を取得する
	 * @link http://www.php.net/manual/ja/reflectionextension.getconstants.php
	 * @return array 定数名をキーとする連想配列を返します。
	 */
	public function getConstants () {}

	/**
	 * 拡張モジュールの ini エントリを取得する
	 * @link http://www.php.net/manual/ja/reflectionextension.getinientries.php
	 * @return array ini エントリをキー、定義されている値をキーに対応する値とした連想配列を返します。
	 */
	public function getINIEntries () {}

	/**
	 * クラスを取得する
	 * @link http://www.php.net/manual/ja/reflectionextension.getclasses.php
	 * @return array ReflectionClass オブジェクトの配列を返します。
	 * 各要素が、拡張モジュール内のクラスを表します。
	 * クラスが定義されていない場合は空の配列を返します。
	 */
	public function getClasses () {}

	/**
	 * クラス名を取得する
	 * @link http://www.php.net/manual/ja/reflectionextension.getclassnames.php
	 * @return array 拡張モジュールで定義されているクラス名の配列を返します。
	 * クラスが定義されていない場合は空の配列を返します。
	 */
	public function getClassNames () {}

	/**
	 * 依存性を取得する
	 * @link http://www.php.net/manual/ja/reflectionextension.getdependencies.php
	 * @return array 依存する拡張モジュールをキー、そして
	 * Required、Optional
	 * あるいは Conflicts
	 * のいずれかを値とする連想配列を返します。
	 */
	public function getDependencies () {}

	/**
	 * 拡張モジュールの情報を表示する
	 * @link http://www.php.net/manual/ja/reflectionextension.info.php
	 * @return void 拡張モジュールの情報を返します。
	 */
	public function info () {}

}
// End of Reflection v.$Id: 4af6c4c676864b1c0bfa693845af0688645c37cf $
?>
