<?php

// Start of imagick v.@PACKAGE_VERSION@

class ImagickException extends Exception  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class ImagickDrawException extends Exception  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class ImagickPixelIteratorException extends Exception  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class ImagickPixelException extends Exception  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class Imagick implements Iterator, Traversable {
	const COLOR_BLACK = 11;
	const COLOR_BLUE = 12;
	const COLOR_CYAN = 13;
	const COLOR_GREEN = 14;
	const COLOR_RED = 15;
	const COLOR_YELLOW = 16;
	const COLOR_MAGENTA = 17;
	const COLOR_OPACITY = 18;
	const COLOR_ALPHA = 19;
	const COLOR_FUZZ = 20;
	const IMAGICK_EXTNUM = 30100;
	const IMAGICK_EXTVER = "@PACKAGE_VERSION@";
	const COMPOSITE_DEFAULT = 40;
	const COMPOSITE_UNDEFINED = 0;
	const COMPOSITE_NO = 1;
	const COMPOSITE_ADD = 2;
	const COMPOSITE_ATOP = 3;
	const COMPOSITE_BLEND = 4;
	const COMPOSITE_BUMPMAP = 5;
	const COMPOSITE_CLEAR = 7;
	const COMPOSITE_COLORBURN = 8;
	const COMPOSITE_COLORDODGE = 9;
	const COMPOSITE_COLORIZE = 10;
	const COMPOSITE_COPYBLACK = 11;
	const COMPOSITE_COPYBLUE = 12;
	const COMPOSITE_COPY = 13;
	const COMPOSITE_COPYCYAN = 14;
	const COMPOSITE_COPYGREEN = 15;
	const COMPOSITE_COPYMAGENTA = 16;
	const COMPOSITE_COPYOPACITY = 17;
	const COMPOSITE_COPYRED = 18;
	const COMPOSITE_COPYYELLOW = 19;
	const COMPOSITE_DARKEN = 20;
	const COMPOSITE_DSTATOP = 21;
	const COMPOSITE_DST = 22;
	const COMPOSITE_DSTIN = 23;
	const COMPOSITE_DSTOUT = 24;
	const COMPOSITE_DSTOVER = 25;
	const COMPOSITE_DIFFERENCE = 26;
	const COMPOSITE_DISPLACE = 27;
	const COMPOSITE_DISSOLVE = 28;
	const COMPOSITE_EXCLUSION = 29;
	const COMPOSITE_HARDLIGHT = 30;
	const COMPOSITE_HUE = 31;
	const COMPOSITE_IN = 32;
	const COMPOSITE_LIGHTEN = 33;
	const COMPOSITE_LUMINIZE = 35;
	const COMPOSITE_MINUS = 36;
	const COMPOSITE_MODULATE = 37;
	const COMPOSITE_MULTIPLY = 38;
	const COMPOSITE_OUT = 39;
	const COMPOSITE_OVER = 40;
	const COMPOSITE_OVERLAY = 41;
	const COMPOSITE_PLUS = 42;
	const COMPOSITE_REPLACE = 43;
	const COMPOSITE_SATURATE = 44;
	const COMPOSITE_SCREEN = 45;
	const COMPOSITE_SOFTLIGHT = 46;
	const COMPOSITE_SRCATOP = 47;
	const COMPOSITE_SRC = 48;
	const COMPOSITE_SRCIN = 49;
	const COMPOSITE_SRCOUT = 50;
	const COMPOSITE_SRCOVER = 51;
	const COMPOSITE_SUBTRACT = 52;
	const COMPOSITE_THRESHOLD = 53;
	const COMPOSITE_XOR = 54;
	const MONTAGEMODE_FRAME = 1;
	const MONTAGEMODE_UNFRAME = 2;
	const MONTAGEMODE_CONCATENATE = 3;
	const STYLE_NORMAL = 1;
	const STYLE_ITALIC = 2;
	const STYLE_OBLIQUE = 3;
	const STYLE_ANY = 4;
	const FILTER_UNDEFINED = 0;
	const FILTER_POINT = 1;
	const FILTER_BOX = 2;
	const FILTER_TRIANGLE = 3;
	const FILTER_HERMITE = 4;
	const FILTER_HANNING = 5;
	const FILTER_HAMMING = 6;
	const FILTER_BLACKMAN = 7;
	const FILTER_GAUSSIAN = 8;
	const FILTER_QUADRATIC = 9;
	const FILTER_CUBIC = 10;
	const FILTER_CATROM = 11;
	const FILTER_MITCHELL = 12;
	const FILTER_LANCZOS = 22;
	const FILTER_BESSEL = 13;
	const FILTER_SINC = 14;
	const IMGTYPE_UNDEFINED = 0;
	const IMGTYPE_BILEVEL = 1;
	const IMGTYPE_GRAYSCALE = 2;
	const IMGTYPE_GRAYSCALEMATTE = 3;
	const IMGTYPE_PALETTE = 4;
	const IMGTYPE_PALETTEMATTE = 5;
	const IMGTYPE_TRUECOLOR = 6;
	const IMGTYPE_TRUECOLORMATTE = 7;
	const IMGTYPE_COLORSEPARATION = 8;
	const IMGTYPE_COLORSEPARATIONMATTE = 9;
	const IMGTYPE_OPTIMIZE = 10;
	const RESOLUTION_UNDEFINED = 0;
	const RESOLUTION_PIXELSPERINCH = 1;
	const RESOLUTION_PIXELSPERCENTIMETER = 2;
	const COMPRESSION_UNDEFINED = 0;
	const COMPRESSION_NO = 1;
	const COMPRESSION_BZIP = 2;
	const COMPRESSION_FAX = 6;
	const COMPRESSION_GROUP4 = 7;
	const COMPRESSION_JPEG = 8;
	const COMPRESSION_JPEG2000 = 9;
	const COMPRESSION_LOSSLESSJPEG = 10;
	const COMPRESSION_LZW = 11;
	const COMPRESSION_RLE = 12;
	const COMPRESSION_ZIP = 13;
	const COMPRESSION_DXT1 = 3;
	const COMPRESSION_DXT3 = 4;
	const COMPRESSION_DXT5 = 5;
	const PAINT_POINT = 1;
	const PAINT_REPLACE = 2;
	const PAINT_FLOODFILL = 3;
	const PAINT_FILLTOBORDER = 4;
	const PAINT_RESET = 5;
	const GRAVITY_NORTHWEST = 1;
	const GRAVITY_NORTH = 2;
	const GRAVITY_NORTHEAST = 3;
	const GRAVITY_WEST = 4;
	const GRAVITY_CENTER = 5;
	const GRAVITY_EAST = 6;
	const GRAVITY_SOUTHWEST = 7;
	const GRAVITY_SOUTH = 8;
	const GRAVITY_SOUTHEAST = 9;
	const STRETCH_NORMAL = 1;
	const STRETCH_ULTRACONDENSED = 2;
	const STRETCH_CONDENSED = 4;
	const STRETCH_SEMICONDENSED = 5;
	const STRETCH_SEMIEXPANDED = 6;
	const STRETCH_EXPANDED = 7;
	const STRETCH_EXTRAEXPANDED = 8;
	const STRETCH_ULTRAEXPANDED = 9;
	const STRETCH_ANY = 10;
	const ALIGN_UNDEFINED = 0;
	const ALIGN_LEFT = 1;
	const ALIGN_CENTER = 2;
	const ALIGN_RIGHT = 3;
	const DECORATION_NO = 1;
	const DECORATION_UNDERLINE = 2;
	const DECORATION_OVERLINE = 3;
	const DECORATION_LINETROUGH = 4;
	const NOISE_UNIFORM = 1;
	const NOISE_GAUSSIAN = 2;
	const NOISE_MULTIPLICATIVEGAUSSIAN = 3;
	const NOISE_IMPULSE = 4;
	const NOISE_LAPLACIAN = 5;
	const NOISE_POISSON = 6;
	const NOISE_RANDOM = 7;
	const CHANNEL_UNDEFINED = 0;
	const CHANNEL_RED = 1;
	const CHANNEL_GRAY = 1;
	const CHANNEL_CYAN = 1;
	const CHANNEL_GREEN = 2;
	const CHANNEL_MAGENTA = 2;
	const CHANNEL_BLUE = 4;
	const CHANNEL_YELLOW = 4;
	const CHANNEL_ALPHA = 8;
	const CHANNEL_OPACITY = 8;
	const CHANNEL_MATTE = 8;
	const CHANNEL_BLACK = 32;
	const CHANNEL_INDEX = 32;
	const CHANNEL_ALL = 134217727;
	const CHANNEL_DEFAULT = 134217719;
	const METRIC_UNDEFINED = 0;
	const METRIC_MEANABSOLUTEERROR = 2;
	const METRIC_MEANSQUAREERROR = 4;
	const METRIC_PEAKABSOLUTEERROR = 5;
	const METRIC_PEAKSIGNALTONOISERATIO = 6;
	const METRIC_ROOTMEANSQUAREDERROR = 7;
	const PIXEL_CHAR = 1;
	const PIXEL_DOUBLE = 2;
	const PIXEL_FLOAT = 3;
	const PIXEL_INTEGER = 4;
	const PIXEL_LONG = 5;
	const PIXEL_QUANTUM = 6;
	const PIXEL_SHORT = 7;
	const EVALUATE_UNDEFINED = 0;
	const EVALUATE_ADD = 1;
	const EVALUATE_AND = 2;
	const EVALUATE_DIVIDE = 3;
	const EVALUATE_LEFTSHIFT = 4;
	const EVALUATE_MAX = 5;
	const EVALUATE_MIN = 6;
	const EVALUATE_MULTIPLY = 7;
	const EVALUATE_OR = 8;
	const EVALUATE_RIGHTSHIFT = 9;
	const EVALUATE_SET = 10;
	const EVALUATE_SUBTRACT = 11;
	const EVALUATE_XOR = 12;
	const EVALUATE_POW = 13;
	const EVALUATE_LOG = 14;
	const EVALUATE_THRESHOLD = 15;
	const EVALUATE_THRESHOLDBLACK = 16;
	const EVALUATE_THRESHOLDWHITE = 17;
	const EVALUATE_GAUSSIANNOISE = 18;
	const EVALUATE_IMPULSENOISE = 19;
	const EVALUATE_LAPLACIANNOISE = 20;
	const EVALUATE_MULTIPLICATIVENOISE = 21;
	const EVALUATE_POISSONNOISE = 22;
	const EVALUATE_UNIFORMNOISE = 23;
	const EVALUATE_COSINE = 24;
	const EVALUATE_SINE = 25;
	const EVALUATE_ADDMODULUS = 26;
	const COLORSPACE_UNDEFINED = 0;
	const COLORSPACE_RGB = 1;
	const COLORSPACE_GRAY = 2;
	const COLORSPACE_TRANSPARENT = 3;
	const COLORSPACE_OHTA = 4;
	const COLORSPACE_LAB = 5;
	const COLORSPACE_XYZ = 6;
	const COLORSPACE_YCBCR = 7;
	const COLORSPACE_YCC = 8;
	const COLORSPACE_YIQ = 9;
	const COLORSPACE_YPBPR = 10;
	const COLORSPACE_YUV = 11;
	const COLORSPACE_CMYK = 12;
	const COLORSPACE_SRGB = 13;
	const COLORSPACE_HSB = 14;
	const COLORSPACE_HSL = 15;
	const COLORSPACE_HWB = 16;
	const COLORSPACE_REC601LUMA = 17;
	const COLORSPACE_REC709LUMA = 19;
	const COLORSPACE_LOG = 21;
	const COLORSPACE_CMY = 22;
	const VIRTUALPIXELMETHOD_UNDEFINED = 0;
	const VIRTUALPIXELMETHOD_BACKGROUND = 1;
	const VIRTUALPIXELMETHOD_CONSTANT = 2;
	const VIRTUALPIXELMETHOD_EDGE = 4;
	const VIRTUALPIXELMETHOD_MIRROR = 5;
	const VIRTUALPIXELMETHOD_TILE = 7;
	const VIRTUALPIXELMETHOD_TRANSPARENT = 8;
	const VIRTUALPIXELMETHOD_MASK = 9;
	const VIRTUALPIXELMETHOD_BLACK = 10;
	const VIRTUALPIXELMETHOD_GRAY = 11;
	const VIRTUALPIXELMETHOD_WHITE = 12;
	const VIRTUALPIXELMETHOD_HORIZONTALTILE = 13;
	const VIRTUALPIXELMETHOD_VERTICALTILE = 14;
	const PREVIEW_UNDEFINED = 0;
	const PREVIEW_ROTATE = 1;
	const PREVIEW_SHEAR = 2;
	const PREVIEW_ROLL = 3;
	const PREVIEW_HUE = 4;
	const PREVIEW_SATURATION = 5;
	const PREVIEW_BRIGHTNESS = 6;
	const PREVIEW_GAMMA = 7;
	const PREVIEW_SPIFF = 8;
	const PREVIEW_DULL = 9;
	const PREVIEW_GRAYSCALE = 10;
	const PREVIEW_QUANTIZE = 11;
	const PREVIEW_DESPECKLE = 12;
	const PREVIEW_REDUCENOISE = 13;
	const PREVIEW_ADDNOISE = 14;
	const PREVIEW_SHARPEN = 15;
	const PREVIEW_BLUR = 16;
	const PREVIEW_THRESHOLD = 17;
	const PREVIEW_EDGEDETECT = 18;
	const PREVIEW_SPREAD = 19;
	const PREVIEW_SOLARIZE = 20;
	const PREVIEW_SHADE = 21;
	const PREVIEW_RAISE = 22;
	const PREVIEW_SEGMENT = 23;
	const PREVIEW_SWIRL = 24;
	const PREVIEW_IMPLODE = 25;
	const PREVIEW_WAVE = 26;
	const PREVIEW_OILPAINT = 27;
	const PREVIEW_CHARCOALDRAWING = 28;
	const PREVIEW_JPEG = 29;
	const RENDERINGINTENT_UNDEFINED = 0;
	const RENDERINGINTENT_SATURATION = 1;
	const RENDERINGINTENT_PERCEPTUAL = 2;
	const RENDERINGINTENT_ABSOLUTE = 3;
	const RENDERINGINTENT_RELATIVE = 4;
	const INTERLACE_UNDEFINED = 0;
	const INTERLACE_NO = 1;
	const INTERLACE_LINE = 2;
	const INTERLACE_PLANE = 3;
	const INTERLACE_PARTITION = 4;
	const INTERLACE_GIF = 5;
	const INTERLACE_JPEG = 6;
	const INTERLACE_PNG = 7;
	const FILLRULE_UNDEFINED = 0;
	const FILLRULE_EVENODD = 1;
	const FILLRULE_NONZERO = 2;
	const PATHUNITS_UNDEFINED = 0;
	const PATHUNITS_USERSPACE = 1;
	const PATHUNITS_USERSPACEONUSE = 2;
	const PATHUNITS_OBJECTBOUNDINGBOX = 3;
	const LINECAP_UNDEFINED = 0;
	const LINECAP_BUTT = 1;
	const LINECAP_ROUND = 2;
	const LINECAP_SQUARE = 3;
	const LINEJOIN_UNDEFINED = 0;
	const LINEJOIN_MITER = 1;
	const LINEJOIN_ROUND = 2;
	const LINEJOIN_BEVEL = 3;
	const RESOURCETYPE_UNDEFINED = 0;
	const RESOURCETYPE_AREA = 1;
	const RESOURCETYPE_DISK = 2;
	const RESOURCETYPE_FILE = 3;
	const RESOURCETYPE_MAP = 4;
	const RESOURCETYPE_MEMORY = 5;
	const DISPOSE_UNRECOGNIZED = 0;
	const DISPOSE_UNDEFINED = 0;
	const DISPOSE_NONE = 1;
	const DISPOSE_BACKGROUND = 2;
	const DISPOSE_PREVIOUS = 3;
	const INTERPOLATE_UNDEFINED = 0;
	const INTERPOLATE_AVERAGE = 1;
	const INTERPOLATE_BICUBIC = 2;
	const INTERPOLATE_BILINEAR = 3;
	const INTERPOLATE_FILTER = 4;
	const INTERPOLATE_INTEGER = 5;
	const INTERPOLATE_MESH = 6;
	const INTERPOLATE_NEARESTNEIGHBOR = 7;
	const INTERPOLATE_SPLINE = 8;
	const LAYERMETHOD_UNDEFINED = 0;
	const LAYERMETHOD_COALESCE = 1;
	const LAYERMETHOD_COMPAREANY = 2;
	const LAYERMETHOD_COMPARECLEAR = 3;
	const LAYERMETHOD_COMPAREOVERLAY = 4;
	const LAYERMETHOD_DISPOSE = 5;
	const LAYERMETHOD_OPTIMIZE = 6;
	const LAYERMETHOD_OPTIMIZEPLUS = 8;
	const LAYERMETHOD_OPTIMIZETRANS = 9;
	const LAYERMETHOD_COMPOSITE = 12;
	const LAYERMETHOD_OPTIMIZEIMAGE = 7;
	const LAYERMETHOD_REMOVEDUPS = 10;
	const LAYERMETHOD_REMOVEZERO = 11;
	const ORIENTATION_UNDEFINED = 0;
	const ORIENTATION_TOPLEFT = 1;
	const ORIENTATION_TOPRIGHT = 2;
	const ORIENTATION_BOTTOMRIGHT = 3;
	const ORIENTATION_BOTTOMLEFT = 4;
	const ORIENTATION_LEFTTOP = 5;
	const ORIENTATION_RIGHTTOP = 6;
	const ORIENTATION_RIGHTBOTTOM = 7;
	const ORIENTATION_LEFTBOTTOM = 8;
	const DISTORTION_UNDEFINED = 0;
	const DISTORTION_AFFINE = 1;
	const DISTORTION_AFFINEPROJECTION = 2;
	const DISTORTION_ARC = 9;
	const DISTORTION_BILINEAR = 6;
	const DISTORTION_PERSPECTIVE = 4;
	const DISTORTION_PERSPECTIVEPROJECTION = 5;
	const DISTORTION_SCALEROTATETRANSLATE = 3;
	const DISTORTION_POLYNOMIAL = 8;
	const DISTORTION_POLAR = 10;
	const DISTORTION_DEPOLAR = 11;
	const DISTORTION_BARREL = 14;
	const DISTORTION_BARRELINVERSE = 15;
	const DISTORTION_SHEPARDS = 16;
	const DISTORTION_SENTINEL = 18;
	const LAYERMETHOD_MERGE = 13;
	const LAYERMETHOD_FLATTEN = 14;
	const LAYERMETHOD_MOSAIC = 15;
	const ALPHACHANNEL_ACTIVATE = 1;
	const ALPHACHANNEL_DEACTIVATE = 4;
	const ALPHACHANNEL_RESET = 7;
	const ALPHACHANNEL_SET = 8;
	const ALPHACHANNEL_UNDEFINED = 0;
	const ALPHACHANNEL_COPY = 3;
	const ALPHACHANNEL_EXTRACT = 5;
	const ALPHACHANNEL_OPAQUE = 6;
	const ALPHACHANNEL_SHAPE = 9;
	const ALPHACHANNEL_TRANSPARENT = 10;
	const SPARSECOLORMETHOD_UNDEFINED = 0;
	const SPARSECOLORMETHOD_BARYCENTRIC = 1;
	const SPARSECOLORMETHOD_BILINEAR = 7;
	const SPARSECOLORMETHOD_POLYNOMIAL = 8;
	const SPARSECOLORMETHOD_SPEPARDS = 16;
	const SPARSECOLORMETHOD_VORONOI = 18;
	const DITHERMETHOD_UNDEFINED = 0;
	const DITHERMETHOD_NO = 1;
	const DITHERMETHOD_RIEMERSMA = 2;
	const DITHERMETHOD_FLOYDSTEINBERG = 3;
	const FUNCTION_UNDEFINED = 0;
	const FUNCTION_POLYNOMIAL = 1;
	const FUNCTION_SINUSOID = 2;


	/**
	 * 画像の繰り返し部分を削除して最適化する
	 * @link http://www.php.net/manual/ja/imagick.optimizeimagelayers.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function optimizeimagelayers () {}

	/**
	 * 複数の画像の中で最大の境界範囲を返す
	 * @link http://www.php.net/manual/ja/imagick.compareimagelayers.php
	 * @param method int <p>
	 * レイヤメソッド定数 のいずれか。
	 * </p>
	 * @return Imagick 成功した場合に TRUE を返します。
	 */
	public function compareimagelayers ($method) {}

	/**
	 * 手早く属性を取得する
	 * @link http://www.php.net/manual/ja/imagick.pingimageblob.php
	 * @param image string <p>
	 * 画像を含む文字列。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function pingimageblob ($image) {}

	/**
	 * 画像の基本属性を手軽に取得する
	 * @link http://www.php.net/manual/ja/imagick.pingimagefile.php
	 * @param filehandle resource <p>
	 * 開いている画像のファイルハンドル。
	 * </p>
	 * @param fileName string[optional] <p>
	 * オプションで指定する、この画像のファイル名。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function pingimagefile ($filehandle, $fileName = null) {}

	/**
	 * 垂直方向に反転させた画像を作成する
	 * @link http://www.php.net/manual/ja/imagick.transposeimage.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function transposeimage () {}

	/**
	 * 水平方向に反転させた画像を作成する
	 * @link http://www.php.net/manual/ja/imagick.transverseimage.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function transverseimage () {}

	/**
	 * 画像の輪郭を削除する
	 * @link http://www.php.net/manual/ja/imagick.trimimage.php
	 * @param fuzz float <p>
	 * デフォルトでは、対象の色は特定のピクセルの色とまったく同じでなければなりません。
	 * しかし、ふたつの色が微妙に異なることもよくあります。
	 * 画像の fuzz メンバは、どの程度の色を「同じ色」とみなすかを表します。
	 * このパラメータは、量の範囲の変化を表します。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function trimimage ($fuzz) {}

	/**
	 * ウェーブフィルタを画像に適用する
	 * @link http://www.php.net/manual/ja/imagick.waveimage.php
	 * @param amplitude float <p>
	 * 波の振幅。
	 * </p>
	 * @param length float <p>
	 * 波長。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function waveimage ($amplitude, $length) {}

	/**
	 * ビネットフィルタを画像に追加する
	 * @link http://www.php.net/manual/ja/imagick.vignetteimage.php
	 * @param blackPoint float <p>
	 * 黒の点。
	 * </p>
	 * @param whitePoint float <p>
	 * 白の点。
	 * </p>
	 * @param x int <p>
	 * 楕円の X オフセット。
	 * </p>
	 * @param y int <p>
	 * 楕円の Y オフセット。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function vignetteimage ($blackPoint, $whitePoint, $x, $y) {}

	/**
	 * ある 1 色以外のすべての色のピクセルを削除する
	 * @link http://www.php.net/manual/ja/imagick.uniqueimagecolors.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function uniqueimagecolors () {}

	/**
	 * 画像がマットチャネルを持っているかどうかを返す
	 * @link http://www.php.net/manual/ja/imagick.getimagematte.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function getimagematte () {}

	/**
	 * 画像のマットチャネルを設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagematte.php
	 * @param matte bool <p>
	 * True にするとマットチャネルを有効にし、false の場合は無効にします。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagematte ($matte) {}

	/**
	 * データに依存する三角測量にもとづいて画像のサイズを変更する
	 * @link http://www.php.net/manual/ja/imagick.adaptiveresizeimage.php
	 * @param columns int <p>
	 * 変更後の画像のカラム数。
	 * </p>
	 * @param rows int <p>
	 * 変更後の画像の行数。
	 * </p>
	 * @param bestfit bool[optional] <p>
	 * 画像の大きさをバウンディングボックスにあわせるかどうか。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function adaptiveresizeimage ($columns, $rows, $bestfit = null) {}

	/**
	 * 鉛筆画をシミュレートする
	 * @link http://www.php.net/manual/ja/imagick.sketchimage.php
	 * @param radius float <p>
	 * ガウス変換の半径 (ピクセル単位で中心のピクセルは数えない)。
	 * </p>
	 * @param sigma float <p>
	 * ガウス変換の標準偏差 (ピクセル単位)。
	 * </p>
	 * @param angle float <p>
	 * この角度で効果を適用します。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function sketchimage ($radius, $sigma, $angle) {}

	/**
	 * 3D 効果を作成する
	 * @link http://www.php.net/manual/ja/imagick.shadeimage.php
	 * @param gray bool <p>
	 * ゼロ以外の値で、各ピクセルに影をつけます。
	 * </p>
	 * @param azimuth float <p>
	 * 光源の方向を定義します。
	 * </p>
	 * @param elevation float <p>
	 * 光源の方向を定義します。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function shadeimage ($gray, $azimuth, $elevation) {}

	/**
	 * サイズのオフセットを返す
	 * @link http://www.php.net/manual/ja/imagick.getsizeoffset.php
	 * @return int Imagick オブジェクトのサイズのオフセットを返します。
	 */
	public function getsizeoffset () {}

	/**
	 * Imagick オブジェクトのサイズのオフセットを設定する
	 * @link http://www.php.net/manual/ja/imagick.setsizeoffset.php
	 * @param columns int <p>
	 * 幅 (ピクセル単位)。
	 * </p>
	 * @param rows int <p>
	 * 高さ (ピクセル単位)。
	 * </p>
	 * @param offset int <p>
	 * 画像のオフセット。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setsizeoffset ($columns, $rows, $offset) {}

	/**
	 * adaptive blur (順応性にじみ) フィルタを画像に追加する
	 * @link http://www.php.net/manual/ja/imagick.adaptiveblurimage.php
	 * @param radius float <p>
	 * ガウス分布の半径。中心を含まないピクセル数。
	 * 0 を指定すると、半径を自動的に選択します。
	 * </p>
	 * @param sigma float <p>
	 * ガウス分布の標準偏差 (ピクセル単位)。
	 * </p>
	 * @param channel int[optional] <p>
	 * そのモードで有効なチャネル定数を指定します。
	 * 複数のチャネルを適用するには、チャネル定数
	 * をビット演算子で組み合わせます。デフォルトは Imagick::CHANNEL_DEFAULT です。
	 * チャネル定数 の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function adaptiveblurimage ($radius, $sigma, $channel = null) {}

	/**
	 * カラー画像のコントラストを強調する
	 * @link http://www.php.net/manual/ja/imagick.contraststretchimage.php
	 * @param black_point float <p>
	 * 黒の点。
	 * </p>
	 * @param white_point float <p>
	 * 白の点。
	 * </p>
	 * @param channel int[optional] <p>
	 * チャネルモードに対応したチャネル定数を指定します。
	 * 複数のチャネルに適用するには、
	 * ビット演算子でチャネル型定数を組み合わせます。
	 * デフォルトは Imagick::CHANNEL_ALL です。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function contraststretchimage ($black_point, $white_point, $channel = null) {}

	/**
	 * 順応して画像をシャープにする
	 * @link http://www.php.net/manual/ja/imagick.adaptivesharpenimage.php
	 * @param radius float <p>
	 * ガウス分布の半径。中心を含まないピクセル数。
	 * 0 を使用すると自動的に選択します。
	 * </p>
	 * @param sigma float <p>
	 * ガウス分布の標準偏差 (ピクセル単位)。
	 * </p>
	 * @param channel int[optional] <p>
	 * そのモードで有効なチャネル定数を指定します。
	 * 複数のチャネルを適用するには、チャネル定数
	 * をビット演算子で組み合わせます。デフォルトは Imagick::CHANNEL_DEFAULT です。
	 * チャネル定数 の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function adaptivesharpenimage ($radius, $sigma, $channel = null) {}

	/**
	 * コントラストの高い 2 色の画像を作成する
	 * @link http://www.php.net/manual/ja/imagick.randomthresholdimage.php
	 * @param low float <p>
	 * 低い点。
	 * </p>
	 * @param high float <p>
	 * 高い点。
	 * </p>
	 * @param channel int[optional] <p>
	 * そのモードに対応した任意のチャネル定数を指定します。
	 * 複数のチャネルを適用するには、チャネル定数をビット演算子で連結します。
	 * この チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function randomthresholdimage ($low, $high, $channel = null) {}

	/**
	 * @param xRounding
	 * @param yRounding
	 * @param strokeWidth[optional]
	 * @param displace[optional]
	 * @param sizeCorrection[optional]
	 */
	public function roundcornersimage ($xRounding, $yRounding, $strokeWidth, $displace, $sizeCorrection) {}

	/**
	 * 画像の角を丸める
	 * @link http://www.php.net/manual/ja/imagick.roundcorners.php
	 * @param x_rounding float <p>
	 * x 方向の丸め。
	 * </p>
	 * @param y_rounding float <p>
	 * y 方向の丸め。
	 * </p>
	 * @param stroke_width float[optional] <p>
	 * 線幅。
	 * </p>
	 * @param displace float[optional] <p>
	 * image displace
	 * </p>
	 * @param size_correction float[optional] <p>
	 * サイズ補正。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function roundcorners ($x_rounding, $y_rounding, $stroke_width = null, $displace = null, $size_correction = null) {}

	/**
	 * イテレータの位置を設定する
	 * @link http://www.php.net/manual/ja/imagick.setiteratorindex.php
	 * @param index int <p>
	 * イテレータを設定する場所。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setiteratorindex ($index) {}

	/**
	 * 現在アクティブな画像のインデックスを取得する
	 * @link http://www.php.net/manual/ja/imagick.getiteratorindex.php
	 * @return int スタック内の画像のインデックスを含む整数値を返します。
	 */
	public function getiteratorindex () {}

	/**
	 * 切り取るサイズと画像のジオメトリを設定する便利なメソッド
	 * @link http://www.php.net/manual/ja/imagick.transformimage.php
	 * @param crop string <p>
	 * 切り取りジオメトリ文字列。
	 * このジオメトリで画像の一部の範囲を指定し、その部分を切り取ります。
	 * </p>
	 * @param geometry string <p>
	 * 画像ジオメトリ文字列。このジオメトリで最終的な画像のサイズを指定します。
	 * </p>
	 * @return Imagick 成功した場合に TRUE を返します。
	 */
	public function transformimage ($crop, $geometry) {}

	/**
	 * 画像の不透明度を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageopacity.php
	 * @param opacity float <p>
	 * 透明度。1.0 が完全な不透明で、0.0 が完全な透明です。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageopacity ($opacity) {}

	/**
	 * 配列ディザリングを行う
	 * @link http://www.php.net/manual/ja/imagick.orderedposterizeimage.php
	 * @param threshold_map string <p>
	 * 使用するディザリング閾値マップを含む文字列。
	 * </p>
	 * @param channel int[optional] <p>
	 * チャネルモードに応じたチャネル定数を指定します。
	 * 複数のチャネルに適用するには、定数をビット演算子で組み合わせます。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function orderedposterizeimage ($threshold_map, $channel = null) {}

	/**
	 * ポラロイド写真をシミュレートする
	 * @link http://www.php.net/manual/ja/imagick.polaroidimage.php
	 * @param properties ImagickDraw <p>
	 * ポラロイドプロパティ。
	 * </p>
	 * @param angle float <p>
	 * ポラロイド角度。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function polaroidimage (ImagickDraw $properties, $angle) {}

	/**
	 * 指定した名前の画像のプロパティを返す
	 * @link http://www.php.net/manual/ja/imagick.getimageproperty.php
	 * @param name string <p>
	 * プロパティの名前 (たとえば Exif:DateTime)。
	 * </p>
	 * @return string 画像のプロパティを含む文字列を返します。
	 * 指定した名前のプロパティが存在しない場合に false を返します。
	 */
	public function getimageproperty ($name) {}

	/**
	 * 画像のプロパティを設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageproperty.php
	 * @param name string <p>
	 * </p>
	 * @param value string <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageproperty ($name, $value) {}

	/**
	 * 画像のピクセル補間方式を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageinterpolatemethod.php
	 * @param method int <p>
	 * Imagick::INTERPOLATE_* 定数のいずれか。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageinterpolatemethod ($method) {}

	/**
	 * 画像の補間方式を返す
	 * @link http://www.php.net/manual/ja/imagick.getimageinterpolatemethod.php
	 * @return int 成功した場合に補間方式を返します。
	 */
	public function getimageinterpolatemethod () {}

	/**
	 * 画像の輝度を引き伸ばして飽和させる
	 * @link http://www.php.net/manual/ja/imagick.linearstretchimage.php
	 * @param blackPoint float <p>
	 * 画像の黒の点。
	 * </p>
	 * @param whitePoint float <p>
	 * 画像の白の点。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function linearstretchimage ($blackPoint, $whitePoint) {}

	/**
	 * 画像の長さをバイト数で取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagelength.php
	 * @return int 現在の画像のサイズを整数値で返します。
	 */
	public function getimagelength () {}

	/**
	 * 画像のサイズを設定する
	 * @link http://www.php.net/manual/ja/imagick.extentimage.php
	 * @param width int <p>
	 * 新しい幅。
	 * </p>
	 * @param height int <p>
	 * 新しい高さ。
	 * </p>
	 * @param x int <p>
	 * 新しいサイズの X 座標。
	 * </p>
	 * @param y int <p>
	 * 新しいサイズの Y 座標。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function extentimage ($width, $height, $x, $y) {}

	/**
	 * 画像の方向を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimageorientation.php
	 * @return int 成功した場合に整数値を返します。
	 */
	public function getimageorientation () {}

	/**
	 * 画像の方向を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageorientation.php
	 * @param orientation int <p>
	 * 方向定数 のいずれか。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageorientation ($orientation) {}

	/**
	 * 色にマッチするピクセルを変更する
	 * @link http://www.php.net/manual/ja/imagick.paintfloodfillimage.php
	 * @param fill mixed <p>
	 * 塗りつぶし色を表す ImagickPixel オブジェクトあるいは文字列。
	 * </p>
	 * @param fuzz float <p>
	 * fuzz の量。たとえば fuzz を 10 にすると、
	 * 強度 100 の赤と 102 の赤は同じ色とみなします。
	 * </p>
	 * @param bordercolor mixed <p>
	 * 境界色を表す ImagickPixel オブジェクトあるいは文字列。
	 * </p>
	 * @param x int <p>
	 * floodfill の開始位置の X 座標。
	 * </p>
	 * @param y int <p>
	 * floodfill の開始位置の Y 座標。
	 * </p>
	 * @param channel int[optional] <p>
	 * そのモードで有効なチャネル定数を指定します。
	 * 複数のチャネルを適用するには、チャネル定数
	 * をビット演算子で組み合わせます。デフォルトは Imagick::CHANNEL_DEFAULT です。
	 * チャネル定数 の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function paintfloodfillimage ($fill, $fuzz, $bordercolor, $x, $y, $channel = null) {}

	/**
	 * 画像の色を置き換える
	 * @link http://www.php.net/manual/ja/imagick.clutimage.php
	 * @param lookup_table Imagick <p>
	 * 色ルックアップテーブルを含む Imagick オブジェクト。
	 * </p>
	 * @param channel float[optional] <p>
	 * チャネルタイプ 定数。
	 * 省略した場合はデフォルトチャネルが対象となります。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function clutimage (Imagick $lookup_table, $channel = null) {}

	/**
	 * 画像のプロパティを返す
	 * @link http://www.php.net/manual/ja/imagick.getimageproperties.php
	 * @param pattern string[optional] <p>
	 * プロパティ名のパターン。
	 * </p>
	 * @param only_names bool[optional] <p>
	 * プロパティ名のみを返すかどうか。FALSE の場合は値も返します。
	 * </p>
	 * @return array 画像のプロパティあるいはプロパティ名を含む連想配列を返します。
	 */
	public function getimageproperties ($pattern = null, $only_names = null) {}

	/**
	 * 画像プロファイルを返す
	 * @link http://www.php.net/manual/ja/imagick.getimageprofiles.php
	 * @param pattern string[optional] <p>
	 * プロファイル名のパターン。
	 * </p>
	 * @param only_names bool[optional] <p>
	 * プロファイル名のみを返すかどうか。FALSE の場合は値も返します。
	 * </p>
	 * @return array 画像のプロファイルあるいはプロファイル名を含む連想配列を返します。
	 */
	public function getimageprofiles ($pattern = null, $only_names = null) {}

	/**
	 * さまざまな方式で画像を歪める
	 * @link http://www.php.net/manual/ja/imagick.distortimage.php
	 * @param method int <p>
	 * 画像の歪め方式。
	 * 歪め定数
	 * を参照ください。
	 * </p>
	 * @param arguments array <p>
	 * 歪め方式の引数。
	 * </p>
	 * @param bestfit bool <p>
	 * 元画像のサイズを変更する。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function distortimage ($method, array $arguments, $bestfit) {}

	/**
	 * 画像をファイルハンドルに書き出す
	 * @link http://www.php.net/manual/ja/imagick.writeimagefile.php
	 * @param filehandle resource <p>
	 * 画像を書き出すファイルハンドル。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function writeimagefile ($filehandle) {}

	/**
	 * フレームをファイルハンドルに書き出す
	 * @link http://www.php.net/manual/ja/imagick.writeimagesfile.php
	 * @param filehandle resource <p>
	 * 画像を書き出すファイルハンドル。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function writeimagesfile ($filehandle) {}

	/**
	 * 画像のページをリセットする
	 * @link http://www.php.net/manual/ja/imagick.resetimagepage.php
	 * @param page string <p>
	 * ページ定義。たとえば 7168x5147+0+0 のようになります。 
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function resetimagepage ($page) {}

	/**
	 * 画像のクリップマスクを設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageclipmask.php
	 * @param clip_mask Imagick <p>
	 * クリップマスクを含む Imagick オブジェクト。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageclipmask (Imagick $clip_mask) {}

	/**
	 * 画像のクリップマスクを取得する
	 * @link http://www.php.net/manual/ja/imagick.getimageclipmask.php
	 * @return Imagick 画像のクリップマスクを含む Imagick オブジェクトを返します。
	 */
	public function getimageclipmask () {}

	/**
	 * 画像を動かす
	 * @link http://www.php.net/manual/ja/imagick.animateimages.php
	 * @param x_server string <p>
	 * X サーバーのアドレス。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function animateimages ($x_server) {}

	/**
	 * 画像の色を変更する
	 * @link http://www.php.net/manual/ja/imagick.recolorimage.php
	 * @param matrix array <p>
	 * 色の値を含む行列。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function recolorimage (array $matrix) {}

	/**
	 * フォントを設定する
	 * @link http://www.php.net/manual/ja/imagick.setfont.php
	 * @param font string <p>
	 * フォント名あるいはファイル名。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setfont ($font) {}

	/**
	 * フォントを取得する
	 * @link http://www.php.net/manual/ja/imagick.getfont.php
	 * @return string フォント名を表す文字列を返します。フォントが設定されていない場合は FALSE を返します。
	 */
	public function getfont () {}

	/**
	 * ポイントサイズを設定する
	 * @link http://www.php.net/manual/ja/imagick.setpointsize.php
	 * @param point_size float <p>
	 * ポイントサイズ。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setpointsize ($point_size) {}

	/**
	 * ポイントサイズを取得する
	 * @link http://www.php.net/manual/ja/imagick.getpointsize.php
	 * @return float ポイントサイズを表す float 型の値を返します。
	 */
	public function getpointsize () {}

	/**
	 * 画像のレイヤーをマージする
	 * @link http://www.php.net/manual/ja/imagick.mergeimagelayers.php
	 * @param layer_method int <p>
	 * Imagick::LAYERMETHOD_* 定数のいずれか。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function mergeimagelayers ($layer_method) {}

	/**
	 * 画像のアルファチャネルを設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagealphachannel.php
	 * @param mode int <p>
	 * Imagick::ALPHACHANNEL_* 定数のいずれか。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagealphachannel ($mode) {}

	/**
	 * 対象にマッチする任意のピクセルの値を変更する
	 * @link http://www.php.net/manual/ja/imagick.floodfillpaintimage.php
	 * @param fill mixed <p>
	 * 塗りつぶし色を表す ImagickPixel オブジェクトあるいは文字列。
	 * </p>
	 * @param fuzz float <p>
	 * あいまいさをあらわす量。たとえば、これを 10 に設定すると、
	 * 赤色の値が 100 の色と 102 の色は同じものとみなされます。
	 * </p>
	 * @param target mixed <p>
	 * 対象の色を表す ImagickPixel オブジェクトあるいは文字列。
	 * </p>
	 * @param x int <p>
	 * 開始位置の X 座標。
	 * </p>
	 * @param y int <p>
	 * 開始位置の Y 座標。
	 * </p>
	 * @param invert bool <p>
	 * TRUE の場合は、対象の色にマッチしない任意のピクセルをペイントします。
	 * </p>
	 * @param channel int[optional] <p>
	 * そのモードで有効なチャネル定数を指定します。
	 * 複数のチャネルを適用するには、チャネル定数
	 * をビット演算子で組み合わせます。デフォルトは Imagick::CHANNEL_DEFAULT です。
	 * チャネル定数 の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function floodfillpaintimage ($fill, $fuzz, $target, $x, $y, $invert, $channel = null) {}

	/**
	 * 対象にマッチする任意のピクセルの色を変更する
	 * @link http://www.php.net/manual/ja/imagick.opaquepaintimage.php
	 * @param target mixed <p>
	 * 変更したい色をあらわす ImagickPixel オブジェクトあるいは文字列。
	 * </p>
	 * @param fill mixed <p>
	 * 置き換える色。
	 * </p>
	 * @param fuzz float <p>
	 * あいまいさをあらわす量。たとえば、これを 10 に設定すると、
	 * 赤色の値が 100 の色と 102 の色は同じものとみなされます。
	 * </p>
	 * @param invert bool <p>
	 * TRUE の場合は、対象の色にマッチしないピクセルを変更します。
	 * </p>
	 * @param channel int[optional] <p>
	 * そのモードで有効なチャネル定数を指定します。
	 * 複数のチャネルを適用するには、チャネル定数
	 * をビット演算子で組み合わせます。デフォルトは Imagick::CHANNEL_DEFAULT です。
	 * チャネル定数 の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function opaquepaintimage ($target, $fill, $fuzz, $invert, $channel = null) {}

	/**
	 * ピクセルを透過させる
	 * @link http://www.php.net/manual/ja/imagick.transparentpaintimage.php
	 * @param target mixed <p>
	 * 対象となる色。
	 * </p>
	 * @param alpha float <p>
	 * 透明度。1.0 は完全な不透明で 0.0 が完全な透明をあらわします。
	 * </p>
	 * @param fuzz float <p>
	 * あいまいさをあらわす量。たとえば、これを 10 に設定すると、
	 * 赤色の値が 100 の色と 102 の色は同じものとみなされます。
	 * </p>
	 * @param invert bool <p>
	 * TRUE の場合は、対象の色にマッチしないピクセルを変更します。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function transparentpaintimage ($target, $alpha, $fuzz, $invert) {}

	/**
	 * 画像を動かす
	 * @link http://www.php.net/manual/ja/imagick.liquidrescaleimage.php
	 * @param width int <p>
	 * 変更後のサイズの幅。
	 * </p>
	 * @param height int <p>
	 * 変更後のサイズの高さ。
	 * </p>
	 * @param delta_x float <p>
	 * seam が x 軸をどれだけ横切るか。
	 * 0 を渡すと seam が直線になります。
	 * </p>
	 * @param rigidity float <p>
	 * 直線でない seam のバイアスを導入します。このパラメータは通常は 0 です。 
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function liquidrescaleimage ($width, $height, $delta_x, $rigidity) {}

	/**
	 * 画像を暗号化する
	 * @link http://www.php.net/manual/ja/imagick.encipherimage.php
	 * @param passphrase string <p>
	 * パスフレーズ。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function encipherimage ($passphrase) {}

	/**
	 * 画像を復号する
	 * @link http://www.php.net/manual/ja/imagick.decipherimage.php
	 * @param passphrase string <p>
	 * パスフレーズ。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function decipherimage ($passphrase) {}

	/**
	 * gravity を設定する
	 * @link http://www.php.net/manual/ja/imagick.setgravity.php
	 * @param gravity int <p>
	 * gravity プロパティ。
	 * gravity 定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setgravity ($gravity) {}

	/**
	 * gravity を取得する
	 * @link http://www.php.net/manual/ja/imagick.getgravity.php
	 * @return int gravity プロパティを返します。
	 * gravity 定数
	 * の一覧を参照ください。
	 */
	public function getgravity () {}

	/**
	 * チャネルの範囲を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagechannelrange.php
	 * @param channel int <p>
	 * そのモードで有効なチャネル定数を指定します。
	 * 複数のチャネルを適用するには、チャネル定数
	 * をビット演算子で組み合わせます。デフォルトは Imagick::CHANNEL_DEFAULT です。
	 * チャネル定数 の一覧を参照ください。
	 * </p>
	 * @return array チャネルの minima および maxima の値を含む配列を返します。
	 */
	public function getimagechannelrange ($channel) {}

	/**
	 * 画像のアルファチャネルを取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagealphachannel.php
	 * @return int 現在のアルファチャネル値を表す定数を返します。
	 * アルファチャネル定数
	 * の一覧を参照ください。
	 */
	public function getimagealphachannel () {}

	/**
	 * チャネルの歪みを取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagechanneldistortions.php
	 * @param reference Imagick <p>
	 * 比較する画像を含む Imagick オブジェクト。
	 * </p>
	 * @param metric int <p>
	 * メトリック型定数
	 * の一覧を参照ください。
	 * </p>
	 * @param channel int[optional] <p>
	 * そのモードで有効なチャネル定数を指定します。
	 * 複数のチャネルを適用するには、チャネル定数
	 * をビット演算子で組み合わせます。デフォルトは Imagick::CHANNEL_DEFAULT です。
	 * チャネル定数 の一覧を参照ください。
	 * </p>
	 * @return float チャネルの歪みを表す double 型の値を返します。
	 */
	public function getimagechanneldistortions (Imagick $reference, $metric, $channel = null) {}

	/**
	 * 画像の gravity を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagegravity.php
	 * @param gravity int <p>
	 * gravity プロパティ。
	 * gravity 定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setimagegravity ($gravity) {}

	/**
	 * 画像の gravity を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagegravity.php
	 * @return int 画像の property プロパティを返します。
	 * gravity 定数
	 * の一覧を参照ください。
	 */
	public function getimagegravity () {}

	/**
	 * 画像のピクセルをインポートする
	 * @link http://www.php.net/manual/ja/imagick.importimagepixels.php
	 * @param x int <p>
	 * 画像の x 位置。
	 * </p>
	 * @param y int <p>
	 * 画像の y 位置。
	 * </p>
	 * @param width int <p>
	 * 画像の幅。
	 * </p>
	 * @param height int <p>
	 * 画像の高さ。
	 * </p>
	 * @param map string <p>
	 * ピクセルの並び順を表す文字列。たとえば RGB のようになります。以下の文字を任意の順で組み合わせることができます。
	 * R = red, G = green, B = blue, A = alpha (0 is transparent), 
	 * O = opacity (0 is opaque), C = cyan, Y = yellow, M = magenta, K = black, I = intensity (for grayscale), P = pad.
	 * </p>
	 * @param storage int <p>
	 * ピクセルの格納方式。
	 * pixel 定数 の一覧を参照ください。
	 * </p>
	 * @param pixels array <p>
	 * ピクセルの配列。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function importimagepixels ($x, $y, $width, $height, $map, $storage, array $pixels) {}

	/**
	 * 傾きを除去する
	 * @link http://www.php.net/manual/ja/imagick.deskewimage.php
	 * @param threshold float <p>
	 * 傾き除去の閾値。
	 * </p>
	 * @return bool 
	 */
	public function deskewimage ($threshold) {}

	/**
	 * 画像を分割する
	 * @link http://www.php.net/manual/ja/imagick.segmentimage.php
	 * @param COLORSPACE int <p>
	 * COLORSPACE 定数 のいずれか。
	 * </p>
	 * @param cluster_threshold float <p>
	 * 有効と見なされるために必要な、
	 * hexedra 内の最小ピクセル数を表すパーセンテージ。
	 * </p>
	 * @param smooth_threshold float <p>
	 * ヒストグラムからノイズを除去する。
	 * </p>
	 * @param verbose bool[optional] <p>
	 * 識別した区分についての詳細情報を出力するか否か。
	 * </p>
	 * @return bool 
	 */
	public function segmentimage ($COLORSPACE, $cluster_threshold, $smooth_threshold, $verbose = null) {}

	/**
	 * 色を補間する
	 * @link http://www.php.net/manual/ja/imagick.sparsecolorimage.php
	 * @param SPARSE_METHOD int <p>
	 * sparse method 定数 の一覧を参照ください。
	 * </p>
	 * @param arguments array <p>
	 * 座標を含む配列。配列の書式は array(1,1, 2,45)
	 * のようになります。
	 * </p>
	 * @param channel int[optional] 
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function sparsecolorimage ($SPARSE_METHOD, array $arguments, $channel = null) {}

	/**
	 * 画像の色を再配置する
	 * @link http://www.php.net/manual/ja/imagick.remapimage.php
	 * @param replacement Imagick <p>
	 * 置き換える色を含む Imagick オブジェクト。
	 * </p>
	 * @param DITHER int <p>
	 * ディザメソッド定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function remapimage (Imagick $replacement, $DITHER) {}

	/**
	 * 画像の生のピクセルをエクスポートする
	 * @link http://www.php.net/manual/ja/imagick.exportimagepixels.php
	 * @param x int <p>
	 * エクスポートする範囲の X 座標。
	 * </p>
	 * @param y int <p>
	 * エクスポートする範囲の Y 座標。
	 * </p>
	 * @param width int <p>
	 * エクスポートする範囲の幅。
	 * </p>
	 * @param height int <p>
	 * エクスポートする範囲の高さ。
	 * </p>
	 * @param map string <p>
	 * エクスポートするピクセルの順序。"RGB" など。
	 * map で使える文字は R, G, B, A, O, C, Y, M, K, I および P です。
	 * </p>
	 * @param STORAGE int <p>
	 * ピクセル型定数 を参照ください。
	 * </p>
	 * @return array ピクセルの値を含む配列を返します。
	 */
	public function exportimagepixels ($x, $y, $width, $height, $map, $STORAGE) {}

	/**
	 * getImageChannelKurtosis
	 * @link http://www.php.net/manual/ja/imagick.getimagechannelkurtosis.php
	 * @param channel int[optional] <p>
	 * そのモードで有効なチャネル定数を指定します。
	 * 複数のチャネルを適用するには、チャネル定数
	 * をビット演算子で組み合わせます。デフォルトは Imagick::CHANNEL_DEFAULT です。
	 * チャネル定数 の一覧を参照ください。
	 * </p>
	 * @return array kurtosis と skewness
	 * を要素に持つ配列を返します。
	 */
	public function getimagechannelkurtosis ($channel = null) {}

	/**
	 * 画像に関数を適用する
	 * @link http://www.php.net/manual/ja/imagick.functionimage.php
	 * @param function int <p>
	 * 関数定数 の一覧を参照ください。
	 * </p>
	 * @param arguments array <p>
	 * この関数に渡す引数の配列。
	 * </p>
	 * @param channel int[optional] 
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function functionimage ($function, array $arguments, $channel = null) {}

	/**
	 * @param COLORSPACE
	 */
	public function transformimagecolorspace ($COLORSPACE) {}

	/**
	 * 画像内の色を置換する
	 * @link http://www.php.net/manual/ja/imagick.haldclutimage.php
	 * @param clut Imagick <p>
	 * Hald ルックアップ画像を含む Imagick オブジェクト。
	 * </p>
	 * @param channel int[optional] <p>
	 * そのモードで有効なチャネル定数を指定します。
	 * 複数のチャネルを適用するには、チャネル定数
	 * をビット演算子で組み合わせます。デフォルトは Imagick::CHANNEL_DEFAULT です。
	 * チャネル定数 の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function haldclutimage (Imagick $clut, $channel = null) {}

	/**
	 * 画像のアーチファクトを取得する
	 * @link http://www.php.net/manual/ja/imagick.getimageartifact.php
	 * @param artifact string <p>
	 * アーチファクトの名前。
	 * </p>
	 * @return string 成功した場合にアーチファクトの値を返します。
	 */
	public function getimageartifact ($artifact) {}

	/**
	 * 画像のアーチファクトを設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageartifact.php
	 * @param artifact string <p>
	 * アーチファクトの名前。
	 * </p>
	 * @param value string <p>
	 * アーチファクトの値。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageartifact ($artifact, $value) {}

	/**
	 * 画像のアーチファクトを削除する
	 * @link http://www.php.net/manual/ja/imagick.deleteimageartifact.php
	 * @param artifact string <p>
	 * アーチファクトの名前。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function deleteimageartifact ($artifact) {}

	/**
	 * 色空間を取得する
	 * @link http://www.php.net/manual/ja/imagick.getcolorspace.php
	 * @return int 整数値を返します。この値を
	 * COLORSPACE 定数 と比較することができます。
	 */
	public function getcolorspace () {}

	/**
	 * 色空間を設定する
	 * @link http://www.php.net/manual/ja/imagick.setcolorspace.php
	 * @param COLORSPACE int <p>
	 * COLORSPACE 定数
	 * のひとつ。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setcolorspace ($COLORSPACE) {}

	/**
	 * Imagick のコンストラクタ
	 * @link http://www.php.net/manual/ja/imagick.construct.php
	 * @param files[optional]
	 */
	public function __construct ($files) {}

	public function __tostring () {}

	/**
	 * MagickPixelIterator を返す
	 * @link http://www.php.net/manual/ja/imagick.getpixeliterator.php
	 * @return ImagickPixelIterator 成功した場合に ImagickPixelIterator を返します。
	 */
	public function getpixeliterator () {}

	/**
	 * 画像セクションの ImagickPixelIterator を取得する
	 * @link http://www.php.net/manual/ja/imagick.getpixelregioniterator.php
	 * @param x int <p>
	 * 範囲の x 座標。
	 * </p>
	 * @param y int <p>
	 * 範囲の y 座標。
	 * </p>
	 * @param columns int <p>
	 * 範囲の幅。
	 * </p>
	 * @param rows int <p>
	 * 範囲の高さ。
	 * </p>
	 * @return ImagickPixelIterator 画像セクションの ImagickPixelIterator を返します。
	 */
	public function getpixelregioniterator ($x, $y, $columns, $rows) {}

	/**
	 * ファイルから画像を読み込む
	 * @link http://www.php.net/manual/ja/imagick.readimage.php
	 * @param filename string <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function readimage ($filename) {}

	/**
	 * @param filenames
	 */
	public function readimages ($filenames) {}

	/**
	 * バイナリ文字列から画像を読み込む
	 * @link http://www.php.net/manual/ja/imagick.readimageblob.php
	 * @param image string <p>
	 * </p>
	 * @param filename string[optional] 
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function readimageblob ($image, $filename = null) {}

	/**
	 * 特定の画像のフォーマットを設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageformat.php
	 * @param format string <p>
	 * 画像フォーマットを表す文字列。対応するフォーマットは、
	 * インストールされている ImageMagick に依存します。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageformat ($format) {}

	/**
	 * 画像のサイズを変更する
	 * @link http://www.php.net/manual/ja/imagick.scaleimage.php
	 * @param cols int <p>
	 * </p>
	 * @param rows int <p>
	 * </p>
	 * @param bestfit bool[optional] <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function scaleimage ($cols, $rows, $bestfit = null) {}

	/**
	 * 指定した名前で画像を書き込む
	 * @link http://www.php.net/manual/ja/imagick.writeimage.php
	 * @param filename string[optional] <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function writeimage ($filename = null) {}

	/**
	 * 画像あるいは画像シーケンスを書き込む
	 * @link http://www.php.net/manual/ja/imagick.writeimages.php
	 * @param filename string <p>
	 * </p>
	 * @param adjoin bool <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function writeimages ($filename, $adjoin) {}

	/**
	 * blur (にじみ) フィルタを画像に追加する
	 * @link http://www.php.net/manual/ja/imagick.blurimage.php
	 * @param radius float <p>
	 * にじみの半径。
	 * </p>
	 * @param sigma float <p>
	 * 標準偏差。
	 * </p>
	 * @param channel int[optional] <p>
	 * チャネル 定数。
	 * 省略した場合は全チャネルが対象となります。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function blurimage ($radius, $sigma, $channel = null) {}

	/**
	 * 画像のサイズを変更する
	 * @link http://www.php.net/manual/ja/imagick.thumbnailimage.php
	 * @param columns int <p>
	 * 画像の幅。
	 * </p>
	 * @param rows int <p>
	 * 画像の高さ。
	 * </p>
	 * @param bestfit bool[optional] <p>
	 * 最大値を強制的に使用するかどうか。
	 * </p>
	 * @param fill bool[optional] 
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function thumbnailimage ($columns, $rows, $bestfit = null, $fill = null) {}

	/**
	 * 切り取ってサムネイルを作成する
	 * @link http://www.php.net/manual/ja/imagick.cropthumbnailimage.php
	 * @param width int <p>
	 * サムネイルの幅。
	 * </p>
	 * @param height int <p>
	 * サムネイルの高さ。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function cropthumbnailimage ($width, $height) {}

	/**
	 * シーケンス内の特定の画像のファイル名を返す
	 * @link http://www.php.net/manual/ja/imagick.getimagefilename.php
	 * @return string 画像のファイル名を文字列で返します。
	 */
	public function getimagefilename () {}

	/**
	 * 特定の画像のファイル名を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagefilename.php
	 * @param filename string <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagefilename ($filename) {}

	/**
	 * シーケンス内の特定の画像のフォーマットを返す
	 * @link http://www.php.net/manual/ja/imagick.getimageformat.php
	 * @return string 成功した場合は画像のフォーマットを文字列で返します。
	 */
	public function getimageformat () {}

	public function getimagemimetype () {}

	/**
	 * 画像リストから画像を削除する
	 * @link http://www.php.net/manual/ja/imagick.removeimage.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function removeimage () {}

	/**
	 * Imagick オブジェクトを破棄する
	 * @link http://www.php.net/manual/ja/imagick.destroy.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function destroy () {}

	/**
	 * Imagick オブジェクトに関連付けられたすべてのリソースをクリアする
	 * @link http://www.php.net/manual/ja/imagick.clear.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function clear () {}

	/**
	 * Imagick オブジェクトの完全なコピーを作成する
	 * @link http://www.php.net/manual/ja/imagick.clone.php
	 * @return Imagick Imagick オブジェクトのコピーを返します。
	 */
//	public function clone () {}

	/**
	 * 画像の長さをバイト数で返す
	 * @link http://www.php.net/manual/ja/imagick.getimagesize.php
	 * @return int 現在の画像のサイズをバイト数で返します。
	 */
	public function getimagesize () {}

	/**
	 * 画像シーケンスを blob で返す
	 * @link http://www.php.net/manual/ja/imagick.getimageblob.php
	 * @return string 画像を含む文字列を返します。
	 */
	public function getimageblob () {}

	/**
	 * すべての画像シーケンスを blob で返す
	 * @link http://www.php.net/manual/ja/imagick.getimagesblob.php
	 * @return string 画像を文字列で返します。失敗した場合は
	 * ImagickException をスローします。
	 */
	public function getimagesblob () {}

	/**
	 * Imagick イテレータを最初の画像に設定する
	 * @link http://www.php.net/manual/ja/imagick.setfirstiterator.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setfirstiterator () {}

	/**
	 * Imagick イテレータを最後の画像に設定する
	 * @link http://www.php.net/manual/ja/imagick.setlastiterator.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setlastiterator () {}

	public function resetiterator () {}

	/**
	 * オブジェクト内の前の画像に移動する
	 * @link http://www.php.net/manual/ja/imagick.previousimage.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function previousimage () {}

	/**
	 * 次の画像に移動する
	 * @link http://www.php.net/manual/ja/imagick.nextimage.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function nextimage () {}

	/**
	 * オブジェクトが前の画像を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/imagick.haspreviousimage.php
	 * @return bool リスト内で逆方向にひとつ進んだときにまだオブジェクトが画像を保持していれば
	 * TRUE、していなければ FALSE を返します。
	 */
	public function haspreviousimage () {}

	/**
	 * オブジェクトが次の画像を保持しているかどうかを調べる
	 * @link http://www.php.net/manual/ja/imagick.hasnextimage.php
	 * @return bool リスト内でひとつ先に進んだときにまだオブジェクトが画像を保持していれば
	 * TRUE、していなければ FALSE を返します。
	 */
	public function hasnextimage () {}

	/**
	 * イテレータの位置を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageindex.php
	 * @param index int <p>
	 * イテレータを設定する位置。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageindex ($index) {}

	/**
	 * 現在アクティブな画像のインデックスを取得する
	 * @link http://www.php.net/manual/ja/imagick.getimageindex.php
	 * @return int スタック内の画像のインデックスを表す整数値を返します。
	 */
	public function getimageindex () {}

	/**
	 * コメントを画像に追加する
	 * @link http://www.php.net/manual/ja/imagick.commentimage.php
	 * @param comment string <p>
	 * 追加するコメント。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function commentimage ($comment) {}

	/**
	 * 画像の一部を抽出する
	 * @link http://www.php.net/manual/ja/imagick.cropimage.php
	 * @param width int <p>
	 * 抽出する幅。
	 * </p>
	 * @param height int <p>
	 * 抽出する高さ。
	 * </p>
	 * @param x int <p>
	 * 抽出する領域の左上の X 座標。
	 * </p>
	 * @param y int <p>
	 * 抽出する領域の左上の Y 座標。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function cropimage ($width, $height, $x, $y) {}

	/**
	 * ラベルを画像に追加する
	 * @link http://www.php.net/manual/ja/imagick.labelimage.php
	 * @param label string <p>
	 * 追加するラベル。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function labelimage ($label) {}

	/**
	 * 幅と高さを連想配列で取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagegeometry.php
	 * @return array 画像の幅と高さを表す配列を返します。
	 */
	public function getimagegeometry () {}

	/**
	 * 現在の画像上の ImagickDraw オブジェクトをレンダリングする
	 * @link http://www.php.net/manual/ja/imagick.drawimage.php
	 * @param draw ImagickDraw <p>
	 * 画像をレンダリングする描画操作。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function drawimage (ImagickDraw $draw) {}

	/**
	 * 画像の圧縮品質を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagecompressionquality.php
	 * @param quality int <p>
	 * 画像の圧縮品質を表す整数値。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagecompressionquality ($quality) {}

	/**
	 * 現在の画像の圧縮品質を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagecompressionquality.php
	 * @return int 画像の圧縮品質を表す整数値を返します。
	 */
	public function getimagecompressionquality () {}

	/**
	 * 画像にテキストによる注記を加える
	 * @link http://www.php.net/manual/ja/imagick.annotateimage.php
	 * @param draw_settings ImagickDraw <p>
	 * テキスト描画設定を含む ImagickDraw オブジェクト。
	 * </p>
	 * @param x float <p>
	 * テキストの左端の水平オフセットをあらわすピクセル数。
	 * </p>
	 * @param y float <p>
	 * テキストのベースラインの垂直オフセットをあらわすピクセル数。
	 * </p>
	 * @param angle float <p>
	 * テキストを書き出す角度。
	 * </p>
	 * @param text string <p>
	 * 描画するテキスト。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function annotateimage (ImagickDraw $draw_settings, $x, $y, $angle, $text) {}

	/**
	 * ある画像を別の画像に合成する
	 * @link http://www.php.net/manual/ja/imagick.compositeimage.php
	 * @param composite_object Imagick <p>
	 * 合成する画像を保持する Imagick オブジェクト。
	 * </p>
	 * @param composite int 
	 * @param x int <p>
	 * 合成する位置の列オフセット。
	 * </p>
	 * @param y int <p>
	 * 合成する位置の行オフセット。
	 * </p>
	 * @param channel int[optional] <p>
	 * そのチャネルモードで使用可能なチャネル定数を指定します。
	 * 複数のチャネルを指定するには、チャネル型定数をビット演算子で結合します。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function compositeimage (Imagick $composite_object, $composite, $x, $y, $channel = null) {}

	/**
	 * 明度、飽和度、色相を制御する
	 * @link http://www.php.net/manual/ja/imagick.modulateimage.php
	 * @param brightness float <p>
	 * </p>
	 * @param saturation float <p>
	 * </p>
	 * @param hue float <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function modulateimage ($brightness, $saturation, $hue) {}

	/**
	 * 画像で使われている色の数を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagecolors.php
	 * @return int 成功した場合に TRUE を返します。
	 */
	public function getimagecolors () {}

	/**
	 * 合成画像を作成する
	 * @link http://www.php.net/manual/ja/imagick.montageimage.php
	 * @param draw ImagickDraw <p>
	 * フォント名、サイズ、色をこのオブジェクトから取得します。
	 * </p>
	 * @param tile_geometry string <p>
	 * 行単位、ページ単位のタイル数 (例 6x4+0+0)。
	 * </p>
	 * @param thumbnail_geometry string <p>
	 * 各サムネイルの画像サイズと枠線のサイズ (例 120x120+4+3>)。
	 * </p>
	 * @param mode int <p>
	 * サムネイルのフレームモード。
	 * モンタージュモード定数
	 * を参照ください。
	 * </p>
	 * @param frame string <p>
	 * 画像を枠線で囲みます (例 15x15+3+3)。
	 * 枠の色は、サムネイルのマット色となります。
	 * </p>
	 * @return Imagick 成功した場合に TRUE を返します。
	 */
	public function montageimage (ImagickDraw $draw, $tile_geometry, $thumbnail_geometry, $mode, $frame) {}

	/**
	 * 画像を識別し、属性を取得する
	 * @link http://www.php.net/manual/ja/imagick.identifyimage.php
	 * @param appendRawOutput bool[optional] <p>
	 * </p>
	 * @return array 画像を識別し、属性を返します。属性には画像の幅や高さ、サイズなどが含まれます。
	 */
	public function identifyimage ($appendRawOutput = null) {}

	/**
	 * 閾値にもとづいて個々のピクセルの値を変更する
	 * @link http://www.php.net/manual/ja/imagick.thresholdimage.php
	 * @param threshold float <p>
	 * </p>
	 * @param channel int[optional] <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function thresholdimage ($threshold, $channel = null) {}

	/**
	 * 輝度の範囲にもとづいて各ピクセルの閾値を選択する
	 * @link http://www.php.net/manual/ja/imagick.adaptivethresholdimage.php
	 * @param width int <p>
	 * 周辺の幅。
	 * </p>
	 * @param height int <p>
	 * 周辺の高さ。
	 * </p>
	 * @param offset int <p>
	 * 平均オフセット。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function adaptivethresholdimage ($width, $height, $offset) {}

	/**
	 * 閾値に満たないすべてのピクセルを黒にする
	 * @link http://www.php.net/manual/ja/imagick.blackthresholdimage.php
	 * @param threshold mixed <p>
	 * すべて黒にする閾値。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function blackthresholdimage ($threshold) {}

	/**
	 * 閾値に満たないすべてのピクセルを白にする
	 * @link http://www.php.net/manual/ja/imagick.whitethresholdimage.php
	 * @param threshold mixed <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function whitethresholdimage ($threshold) {}

	/**
	 * 画像群を追加する
	 * @link http://www.php.net/manual/ja/imagick.appendimages.php
	 * @param stack bool <p>
	 * 画像を垂直方向に積むかどうか。デフォルト (あるいは FALSE を指定した場合)
	 * は、画像を左から右に積みます。stack が TRUE
	 * の場合は、画像を上から下に積みます。
	 * </p>
	 * @return Imagick 成功した場合に Imagick インスタンスを返します。
	 */
	public function appendimages ($stack) {}

	/**
	 * 木炭画をシミュレートする
	 * @link http://www.php.net/manual/ja/imagick.charcoalimage.php
	 * @param radius float <p>
	 * ガウス分布の半径。中心を含まないピクセル数。
	 * </p>
	 * @param sigma float <p>
	 * ガウス分布の標準偏差 (ピクセル単位)。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function charcoalimage ($radius, $sigma) {}

	/**
	 * カラー画像のコントラストを強調する
	 * @link http://www.php.net/manual/ja/imagick.normalizeimage.php
	 * @param channel int[optional] <p>
	 * チャネルモードに対応したチャネル定数を指定します。
	 * 複数のチャネルに適用するには、
	 * ビット演算子でチャネル型定数を組み合わせます。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function normalizeimage ($channel = null) {}

	/**
	 * 油絵をシミュレートする
	 * @link http://www.php.net/manual/ja/imagick.oilpaintimage.php
	 * @param radius float <p>
	 * 近傍円の半径。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function oilpaintimage ($radius) {}

	/**
	 * 指定した色数まで画像を減色する
	 * @link http://www.php.net/manual/ja/imagick.posterizeimage.php
	 * @param levels int <p>
	 * </p>
	 * @param dither bool <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function posterizeimage ($levels, $dither) {}

	/**
	 * 画像にラジアルブラーを施す
	 * @link http://www.php.net/manual/ja/imagick.radialblurimage.php
	 * @param angle float <p>
	 * </p>
	 * @param channel int[optional] <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function radialblurimage ($angle, $channel = null) {}

	/**
	 * 三次元のボタン風の効果をシミュレートする
	 * @link http://www.php.net/manual/ja/imagick.raiseimage.php
	 * @param width int <p>
	 * </p>
	 * @param height int <p>
	 * </p>
	 * @param x int <p>
	 * </p>
	 * @param y int <p>
	 * </p>
	 * @param raise bool <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function raiseimage ($width, $height, $x, $y, $raise) {}

	/**
	 * 画像を指定した解像度にリサンプリングする
	 * @link http://www.php.net/manual/ja/imagick.resampleimage.php
	 * @param x_resolution float <p>
	 * </p>
	 * @param y_resolution float <p>
	 * </p>
	 * @param filter int <p>
	 * </p>
	 * @param blur float <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function resampleimage ($x_resolution, $y_resolution, $filter, $blur) {}

	/**
	 * 画像のサイズを変更する
	 * @link http://www.php.net/manual/ja/imagick.resizeimage.php
	 * @param columns int <p>
	 * 画像の幅。
	 * </p>
	 * @param rows int <p>
	 * 画像の高さ。
	 * </p>
	 * @param filter int <p>
	 * フィルタ定数
	 * の一覧を参照ください。
	 * </p>
	 * @param blur float <p>
	 * blur 要素。&gt; 1 はぼやけた状態、&lt; 1 はシャープな状態を表します。
	 * </p>
	 * @param bestfit bool[optional] <p>
	 * オプションの fit パラメータ。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function resizeimage ($columns, $rows, $filter, $blur, $bestfit = null) {}

	/**
	 * 画像を補正する
	 * @link http://www.php.net/manual/ja/imagick.rollimage.php
	 * @param x int <p>
	 * X オフセット。
	 * </p>
	 * @param y int <p>
	 * Y オフセット。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function rollimage ($x, $y) {}

	/**
	 * 画像を回転する
	 * @link http://www.php.net/manual/ja/imagick.rotateimage.php
	 * @param background mixed <p>
	 * 背景色。
	 * </p>
	 * @param degrees float <p>
	 * 画像を回転させる度数。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function rotateimage ($background, $degrees) {}

	/**
	 * ピクセルのサンプリングによって画像の倍率を変更する
	 * @link http://www.php.net/manual/ja/imagick.sampleimage.php
	 * @param columns int <p>
	 * </p>
	 * @param rows int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function sampleimage ($columns, $rows) {}

	/**
	 * 画像にソラリゼーション効果を適用する
	 * @link http://www.php.net/manual/ja/imagick.solarizeimage.php
	 * @param threshold int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function solarizeimage ($threshold) {}

	/**
	 * 画像の影をシミュレートする
	 * @link http://www.php.net/manual/ja/imagick.shadowimage.php
	 * @param opacity float <p>
	 * </p>
	 * @param sigma float <p>
	 * </p>
	 * @param x int <p>
	 * </p>
	 * @param y int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function shadowimage ($opacity, $sigma, $x, $y) {}

	/**
	 * @param key
	 * @param value
	 */
	public function setimageattribute ($key, $value) {}

	/**
	 * 画像の背景色を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagebackgroundcolor.php
	 * @param background mixed <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagebackgroundcolor ($background) {}

	/**
	 * 画像の合成演算子を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagecompose.php
	 * @param compose int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagecompose ($compose) {}

	/**
	 * 画像の圧縮を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagecompression.php
	 * @param compression int <p>
	 * COMPRESSION 定数のいずれか。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagecompression ($compression) {}

	/**
	 * 画像の遅延を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagedelay.php
	 * @param delay int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagedelay ($delay) {}

	/**
	 * 画像の深度を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagedepth.php
	 * @param depth int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagedepth ($depth) {}

	/**
	 * 画像のガンマを設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagegamma.php
	 * @param gamma float <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagegamma ($gamma) {}

	/**
	 * 画像の反復を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageiterations.php
	 * @param iterations int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageiterations ($iterations) {}

	/**
	 * 画像のマット色を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagemattecolor.php
	 * @param matte mixed <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagemattecolor ($matte) {}

	/**
	 * 画像のページのジオメトリを設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagepage.php
	 * @param width int <p>
	 * </p>
	 * @param height int <p>
	 * </p>
	 * @param x int <p>
	 * </p>
	 * @param y int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagepage ($width, $height, $x, $y) {}

	/**
	 * @param filename
	 */
	public function setimageprogressmonitor ($filename) {}

	/**
	 * 画像の解像度を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageresolution.php
	 * @param x_resolution float <p>
	 * </p>
	 * @param y_resolution float <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageresolution ($x_resolution, $y_resolution) {}

	/**
	 * 画像のシーンを設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagescene.php
	 * @param scene int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagescene ($scene) {}

	/**
	 * 画像の ticks-per-second を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagetickspersecond.php
	 * @param ticks_per_second int 
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagetickspersecond ($ticks_per_second) {}

	/**
	 * 画像の型を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagetype.php
	 * @param image_type int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagetype ($image_type) {}

	/**
	 * 画像の解像度の単位を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageunits.php
	 * @param units int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageunits ($units) {}

	/**
	 * 画像をシャープにする
	 * @link http://www.php.net/manual/ja/imagick.sharpenimage.php
	 * @param radius float <p>
	 * </p>
	 * @param sigma float <p>
	 * </p>
	 * @param channel int[optional] <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function sharpenimage ($radius, $sigma, $channel = null) {}

	/**
	 * 画像の輪郭からピクセルを刈り取る
	 * @link http://www.php.net/manual/ja/imagick.shaveimage.php
	 * @param columns int <p>
	 * </p>
	 * @param rows int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function shaveimage ($columns, $rows) {}

	/**
	 * 平行四辺形を作成する
	 * @link http://www.php.net/manual/ja/imagick.shearimage.php
	 * @param background mixed <p>
	 * 背景色。
	 * </p>
	 * @param x_shear float <p>
	 * x 軸方向に押しつぶす角度。
	 * </p>
	 * @param y_shear float <p>
	 * y 軸方向に押しつぶす角度。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function shearimage ($background, $x_shear, $y_shear) {}

	/**
	 * 無地の画像を作成する
	 * @link http://www.php.net/manual/ja/imagick.spliceimage.php
	 * @param width int <p>
	 * </p>
	 * @param height int <p>
	 * </p>
	 * @param x int <p>
	 * </p>
	 * @param y int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function spliceimage ($width, $height, $x, $y) {}

	/**
	 * 画像の基本属性を取得する
	 * @link http://www.php.net/manual/ja/imagick.pingimage.php
	 * @param filename string <p>
	 * 情報を読み込むファイル名。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function pingimage ($filename) {}

	/**
	 * オープンしているファイルハンドルから画像を読み込む
	 * @link http://www.php.net/manual/ja/imagick.readimagefile.php
	 * @param filehandle resource <p>
	 * </p>
	 * @param fileName string[optional] <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function readimagefile ($filehandle, $fileName = null) {}

	/**
	 * 画像を表示する
	 * @link http://www.php.net/manual/ja/imagick.displayimage.php
	 * @param servername string <p>
	 * X サーバーの名前。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function displayimage ($servername) {}

	/**
	 * 画像あるいは画像シーケンスを表示する
	 * @link http://www.php.net/manual/ja/imagick.displayimages.php
	 * @param servername string <p>
	 * X サーバーの名前。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function displayimages ($servername) {}

	/**
	 * ブロック内の各ピクセルをランダムに移動する
	 * @link http://www.php.net/manual/ja/imagick.spreadimage.php
	 * @param radius float <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function spreadimage ($radius) {}

	/**
	 * 画像の中心から、ピクセルを渦巻状にする
	 * @link http://www.php.net/manual/ja/imagick.swirlimage.php
	 * @param degrees float <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function swirlimage ($degrees) {}

	/**
	 * 画像からすべてのプロパティやコメントを除去する
	 * @link http://www.php.net/manual/ja/imagick.stripimage.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function stripimage () {}

	/**
	 * Imagick がサポートするフォーマットを返す
	 * @link http://www.php.net/manual/ja/imagick.queryformats.php
	 * @param pattern string[optional] <p>
	 * </p>
	 * @return array Imagick がサポートするフォーマットを含む配列を返します。
	 */
	public function queryformats ($pattern = null) {}

	/**
	 * 設定したフォントを返す
	 * @link http://www.php.net/manual/ja/imagick.queryfonts.php
	 * @param pattern string[optional] <p>
	 * クエリパターン。
	 * </p>
	 * @return array フォントを含む配列を返します。
	 */
	public function queryfonts ($pattern = null) {}

	/**
	 * フォントメトリクスを表す配列を返す
	 * @link http://www.php.net/manual/ja/imagick.queryfontmetrics.php
	 * @param properties ImagickDraw <p>
	 * フォントのプロパティを含む ImagickDraw オブジェクト。
	 * </p>
	 * @param text string <p>
	 * テキスト。
	 * </p>
	 * @param multiline bool[optional] <p>
	 * マルチラインパラメータ。空にすると自動検出します。
	 * </p>
	 * @return array フォントメトリクスを表す、多次元配列を返します。
	 */
	public function queryfontmetrics (ImagickDraw $properties, $text, $multiline = null) {}

	/**
	 * デジタル透かしを画像に埋め込む
	 * @link http://www.php.net/manual/ja/imagick.steganoimage.php
	 * @param watermark_wand Imagick <p>
	 * </p>
	 * @param offset int <p>
	 * </p>
	 * @return Imagick 成功した場合に TRUE を返します。
	 */
	public function steganoimage (Imagick $watermark_wand, $offset) {}

	/**
	 * ランダムなノイズを画像に追加する
	 * @link http://www.php.net/manual/ja/imagick.addnoiseimage.php
	 * @param noise_type int <p>
	 * ノイズの形式。
	 * ノイズ定数
	 * の一覧を参照ください。
	 * </p>
	 * @param channel int[optional] <p>
	 * そのモードで有効なチャネル定数を指定します。
	 * 複数のチャネルを適用するには、チャネル定数
	 * をビット演算子で組み合わせます。デフォルトは Imagick::CHANNEL_DEFAULT です。
	 * チャネル定数 の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function addnoiseimage ($noise_type, $channel = null) {}

	/**
	 * モーションブラーをシミュレートする
	 * @link http://www.php.net/manual/ja/imagick.motionblurimage.php
	 * @param radius float <p>
	 * ガウス演算の半径。ピクセル単位で指定し、中心は計算に入れません。
	 * </p>
	 * @param sigma float <p>
	 * ガウス演算の標準偏差。ピクセル単位で指定します。
	 * </p>
	 * @param angle float <p>
	 * この角度で効果を適用します。
	 * </p>
	 * @param channel int[optional] <p>
	 * そのチャンネルモードで使用可能な任意のチャンネル定数を指定します。
	 * 複数を指定する場合はビット演算子を使用します。
	 * チャンネル定数
	 * の一覧を参照ください。
	 * この引数が有効になるのは、ImageMagick バージョン 6.4.4
	 * 以降で Imagick をコンパイルした場合のみです。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function motionblurimage ($radius, $sigma, $angle, $channel = null) {}

	/**
	 * 画像からモザイクを作成する
	 * @link http://www.php.net/manual/ja/imagick.mosaicimages.php
	 * @return Imagick 成功した場合に TRUE を返します。
	 */
	public function mosaicimages () {}

	/**
	 * 複数の画像をモーフィングする
	 * @link http://www.php.net/manual/ja/imagick.morphimages.php
	 * @param number_frames int <p>
	 * 生成する中間画像の数。
	 * </p>
	 * @return Imagick このメソッドは、成功した場合に新しい Imagick オブジェクトを返します。
	 * エラー時に
	 * ImagickException をスローします。
	 */
	public function morphimages ($number_frames) {}

	/**
	 * 画像をその半分のサイズに比例縮小する
	 * @link http://www.php.net/manual/ja/imagick.minifyimage.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function minifyimage () {}

	/**
	 * 画像を変換する
	 * @link http://www.php.net/manual/ja/imagick.affinetransformimage.php
	 * @param matrix ImagickDraw <p>
	 * アフィン行列。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function affinetransformimage (ImagickDraw $matrix) {}

	/**
	 * 画像群を平均化する
	 * @link http://www.php.net/manual/ja/imagick.averageimages.php
	 * @return Imagick 成功した場合に Imagick インスタンスを返します。
	 */
	public function averageimages () {}

	/**
	 * 画像の周りを枠線で囲む
	 * @link http://www.php.net/manual/ja/imagick.borderimage.php
	 * @param bordercolor mixed <p>
	 * 枠線の色を含む ImagickPixel オブジェクトあるいは文字列。
	 * </p>
	 * @param width int <p>
	 * 枠線の幅。
	 * </p>
	 * @param height int <p>
	 * 枠線の高さ。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function borderimage ($bordercolor, $width, $height) {}

	/**
	 * 画像の一部を取り除き、切り詰める
	 * @link http://www.php.net/manual/ja/imagick.chopimage.php
	 * @param width int <p>
	 * 切り取る範囲の幅。
	 * </p>
	 * @param height int <p>
	 * 切り取る範囲の高さ。
	 * </p>
	 * @param x int <p>
	 * 切り取る範囲の X 座標。
	 * </p>
	 * @param y int <p>
	 * 切り取る範囲の Y 座標。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function chopimage ($width, $height, $x, $y) {}

	/**
	 * 8BIM プロファイルの最初のパスにそって切り取る
	 * @link http://www.php.net/manual/ja/imagick.clipimage.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function clipimage () {}

	/**
	 * 8BIM プロファイルの指定した名前のパスにそって切り取る
	 * @link http://www.php.net/manual/ja/imagick.clippathimage.php
	 * @param pathname string <p>
	 * パスの名前。
	 * </p>
	 * @param inside bool <p>
	 * true の場合は、その後の操作はクリップパスの内側に対して適用されます。
	 * それ以外の場合は、その後の操作はクリップパスの外側に対して適用されます。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function clippathimage ($pathname, $inside) {}

	/**
	 * @param pathname
	 * @param inside
	 */
	public function clipimagepath ($pathname, $inside) {}

	/**
	 * 複数の画像を合成する
	 * @link http://www.php.net/manual/ja/imagick.coalesceimages.php
	 * @return Imagick 成功した場合に新規 Imagick オブジェクトを返します。
	 */
	public function coalesceimages () {}

	/**
	 * 対象にマッチする任意の点の色の値を変更する
	 * @link http://www.php.net/manual/ja/imagick.colorfloodfillimage.php
	 * @param fill mixed <p>
	 * 塗りつぶし色を表す ImagickPixel オブジェクト。
	 * </p>
	 * @param fuzz float <p>
	 * fuzz の量。たとえば fuzz を 10 に設定すると、
	 * 赤の輝度が 100 および 102 の点は同じ色とみなされます。
	 * </p>
	 * @param bordercolor mixed <p>
	 * 枠線の色を表す ImagickPixel オブジェクト。
	 * </p>
	 * @param x int <p>
	 * 開始位置の X 座標。
	 * </p>
	 * @param y int <p>
	 * 開始位置の Y 座標。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function colorfloodfillimage ($fill, $fuzz, $bordercolor, $x, $y) {}

	/**
	 * 塗りつぶし色と画像を混合する
	 * @link http://www.php.net/manual/ja/imagick.colorizeimage.php
	 * @param colorize mixed <p>
	 * 色を表す ImagickPixel オブジェクトあるいは文字列。
	 * </p>
	 * @param opacity mixed <p>
	 * 不透明度を表す ImagickPixel オブジェクトあるいは文字列。
	 * 1.0 は完全に不透明、0.0 は完全に透明であることを表します。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function colorizeimage ($colorize, $opacity) {}

	/**
	 * ひとつあるいは複数の画像の差を返す
	 * @link http://www.php.net/manual/ja/imagick.compareimagechannels.php
	 * @param image Imagick <p>
	 * 比較する画像を含む Imagick オブジェクト。
	 * </p>
	 * @param channelType int <p>
	 * そのチャネルモードで使用可能なチャネル定数を指定します。
	 * 複数のチャネルを指定するには、チャネル型定数をビット演算子で結合します。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @param metricType int <p>
	 * メトリック型定数 のいずれか。
	 * </p>
	 * @return array new_wand と
	 * distortion を含む配列を返します。
	 */
	public function compareimagechannels (Imagick $image, $channelType, $metricType) {}

	/**
	 * ある画像を再構築された画像と比較する
	 * @link http://www.php.net/manual/ja/imagick.compareimages.php
	 * @param compare Imagick <p>
	 * 比較したい画像。
	 * </p>
	 * @param metric int <p>
	 * メトリック定数を指定します。この
	 * メトリック定数
	 * の一覧を参照ください。
	 * </p>
	 * @return array 成功した場合に TRUE を返します。
	 */
	public function compareimages (Imagick $compare, $metric) {}

	/**
	 * 画像のコントラストを変更する
	 * @link http://www.php.net/manual/ja/imagick.contrastimage.php
	 * @param sharpen bool <p>
	 * シャープ値。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function contrastimage ($sharpen) {}

	/**
	 * ひとつあるいは複数の画像をひとつにまとめる
	 * @link http://www.php.net/manual/ja/imagick.combineimages.php
	 * @param channelType int <p>
	 * そのチャネルモードで使用可能なチャネル定数のいずれか。
	 * 複数のチャネルを適用するには、channeltype 定数をビット演算子でまとめます。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return Imagick 成功した場合に TRUE を返します。
	 */
	public function combineimages ($channelType) {}

	/**
	 * 独自の畳み込み関数を画像に適用する
	 * @link http://www.php.net/manual/ja/imagick.convolveimage.php
	 * @param kernel array <p>
	 * 畳み込みの中心。
	 * </p>
	 * @param channel int[optional] <p>
	 * そのチャネルモードで使用可能なチャネル定数を指定します。
	 * 複数のチャネルを適用するには、定数をビット演算子で連結します。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function convolveimage (array $kernel, $channel = null) {}

	/**
	 * 画像のカラーマップを移動する
	 * @link http://www.php.net/manual/ja/imagick.cyclecolormapimage.php
	 * @param displace int <p>
	 * カラーマップを移動させる量。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function cyclecolormapimage ($displace) {}

	/**
	 * 画像間の特定のピクセルの差を返す
	 * @link http://www.php.net/manual/ja/imagick.deconstructimages.php
	 * @return Imagick 成功した場合に新しい Imagick オブジェクトを返します。
	 */
	public function deconstructimages () {}

	/**
	 * 画像内のスペックルノイズを軽減する
	 * @link http://www.php.net/manual/ja/imagick.despeckleimage.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function despeckleimage () {}

	/**
	 * 画像の輪郭を強調する
	 * @link http://www.php.net/manual/ja/imagick.edgeimage.php
	 * @param radius float <p>
	 * 操作の半径。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function edgeimage ($radius) {}

	/**
	 * グレースケール画像に三次元効果を施して返す
	 * @link http://www.php.net/manual/ja/imagick.embossimage.php
	 * @param radius float <p>
	 * 効果の半径。
	 * </p>
	 * @param sigma float <p>
	 * 効果のシグマ。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function embossimage ($radius, $sigma) {}

	/**
	 * ノイジーな画像の品質を向上させる
	 * @link http://www.php.net/manual/ja/imagick.enhanceimage.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function enhanceimage () {}

	/**
	 * 画像ヒストグラムを均等化する
	 * @link http://www.php.net/manual/ja/imagick.equalizeimage.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function equalizeimage () {}

	/**
	 * 式を画像に適用する
	 * @link http://www.php.net/manual/ja/imagick.evaluateimage.php
	 * @param op int <p>
	 * 評価演算子。
	 * </p>
	 * @param constant float <p>
	 * 演算子の値。
	 * </p>
	 * @param channel int[optional] <p>
	 * チャネルモードに対応したチャネル定数を指定します。
	 * 複数のチャネルに適用するには、
	 * ビット演算子でチャネル型定数を組み合わせます。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function evaluateimage ($op, $constant, $channel = null) {}

	/**
	 * 画像シーケンスをマージする
	 * @link http://www.php.net/manual/ja/imagick.flattenimages.php
	 * @return Imagick 成功した場合に TRUE を返します。
	 */
	public function flattenimages () {}

	/**
	 * 垂直方向に反転した画像を作成する
	 * @link http://www.php.net/manual/ja/imagick.flipimage.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function flipimage () {}

	/**
	 * 水平方向に反転した画像を作成する
	 * @link http://www.php.net/manual/ja/imagick.flopimage.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function flopimage () {}

	/**
	 * 三次元の枠線をシミュレートする
	 * @link http://www.php.net/manual/ja/imagick.frameimage.php
	 * @param matte_color mixed <p>
	 * マット色を表す ImagickPixel オブジェクトあるいは文字列。
	 * </p>
	 * @param width int <p>
	 * 枠の幅。
	 * </p>
	 * @param height int <p>
	 * 枠の高さ。
	 * </p>
	 * @param inner_bevel int <p>
	 * 内側の影の幅。
	 * </p>
	 * @param outer_bevel int <p>
	 * 外側の影の幅。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function frameimage ($matte_color, $width, $height, $inner_bevel, $outer_bevel) {}

	/**
	 * 式を画像の各ピクセルに適用する
	 * @link http://www.php.net/manual/ja/imagick.fximage.php
	 * @param expression string <p>
	 * 式。
	 * </p>
	 * @param channel int[optional] <p>
	 * チャネルモードに対応したチャネル定数を指定します。
	 * 複数のチャネルに適用するには、
	 * ビット演算子でチャネル型定数を組み合わせます。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return Imagick 成功した場合に TRUE を返します。
	 */
	public function fximage ($expression, $channel = null) {}

	/**
	 * 画像をガンマ補正する
	 * @link http://www.php.net/manual/ja/imagick.gammaimage.php
	 * @param gamma float <p>
	 * ガンマ補正の量。
	 * </p>
	 * @param channel int[optional] <p>
	 * チャネルモードに対応したチャネル定数を指定します。
	 * 複数のチャネルに適用するには、
	 * ビット演算子でチャネル型定数を組み合わせます。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function gammaimage ($gamma, $channel = null) {}

	/**
	 * 画像をぼかす
	 * @link http://www.php.net/manual/ja/imagick.gaussianblurimage.php
	 * @param radius float <p>
	 * ガウス演算の半径。ピクセル単位で指定し、中心は計算に入れません。
	 * </p>
	 * @param sigma float <p>
	 * ガウス演算の標準偏差。ピクセル単位で指定します。
	 * </p>
	 * @param channel int[optional] <p>
	 * チャネルモードに対応したチャネル定数を指定します。
	 * 複数のチャネルに適用するには、
	 * ビット演算子でチャネル型定数を組み合わせます。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function gaussianblurimage ($radius, $sigma, $channel = null) {}

	/**
	 * @param key
	 */
	public function getimageattribute ($key) {}

	/**
	 * 画像の背景色を返す
	 * @link http://www.php.net/manual/ja/imagick.getimagebackgroundcolor.php
	 * @return ImagickPixel 画像の背景色を設定した ImagickPixel を返します。
	 */
	public function getimagebackgroundcolor () {}

	/**
	 * 青が一番強い点を返す
	 * @link http://www.php.net/manual/ja/imagick.getimageblueprimary.php
	 * @return array "x" 座標および "y" 座標を含む配列を返します。
	 */
	public function getimageblueprimary () {}

	/**
	 * 画像の前景色を返す
	 * @link http://www.php.net/manual/ja/imagick.getimagebordercolor.php
	 * @return ImagickPixel 成功した場合に TRUE を返します。
	 */
	public function getimagebordercolor () {}

	/**
	 * 特定の画像チャネルの深度を返す
	 * @link http://www.php.net/manual/ja/imagick.getimagechanneldepth.php
	 * @param channel int <p>
	 * そのモードで有効なチャネル定数を指定します。
	 * 複数のチャネルを適用するには、チャネル定数
	 * をビット演算子で組み合わせます。デフォルトは Imagick::CHANNEL_DEFAULT です。
	 * チャネル定数 の一覧を参照ください。
	 * </p>
	 * @return int 成功した場合に TRUE を返します。
	 */
	public function getimagechanneldepth ($channel) {}

	/**
	 * 画像のチャネルを再構築した画像と比較する
	 * @link http://www.php.net/manual/ja/imagick.getimagechanneldistortion.php
	 * @param reference Imagick <p>
	 * 比較する Imagick オブジェクト。
	 * </p>
	 * @param channel int <p>
	 * チャネルモードに対応したチャネル定数を指定します。
	 * 複数のチャネルに適用するには、
	 * ビット演算子でチャネル型定数を組み合わせます。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @param metric int <p>
	 * メトリック型定数
	 * のいずれか。
	 * </p>
	 * @return float 成功した場合に TRUE を返します。
	 */
	public function getimagechanneldistortion (Imagick $reference, $channel, $metric) {}

	/**
	 * ひとつあるいは複数の画像チャネルの極値を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagechannelextrema.php
	 * @param channel int <p>
	 * チャネルモードに対応したチャネル定数を指定します。
	 * 複数のチャネルに適用するには、
	 * ビット演算子でチャネル型定数を組み合わせます。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return array 成功した場合に TRUE を返します。
	 */
	public function getimagechannelextrema ($channel) {}

	/**
	 * 平均値と標準偏差を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagechannelmean.php
	 * @param channel int <p>
	 * チャネルモードに対応したチャネル定数を指定します。
	 * 複数のチャネルに適用するには、
	 * ビット演算子でチャネル型定数を組み合わせます。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return array 成功した場合に TRUE を返します。
	 */
	public function getimagechannelmean ($channel) {}

	/**
	 * 画像の各チャネルの統計情報を返す
	 * @link http://www.php.net/manual/ja/imagick.getimagechannelstatistics.php
	 * @return array 成功した場合に TRUE を返します。
	 */
	public function getimagechannelstatistics () {}

	/**
	 * 指定したインデックスに対応する色マップ上の色を返す
	 * @link http://www.php.net/manual/ja/imagick.getimagecolormapcolor.php
	 * @param index int <p>
	 * 画像の色マップ内のオフセット。
	 * </p>
	 * @return ImagickPixel 成功した場合に TRUE を返します。
	 */
	public function getimagecolormapcolor ($index) {}

	/**
	 * 画像の色空間を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagecolorspace.php
	 * @return int 成功した場合に TRUE を返します。
	 */
	public function getimagecolorspace () {}

	/**
	 * 画像の合成演算子を返す
	 * @link http://www.php.net/manual/ja/imagick.getimagecompose.php
	 * @return int 成功した場合に TRUE を返します。
	 */
	public function getimagecompose () {}

	/**
	 * 画像の遅延を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagedelay.php
	 * @return int 画像の遅延を返します。
	 */
	public function getimagedelay () {}

	/**
	 * 画像の深度を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagedepth.php
	 * @return int 画像の深度を返します。
	 */
	public function getimagedepth () {}

	/**
	 * ある画像と再構築した画像を比較する
	 * @link http://www.php.net/manual/ja/imagick.getimagedistortion.php
	 * @param reference MagickWand <p>
	 * 比較する Imagick オブジェクト。
	 * </p>
	 * @param metric int <p>
	 * メトリック型定数
	 * のいずれか。
	 * </p>
	 * @return float その画像で使用する歪み係数 (あるいはその推測値) を返します。
	 */
	public function getimagedistortion ($reference, $metric) {}

	/**
	 * 画像の極値を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimageextrema.php
	 * @return array "min" および "max" というキーを持つ連想配列を返します。
	 */
	public function getimageextrema () {}

	/**
	 * 画像の配置方法を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagedispose.php
	 * @return int 成功した場合に配置方法を返します。
	 */
	public function getimagedispose () {}

	/**
	 * 画像のガンマを取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagegamma.php
	 * @return float 成功した場合にガンマを返します。
	 */
	public function getimagegamma () {}

	/**
	 * 緑が一番強い点を返す
	 * @link http://www.php.net/manual/ja/imagick.getimagegreenprimary.php
	 * @return array 成功した場合に "x" および "y" というキーを持つ配列を返します。
	 * 失敗した場合は ImagickException をスローします。
	 */
	public function getimagegreenprimary () {}

	/**
	 * 画像の高さを返す
	 * @link http://www.php.net/manual/ja/imagick.getimageheight.php
	 * @return int 画像の高さをピクセル数で返します。
	 */
	public function getimageheight () {}

	/**
	 * 画像のヒストグラムを取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagehistogram.php
	 * @return array 画像のヒストグラムを ImagickPixel オブジェクトの配列で返します。
	 */
	public function getimagehistogram () {}

	/**
	 * 画像のインターレース手法を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimageinterlacescheme.php
	 * @return int 成功した場合に画像のインターレース手法を返します。
	 * エラー時に
	 * ImagickException をスローします。
	 */
	public function getimageinterlacescheme () {}

	/**
	 * 画像の反復を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimageiterations.php
	 * @return int 画像の反復を表す整数値を返します。
	 */
	public function getimageiterations () {}

	/**
	 * 画像のマット色を返す
	 * @link http://www.php.net/manual/ja/imagick.getimagemattecolor.php
	 * @return ImagickPixel 成功した場合に ImagickPixel オブジェクトを返します。
	 */
	public function getimagemattecolor () {}

	/**
	 * ページのジオメトリを返す
	 * @link http://www.php.net/manual/ja/imagick.getimagepage.php
	 * @return array 画像のページジオメトリを配列で返します。配列のキーは
	 * "width"、"height"、"x" および "y" です。
	 */
	public function getimagepage () {}

	/**
	 * 指定したピクセルの色を返す
	 * @link http://www.php.net/manual/ja/imagick.getimagepixelcolor.php
	 * @param x int <p>
	 * ピクセルの x 座標。
	 * </p>
	 * @param y int <p>
	 * ピクセルの y 座標。
	 * </p>
	 * @return ImagickPixel 指定した座標の色を表す ImagickPixel のインスタンスを返します。
	 */
	public function getimagepixelcolor ($x, $y) {}

	/**
	 * 指定した名前の画像プロファイルを返す
	 * @link http://www.php.net/manual/ja/imagick.getimageprofile.php
	 * @param name string <p>
	 * 返したいプロファイルの名前。
	 * </p>
	 * @return string 画像プロファイルを含む文字列を返します。
	 */
	public function getimageprofile ($name) {}

	/**
	 * 赤が一番強い点を返す
	 * @link http://www.php.net/manual/ja/imagick.getimageredprimary.php
	 * @return array 赤が一番強い点を "x" および "y" というキーを持つ配列で返します。
	 * エラー時に
	 * ImagickException をスローします。
	 */
	public function getimageredprimary () {}

	/**
	 * 画像のレンダリング方向を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagerenderingintent.php
	 * @return int 画像の レンダリング方向 を返します。
	 */
	public function getimagerenderingintent () {}

	/**
	 * 画像の X 方向と Y 方向の解像度を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimageresolution.php
	 * @return array 解像度を配列で返します。
	 */
	public function getimageresolution () {}

	/**
	 * 画像のシーンを取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagescene.php
	 * @return int 画像のシーンを返します。
	 */
	public function getimagescene () {}

	/**
	 * SHA-256 メッセージダイジェストを生成する
	 * @link http://www.php.net/manual/ja/imagick.getimagesignature.php
	 * @return string そのファイルの SHA-256 ハッシュを文字列で返します。
	 */
	public function getimagesignature () {}

	/**
	 * 画像の ticks-per-second を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagetickspersecond.php
	 * @return int 画像の ticks-per-second を返します。
	 */
	public function getimagetickspersecond () {}

	/**
	 * 画像の型を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagetype.php
	 * @return int 画像の型を返します。
	 * imagick::IMGTYPE_UNDEFINED
	 * imagick::IMGTYPE_BILEVEL
	 * imagick::IMGTYPE_GRAYSCALE
	 * imagick::IMGTYPE_GRAYSCALEMATTE
	 * imagick::IMGTYPE_PALETTE
	 * imagick::IMGTYPE_PALETTEMATTE
	 * imagick::IMGTYPE_TRUECOLOR
	 * imagick::IMGTYPE_TRUECOLORMATTE
	 * imagick::IMGTYPE_COLORSEPARATION
	 * imagick::IMGTYPE_COLORSEPARATIONMATTE
	 * imagick::IMGTYPE_OPTIMIZE
	 */
	public function getimagetype () {}

	/**
	 * 画像の解像度の単位を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimageunits.php
	 * @return int 画像の解像度の単位を返します。
	 */
	public function getimageunits () {}

	/**
	 * 仮想ピクセルメソッドを取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagevirtualpixelmethod.php
	 * @return int 成功した場合に仮想ピクセルメソッドを返します。
	 */
	public function getimagevirtualpixelmethod () {}

	/**
	 * 色度が白い点を返す
	 * @link http://www.php.net/manual/ja/imagick.getimagewhitepoint.php
	 * @return array 色度が白い点を返します。
	 * "x" および "y" というキーを持つ連想配列となります。
	 */
	public function getimagewhitepoint () {}

	/**
	 * 画像の幅を返す
	 * @link http://www.php.net/manual/ja/imagick.getimagewidth.php
	 * @return int 画像の幅を返します。
	 */
	public function getimagewidth () {}

	/**
	 * オブジェクト内の画像の数を返す
	 * @link http://www.php.net/manual/ja/imagick.getnumberimages.php
	 * @return int Imagick オブジェクトに関連付けられている画像の数を返します。
	 */
	public function getnumberimages () {}

	/**
	 * 画像の総インク密度を取得する
	 * @link http://www.php.net/manual/ja/imagick.getimagetotalinkdensity.php
	 * @return float 画像の総インク密度を返します。
	 * エラー時に
	 * ImagickException をスローします。
	 */
	public function getimagetotalinkdensity () {}

	/**
	 * 画像の一部を抽出する
	 * @link http://www.php.net/manual/ja/imagick.getimageregion.php
	 * @param width int <p>
	 * 抽出する範囲の幅。
	 * </p>
	 * @param height int <p>
	 * 抽出する範囲の高さ。
	 * </p>
	 * @param x int <p>
	 * 抽出する範囲の左上の X 座標。
	 * </p>
	 * @param y int <p>
	 * 抽出する範囲の左上の Y 座標。
	 * </p>
	 * @return Imagick 画像の一部を抽出し、新しい wand として返します。
	 */
	public function getimageregion ($width, $height, $x, $y) {}

	/**
	 * 新しい画像をコピーとして作成する
	 * @link http://www.php.net/manual/ja/imagick.implodeimage.php
	 * @param radius float <p>
	 * 内破処理の半径。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function implodeimage ($radius) {}

	/**
	 * 画像のレベルを調節する
	 * @link http://www.php.net/manual/ja/imagick.levelimage.php
	 * @param blackPoint float <p>
	 * 画像の黒の点。
	 * </p>
	 * @param gamma float <p>
	 * ガンマ値。
	 * </p>
	 * @param whitePoint float <p>
	 * 画像の白の点。
	 * </p>
	 * @param channel int[optional] <p>
	 * チャネルモードに対応したチャネル定数を指定します。
	 * 複数のチャネルに適用するには、
	 * ビット演算子でチャネル型定数を組み合わせます。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function levelimage ($blackPoint, $gamma, $whitePoint, $channel = null) {}

	/**
	 * 画像を 2 倍に比例拡大する
	 * @link http://www.php.net/manual/ja/imagick.magnifyimage.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function magnifyimage () {}

	/**
	 * 画像の色を、参照画像の中の最も近い色に置き換える
	 * @link http://www.php.net/manual/ja/imagick.mapimage.php
	 * @param map Imagick <p>
	 * </p>
	 * @param dither bool <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function mapimage (Imagick $map, $dither) {}

	/**
	 * 色の透明度を変更する
	 * @link http://www.php.net/manual/ja/imagick.mattefloodfillimage.php
	 * @param alpha float <p>
	 * 不透明度レベル。1.0 は完全な不透明、0.0 は完全な透明を表します。
	 * </p>
	 * @param fuzz float <p>
	 * 画像の fuzz 値。
	 * どの程度の色を「同じ色」とみなすかを表します。
	 * </p>
	 * @param bordercolor mixed <p>
	 * 輪郭の色を表す ImagickPixel オブジェクトあるいは文字列。
	 * </p>
	 * @param x int <p>
	 * 操作の開始位置の x 座標。
	 * </p>
	 * @param y int <p>
	 * 操作の開始位置の y 座標。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function mattefloodfillimage ($alpha, $fuzz, $bordercolor, $x, $y) {}

	/**
	 * デジタルフィルタを適用する
	 * @link http://www.php.net/manual/ja/imagick.medianfilterimage.php
	 * @param radius float <p>
	 * 近傍ピクセルの半径。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function medianfilterimage ($radius) {}

	/**
	 * 画像の色を打ち消す
	 * @link http://www.php.net/manual/ja/imagick.negateimage.php
	 * @param gray bool <p>
	 * 画像内のグレースケールのみを打ち消すのかどうか。
	 * </p>
	 * @param channel int[optional] <p>
	 * チャネルモードに対応したチャネル定数を指定します。
	 * 複数のチャネルに適用するには、
	 * ビット演算子でチャネル型定数を組み合わせます。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function negateimage ($gray, $channel = null) {}

	/**
	 * 色にマッチするピクセルを変更する
	 * @link http://www.php.net/manual/ja/imagick.paintopaqueimage.php
	 * @param target mixed <p>
	 * この対象色を変更すると、画像の塗りつぶし色が変わります。
	 * ImagickPixel オブジェクトあるいは文字列で対象色を指定します。
	 * </p>
	 * @param fill mixed <p>
	 * 塗りつぶし色を表す ImagickPixel オブジェクトあるいは文字列。
	 * </p>
	 * @param fuzz float <p>
	 * 画像の fuzz 値。
	 * どの程度の色を「同じ色」とみなすかを表します。
	 * </p>
	 * @param channel int[optional] <p>
	 * チャネルモードに対応したチャネル定数を指定します。
	 * 複数のチャネルに適用するには、
	 * ビット演算子でチャネル型定数を組み合わせます。
	 * チャネル定数
	 * の一覧を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function paintopaqueimage ($target, $fill, $fuzz, $channel = null) {}

	/**
	 * 色にマッチするピクセルを塗りつぶし色に変更する
	 * @link http://www.php.net/manual/ja/imagick.painttransparentimage.php
	 * @param target mixed <p>
	 * この対象色を変更して、画像の不透明度を指定します。
	 * </p>
	 * @param alpha float <p>
	 * 不透明度レベル。1.0 は完全な不透明、0.0 は完全な透明を表します。
	 * </p>
	 * @param fuzz float <p>
	 * 画像の fuzz 値。
	 * どの程度の色を「同じ色」とみなすかを表します。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function painttransparentimage ($target, $alpha, $fuzz) {}

	/**
	 * 画像処理用の適切なパラメータを手早く取得する
	 * @link http://www.php.net/manual/ja/imagick.previewimages.php
	 * @param preview int <p>
	 * プレビュー形式。プレビュー形式の定数
	 * を参照ください。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function previewimages ($preview) {}

	/**
	 * 画像のプロファイルを追加あるいは削除する
	 * @link http://www.php.net/manual/ja/imagick.profileimage.php
	 * @param name string <p>
	 * </p>
	 * @param profile string <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function profileimage ($name, $profile) {}

	/**
	 * 参照画像内の色を解析する
	 * @link http://www.php.net/manual/ja/imagick.quantizeimage.php
	 * @param numberColors int <p>
	 * </p>
	 * @param colorspace int <p>
	 * </p>
	 * @param treedepth int <p>
	 * </p>
	 * @param dither bool <p>
	 * </p>
	 * @param measureError bool <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function quantizeimage ($numberColors, $colorspace, $treedepth, $dither, $measureError) {}

	/**
	 * 画像シーケンス内の色を解析する
	 * @link http://www.php.net/manual/ja/imagick.quantizeimages.php
	 * @param numberColors int <p>
	 * </p>
	 * @param colorspace int <p>
	 * </p>
	 * @param treedepth int <p>
	 * </p>
	 * @param dither bool <p>
	 * </p>
	 * @param measureError bool <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function quantizeimages ($numberColors, $colorspace, $treedepth, $dither, $measureError) {}

	/**
	 * 画像の輪郭をなめらかにする
	 * @link http://www.php.net/manual/ja/imagick.reducenoiseimage.php
	 * @param radius float <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function reducenoiseimage ($radius) {}

	/**
	 * 指定した名前の画像プロファイルを削除してそれを返す
	 * @link http://www.php.net/manual/ja/imagick.removeimageprofile.php
	 * @param name string <p>
	 * </p>
	 * @return string 画像のプロファイル名を返します。
	 */
	public function removeimageprofile ($name) {}

	/**
	 * 画像からチャネルを分離する
	 * @link http://www.php.net/manual/ja/imagick.separateimagechannel.php
	 * @param channel int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function separateimagechannel ($channel) {}

	/**
	 * 画像をセピア調にする
	 * @link http://www.php.net/manual/ja/imagick.sepiatoneimage.php
	 * @param threshold float <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function sepiatoneimage ($threshold) {}

	/**
	 * 画像を折りたたむ任意のメソッドについて画像のバイアスを設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagebias.php
	 * @param bias float <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagebias ($bias) {}

	/**
	 * 青が一番強い点を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageblueprimary.php
	 * @param x float <p>
	 * </p>
	 * @param y float <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageblueprimary ($x, $y) {}

	/**
	 * 画像の前景色を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagebordercolor.php
	 * @param border mixed <p>
	 * 前景色。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagebordercolor ($border) {}

	/**
	 * 特定の画像チャネルの深度を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagechanneldepth.php
	 * @param channel int <p>
	 * </p>
	 * @param depth int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagechanneldepth ($channel, $depth) {}

	/**
	 * 指定した色マップインデックスの色を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagecolormapcolor.php
	 * @param index int <p>
	 * </p>
	 * @param color ImagickPixel <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagecolormapcolor ($index, ImagickPixel $color) {}

	/**
	 * 画像の色空間を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagecolorspace.php
	 * @param colorspace int <p>
	 * COLORSPACE 定数のいずれか。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagecolorspace ($colorspace) {}

	/**
	 * 画像の配置方法を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagedispose.php
	 * @param dispose int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagedispose ($dispose) {}

	/**
	 * 画像のサイズを設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageextent.php
	 * @param columns int <p>
	 * </p>
	 * @param rows int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageextent ($columns, $rows) {}

	/**
	 * 緑が一番強い点を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagegreenprimary.php
	 * @param x float <p>
	 * </p>
	 * @param y float <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagegreenprimary ($x, $y) {}

	/**
	 * 画像のインターレース手法を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageinterlacescheme.php
	 * @param interlace_scheme int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageinterlacescheme ($interlace_scheme) {}

	/**
	 * 指定した名前の画像プロファイルを Imagick オブジェクトに追加する
	 * @link http://www.php.net/manual/ja/imagick.setimageprofile.php
	 * @param name string <p>
	 * </p>
	 * @param profile string <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageprofile ($name, $profile) {}

	/**
	 * 赤が一番強い点を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimageredprimary.php
	 * @param x float <p>
	 * </p>
	 * @param y float <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimageredprimary ($x, $y) {}

	/**
	 * 画像のレンダリング方向を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagerenderingintent.php
	 * @param rendering_intent int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagerenderingintent ($rendering_intent) {}

	/**
	 * 画像の仮想ピクセルメソッドを設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagevirtualpixelmethod.php
	 * @param method int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagevirtualpixelmethod ($method) {}

	/**
	 * 画像の色度が白い点を設定する
	 * @link http://www.php.net/manual/ja/imagick.setimagewhitepoint.php
	 * @param x float <p>
	 * </p>
	 * @param y float <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimagewhitepoint ($x, $y) {}

	/**
	 * 画像のコントラストを調整する
	 * @link http://www.php.net/manual/ja/imagick.sigmoidalcontrastimage.php
	 * @param sharpen bool <p>
	 * </p>
	 * @param alpha float <p>
	 * </p>
	 * @param beta float <p>
	 * </p>
	 * @param channel int[optional] <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function sigmoidalcontrastimage ($sharpen, $alpha, $beta, $channel = null) {}

	/**
	 * ふたつの画像を合成する
	 * @link http://www.php.net/manual/ja/imagick.stereoimage.php
	 * @param offset_wand Imagick <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function stereoimage (Imagick $offset_wand) {}

	/**
	 * テクスチャ画像をタイル状に並べる
	 * @link http://www.php.net/manual/ja/imagick.textureimage.php
	 * @param texture_wand Imagick <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function textureimage (Imagick $texture_wand) {}

	/**
	 * 色ベクトルを画像の各ピクセルに適用する
	 * @link http://www.php.net/manual/ja/imagick.tintimage.php
	 * @param tint mixed <p>
	 * </p>
	 * @param opacity mixed <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function tintimage ($tint, $opacity) {}

	/**
	 * 画像をシャープにする
	 * @link http://www.php.net/manual/ja/imagick.unsharpmaskimage.php
	 * @param radius float <p>
	 * </p>
	 * @param sigma float <p>
	 * </p>
	 * @param amount float <p>
	 * </p>
	 * @param threshold float <p>
	 * </p>
	 * @param channel int[optional] <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function unsharpmaskimage ($radius, $sigma, $amount, $threshold, $channel = null) {}

	/**
	 * 新しい Imagick オブジェクトを返す
	 * @link http://www.php.net/manual/ja/imagick.getimage.php
	 * @return Imagick 現在の画像シーケンスを使用した新しい Imagick オブジェクトを返します。
	 */
	public function getimage () {}

	/**
	 * 新しい画像を Imagick オブジェクトの画像リストに追加する
	 * @link http://www.php.net/manual/ja/imagick.addimage.php
	 * @param source Imagick <p>
	 * 元の Imagick オブジェクト。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function addimage (Imagick $source) {}

	/**
	 * オブジェクト内の画像を置き換える
	 * @link http://www.php.net/manual/ja/imagick.setimage.php
	 * @param replace Imagick <p>
	 * 置き換える Imagick オブジェクト。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setimage (Imagick $replace) {}

	/**
	 * 新しい画像を作成する
	 * @link http://www.php.net/manual/ja/imagick.newimage.php
	 * @param cols int <p>
	 * 新しい画像のカラム数。
	 * </p>
	 * @param rows int <p>
	 * 新しい画像の行数。
	 * </p>
	 * @param background mixed <p>
	 * この画像で使用する背景色。
	 * </p>
	 * @param format string[optional] <p>
	 * 画像フォーマット。このパラメータは Imagick バージョン 2.0.1
	 * で追加されました。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function newimage ($cols, $rows, $background, $format = null) {}

	/**
	 * 新しい画像を作成する
	 * @link http://www.php.net/manual/ja/imagick.newpseudoimage.php
	 * @param columns int <p>
	 * 新しい画像のカラム数。
	 * </p>
	 * @param rows int <p>
	 * 新しい画像の行数。
	 * </p>
	 * @param pseudoString string <p>
	 * 疑似画像定義を含む文字列。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function newpseudoimage ($columns, $rows, $pseudoString) {}

	/**
	 * オブジェクトの圧縮形式を取得する
	 * @link http://www.php.net/manual/ja/imagick.getcompression.php
	 * @return int 圧縮定数を返します。
	 */
	public function getcompression () {}

	/**
	 * オブジェクトの圧縮品質を取得する
	 * @link http://www.php.net/manual/ja/imagick.getcompressionquality.php
	 * @return int 圧縮品質を表す整数値を返します。
	 */
	public function getcompressionquality () {}

	/**
	 * ImageMagick API の著作権情報を文字列で返す
	 * @link http://www.php.net/manual/ja/imagick.getcopyright.php
	 * @return string Imagemagick および Magickwand C API の著作権情報を含む文字列を返します。
	 */
	public function getcopyright () {}

	/**
	 * 画像シーケンスに関連付けられたファイル名を取得する
	 * @link http://www.php.net/manual/ja/imagick.getfilename.php
	 * @return string 成功した場合に文字列を返します。
	 */
	public function getfilename () {}

	/**
	 * Imagick オブジェクトのフォーマットを取得する
	 * @link http://www.php.net/manual/ja/imagick.getformat.php
	 * @return string 画像フォーマットを返します。
	 */
	public function getformat () {}

	/**
	 * ImageMagick のホーム URL を返す
	 * @link http://www.php.net/manual/ja/imagick.gethomeurl.php
	 * @return string imagemagick のホームページへのリンクを返します。
	 */
	public function gethomeurl () {}

	/**
	 * オブジェクトのインターレース方式を取得する
	 * @link http://www.php.net/manual/ja/imagick.getinterlacescheme.php
	 * @return int インターレース方式
	 * を返します。
	 */
	public function getinterlacescheme () {}

	/**
	 * 指定したキーに対応する値を返す
	 * @link http://www.php.net/manual/ja/imagick.getoption.php
	 * @param key string <p>
	 * オプションの名前。
	 * </p>
	 * @return string 指定したキーに対応する値を返します。
	 */
	public function getoption ($key) {}

	/**
	 * ImageMagick パッケージ名を返す
	 * @link http://www.php.net/manual/ja/imagick.getpackagename.php
	 * @return string ImageMagick パッケージ名を文字列で返します。
	 */
	public function getpackagename () {}

	/**
	 * ページのジオメトリを返す
	 * @link http://www.php.net/manual/ja/imagick.getpage.php
	 * @return array Imagick オブジェクトに関連付けられたページのジオメトリを返します。
	 * "width"、"height"、"x" そして "y" というキーを持つ連想配列となります。
	 * エラー時に ImagickException をスローします。
	 */
	public function getpage () {}

	/**
	 * quantum depth を取得する
	 * @link http://www.php.net/manual/ja/imagick.getquantumdepth.php
	 * @return array Imagick quantum depth を文字列で返します。
	 */
	public function getquantumdepth () {}

	/**
	 * Imagick quantum range を返す
	 * @link http://www.php.net/manual/ja/imagick.getquantumrange.php
	 * @return array Imagick quantum range を文字列で返します。
	 */
	public function getquantumrange () {}

	/**
	 * ImageMagick のリリース日を返す
	 * @link http://www.php.net/manual/ja/imagick.getreleasedate.php
	 * @return string ImageMagick のリリース日を文字列で返します。
	 */
	public function getreleasedate () {}

	/**
	 * 指定したリソースのメモリ使用状況を返す
	 * @link http://www.php.net/manual/ja/imagick.getresource.php
	 * @param type int <p>
	 * リソース型定数
	 * の一覧を参照ください。
	 * </p>
	 * @return int 指定したリソースのメモリ使用状況をメガバイト単位で返します。
	 */
	public function getresource ($type) {}

	/**
	 * 指定したリソースの制限を返す
	 * @link http://www.php.net/manual/ja/imagick.getresourcelimit.php
	 * @param type int <p>
	 * リソース型定数
	 * の一覧を参照ください。
	 * </p>
	 * @return int 指定したリソースの制限をメガバイト単位で返します。
	 */
	public function getresourcelimit ($type) {}

	/**
	 * 水平方向および垂直方向のサンプリング係数を取得する
	 * @link http://www.php.net/manual/ja/imagick.getsamplingfactors.php
	 * @return array 画像の水平方向および垂直方向のサンプリング係数を含む連想配列を返します。
	 */
	public function getsamplingfactors () {}

	/**
	 * Imagick オブジェクトのサイズを取得する
	 * @link http://www.php.net/manual/ja/imagick.getsize.php
	 * @return array Imagick オブジェクトのサイズを返します。
	 * "columns" および "rows" というキーを持つ連想配列となります。
	 */
	public function getsize () {}

	/**
	 * ImageMagick API のバージョンを返す
	 * @link http://www.php.net/manual/ja/imagick.getversion.php
	 * @return array ImageMagick API のバージョンを文字列と数値で返します。
	 */
	public function getversion () {}

	/**
	 * オブジェクトのデフォルト背景色を設定する
	 * @link http://www.php.net/manual/ja/imagick.setbackgroundcolor.php
	 * @param background mixed <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setbackgroundcolor ($background) {}

	/**
	 * オブジェクトのデフォルトの圧縮方式を設定する
	 * @link http://www.php.net/manual/ja/imagick.setcompression.php
	 * @param compression int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setcompression ($compression) {}

	/**
	 * オブジェクトのデフォルトの圧縮品質を設定する
	 * @link http://www.php.net/manual/ja/imagick.setcompressionquality.php
	 * @param quality int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setcompressionquality ($quality) {}

	/**
	 * 画像を読み書きする前にファイル名を設定する
	 * @link http://www.php.net/manual/ja/imagick.setfilename.php
	 * @param filename string <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setfilename ($filename) {}

	/**
	 * Imagick オブジェクトのフォーマットを設定する
	 * @link http://www.php.net/manual/ja/imagick.setformat.php
	 * @param format string <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setformat ($format) {}

	/**
	 * 画像の圧縮を設定する
	 * @link http://www.php.net/manual/ja/imagick.setinterlacescheme.php
	 * @param interlace_scheme int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setinterlacescheme ($interlace_scheme) {}

	/**
	 * オプションを設定する
	 * @link http://www.php.net/manual/ja/imagick.setoption.php
	 * @param key string <p>
	 * </p>
	 * @param value string <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setoption ($key, $value) {}

	/**
	 * Imagick オブジェクトのページジオメトリを設定する
	 * @link http://www.php.net/manual/ja/imagick.setpage.php
	 * @param width int <p>
	 * </p>
	 * @param height int <p>
	 * </p>
	 * @param x int <p>
	 * </p>
	 * @param y int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setpage ($width, $height, $x, $y) {}

	/**
	 * 特定のリソースの制限をメガバイト単位で設定する
	 * @link http://www.php.net/manual/ja/imagick.setresourcelimit.php
	 * @param type int <p>
	 * </p>
	 * @param limit int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setresourcelimit ($type, $limit) {}

	/**
	 * 画像の解像度を設定する
	 * @link http://www.php.net/manual/ja/imagick.setresolution.php
	 * @param x_resolution float <p>
	 * 水平方向の解像度。
	 * </p>
	 * @param y_resolution float <p>
	 * 垂直方向の解像度。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setresolution ($x_resolution, $y_resolution) {}

	/**
	 * 画像のサンプリング係数を設定する
	 * @link http://www.php.net/manual/ja/imagick.setsamplingfactors.php
	 * @param factors array <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setsamplingfactors (array $factors) {}

	/**
	 * Imagick オブジェクトのサイズを設定する
	 * @link http://www.php.net/manual/ja/imagick.setsize.php
	 * @param columns int <p>
	 * </p>
	 * @param rows int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setsize ($columns, $rows) {}

	/**
	 * 画像タイプ属性を設定する
	 * @link http://www.php.net/manual/ja/imagick.settype.php
	 * @param image_type int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function settype ($image_type) {}

	public function key () {}

	public function next () {}

	public function rewind () {}

	/**
	 * 現在のアイテムが有効かどうかを調べる
	 * @link http://www.php.net/manual/ja/imagick.valid.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function valid () {}

	/**
	 * 現在の Imagick オブジェクトへの参照を返す
	 * @link http://www.php.net/manual/ja/imagick.current.php
	 * @return Imagick 成功した場合に自分自身を返します。
	 */
	public function current () {}

}

class ImagickDraw  {

	public function resetvectorgraphics () {}

	public function gettextkerning () {}

	/**
	 * @param kerning
	 */
	public function settextkerning ($kerning) {}

	public function gettextinterwordspacing () {}

	/**
	 * @param spacing
	 */
	public function settextinterwordspacing ($spacing) {}

	public function gettextinterlinespacing () {}

	/**
	 * @param spacing
	 */
	public function settextinterlinespacing ($spacing) {}

	/**
	 * ImagickDraw コンストラクタ
	 * @link http://www.php.net/manual/ja/imagickdraw.construct.php
	 */
	public function __construct () {}

	/**
	 * オブジェクトの塗りつぶしに使用する色を設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setfillcolor.php
	 * @param fill_pixel ImagickPixel <p>
	 * 色を表す ImagickPixel。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setfillcolor (ImagickPixel $fill_pixel) {}

	/**
	 * 色やテクスチャによる塗りつぶしの際の透過度を設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setfillalpha.php
	 * @param opacity float <p>
	 * 塗りつぶしのアルファ値。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setfillalpha ($opacity) {}

	/**
	 * @param x_resolution
	 * @param y_resolution
	 */
	public function setresolution ($x_resolution, $y_resolution) {}

	/**
	 * オブジェクトの縁取りに使用する色を設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setstrokecolor.php
	 * @param stroke_pixel ImagickPixel <p>
	 * 縁取り色。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setstrokecolor (ImagickPixel $stroke_pixel) {}

	/**
	 * オブジェクトの枠線の透明度を指定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setstrokealpha.php
	 * @param opacity float <p>
	 * 透明度。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setstrokealpha ($opacity) {}

	/**
	 * オブジェクトの枠線の描画に使用する線の幅を設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setstrokewidth.php
	 * @param stroke_width float <p>
	 * 線の幅。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setstrokewidth ($stroke_width) {}

	/**
	 * ImagickDraw をクリアする
	 * @link http://www.php.net/manual/ja/imagickdraw.clear.php
	 * @return bool ImagickDraw オブジェクトを返します。
	 */
	public function clear () {}

	/**
	 * 円を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.circle.php
	 * @param ox float <p>
	 * 原点の x 座標。
	 * </p>
	 * @param oy float <p>
	 * 原点の y 座標。
	 * </p>
	 * @param px float <p>
	 * 周囲の x 座標。
	 * </p>
	 * @param py float <p>
	 * 周囲の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function circle ($ox, $oy, $px, $py) {}

	/**
	 * 画像上にテキストを描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.annotation.php
	 * @param x float <p>
	 * テキストを描画する x 座標。
	 * </p>
	 * @param y float <p>
	 * テキストを描画する y 座標。
	 * </p>
	 * @param text string <p>
	 * 画像上に描画するテキスト。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function annotation ($x, $y, $text) {}

	/**
	 * テキストをアンチエイリアス処理するかどうかを制御する
	 * @link http://www.php.net/manual/ja/imagickdraw.settextantialias.php
	 * @param antiAlias bool <p>
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function settextantialias ($antiAlias) {}

	/**
	 * テキストのコードセットを指定する
	 * @link http://www.php.net/manual/ja/imagickdraw.settextencoding.php
	 * @param encoding string <p>
	 * エンコーディング名。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function settextencoding ($encoding) {}

	/**
	 * テキストによる注記を行う際に使用するフォントを設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setfont.php
	 * @param font_name string <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setfont ($font_name) {}

	/**
	 * テキストによる注記を行う際に使用するフォントファミリーを設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setfontfamily.php
	 * @param font_family string <p>
	 * フォントファミリー。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setfontfamily ($font_family) {}

	/**
	 * テキストによる注記を行う際に使用するフォントのポイント数を設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setfontsize.php
	 * @param pointsize float <p>
	 * ポイント数。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setfontsize ($pointsize) {}

	/**
	 * テキストによる注記を行う際に使用するフォントのスタイルを設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setfontstyle.php
	 * @param style int <p>
	 * STYLETYPE_ 定数。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setfontstyle ($style) {}

	/**
	 * フォントの重さを設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setfontweight.php
	 * @param font_weight int <p>
	 * </p>
	 * @return bool 
	 */
	public function setfontweight ($font_weight) {}

	/**
	 * フォントを返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getfont.php
	 * @return string 成功した場合に文字列、フォントが設定されていない場合に false を返します。
	 */
	public function getfont () {}

	/**
	 * フォントファミリーを返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getfontfamily.php
	 * @return string 現在選択されているフォントファミリー、
	 * あるいはフォントファミリーが設定されていない場合に false を返します。
	 */
	public function getfontfamily () {}

	/**
	 * フォントのポイント数を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getfontsize.php
	 * @return float 現在の ImagickDraw オブジェクトに関連付けられているフォントのサイズを返します。
	 */
	public function getfontsize () {}

	/**
	 * フォントのスタイルを返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getfontstyle.php
	 * @return int ImagickDraw オブジェクトに関連付けられたフォントのスタイルを表す定数 (STYLE_)、
	 * あるいはスタイルが設定されていない場合に 0 を返します。
	 */
	public function getfontstyle () {}

	/**
	 * フォントの重さを返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getfontweight.php
	 * @return int 成功した場合に整数値、重さが設定されていない場合に 0 を返します。
	 */
	public function getfontweight () {}

	/**
	 * 関連付けられたすべてのリソースを開放する
	 * @link http://www.php.net/manual/ja/imagickdraw.destroy.php
	 * @return bool 値を返しません。
	 */
	public function destroy () {}

	/**
	 * 矩形を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.rectangle.php
	 * @param x1 float <p>
	 * 左上の角の x 座標。
	 * </p>
	 * @param y1 float <p>
	 * 左上の角の y 座標。
	 * </p>
	 * @param x2 float <p>
	 * 右下の角の x 座標。
	 * </p>
	 * @param y2 float <p>
	 * 右下の角の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function rectangle ($x1, $y1, $x2, $y2) {}

	/**
	 * 角が丸い矩形を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.roundrectangle.php
	 * @param x1 float <p>
	 * 左上の角の x 座標。
	 * </p>
	 * @param y1 float <p>
	 * 左上の角の y 座標。
	 * </p>
	 * @param x2 float <p>
	 * 右下の角の x 座標。
	 * </p>
	 * @param y2 float <p>
	 * 右下の角の y 座標。
	 * </p>
	 * @param rx float <p>
	 * x 方向の丸め。
	 * </p>
	 * @param ry float <p>
	 * y 方向の丸め。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function roundrectangle ($x1, $y1, $x2, $y2, $rx, $ry) {}

	/**
	 * 画像上に楕円を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.ellipse.php
	 * @param ox float <p>
	 * </p>
	 * @param oy float <p>
	 * </p>
	 * @param rx float <p>
	 * </p>
	 * @param ry float <p>
	 * </p>
	 * @param start float <p>
	 * </p>
	 * @param end float <p>
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function ellipse ($ox, $oy, $rx, $ry, $start, $end) {}

	/**
	 * 現在の座標系を水平方向に傾ける
	 * @link http://www.php.net/manual/ja/imagickdraw.skewx.php
	 * @param degrees float <p>
	 * 傾斜角。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function skewx ($degrees) {}

	/**
	 * 現在の座標系を垂直方向に傾ける
	 * @link http://www.php.net/manual/ja/imagickdraw.skewy.php
	 * @param degrees float <p>
	 * 傾斜角。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function skewy ($degrees) {}

	/**
	 * 現在の座標系に変換を適用する
	 * @link http://www.php.net/manual/ja/imagickdraw.translate.php
	 * @param x float <p>
	 * 水平方向の変換。
	 * </p>
	 * @param y float <p>
	 * 垂直方向の変換。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function translate ($x, $y) {}

	/**
	 * 直線を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.line.php
	 * @param sx float <p>
	 * 開始位置の x 座標。
	 * </p>
	 * @param sy float <p>
	 * 開始位置の y 座標。
	 * </p>
	 * @param ex float <p>
	 * 終了位置の x 座標。
	 * </p>
	 * @param ey float <p>
	 * 終了位置の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function line ($sx, $sy, $ex, $ey) {}

	/**
	 * 円弧を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.arc.php
	 * @param sx float <p>
	 * 矩形の開始位置の x 座標。
	 * </p>
	 * @param sy float <p>
	 * 矩形の開始位置の y 座標。
	 * </p>
	 * @param ex float <p>
	 * 矩形の終了位置の x 座標。
	 * </p>
	 * @param ey float <p>
	 * 矩形の終了位置の y 座標。
	 * </p>
	 * @param sd float <p>
	 * 開始位置の角度。
	 * </p>
	 * @param ed float <p>
	 * 終了位置の角度。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function arc ($sx, $sy, $ex, $ey, $sd, $ed) {}

	/**
	 * 画像の opacity チャネル上に描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.matte.php
	 * @param x float <p>
	 * マットの x 座標。
	 * </p>
	 * @param y float <p>
	 * マットの y 座標。
	 * </p>
	 * @param paintMethod int <p>
	 * PAINT_ 定数。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function matte ($x, $y, $paintMethod) {}

	/**
	 * 多角形を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.polygon.php
	 * @param coordinates array <p>
	 * 多次元配列。 array( array( 'x' => 3, 'y' => 4 ),
	 * array( 'x' => 2, 'y' => 6 ) ); のような形式となります。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function polygon (array $coordinates) {}

	/**
	 * 点を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.point.php
	 * @param x float <p>
	 * 点の x 座標。
	 * </p>
	 * @param y float <p>
	 * 点の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function point ($x, $y) {}

	/**
	 * テキストの装飾を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.gettextdecoration.php
	 * @return int DECORATION_ 定数のいずれか、あるいは装飾が設定されていない場合に
	 * 0 を返します。
	 */
	public function gettextdecoration () {}

	/**
	 * テキストによる注記の際に使用するコードセットを返す
	 * @link http://www.php.net/manual/ja/imagickdraw.gettextencoding.php
	 * @return string コードセットを表す文字列、
	 * あるいはエンコーディングが設定されていない場合に false を返します。
	 */
	public function gettextencoding () {}

	public function getfontstretch () {}

	/**
	 * テキストによる注記を行う際に使用するフォントの伸縮を設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setfontstretch.php
	 * @param fontStretch int <p>
	 * STRETCH_ 定数。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setfontstretch ($fontStretch) {}

	/**
	 * 縁取りの枠線をアンチエイリアス処理するかどうかを制御する
	 * @link http://www.php.net/manual/ja/imagickdraw.setstrokeantialias.php
	 * @param stroke_antialias bool <p>
	 * アンチエイリアス設定。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setstrokeantialias ($stroke_antialias) {}

	/**
	 * テキストの配置を指定する
	 * @link http://www.php.net/manual/ja/imagickdraw.settextalignment.php
	 * @param alignment int <p>
	 * ALIGN_ 定数。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function settextalignment ($alignment) {}

	/**
	 * 装飾を指定する
	 * @link http://www.php.net/manual/ja/imagickdraw.settextdecoration.php
	 * @param decoration int <p>
	 * DECORATION_ 定数。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function settextdecoration ($decoration) {}

	/**
	 * 背景の矩形の色を指定する
	 * @link http://www.php.net/manual/ja/imagickdraw.settextundercolor.php
	 * @param under_color ImagickPixel <p>
	 * 背景色。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function settextundercolor (ImagickPixel $under_color) {}

	/**
	 * キャンバス全体の大きさを設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setviewbox.php
	 * @param x1 int <p>
	 * 左の x 座標。
	 * </p>
	 * @param y1 int <p>
	 * 左の y 座標。
	 * </p>
	 * @param x2 int <p>
	 * 右の x 座標。
	 * </p>
	 * @param y2 int <p>
	 * 右の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setviewbox ($x1, $y1, $x2, $y2) {}

	/**
	 * 指定した ImagickDraw オブジェクトの完全なコピーを作成する
	 * @link http://www.php.net/manual/ja/imagickdraw.clone.php
	 * @return ImagickDraw What the function returns, first on success, then on failure. See
	 * also the &amp;return.success; entity
	 */
//	public function clone () {}

	/**
	 * 現在のアフィン変換行列を設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.affine.php
	 * @param affine array <p>
	 * アフィン行列のパラメータ。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function affine (array $affine) {}

	/**
	 * ベジエ曲線を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.bezier.php
	 * @param coordinates array <p>
	 * 多次元配列。array( array( 'x' => 1, 'y' => 2 ), array( 'x' => 3, 'y' => 4 ) ) 
	 * のような形式。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function bezier (array $coordinates) {}

	/**
	 * 現在の画像上に別の画像を合成する
	 * @link http://www.php.net/manual/ja/imagickdraw.composite.php
	 * @param compose int <p>
	 * 合成演算子。COMPOSITE_ 定数のいずれか。
	 * </p>
	 * @param x float <p>
	 * 左上角の x 座標。
	 * </p>
	 * @param y float <p>
	 * 左上角の y 座標。
	 * </p>
	 * @param width float <p>
	 * 合成する画像の幅。
	 * </p>
	 * @param height float <p>
	 * 合成する画像の高さ。
	 * </p>
	 * @param compositeWand Imagick <p>
	 * 合成する画像を取得する Imagick オブジェクト。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function composite ($compose, $x, $y, $width, $height, Imagick $compositeWand) {}

	/**
	 * 画像上に色を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.color.php
	 * @param x float <p>
	 * 描画位置の x 座標。
	 * </p>
	 * @param y float <p>
	 * 描画位置の y 座標。
	 * </p>
	 * @param paintMethod int <p>
	 * PAINT_ 定数のいずれか。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function color ($x, $y, $paintMethod) {}

	/**
	 * コメントを追加する
	 * @link http://www.php.net/manual/ja/imagickdraw.comment.php
	 * @param comment string <p>
	 * ベクター出力ストリームに追加するコメント文字列。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function comment ($comment) {}

	/**
	 * 現在のクリッピングパスの ID を取得する
	 * @link http://www.php.net/manual/ja/imagickdraw.getclippath.php
	 * @return string クリッピングパスの ID を含む文字列、あるいはパスが存在しない場合に false を返します。
	 */
	public function getclippath () {}

	/**
	 * 現在の多角形塗りつぶしルールを返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getcliprule.php
	 * @return int FILLRULE_ 定数のいずれかを返します。
	 */
	public function getcliprule () {}

	/**
	 * クリップパスの単位の解釈を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getclipunits.php
	 * @return int 成功した場合に整数値を返します。
	 */
	public function getclipunits () {}

	/**
	 * 塗りつぶし色を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getfillcolor.php
	 * @return ImagickPixel ImagickPixel オブジェクトを返します。
	 */
	public function getfillcolor () {}

	/**
	 * 描画時の透過度を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getfillopacity.php
	 * @return float 透過度を返します。
	 */
	public function getfillopacity () {}

	/**
	 * 塗りつぶしルールを返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getfillrule.php
	 * @return int FILLRULE_ 定数を返します。
	 */
	public function getfillrule () {}

	/**
	 * テキストの配置時の gravity を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getgravity.php
	 * @return int 成功した場合に GRAVITY_ 定数、gravity が設定されていない場合に 0 を返します。
	 */
	public function getgravity () {}

	/**
	 * 現在の縁取りのアンチエイリアス設定を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getstrokeantialias.php
	 * @return bool アンチエイリアスがオンの場合に TRUE、オフの場合に false を返します。
	 */
	public function getstrokeantialias () {}

	/**
	 * オブジェクトの縁取りに使用する色を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getstrokecolor.php
	 * @return ImagickPixel 色を表す ImagickPixel オブジェクトを返します。
	 */
	public function getstrokecolor () {}

	/**
	 * パスの描画に使用する破線のパターンを表す配列を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getstrokedasharray.php
	 * @return array 成功した場合に配列、設定されていない場合は空の配列を返します。
	 */
	public function getstrokedasharray () {}

	/**
	 * 破線パターンにおける破線の開始オフセットを返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getstrokedashoffset.php
	 * @return float オフセットを表す float 値、あるいは設定されていない場合に 0 を返します。
	 */
	public function getstrokedashoffset () {}

	/**
	 * 開かれたサブパスを描画する際に使用する端点の形状を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getstrokelinecap.php
	 * @return int LINECAP_ 定数のいずれか、あるいは設定されていない場合に 0 を返します。
	 */
	public function getstrokelinecap () {}

	/**
	 * パスの角を描画する際に使用する形状を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getstrokelinejoin.php
	 * @return int LINEJOIN_ 定数のいずれか、あるいは設定されていない場合に 0 を返します。
	 */
	public function getstrokelinejoin () {}

	/**
	 * マイターリミットを返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getstrokemiterlimit.php
	 * @return int マイターリミットを表す整数値、あるいは
	 * マイターリミットが設定されていない場合に 0 を返します。
	 */
	public function getstrokemiterlimit () {}

	/**
	 * オブジェクトの枠線の透明度を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getstrokeopacity.php
	 * @return float 透明度を表す double 値を返します。
	 */
	public function getstrokeopacity () {}

	/**
	 * オブジェクトの枠線の描画に使用する線の幅を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getstrokewidth.php
	 * @return float 線幅を表す double 値を返します。
	 */
	public function getstrokewidth () {}

	/**
	 * テキストの配置を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.gettextalignment.php
	 * @return int ALIGN_ 定数のいずれか、あるいは設定されていない場合に 0 を返します。
	 */
	public function gettextalignment () {}

	/**
	 * 現在のテキストのアンチエイリアス設定を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.gettextantialias.php
	 * @return bool テキストをアンチエイリアス処理する場合に true、しない場合に false を返します。
	 */
	public function gettextantialias () {}

	/**
	 * ベクターグラフィックを含む文字列を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.getvectorgraphics.php
	 * @return string ベクターグラフィックを文字列で返します。
	 */
	public function getvectorgraphics () {}

	/**
	 * テキストの背景色を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.gettextundercolor.php
	 * @return ImagickPixel 色を表す ImagickPixel オブジェクトを返します。
	 */
	public function gettextundercolor () {}

	/**
	 * パス要素を現在のパスに追加する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathclose.php
	 * @return bool 値を返しません。
	 */
	public function pathclose () {}

	/**
	 * 三次ベジエ曲線を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathcurvetoabsolute.php
	 * @param x1 float <p>
	 * 最初の制御点の x 座標。
	 * </p>
	 * @param y1 float <p>
	 * 最初の制御点の y 座標。
	 * </p>
	 * @param x2 float <p>
	 * 2 番目の制御点の x 座標。
	 * </p>
	 * @param y2 float <p>
	 * 2 番目の制御点の y 座標。
	 * </p>
	 * @param x float <p>
	 * 終点の x 座標。
	 * </p>
	 * @param y float <p>
	 * 終点の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathcurvetoabsolute ($x1, $y1, $x2, $y2, $x, $y) {}

	/**
	 * 三次ベジエ曲線を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathcurvetorelative.php
	 * @param x1 float <p>
	 * 開始制御点の x 座標。
	 * </p>
	 * @param y1 float <p>
	 * 開始制御点の y 座標。
	 * </p>
	 * @param x2 float <p>
	 * 終了制御点の x 座標。
	 * </p>
	 * @param y2 float <p>
	 * 終了制御点の y 座標。
	 * </p>
	 * @param x float <p>
	 * 終点の x 座標。
	 * </p>
	 * @param y float <p>
	 * 終点の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathcurvetorelative ($x1, $y1, $x2, $y2, $x, $y) {}

	/**
	 * 二次ベジエ曲線を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathcurvetoquadraticbezierabsolute.php
	 * @param x1 float <p>
	 * 制御点の x 座標。
	 * </p>
	 * @param y1 float <p>
	 * 制御点の y 座標。
	 * </p>
	 * @param x float <p>
	 * 終点の x 座標。
	 * </p>
	 * @param y float <p>
	 * 終点の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathcurvetoquadraticbezierabsolute ($x1, $y1, $x, $y) {}

	/**
	 * 二次ベジエ曲線を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathcurvetoquadraticbezierrelative.php
	 * @param x1 float <p>
	 * 始点の x 座標。
	 * </p>
	 * @param y1 float <p>
	 * 始点の y 座標。
	 * </p>
	 * @param x float <p>
	 * 終点の x 座標。
	 * </p>
	 * @param y float <p>
	 * 終点の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathcurvetoquadraticbezierrelative ($x1, $y1, $x, $y) {}

	/**
	 * 二次ベジエ曲線を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathcurvetoquadraticbeziersmoothabsolute.php
	 * @param x float <p>
	 * 終点の x 座標。
	 * </p>
	 * @param y float <p>
	 * 終点の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathcurvetoquadraticbeziersmoothabsolute ($x, $y) {}

	/**
	 * 二次ベジエ曲線を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathcurvetoquadraticbeziersmoothrelative.php
	 * @param x float <p>
	 * 終点の x 座標。
	 * </p>
	 * @param y float <p>
	 * 終点の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathcurvetoquadraticbeziersmoothrelative ($x, $y) {}

	/**
	 * 三次ベジエ曲線を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathcurvetosmoothabsolute.php
	 * @param x2 float <p>
	 * 2 番目の制御点の x 座標。
	 * </p>
	 * @param y2 float <p>
	 * 2 番目の制御点の y 座標。
	 * </p>
	 * @param x float <p>
	 * 終点の x 座標。
	 * </p>
	 * @param y float <p>
	 * 終点の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathcurvetosmoothabsolute ($x2, $y2, $x, $y) {}

	/**
	 * 三次ベジエ曲線を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathcurvetosmoothrelative.php
	 * @param x2 float <p>
	 * 2 番目の制御点の x 座標。
	 * </p>
	 * @param y2 float <p>
	 * 2 番目の制御点の y 座標。
	 * </p>
	 * @param x float <p>
	 * 終点の x 座標。
	 * </p>
	 * @param y float <p>
	 * 終点の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathcurvetosmoothrelative ($x2, $y2, $x, $y) {}

	/**
	 * 楕円弧を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathellipticarcabsolute.php
	 * @param rx float <p>
	 * x 方向の半径。
	 * </p>
	 * @param ry float <p>
	 * y 方向の半径。
	 * </p>
	 * @param x_axis_rotation float <p>
	 * x 軸の回転。
	 * </p>
	 * @param large_arc_flag bool <p>
	 * large arc フラグ。
	 * </p>
	 * @param sweep_flag bool <p>
	 * sweep フラグ。
	 * </p>
	 * @param x float <p>
	 * x 座標。
	 * </p>
	 * @param y float <p>
	 * y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathellipticarcabsolute ($rx, $ry, $x_axis_rotation, $large_arc_flag, $sweep_flag, $x, $y) {}

	/**
	 * 楕円弧を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathellipticarcrelative.php
	 * @param rx float <p>
	 * x 方向の半径。
	 * </p>
	 * @param ry float <p>
	 * y 方向の半径。
	 * </p>
	 * @param x_axis_rotation float <p>
	 * x 軸の回転。
	 * </p>
	 * @param large_arc_flag bool <p>
	 * large arc フラグ。
	 * </p>
	 * @param sweep_flag bool <p>
	 * sweep フラグ。
	 * </p>
	 * @param x float <p>
	 * x 座標。
	 * </p>
	 * @param y float <p>
	 * y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathellipticarcrelative ($rx, $ry, $x_axis_rotation, $large_arc_flag, $sweep_flag, $x, $y) {}

	/**
	 * 現在のパスを終了する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathfinish.php
	 * @return bool 値を返しません。
	 */
	public function pathfinish () {}

	/**
	 * 直線パスを描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathlinetoabsolute.php
	 * @param x float <p>
	 * 始点の x 座標。
	 * </p>
	 * @param y float <p>
	 * 終点の x 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathlinetoabsolute ($x, $y) {}

	/**
	 * 直線パスを描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathlinetorelative.php
	 * @param x float <p>
	 * 始点の x 座標。
	 * </p>
	 * @param y float <p>
	 * 始点の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathlinetorelative ($x, $y) {}

	/**
	 * 水平直線パスを描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathlinetohorizontalabsolute.php
	 * @param x float <p>
	 * x 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathlinetohorizontalabsolute ($x) {}

	/**
	 * 水平直線パスを描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathlinetohorizontalrelative.php
	 * @param x float <p>
	 * x 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathlinetohorizontalrelative ($x) {}

	/**
	 * 垂直直線パスを描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathlinetoverticalabsolute.php
	 * @param y float <p>
	 * y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathlinetoverticalabsolute ($y) {}

	/**
	 * 垂直直線パスを描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathlinetoverticalrelative.php
	 * @param y float <p>
	 * y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathlinetoverticalrelative ($y) {}

	/**
	 * 新しいサブパスを開始する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathmovetoabsolute.php
	 * @param x float <p>
	 * 始点の x 座標。
	 * </p>
	 * @param y float <p>
	 * 始点の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathmovetoabsolute ($x, $y) {}

	/**
	 * 新しいサブパスを開始する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathmovetorelative.php
	 * @param x float <p>
	 * 始点の x 座標。
	 * </p>
	 * @param y float <p>
	 * 始点の y 座標。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pathmovetorelative ($x, $y) {}

	/**
	 * パス描画リストの開始を宣言する
	 * @link http://www.php.net/manual/ja/imagickdraw.pathstart.php
	 * @return bool 値を返しません。
	 */
	public function pathstart () {}

	/**
	 * 線分群を描画する
	 * @link http://www.php.net/manual/ja/imagickdraw.polyline.php
	 * @param coordinates array <p>
	 * x 座標および y 座標の配列。
	 * array( array( 'x' => 4, 'y' => 6 ), array( 'x' => 8, 'y' => 10 ) )
	 * のような形式となります。 
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function polyline (array $coordinates) {}

	/**
	 * クリップパスの定義を終了する
	 * @link http://www.php.net/manual/ja/imagickdraw.popclippath.php
	 * @return bool 値を返しません。
	 */
	public function popclippath () {}

	/**
	 * 定義リストを終了する
	 * @link http://www.php.net/manual/ja/imagickdraw.popdefs.php
	 * @return bool 値を返しません。
	 */
	public function popdefs () {}

	/**
	 * パターン定義を終了する
	 * @link http://www.php.net/manual/ja/imagickdraw.poppattern.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function poppattern () {}

	/**
	 * クリップパスの定義を開始する
	 * @link http://www.php.net/manual/ja/imagickdraw.pushclippath.php
	 * @param clip_mask_id string <p>
	 * クリップマスク ID。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function pushclippath ($clip_mask_id) {}

	/**
	 * 後に続くコマンドが、処理の前に名前つき要素を作成することを示す
	 * @link http://www.php.net/manual/ja/imagickdraw.pushdefs.php
	 * @return bool 値を返しません。
	 */
	public function pushdefs () {}

	/**
	 * 後に続く ImagickDraw::opPattern() までのコマンドが、名前付きパターンを構成することを示す
	 * @link http://www.php.net/manual/ja/imagickdraw.pushpattern.php
	 * @param pattern_id string <p>
	 * パターン ID。
	 * </p>
	 * @param x float <p>
	 * 左上の角の x 座標。
	 * </p>
	 * @param y float <p>
	 * 左上の角の y 座標。
	 * </p>
	 * @param width float <p>
	 * パターンの幅。
	 * </p>
	 * @param height float <p>
	 * パターンの高さ。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function pushpattern ($pattern_id, $x, $y, $width, $height) {}

	/**
	 * これまでのすべての描画コマンドを画像上にレンダリングする
	 * @link http://www.php.net/manual/ja/imagickdraw.render.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function render () {}

	/**
	 * 指定した回転を現在の座標空間に適用する
	 * @link http://www.php.net/manual/ja/imagickdraw.rotate.php
	 * @param degrees float <p>
	 * 回転角度。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function rotate ($degrees) {}

	/**
	 * 倍率を調整する
	 * @link http://www.php.net/manual/ja/imagickdraw.scale.php
	 * @param x float <p>
	 * 水平方向の拡大率。
	 * </p>
	 * @param y float <p>
	 * 垂直方向の拡大率。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function scale ($x, $y) {}

	/**
	 * 指定した名前のクリッピングパスを画像に関連付ける
	 * @link http://www.php.net/manual/ja/imagickdraw.setclippath.php
	 * @param clip_mask string <p>
	 * クリッピングパスの名前。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setclippath ($clip_mask) {}

	/**
	 * クリッピングパスで使用する多角形塗りつぶしルールを設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setcliprule.php
	 * @param fill_rule int <p>
	 * FILLRULE_ 定数。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setcliprule ($fill_rule) {}

	/**
	 * クリップパスの単位の解釈を設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setclipunits.php
	 * @param clip_units int <p>
	 * クリップ単位の数。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setclipunits ($clip_units) {}

	/**
	 * 色やテクスチャによる塗りつぶしの際の透過度を設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setfillopacity.php
	 * @param fillOpacity float <p>
	 * 塗りつぶしの透明度。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setfillopacity ($fillOpacity) {}

	/**
	 * オブジェクトの塗りつぶしパターンとして使用する URL を設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setfillpatternurl.php
	 * @param fill_url string <p>
	 * 塗りつぶしパターンを取得する URL。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setfillpatternurl ($fill_url) {}

	/**
	 * 多角形の描画時に使用する塗りつぶしルールを設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setfillrule.php
	 * @param fill_rule int <p>
	 * FILLRULE_ 定数。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setfillrule ($fill_rule) {}

	/**
	 * テキストの配置時の gravity を設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setgravity.php
	 * @param gravity int <p>
	 * GRAVITY_ 定数。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setgravity ($gravity) {}

	/**
	 * オブジェクトの枠線の描画に使用するパターンを設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setstrokepatternurl.php
	 * @param stroke_url string <p>
	 * URL。
	 * </p>
	 * @return bool imagick.imagickdraw.return.success;
	 */
	public function setstrokepatternurl ($stroke_url) {}

	/**
	 * 破線パターンにおける破線の開始オフセットを指定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setstrokedashoffset.php
	 * @param dash_offset float <p>
	 * 破線のオフセット。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setstrokedashoffset ($dash_offset) {}

	/**
	 * 開かれたサブパスを描画する際に使用する端点の形状を指定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setstrokelinecap.php
	 * @param linecap int <p>
	 * LINECAP_ 定数。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setstrokelinecap ($linecap) {}

	/**
	 * パスの角を描画する際に使用する形状を指定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setstrokelinejoin.php
	 * @param linejoin int <p>
	 * LINEJOIN_ 定数。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setstrokelinejoin ($linejoin) {}

	/**
	 * マイターリミットを指定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setstrokemiterlimit.php
	 * @param miterlimit int <p>
	 * マイターリミット。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setstrokemiterlimit ($miterlimit) {}

	/**
	 * オブジェクトの枠線の透明度を指定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setstrokeopacity.php
	 * @param stroke_opacity float <p>
	 * 枠線の透明度。1.0 は完全に不透明な状態です。
	 * </p>
	 * @return bool 値を返しません。
	 */
	public function setstrokeopacity ($stroke_opacity) {}

	/**
	 * ベクターグラフィックを設定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setvectorgraphics.php
	 * @param xml string <p>
	 * ベクターグラフィックを表す xml。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setvectorgraphics ($xml) {}

	/**
	 * スタック内の現在の ImagickDraw を破棄し、事前に push された ImagickDraw を返す
	 * @link http://www.php.net/manual/ja/imagickdraw.pop.php
	 * @return bool 成功した場合に TRUE、失敗した場合に false を返します。
	 */
	public function pop () {}

	/**
	 * 現在の ImagickDraw をコピーしてスタックに格納する
	 * @link http://www.php.net/manual/ja/imagickdraw.push.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function push () {}

	/**
	 * パスの描画に使用する破線のパターンを指定する
	 * @link http://www.php.net/manual/ja/imagickdraw.setstrokedasharray.php
	 * @param dashArray array <p>
	 * float の配列。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setstrokedasharray (array $dashArray) {}

}

class ImagickPixelIterator implements Iterator, Traversable {

	/**
	 * ImagickPixelIterator のコンストラクタ
	 * @link http://www.php.net/manual/ja/imagickpixeliterator.construct.php
	 * @param Imagick Imagick
	 */
	public function __construct (Imagick $Imagick) {}

	/**
	 * 新しい pixel iterator を返す
	 * @link http://www.php.net/manual/ja/imagickpixeliterator.newpixeliterator.php
	 * @param wand Imagick 
	 * @return bool 成功した場合に TRUE を返します。
	 * ImagickPixelIteratorException をスローします。
	 */
	public function newpixeliterator (Imagick $wand) {}

	/**
	 * 新しい pixel iterator を返す
	 * @link http://www.php.net/manual/ja/imagickpixeliterator.newpixelregioniterator.php
	 * @param wand Imagick <p>
	 * </p>
	 * @param x int <p>
	 * </p>
	 * @param y int <p>
	 * </p>
	 * @param columns int <p>
	 * </p>
	 * @param rows int <p>
	 * </p>
	 * @return bool 成功した場合に新しい ImagickPixelIterator を返します。
	 * 失敗した場合は ImagickPixelIteratorException をスローします。
	 */
	public function newpixelregioniterator (Imagick $wand, $x, $y, $columns, $rows) {}

	/**
	 * pixel iterator の現在の行を返す
	 * @link http://www.php.net/manual/ja/imagickpixeliterator.getiteratorrow.php
	 * @return int pixel iterator の現在の行を返します。
	 * エラー時には ImagickPixelIteratorException をスローします。
	 */
	public function getiteratorrow () {}

	/**
	 * pixel iterator の行を設定する
	 * @link http://www.php.net/manual/ja/imagickpixeliterator.setiteratorrow.php
	 * @param row int <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setiteratorrow ($row) {}

	/**
	 * pixel iterator を最初の行に設定する
	 * @link http://www.php.net/manual/ja/imagickpixeliterator.setiteratorfirstrow.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setiteratorfirstrow () {}

	/**
	 * pixel iterator を最後の行に設定する
	 * @link http://www.php.net/manual/ja/imagickpixeliterator.setiteratorlastrow.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setiteratorlastrow () {}

	/**
	 * 前の行を返す
	 * @link http://www.php.net/manual/ja/imagickpixeliterator.getpreviousiteratorrow.php
	 * @return array ImagickPixelIterator の前の行を、ImagickPixelWand
	 * オブジェクトの配列として返します。エラー時には
	 * ImagickPixelIteratorException をスローします。
	 */
	public function getpreviousiteratorrow () {}

	/**
	 * ImagickPixel オブジェクトのの現在の行を返す
	 * @link http://www.php.net/manual/ja/imagickpixeliterator.getcurrentiteratorrow.php
	 * @return array ImagickPixel オブジェクトの配列形式で行を返します。これを順次処理することが可能です。
	 */
	public function getcurrentiteratorrow () {}

	/**
	 * pixel iterator の次の行を返す
	 * @link http://www.php.net/manual/ja/imagickpixeliterator.getnextiteratorrow.php
	 * @return array 次の行を ImagickPixel オブジェクトの配列で返します。
	 * エラー時には ImagickPixelIteratorException をスローします。
	 */
	public function getnextiteratorrow () {}

	/**
	 * pixel iterator をリセットする
	 * @link http://www.php.net/manual/ja/imagickpixeliterator.resetiterator.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function resetiterator () {}

	/**
	 * pixel iterator を同期する
	 * @link http://www.php.net/manual/ja/imagickpixeliterator.synciterator.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function synciterator () {}

	/**
	 * PixelIterator に関連付けられているリソースの割り当てを解除する
	 * @link http://www.php.net/manual/ja/imagickpixeliterator.destroy.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function destroy () {}

	/**
	 * PixelIterator に関連付けられたリソースを消去する
	 * @link http://www.php.net/manual/ja/imagickpixeliterator.clear.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function clear () {}

	public function key () {}

	public function next () {}

	public function rewind () {}

	public function current () {}

	public function valid () {}

}

class ImagickPixel  {

	/**
	 * ImagickPixel オブジェクトの HSL カラーを正規化したものを返す
	 * @link http://www.php.net/manual/ja/imagickpixel.gethsl.php
	 * @return array HSL の値をそれぞれ "hue"、
	 * "saturation"、そして "luminosity" というキーに保持する配列を返します。
	 * 失敗した場合に ImagickPixelException をスローします。
	 */
	public function gethsl () {}

	/**
	 * 正規化した HSL カラーを設定する
	 * @link http://www.php.net/manual/ja/imagickpixel.sethsl.php
	 * @param hue float <p>
	 * 色相を正規化した値。これは、色相環上での位置
	 * (0 から 1 まで) を表します。ゼロは赤です。
	 * </p>
	 * @param saturation float <p>
	 * 彩度を正規化した値。1 が最大です。
	 * </p>
	 * @param luminosity float <p>
	 * 明度を正規化した値。黒が 0、白が 1 で、
	 * 0.5 にすると完全な HS 値が再現されます。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function sethsl ($hue, $saturation, $luminosity) {}

	public function getcolorvaluequantum () {}

	/**
	 * @param color_value
	 */
	public function setcolorvaluequantum ($color_value) {}

	public function getindex () {}

	/**
	 * @param index
	 */
	public function setindex ($index) {}

	/**
	 * ImagickPixel のコンストラクタ
	 * @link http://www.php.net/manual/ja/imagickpixel.construct.php
	 * @param color[optional]
	 */
	public function __construct ($color) {}

	/**
	 * 色を設定する
	 * @link http://www.php.net/manual/ja/imagickpixel.setcolor.php
	 * @param color string <p>
	 * ImagickPixel オブジェクトを初期化する際に使用する色。
	 * </p>
	 * @return bool 色が設定できた場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function setcolor ($color) {}

	/**
	 * 指定したチャネルの正規化した値を設定する
	 * @link http://www.php.net/manual/ja/imagickpixel.setcolorvalue.php
	 * @param color int <p>
	 * Imagick 色チャネル定数のいずれか。
	 * </p>
	 * @param value float <p>
	 * そのチャネルに設定する値。0 から 1 までとなります。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function setcolorvalue ($color, $value) {}

	/**
	 * 指定した色チャネルの値を正規化したものを取得する
	 * @link http://www.php.net/manual/ja/imagickpixel.getcolorvalue.php
	 * @param color int <p>
	 * 調べたいチャネル。Imagick のチャネル定数で指定します。
	 * </p>
	 * @return float チャネルの値を正規化した浮動小数点数値を返します。
	 * エラー時には ImagickPixelException をスローします。
	 */
	public function getcolorvalue ($color) {}

	/**
	 * このオブジェクトに関連付けられたリソースを消去する
	 * @link http://www.php.net/manual/ja/imagickpixel.clear.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function clear () {}

	/**
	 * このオブジェクトに関連付けられているリソースの割り当てを解除する
	 * @link http://www.php.net/manual/ja/imagickpixel.destroy.php
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function destroy () {}

	/**
	 * この色と別の色の差を調べる
	 * @link http://www.php.net/manual/ja/imagickpixel.issimilar.php
	 * @param color ImagickPixel <p>
	 * このオブジェクトと比較したい ImagickPixel オブジェクト。
	 * </p>
	 * @param fuzz float <p>
	 * 同じ色であるとみなす最大の誤差。
	 * 理論上の最大値は、3 の平方根 (1.732) となります。
	 * </p>
	 * @return bool 成功した場合に TRUE を返します。
	 */
	public function issimilar (ImagickPixel $color, $fuzz) {}

	/**
	 * 色を返す
	 * @link http://www.php.net/manual/ja/imagickpixel.getcolor.php
	 * @param normalized bool[optional] <p>
	 * 色を正規化する。
	 * </p>
	 * @return array 各チャネルの値を配列で返します。パラメータに TRUE
	 * を指定した場合は、各値を正規化します。エラー時には
	 * ImagickPixelException をスローします。
	 */
	public function getcolor ($normalized = null) {}

	/**
	 * 色を文字列で返す
	 * @link http://www.php.net/manual/ja/imagickpixel.getcolorasstring.php
	 * @return string ImagickPixel オブジェクトの色を文字列で返します。
	 */
	public function getcolorasstring () {}

	/**
	 * この色に関連付けられている色カウントを返す
	 * @link http://www.php.net/manual/ja/imagickpixel.getcolorcount.php
	 * @return int 成功した場合に色数を返します。失敗した場合に
	 * ImagickPixelException をスローします。
	 */
	public function getcolorcount () {}

	/**
	 * @param colorCount
	 */
	public function setcolorcount ($colorCount) {}

//	public function clone () {}

}
// End of imagick v.@PACKAGE_VERSION@
?>
