<?php

// Start of Core v.5.4.11

class stdClass  {
}

interface Traversable  {
}

interface IteratorAggregate extends Traversable {

	abstract public function getIterator () {}

}

interface Iterator extends Traversable {

	abstract public function current () {}

	abstract public function next () {}

	abstract public function key () {}

	abstract public function valid () {}

	abstract public function rewind () {}

}

interface ArrayAccess  {

	/**
	 * @param offset
	 */
	abstract public function offsetExists ($offset) {}

	/**
	 * @param offset
	 */
	abstract public function offsetGet ($offset) {}

	/**
	 * @param offset
	 * @param value
	 */
	abstract public function offsetSet ($offset, $value) {}

	/**
	 * @param offset
	 */
	abstract public function offsetUnset ($offset) {}

}

interface Serializable  {

	abstract public function serialize () {}

	/**
	 * @param serialized
	 */
	abstract public function unserialize ($serialized) {}

}

class Exception  {
	protected $message;
	private $string;
	protected $code;
	protected $file;
	protected $line;
	private $trace;
	private $previous;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class ErrorException extends Exception  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;
	protected $severity;


	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param severity[optional]
	 * @param filename[optional]
	 * @param lineno[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $severity, $filename, $lineno, $previous) {}

	final public function getSeverity () {}

	final private function __clone () {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

final class Closure  {

	private function __construct () {}

	/**
	 * @param closure
	 * @param newthis
	 * @param newscope[optional]
	 */
	public static function bind ($closure, $newthis, $newscope) {}

	/**
	 * @param newthis
	 * @param newscope[optional]
	 */
	public function bindTo ($newthis, $newscope) {}

}

/**
 * 現在の Zend Engine のバージョンを取得する
 * @link http://www.php.net/manual/ja/function.zend-version.php
 * @return string Zend Engine のバージョン番号を文字列で返します。
 */
function zend_version () {}

/**
 * 関数に渡された引数の数を返す
 * @link http://www.php.net/manual/ja/function.func-num-args.php
 * @return int 現在のユーザー定義関数に渡された引数の数を返します。
 */
function func_num_args () {}

/**
 * 引数のリストから要素をひとつ返す
 * @link http://www.php.net/manual/ja/function.func-get-arg.php
 * @param arg_num int <p>
 * 引数の位置。関数の引数はゼロから数え始めます。
 * </p>
 * @return mixed 指定した引数、あるいはエラー時に FALSE を返します。
 */
function func_get_arg ($arg_num) {}

/**
 * 関数の引数リストを配列として返す
 * @link http://www.php.net/manual/ja/function.func-get-args.php
 * @return array 配列を返します。この配列の各要素は、
 * 現在のユーザー定義関数の引数リストにおける対応するメンバのコピーとなります。
 */
function func_get_args () {}

/**
 * 文字列の長さを得る
 * @link http://www.php.net/manual/ja/function.strlen.php
 * @param string string <p>
 * 長さを調べる文字列。
 * </p>
 * @return int 成功した場合に string の長さ、
 * string が空の文字列だった場合に
 * 0 を返します。
 */
function strlen ($string) {}

/**
 * バイナリセーフな文字列比較
 * @link http://www.php.net/manual/ja/function.strcmp.php
 * @param str1 string <p>
 * 最初の文字列。
 * </p>
 * @param str2 string <p>
 * 次の文字列。
 * </p>
 * @return int str1 が str2
 * よりも小さければ &lt; 0 を、str1が
 * str2よりも大きければ &gt; 0 を、
 * 等しければ 0 を返します。
 */
function strcmp ($str1, $str2) {}

/**
 * 最初の n 文字についてバイナリセーフな文字列比較を行う
 * @link http://www.php.net/manual/ja/function.strncmp.php
 * @param str1 string <p>
 * 最初の文字列。
 * </p>
 * @param str2 string <p>
 * 次の文字列。
 * </p>
 * @param len int <p>
 * 比較する文字数。
 * </p>
 * @return int str1 が str2
 * より小さい場合に &lt; 0、str1 が
 * str2 より大きい場合に &gt; 0 、等しい場合に
 * 0 を返します。
 */
function strncmp ($str1, $str2, $len) {}

/**
 * 大文字小文字を区別しないバイナリセーフな文字列比較を行う
 * @link http://www.php.net/manual/ja/function.strcasecmp.php
 * @param str1 string <p>
 * 最初の文字列。
 * </p>
 * @param str2 string <p>
 * 次の文字列。
 * </p>
 * @return int str1 が str2
 * より小さい場合は負、str1 が
 * str2 より大きい場合は正、等しい場合は 0
 * を返します。
 */
function strcasecmp ($str1, $str2) {}

/**
 * バイナリセーフで大文字小文字を区別しない文字列比較を、最初の n 文字について行う
 * @link http://www.php.net/manual/ja/function.strncasecmp.php
 * @param str1 string <p>
 * 最初の文字列。
 * </p>
 * @param str2 string <p>
 * 次の文字列。
 * </p>
 * @param len int <p>
 * 比較する文字列の長さ。
 * </p>
 * @return int str1 が str2
 * より短い場合に &lt; 0 を返し、str1 が
 * str2 より大きい場合に &gt; 0、等しい場合に
 * 0 を返します。
 */
function strncasecmp ($str1, $str2, $len) {}

/**
 * 配列から現在のキーと値のペアを返して、カーソルを進める
 * @link http://www.php.net/manual/ja/function.each.php
 * @param array array <p>
 * 入力の配列。
 * </p>
 * @return array 配列 array から現在のキーと値のペアを返します。
 * このペアは 4 つの要素を持つ配列で、
 * それぞれの要素は 0, 1,
 * key, value というキーを有しています。
 * 要素 0とkey
 * の各々は配列要素のキー名称を保持しており、1
 * と value の各々はそのデータを保持しています。
 * </p>
 * <p>
 * 配列の内部ポインタが配列の最終要素以降を指す場合、
 * each は FALSE を返します。
 */
function each (array &$array) {}

/**
 * 出力する PHP エラーの種類を設定する
 * @link http://www.php.net/manual/ja/function.error-reporting.php
 * @param level int[optional] <p>
 * 新しい error_reporting
 * レベル。ビットマスクまたは名前つき定数のどちらかです。将来の
 * バージョンとの互換性を保証するために、名前つき定数の使用が
 * 強く推奨されています。エラーレベルが追加されると、整数の幅は増加します。
 * そのため、以前の整数を使用するエラーレベルは常に期待通りに動作するとは
 * 限りません。
 * </p>
 * <p>
 * 利用可能なエラーレベル定数とその実際の意味は、
 * 定義済みの定数に
 * 記述されています。
 * </p>
 * @return int 変更前の error_reporting
 * レベルを返します。level
 * パラメータを指定しなかった場合は、現在のレベルを返します。
 */
function error_reporting ($level = null) {}

/**
 * 名前を指定して定数を定義する
 * @link http://www.php.net/manual/ja/function.define.php
 * @param name string <p>
 * 定数の名前。
 * </p>
 * @param value mixed <p>
 * 定数の値。スカラー値あるいは null 値のみを指定できます。
 * スカラー値とは integer か
 * float、string、boolean
 * のいずれかのことです。リソース定数を定義することもできますが、
 * 推奨できません。予期せぬ振る舞いをする可能性があります。
 * </p>
 * @param case_insensitive bool[optional] <p>
 * TRUE を指定すると、定数は大文字小文字を区別しないようになります。
 * デフォルトでは大文字小文字を区別します。つまり
 * CONSTANT と Constant
 * は別の値を表すわけです。
 * </p>
 * <p>
 * 大文字小文字を区別しないときは、定数は小文字で格納されます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function define ($name, $value, $case_insensitive = null) {}

/**
 * 指定した名前の定数が存在するかどうかを調べる
 * @link http://www.php.net/manual/ja/function.defined.php
 * @param name string <p>
 * 定数名。
 * </p>
 * @return bool name で指定した名前の定数が定義されている
 * 場合に TRUE、その他の場合にFALSEを返します。
 */
function defined ($name) {}

/**
 * オブジェクトのクラス名を返す
 * @link http://www.php.net/manual/ja/function.get-class.php
 * @param object object[optional] <p>
 * 調べるオブジェクト。クラスの内部ではこのパラメータを省略することもできます。
 * </p>
 * @return string オブジェクト object がインスタンス
 * であるクラスの名前を返します。object
 * がオブジェクトでない場合にはFALSEが返されます。
 * </p>
 * <p>
 * クラスの内部で object を省略すると、
 * そのクラスの名前を返します。
 */
function get_class ($object = null) {}

/**
 * "静的遅延束縛" のクラス名
 * @link http://www.php.net/manual/ja/function.get-called-class.php
 * @return string クラス名を返します。クラスの外部からコールされた場合は FALSE を返します。
 */
function get_called_class () {}

/**
 * オブジェクトの親クラスの名前を取得する
 * @link http://www.php.net/manual/ja/function.get-parent-class.php
 * @param object mixed[optional] <p>
 * 調べたいオブジェクトあるいはクラスの名前。
 * </p>
 * @return string object
 * がインスタンスあるいは名前であるクラスの親クラス名を返します。
 * </p>
 * <p>
 * オブジェクトが親を持たない場合や指定したクラスが存在しない場合は FALSE を返します。
 * </p>
 * <p>
 * オブジェクトの外部からこのパラメータを省略してコールすると、
 * この関数は FALSE を返します
 */
function get_parent_class ($object = null) {}

/**
 * クラスメソッドが存在するかどうかを確認する
 * @link http://www.php.net/manual/ja/function.method-exists.php
 * @param object mixed <p>
 * オブジェクトのインスタンス、あるいはクラス名。
 * </p>
 * @param method_name string <p>
 * メソッドの名前。
 * </p>
 * @return bool method_name で指定したメソッドが
 * 指定した object において定義されている場合に
 * TRUE、そうでない場合に FALSE を返します。
 */
function method_exists ($object, $method_name) {}

/**
 * オブジェクトもしくはクラスにプロパティが存在するかどうかを調べる
 * @link http://www.php.net/manual/ja/function.property-exists.php
 * @param class mixed <p>
 * 確認するクラス名、もしくはクラスのオブジェクトを指定します。
 * </p>
 * @param property string <p>
 * プロパティ名を指定します。
 * </p>
 * @return bool プロパティが存在している場合は TRUE、存在していない場合に FALSE、
 * エラー時には NULL を返します。
 */
function property_exists ($class, $property) {}

/**
 * クラスが定義済みかどうかを確認する
 * @link http://www.php.net/manual/ja/function.class-exists.php
 * @param class_name string <p>
 * クラス名。大文字小文字は区別しません。
 * </p>
 * @param autoload bool[optional] <p>
 * デフォルトで __autoload をコールするかしないか。
 * </p>
 * @return bool クラス class_name が定義されている場合に TRUE、
 * それ以外の場合に FALSE を返します。
 */
function class_exists ($class_name, $autoload = null) {}

/**
 * インターフェイスが宣言されているかどうかを確認する
 * @link http://www.php.net/manual/ja/function.interface-exists.php
 * @param interface_name string <p>
 * インターフェイス名。
 * </p>
 * @param autoload bool[optional] <p>
 * デフォルトで __autoload をコールするかどうか。
 * </p>
 * @return bool interface_name
 * で与えられたインターフェイスが宣言されていれば TRUE を返します。
 * そうでなければ FALSE を返します。
 */
function interface_exists ($interface_name, $autoload = null) {}

/**
 * トレイトが存在するかどうかを調べる
 * @link http://www.php.net/manual/ja/function.trait-exists.php
 * @param traitname string <p>
 * 調べたいトレイトの名前。
 * </p>
 * @param autoload bool[optional] <p>
 * まだロードされていない場合にオートロードするかどうか。
 * </p>
 * @return bool トレイトが存在する場合に TRUE、存在しない場合に FALSE、エラーが発生した場合に NULL を返します。
 */
function trait_exists ($traitname, $autoload = null) {}

/**
 * 指定した関数が定義されている場合に TRUE を返す
 * @link http://www.php.net/manual/ja/function.function-exists.php
 * @param function_name string <p>
 * 関数名を表す文字列。
 * </p>
 * @return bool function_name が存在し、関数である場合に TRUE、
 * それ以外の場合に FALSE を返します。
 * </p>
 * <p>
 * この関数は、
 * include_once や echo
 * のような言語構造については FALSE を返します。
 */
function function_exists ($function_name) {}

/**
 * クラスのエイリアスを作成する
 * @link http://www.php.net/manual/ja/function.class-alias.php
 * @param original string <p>
 * 元となるクラス。
 * </p>
 * @param alias string <p>
 * クラスのエイリアス名。
 * </p>
 * @param autoload bool[optional] <p>
 * 元のクラスが見つからない場合にオートロードするかどうか。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function class_alias ($original, $alias, $autoload = null) {}

/**
 * include または require で読み込まれたファイルの名前を配列として返す
 * @link http://www.php.net/manual/ja/function.get-included-files.php
 * @return array すべてのファイル名を含む配列を返します。
 * </p>
 * <p>
 * 最初にコールされたスクリプトは "include されたファイル" という扱いに
 * なります。そのため、
 * include やその仲間たちにより
 * 読み込まれたファイルの一覧に含めて表示されます。
 * </p>
 * <p>
 * 複数回読み込まれているファイルも、
 * 返される配列には一度しかあらわれません。
 */
function get_included_files () {}

/**
 * <function>get_included_files</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.get-required-files.php
 */
function get_required_files () {}

/**
 * あるオブジェクトが指定したクラスのサブクラスに属するかどうかを調べる
 * @link http://www.php.net/manual/ja/function.is-subclass-of.php
 * @param object mixed <p>
 * クラス名あるいはオブジェクトのインスタンス。
 * </p>
 * @param class_name string <p>
 * クラス名。
 * </p>
 * @param allow_string bool[optional] <p>
 * このパラメータを false にすると、
 * クラス名を表す文字列を object に指定できなくなります。
 * そして、クラスが存在しない場合のオートローダーの呼び出しもしなくなります。
 * </p>
 * @return bool この関数は、オブジェクト object
 * が superclass のサブクラスであるクラスに属する場合に
 * TRUE、その他の場合に FALSE を返します。
 */
function is_subclass_of ($object, $class_name, $allow_string = null) {}

/**
 * オブジェクトがこのクラスのものであるか、このクラスをその親クラスのひとつとしているかどうかを調べる
 * @link http://www.php.net/manual/ja/function.is-a.php
 * @param object object <p>
 * 調べたいオブジェクト。
 * </p>
 * @param class_name string <p>
 * クラス名。
 * </p>
 * @param allow_string bool[optional] <p>
 * このパラメータを FALSE にすると、
 * クラス名を表す文字列を object に指定できなくなります。
 * そして、クラスが存在しない場合のオートローダーの呼び出しもしなくなります。
 * </p>
 * @return bool オブジェクトがこのクラスのものであるか、
 * あるいはこのクラスをその親クラスのひとつとしている場合に
 * TRUE、それ以外の場合に FALSE を返します。
 */
function is_a ($object, $class_name, $allow_string = null) {}

/**
 * クラスのデフォルトプロパティを取得する
 * @link http://www.php.net/manual/ja/function.get-class-vars.php
 * @param class_name string <p>
 * クラス名。
 * </p>
 * @return array 宣言されているプロパティのうち、現在のスコープから見えるものとそのデフォルト値を連想配列で返します。
 * 返される配列要素は、変数名 => 値 の形式となります。
 * エラーが発生した場合は FALSE を返します。
 */
function get_class_vars ($class_name) {}

/**
 * 指定したオブジェクトのプロパティを取得する
 * @link http://www.php.net/manual/ja/function.get-object-vars.php
 * @param object object <p>
 * オブジェクトのインスタンス。
 * </p>
 * @return array 指定したオブジェクト object について、
 * そのスコープ内でアクセス可能な非 static プロパティを連想配列として返します。
 * プロパティに値が設定されていない場合は、NULL 値が返されます。
 */
function get_object_vars ($object) {}

/**
 * クラスメソッドの名前を取得する
 * @link http://www.php.net/manual/ja/function.get-class-methods.php
 * @param class_name mixed <p>
 * オブジェクトのインスタンスのクラス名。
 * </p>
 * @return array この関数は、指定したクラス class_name
 * についてメソッドの名前を配列として返します。
 * エラー時には NULL を返します。
 */
function get_class_methods ($class_name) {}

/**
 * ユーザーレベルのエラー/警告/通知メッセージを生成する
 * @link http://www.php.net/manual/ja/function.trigger-error.php
 * @param error_msg string <p>
 * このエラーに割り当てられたメッセージ。長さは最大 1024 バイトまでです。
 * 1024 バイトを超える部分は切り捨てられます。
 * </p>
 * @param error_type int[optional] <p>
 * このエラーに割り当てられたエラー型。E_USER 関連の定数のみが指定可能で、
 * デフォルトは E_USER_NOTICE です。
 * </p>
 * @return bool この関数は、間違った error_type が指定された場合に
 * FALSE を、それ以外の場合に TRUE を返します。
 */
function trigger_error ($error_msg, $error_type = null) {}

/**
 * <function>trigger_error</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.user-error.php
 * @param message
 * @param error_type[optional]
 */
function user_error ($message, $error_type) {}

/**
 * ユーザー定義のエラーハンドラ関数を設定する
 * @link http://www.php.net/manual/ja/function.set-error-handler.php
 * @param error_handler callable <p>
 * ユーザー関数は、エラーコードとエラーを記述する文字列の 2 つの引数を
 * 受け取る必要があります。さらにオプションのパラメータとして 3 つの引数が
 * 追加されています。これらは、エラーが発生したファイル名、エラーが
 * 発生した行、発生したエラーのコンテキスト(エラーが発生した場所での
 * アクティブなシンボルテーブルを指す配列)です。関数は以下のようになります。
 * </p>
 * <p>
 * handler
 * interrno
 * stringerrstr
 * stringerrfile
 * interrline
 * arrayerrcontext
 * errno
 * 最初のパラメータ errno は、発生させる
 * エラーのレベルを整数で格納します。
 * @param error_types int[optional] <p>
 * 設定パラメータ
 * error_reporting
 * で表示するエラーを制御するのと全く同様に、
 * error_handler の起動を制御する際に
 * 使用可能です。
 * このマスクを指定しない場合、
 * error_handler は
 * error_reporting の設定によらず
 * 全てのエラーに関してコールされます。
 * </p>
 * @return mixed 前に定義されたエラーハンドラ(ある場合)を含む文字列を返します。
 * 組み込みのエラーハンドラを使用している場合は NULL を返します。
 * また、無効なコールバックなどでエラーとなった場合も NULL を返します。
 * 前に定義されたハンドラがクラスメソッドの場合、この関数は、
 * クラスとメソッド名からなる添字配列を返します。
 */
function set_error_handler ($error_handler, $error_types = null) {}

/**
 * 以前のエラーハンドラ関数を回復する
 * @link http://www.php.net/manual/ja/function.restore-error-handler.php
 * @return bool この関数は常に TRUE を返します。
 */
function restore_error_handler () {}

/**
 * ユーザー定義の例外ハンドラ関数を設定する
 * @link http://www.php.net/manual/ja/function.set-exception-handler.php
 * @param exception_handler callable <p>
 * キャッチされない例外が発生した際にコールされる関数の名前。
 * この関数は、set_exception_handler
 * をコールする前に定義する必要があります。
 * このハンドラ関数は、パラメータをひとつとる必要があります。
 * このパラメータは、スローされた例外オブジェクトとなります。
 * </p>
 * <p>
 * NULL を渡すと、このハンドラをデフォルトの状態に戻せます。
 * </p>
 * @return callable 前に定義された例外ハンドラの名前、またはエラー発生時に NULL を返します。
 * 前にハンドラが定義されていない場合にも NULL が返されます。
 * NULL を渡した場合は、このハンドラをデフォルトの状態に戻して TRUE を返します。
 */
function set_exception_handler ($exception_handler) {}

/**
 * 以前の例外ハンドラ関数を回復する
 * @link http://www.php.net/manual/ja/function.restore-exception-handler.php
 * @return bool この関数は常に TRUE を返します。
 */
function restore_exception_handler () {}

/**
 * 定義済のクラスの名前を配列として返す
 * @link http://www.php.net/manual/ja/function.get-declared-classes.php
 * @return array この関数は、現在のスクリプトで宣言されたクラスの名前の配列を返します。
 * </p>
 * <p>
 * PHP にコンパイル時に組み込んだり読み込んだりしている拡張モジュールの種類に依存して、
 * 他のクラスも存在する可能性があることに注意しましょう。
 * これは、自作のクラスをそれらと同じ名前で作成できないことを意味します。
 * 定義済みのクラスについては付録の定義済みクラスのセクションを
 * 参照してください。
 */
function get_declared_classes () {}

/**
 * 宣言されているすべてのトレイトの配列を返す
 * @link http://www.php.net/manual/ja/function.get-declared-traits.php
 * @return array 宣言されているすべてのトレイトの名前を値に持つ配列を返します。
 * 失敗した場合は NULL を返します。
 */
function get_declared_traits () {}

/**
 * 宣言されている全てのインターフェイスの配列を返す
 * @link http://www.php.net/manual/ja/function.get-declared-interfaces.php
 * @return array 現在のスクリプトで宣言されているインターフェイス名の配列を返します。
 */
function get_declared_interfaces () {}

/**
 * 定義済みの全ての関数を配列で返す
 * @link http://www.php.net/manual/ja/function.get-defined-functions.php
 * @return array この関数は、組込 (内部) 関数およびユーザー定義関数を共に含む定義済み
 * の全ての関数のリストを有する多次元配列を返します。内部関数は、
 * $arr["internal"]、ユーザー定義関数は
 * $arr["user"] によりアクセス可能となります
 * (以下の例を参照ください)。
 */
function get_defined_functions () {}

/**
 * 全ての定義済の変数を配列で返す
 * @link http://www.php.net/manual/ja/function.get-defined-vars.php
 * @return array すべての変数を含む多次元の配列を返します。
 */
function get_defined_vars () {}

/**
 * 匿名関数 (ラムダ形式) を作成する
 * @link http://www.php.net/manual/ja/function.create-function.php
 * @param args string <p>
 * 関数の引数。
 * </p>
 * @param code string <p>
 * 関数のコード。
 * </p>
 * @return string 一意な関数名を表す文字列、あるいはエラー時に FALSE を返します。
 */
function create_function ($args, $code) {}

/**
 * リソース型を返す
 * @link http://www.php.net/manual/ja/function.get-resource-type.php
 * @param handle resource <p>
 * 評価されるリソースハンドル。
 * </p>
 * @return string 指定された handle がリソースであった場合、
 * この関数はその型を表す文字列を返します。この関数で型が判別できなかった
 * 場合は、返り値は文字列 Unknown となります。
 * </p>
 * <p>
 * もし handle がリソースでない場合、
 * この関数は FALSE を返し、エラーを発生させます。
 */
function get_resource_type ($handle) {}

/**
 * コンパイル/ロードされている全てのモジュールの名前を配列として返す
 * @link http://www.php.net/manual/ja/function.get-loaded-extensions.php
 * @param zend_extensions bool[optional] <p>
 * Zend 拡張モジュールのみを返します。指定しない場合は、
 * mysqli のような通常の拡張モジュールを返します。デフォルトは
 * FALSE (通常の拡張モジュールを返す) です。
 * </p>
 * @return array モジュール名の配列を返します。
 */
function get_loaded_extensions ($zend_extensions = null) {}

/**
 * ある拡張機能がロードされているかどうかを調べる
 * @link http://www.php.net/manual/ja/function.extension-loaded.php
 * @param name string <p>
 * 拡張モジュールの名前。
 * </p>
 * <p>
 * phpinfoを使って種々の拡張モジュールの
 * 名前を見ることができます。PHP の
 * CGIまたはCLIバージョン
 * を使っている場合には -m スイッチで、
 * 使用できる全ての拡張モジュールのリストを得ることができます:
 * </p>
 * @return bool name で指定する拡張機能がロードされている場合に
 * TRUE を返します。さもなければ FALSE を返します。
 */
function extension_loaded ($name) {}

/**
 * あるモジュールの関数名を配列として返す
 * @link http://www.php.net/manual/ja/function.get-extension-funcs.php
 * @param module_name string <p>
 * モジュール名。
 * </p>
 * <p>
 * このパラメータは 小文字
 * でなければなりません。
 * </p>
 * @return array すべての関数を含む配列を返します。
 * module_name が拡張モジュールでない場合は
 * FALSE を返します。
 */
function get_extension_funcs ($module_name) {}

/**
 * すべての定数の名前とその値を連想配列として返す
 * @link http://www.php.net/manual/ja/function.get-defined-constants.php
 * @param categorize bool[optional] <p>
 * これを渡すと、この関数は多次元の配列を返すようになります。
 * 最初の次元のキーがカテゴリとなり、
 * そのカテゴリ内の定数とその値が下位レベルに格納されます。
 * ]]>
 * 上の例の出力は、
 * たとえば以下のようになります。</p>
 * Array
 * (
 * [E_ERROR] => 1
 * [E_WARNING] => 2
 * [E_PARSE] => 4
 * [E_NOTICE] => 8
 * [E_CORE_ERROR] => 16
 * [E_CORE_WARNING] => 32
 * [E_COMPILE_ERROR] => 64
 * [E_COMPILE_WARNING] => 128
 * [E_USER_ERROR] => 256
 * [E_USER_WARNING] => 512
 * [E_USER_NOTICE] => 1024
 * [E_ALL] => 2047
 * [TRUE] => 1
 * )
 * [pcre] => Array
 * (
 * [PREG_PATTERN_ORDER] => 1
 * [PREG_SET_ORDER] => 2
 * [PREG_OFFSET_CAPTURE] => 256
 * [PREG_SPLIT_NO_EMPTY] => 1
 * [PREG_SPLIT_DELIM_CAPTURE] => 2
 * [PREG_SPLIT_OFFSET_CAPTURE] => 4
 * [PREG_GREP_INVERT] => 1
 * )
 * [user] => Array
 * (
 * [MY_CONSTANT] => 1
 * )
 * )
 * ]]>
 * </p>
 * @return array 
 */
function get_defined_constants ($categorize = null) {}

/**
 * バックトレースを生成する
 * @link http://www.php.net/manual/ja/function.debug-backtrace.php
 * @param options int[optional] <p>
 * PHP 5.3.6 以降、このパラメータは次のオプションのビットマスクとなります。
 * <table>
 * debug_backtrace のオプション
 * <tr valign="top">
 * <td>DEBUG_BACKTRACE_PROVIDE_OBJECT</td>
 * <td>
 * "object" インデックスを埋めるかどうか。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>DEBUG_BACKTRACE_IGNORE_ARGS</td>
 * <td>
 * "args" インデックスを無視してすべての関数/メソッドの引数をメモリに格納するかどうか。
 * </td>
 * </tr>
 * </table>
 * 5.3.6 より前のバージョンでは TRUE あるいは FALSE しか指定できませんでした。これは
 * DEBUG_BACKTRACE_PROVIDE_OBJECT オプションを指定するかしないかを意味します。
 * </p>
 * @param limit int[optional] <p>
 * 5.4.0 以降、このパラメータを使ってスタックフレームの数を制限できるようになりました。
 * デフォルト (limit=0) は、すべてのスタックフレームを返します。
 * </p>
 * @return array 連想配列の配列を返します。連想配列の要素として返される可能性があるものは以下のとおりです。
 * </p>
 * <p>
 * <table>
 * debug_backtrace から返される可能性がある要素
 * <tr valign="top">
 * <td>名前</td>
 * <td>型</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>function</td>
 * <td>string</td>
 * <td>
 * カレントの関数名。
 * __FUNCTION__
 * も参照してください。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>line</td>
 * <td>integer</td>
 * <td>
 * カレントの行番号。
 * __LINE__
 * も参照してください。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>file</td>
 * <td>string</td>
 * <td>
 * カレントのファイル名。
 * __FILE__
 * も参照してください。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>class</td>
 * <td>string</td>
 * <td>
 * カレントのクラス名。
 * __CLASS__
 * も参照してください。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>object</td>
 * <td>object</td>
 * <td>
 * カレントのオブジェクト。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>type</td>
 * <td>string</td>
 * <td>
 * カレントのコール方式。メソッド呼び出しの場合は "->"、
 * 静的なメソッド呼び出しの場合は "::" が返されます。
 * 関数呼び出しの場合は何も返されません。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>args</td>
 * <td>array</td>
 * <td>
 * 関数の内部の場合、関数の引数のリストとなります。
 * インクルードされたファイル内では、
 * 読み込まれたファイルの名前となります。
 * </td>
 * </tr>
 * </table>
 */
function debug_backtrace ($options = null, $limit = null) {}

/**
 * バックトレースを表示する
 * @link http://www.php.net/manual/ja/function.debug-print-backtrace.php
 * @param options int[optional] <p>
 * PHP 5.3.6 の時点では、このパラメータは次のオプションのビットマスクとなります。
 * <table>
 * debug_print_backtrace のオプション
 * <tr valign="top">
 * <td>DEBUG_BACKTRACE_IGNORE_ARGS</td>
 * <td>
 * "args" インデックスを無視してすべての関数/メソッドの引数をメモリに格納するかどうか。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param limit int[optional] <p>
 * 5.4.0 以降、このパラメータを使ってスタックフレームの数を制限できるようになりました。
 * デフォルト (limit=0) は、すべてのスタックフレームを表示します。
 * </p>
 * @return void 値を返しません。
 */
function debug_print_backtrace ($options = null, $limit = null) {}

/**
 * すべての既存ガベージサイクルを強制的に収集する
 * @link http://www.php.net/manual/ja/function.gc-collect-cycles.php
 * @return int 収集したサイクルの数を返します。
 */
function gc_collect_cycles () {}

/**
 * 循環参照コレクタの状態を返す
 * @link http://www.php.net/manual/ja/function.gc-enabled.php
 * @return bool ガベージコレクタが有効な場合に TRUE、そうでない場合に FALSE を返します。
 */
function gc_enabled () {}

/**
 * 循環参照コレクタを有効にする
 * @link http://www.php.net/manual/ja/function.gc-enable.php
 * @return void 値を返しません。
 */
function gc_enable () {}

/**
 * 循環参照コレクタを無効にする
 * @link http://www.php.net/manual/ja/function.gc-disable.php
 * @return void 値を返しません。
 */
function gc_disable () {}


/**
 * 重大な実行時エラー。これは、メモリ確保に関する問題のように復帰で
 * きないエラーを示します。スクリプトの実行は中断されます。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_ERROR', 1);

/**
 * キャッチできる致命的なエラー。危険なエラーが発生したが、
 * エンジンが不安定な状態になるほどではないことを表す。
 * ユーザー定義のハンドラでエラーがキャッチされなかった場合
 * (set_error_handler も参照ください) は、
 * E_ERROR として異常終了する。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_RECOVERABLE_ERROR', 4096);

/**
 * 実行時の警告 (致命的なエラーではない)。スクリプトの実行は中断さ
 * れません。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_WARNING', 2);

/**
 * コンパイル時のパースエラー。パースエラーはパーサでのみ生成されま
 * す。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_PARSE', 4);

/**
 * 実行時の警告。エラーを発しうる状況に遭遇したことを示す。
 * ただし通常のスクリプト実行の場合にもこの警告を発することがありうる。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_NOTICE', 8);

/**
 * コードの相互運用性や互換性を維持するために
 * PHP がコードの変更を提案する。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_STRICT', 2048);

/**
 * 実行時の注意。これを有効にすると、
 * 将来のバージョンで動作しなくなるコードについての警告を受け取ることができる。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_DEPRECATED', 8192);

/**
 * PHPの初期始動時点での致命的なエラー。E_ERRORに
 * 似ているがPHPのコアによって発行される点が違う。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_CORE_ERROR', 16);

/**
 * （致命的ではない）警告。PHPの初期始動時に発生する。
 * E_WARNINGに似ているがPHPのコアによって発行される
 * 点が違う。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_CORE_WARNING', 32);

/**
 * コンパイル時の致命的なエラー。E_ERRORに
 * 似ているがZendスクリプティングエンジンによって発行される点が違う。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_COMPILE_ERROR', 64);

/**
 * コンパイル時の警告（致命的ではない）。E_WARNINGに
 * 似ているがZendスクリプティングエンジンによって発行される点が違う。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_COMPILE_WARNING', 128);

/**
 * ユーザーによって発行されるエラーメッセージ。E_ERROR
 * に似ているがPHPコード上でtrigger_error関数を
 * 使用した場合に発行される点が違う。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_USER_ERROR', 256);

/**
 * ユーザーによって発行される警告メッセージ。E_WARNING
 * に似ているがPHPコード上でtrigger_error関数を
 * 使用した場合に発行される点が違う。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_USER_WARNING', 512);

/**
 * ユーザーによって発行される注意メッセージ。E_NOTICEに
 * に似ているがPHPコード上でtrigger_error関数を
 * 使用した場合に発行される点が違う。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_USER_NOTICE', 1024);

/**
 * ユーザー定義の警告メッセージ。これは
 * E_DEPRECATED と同等だが、
 * PHP のコード上で関数 trigger_error
 * によって作成されるという点が異なる。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_USER_DEPRECATED', 16384);

/**
 * サポートされる全てのエラーと警告。
 * PHP 5.4.0 より前のバージョンでは、E_STRICT レベルのエラーは除く。
 * @link http://www.php.net/manual/ja/errorfunc.constants.php
 */
define ('E_ALL', 32767);
define ('DEBUG_BACKTRACE_PROVIDE_OBJECT', 1);
define ('DEBUG_BACKTRACE_IGNORE_ARGS', 2);
define ('TRUE', true);
define ('FALSE', false);
define ('NULL', null);
define ('ZEND_THREAD_SAFE', false);
define ('ZEND_DEBUG_BUILD', false);
define ('PHP_VERSION', "5.4.11");
define ('PHP_MAJOR_VERSION', 5);
define ('PHP_MINOR_VERSION', 4);
define ('PHP_RELEASE_VERSION', 11);
define ('PHP_EXTRA_VERSION', "");
define ('PHP_VERSION_ID', 50411);
define ('PHP_ZTS', 0);
define ('PHP_DEBUG', 0);
define ('PHP_OS', "WINNT");
define ('PHP_SAPI', "cli");
define ('DEFAULT_INCLUDE_PATH', ".;C:\php\pear");
define ('PEAR_INSTALL_DIR', "C:\php\pear");
define ('PEAR_EXTENSION_DIR', "C:\php");
define ('PHP_EXTENSION_DIR', "C:\php");
define ('PHP_PREFIX', "C:\php");
define ('PHP_BINDIR', "C:\php");
define ('PHP_LIBDIR', "C:\php");
define ('PHP_DATADIR', "C:\php");
define ('PHP_SYSCONFDIR', "C:\php");
define ('PHP_LOCALSTATEDIR', "C:\php");
define ('PHP_CONFIG_FILE_PATH', "C:\WINDOWS");
define ('PHP_CONFIG_FILE_SCAN_DIR', "");
define ('PHP_SHLIB_SUFFIX', "dll");
define ('PHP_EOL', "\r\n");
define ('PHP_MAXPATHLEN', 260);
define ('PHP_INT_MAX', 2147483647);
define ('PHP_INT_SIZE', 4);
define ('PHP_WINDOWS_VERSION_MAJOR', 5);
define ('PHP_WINDOWS_VERSION_MINOR', 1);
define ('PHP_WINDOWS_VERSION_BUILD', 2600);
define ('PHP_WINDOWS_VERSION_PLATFORM', 2);
define ('PHP_WINDOWS_VERSION_SP_MAJOR', 3);
define ('PHP_WINDOWS_VERSION_SP_MINOR', 0);
define ('PHP_WINDOWS_VERSION_SUITEMASK', 256);
define ('PHP_WINDOWS_VERSION_PRODUCTTYPE', 1);
define ('PHP_WINDOWS_NT_DOMAIN_CONTROLLER', 2);
define ('PHP_WINDOWS_NT_SERVER', 3);
define ('PHP_WINDOWS_NT_WORKSTATION', 1);
define ('PHP_BINARY', "C:\workshop\php\php-5.4.11-nts-Win32-VC9-x86\php.exe");

/**
 * <p>
 * 出力バッファリングが始まったことを表します。
 * </p>
 * @link http://www.php.net/manual/ja/outcontrol.constants.php
 */
define ('PHP_OUTPUT_HANDLER_START', 1);

/**
 * <p>
 * 出力バッファがフラッシュされ、データが出力されたことを表します。
 * </p>
 * <p>
 * PHP 5.4 以降で利用可能です。
 * </p>
 * @link http://www.php.net/manual/ja/outcontrol.constants.php
 */
define ('PHP_OUTPUT_HANDLER_WRITE', 0);

/**
 * <p>
 * バッファがフラッシュされたことを表します。
 * </p>
 * <p>
 * PHP 5.4 以降で利用可能です。
 * </p>
 * @link http://www.php.net/manual/ja/outcontrol.constants.php
 */
define ('PHP_OUTPUT_HANDLER_FLUSH', 4);

/**
 * <p>
 * 出力バッファが消去されたことを表します。
 * </p>
 * <p>
 * PHP 5.4 以降で利用可能です。
 * </p>
 * @link http://www.php.net/manual/ja/outcontrol.constants.php
 */
define ('PHP_OUTPUT_HANDLER_CLEAN', 2);

/**
 * <p>
 * 出力バッファリングの最終操作であることを表します。
 * </p>
 * <p>
 * PHP 5.4 以降で利用可能です。
 * </p>
 * @link http://www.php.net/manual/ja/outcontrol.constants.php
 */
define ('PHP_OUTPUT_HANDLER_FINAL', 8);

/**
 * <p>
 * バッファはフラッシュされたけれども、出力バッファリングはまだ続くことを表します。
 * </p>
 * <p>
 * PHP 5.4 の時点では、これは
 * PHP_OUTPUT_HANDLER_WRITE
 * のエイリアスです。
 * </p>
 * @link http://www.php.net/manual/ja/outcontrol.constants.php
 */
define ('PHP_OUTPUT_HANDLER_CONT', 0);

/**
 * <p>
 * 出力バッファリングが終わったことを表します。
 * </p>
 * <p>
 * PHP 5.4 の時点では、これは
 * PHP_OUTPUT_HANDLER_FINAL
 * のエイリアスです。
 * </p>
 * @link http://www.php.net/manual/ja/outcontrol.constants.php
 */
define ('PHP_OUTPUT_HANDLER_END', 8);
define ('PHP_OUTPUT_HANDLER_CLEANABLE', 16);
define ('PHP_OUTPUT_HANDLER_FLUSHABLE', 32);
define ('PHP_OUTPUT_HANDLER_REMOVABLE', 64);
define ('PHP_OUTPUT_HANDLER_STDFLAGS', 112);
define ('PHP_OUTPUT_HANDLER_STARTED', 4096);
define ('PHP_OUTPUT_HANDLER_DISABLED', 8192);
define ('UPLOAD_ERR_OK', 0);
define ('UPLOAD_ERR_INI_SIZE', 1);
define ('UPLOAD_ERR_FORM_SIZE', 2);
define ('UPLOAD_ERR_PARTIAL', 3);
define ('UPLOAD_ERR_NO_FILE', 4);
define ('UPLOAD_ERR_NO_TMP_DIR', 6);
define ('UPLOAD_ERR_CANT_WRITE', 7);
define ('UPLOAD_ERR_EXTENSION', 8);
define ('STDIN', "Resource id #1");
define ('STDOUT', "Resource id #2");
define ('STDERR', "Resource id #3");

// End of Core v.5.4.11
?>
