<?php

// Start of PDO v.1.0.4dev

class PDOException extends RuntimeException  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;
	public $errorInfo;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class PDO  {
	const PARAM_BOOL = 5;
	const PARAM_NULL = 0;
	const PARAM_INT = 1;
	const PARAM_STR = 2;
	const PARAM_LOB = 3;
	const PARAM_STMT = 4;
	const PARAM_INPUT_OUTPUT = -2147483648;
	const PARAM_EVT_ALLOC = 0;
	const PARAM_EVT_FREE = 1;
	const PARAM_EVT_EXEC_PRE = 2;
	const PARAM_EVT_EXEC_POST = 3;
	const PARAM_EVT_FETCH_PRE = 4;
	const PARAM_EVT_FETCH_POST = 5;
	const PARAM_EVT_NORMALIZE = 6;
	const FETCH_LAZY = 1;
	const FETCH_ASSOC = 2;
	const FETCH_NUM = 3;
	const FETCH_BOTH = 4;
	const FETCH_OBJ = 5;
	const FETCH_BOUND = 6;
	const FETCH_COLUMN = 7;
	const FETCH_CLASS = 8;
	const FETCH_INTO = 9;
	const FETCH_FUNC = 10;
	const FETCH_GROUP = 65536;
	const FETCH_UNIQUE = 196608;
	const FETCH_KEY_PAIR = 12;
	const FETCH_CLASSTYPE = 262144;
	const FETCH_SERIALIZE = 524288;
	const FETCH_PROPS_LATE = 1048576;
	const FETCH_NAMED = 11;
	const ATTR_AUTOCOMMIT = 0;
	const ATTR_PREFETCH = 1;
	const ATTR_TIMEOUT = 2;
	const ATTR_ERRMODE = 3;
	const ATTR_SERVER_VERSION = 4;
	const ATTR_CLIENT_VERSION = 5;
	const ATTR_SERVER_INFO = 6;
	const ATTR_CONNECTION_STATUS = 7;
	const ATTR_CASE = 8;
	const ATTR_CURSOR_NAME = 9;
	const ATTR_CURSOR = 10;
	const ATTR_ORACLE_NULLS = 11;
	const ATTR_PERSISTENT = 12;
	const ATTR_STATEMENT_CLASS = 13;
	const ATTR_FETCH_TABLE_NAMES = 14;
	const ATTR_FETCH_CATALOG_NAMES = 15;
	const ATTR_DRIVER_NAME = 16;
	const ATTR_STRINGIFY_FETCHES = 17;
	const ATTR_MAX_COLUMN_LEN = 18;
	const ATTR_EMULATE_PREPARES = 20;
	const ATTR_DEFAULT_FETCH_MODE = 19;
	const ERRMODE_SILENT = 0;
	const ERRMODE_WARNING = 1;
	const ERRMODE_EXCEPTION = 2;
	const CASE_NATURAL = 0;
	const CASE_LOWER = 2;
	const CASE_UPPER = 1;
	const NULL_NATURAL = 0;
	const NULL_EMPTY_STRING = 1;
	const NULL_TO_STRING = 2;
	const ERR_NONE = 00000;
	const FETCH_ORI_NEXT = 0;
	const FETCH_ORI_PRIOR = 1;
	const FETCH_ORI_FIRST = 2;
	const FETCH_ORI_LAST = 3;
	const FETCH_ORI_ABS = 4;
	const FETCH_ORI_REL = 5;
	const CURSOR_FWDONLY = 0;
	const CURSOR_SCROLL = 1;
	const SQLSRV_ATTR_ENCODING = 1000;
	const SQLSRV_ATTR_QUERY_TIMEOUT = 1001;
	const SQLSRV_ATTR_DIRECT_QUERY = 1002;
	const SQLSRV_ATTR_CURSOR_SCROLL_TYPE = 1003;
	const SQLSRV_ATTR_CLIENT_BUFFER_MAX_KB_SIZE = 1004;
	const SQLSRV_PARAM_OUT_DEFAULT_SIZE = -1;
	const SQLSRV_ENCODING_DEFAULT = 1;
	const SQLSRV_ENCODING_SYSTEM = 3;
	const SQLSRV_ENCODING_BINARY = 2;
	const SQLSRV_ENCODING_UTF8 = 65001;
	const SQLSRV_CURSOR_STATIC = 3;
	const SQLSRV_CURSOR_DYNAMIC = 2;
	const SQLSRV_CURSOR_KEYSET = 1;
	const SQLSRV_CURSOR_BUFFERED = -2;
	const SQLSRV_TXN_READ_UNCOMMITTED = "READ_UNCOMMITTED";
	const SQLSRV_TXN_READ_COMMITTED = "READ_COMMITTED";
	const SQLSRV_TXN_REPEATABLE_READ = "REPEATABLE_READ";
	const SQLSRV_TXN_SERIALIZABLE = "SERIALIZABLE";
	const SQLSRV_TXN_SNAPSHOT = "SNAPSHOT";
	const FB_ATTR_DATE_FORMAT = 1000;
	const FB_ATTR_TIME_FORMAT = 1001;
	const FB_ATTR_TIMESTAMP_FORMAT = 1002;
	const MYSQL_ATTR_USE_BUFFERED_QUERY = 1000;
	const MYSQL_ATTR_LOCAL_INFILE = 1001;
	const MYSQL_ATTR_INIT_COMMAND = 1002;
	const MYSQL_ATTR_COMPRESS = 1003;
	const MYSQL_ATTR_DIRECT_QUERY = 1004;
	const MYSQL_ATTR_FOUND_ROWS = 1005;
	const MYSQL_ATTR_IGNORE_SPACE = 1006;
	const MYSQL_ATTR_SSL_KEY = 1007;
	const MYSQL_ATTR_SSL_CERT = 1008;
	const MYSQL_ATTR_SSL_CA = 1009;
	const MYSQL_ATTR_SSL_CAPATH = 1010;
	const MYSQL_ATTR_SSL_CIPHER = 1011;
	const ODBC_ATTR_USE_CURSOR_LIBRARY = 1000;
	const ODBC_ATTR_ASSUME_UTF8 = 1001;
	const ODBC_SQL_USE_IF_NEEDED = 0;
	const ODBC_SQL_USE_DRIVER = 2;
	const ODBC_SQL_USE_ODBC = 1;
	const PGSQL_ATTR_DISABLE_NATIVE_PREPARED_STATEMENT = 1000;
	const PGSQL_TRANSACTION_IDLE = 0;
	const PGSQL_TRANSACTION_ACTIVE = 1;
	const PGSQL_TRANSACTION_INTRANS = 2;
	const PGSQL_TRANSACTION_INERROR = 3;
	const PGSQL_TRANSACTION_UNKNOWN = 4;


	/**
	 * データベースへの接続を表す PDO インスタンスを生成する
	 * @link http://www.php.net/manual/ja/pdo.construct.php
	 * @param dsn
	 * @param username
	 * @param passwd
	 * @param options[optional]
	 */
	public function __construct ($dsn, $username, $passwd, $options) {}

	/**
	 * 文を実行する準備を行い、文オブジェクトを返す
	 * @link http://www.php.net/manual/ja/pdo.prepare.php
	 * @param statement string <p>
	 * これは対象のデータベースサーバーに対して有効な SQL
	 * 文でなければなりません。
	 * </p>
	 * @param driver_options array[optional] <p>
	 * この配列は、このメソッドによって返される PDOStatement
	 * オブジェクトに対して 1
	 * もしくはそれ以上の key=&gt;value の組を含みます。
	 * 通常、スクロール可能なカーソルを要求するために
	 * PDO::ATTR_CURSOR に
	 * PDO::CURSOR_SCROLL
	 * を設定する場合に使用することになるでしょう。
	 * いくつかのドライバには、準備する際に利用可能なドライバ固有の
	 * オプションがあります。
	 * </p>
	 * @return PDOStatement もしデータベースサーバーが正常に文を準備する場合、
	 * PDO::prepare は
	 * PDOStatement オブジェクトを返します。
	 * もしデータベースサーバーが文を準備できなかった場合、
	 * PDO::prepare は FALSE を返すか
	 * PDOException を発行します
	 * (エラー処理 の方法に依存します)。
	 * </p>
	 * <p>
	 * プリペアドステートメントをエミュレートする際にデータベースサーバーとの通信は行いません。
	 * したがって PDO::prepare はステートメントのチェックを行いません。
	 */
	public function prepare ($statement, array $driver_options = null) {}

	/**
	 * トランザクションを開始する
	 * @link http://www.php.net/manual/ja/pdo.begintransaction.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function beginTransaction () {}

	/**
	 * トランザクションをコミットする
	 * @link http://www.php.net/manual/ja/pdo.commit.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function commit () {}

	/**
	 * トランザクションをロールバックする
	 * @link http://www.php.net/manual/ja/pdo.rollback.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function rollBack () {}

	/**
	 * トランザクション内かどうかを調べる
	 * @link http://www.php.net/manual/ja/pdo.intransaction.php
	 * @return bool トランザクションが現在アクティブな場合に TRUE、
	 * そうでないときに FALSE を返します。
	 */
	public function inTransaction () {}

	/**
	 * 属性を設定する
	 * @link http://www.php.net/manual/ja/pdo.setattribute.php
	 * @param attribute int 
	 * @param value mixed 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setAttribute ($attribute, $value) {}

	/**
	 * SQL ステートメントを実行し、作用した行数を返す
	 * @link http://www.php.net/manual/ja/pdo.exec.php
	 * @param statement string <p>
	 * 準備、実行する SQL ステートメントを指定します。
	 * </p>
	 * <p>
	 * クエリ内のデータは 適切にエスケープ
	 * する必要があります。
	 * </p>
	 * @return int PDO::exec は、発行した SQL
	 * ステートメントによって更新もしくは
	 * 削除された行数を返します。
	 * 1 行も作用しなかった場合、PDO::exec は
	 * 0 を返します。
	 * </p>
	 * この関数は論理値
	 * FALSE を返す可能性がありますが、FALSE として評価される値を返す可能性もあります。
	 * 詳細については 論理値の
	 * セクションを参照してください。この関数の返り値を調べるには
	 * ===演算子 を
	 * 使用してください。
	 * <p>
	 * 以下の例は PDO::exec
	 * の戻り値の使用法を間違っています。結果として一行も更新されなかった場合に
	 * die がコールされてしまうからです。
	 * exec() or die(print_r($db->errorInfo(), true));
	 * ?>
	 * ]]>
	 */
	public function exec ($statement) {}

	/**
	 * SQL ステートメントを実行し、結果セットを PDOStatement オブジェクトとして返す
	 * @link http://www.php.net/manual/ja/pdo.query.php
	 * @param statement string <p>
	 * 準備、発行する SQL ステートメント。
	 * </p>
	 * <p>
	 * クエリ内のデータは 適切にエスケープ
	 * する必要があります。
	 * </p>
	 * @return PDOStatement PDO::query は、PDOStatement オブジェクトを返します。
	 * 失敗した場合は FALSE を返します。
	 */
	public function query ($statement) {}

	/**
	 * 最後に挿入された行の ID あるいはシーケンスの値を返す
	 * @link http://www.php.net/manual/ja/pdo.lastinsertid.php
	 * @param name string[optional] <p>
	 * ID が返されるべきシーケンスオブジェクト名を指定します。
	 * </p>
	 * @return string もし name
	 * パラメータにシーケンス名が指定されなかった場合、
	 * PDO::lastInsertId
	 * はデータベースに挿入された最後の行の行IDに相当する文字列を返します。
	 * </p>
	 * <p>
	 * もし name
	 * パラメータにシーケンス名が指定された場合、
	 * PDO::lastInsertId
	 * は指定されたシーケンスオブジェクトから取得した最後の値に相当する
	 * 文字列を返します。
	 * </p>
	 * <p>
	 * もし PDO ドライバがサポートしていない場合、
	 * PDO::lastInsertId
	 * は IM001 SQLSTATE を発生させます。
	 */
	public function lastInsertId ($name = null) {}

	/**
	 * データベースハンドラにおける直近の操作に関連する SQLSTATE を取得する
	 * @link http://www.php.net/manual/ja/pdo.errorcode.php
	 * @return mixed SQLSTATE を返します。これは、ANSI SQL-92 標準で定義された英数 5
	 * 文字の ID です。簡潔に言えば、SQLSTATE は 2文字のクラス値の後に
	 * 3 文字のサブクラス値が続きます。クラス値 01 はワーニングを表し、
	 * 戻り値のコード SQL_SUCCESS_WITH_INFO を伴います。
	 * クラス 'IM' を除く '01' 以外のクラス値はエラーを表します。
	 * クラス 'IM' は PDO 自身の実装 (もしくは ODBC ドライバを使用している場合は
	 * ODBC かも知れません) に由来するワーニングやエラーに固有の値です。
	 * あらゆるクラスでのサブクラス値 '000' は SQLSTATE
	 * に対するサブクラスがない事を示しています。
	 * </p>
	 * <p>
	 * PDO::errorCode はデータベースハンドラに
	 * 直接行った操作に対するエラーコードのみを取得します。
	 * もし PDO::prepare や PDO::query
	 * を通して PDOStatement オブジェクトを生成し、
	 * 文でエラーが発生した場合、PDO::errorCode
	 * はエラーを反映しません。
	 * 特定の文ハンドラに対して実行された操作についてのエラーコードを返すには
	 * PDOStatement::errorCode
	 * をコールしなければなりません。
	 * </p>
	 * <p>
	 * そのデータベースハンドル上で何も操作が行われていない場合は NULL を返します。
	 */
	public function errorCode () {}

	/**
	 * データベースハンドラにおける直近の操作に関連する拡張エラー情報を取得する
	 * @link http://www.php.net/manual/ja/pdo.errorinfo.php
	 * @return array PDO::errorInfo は、
	 * このデータベースハンドラによって実行された直近の操作に関するエラー情報を
	 * 配列として返します。この配列は次のフィールドを含みます。
	 * <tr valign="top">
	 * <td>要素</td>
	 * <td>情報</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>0</td>
	 * <td>SQLSTATE エラーコード
	 * (これは、ANSI SQL 標準で定義された英数 5 文字の ID)</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>1</td>
	 * <td>ドライバ固有のエラーコード</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>2</td>
	 * <td>ドライバ固有のエラーメッセージ</td>
	 * </tr>
	 * </p>
	 * <p>
	 * SQLSTATE エラーコードが設定されていない場合やドライバ固有のエラーがない場合は、
	 * 要素 0 に続く要素は NULL となります。
	 * </p>
	 * <p>
	 * PDO::errorInfo はデータベースハンドラに
	 * 直接行った操作に対するエラーコードのみを取得します。
	 * もし PDO::prepare や PDO::query
	 * を通して PDOStatement オブジェクトを生成し、
	 * 文でエラーが発生した場合、PDO::errorInfo
	 * はそのエラーを反映しません。
	 * 特定の文ハンドラに対して実行された操作についてのエラーコードを返すには
	 * PDOStatement::errorInfo
	 * をコールしなければなりません。
	 */
	public function errorInfo () {}

	/**
	 * データベース接続の属性を取得する
	 * @link http://www.php.net/manual/ja/pdo.getattribute.php
	 * @param attribute int <p>
	 * PDO_ATTR_* 定数の 1 つを指定します。
	 * データベース接続に適用される定数は以下の通りです。
	 * PDO::ATTR_AUTOCOMMIT
	 * PDO::ATTR_CASE
	 * PDO::ATTR_CLIENT_VERSION
	 * PDO::ATTR_CONNECTION_STATUS
	 * PDO::ATTR_DRIVER_NAME
	 * PDO::ATTR_ERRMODE
	 * PDO::ATTR_ORACLE_NULLS
	 * PDO::ATTR_PERSISTENT
	 * PDO::ATTR_PREFETCH
	 * PDO::ATTR_SERVER_INFO
	 * PDO::ATTR_SERVER_VERSION
	 * PDO::ATTR_TIMEOUT
	 * </p>
	 * @return mixed コールに成功した場合は要求された PDO 属性の値を返します。
	 * コールに失敗した場合は null を返します。
	 */
	public function getAttribute ($attribute) {}

	/**
	 * クエリ用の文字列をクオートする
	 * @link http://www.php.net/manual/ja/pdo.quote.php
	 * @param string string <p>
	 * クオートされる文字列を指定します。
	 * </p>
	 * @param parameter_type int[optional] <p>
	 * クオートするスタイルを変更するため、
	 * ドライバにデータ型のヒントを提供します。
	 * </p>
	 * @return string 理論上安全なクオートされた SQL ステートメントの文字列を返します。
	 * ドライバがこの方法での引用符付けをサポートしていない場合は
	 * FALSE を返します。
	 */
	public function quote ($string, $parameter_type = null) {}

	final public function __wakeup () {}

	final public function __sleep () {}

	/**
	 * 利用可能な PDO ドライバの配列を返す
	 * @link http://www.php.net/manual/ja/pdo.getavailabledrivers.php
	 * @return array PDO::getAvailableDrivers は PDO ドライバ名の配列を返します。
	 * もしドライバが何も利用できない場合、空の配列を返します。
	 */
	public static function getAvailableDrivers () {}

}

class PDOStatement implements Traversable {
	public $queryString;


	/**
	 * プリペアドステートメントを実行する
	 * @link http://www.php.net/manual/ja/pdostatement.execute.php
	 * @param input_parameters array[optional] <p>
	 * 実行される SQL 文の中のバインドパラメータと同数の要素からなる、
	 * 値の配列。すべての値は PDO::PARAM_STR として扱われます。
	 * </p>
	 * <p>
	 * ひとつのパラメータに対して複数の値をバインドすることはできません。
	 * 例えば、IN() 句の中のひとつのパラメータに対して
	 * 2 つの値をバインドすることはできません。
	 * </p>
	 * <p>
	 * 指定した数よりも多い値をバインドすることはできません。
	 * input_parameters のキーが
	 * PDO::prepare で指定した SQL にある数より多い場合は、
	 * ステートメントが失敗してエラーが発生します。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function execute (array $input_parameters = null) {}

	/**
	 * 結果セットから次の行を取得する
	 * @link http://www.php.net/manual/ja/pdostatement.fetch.php
	 * @param fetch_style int[optional] <p>
	 * 次のレコードを呼び出し元に返す方法を制御します。
	 * この値は、PDO::FETCH_* 定数のどれかで、
	 * デフォルトは PDO::ATTR_DEFAULT_FETCH_MODE の値
	 * (そのデフォルトは PDO::FETCH_BOTH) です。
	 * <p>
	 * PDO::FETCH_ASSOC: は、結果セットに
	 * 返された際のカラム名で添字を付けた配列を返します。
	 * </p>
	 * @param cursor_orientation int[optional] <p>
	 * スクロール可能なカーソルを表す PDOStatement オブジェクトの場合、
	 * この値により呼び出し側に返される行を定義します。
	 * この値は、PDO::FETCH_ORI_* 定数のどれかと
	 * する必要があり、
	 * PDO::FETCH_ORI_NEXT がデフォルトとなっています。
	 * PDOStatement に対してスクロール可能なカーソルを要求するためには、
	 * PDO::prepare を用いて SQL ステートメントを
	 * 準備する際、
	 * PDO::CURSOR_SCROLL に
	 * PDO::ATTR_CURSOR 属性を設定する必要があります。
	 * </p>
	 * @param cursor_offset int[optional] 
	 * @return mixed この関数が成功した場合の返り値は、取得形式によって異なります。
	 * 失敗した場合は常に FALSE を返します。
	 */
	public function fetch ($fetch_style = null, $cursor_orientation = null, $cursor_offset = null) {}

	/**
	 * 指定された変数名にパラメータをバインドする
	 * @link http://www.php.net/manual/ja/pdostatement.bindparam.php
	 * @param parameter mixed <p>
	 * パラメータ ID を指定します。名前付けされたプレースホルダを使った文に
	 * 対しては、:name 形式のパラメータ名となります。
	 * 疑問符プレースホルダを使った文に対しては、1 から始まるパラメータの
	 * 位置となります。
	 * </p>
	 * @param variable mixed <p>
	 * SQL ステートメントパラメータにバインドする PHP 変数名を指定します。
	 * </p>
	 * @param data_type int[optional] <p>
	 * パラメータに対して PDO::PARAM_* 定数を使った明示的なデータ型を指定します。
	 * ストアドプロシージャからの INOUT パラメータの場合、
	 * data_type パラメータに PDO::PARAM_INPUT_OUTPUT
	 * ビットを設定するためにビット OR を使用してください。
	 * </p>
	 * @param length int[optional] <p>
	 * データ型の長さを指定します。パラメータがストアドプロシージャからの
	 * OUT パラメータであることを示す場合、
	 * 明示的に長さを設定しなければなりません。
	 * </p>
	 * @param driver_options mixed[optional] <p>
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function bindParam ($parameter, &$variable, $data_type = null, $length = null, $driver_options = null) {}

	/**
	 * カラムを PHP 変数にバインドする
	 * @link http://www.php.net/manual/ja/pdostatement.bindcolumn.php
	 * @param column mixed <p>
	 * 結果セット中のカラム番号 (1 から始まる) を指定します。
	 * カラム名を使用する場合、
	 * ドライバによって返されるカラムの大文字小文字が一致する必要が
	 * あることをご承知おきください。
	 * </p>
	 * @param param mixed <p>
	 * カラムがバインドされる PHP 変数名を指定します。
	 * </p>
	 * @param type int[optional] <p>
	 * パラメータのデータ型を PDO::PARAM_* 定数で指定します。
	 * </p>
	 * @param maxlen int[optional] <p>
	 * 領域を事前に確保するためのヒント。
	 * </p>
	 * @param driverdata mixed[optional] <p>
	 * ドライバのオプションパラメータ。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function bindColumn ($column, &$param, $type = null, $maxlen = null, $driverdata = null) {}

	/**
	 * 値をパラメータにバインドする
	 * @link http://www.php.net/manual/ja/pdostatement.bindvalue.php
	 * @param parameter mixed <p>
	 * パラメータ ID。名前つきプレースホルダを使用する
	 * プリペアドステートメントの場合は、
	 * :name 形式のパラメータ名となります。
	 * 疑問符プレースホルダを使用するプリペアドステートメントの場合は、
	 * 1 から始まるパラメータの位置となります。
	 * </p>
	 * @param value mixed <p>
	 * パラメータにバインドする値。
	 * </p>
	 * @param data_type int[optional] <p>
	 * パラメータに対して PDO::PARAM_* 定数を使った明示的なデータ型を指定します。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function bindValue ($parameter, $value, $data_type = null) {}

	/**
	 * 直近の SQL ステートメントによって作用した行数を返す
	 * @link http://www.php.net/manual/ja/pdostatement.rowcount.php
	 * @return int 行の数を返します。
	 */
	public function rowCount () {}

	/**
	 * 結果セットの次行から単一カラムを返す
	 * @link http://www.php.net/manual/ja/pdostatement.fetchcolumn.php
	 * @param column_number int[optional] <p>
	 * 行から処理したい 0 で始まるカラム番号を指定します。
	 * 何も値が与えられない場合、
	 * PDOStatement::fetchColumn
	 * は最初のカラムをフェッチします。
	 * </p>
	 * @return string PDOStatement::fetchColumn
	 * は結果セットの次行から単一カラムを返します。
	 * </p>
	 * <p>
	 * PDOStatement::fetchColumn
	 * を使用してデータを処理する場合、同一行から
	 * 他のカラムを返す方法はありません。
	 */
	public function fetchColumn ($column_number = null) {}

	/**
	 * 全ての結果行を含む配列を返す
	 * @link http://www.php.net/manual/ja/pdostatement.fetchall.php
	 * @param fetch_style int[optional] <p>
	 * PDOStatement::fetch に文章化されているような
	 * 返される配列の内容を制御します。
	 * デフォルトは PDO::ATTR_DEFAULT_FETCH_MODE の値
	 * (そのデフォルトは PDO::FETCH_BOTH) です。
	 * </p>
	 * <p>
	 * 結果セットから単一カラムの全ての値を含む配列を返す場合、
	 * PDO::FETCH_COLUMN を指定します。
	 * column-index パラメータにどのカラムを返すかを
	 * 指定することができます。
	 * </p>
	 * <p>
	 * 結果セットから単一カラムの一意な値のみ取得する場合、
	 * PDO::FETCH_UNIQUE をビット OR した
	 * PDO::FETCH_COLUMN を指定します。
	 * </p>
	 * <p>
	 * 指定したカラムの値によってグループ化した連想配列を返す場合、
	 * PDO::FETCH_GROUP をビット OR した
	 * PDO::FETCH_COLUMN を指定します。
	 * </p>
	 * @param fetch_argument mixed[optional] <p>
	 * この引数は、fetch_style の値によって意味が異なります。
	 * <p>
	 * PDO::FETCH_COLUMN: ここで指定した、
	 * 0 から始まる番号のカラムを返します。
	 * </p>
	 * @param ctor_args array[optional] <p>
	 * fetch_style が
	 * PDO::FETCH_CLASS
	 * のときに使う、独自のクラスコンストラクタへの引数。
	 * </p>
	 * @return array PDOStatement::fetchAll は、
	 * 結果セットに残っている全ての行を含む配列を返します。
	 * この配列は、カラム値の配列
	 * もしくは各カラム名に対応するプロパティを持つオブジェクトをして
	 * 各行を表します。
	 * </p>
	 * <p>
	 * 大きな結果セットをフェッチするためにこのメソッドを使用することは、
	 * システムとネットワークリソースに大量の要求を行うことになります。
	 * PHP で全てのデータ処理と操作を行うよりも、データベースサーバー側で
	 * 結果セットを操作することを検討してください。例えば、PHP で処理を行う前に
	 * SQL で WHERE 句や ORDER BY 句を使用し、結果を制限することです。
	 */
	public function fetchAll ($fetch_style = null, $fetch_argument = null, array $ctor_args = null) {}

	/**
	 * 次の行を取得し、それをオブジェクトとして返す
	 * @link http://www.php.net/manual/ja/pdostatement.fetchobject.php
	 * @param class_name string[optional] <p>
	 * 作成されるクラスの名前。
	 * </p>
	 * @param ctor_args array[optional] <p>
	 * この配列の要素がコンストラクタに渡されます。
	 * </p>
	 * @return mixed カラム名に対応するプロパティを保持する、要求されたクラスの
	 * インスタンスを返します。失敗した場合に FALSE を返します。
	 */
	public function fetchObject ($class_name = null, array $ctor_args = null) {}

	/**
	 * 文ハンドラにおける直近の操作に関連する SQLSTATE を取得する
	 * @link http://www.php.net/manual/ja/pdostatement.errorcode.php
	 * @return string PDOStatement::errorCode
	 * は PDOStatement オブジェクトを用いて実行された操作に対する
	 * エラーコードを取得することを除き、
	 * PDO::errorCode と等価です。
	 */
	public function errorCode () {}

	/**
	 * 文ハンドラにおける直近の操作に関連する拡張エラー情報を取得する
	 * @link http://www.php.net/manual/ja/pdostatement.errorinfo.php
	 * @return array PDOStatement::errorInfo は、
	 * この文ハンドラによって実行された直近の操作に関するエラー情報を
	 * 配列として返します。この配列は次のフィールドを含みます。
	 * <tr valign="top">
	 * <td>要素</td>
	 * <td>情報</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>0</td>
	 * <td>SQLSTATE エラーコード
	 * (これは、ANSI SQL 標準で定義された英数 5 文字の ID)</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>1</td>
	 * <td>ドライバ固有のエラーコード</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>2</td>
	 * <td>ドライバ固有のエラーメッセージ</td>
	 * </tr>
	 */
	public function errorInfo () {}

	/**
	 * 文の属性を設定する
	 * @link http://www.php.net/manual/ja/pdostatement.setattribute.php
	 * @param attribute int 
	 * @param value mixed 
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setAttribute ($attribute, $value) {}

	/**
	 * 文の属性を取得する
	 * @link http://www.php.net/manual/ja/pdostatement.getattribute.php
	 * @param attribute int 
	 * @return mixed 属性の値を返します。
	 */
	public function getAttribute ($attribute) {}

	/**
	 * 結果セット中のカラム数を返す
	 * @link http://www.php.net/manual/ja/pdostatement.columncount.php
	 * @return int PDOStatement オブジェクトに相当する結果セットにあるカラム数を返します。
	 * もし結果セットがなければ、PDOStatement::columnCount
	 * は 0 を返します。
	 */
	public function columnCount () {}

	/**
	 * 結果セットのカラムに対するメタデータを返す
	 * @link http://www.php.net/manual/ja/pdostatement.getcolumnmeta.php
	 * @param column int <p>
	 * 結果セットの 0 から始まるカラムを指定します。
	 * </p>
	 * @return array 1つのカラムについてのメタデータに相当する次の値を含んだ連想配列を返します。
	 * </p>
	 * <table>
	 * カラムのメタデータ
	 * <tr valign="top">
	 * <td>名前</td>
	 * <td>値</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>native_type</td>
	 * <td>カラム値を表現するために使用される PHP のネイティブ型</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>driver:decl_type</td>
	 * <td>データベースにおけるカラム値を表現するために使用される SQL 型。
	 * もし、結果セットのカラムが関数から返される場合、
	 * この値は PDOStatement::getColumnMeta.
	 * よって返されません。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>flags</td>
	 * <td>このカラムにセットされているあらゆるフラグ</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>name</td>
	 * <td>データベースによって返されるこのカラムの名前</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>table</td>
	 * <td>データベースによって返されるこのカラムのテーブル名</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>len</td>
	 * <td>カラム長。浮動小数点数以外の型については通常
	 * -1 となる。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>precision</td>
	 * <td>カラムの数値精度。浮動小数点数以外の型については通常
	 * 0 となる。</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>pdo_type</td>
	 * <td>PDO::PARAM_*
	 * 定数によって表現されるカラムの型</td>
	 * </tr>
	 * </table>
	 * <p>
	 * 要求されたカラムが結果セットに存在しない、
	 * もしくは結果セットが存在しない場合、FALSE を返します。
	 */
	public function getColumnMeta ($column) {}

	/**
	 * この文に対するデフォルトのフェッチモードを設定する
	 * @link http://www.php.net/manual/ja/pdostatement.setfetchmode.php
	 * @param mode int <p>
	 * フェッチモードは、PDO::FETCH_* 定数の 1
	 * つでなければなりません。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function setFetchMode ($mode) {}

	/**
	 * 複数の行セットを返す文ハンドラで次の行セットに移動する
	 * @link http://www.php.net/manual/ja/pdostatement.nextrowset.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function nextRowset () {}

	/**
	 * カーソルを閉じてステートメントを再実行できるようにする
	 * @link http://www.php.net/manual/ja/pdostatement.closecursor.php
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function closeCursor () {}

	/**
	 * SQL プリペアドコマンドを出力する
	 * @link http://www.php.net/manual/ja/pdostatement.debugdumpparams.php
	 * @return bool 値を返しません。
	 */
	public function debugDumpParams () {}

	final public function __wakeup () {}

	final public function __sleep () {}

}

final class PDORow  {
}

function pdo_drivers () {}

// End of PDO v.1.0.4dev
?>
