<?php

// Start of SimpleXML v.0.1

class SimpleXMLElement implements Traversable {

	/**
	 * 新しい SimpleXMLElement オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/simplexmlelement.construct.php
	 * @param data
	 * @param options[optional]
	 * @param data_is_url[optional]
	 * @param ns[optional]
	 * @param is_prefix[optional]
	 */
	final public function __construct ($data, $options, $data_is_url, $ns, $is_prefix) {}

	/**
	 * SimpleXML 要素に基づき整形式の XML 文字列を返す
	 * @link http://www.php.net/manual/ja/simplexmlelement.asxml.php
	 * @param filename string[optional] <p>
	 * 指定した場合、データを返すかわりにファイルにデータを書き込みます。
	 * </p>
	 * @return mixed filename が指定されていない場合、この関数は
	 * 成功時に string 、エラー時に FALSE を返します。
	 * パラメータが指定されていた場合は、ファイルが正常に書き込めたときに
	 * TRUE 、そうでないときに FALSE を返します。
	 */
	public function asXML ($filename = null) {}

	/**
	 * <methodname>SimpleXMLElement::asXML</methodname> のエイリアス
	 * @link http://www.php.net/manual/ja/simplexmlelement.savexml.php
	 * @param filename[optional]
	 */
	public function saveXML ($filename) {}

	/**
	 * XML データに Xpath クエリを実行する
	 * @link http://www.php.net/manual/ja/simplexmlelement.xpath.php
	 * @param path string <p>
	 * XPath パス。
	 * </p>
	 * @return array SimpleXMLElement オブジェクトの配列を返します。
	 * エラーが発生した場合は FALSE を返します。
	 */
	public function xpath ($path) {}

	/**
	 * 次の XPath クエリ用の prefix/ns コンテキストを作成する
	 * @link http://www.php.net/manual/ja/simplexmlelement.registerxpathnamespace.php
	 * @param prefix string <p>
	 * ns で指定した名前空間への XPath クエリで使用する、
	 * 名前空間プレフィックス。
	 * </p>
	 * @param ns string <p>
	 * XPath クエリで使用する名前空間。
	 * これは XML ドキュメントで使用している名前空間と一致していなければなりません。
	 * 一致していない場合、prefix
	 * を使用した XPath クエリは何も結果を返しません。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function registerXPathNamespace ($prefix, $ns) {}

	/**
	 * 要素の属性を定義する
	 * @link http://www.php.net/manual/ja/simplexmlelement.attributes.php
	 * @param ns string[optional] <p>
	 * オプションで指定する、取得した属性の名前空間。
	 * </p>
	 * @param is_prefix bool[optional] <p>
	 * デフォルトは FALSE。
	 * </p>
	 * @return SimpleXMLElement SimpleXMLElement オブジェクトを返します。
	 * これを反復処理すれば、そのタグの属性を順に処理することができます。
	 * </p>
	 * <p>
	 * タグではなく属性を指している SimpleXMLElement
	 * に対してコールした場合は NULL を返します。
	 */
	public function attributes ($ns = null, $is_prefix = null) {}

	/**
	 * 指定したノードの子ノードを見付ける
	 * @link http://www.php.net/manual/ja/simplexmlelement.children.php
	 * @param ns string[optional] <p>
	 * XML 名前空間。
	 * </p>
	 * @param is_prefix bool[optional] <p>
	 * is_prefix が TRUE の場合は
	 * ns をプレフィックスとして扱います。FALSE の場合は
	 * ns を名前空間 URL として扱います。
	 * </p>
	 * @return SimpleXMLElement ノードが子を持つかどうかにかかわらず
	 * SimpleXMLElement 要素を返します。
	 */
	public function children ($ns = null, $is_prefix = null) {}

	/**
	 * ドキュメントで使用している名前空間を返す
	 * @link http://www.php.net/manual/ja/simplexmlelement.getnamespaces.php
	 * @param recursive bool[optional] <p>
	 * 指定されている場合は、親ノードおよび子ノードで使用している全ての名前空間を返します。
	 * されていない場合は、ルートノードで使用している名前空間のみを返します。
	 * </p>
	 * @return array getNamespaces メソッドは、
	 * 名前空間名および関連付けられた URI を配列で返します。
	 */
	public function getNamespaces ($recursive = null) {}

	/**
	 * ドキュメントで宣言されている名前空間を返す
	 * @link http://www.php.net/manual/ja/simplexmlelement.getdocnamespaces.php
	 * @param recursive bool[optional] <p>
	 * 指定されている場合は、親ノードおよび子ノードで宣言されている全ての名前空間を返します。
	 * されていない場合は、ルートノードで宣言されている名前空間のみを返します。
	 * </p>
	 * @return array getDocNamespaces メソッドは、
	 * 名前空間名および関連付けられた URI を配列で返します。
	 */
	public function getDocNamespaces ($recursive = null) {}

	/**
	 * XML 要素の名前を取得する
	 * @link http://www.php.net/manual/ja/simplexmlelement.getname.php
	 * @return string getName メソッドは、
	 * SimpleXMLElement オブジェクトが参照している XML タグの名前を
	 * string で返します。
	 */
	public function getName () {}

	/**
	 * XML ノードに子要素を追加する
	 * @link http://www.php.net/manual/ja/simplexmlelement.addchild.php
	 * @param name string <p>
	 * 追加する子要素の名前。
	 * </p>
	 * @param value string[optional] <p>
	 * 指定されている場合は、子要素の値。
	 * </p>
	 * @param namespace string[optional] <p>
	 * 指定されている場合は、その子要素が所属する名前空間。
	 * </p>
	 * @return SimpleXMLElement addChild メソッドは、
	 * XML ノードに追加した子要素を表す
	 * SimpleXMLElement オブジェクトを返します。
	 */
	public function addChild ($name, $value = null, $namespace = null) {}

	/**
	 * SimpleXML 要素に属性を追加する
	 * @link http://www.php.net/manual/ja/simplexmlelement.addattribute.php
	 * @param name string <p>
	 * 追加する属性の名前。
	 * </p>
	 * @param value string[optional] <p>
	 * 属性の値。
	 * </p>
	 * @param namespace string[optional] <p>
	 * 指定されている場合は、その属性が所属する名前空間。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function addAttribute ($name, $value = null, $namespace = null) {}

	public function __toString () {}

	/**
	 * 子要素を数える
	 * @link http://www.php.net/manual/ja/simplexmlelement.count.php
	 * @return int 子要素の数を返します。
	 */
	public function count () {}

}

class SimpleXMLIterator extends SimpleXMLElement implements Traversable, RecursiveIterator, Iterator, Countable {

	/**
	 * 最初の要素に巻き戻す
	 * @link http://www.php.net/manual/ja/simplexmliterator.rewind.php
	 * @return void 値を返しません。
	 */
	public function rewind () {}

	/**
	 * 現在の要素が有効かどうかを調べる
	 * @link http://www.php.net/manual/ja/simplexmliterator.valid.php
	 * @return bool 現在の要素が有効な場合に TRUE、そうでない場合に FALSE を返します。
	 */
	public function valid () {}

	/**
	 * 現在の SimpleXML エントリを返す
	 * @link http://www.php.net/manual/ja/simplexmliterator.current.php
	 * @return mixed 現在の要素を SimpleXMLIterator オブジェクトで返します。
	 * 失敗した場合は NULL を返します。
	 */
	public function current () {}

	/**
	 * 現在のキーを返す
	 * @link http://www.php.net/manual/ja/simplexmliterator.key.php
	 * @return mixed 現在の SimpleXMLIterator オブジェクトが参照する要素の XML
	 * タグ名、あるいは FALSE を返します。
	 */
	public function key () {}

	/**
	 * 次の要素に移動する
	 * @link http://www.php.net/manual/ja/simplexmliterator.next.php
	 * @return void 値を返しません。
	 */
	public function next () {}

	/**
	 * 現在の要素が子要素を持つかどうかを調べる
	 * @link http://www.php.net/manual/ja/simplexmliterator.haschildren.php
	 * @return bool 現在の要素が子要素を持つ場合に TRUE、それ以外の場合に FALSE を返します。
	 */
	public function hasChildren () {}

	/**
	 * 現在の要素の子要素を返す
	 * @link http://www.php.net/manual/ja/simplexmliterator.getchildren.php
	 * @return SimpleXMLIterator 現在の要素の子要素を含む SimpleXMLIterator
	 * オブジェクトを返します。
	 */
	public function getChildren () {}

	/**
	 * 新しい SimpleXMLElement オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/simplexmlelement.construct.php
	 * @param data
	 * @param options[optional]
	 * @param data_is_url[optional]
	 * @param ns[optional]
	 * @param is_prefix[optional]
	 */
	final public function __construct ($data, $options, $data_is_url, $ns, $is_prefix) {}

	/**
	 * SimpleXML 要素に基づき整形式の XML 文字列を返す
	 * @link http://www.php.net/manual/ja/simplexmlelement.asxml.php
	 * @param filename string[optional] <p>
	 * 指定した場合、データを返すかわりにファイルにデータを書き込みます。
	 * </p>
	 * @return mixed filename が指定されていない場合、この関数は
	 * 成功時に string 、エラー時に FALSE を返します。
	 * パラメータが指定されていた場合は、ファイルが正常に書き込めたときに
	 * TRUE 、そうでないときに FALSE を返します。
	 */
	public function asXML ($filename = null) {}

	/**
	 * <methodname>SimpleXMLElement::asXML</methodname> のエイリアス
	 * @link http://www.php.net/manual/ja/simplexmlelement.savexml.php
	 * @param filename[optional]
	 */
	public function saveXML ($filename) {}

	/**
	 * XML データに Xpath クエリを実行する
	 * @link http://www.php.net/manual/ja/simplexmlelement.xpath.php
	 * @param path string <p>
	 * XPath パス。
	 * </p>
	 * @return array SimpleXMLElement オブジェクトの配列を返します。
	 * エラーが発生した場合は FALSE を返します。
	 */
	public function xpath ($path) {}

	/**
	 * 次の XPath クエリ用の prefix/ns コンテキストを作成する
	 * @link http://www.php.net/manual/ja/simplexmlelement.registerxpathnamespace.php
	 * @param prefix string <p>
	 * ns で指定した名前空間への XPath クエリで使用する、
	 * 名前空間プレフィックス。
	 * </p>
	 * @param ns string <p>
	 * XPath クエリで使用する名前空間。
	 * これは XML ドキュメントで使用している名前空間と一致していなければなりません。
	 * 一致していない場合、prefix
	 * を使用した XPath クエリは何も結果を返しません。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public function registerXPathNamespace ($prefix, $ns) {}

	/**
	 * 要素の属性を定義する
	 * @link http://www.php.net/manual/ja/simplexmlelement.attributes.php
	 * @param ns string[optional] <p>
	 * オプションで指定する、取得した属性の名前空間。
	 * </p>
	 * @param is_prefix bool[optional] <p>
	 * デフォルトは FALSE。
	 * </p>
	 * @return SimpleXMLElement SimpleXMLElement オブジェクトを返します。
	 * これを反復処理すれば、そのタグの属性を順に処理することができます。
	 * </p>
	 * <p>
	 * タグではなく属性を指している SimpleXMLElement
	 * に対してコールした場合は NULL を返します。
	 */
	public function attributes ($ns = null, $is_prefix = null) {}

	/**
	 * 指定したノードの子ノードを見付ける
	 * @link http://www.php.net/manual/ja/simplexmlelement.children.php
	 * @param ns string[optional] <p>
	 * XML 名前空間。
	 * </p>
	 * @param is_prefix bool[optional] <p>
	 * is_prefix が TRUE の場合は
	 * ns をプレフィックスとして扱います。FALSE の場合は
	 * ns を名前空間 URL として扱います。
	 * </p>
	 * @return SimpleXMLElement ノードが子を持つかどうかにかかわらず
	 * SimpleXMLElement 要素を返します。
	 */
	public function children ($ns = null, $is_prefix = null) {}

	/**
	 * ドキュメントで使用している名前空間を返す
	 * @link http://www.php.net/manual/ja/simplexmlelement.getnamespaces.php
	 * @param recursive bool[optional] <p>
	 * 指定されている場合は、親ノードおよび子ノードで使用している全ての名前空間を返します。
	 * されていない場合は、ルートノードで使用している名前空間のみを返します。
	 * </p>
	 * @return array getNamespaces メソッドは、
	 * 名前空間名および関連付けられた URI を配列で返します。
	 */
	public function getNamespaces ($recursive = null) {}

	/**
	 * ドキュメントで宣言されている名前空間を返す
	 * @link http://www.php.net/manual/ja/simplexmlelement.getdocnamespaces.php
	 * @param recursive bool[optional] <p>
	 * 指定されている場合は、親ノードおよび子ノードで宣言されている全ての名前空間を返します。
	 * されていない場合は、ルートノードで宣言されている名前空間のみを返します。
	 * </p>
	 * @return array getDocNamespaces メソッドは、
	 * 名前空間名および関連付けられた URI を配列で返します。
	 */
	public function getDocNamespaces ($recursive = null) {}

	/**
	 * XML 要素の名前を取得する
	 * @link http://www.php.net/manual/ja/simplexmlelement.getname.php
	 * @return string getName メソッドは、
	 * SimpleXMLElement オブジェクトが参照している XML タグの名前を
	 * string で返します。
	 */
	public function getName () {}

	/**
	 * XML ノードに子要素を追加する
	 * @link http://www.php.net/manual/ja/simplexmlelement.addchild.php
	 * @param name string <p>
	 * 追加する子要素の名前。
	 * </p>
	 * @param value string[optional] <p>
	 * 指定されている場合は、子要素の値。
	 * </p>
	 * @param namespace string[optional] <p>
	 * 指定されている場合は、その子要素が所属する名前空間。
	 * </p>
	 * @return SimpleXMLElement addChild メソッドは、
	 * XML ノードに追加した子要素を表す
	 * SimpleXMLElement オブジェクトを返します。
	 */
	public function addChild ($name, $value = null, $namespace = null) {}

	/**
	 * SimpleXML 要素に属性を追加する
	 * @link http://www.php.net/manual/ja/simplexmlelement.addattribute.php
	 * @param name string <p>
	 * 追加する属性の名前。
	 * </p>
	 * @param value string[optional] <p>
	 * 属性の値。
	 * </p>
	 * @param namespace string[optional] <p>
	 * 指定されている場合は、その属性が所属する名前空間。
	 * </p>
	 * @return void 値を返しません。
	 */
	public function addAttribute ($name, $value = null, $namespace = null) {}

	public function __toString () {}

	/**
	 * 子要素を数える
	 * @link http://www.php.net/manual/ja/simplexmlelement.count.php
	 * @return int 子要素の数を返します。
	 */
	public function count () {}

}

/**
 * XMLファイルをパースし、オブジェクトに代入する
 * @link http://www.php.net/manual/ja/function.simplexml-load-file.php
 * @param filename string <p>
 * XML ファイルへのパス。
 * </p>
 * <p>
 * Libxml 2 は URI をエスケープしませんので、例えば URI パラメータ
 * a に b&amp;c を渡したい場合、
 * simplexml_load_file(rawurlencode('http://example.com/?a=' .
 * urlencode('b&amp;c')))
 * をしてコールする必要があります。PHP 5.1.0 以降では、これをする必要は
 * ありません。PHP が自動的に行います。
 * </p>
 * @param class_name string[optional] <p>
 * simplexml_load_file
 * が指定されたクラスのオブジェクトを返すようにするために、
 * このオプションのパラメータを使用します。
 * このクラスは、SimpleXMLElement
 * クラスを継承していなければなりません。
 * </p>
 * @param options int[optional] <p>
 * PHP 5.1.0 と Libxml 2.6.0 から、追加の Libxml パラメータ
 * を指定するために options
 * を使用することもできます。
 * </p>
 * @param ns string[optional] <p>
 * 名前空間プレフィックスあるいは URI。
 * </p>
 * @param is_prefix bool[optional] <p>
 * ns がプレフィックスである場合に TRUE、
 * URI である場合に FALSE。デフォルトは FALSE です。
 * </p>
 * @return SimpleXMLElement SimpleXMLElement クラスのオブジェクトを返します。
 * XML ドキュメント内のデータをプロパティに含みます。
 * 失敗した場合に FALSE を返します。
 */
function simplexml_load_file ($filename, $class_name = null, $options = null, $ns = null, $is_prefix = null) {}

/**
 * XML 文字列をオブジェクトに代入する
 * @link http://www.php.net/manual/ja/function.simplexml-load-string.php
 * @param data string <p>
 * 整形式 XML 文字列。
 * </p>
 * @param class_name string[optional] <p>
 * このオプションのパラメータを使用して、
 * simplexml_load_file
 * が指定されたクラスのオブジェクトを返すようにします。
 * このクラスは、SimpleXMLElement
 * クラスを継承していなければなりません。
 * </p>
 * @param options int[optional] <p>
 * PHP 5.1.0 と Libxml 2.6.0 から、追加の Libxml パラメータ
 * を指定するために options
 * を使用することもできます。
 * </p>
 * @param ns string[optional] <p>
 * 名前空間プレフィックスあるいは URI。
 * </p>
 * @param is_prefix bool[optional] <p>
 * ns がプレフィックスである場合に TRUE、
 * URI である場合に FALSE。デフォルトは FALSE です。
 * </p>
 * @return SimpleXMLElement SimpleXMLElement クラスのオブジェクトを返します。
 * XML ドキュメント内のデータをプロパティに含みます。
 * 失敗した場合に FALSE を返します。
 */
function simplexml_load_string ($data, $class_name = null, $options = null, $ns = null, $is_prefix = null) {}

/**
 * DOM ノードから <literal>SimpleXMLElement</literal> オブジェクトを取得する
 * @link http://www.php.net/manual/ja/function.simplexml-import-dom.php
 * @param node DOMNode <p>
 * DOM 要素ノード。
 * </p>
 * @param class_name string[optional] <p>
 * このオプションパラメータを使用すると、
 * simplexml_import_dom
 * は指定したクラスのオブジェクトを返します。このクラスは
 * SimpleXMLElement を継承していなければなりません。
 * </p>
 * @return SimpleXMLElement SimpleXMLElement を返します。失敗した場合に FALSE を返します。
 */
function simplexml_import_dom (DOMNode $node, $class_name = null) {}

// End of SimpleXML v.0.1
?>
