<?php

// Start of pcre v.

/**
 * 正規表現によるマッチングを行う
 * @link http://www.php.net/manual/ja/function.preg-match.php
 * @param pattern string <p>
 * 検索するパターンを表す文字列。
 * </p>
 * @param subject string <p>
 * 入力文字列。
 * </p>
 * @param matches array[optional] <p>
 * matches を指定した場合、検索結果が代入されます。
 * $matches[0] にはパターン全体にマッチしたテキストが代入され、
 * $matches[1] には 1 番目ののキャプチャ用サブパターンにマッチした
 * 文字列が代入され、といったようになります。
 * </p>
 * @param flags int[optional] <p>
 * flags には以下のフラグを指定できます。
 * PREG_OFFSET_CAPTURE
 * このフラグを設定した場合、各マッチに対応する文字列のオフセットも返されます。
 * これにより matches の値は配列となり、
 * 配列の要素 0 はマッチした文字列、
 * 要素 1は対象文字列中におけるマッチした文字列のオフセット値
 * となることに注意してください。
 * @param offset int[optional] <p>
 * 通常、検索は対象文字列の先頭から開始されます。
 * オプションのパラメータ offset を使用して
 * 検索の開始位置を (バイト単位で) 指定することも可能です。
 * </p>
 * <p>
 * offset を用いるのと、
 * substr($subject, $offset) を
 * preg_matchの対象文字列として指定するのとは
 * 等価ではありません。
 * これは、pattern には、
 * ^, $ や
 * (?&lt;=x) のような言明を含めることができるためです。
 * 以下を比べてみてください。
 * ]]>
 * 上の例の出力は以下となります。</p>
 * <p>
 * 一方、この例を見てください。
 * </p>
 * ]]>
 * <p>
 * 出力は以下のようになります。
 * </p>
 * Array
 * (
 * [0] => def
 * [1] => 0
 * )
 * )
 * ]]>
 * </p>
 * @return int preg_match は、pattern
 * が指定した subject にマッチした場合に 1 を返します。
 * マッチしなかった場合は 0、エラーが発生した場合は FALSE を返します。
 */
function preg_match ($pattern, $subject, array &$matches = null, $flags = null, $offset = null) {}

/**
 * 繰り返し正規表現検索を行う
 * @link http://www.php.net/manual/ja/function.preg-match-all.php
 * @param pattern string <p>
 * 検索するパターンを表す文字列。
 * </p>
 * @param subject string <p>
 * 通常、検索は対象文字列の先頭から開始されます。
 * オプションのパラメータ offset を使用して
 * 検索の開始位置を (バイト単位で) 指定することも可能です。
 * </p>
 * <p>
 * offset を用いるのと、
 * substr($subject, $offset) を
 * preg_match_allの対象文字列として指定するのとは
 * 等価ではありません。
 * これは、pattern には、
 * ^, $ や
 * (?&lt;=x) のような言明を含めることができるためです。
 * これに関する例については、
 * preg_match を参照してください。
 * </p>
 * @param matches array[optional] <p>
 * マッチしたすべての内容を含む、
 * flags
 * で指定した形式の多次元配列。
 * </p>
 * @param flags int[optional] <p>
 * 以下のフラグの組み合わせ
 * (PREG_PATTERN_ORDER を
 * PREG_SET_ORDER と組み合わせて使用することは
 * 無意味ですので注意してください)。
 * PREG_PATTERN_ORDER
 * <p>
 * $matches[0] はパターン全体にマッチした文字列の配列、
 * $matches[1] は第 1 のキャプチャ用サブパターンにマッチした文字列の配列、
 * といった順番となります。
 * </p>
 * <p>
 * ]]>
 * 上の例の出力は以下となります。</p>
 * example: , this is a test
 * example: , this is a test
 * ]]>
 * <p>
 * $out[0] はパターン全体にマッチした文字列の配列を有しており、
 * $out[1] はタグで囲まれた文字列の配列を有しています。
 * </p>
 * </p>
 * @param offset int[optional] 
 * @return int パターンがマッチした総数を返します（ゼロとなる可能性もあります）。
 * または、エラーが発生した場合に FALSE を返します。
 */
function preg_match_all ($pattern, $subject, array &$matches = null, $flags = null, $offset = null) {}

/**
 * 正規表現検索および置換を行う
 * @link http://www.php.net/manual/ja/function.preg-replace.php
 * @param pattern mixed <p>
 * 検索を行うパターン。文字列もしくは配列とすることができます。
 * </p>
 * <p>
 * PCRE 修飾子
 * も使えます。'e' (PREG_REPLACE_EVAL) は、この関数でだけ使える修飾子です。
 * </p>
 * @param replacement mixed <p>
 * 置換を行う文字列もしくは文字列の配列。
 * この引数が文字列で、pattern 引数が配列の場合、
 * すべてのパターンがこの文字列に置換されます。
 * pattern および replacement
 * のいずれもが配列の場合、各 pattern は
 * 対応する replacement に置換されます。
 * もし、replacement 配列の要素の数が pattern
 * 配列よりも少ない場合は、余った pattern は
 * 空文字に置換されます。
 * </p>
 * <p>
 * replacement では、
 * \\n 形式または
 * $n
 * 形式（PHP 4.0.4 以降）で参照を指定することができます。
 * 後者の形式の方が好ましい形式です。各参照は、n
 * 番目のキャプチャ用サブパターンにマッチしたテキストにより置換されます。
 * n は 0 から 99 までとすることができ、
 * \\0 または $0 は
 * パターン全体にマッチするテキストを参照します。キャプチャ用サブパターンの番号
 * については、その左括弧が左から右に（1から）カウントされます。
 * 置換文字でバックスラッシュを使用する場合は、二重化する必要があります
 * (PHP の文字列 "\\\\" となります)。
 * </p>
 * <p>
 * 後方参照の直後に他の数字が続くような置換 (replacement) パターンを
 * 使用する場合（すなわち、マッチしたパターンの直後に数字リテラルを置く
 * 場合）、後方参照を行うために通常の \\1 表記を
 * 使用することができません。例えば、\\11　は、
 * 後方参照 \\1 の後にリテラル
 * 1 が続くのか、後方参照 \\11 で
 * その後には何も続かないのかが不明のため、
 * preg_replace を混乱させる可能性があります。
 * この場合、解決策は、\${1}1 を使用することです。
 * こうすることで、1 はリテラルとなり、後方参照
 * $1 を明確に作成できます。
 * </p>
 * <p>
 * e 修飾子を使用する際に、
 * この関数は後方参照を置換する文字列のうちの特定の文字
 * (具体的には '、"、
 * \ および NULL) をエスケープします。
 * これは、後方参照をシングルクォートやダブルクォートを共用した場合
 * (たとえば 'strlen(\'$1\')+strlen("$2")')
 * に構文エラーが発生しないようにするためのものです。
 * PHP の 文字列構文 を意識し、
 * 文字列がどのように解釈されるのかを正確に知っておくようにしましょう。
 * </p>
 * @param subject mixed <p>
 * 検索・置換対象となる文字列もしくは文字列の配列
 * </p>
 * <p>
 * subject が配列の場合、検索と置換は
 * subject
 * の各要素に対して行われ、返り値も配列となります。
 * </p>
 * @param limit int[optional] <p>
 * subject 文字列において、各パターンによる
 * 置換を行う最大回数。デフォルトは
 * -1 (制限無し)。
 * </p>
 * @param count int[optional] <p>
 * この引数が指定されると、置換回数が渡されます。
 * </p>
 * @return mixed preg_replace は、
 * subject 引数が配列の場合は配列を、
 * その他の場合は文字列を返します。
 * </p>
 * <p>
 * パターンがマッチした場合、〔置換が行われた〕新しい subject
 * を返します。マッチしなかった場合、subject
 * をそのまま返します。エラーが発生した場合、NULL を返します。
 */
function preg_replace ($pattern, $replacement, $subject, $limit = null, &$count = null) {}

/**
 * 正規表現検索を行い、コールバック関数を使用して置換を行う
 * @link http://www.php.net/manual/ja/function.preg-replace-callback.php
 * @param pattern mixed <p>
 * 検索するパターン。
 * 文字列あるいは文字列の配列のいずれかとなります。
 * </p>
 * @param callback callable <p>
 * このコールバック関数は、検索対象文字列でマッチした要素の配列が指定されて
 * コールされます。このコールバック関数は、置換後の文字列を返す必要があります。
 * </p>
 * <p>
 * preg_replace_callback 用の
 * callback 関数が、
 * ひとつの場所だけで必要となることがあります。
 * そんな場合は、
 * 無名関数機能
 * (PHP 5.3.0 以降) あるいは create_function
 * を使って宣言した無名関数を
 * preg_replace_callback のコール時に使用します。
 * このようにすることにより、コールに関するすべての情報を 1 ヶ所に集め、
 * 他の場所で使用されないコールバック関数名で関数の名前空間を
 * 汚染しないようにすることができます。
 * </p>
 * <p>
 * preg_replace_callback と
 * create_function
 * ]]>
 * </p>
 * @param subject mixed <p>
 * 文字列あるいは文字列の配列で、
 * 検索および置換の対象となる文字列を指定します。
 * </p>
 * @param limit int[optional] <p>
 * subject 文字列における
 * 各パターンの最大置換回数。デフォルトは
 * -1 (無制限) です。
 * </p>
 * @param count int[optional] <p>
 * 指定した場合は、置換を行った回数がここに格納されます。
 * </p>
 * @return mixed preg_replace_callback は、
 * subject が配列の場合には配列を、
 * それ以外の場合は文字列を返します。
 * エラー時の返り値は NULL となります。
 * </p>
 * <p>
 * マッチするものが見つかった場合は新しい subject
 * を返し、それ以外の場合はもとの subject
 * をそのまま返します。
 */
function preg_replace_callback ($pattern, $callback, $subject, $limit = null, &$count = null) {}

/**
 * 正規表現による検索と置換を行う
 * @link http://www.php.net/manual/ja/function.preg-filter.php
 * @param pattern mixed 
 * @param replacement mixed 
 * @param subject mixed 
 * @param limit int[optional] 
 * @param count int[optional] 
 * @return mixed subject
 * が配列の場合は配列を、それ以外の場合は文字列を返します。
 * </p>
 * <p>
 * マッチする結果が見つからなかったりエラーが発生したりした場合は、
 * subject が array なら空の配列を返し、そうでなければ
 * NULL を返します。
 */
function preg_filter ($pattern, $replacement, $subject, $limit = null, &$count = null) {}

/**
 * 正規表現で文字列を分割する
 * @link http://www.php.net/manual/ja/function.preg-split.php
 * @param pattern string <p>
 * 検索するパターンを表す文字列。
 * </p>
 * @param subject string <p>
 * 入力文字列。
 * </p>
 * @param limit int[optional] <p>
 * これを指定した場合、最大
 * limit 個の部分文字列を返します。
 * 残りの文字列は、最後の部分文字列に含めて返されます。
 * limit が -1、0 あるいは NULL の場合は「制限が無い」ことを意味します。
 * 制限を指定せずに
 * flags パラメータを指定したい場合などに NULL を使用します。
 * </p>
 * @param flags int[optional] <p>
 * flags は、次のフラグを組み合わせたものとする
 * （ビット和演算子 | で組み合わせる）ことが可能です。
 * PREG_SPLIT_NO_EMPTY
 * このフラグを設定すると、空文字列でないものだけが
 * preg_split により返されます。
 * @return array pattern にマッチした境界で分割した
 * subject の部分文字列の配列を返します。
 */
function preg_split ($pattern, $subject, $limit = null, $flags = null) {}

/**
 * 正規表現文字をクオートする
 * @link http://www.php.net/manual/ja/function.preg-quote.php
 * @param str string <p>
 * 入力文字列。
 * </p>
 * @param delimiter string[optional] <p>
 * オプションの delimiter を指定すると、
 * ここで指定した文字もエスケープされます。これは、PCRE 関数が使用する
 * デリミタをエスケープする場合に便利です。'/' がデリミタとしては
 * 最も一般的に使用されています。
 * </p>
 * @return string クォートされた文字列を返します。
 */
function preg_quote ($str, $delimiter = null) {}

/**
 * パターンにマッチする配列の要素を返す
 * @link http://www.php.net/manual/ja/function.preg-grep.php
 * @param pattern string <p>
 * 検索するパターンを表す文字列。
 * </p>
 * @param input array <p>
 * 入力の配列。
 * </p>
 * @param flags int[optional] <p>
 * PREG_GREP_INVERT
 * を設定すると、この関数は
 * 与えた pattern にマッチ しない
 * 要素を返します。
 * </p>
 * @return array input 配列のキーを使用した配列を返します。
 */
function preg_grep ($pattern, array $input, $flags = null) {}

/**
 * 直近の PCRE 正規表現処理のエラーコードを返す
 * @link http://www.php.net/manual/ja/function.preg-last-error.php
 * @return int 以下の定数のいずれかを返します (別のページで説明します)。
 * PREG_NO_ERROR
 * PREG_INTERNAL_ERROR
 * PREG_BACKTRACK_LIMIT_ERROR (pcre.backtrack_limit も参照ください)
 * PREG_RECURSION_LIMIT_ERROR (pcre.recursion_limit も参照ください)
 * PREG_BAD_UTF8_ERROR
 * PREG_BAD_UTF8_OFFSET_ERROR (PHP 5.3.0 以降)
 */
function preg_last_error () {}


/**
 * $matches[0] はパターン全体にマッチした文字列の配列、
 * $matches[1] は第 1 のキャプチャ用サブパターンにマッチした文字列の配列、
 * といったように結果の順序を指定します。
 * このフラグは、preg_match_all でのみ使用されます。
 * @link http://www.php.net/manual/ja/pcre.constants.php
 */
define ('PREG_PATTERN_ORDER', 1);

/**
 * $matches[0] は 1 回目のマッチングでキャプチャした値の配列、
 * $matches[1] は 2 回目のマッチングでキャプチャした値の配列、
 * といったように結果の順序を指定します。
 * このフラグは、preg_match_all でのみ使用されます。
 * @link http://www.php.net/manual/ja/pcre.constants.php
 */
define ('PREG_SET_ORDER', 2);

/**
 * PREG_SPLIT_OFFSET_CAPTURE の説明を参照してください。
 * @link http://www.php.net/manual/ja/pcre.constants.php
 */
define ('PREG_OFFSET_CAPTURE', 256);

/**
 * このフラグは、preg_split が、空文字列でないものだけ
 * を返すようにします。
 * @link http://www.php.net/manual/ja/pcre.constants.php
 */
define ('PREG_SPLIT_NO_EMPTY', 1);

/**
 * このフラグは、preg_split が
 * 文字列分割用のパターン中のカッコによるサブパターンでキャプチャされた値も
 * 同時に返すようにします。
 * @link http://www.php.net/manual/ja/pcre.constants.php
 */
define ('PREG_SPLIT_DELIM_CAPTURE', 2);

/**
 * このフラグを設定した場合、各マッチに対応する文字列のオフセットも返されます。
 * これにより、返り値は配列となり、配列の要素 0 はマッチした文字列、 要素 1 
 * は対象文字列中におけるマッチした文字列のオフセット値となることに注意してください。 
 * このフラグは
 * preg_split のみで使用されます。
 * @link http://www.php.net/manual/ja/pcre.constants.php
 */
define ('PREG_SPLIT_OFFSET_CAPTURE', 4);
define ('PREG_GREP_INVERT', 1);

/**
 * エラーが存在しなかった場合に
 * preg_last_error から返されます。
 * @link http://www.php.net/manual/ja/pcre.constants.php
 */
define ('PREG_NO_ERROR', 0);

/**
 * PCRE 内部エラーが発生した場合に
 * preg_last_error から返されます。
 * @link http://www.php.net/manual/ja/pcre.constants.php
 */
define ('PREG_INTERNAL_ERROR', 1);

/**
 * backtrack limit に達した場合に
 * preg_last_error から返されます。
 * @link http://www.php.net/manual/ja/pcre.constants.php
 */
define ('PREG_BACKTRACK_LIMIT_ERROR', 2);

/**
 * recursion limit に達した場合に
 * preg_last_error から返されます。
 * @link http://www.php.net/manual/ja/pcre.constants.php
 */
define ('PREG_RECURSION_LIMIT_ERROR', 3);

/**
 * 壊れている UTF8 データによって直近のエラーが発生した場合に
 * preg_last_error から返されます
 * (UTF-8 モード
 * で正規表現を実行した場合のみ)。
 * @link http://www.php.net/manual/ja/pcre.constants.php
 */
define ('PREG_BAD_UTF8_ERROR', 4);

/**
 * オフセットが妥当な UTF-8 コードポイントの開始位置に対応しない場合に
 * preg_last_error から返されます
 * (UTF-8 モード
 * で正規表現を実行した場合のみ)。
 * @link http://www.php.net/manual/ja/pcre.constants.php
 */
define ('PREG_BAD_UTF8_OFFSET_ERROR', 5);

/**
 * PCRE のバージョンおよびリリース日 (例: "7.0 18-Dec-2006")。
 * @link http://www.php.net/manual/ja/pcre.constants.php
 */
define ('PCRE_VERSION', "8.31 2012-07-06");

// End of pcre v.
?>
