<?php

// Start of mongo v.1.3.1

class MongoClient  {
	const DEFAULT_HOST = "localhost";
	const DEFAULT_PORT = 27017;
	const VERSION = "1.3.1";
	const RP_PRIMARY = "primary";
	const RP_PRIMARY_PREFERRED = "primaryPreferred";
	const RP_SECONDARY = "secondary";
	const RP_SECONDARY_PREFERRED = "secondaryPreferred";
	const RP_NEAREST = "nearest";

	public $connected;
	public $status;
	protected $server;
	protected $persistent;


	/**
	 * @param server[optional]
	 * @param options[optional]
	 */
	public function __construct ($serverarray , $options) {}

	/**
	 * 開いているすべての接続の情報を返す
	 * @link http://www.php.net/manual/ja/mongoclient.getconnections.php
	 * @return void 開いている接続に関する配列を返します。
	 */
	public static function getConnections () {}

	public function connect () {}

	public function __toString () {}

	/**
	 * @param name
	 */
	public function __get ($name) {}

	/**
	 * @param database_name
	 */
	public function selectDB ($database_name) {}

	/**
	 * @param database_name
	 * @param collection_name[optional]
	 */
	public function selectCollection ($database_name, $collection_name) {}

	/**
	 * この接続の優先読み込みを取得する
	 * @link http://www.php.net/manual/ja/mongoclient.getreadpreference.php
	 * @return array 
	 */
	public function getReadPreference () {}

	/**
	 * この接続の優先読み込みを設定する
	 * @link http://www.php.net/manual/ja/mongoclient.setreadpreference.php
	 * @param read_preference string <p>読み込みの優先モード。MongoClient::RP_PRIMARY、MongoClient::RP_PRIMARY_PREFERRED、MongoClient::RP_SECONDARY、MongoClient::RP_SECONDARY_PREFERRED あるいは MongoClient::RP_NEAREST のいずれか。</p>
	 * @param tags array[optional] <p>ゼロ個以上のタグセットの配列。各タグセット自体も配列で、レプリカセットのメンバーのタグにマッチさせる条件として使います。</p>
	 * @return bool 
	 */
	public function setReadPreference ($read_preference, array $tags = null) {}

	/**
	 * @param MongoDB_object_OR_database_name
	 */
	public function dropDB ($MongoDB_object_OR_database_name) {}

	public function listDBs () {}

	public function getHosts () {}

	public function close () {}

}

class Mongo extends MongoClient  {
	const DEFAULT_HOST = "localhost";
	const DEFAULT_PORT = 27017;
	const VERSION = "1.3.1";
	const RP_PRIMARY = "primary";
	const RP_PRIMARY_PREFERRED = "primaryPreferred";
	const RP_SECONDARY = "secondary";
	const RP_SECONDARY_PREFERRED = "secondaryPreferred";
	const RP_NEAREST = "nearest";

	public $connected;
	public $status;
	protected $server;
	protected $persistent;


	/**
	 * 新しいデータベース接続オブジェクトを作成する
	 * @link http://www.php.net/manual/ja/mongoclient.construct.php
	 * @param server[optional]
	 * @param options[optional]
	 */
	public function __construct ($serverarray , $options) {}

	/**
	 * データベースサーバーに接続する
	 * @link http://www.php.net/manual/ja/mongo.connectutil.php
	 * @return bool 接続に成功したかどうかを返します。
	 */
	protected function connectUtil () {}

	/**
	 * この接続の slaveOkay 設定を取得する
	 * @link http://www.php.net/manual/ja/mongo.getslaveokay.php
	 * @return bool このインスタンスの slaveOkay の値を返します。
	 */
	public function getSlaveOkay () {}

	/**
	 * この接続の slaveOkay の設定を変更する
	 * @link http://www.php.net/manual/ja/mongo.setslaveokay.php
	 * @param ok bool[optional] <p>
	 * 可能な限りの問い合わせをレプリカセットのセカンダリメンバに送信したいときに、この
	 * MongoClient インスタンスを使います。
	 * </p>
	 * @return bool このインスタンスの、変更前の slaveOkay の値を返します。
	 */
	public function setSlaveOkay ($ok = null) {}

	public function lastError () {}

	public function prevError () {}

	public function resetError () {}

	public function forceError () {}

	/**
	 * slaveOkay の読み込みに使われているアドレスを返す
	 * @link http://www.php.net/manual/ja/mongo.getslave.php
	 * @return string この接続が読み込みに使っているセカンダリのアドレスを返します。
	 * </p>
	 * <p>
	 * レプリカセットへの接続ではない場合や接続がまだ初期化されていない場合は
	 * NULL を返します。
	 */
	public function getSlave () {}

	/**
	 * slaveOkay 読み込み用の新しいセカンダリを選ぶ
	 * @link http://www.php.net/manual/ja/mongo.switchslave.php
	 * @return string この接続が読み込みに使っているセカンダリのアドレスを返します。
	 * アドレスはランダムに選ばれるので、前と同じアドレスになることもあります。
	 * 稼働中のセカンダリが 1 台だけ (あるいはプライマリだけ) の場合はひとつのアドレスしか返しません。
	 * </p>
	 * <p>
	 * たとえば、プライマリ・セカンダリ・アービター (調停者) の 3 台からなるレプリカセットの場合、
	 * このメソッドは常にセカンダリのアドレスを返します。セカンダリがダウンしているときは、
	 * このメソッドは常にプライマリのアドレスを返します。プライマリもダウンしたときは
	 * このメソッドは例外をスローします。アービターが読み込みを処理できないからです。
	 */
	public function switchSlave () {}

	/**
	 * 新しい接続プールのサイズを設定する
	 * @link http://www.php.net/manual/ja/mongo.setpoolsize.php
	 * @param size int <p>
	 * 新しい接続プールが作成できる接続の最大数。
	 * 負の値を設定すると、接続を無限に作成できるようになります。
	 * </p>
	 * @return bool 設定する前のプールのサイズを返します。
	 */
	public static function setPoolSize ($size) {}

	/**
	 * 接続プールのサイズを取得する
	 * @link http://www.php.net/manual/ja/mongo.getpoolsize.php
	 * @return int 現在のプールのサイズを返します。
	 */
	public static function getPoolSize () {}

	/**
	 * すべての接続プールに関する情報を返す
	 * @link http://www.php.net/manual/ja/mongo.pooldebug.php
	 * @return array 各接続プールには識別子があり、ホスト名から始まります。
	 * 個々の接続プールに対して、この関数は次のフィールドを表示します。
	 * in use
	 * <p>
	 * 現在 MongoClient のインスタンスが使っている接続数。
	 * </p>
	 * in pool
	 * <p>
	 * 現在プールにある (未使用の) 接続数。
	 * </p>
	 * remaining
	 * <p>
	 * このプールで作れる接続数。たとえば、このプールで作れる接続数が 5 つで
	 * 現在プール内にある接続数が 3 であるとしましょう。この場合、プールを使い切るまでに
	 * MongoClient の新しいインスタンスを 8 つ作れることになります
	 * (MongoClient のインスタンスがスコープ外に出て、
	 * 接続をプールに返すことはないものとします)。
	 * </p>
	 * <p>
	 * 負の値は、このプールでは無制限に接続を作れることを意味します。
	 * </p>
	 * <p>
	 * プールを作る前には、接続の最大数を
	 * Mongo::setPoolSize で変更できます。
	 * この関数の出力でいったんプールを表示してしまうと、そのサイズは変更できません。
	 * </p>
	 * timeout
	 * <p>
	 * このプール内の接続のソケットタイムアウト。
	 * このプール内の接続がサーバーへの接続を試みるときにどれだけ待つかを決めます。
	 * </p>
	 */
	public static function poolDebug () {}

	/**
	 * 開いているすべての接続の情報を返す
	 * @link http://www.php.net/manual/ja/mongoclient.getconnections.php
	 * @return void 開いている接続に関する配列を返します。
	 */
	public static function getConnections () {}

	public function connect () {}

	public function __toString () {}

	/**
	 * @param name
	 */
	public function __get ($name) {}

	/**
	 * @param database_name
	 */
	public function selectDB ($database_name) {}

	/**
	 * @param database_name
	 * @param collection_name[optional]
	 */
	public function selectCollection ($database_name, $collection_name) {}

	/**
	 * この接続の優先読み込みを取得する
	 * @link http://www.php.net/manual/ja/mongoclient.getreadpreference.php
	 * @return array 
	 */
	public function getReadPreference () {}

	/**
	 * この接続の優先読み込みを設定する
	 * @link http://www.php.net/manual/ja/mongoclient.setreadpreference.php
	 * @param read_preference string <p>読み込みの優先モード。MongoClient::RP_PRIMARY、MongoClient::RP_PRIMARY_PREFERRED、MongoClient::RP_SECONDARY、MongoClient::RP_SECONDARY_PREFERRED あるいは MongoClient::RP_NEAREST のいずれか。</p>
	 * @param tags array[optional] <p>ゼロ個以上のタグセットの配列。各タグセット自体も配列で、レプリカセットのメンバーのタグにマッチさせる条件として使います。</p>
	 * @return bool 
	 */
	public function setReadPreference ($read_preference, array $tags = null) {}

	/**
	 * @param MongoDB_object_OR_database_name
	 */
	public function dropDB ($MongoDB_object_OR_database_name) {}

	public function listDBs () {}

	public function getHosts () {}

	public function close () {}

}

class MongoDB  {
	const PROFILING_OFF = 0;
	const PROFILING_SLOW = 1;
	const PROFILING_ON = 2;

	public $w;
	public $wtimeout;


	/**
	 * 新しいデータベースを作成する
	 * @link http://www.php.net/manual/ja/mongodb.construct.php
	 * @param connection MongoClient
	 * @param database_name
	 */
	public function __construct (MongoClient $connection, $database_name) {}

	/**
	 * このデータベースの名前
	 * @link http://www.php.net/manual/ja/mongodb.--tostring.php
	 * @return string このデータベースの名前を返します。
	 */
	public function __toString () {}

	/**
	 * コレクションを取得する
	 * @link http://www.php.net/manual/ja/mongodb.get.php
	 * @param name string <p>
	 * コレクションの名前。
	 * </p>
	 * @return MongoCollection コレクションを返します。
	 */
	public function __get ($name) {}

	/**
	 * このデータベースに格納されているファイルを扱うためのツールキットを取得する
	 * @link http://www.php.net/manual/ja/mongodb.getgridfs.php
	 * @param prefix string[optional] <p>
	 * ファイルやチャンクのコレクションのプレフィックス。
	 * </p>
	 * @return MongoGridFS このデータベースの新しい gridfs オブジェクトを返します。
	 */
	public function getGridFS ($prefix = null) {}

	/**
	 * このデータベースの slaveOkay 設定を取得する
	 * @link http://www.php.net/manual/ja/mongodb.getslaveokay.php
	 * @return bool このインスタンスの slaveOkay の値を返します。
	 */
	public function getSlaveOkay () {}

	/**
	 * このデータベースの slaveOkay の設定を変更する
	 * @link http://www.php.net/manual/ja/mongodb.setslaveokay.php
	 * @param ok bool[optional] <p>
	 * 可能な限りの問い合わせをレプリカセットのセカンダリメンバに送信したいときに、この
	 * Mongo インスタンスを使います。
	 * </p>
	 * @return bool このインスタンスの、変更前の slaveOkay の値を返します。
	 */
	public function setSlaveOkay ($ok = null) {}

	/**
	 * このデータベースの優先読み込みを取得する
	 * @link http://www.php.net/manual/ja/mongodb.getreadpreference.php
	 * @return array 
	 */
	public function getReadPreference () {}

	/**
	 * このデータベースの優先読み込みを設定する
	 * @link http://www.php.net/manual/ja/mongodb.setreadpreference.php
	 * @param read_preference string <p>読み込みの優先モード。MongoClient::RP_PRIMARY、MongoClient::RP_PRIMARY_PREFERRED、MongoClient::RP_SECONDARY、MongoClient::RP_SECONDARY_PREFERRED あるいは MongoClient::RP_NEAREST のいずれか。</p>
	 * @param tags array[optional] <p>ゼロ個以上のタグセットの配列。各タグセット自体も配列で、レプリカセットのメンバーのタグにマッチさせる条件として使います。</p>
	 * @return bool 
	 */
	public function setReadPreference ($read_preference, array $tags = null) {}

	/**
	 * このデータベースのプロファイリングレベルを取得する
	 * @link http://www.php.net/manual/ja/mongodb.getprofilinglevel.php
	 * @return int プロファイリングレベルを返します。
	 */
	public function getProfilingLevel () {}

	/**
	 * このデータベースのプロファイリングレベルを設定する
	 * @link http://www.php.net/manual/ja/mongodb.setprofilinglevel.php
	 * @param level int <p>
	 * プロファイリングレベル。
	 * </p>
	 * @return int 前に設定されていたプロファイリングレベルを返します。
	 */
	public function setProfilingLevel ($level) {}

	/**
	 * このデータベースを削除する
	 * @link http://www.php.net/manual/ja/mongodb.drop.php
	 * @return array データベースの応答を返します。
	 */
	public function drop () {}

	/**
	 * このデータベースを修復・圧縮する
	 * @link http://www.php.net/manual/ja/mongodb.repair.php
	 * @param preserve_cloned_files bool[optional] <p>
	 * 修復に失敗した場合に、コピーしたファイルを保持します。
	 * </p>
	 * @param backup_original_files bool[optional] <p>
	 * 元ファイルをバックアップするかどうか。
	 * </p>
	 * @return array データベースの応答を返します。
	 */
	public function repair ($preserve_cloned_files = null, $backup_original_files = null) {}

	/**
	 * コレクションを取得する
	 * @link http://www.php.net/manual/ja/mongodb.selectcollection.php
	 * @param name string <p>
	 * コレクションの名前。
	 * </p>
	 * @return MongoCollection コレクションを返します。
	 */
	public function selectCollection ($name) {}

	/**
	 * コレクションを作成する
	 * @link http://www.php.net/manual/ja/mongodb.createcollection.php
	 * @param name string <p>
	 * コレクションの名前。
	 * </p>
	 * @param options array[optional] <p>
	 * コレクションのオプションを含む配列。個々のオプション用の要素がこの配列に用意されており、
	 * 以下に挙げるオプション名が配列のキーになります。サポートするオプションは
	 * MongoDB サーバーのバージョンによって変わります。
	 * 現時点でサポートするオプションは、次のとおりです。
	 * </p>
	 * <p>
	 * capped
	 * <p>
	 * コレクションが固定サイズかどうか。
	 * </p>
	 * @return MongoCollection 新しいコレクションをあらわすコレクションオブジェクトを返します。
	 */
	public function createCollection ($name, array $options = null) {}

	/**
	 * コレクションを削除する [非推奨]
	 * @link http://www.php.net/manual/ja/mongodb.dropcollection.php
	 * @param coll mixed <p>
	 * 削除したい MongoCollection あるいはコレクション名。
	 * </p>
	 * @return array データベースの応答を返します。
	 */
	public function dropCollection ($coll) {}

	/**
	 * このデータベース内のすべての MongoCollection の配列を取得する
	 * @link http://www.php.net/manual/ja/mongodb.listcollections.php
	 * @param includeSystemCollections bool[optional] <p>
	 * システムコレクションを含める。
	 * </p>
	 * @return array MongoCollection オブジェクトの配列を返します。
	 */
	public function listCollections ($includeSystemCollections = null) {}

	/**
	 * このデータベースのすべてのコレクションを取得する
	 * @link http://www.php.net/manual/ja/mongodb.getcollectionnames.php
	 * @param includeSystemCollections bool[optional] <p>
	 * システムコレクションを含むかどうか。
	 * </p>
	 * @return array 指定したデータベースのすべてのコレクションの名前を配列で返します。
	 */
	public function getCollectionNames ($includeSystemCollections = null) {}

	/**
	 * データベース参照を作成する
	 * @link http://www.php.net/manual/ja/mongodb.createdbref.php
	 * @param collection string <p>
	 * データベース参照が指すコレクション。
	 * </p>
	 * @param a mixed <p>
	 * 参照を作成するオブジェクトあるいは _id。オブジェクトあるいは連想配列を渡した場合は、
	 * _id フィールドを使って参照を作成します。
	 * </p>
	 * @return array データベース参照配列を返します。
	 */
	public function createDBRef ($collection, $a) {}

	/**
	 * データベース参照が指すドキュメントを取得する
	 * @link http://www.php.net/manual/ja/mongodb.getdbref.php
	 * @param ref array <p>
	 * データベース参照。
	 * </p>
	 * @return array 参照が指すドキュメントを返します。
	 */
	public function getDBRef (array $ref) {}

	/**
	 * JavaScript コードをデータベースサーバー上で実行する
	 * @link http://www.php.net/manual/ja/mongodb.execute.php
	 * @param code mixed <p>
	 * 実行したい MongoCode あるいは文字列。
	 * </p>
	 * @param args array[optional] <p>
	 * code に渡す引数。
	 * </p>
	 * @return array 評価した結果を返します。
	 */
	public function execute ($code, array $args = null) {}

	/**
	 * データベースコマンドを実行する
	 * @link http://www.php.net/manual/ja/mongodb.command.php
	 * @param command array <p>
	 * 送信したいクエリ。
	 * </p>
	 * @param options array[optional] <p>
	 * array("オプション名" => &lt;boolean&gt;, ...)
	 * 形式の連想配列です。現在サポートするオプションは次のとおりです。
	 * <p>"timeout"</p>
	 * <p>整数で、デフォルトは MongoCursor::$timeout です。
	 * 確認付き書き込みを使っている場合、これはクライアントがデータベースからのレスポンスを待ち続ける時間 (ミリ秒) を表します。
	 * この時間内にデータベースからの反応がなければ、MongoCursorTimeoutException をスローします。</p>
	 * @return array データベースの応答を返します。データベースの応答はすべて、
	 * 最大で 1 件のドキュメントになります。つまり、データベースへのコマンドの結果は決して
	 * 16MB を超えないということです。結果のドキュメントの構造はコマンドによって異なりますが、
	 * 大半の結果には ok フィールドがあって、これが成功したか失敗したかを表します。
	 * また、同じく大半の結果には results フィールドもあって、
	 * ここにドキュメントの配列が含まれます。
	 */
	public function command (array $command, array $options = null) {}

	/**
	 * 直近のデータベース操作でエラーが発生したかどうかを調べる
	 * @link http://www.php.net/manual/ja/mongodb.lasterror.php
	 * @return array エラーがあった場合はそれを返します。
	 */
	public function lastError () {}

	/**
	 * データベース操作中の直近に発生したエラーを調べる
	 * @link http://www.php.net/manual/ja/mongodb.preverror.php
	 * @return array エラーと、それが何回前の操作で発生したかを返します。
	 */
	public function prevError () {}

	/**
	 * データベースで発生したすべてのエラーをクリアする
	 * @link http://www.php.net/manual/ja/mongodb.reseterror.php
	 * @return array データベースからの応答を返します。
	 */
	public function resetError () {}

	/**
	 * データベースのエラーを作成する
	 * @link http://www.php.net/manual/ja/mongodb.forceerror.php
	 * @return bool データベースからの応答を返します。
	 */
	public function forceError () {}

	/**
	 * このデータベースにログインする
	 * @link http://www.php.net/manual/ja/mongodb.authenticate.php
	 * @param username string <p>
	 * ユーザー名。
	 * </p>
	 * @param password string <p>
	 * パスワード (プレーンテキスト)。
	 * </p>
	 * @return array データベースからの応答を返します。ログインに成功すると、次のようになります。
	 * 1);
	 * ?>
	 * ]]>
	 * 何かが失敗した場合は、次のようになります。
	 * 0, "errmsg" => "auth fails");
	 * ?>
	 * ]]>
	 * ("auth fails" は別のメッセージかもしれません。
	 * データベースのバージョンや問題の原因によって変わります)。
	 */
	public function authenticate ($username, $password) {}

}

class MongoCollection  {
	const ASCENDING = 1;
	const DESCENDING = -1;

	public $w;
	public $wtimeout;


	/**
	 * 新しいコレクションを作成する
	 * @link http://www.php.net/manual/ja/mongocollection.construct.php
	 * @param database MongoDB
	 * @param collection_name
	 */
	public function __construct (MongoDB $database, $collection_name) {}

	/**
	 * このコレクションの文字列表現
	 * @link http://www.php.net/manual/ja/mongocollection.--tostring.php
	 * @return string このコレクションの完全な名前を返します。
	 */
	public function __toString () {}

	/**
	 * コレクションを取得する
	 * @link http://www.php.net/manual/ja/mongocollection.get.php
	 * @param name string <p>
	 * コレクション名の中の次の文字列。
	 * </p>
	 * @return MongoCollection コレクションを返します。
	 */
	public function __get ($name) {}

	/**
	 * コレクションの名前を返す
	 * @link http://www.php.net/manual/ja/mongocollection.getname.php
	 * @return string コレクションの名前を返します。
	 */
	public function getName () {}

	/**
	 * このコレクションの slaveOkay 設定を取得する
	 * @link http://www.php.net/manual/ja/mongocollection.getslaveokay.php
	 * @return bool このインスタンスの slaveOkay の値を返します。
	 */
	public function getSlaveOkay () {}

	/**
	 * このコレクションの slaveOkay の設定を変更する
	 * @link http://www.php.net/manual/ja/mongocollection.setslaveokay.php
	 * @param ok bool[optional] <p>
	 * 可能な限りの問い合わせをレプリカセットのセカンダリメンバに送信したいときに、この
	 * Mongo インスタンスを使います。
	 * </p>
	 * @return bool このインスタンスの、変更前の slaveOkay の値を返します。
	 */
	public function setSlaveOkay ($ok = null) {}

	/**
	 * このコレクションの優先読み込みを取得する
	 * @link http://www.php.net/manual/ja/mongocollection.getreadpreference.php
	 * @return array 
	 */
	public function getReadPreference () {}

	/**
	 * このコレクションの優先読み込みを設定する
	 * @link http://www.php.net/manual/ja/mongocollection.setreadpreference.php
	 * @param read_preference string <p>読み込みの優先モード。MongoClient::RP_PRIMARY、MongoClient::RP_PRIMARY_PREFERRED、MongoClient::RP_SECONDARY、MongoClient::RP_SECONDARY_PREFERRED あるいは MongoClient::RP_NEAREST のいずれか。</p>
	 * @param tags array[optional] <p>ゼロ個以上のタグセットの配列。各タグセット自体も配列で、レプリカセットのメンバーのタグにマッチさせる条件として使います。</p>
	 * @return bool 
	 */
	public function setReadPreference ($read_preference, array $tags = null) {}

	/**
	 * コレクションを削除する
	 * @link http://www.php.net/manual/ja/mongocollection.drop.php
	 * @return array データベースの応答を返します。
	 */
	public function drop () {}

	/**
	 * コレクションを検証する
	 * @link http://www.php.net/manual/ja/mongocollection.validate.php
	 * @param scan_data bool[optional] <p>
	 * インデックスの検証のみを行い、コレクションは検証しない。
	 * </p>
	 * @return array このオブジェクトをデータベースで評価した結果を返します。
	 */
	public function validate ($scan_data = null) {}

	/**
	 * ドキュメントをコレクションに追加する
	 * @link http://www.php.net/manual/ja/mongocollection.insert.php
	 * @param a array|object <p>
	 * 配列あるいはオブジェクト。オブジェクトを使う場合は、
	 * protected や private のプロパティは保持できません。
	 * </p>
	 * <p>
	 * _id のキーあるいはプロパティを持たない場合は、
	 * 新しい MongoId インスタンスを作ってそれを代入します。
	 * ただし、パラメータを参照で渡した場合は別です。
	 * </p>
	 * @param options array[optional] <p>
	 * 追加時のオプション。
	 * <p>"fsync"</p>
	 * <p>デフォルトは FALSE です。
	 * これを指定すると、追加をディスクに同期させるまで成功したと見なさないようになります。
	 * TRUE にすると、w の設定を 0 に上書きします。</p>
	 * @return bool|array "w" オプションが設定されている場合は、
	 * 追加の状況を含む配列を返します。
	 * 設定されていない場合は、
	 * もし追加された配列が空でない場合に TRUE を返します
	 * (追加された配列が空の場合は MongoException をスローします)。
	 * </p>
	 * <p>
	 * 配列が返された場合、その中に含まれる要素は次のようになります。
	 * ok
	 * <p>
	 * これはほぼ常に 1 です (ただし last_error 自体が失敗した場合は除く)。
	 * </p>
	 * err
	 * <p>
	 * このフィールドに null 以外の値が入っている場合は、直前の操作でエラーが発生しています。
	 * このフィールドが設定されている場合、その内容は発生したエラーを表す文字列となります。
	 * </p>
	 * code
	 * <p>
	 * データベースのエラーが発生した場合に、そのエラーコードをクライアントに戻します。
	 * </p>
	 * errmsg
	 * <p>
	 * このフィールドが設定されるのは、データベースコマンドで何か問題が発生したときです。
	 * ok を 0 にすることと組み合わせて使います。
	 * たとえば、もし w が設定されているときにタイムアウトが発生すると、
	 * errmsg は "timed out waiting for slaves" そして ok は 0 になります。
	 * このフィールドが設定されている場合、その内容は発生したエラーを表す文字列となります。
	 * </p>
	 * n
	 * <p>
	 * 直近の操作が insert、update あるいは remove だった場合に、影響を受けたドキュメントの数を返します。
	 * 追加操作の場合は、この値は常に 0 です。
	 * </p>
	 * wtimeout
	 * <p>
	 * 直近の操作がレプリケーション待ちでタイムアウトしたかどうか。
	 * </p>
	 * waited
	 * <p>
	 * 操作がタイムアウトするまでにどれだか待ったか。
	 * </p>
	 * wtime
	 * <p>
	 * w を設定して、かつ操作が成功した場合に、
	 * w サーバーへのレプリケートにかかった時間。
	 * </p>
	 * upserted
	 * <p>
	 * upsert が発生した場合は、このフィールドに新しいレコードの
	 * _id が格納されます。upsert の場合は、このフィールドあるいは
	 * updatedExisting のいずれかが (エラーが発生しない限り) 必ず存在します。
	 * </p>
	 * updatedExisting
	 * <p>
	 * upsert が既存の要素を更新した場合に、このフィールドが true となります。
	 * _id が格納されます。upsert の場合は、このフィールドあるいは
	 * upsearted のいずれかが (エラーが発生しない限り) 必ず存在します。
	 * </p>
	 */
	public function insert ($a, array $options = null) {}

	/**
	 * 複数のドキュメントをコレクションに追加する
	 * @link http://www.php.net/manual/ja/mongocollection.batchinsert.php
	 * @param a array <p>
	 * 配列の配列あるいはオブジェクト。オブジェクトを使う場合は、
	 * protected や private のプロパティは保持できません。
	 * </p>
	 * <p>
	 * 追加するドキュメントが _id のキーあるいはプロパティを持たない場合は、
	 * 新しい MongoId インスタンスを作ってそれを代入します。
	 * この挙動に関する詳しい情報は MongoCollection::insert を参照ください。
	 * </p>
	 * @param options array[optional] <p>
	 * 追加時のオプション。
	 * <p>
	 * "continueOnError"
	 * </p>
	 * <p>
	 * boolean で、デフォルトは FALSE です。
	 * これを設定すると、(ID の重複などが原因で)
	 * 一括インサートが失敗したときにもデータベースは処理を続行します。
	 * その結果、一括インサート処理の挙動が一件ごとのインサートを繰り返したときと同じになります。
	 * ただし、MongoDB::lastError をコールすると、
	 * 直近の操作が失敗していなくても何か失敗があればエラーが設定されています。
	 * 複数のエラーが発生したときには、
	 * MongoDB::lastError が返すのは最後に発生したエラーだけとなります。
	 * </p>
	 * <p>
	 * continueOnError は、あくまでもデータベース側のエラーにしか影響を及ぼさないことに注意しましょう。
	 * ドキュメントそのものに問題があるもの
	 * (キーの名前が空になっているなど) をインサートしようとすると、
	 * ドライバーがこのエラーを検出してデータベースへの送信を止めてしまうので、処理はそこで終わってしまいます。
	 * ドライバー側で検出されるドキュメントのエラーに関しては、
	 * continueOnError は何もできません。
	 * </p>
	 * @return mixed w を設定して書き込みの確認をするようにしている場合は、
	 * 追加の状況 ("ok") と発生したエラー ("err")
	 * を連想配列で返します。設定されていないときは、一括追加の送信に成功すれば
	 * TRUE、失敗すれば FALSE を返します。
	 */
	public function batchInsert (array $a, array $options = null) {}

	/**
	 * 指定した条件にもとづいてレコードを更新する
	 * @link http://www.php.net/manual/ja/mongocollection.update.php
	 * @param criteria array <p>
	 * 更新したいオブジェクトの条件。
	 * </p>
	 * @param new_object array <p>
	 * マッチするレコードを更新するオブジェクト。
	 * </p>
	 * @param options array[optional] <p>
	 * このパラメータは
	 * array("optionname" => &lt;boolean&gt;, ...)
	 * 形式の連想配列で、現在サポートしているオプションは次の通りです。
	 * <p>"w"</p>
	 * <p>WriteConcerns を参照ください。MongoClient でのデフォルト値は 1 です。
	 * </p>
	 * @return bool|array "w" が設定されていれば、更新の状態を表す配列を返します。
	 * それ以外の場合は TRUE を返します。
	 * </p>
	 * <p>
	 * 状態を表す配列のフィールドについては MongoCollection::insert のドキュメントを参照ください。
	 */
	public function update (array $criteria, array $new_object, array $options = null) {}

	/**
	 * レコードをコレクションから削除する
	 * @link http://www.php.net/manual/ja/mongocollection.remove.php
	 * @param criteria array[optional] <p>
	 * 削除したいレコードの条件。
	 * </p>
	 * @param options array[optional] <p>
	 * 削除時のオプション。
	 * <p>"w"</p>
	 * <p>WriteConcerns を参照ください。MongoClient でのデフォルト値は 1 です。
	 * </p>
	 * @return bool|array "w" が設定されていれば、削除の状態を表す配列を返します。
	 * それ以外の場合は TRUE を返します。
	 * </p>
	 * <p>
	 * 状態を表す配列のフィールドについては MongoCollection::insert のドキュメントを参照ください。
	 */
	public function remove (array $criteria = null, array $options = null) {}

	/**
	 * コレクションに問い合わせ、結果セットの <classname>MongoCursor</classname> を返す
	 * @link http://www.php.net/manual/ja/mongocollection.find.php
	 * @param query array[optional] <p>
	 * 検索したいフィールド。
	 * MongoDB のクエリ言語は極めて幅広いものです。
	 * PHP ドライバはほとんどの場合クエリをそのままサーバーに流すので、
	 * MongoDB コアドキュメントの
	 * find を読むといいでしょう。
	 * </p>
	 * <p>
	 * クエリの特別な演算子 ($ ではじまるもの)
	 * は、すべてシングルクォートで囲まなければならないことに注意しましょう。
	 * "$exists" などとすると、PHP がそれを変数
	 * $exists の値で置き換えてしまいます。
	 * </p>
	 * @param fields array[optional] <p>
	 * 返される結果のフィールド。配列の形式は
	 * array('fieldname' => true, 'fieldname2' => true)
	 * のようになります。_id フィールドは常に返されます。
	 * </p>
	 * @return MongoCursor 検索結果のカーソルを返します。
	 */
	public function find (array $query = null, array $fields = null) {}

	/**
	 * コレクションに問い合わせ、単一の要素を返す
	 * @link http://www.php.net/manual/ja/mongocollection.findone.php
	 * @param query array[optional] <p>
	 * 検索したいフィールド。
	 * MongoDB のクエリ言語は極めて幅広いものです。
	 * PHP ドライバはほとんどの場合クエリをそのままサーバーに流すので、
	 * MongoDB コアドキュメントの
	 * find を読むといいでしょう。
	 * </p>
	 * <p>
	 * クエリの特別な演算子 ($ ではじまるもの)
	 * は、すべてシングルクォートで囲まなければならないことに注意しましょう。
	 * "$exists" などとすると、PHP がそれを変数
	 * $exists の値で置き換えてしまいます。
	 * </p>
	 * @param fields array[optional] <p>
	 * 返される結果のフィールド。配列の形式は
	 * array('fieldname' => true, 'fieldname2' => true)
	 * のようになります。_id フィールドは常に返されます。
	 * </p>
	 * @return array 検索にマッチしたレコード、あるいは NULL を返します。
	 */
	public function findOne (array $query = null, array $fields = null) {}

	/**
	 * ドキュメントを更新して返す
	 * @link http://www.php.net/manual/ja/mongocollection.findandmodify.php
	 * @param query array <p>
	 * クエリの検索条件。
	 * </p>
	 * @param update array[optional] <p>
	 * 更新条件。
	 * </p>
	 * @param fields array[optional] <p>
	 * オプションで、返すフィールドを絞り込めます。
	 * </p>
	 * @param options array[optional] <p>
	 * 適用するオプションの配列。マッチしたドキュメントを DB から削除してから返すなどのオプションを指定できます。
	 * <tr valign="top">
	 * <td>オプション</td>
	 * <td>説明</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>sort array</td>
	 * <td>
	 * クエリが複数のドキュメントを選択したときに、どのドキュメントを変更するかを決めます。
	 * findAndModify が変更するのは、この引数で指定した並び順で最初にあるドキュメントだけです。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>remove boolean</td>
	 * <td>
	 * update フィールドが存在するときは必須ではありません。
	 * TRUE にすると、選択したドキュメントを削除します。デフォルトは FALSE です。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>update array</td>
	 * <td>
	 * remove フィールドが存在するときは必須ではありません。
	 * 選択したドキュメントを更新します。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>new boolean</td>
	 * <td>
	 * 必須ではありません。TRUE にすると、変更前のドキュメントではなく変更後のドキュメントを返します。
	 * findAndModify メソッドは、remove 操作のときには new オプションを無視します。
	 * デフォルトは FALSE です。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>upsert boolean</td>
	 * <td>
	 * 必須ではありません。update と組み合わせて使います。
	 * TRUE にすると、クエリがドキュメントを返さないときに findAndModify コマンドが新しいドキュメントを作ります。
	 * デフォルトは FALSE です。MongoDB 2.2 では、upsert が TRUE
	 * のときに findAndModify コマンドは NULL を返します。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td></td>
	 * <td>
	 * </td>
	 * </tr>
	 * </p>
	 * @return void 元のドキュメントを返します。
	 * new が設定されている場合は変更後のドキュメントを返します。
	 */
	public function findAndModify (array $query, array $update = null, array $fields = null, array $options = null) {}

	/**
	 * 指定したフィールドにインデックスを作成する (すでに存在する場合は何もしない)
	 * @link http://www.php.net/manual/ja/mongocollection.ensureindex.php
	 * @param key_keys string|array 
	 * @param options array[optional] <p>
	 * このパラメータは
	 * array("optionname" => &lt;boolean&gt;, ...)
	 * 形式の連想配列で、現在サポートしているオプションは次の通りです。
	 * <p>"w"</p>
	 * <p>WriteConcerns を参照ください。MongoClient でのデフォルト値は 1 です。
	 * </p>
	 * @return bool "w" オプションが設定されている場合は、
	 * インデックスの作成の状態を含む配列を返します。それ以外の場合は
	 * TRUE を返します。
	 * </p>
	 * <p>
	 * 配列のフィールドについての説明は
	 * MongoCollection::insert を参照ください。
	 */
	public function ensureIndex ($key_keys, array $options = null) {}

	/**
	 * コレクションからインデックスを削除する
	 * @link http://www.php.net/manual/ja/mongocollection.deleteindex.php
	 * @param keys string|array <p>
	 * インデックスを削除したいフィールド。
	 * </p>
	 * @return array 成功した場合にキーの名前、それ以外の場合に NULL を返します。
	 */
	public function deleteIndex ($keys) {}

	/**
	 * コレクションのすべてのインデックスを削除する
	 * @link http://www.php.net/manual/ja/mongocollection.deleteindexes.php
	 * @return array データベースの応答を返します。
	 */
	public function deleteIndexes () {}

	/**
	 * このコレクションのインデックスについての情報を返す
	 * @link http://www.php.net/manual/ja/mongocollection.getindexinfo.php
	 * @return array この関数は、配列を返します。配列の各要素が、それぞれインデックスを表します。
	 * その要素には、インデックス名を表す name や名前空間
	 * (データベース名とコレクション名の組み合わせ) を表す ns、すべてのキーとそのソート順
	 * (インデックスを作るもの) を表す key があります。
	 * また、それ以外の値も特別なインデックスに含まれるかもしれません。
	 * unique や sparse などです。
	 */
	public function getIndexInfo () {}

	/**
	 * コレクション内のドキュメント数を数える
	 * @link http://www.php.net/manual/ja/mongocollection.count.php
	 * @param query array[optional] <p>
	 * マッチさせるフィールドを持つ連想配列あるいはオブジェクト。
	 * </p>
	 * @param limit int[optional] <p>
	 * 返す件数の上限を指定します。
	 * </p>
	 * @param skip int[optional] <p>
	 * 数え始めるまでに読み飛ばす結果の数を指定します。
	 * </p>
	 * @return int query にマッチするドキュメントの数を返します。
	 */
	public function count (array $query = null, $limit = null, $skip = null) {}

	/**
	 * ドキュメントをコレクションに保存する
	 * @link http://www.php.net/manual/ja/mongocollection.save.php
	 * @param a array|object <p>
	 * 保存したい配列あるいはオブジェクト。オブジェクトを使う場合は、
	 * protected や private のプロパティは保持できません。
	 * </p>
	 * <p>
	 * _id のキーあるいはプロパティを持たない場合は、
	 * 新しい MongoId インスタンスを作ってそれを代入します。
	 * この挙動に関する詳しい情報は MongoCollection::insert を参照ください。
	 * </p>
	 * @param options array[optional] <p>
	 * 保存時のオプション。
	 * <p>"fsync"</p>
	 * <p>デフォルトは FALSE です。
	 * これを指定すると、追加をディスクに同期させるまで成功したと見なさないようになります。
	 * TRUE にすると、w の設定を 0 に上書きします。</p>
	 * @return mixed w が設定されている場合は、
	 * 保存結果を含む配列を返します。設定されていない場合は、
	 * 配列が空でなかったかどうかをあらわす boolean 値を返します (空の配列は追加されません)。
	 */
	public function save ($a, array $options = null) {}

	/**
	 * データベースへの参照を作成する
	 * @link http://www.php.net/manual/ja/mongocollection.createdbref.php
	 * @param a array <p>
	 * 参照を作成したいオブジェクト。
	 * </p>
	 * @return array データベース参照配列を返します。
	 */
	public function createDBRef (array $a) {}

	/**
	 * データベース参照が指すドキュメントを取得する
	 * @link http://www.php.net/manual/ja/mongocollection.getdbref.php
	 * @param ref array <p>
	 * データベース参照。
	 * </p>
	 * @return array 参照が指し示すデータベースドキュメントを返します。
	 */
	public function getDBRef (array $ref) {}

	/**
	 * インデックスを指定するキーを、インデックスを指す文字列に変換する
	 * @link http://www.php.net/manual/ja/mongocollection.toindexstring.php
	 * @param keys mixed <p>
	 * 指し示す文字列に変換したいフィールド。
	 * </p>
	 * @return string インデックスを表す文字列を返します。
	 */
	protected static function toIndexString ($keys) {}

	/**
	 * SQL の GROUP BY コマンドと似た処理を行う
	 * @link http://www.php.net/manual/ja/mongocollection.group.php
	 * @param keys mixed <p>
	 * group by したいフィールド。
	 * 配列あるいは非コードオブジェクトが渡された場合は、
	 * 結果をグループ化するキーとして扱います。
	 * </p>
	 * <p>1.0.4+: keys が
	 * MongoCode のインスタンスである場合は、
	 * keys はグループ化のキーを返す関数であると見なします
	 * (下の例 "keys へ関数を渡す" を参照ください)。
	 * </p>
	 * @param initial array <p>
	 * 集約カウンタオブジェクトの初期値。
	 * </p>
	 * @param reduce MongoCode <p>
	 * ふたつの引数 (現在のドキュメント、
	 * そして集約する点) を受け取って集約をする関数。
	 * </p>
	 * @param options array[optional] <p>
	 * group コマンドへのオプションのパラメータ。次のオプションが使えます。
	 * </p>
	 * <p>
	 * "condition"
	 * </p>
	 * <p>
	 * 集約処理に含めるドキュメントの条件。
	 * </p>
	 * @return array 結果を含む配列を返します。
	 */
	public function group ($keys, array $initial, MongoCode $reduce, array $options = null) {}

	/**
	 * コレクション内で、指定したキーに対応する区別できる値の一覧を取得する
	 * @link http://www.php.net/manual/ja/mongocollection.distinct.php
	 * @param key string <p>
	 * 使うキー。
	 * </p>
	 * @param query array[optional] <p>
	 * オプションのクエリパラメータ。
	 * </p>
	 * @return array 区別できる値の配列を返します。失敗した場合に FALSE を返します
	 */
	public function distinct ($key, array $query = null) {}

	/**
	 * aggregation フレームワークを使って集約する
	 * @link http://www.php.net/manual/ja/mongocollection.aggregate.php
	 * @param pipeline array <p>
	 * パイプライン演算子の配列、あるいは最初の演算子。
	 * </p>
	 * @param op array[optional] <p>
	 * 二番目のパイプライン演算子。
	 * </p>
	 * @param _ array[optional] 
	 * @return array 集約の結果を配列で返します。成功した場合は ok が
	 * 1 になり、失敗した場合は 0 になります。
	 */
	public function aggregate (array $pipeline, array $op = null, array $_ = null) {}

}

class MongoCursor implements Iterator, Traversable {
	public static $slaveOkay;
	public static $timeout;


	/**
	 * 新しいカーソルを作成する
	 * @link http://www.php.net/manual/ja/mongocursor.construct.php
	 * @param connection MongoClient
	 * @param database_and_collection_name
	 * @param query[optional]
	 * @param array_of_fields_OR_object[optional]
	 */
	public function __construct (MongoClient $connection, $database_and_collection_name, $query, $array_of_fields_OR_object) {}

	/**
	 * このカーソルにまだ要素があるかどうかを調べる
	 * @link http://www.php.net/manual/ja/mongocursor.hasnext.php
	 * @return bool まだ要素があるかどうかを返します。
	 */
	public function hasNext () {}

	/**
	 * このカーソルがさす次のオブジェクトを返し、カーソルを進める
	 * @link http://www.php.net/manual/ja/mongocursor.getnext.php
	 * @return array 次のオブジェクトを返します。
	 */
	public function getNext () {}

	/**
	 * 返す結果の数を制限する
	 * @link http://www.php.net/manual/ja/mongocursor.limit.php
	 * @param num int <p>
	 * 返したい結果の数。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function limit ($num) {}

	/**
	 * ひとつのバッチで返す要素数を制限する
	 * @link http://www.php.net/manual/ja/mongocursor.batchsize.php
	 * @param batchSize int <p>
	 * バッチで返す結果の数。バッチごとにサーバーとのやりとりが発生します。
	 * </p>
	 * <p>
	 * batchSize が 2 以上
	 * の場合は、取得するオブジェクトの各バッチのサイズを表します。
	 * これをうまく調整すれば、パフォーマンスとデータ転送量を最適化できます。
	 * </p>
	 * <p>
	 * batchSize が 1 あるいは負の数の場合は、
	 * 返すドキュメントの最大数を batchSize の絶対値までに抑え、
	 * 結果を返した後にカーソルを閉じます。
	 * たとえば batchSize を -10
	 * にすると、サーバーは 4MB に収まる範囲で最大 10 件までのドキュメントを返して
	 * カーソルを閉じます。
	 * </p>
	 * <p>
	 * batchSize が 1
	 * あるいは -1 の場合は特別で、
	 * このカーソルからは 1 件のドキュメントしか返せなくなります。
	 * </p>
	 * <p>
	 * この機能が MongoCursor::limit と違うところは、
	 * ドキュメントが最大サイズに収まらなければいけないという点と、
	 * カーソルを閉じるリクエストをサーバーに送らなくてもよいという点です。
	 * カーソルをループしている間にもバッチサイズを変更でき、
	 * その次にバッチを取得するときから新しい設定が反映されます。
	 * </p>
	 * <p>
	 * これは、MongoDB がクライアントに返すデータ量の制限を上書きすることはできません。
	 * つまり、たとえバッチサイズを 1,000,000,000 にしても、
	 * MongoDB がバッチあたりで返す結果は 4-16MB にしかならないということです。
	 * </p>
	 * <p>
	 * 一貫性を維持するため、
	 * MongoCursor::batchSize と
	 * MongoCursor::limit のルールは多少込み入ったものになっていますが、
	 * 「期待通りに」動作します。そのルールとは、
	 * ハードリミットがソフトリミットを上書きし、
	 * MongoCursor::limit のほうが
	 * MongoCursor::batchSize より優先順位が高くなるということです。
	 * その結果、どちらであってももう一方より小さく設定されているほうが優先されます。
	 * 以下の例を参照ください。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function batchSize ($batchSize) {}

	/**
	 * 結果をスキップする
	 * @link http://www.php.net/manual/ja/mongocursor.skip.php
	 * @param num int <p>
	 * スキップしたい結果の数。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function skip ($num) {}

	/**
	 * クエリのフィールドを設定する
	 * @link http://www.php.net/manual/ja/mongocursor.fields.php
	 * @param f array <p>
	 * 返したい (あるいは返したくない) フィールド。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function fields (array $f) {}

	/**
	 * トップレベルの キー/値 のペアをクエリに追加する
	 * @link http://www.php.net/manual/ja/mongocursor.addoption.php
	 * @param key string <p>
	 * 追加したいフィールド名。
	 * </p>
	 * @param value mixed <p>
	 * 追加したい値。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function addOption ($key, $value) {}

	/**
	 * このクエリでスナップショットモードを使う
	 * @link http://www.php.net/manual/ja/mongocursor.snapshot.php
	 * @return MongoCursor このカーソルを返します。
	 */
	public function snapshot () {}

	/**
	 * 指定したフィールドで結果をソートする
	 * @link http://www.php.net/manual/ja/mongocursor.sort.php
	 * @param fields array <p>
	 * ソートするフィールドの配列。配列のキーがフィールド名、そして値には昇順なら
	 * 1、降順なら -1 を指定します。
	 * </p>
	 * <p>
	 * 個々の結果は、まず配列内の最初のフィールドでソートされ、次に
	 * (もしあれば) 二番目のフィールドでソートされ…というようになります。つまり、
	 * fields 配列でのフィールドを指定する順番が重要になるということです。
	 * サンプルも参照ください。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function sort (array $fields) {}

	/**
	 * クエリについてのヒントをデータベースに与える
	 * @link http://www.php.net/manual/ja/mongocursor.hint.php
	 * @param index mixed <p>
	 * クエリで使用するインデックス。
	 * 文字列を渡した場合は、インデックス名として扱います。
	 * 配列あるいはオブジェクトを渡した場合は、それに基づいてインデックスを組み立てます
	 * (MongoCollection::ensureIndex の最初の引数のようになります)。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function hint ($index) {}

	/**
	 * 最適化やデバッグの際に有効な、クエリの explain を返す
	 * @link http://www.php.net/manual/ja/mongocursor.explain.php
	 * @return array クエリの explain を返します。
	 */
	public function explain () {}

	/**
	 * 専用のメソッドが存在しない任意のフラグを設定する
	 * @link http://www.php.net/manual/ja/mongocursor.setflag.php
	 * @param flag bool <p>
	 * 設定するフラグ。フラグ 6
	 * (EXHAUST) は設定できません。ドライバがその処理方法を知らないからです。
	 * このフラグを使うと警告が発生します。使えるフラグについては、wire プロトコルの
	 * ドキュメント
	 * を参照ください。
	 * </p>
	 * @param set bool[optional] <p>
	 * フラグを設定する (TRUE) か解除する (FALSE) か。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function setFlag ($flag, $set = null) {}

	/**
	 * このクエリをセカンダリ上で完了できるかどうかを設定する
	 * @link http://www.php.net/manual/ja/mongocursor.slaveokay.php
	 * @param okay bool[optional] <p>
	 * セカンダリに問い合わせることが可能かどうか。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function slaveOkay ($okay = null) {}

	/**
	 * このカーソルが、最後の結果を取得した後もオープンしたままにしておくかどうかを設定する
	 * @link http://www.php.net/manual/ja/mongocursor.tailable.php
	 * @param tail bool[optional] <p>
	 * カーソルが追尾可能かどうか。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function tailable ($tail = null) {}

	/**
	 * このカーソルをタイムアウトさせるかどうかを設定する
	 * @link http://www.php.net/manual/ja/mongocursor.immortal.php
	 * @param liveForever bool[optional] <p>
	 * カーソルを不死にするかどうか。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function immortal ($liveForever = null) {}

	/**
	 * 追尾可能なカーソルで、データがないときにしばらく待つかどうかを設定する
	 * @link http://www.php.net/manual/ja/mongocursor.awaitdata.php
	 * @param wait bool[optional] <p>
	 * カーソルに、さらにデータがやってくるまで待たせるかどうか。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function awaitData ($wait = null) {}

	/**
	 * シャードがダウンしているときにこのクエリが <emphasis>mongos</emphasis> から部分的な結果を返すようにするかどうか
	 * @link http://www.php.net/manual/ja/mongocursor.partial.php
	 * @param okay bool[optional] <p>
	 * 部分的な結果の受信を許可するかどうか。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function partial ($okay = null) {}

	/**
	 * このクエリのクライアント側のタイムアウトを設定する
	 * @link http://www.php.net/manual/ja/mongocursor.timeout.php
	 * @param ms int <p>
	 * カーソルがレスポンスを待つミリ秒数。
	 * デフォルトではいつまでも待ち続けます。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function timeout ($ms) {}

	/**
	 * クエリを実行する
	 * @link http://www.php.net/manual/ja/mongocursor.doquery.php
	 * @return void NULL を返します。
	 */
	protected function doQuery () {}

	/**
	 * このカーソルの query、fields、limit そして skip を取得する
	 * @link http://www.php.net/manual/ja/mongocursor.info.php
	 * @return array このカーソルの namespace、limit、skip、query そして fields を返します。
	 */
	public function info () {}

	/**
	 * このカーソルにまだデータベースから送信されていないドキュメントがあるかどうかを調べる
	 * @link http://www.php.net/manual/ja/mongocursor.dead.php
	 * @return bool クライアントにまだ送られていない結果が残っているかどうかを返します。
	 */
	public function dead () {}

	/**
	 * 現在の要素を返す
	 * @link http://www.php.net/manual/ja/mongocursor.current.php
	 * @return array 現在の結果を連想配列で返します。
	 */
	public function current () {}

	/**
	 * 現在の結果の _id を返す
	 * @link http://www.php.net/manual/ja/mongocursor.key.php
	 * @return string 現在の結果の _id を文字列で返します。
	 */
	public function key () {}

	/**
	 * カーソルを次の結果に進める
	 * @link http://www.php.net/manual/ja/mongocursor.next.php
	 * @return void NULL を返します。
	 */
	public function next () {}

	/**
	 * カーソルを結果セットの先頭に戻す
	 * @link http://www.php.net/manual/ja/mongocursor.rewind.php
	 * @return void NULL を返します。
	 */
	public function rewind () {}

	/**
	 * カーソルが正しい結果を読んでいるかどうかを調べる
	 * @link http://www.php.net/manual/ja/mongocursor.valid.php
	 * @return bool 現在の結果が null でないかどうかを返します。
	 */
	public function valid () {}

	/**
	 * カーソルを消去する
	 * @link http://www.php.net/manual/ja/mongocursor.reset.php
	 * @return void NULL を返します。
	 */
	public function reset () {}

	/**
	 * このクエリの結果の数を数える
	 * @link http://www.php.net/manual/ja/mongocursor.count.php
	 * @param foundOnly bool[optional] <p>
	 * カーソルの limit を送信し、制限に達した場合に count 関数への情報の送信をスキップします。
	 * </p>
	 * @return int このカーソルのクエリが返すドキュメントの数を返します。
	 */
	public function count ($foundOnly = null) {}

}

class MongoGridFS extends MongoCollection  {
	const ASCENDING = 1;
	const DESCENDING = -1;

	public $w;
	public $wtimeout;
	public $chunks;
	protected $filesName;
	protected $chunksName;


	/**
	 * 新しいファイルコレクションを作成する
	 * @link http://www.php.net/manual/ja/mongogridfs.construct.php
	 */
	public function __construct () {}

	/**
	 * ファイルコレクションおよびチャンクコレクションを削除する
	 * @link http://www.php.net/manual/ja/mongogridfs.drop.php
	 * @return array データベースの応答を返します。
	 */
	public function drop () {}

	/**
	 * ファイルを問い合わせる
	 * @link http://www.php.net/manual/ja/mongogridfs.find.php
	 * @param query array[optional] <p>
	 * クエリ。
	 * </p>
	 * @param fields array[optional] <p>
	 * 返したいフィールド。
	 * </p>
	 * @return MongoGridFSCursor MongoGridFSCursor を返します。
	 */
	public function find (array $query = null, array $fields = null) {}

	/**
	 * ファイルをデータベースに格納する
	 * @link http://www.php.net/manual/ja/mongogridfs.storefile.php
	 * @param filename string <p>
	 * 格納するファイルの名前。
	 * </p>
	 * @param metadata array[optional] <p>
	 * 格納するファイルに含めるその他のメタデータフィールド。
	 * </p>
	 * <p>これらのフィールドは、ドライバが自動生成したフィールドも上書きします。詳しい説明は、MongoDB コアドキュメントの files collection を参照ください。この挙動の現実的な使い道としては、ファイルの chunkSize や _id を独自に指定する場合などがあります。</p>
	 * @param options array[optional] <p>
	 * 格納時のオプション。
	 * <p>"w"</p>
	 * <p>WriteConcerns を参照ください。MongoClient でのデフォルト値は 1 です。
	 * </p>
	 * @return mixed 
	 */
	public function storeFile ($filename, array $metadata = null, array $options = null) {}

	/**
	 * バイト列をデータベースに格納する
	 * @link http://www.php.net/manual/ja/mongogridfs.storebytes.php
	 * @param bytes string <p>
	 * 格納したいバイト列。
	 * </p>
	 * @param metadata array[optional] <p>
	 * 格納するファイルに含めるその他のメタデータフィールド。
	 * </p>
	 * <p>これらのフィールドは、ドライバが自動生成したフィールドも上書きします。詳しい説明は、MongoDB コアドキュメントの files collection を参照ください。この挙動の現実的な使い道としては、ファイルの chunkSize や _id を独自に指定する場合などがあります。</p>
	 * @param options array[optional] <p>
	 * 格納時のオプション。
	 * <p>"w"</p>
	 * <p>WriteConcerns を参照ください。MongoClient でのデフォルト値は 1 です。
	 * </p>
	 * @return mixed 
	 */
	public function storeBytes ($bytes, array $metadata = null, array $options = null) {}

	/**
	 * 条件にマッチする単一のファイルを返す
	 * @link http://www.php.net/manual/ja/mongogridfs.findone.php
	 * @param query mixed[optional] <p>
	 * 探したいファイル名あるいは条件。
	 * </p>
	 * @param fields mixed[optional] 
	 * @return MongoGridFSFile MongoGridFSFile、あるいは NULL を返します。
	 */
	public function findOne ($query = null, $fields = null) {}

	/**
	 * ファイルをコレクションから削除する
	 * @link http://www.php.net/manual/ja/mongogridfs.remove.php
	 * @param criteria array[optional] 
	 * @param options array[optional] <p>
	 * 削除時のオプション。以下のオプションが使えます。
	 * </p>
	 * <p>"w"</p>
	 * <p>WriteConcerns を参照ください。MongoClient でのデフォルト値は 1 です。
	 * </p>
	 * @return bool 削除がデータベースに正しく送信されたかどうかを返します。
	 */
	public function remove (array $criteria = null, array $options = null) {}

	/**
	 * アップロードされたファイルをデータベースに格納する
	 * @link http://www.php.net/manual/ja/mongogridfs.storeupload.php
	 * @param name string <p>
	 * アップロードされたファイルの name フィールド。
	 * これは、HTML フォームの file フィールドの name
	 * 属性と同じでなければいけません。
	 * </p>
	 * @param metadata array[optional] <p>
	 * 格納するファイルに含めるその他のメタデータフィールド。
	 * </p>
	 * <p>これらのフィールドは、ドライバが自動生成したフィールドも上書きします。詳しい説明は、MongoDB コアドキュメントの files collection を参照ください。この挙動の現実的な使い道としては、ファイルの chunkSize や _id を独自に指定する場合などがあります。</p>
	 * <p>
	 * filename インデックスには、使用したファイル名が入ります。
	 * </p>
	 * @return mixed 
	 */
	public function storeUpload ($name, array $metadata = null) {}

	/**
	 * ファイルをデータベースから削除する
	 * @link http://www.php.net/manual/ja/mongogridfs.delete.php
	 * @param id mixed <p>
	 * 削除したいファイルの _id。
	 * </p>
	 * @return bool ファイルをデータベースから削除できたか否かを返します。
	 */
	public function delete ($id) {}

	/**
	 * ファイルをデータベースから取得する
	 * @link http://www.php.net/manual/ja/mongogridfs.get.php
	 * @param id mixed <p>
	 * 探したいファイルの _id。
	 * </p>
	 * @return MongoGridFSFile 見つかった場合はそのファイル、見つからない場合は NULL を返します。
	 */
	public function get ($id) {}

	/**
	 * ファイルをデータベースに格納する
	 * @link http://www.php.net/manual/ja/mongogridfs.put.php
	 * @param filename string <p>
	 * 格納するファイルの名前。
	 * </p>
	 * @param metadata array[optional] <p>
	 * 格納するファイルに含めるその他のメタデータフィールド。
	 * </p>
	 * <p>これらのフィールドは、ドライバが自動生成したフィールドも上書きします。詳しい説明は、MongoDB コアドキュメントの files collection を参照ください。この挙動の現実的な使い道としては、ファイルの chunkSize や _id を独自に指定する場合などがあります。</p>
	 * @return mixed 
	 */
	public function put ($filename, array $metadata = null) {}

	/**
	 * このコレクションの文字列表現
	 * @link http://www.php.net/manual/ja/mongocollection.--tostring.php
	 * @return string このコレクションの完全な名前を返します。
	 */
	public function __toString () {}

	/**
	 * コレクションを取得する
	 * @link http://www.php.net/manual/ja/mongocollection.get.php
	 * @param name string <p>
	 * コレクション名の中の次の文字列。
	 * </p>
	 * @return MongoCollection コレクションを返します。
	 */
	public function __get ($name) {}

	/**
	 * コレクションの名前を返す
	 * @link http://www.php.net/manual/ja/mongocollection.getname.php
	 * @return string コレクションの名前を返します。
	 */
	public function getName () {}

	/**
	 * このコレクションの slaveOkay 設定を取得する
	 * @link http://www.php.net/manual/ja/mongocollection.getslaveokay.php
	 * @return bool このインスタンスの slaveOkay の値を返します。
	 */
	public function getSlaveOkay () {}

	/**
	 * このコレクションの slaveOkay の設定を変更する
	 * @link http://www.php.net/manual/ja/mongocollection.setslaveokay.php
	 * @param ok bool[optional] <p>
	 * 可能な限りの問い合わせをレプリカセットのセカンダリメンバに送信したいときに、この
	 * Mongo インスタンスを使います。
	 * </p>
	 * @return bool このインスタンスの、変更前の slaveOkay の値を返します。
	 */
	public function setSlaveOkay ($ok = null) {}

	/**
	 * このコレクションの優先読み込みを取得する
	 * @link http://www.php.net/manual/ja/mongocollection.getreadpreference.php
	 * @return array 
	 */
	public function getReadPreference () {}

	/**
	 * このコレクションの優先読み込みを設定する
	 * @link http://www.php.net/manual/ja/mongocollection.setreadpreference.php
	 * @param read_preference string <p>読み込みの優先モード。MongoClient::RP_PRIMARY、MongoClient::RP_PRIMARY_PREFERRED、MongoClient::RP_SECONDARY、MongoClient::RP_SECONDARY_PREFERRED あるいは MongoClient::RP_NEAREST のいずれか。</p>
	 * @param tags array[optional] <p>ゼロ個以上のタグセットの配列。各タグセット自体も配列で、レプリカセットのメンバーのタグにマッチさせる条件として使います。</p>
	 * @return bool 
	 */
	public function setReadPreference ($read_preference, array $tags = null) {}

	/**
	 * コレクションを検証する
	 * @link http://www.php.net/manual/ja/mongocollection.validate.php
	 * @param scan_data bool[optional] <p>
	 * インデックスの検証のみを行い、コレクションは検証しない。
	 * </p>
	 * @return array このオブジェクトをデータベースで評価した結果を返します。
	 */
	public function validate ($scan_data = null) {}

	/**
	 * ドキュメントをコレクションに追加する
	 * @link http://www.php.net/manual/ja/mongocollection.insert.php
	 * @param a array|object <p>
	 * 配列あるいはオブジェクト。オブジェクトを使う場合は、
	 * protected や private のプロパティは保持できません。
	 * </p>
	 * <p>
	 * _id のキーあるいはプロパティを持たない場合は、
	 * 新しい MongoId インスタンスを作ってそれを代入します。
	 * ただし、パラメータを参照で渡した場合は別です。
	 * </p>
	 * @param options array[optional] <p>
	 * 追加時のオプション。
	 * <p>"fsync"</p>
	 * <p>デフォルトは FALSE です。
	 * これを指定すると、追加をディスクに同期させるまで成功したと見なさないようになります。
	 * TRUE にすると、w の設定を 0 に上書きします。</p>
	 * @return bool|array "w" オプションが設定されている場合は、
	 * 追加の状況を含む配列を返します。
	 * 設定されていない場合は、
	 * もし追加された配列が空でない場合に TRUE を返します
	 * (追加された配列が空の場合は MongoException をスローします)。
	 * </p>
	 * <p>
	 * 配列が返された場合、その中に含まれる要素は次のようになります。
	 * ok
	 * <p>
	 * これはほぼ常に 1 です (ただし last_error 自体が失敗した場合は除く)。
	 * </p>
	 * err
	 * <p>
	 * このフィールドに null 以外の値が入っている場合は、直前の操作でエラーが発生しています。
	 * このフィールドが設定されている場合、その内容は発生したエラーを表す文字列となります。
	 * </p>
	 * code
	 * <p>
	 * データベースのエラーが発生した場合に、そのエラーコードをクライアントに戻します。
	 * </p>
	 * errmsg
	 * <p>
	 * このフィールドが設定されるのは、データベースコマンドで何か問題が発生したときです。
	 * ok を 0 にすることと組み合わせて使います。
	 * たとえば、もし w が設定されているときにタイムアウトが発生すると、
	 * errmsg は "timed out waiting for slaves" そして ok は 0 になります。
	 * このフィールドが設定されている場合、その内容は発生したエラーを表す文字列となります。
	 * </p>
	 * n
	 * <p>
	 * 直近の操作が insert、update あるいは remove だった場合に、影響を受けたドキュメントの数を返します。
	 * 追加操作の場合は、この値は常に 0 です。
	 * </p>
	 * wtimeout
	 * <p>
	 * 直近の操作がレプリケーション待ちでタイムアウトしたかどうか。
	 * </p>
	 * waited
	 * <p>
	 * 操作がタイムアウトするまでにどれだか待ったか。
	 * </p>
	 * wtime
	 * <p>
	 * w を設定して、かつ操作が成功した場合に、
	 * w サーバーへのレプリケートにかかった時間。
	 * </p>
	 * upserted
	 * <p>
	 * upsert が発生した場合は、このフィールドに新しいレコードの
	 * _id が格納されます。upsert の場合は、このフィールドあるいは
	 * updatedExisting のいずれかが (エラーが発生しない限り) 必ず存在します。
	 * </p>
	 * updatedExisting
	 * <p>
	 * upsert が既存の要素を更新した場合に、このフィールドが true となります。
	 * _id が格納されます。upsert の場合は、このフィールドあるいは
	 * upsearted のいずれかが (エラーが発生しない限り) 必ず存在します。
	 * </p>
	 */
	public function insert ($a, array $options = null) {}

	/**
	 * 複数のドキュメントをコレクションに追加する
	 * @link http://www.php.net/manual/ja/mongocollection.batchinsert.php
	 * @param a array <p>
	 * 配列の配列あるいはオブジェクト。オブジェクトを使う場合は、
	 * protected や private のプロパティは保持できません。
	 * </p>
	 * <p>
	 * 追加するドキュメントが _id のキーあるいはプロパティを持たない場合は、
	 * 新しい MongoId インスタンスを作ってそれを代入します。
	 * この挙動に関する詳しい情報は MongoCollection::insert を参照ください。
	 * </p>
	 * @param options array[optional] <p>
	 * 追加時のオプション。
	 * <p>
	 * "continueOnError"
	 * </p>
	 * <p>
	 * boolean で、デフォルトは FALSE です。
	 * これを設定すると、(ID の重複などが原因で)
	 * 一括インサートが失敗したときにもデータベースは処理を続行します。
	 * その結果、一括インサート処理の挙動が一件ごとのインサートを繰り返したときと同じになります。
	 * ただし、MongoDB::lastError をコールすると、
	 * 直近の操作が失敗していなくても何か失敗があればエラーが設定されています。
	 * 複数のエラーが発生したときには、
	 * MongoDB::lastError が返すのは最後に発生したエラーだけとなります。
	 * </p>
	 * <p>
	 * continueOnError は、あくまでもデータベース側のエラーにしか影響を及ぼさないことに注意しましょう。
	 * ドキュメントそのものに問題があるもの
	 * (キーの名前が空になっているなど) をインサートしようとすると、
	 * ドライバーがこのエラーを検出してデータベースへの送信を止めてしまうので、処理はそこで終わってしまいます。
	 * ドライバー側で検出されるドキュメントのエラーに関しては、
	 * continueOnError は何もできません。
	 * </p>
	 * @return mixed w を設定して書き込みの確認をするようにしている場合は、
	 * 追加の状況 ("ok") と発生したエラー ("err")
	 * を連想配列で返します。設定されていないときは、一括追加の送信に成功すれば
	 * TRUE、失敗すれば FALSE を返します。
	 */
	public function batchInsert (array $a, array $options = null) {}

	/**
	 * 指定した条件にもとづいてレコードを更新する
	 * @link http://www.php.net/manual/ja/mongocollection.update.php
	 * @param criteria array <p>
	 * 更新したいオブジェクトの条件。
	 * </p>
	 * @param new_object array <p>
	 * マッチするレコードを更新するオブジェクト。
	 * </p>
	 * @param options array[optional] <p>
	 * このパラメータは
	 * array("optionname" => &lt;boolean&gt;, ...)
	 * 形式の連想配列で、現在サポートしているオプションは次の通りです。
	 * <p>"w"</p>
	 * <p>WriteConcerns を参照ください。MongoClient でのデフォルト値は 1 です。
	 * </p>
	 * @return bool|array "w" が設定されていれば、更新の状態を表す配列を返します。
	 * それ以外の場合は TRUE を返します。
	 * </p>
	 * <p>
	 * 状態を表す配列のフィールドについては MongoCollection::insert のドキュメントを参照ください。
	 */
	public function update (array $criteria, array $new_object, array $options = null) {}

	/**
	 * ドキュメントを更新して返す
	 * @link http://www.php.net/manual/ja/mongocollection.findandmodify.php
	 * @param query array <p>
	 * クエリの検索条件。
	 * </p>
	 * @param update array[optional] <p>
	 * 更新条件。
	 * </p>
	 * @param fields array[optional] <p>
	 * オプションで、返すフィールドを絞り込めます。
	 * </p>
	 * @param options array[optional] <p>
	 * 適用するオプションの配列。マッチしたドキュメントを DB から削除してから返すなどのオプションを指定できます。
	 * <tr valign="top">
	 * <td>オプション</td>
	 * <td>説明</td>
	 * </tr>
	 * <tr valign="top">
	 * <td>sort array</td>
	 * <td>
	 * クエリが複数のドキュメントを選択したときに、どのドキュメントを変更するかを決めます。
	 * findAndModify が変更するのは、この引数で指定した並び順で最初にあるドキュメントだけです。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>remove boolean</td>
	 * <td>
	 * update フィールドが存在するときは必須ではありません。
	 * TRUE にすると、選択したドキュメントを削除します。デフォルトは FALSE です。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>update array</td>
	 * <td>
	 * remove フィールドが存在するときは必須ではありません。
	 * 選択したドキュメントを更新します。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>new boolean</td>
	 * <td>
	 * 必須ではありません。TRUE にすると、変更前のドキュメントではなく変更後のドキュメントを返します。
	 * findAndModify メソッドは、remove 操作のときには new オプションを無視します。
	 * デフォルトは FALSE です。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td>upsert boolean</td>
	 * <td>
	 * 必須ではありません。update と組み合わせて使います。
	 * TRUE にすると、クエリがドキュメントを返さないときに findAndModify コマンドが新しいドキュメントを作ります。
	 * デフォルトは FALSE です。MongoDB 2.2 では、upsert が TRUE
	 * のときに findAndModify コマンドは NULL を返します。
	 * </td>
	 * </tr>
	 * <tr valign="top">
	 * <td></td>
	 * <td>
	 * </td>
	 * </tr>
	 * </p>
	 * @return void 元のドキュメントを返します。
	 * new が設定されている場合は変更後のドキュメントを返します。
	 */
	public function findAndModify (array $query, array $update = null, array $fields = null, array $options = null) {}

	/**
	 * 指定したフィールドにインデックスを作成する (すでに存在する場合は何もしない)
	 * @link http://www.php.net/manual/ja/mongocollection.ensureindex.php
	 * @param key_keys string|array 
	 * @param options array[optional] <p>
	 * このパラメータは
	 * array("optionname" => &lt;boolean&gt;, ...)
	 * 形式の連想配列で、現在サポートしているオプションは次の通りです。
	 * <p>"w"</p>
	 * <p>WriteConcerns を参照ください。MongoClient でのデフォルト値は 1 です。
	 * </p>
	 * @return bool "w" オプションが設定されている場合は、
	 * インデックスの作成の状態を含む配列を返します。それ以外の場合は
	 * TRUE を返します。
	 * </p>
	 * <p>
	 * 配列のフィールドについての説明は
	 * MongoCollection::insert を参照ください。
	 */
	public function ensureIndex ($key_keys, array $options = null) {}

	/**
	 * コレクションからインデックスを削除する
	 * @link http://www.php.net/manual/ja/mongocollection.deleteindex.php
	 * @param keys string|array <p>
	 * インデックスを削除したいフィールド。
	 * </p>
	 * @return array 成功した場合にキーの名前、それ以外の場合に NULL を返します。
	 */
	public function deleteIndex ($keys) {}

	/**
	 * コレクションのすべてのインデックスを削除する
	 * @link http://www.php.net/manual/ja/mongocollection.deleteindexes.php
	 * @return array データベースの応答を返します。
	 */
	public function deleteIndexes () {}

	/**
	 * このコレクションのインデックスについての情報を返す
	 * @link http://www.php.net/manual/ja/mongocollection.getindexinfo.php
	 * @return array この関数は、配列を返します。配列の各要素が、それぞれインデックスを表します。
	 * その要素には、インデックス名を表す name や名前空間
	 * (データベース名とコレクション名の組み合わせ) を表す ns、すべてのキーとそのソート順
	 * (インデックスを作るもの) を表す key があります。
	 * また、それ以外の値も特別なインデックスに含まれるかもしれません。
	 * unique や sparse などです。
	 */
	public function getIndexInfo () {}

	/**
	 * コレクション内のドキュメント数を数える
	 * @link http://www.php.net/manual/ja/mongocollection.count.php
	 * @param query array[optional] <p>
	 * マッチさせるフィールドを持つ連想配列あるいはオブジェクト。
	 * </p>
	 * @param limit int[optional] <p>
	 * 返す件数の上限を指定します。
	 * </p>
	 * @param skip int[optional] <p>
	 * 数え始めるまでに読み飛ばす結果の数を指定します。
	 * </p>
	 * @return int query にマッチするドキュメントの数を返します。
	 */
	public function count (array $query = null, $limit = null, $skip = null) {}

	/**
	 * ドキュメントをコレクションに保存する
	 * @link http://www.php.net/manual/ja/mongocollection.save.php
	 * @param a array|object <p>
	 * 保存したい配列あるいはオブジェクト。オブジェクトを使う場合は、
	 * protected や private のプロパティは保持できません。
	 * </p>
	 * <p>
	 * _id のキーあるいはプロパティを持たない場合は、
	 * 新しい MongoId インスタンスを作ってそれを代入します。
	 * この挙動に関する詳しい情報は MongoCollection::insert を参照ください。
	 * </p>
	 * @param options array[optional] <p>
	 * 保存時のオプション。
	 * <p>"fsync"</p>
	 * <p>デフォルトは FALSE です。
	 * これを指定すると、追加をディスクに同期させるまで成功したと見なさないようになります。
	 * TRUE にすると、w の設定を 0 に上書きします。</p>
	 * @return mixed w が設定されている場合は、
	 * 保存結果を含む配列を返します。設定されていない場合は、
	 * 配列が空でなかったかどうかをあらわす boolean 値を返します (空の配列は追加されません)。
	 */
	public function save ($a, array $options = null) {}

	/**
	 * データベースへの参照を作成する
	 * @link http://www.php.net/manual/ja/mongocollection.createdbref.php
	 * @param a array <p>
	 * 参照を作成したいオブジェクト。
	 * </p>
	 * @return array データベース参照配列を返します。
	 */
	public function createDBRef (array $a) {}

	/**
	 * データベース参照が指すドキュメントを取得する
	 * @link http://www.php.net/manual/ja/mongocollection.getdbref.php
	 * @param ref array <p>
	 * データベース参照。
	 * </p>
	 * @return array 参照が指し示すデータベースドキュメントを返します。
	 */
	public function getDBRef (array $ref) {}

	/**
	 * インデックスを指定するキーを、インデックスを指す文字列に変換する
	 * @link http://www.php.net/manual/ja/mongocollection.toindexstring.php
	 * @param keys mixed <p>
	 * 指し示す文字列に変換したいフィールド。
	 * </p>
	 * @return string インデックスを表す文字列を返します。
	 */
	protected static function toIndexString ($keys) {}

	/**
	 * SQL の GROUP BY コマンドと似た処理を行う
	 * @link http://www.php.net/manual/ja/mongocollection.group.php
	 * @param keys mixed <p>
	 * group by したいフィールド。
	 * 配列あるいは非コードオブジェクトが渡された場合は、
	 * 結果をグループ化するキーとして扱います。
	 * </p>
	 * <p>1.0.4+: keys が
	 * MongoCode のインスタンスである場合は、
	 * keys はグループ化のキーを返す関数であると見なします
	 * (下の例 "keys へ関数を渡す" を参照ください)。
	 * </p>
	 * @param initial array <p>
	 * 集約カウンタオブジェクトの初期値。
	 * </p>
	 * @param reduce MongoCode <p>
	 * ふたつの引数 (現在のドキュメント、
	 * そして集約する点) を受け取って集約をする関数。
	 * </p>
	 * @param options array[optional] <p>
	 * group コマンドへのオプションのパラメータ。次のオプションが使えます。
	 * </p>
	 * <p>
	 * "condition"
	 * </p>
	 * <p>
	 * 集約処理に含めるドキュメントの条件。
	 * </p>
	 * @return array 結果を含む配列を返します。
	 */
	public function group ($keys, array $initial, MongoCode $reduce, array $options = null) {}

	/**
	 * コレクション内で、指定したキーに対応する区別できる値の一覧を取得する
	 * @link http://www.php.net/manual/ja/mongocollection.distinct.php
	 * @param key string <p>
	 * 使うキー。
	 * </p>
	 * @param query array[optional] <p>
	 * オプションのクエリパラメータ。
	 * </p>
	 * @return array 区別できる値の配列を返します。失敗した場合に FALSE を返します
	 */
	public function distinct ($key, array $query = null) {}

	/**
	 * aggregation フレームワークを使って集約する
	 * @link http://www.php.net/manual/ja/mongocollection.aggregate.php
	 * @param pipeline array <p>
	 * パイプライン演算子の配列、あるいは最初の演算子。
	 * </p>
	 * @param op array[optional] <p>
	 * 二番目のパイプライン演算子。
	 * </p>
	 * @param _ array[optional] 
	 * @return array 集約の結果を配列で返します。成功した場合は ok が
	 * 1 になり、失敗した場合は 0 になります。
	 */
	public function aggregate (array $pipeline, array $op = null, array $_ = null) {}

}

class MongoGridFSFile  {
	public $file;
	protected $gridfs;


	/**
	 * 新しい GridFS ファイルを作成する
	 * @link http://www.php.net/manual/ja/mongogridfsfile.construct.php
	 */
	public function __construct () {}

	/**
	 * このファイルのファイル名を返す
	 * @link http://www.php.net/manual/ja/mongogridfsfile.getfilename.php
	 * @return string ファイル名を返します。
	 */
	public function getFilename () {}

	/**
	 * このファイルのサイズを返す
	 * @link http://www.php.net/manual/ja/mongogridfsfile.getsize.php
	 * @return int このファイルのサイズを返します。
	 */
	public function getSize () {}

	/**
	 * このファイルをファイルシステムに書き込む
	 * @link http://www.php.net/manual/ja/mongogridfsfile.write.php
	 * @param filename string[optional] <p>
	 * ファイルの書き込み先。指定しなかった場合は、
	 * 格納されているファイル名を使用します。
	 * </p>
	 * @return int 書き込んだバイト数を返します。
	 */
	public function write ($filename = null) {}

	/**
	 * このファイルの内容をバイト文字列で返す
	 * @link http://www.php.net/manual/ja/mongogridfsfile.getbytes.php
	 * @return string ファイルの内容をバイト文字列で返します。
	 */
	public function getBytes () {}

	/**
	 * 格納されたファイルを読むために使うリソースを返す
	 * @link http://www.php.net/manual/ja/mongogridfsfile.getresource.php
	 * @return stream ファイルを読み込むために使うリソースを返します。
	 */
	public function getResource () {}

}

class MongoGridFSCursor extends MongoCursor implements Traversable, Iterator {
	public static $slaveOkay;
	public static $timeout;
	protected $gridfs;


	/**
	 * 新しいカーソルを作成する
	 * @link http://www.php.net/manual/ja/mongogridfscursor.construct.php
	 */
	public function __construct () {}

	/**
	 * カーソルが指す次のファイルを返し、カーソルを進める
	 * @link http://www.php.net/manual/ja/mongogridfscursor.getnext.php
	 * @return MongoGridFSFile 次のファイルを返します。
	 */
	public function getNext () {}

	/**
	 * 現在のファイルを返す
	 * @link http://www.php.net/manual/ja/mongogridfscursor.current.php
	 * @return MongoGridFSFile 現在のファイルを返します。
	 */
	public function current () {}

	/**
	 * 現在の結果のファイル名を返す
	 * @link http://www.php.net/manual/ja/mongogridfscursor.key.php
	 * @return string 現在の結果の _id を文字列で返します。
	 */
	public function key () {}

	/**
	 * このカーソルにまだ要素があるかどうかを調べる
	 * @link http://www.php.net/manual/ja/mongocursor.hasnext.php
	 * @return bool まだ要素があるかどうかを返します。
	 */
	public function hasNext () {}

	/**
	 * 返す結果の数を制限する
	 * @link http://www.php.net/manual/ja/mongocursor.limit.php
	 * @param num int <p>
	 * 返したい結果の数。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function limit ($num) {}

	/**
	 * ひとつのバッチで返す要素数を制限する
	 * @link http://www.php.net/manual/ja/mongocursor.batchsize.php
	 * @param batchSize int <p>
	 * バッチで返す結果の数。バッチごとにサーバーとのやりとりが発生します。
	 * </p>
	 * <p>
	 * batchSize が 2 以上
	 * の場合は、取得するオブジェクトの各バッチのサイズを表します。
	 * これをうまく調整すれば、パフォーマンスとデータ転送量を最適化できます。
	 * </p>
	 * <p>
	 * batchSize が 1 あるいは負の数の場合は、
	 * 返すドキュメントの最大数を batchSize の絶対値までに抑え、
	 * 結果を返した後にカーソルを閉じます。
	 * たとえば batchSize を -10
	 * にすると、サーバーは 4MB に収まる範囲で最大 10 件までのドキュメントを返して
	 * カーソルを閉じます。
	 * </p>
	 * <p>
	 * batchSize が 1
	 * あるいは -1 の場合は特別で、
	 * このカーソルからは 1 件のドキュメントしか返せなくなります。
	 * </p>
	 * <p>
	 * この機能が MongoCursor::limit と違うところは、
	 * ドキュメントが最大サイズに収まらなければいけないという点と、
	 * カーソルを閉じるリクエストをサーバーに送らなくてもよいという点です。
	 * カーソルをループしている間にもバッチサイズを変更でき、
	 * その次にバッチを取得するときから新しい設定が反映されます。
	 * </p>
	 * <p>
	 * これは、MongoDB がクライアントに返すデータ量の制限を上書きすることはできません。
	 * つまり、たとえバッチサイズを 1,000,000,000 にしても、
	 * MongoDB がバッチあたりで返す結果は 4-16MB にしかならないということです。
	 * </p>
	 * <p>
	 * 一貫性を維持するため、
	 * MongoCursor::batchSize と
	 * MongoCursor::limit のルールは多少込み入ったものになっていますが、
	 * 「期待通りに」動作します。そのルールとは、
	 * ハードリミットがソフトリミットを上書きし、
	 * MongoCursor::limit のほうが
	 * MongoCursor::batchSize より優先順位が高くなるということです。
	 * その結果、どちらであってももう一方より小さく設定されているほうが優先されます。
	 * 以下の例を参照ください。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function batchSize ($batchSize) {}

	/**
	 * 結果をスキップする
	 * @link http://www.php.net/manual/ja/mongocursor.skip.php
	 * @param num int <p>
	 * スキップしたい結果の数。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function skip ($num) {}

	/**
	 * クエリのフィールドを設定する
	 * @link http://www.php.net/manual/ja/mongocursor.fields.php
	 * @param f array <p>
	 * 返したい (あるいは返したくない) フィールド。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function fields (array $f) {}

	/**
	 * トップレベルの キー/値 のペアをクエリに追加する
	 * @link http://www.php.net/manual/ja/mongocursor.addoption.php
	 * @param key string <p>
	 * 追加したいフィールド名。
	 * </p>
	 * @param value mixed <p>
	 * 追加したい値。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function addOption ($key, $value) {}

	/**
	 * このクエリでスナップショットモードを使う
	 * @link http://www.php.net/manual/ja/mongocursor.snapshot.php
	 * @return MongoCursor このカーソルを返します。
	 */
	public function snapshot () {}

	/**
	 * 指定したフィールドで結果をソートする
	 * @link http://www.php.net/manual/ja/mongocursor.sort.php
	 * @param fields array <p>
	 * ソートするフィールドの配列。配列のキーがフィールド名、そして値には昇順なら
	 * 1、降順なら -1 を指定します。
	 * </p>
	 * <p>
	 * 個々の結果は、まず配列内の最初のフィールドでソートされ、次に
	 * (もしあれば) 二番目のフィールドでソートされ…というようになります。つまり、
	 * fields 配列でのフィールドを指定する順番が重要になるということです。
	 * サンプルも参照ください。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function sort (array $fields) {}

	/**
	 * クエリについてのヒントをデータベースに与える
	 * @link http://www.php.net/manual/ja/mongocursor.hint.php
	 * @param index mixed <p>
	 * クエリで使用するインデックス。
	 * 文字列を渡した場合は、インデックス名として扱います。
	 * 配列あるいはオブジェクトを渡した場合は、それに基づいてインデックスを組み立てます
	 * (MongoCollection::ensureIndex の最初の引数のようになります)。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function hint ($index) {}

	/**
	 * 最適化やデバッグの際に有効な、クエリの explain を返す
	 * @link http://www.php.net/manual/ja/mongocursor.explain.php
	 * @return array クエリの explain を返します。
	 */
	public function explain () {}

	/**
	 * 専用のメソッドが存在しない任意のフラグを設定する
	 * @link http://www.php.net/manual/ja/mongocursor.setflag.php
	 * @param flag bool <p>
	 * 設定するフラグ。フラグ 6
	 * (EXHAUST) は設定できません。ドライバがその処理方法を知らないからです。
	 * このフラグを使うと警告が発生します。使えるフラグについては、wire プロトコルの
	 * ドキュメント
	 * を参照ください。
	 * </p>
	 * @param set bool[optional] <p>
	 * フラグを設定する (TRUE) か解除する (FALSE) か。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function setFlag ($flag, $set = null) {}

	/**
	 * このクエリをセカンダリ上で完了できるかどうかを設定する
	 * @link http://www.php.net/manual/ja/mongocursor.slaveokay.php
	 * @param okay bool[optional] <p>
	 * セカンダリに問い合わせることが可能かどうか。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function slaveOkay ($okay = null) {}

	/**
	 * このカーソルが、最後の結果を取得した後もオープンしたままにしておくかどうかを設定する
	 * @link http://www.php.net/manual/ja/mongocursor.tailable.php
	 * @param tail bool[optional] <p>
	 * カーソルが追尾可能かどうか。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function tailable ($tail = null) {}

	/**
	 * このカーソルをタイムアウトさせるかどうかを設定する
	 * @link http://www.php.net/manual/ja/mongocursor.immortal.php
	 * @param liveForever bool[optional] <p>
	 * カーソルを不死にするかどうか。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function immortal ($liveForever = null) {}

	/**
	 * 追尾可能なカーソルで、データがないときにしばらく待つかどうかを設定する
	 * @link http://www.php.net/manual/ja/mongocursor.awaitdata.php
	 * @param wait bool[optional] <p>
	 * カーソルに、さらにデータがやってくるまで待たせるかどうか。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function awaitData ($wait = null) {}

	/**
	 * シャードがダウンしているときにこのクエリが <emphasis>mongos</emphasis> から部分的な結果を返すようにするかどうか
	 * @link http://www.php.net/manual/ja/mongocursor.partial.php
	 * @param okay bool[optional] <p>
	 * 部分的な結果の受信を許可するかどうか。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function partial ($okay = null) {}

	/**
	 * このクエリのクライアント側のタイムアウトを設定する
	 * @link http://www.php.net/manual/ja/mongocursor.timeout.php
	 * @param ms int <p>
	 * カーソルがレスポンスを待つミリ秒数。
	 * デフォルトではいつまでも待ち続けます。
	 * </p>
	 * @return MongoCursor このカーソルを返します。
	 */
	public function timeout ($ms) {}

	/**
	 * クエリを実行する
	 * @link http://www.php.net/manual/ja/mongocursor.doquery.php
	 * @return void NULL を返します。
	 */
	protected function doQuery () {}

	/**
	 * このカーソルの query、fields、limit そして skip を取得する
	 * @link http://www.php.net/manual/ja/mongocursor.info.php
	 * @return array このカーソルの namespace、limit、skip、query そして fields を返します。
	 */
	public function info () {}

	/**
	 * このカーソルにまだデータベースから送信されていないドキュメントがあるかどうかを調べる
	 * @link http://www.php.net/manual/ja/mongocursor.dead.php
	 * @return bool クライアントにまだ送られていない結果が残っているかどうかを返します。
	 */
	public function dead () {}

	/**
	 * カーソルを次の結果に進める
	 * @link http://www.php.net/manual/ja/mongocursor.next.php
	 * @return void NULL を返します。
	 */
	public function next () {}

	/**
	 * カーソルを結果セットの先頭に戻す
	 * @link http://www.php.net/manual/ja/mongocursor.rewind.php
	 * @return void NULL を返します。
	 */
	public function rewind () {}

	/**
	 * カーソルが正しい結果を読んでいるかどうかを調べる
	 * @link http://www.php.net/manual/ja/mongocursor.valid.php
	 * @return bool 現在の結果が null でないかどうかを返します。
	 */
	public function valid () {}

	/**
	 * カーソルを消去する
	 * @link http://www.php.net/manual/ja/mongocursor.reset.php
	 * @return void NULL を返します。
	 */
	public function reset () {}

	/**
	 * このクエリの結果の数を数える
	 * @link http://www.php.net/manual/ja/mongocursor.count.php
	 * @param foundOnly bool[optional] <p>
	 * カーソルの limit を送信し、制限に達した場合に count 関数への情報の送信をスキップします。
	 * </p>
	 * @return int このカーソルのクエリが返すドキュメントの数を返します。
	 */
	public function count ($foundOnly = null) {}

}

class MongoId  {
//	public $$id;


	/**
	 * 新しい ID を作成する
	 * @link http://www.php.net/manual/ja/mongoid.construct.php
	 */
	public function __construct () {}

	/**
	 * この ID の 16 進表現を返す
	 * @link http://www.php.net/manual/ja/mongoid.tostring.php
	 * @return string この ID を返します。
	 */
	public function __toString () {}

	/**
	 * ダミー MongoId を作成する
	 * @link http://www.php.net/manual/ja/mongoid.set-state.php
	 * @param props array <p>
	 * 理論上は、新しい id を作るときに使うプロパティの配列です。
	 * しかし、MongoId のインスタンスにはプロパティがないので、これは使いません。
	 * </p>
	 * @return MongoId 値 "000000000000000000000000" を持つ新しい id を返します。
	 */
	public static function __set_state (array $props) {}

	/**
	 * この id が作られたときのエポックからの経過秒数を取得する
	 * @link http://www.php.net/manual/ja/mongoid.gettimestamp.php
	 * @return int この id が作られたときのエポックからの経過秒数を返します。
	 * タイムスタンプの格納領域は 4 バイトしかないので、実際の時刻や幅広い時間を格納するには
	 * MongoDate のほうが適しています。
	 */
	public function getTimestamp () {}

	/**
	 * このマシンの id に使うホスト名を取得する
	 * @link http://www.php.net/manual/ja/mongoid.gethostname.php
	 * @return string ホスト名を返します。
	 */
	public static function getHostname () {}

	/**
	 * プロセス ID を取得する
	 * @link http://www.php.net/manual/ja/mongoid.getpid.php
	 * @return int MongoId の PID を返します。
	 */
	public function getPID () {}

	/**
	 * この id を作るためにインクリメントされた値を取得する
	 * @link http://www.php.net/manual/ja/mongoid.getinc.php
	 * @return int この MongoId を作るためにインクリメントされた値を返します。
	 */
	public function getInc () {}

}

class MongoCode  {
	public $code;
	public $scope;


	/**
	 * 新しいコードオブジェクトを作成する
	 * @link http://www.php.net/manual/ja/mongocode.construct.php
	 */
	public function __construct () {}

	/**
	 * このコードを文字列で返す
	 * @link http://www.php.net/manual/ja/mongocode.tostring.php
	 * @return string このコードを返します。スコープは返しません。
	 */
	public function __toString () {}

}

class MongoRegex  {
	public $regex;
	public $flags;


	/**
	 * 新しい正規表現を作成する
	 * @link http://www.php.net/manual/ja/mongoregex.construct.php
	 */
	public function __construct () {}

	/**
	 * この正規表現の文字列表現
	 * @link http://www.php.net/manual/ja/mongoregex.tostring.php
	 * @return string 正規表現を "/expr/flags" 形式で返します。
	 */
	public function __toString () {}

}

class MongoDate  {
	public $sec;
	public $usec;


	/**
	 * 新しい日付を作成する
	 * @link http://www.php.net/manual/ja/mongodate.construct.php
	 */
	public function __construct () {}

	/**
	 * この日付の文字列表現を返す
	 * @link http://www.php.net/manual/ja/mongodate.tostring.php
	 * @return string この日付を返します。
	 */
	public function __toString () {}

}

class MongoBinData  {
	const FUNC = 1;
	const BYTE_ARRAY = 2;
	const UUID = 3;
	const MD5 = 5;
	const CUSTOM = 128;

	public $bin;
	public $type;


	/**
	 * 新しいバイナリデータオブジェクトを作成する
	 * @link http://www.php.net/manual/ja/mongobindata.construct.php
	 */
	public function __construct () {}

	/**
	 * このバイナリデータオブジェクトの文字列表現
	 * @link http://www.php.net/manual/ja/mongobindata.tostring.php
	 * @return string 文字列 "&lt;Mongo Binary Data&gt;" を返します。
	 * MongoBinData の中身にアクセスするには、bin
	 * フィールドを使います。
	 */
	public function __toString () {}

}

class MongoDBRef  {
	protected static $refKey;
	protected static $idKey;


	/**
	 * 新しいデータベース参照を作成する
	 * @link http://www.php.net/manual/ja/mongodbref.create.php
	 * @param collection string <p>
	 * コレクションの名前 (データベース名を除く)。
	 * </p>
	 * @param id mixed <p>
	 * リンクするオブジェクトの _id フィールド。
	 * </p>
	 * @param database string[optional] <p>
	 * データベースの名前。
	 * </p>
	 * @return array 参照を返します。
	 */
	public static function create ($collection, $id, $database = null) {}

	/**
	 * 配列がデータベース参照か否かを調べる
	 * @link http://www.php.net/manual/ja/mongodbref.isref.php
	 * @param ref mixed <p>
	 * 調べたい配列あるいはオブジェクト。
	 * </p>
	 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public static function isRef ($ref) {}

	/**
	 * 参照が指すオブジェクトを取得する
	 * @link http://www.php.net/manual/ja/mongodbref.get.php
	 * @param db MongoDB <p>
	 * 使用するデータベース。
	 * </p>
	 * @param ref array <p>
	 * 取得したい参照。
	 * </p>
	 * @return array 参照が指すドキュメントを返します。ドキュメントが存在しない
	 * (参照が壊れている) 場合は NULL を返します。
	 */
	public static function get (MongoDB $db, array $ref) {}

}

class MongoException extends Exception  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class MongoCursorException extends MongoException  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;
	private $host;
	private $fd;


	/**
	 * エラーが発生したサーバーのホスト名を取得する
	 * @link http://www.php.net/manual/ja/mongocursorexception.gethost.php
	 * @return string ホスト名を返します。ホスト名が不明な場合は NULL を返します。
	 */
	public function getHost () {}

	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class MongoCursorTimeoutException extends MongoCursorException  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;


	/**
	 * エラーが発生したサーバーのホスト名を取得する
	 * @link http://www.php.net/manual/ja/mongocursorexception.gethost.php
	 * @return string ホスト名を返します。ホスト名が不明な場合は NULL を返します。
	 */
	public function getHost () {}

	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class MongoConnectionException extends MongoException  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class MongoGridFSException extends MongoException  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;


	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class MongoResultException extends MongoException  {
	protected $message;
	protected $code;
	protected $file;
	protected $line;
	public $document;


	/**
	 * 結果ドキュメントを取得する
	 * @link http://www.php.net/manual/ja/mongoresultexception.getdocument.php
	 * @return array すべての結果ドキュメントを配列で返します。部分的なデータや追加のキーがあれば、それも含まれます。
	 */
	public function getDocument () {}

	final private function __clone () {}

	/**
	 * @param message[optional]
	 * @param code[optional]
	 * @param previous[optional]
	 */
	public function __construct ($message, $code, $previous) {}

	final public function getMessage () {}

	final public function getCode () {}

	final public function getFile () {}

	final public function getLine () {}

	final public function getTrace () {}

	final public function getPrevious () {}

	final public function getTraceAsString () {}

	public function __toString () {}

}

class MongoTimestamp  {
	public $sec;
	public $inc;


	/**
	 * 新しいタイムスタンプを作成する
	 * @link http://www.php.net/manual/ja/mongotimestamp.construct.php
	 */
	public function __construct () {}

	/**
	 * このタイムスタンプを文字列形式で返す
	 * @link http://www.php.net/manual/ja/mongotimestamp.tostring.php
	 * @return string このタイムスタンプが表す、エポックからの経過秒数を返します。
	 */
	public function __toString () {}

}

class MongoInt32  {
	public $value;


	/**
	 * 新しい 32 ビット整数値を作成する
	 * @link http://www.php.net/manual/ja/mongoint32.construct.php
	 */
	public function __construct () {}

	/**
	 * この 32 ビット整数値の文字列表現を返す
	 * @link http://www.php.net/manual/ja/mongoint32.tostring.php
	 * @return string この整数値の文字列表現を返します。
	 */
	public function __toString () {}

}

class MongoInt64  {
	public $value;


	/**
	 * 新しい 64 ビット整数値を作成する
	 * @link http://www.php.net/manual/ja/mongoint64.construct.php
	 */
	public function __construct () {}

	/**
	 * この 64 ビット整数値の文字列表現を返す
	 * @link http://www.php.net/manual/ja/mongoint64.tostring.php
	 * @return string この整数値の文字列表現を返します。
	 */
	public function __toString () {}

}

class MongoLog  {
	const NONE = 0;
	const WARNING = 1;
	const INFO = 2;
	const FINE = 4;
	const RS = 1;
	const POOL = 1;
	const PARSE = 16;
	const CON = 2;
	const IO = 4;
	const SERVER = 8;
	const ALL = 31;

	private static $level;
	private static $module;
	private static $callback;


	/**
	 * ログレベルを設定する
	 * @link http://www.php.net/manual/ja/mongolog.setlevel.php
	 * @param level int <p>
	 * 記録したいログのレベル。
	 * </p>
	 * @return void 
	 */
	public static function setLevel ($level) {}

	/**
	 * ログレベルを取得する
	 * @link http://www.php.net/manual/ja/mongolog.getlevel.php
	 * @return int 現在のレベルを返します。
	 */
	public static function getLevel () {}

	/**
	 * ログに記録するドライバの機能を設定する
	 * @link http://www.php.net/manual/ja/mongolog.setmodule.php
	 * @param module int <p>
	 * ログを記録するモジュール。
	 * </p>
	 * @return void 
	 */
	public static function setModule ($module) {}

	/**
	 * 現在ログを記録しているモジュールを取得する
	 * @link http://www.php.net/manual/ja/mongolog.getmodule.php
	 * @return int 現在ログを記録しているモジュールを返します。
	 */
	public static function getModule () {}

	/**
	 * イベントに対応して呼ばれるコールバック関数を設定する
	 * @link http://www.php.net/manual/ja/mongolog.setcallback.php
	 * @param log_function callable <p>
	 * イベントに対応して呼ばれる関数。
	 * </p>
	 * <p>
	 * 関数のプロトタイプは、次のようになります。
	 * </p>
	 * <p>
	 * log_function
	 * intmodule
	 * intlevel
	 * stringmessage
	 * module
	 * MongoLog
	 * モジュール定数 のいずれか。
	 * @return void 成功した場合に TRUE を、失敗した場合に FALSE を返します。
	 */
	public static function setCallback ($log_function) {}

	/**
	 * 以前に設定されたコールバック関数の名前を取得する
	 * @link http://www.php.net/manual/ja/mongolog.getcallback.php
	 * @return void コールバック関数名を返します。まだ設定されていない場合は FALSE を返します。
	 */
	public static function getCallback () {}

}

class MongoPool  {

	/**
	 * すべての接続プールに関する情報を返す
	 * @link http://www.php.net/manual/ja/mongopool.info.php
	 * @return array 各接続プールには識別子があり、ホスト名から始まります。
	 * 個々の接続プールに対して、この関数は次のフィールドを表示します。
	 * in use
	 * <p>
	 * 現在 Mongo のインスタンスが使っている接続数。
	 * </p>
	 * in pool
	 * <p>
	 * 現在プールにある (未使用の) 接続数。
	 * </p>
	 * remaining
	 * <p>
	 * このプールで作れる接続数。たとえば、このプールで作れる接続数が 5 つで
	 * 現在プール内にある接続数が 3 であるとしましょう。この場合、プールを使い切るまでに
	 * MongoClient の新しいインスタンスを 8 つ作れることになります
	 * (MongoClient のインスタンスがスコープ外に出て、
	 * 接続をプールに返すことはないものとします)。
	 * </p>
	 * <p>
	 * 負の値は、このプールでは無制限に接続を作れることを意味します。
	 * </p>
	 * <p>
	 * プールを作る前には、接続の最大数を
	 * Mongo::setPoolSize で変更できます。
	 * この関数の出力でいったんプールを表示してしまうと、そのサイズは変更できません。
	 * </p>
	 * total
	 * <p>
	 * このプールで使える接続の総数。"in use" + "in pool" (あるいは -1) 以上になります。
	 * </p>
	 * timeout
	 * <p>
	 * このプール内の接続のソケットタイムアウト。
	 * このプール内の接続がサーバーへの接続を試みるときにどれだけ待つかを決めます。
	 * </p>
	 * waiting
	 * <p>
	 * プールのサイズの制限に達すると、プールから接続を要求するワーカーは
	 * 他のワーカーが接続を返却するまで待たされます。
	 * このフィールドは、ワーカーが接続の解放を待つミリ秒数を表示します。
	 * もしこの数値が増え続けるようなら、
	 * MongoPool::setSize でプールにより多くの接続を追加するといいでしょう。
	 * </p>
	 */
	public static function info () {}

	/**
	 * 新しい接続プールのサイズを設定する
	 * @link http://www.php.net/manual/ja/mongopool.setsize.php
	 * @param size int <p>
	 * 新しい接続プールが作成できる接続の最大数。
	 * 負の値を設定すると、接続を無限に作成できるようになります。
	 * </p>
	 * @return bool 設定する前のプールのサイズを返します。
	 */
	public static function setSize ($size) {}

	/**
	 * 接続プールのサイズを取得する
	 * @link http://www.php.net/manual/ja/mongopool.getsize.php
	 * @return int 現在のプールのサイズを返します。
	 */
	public static function getSize () {}

}

class MongoMaxKey  {
}

class MongoMinKey  {
}

/**
 * PHP の変数を BSON 文字列に変換する
 * @link http://www.php.net/manual/ja/function.bson-encode.php
 * @param anything mixed <p>
 * 変換したい変数。
 * </p>
 * @return string 変換した文字列を返します。
 */
function bson_encode ($anything) {}

/**
 * BSON オブジェクトを PHP の配列に復元する
 * @link http://www.php.net/manual/ja/function.bson-decode.php
 * @param bson string <p>
 * 復元したい BSON。
 * </p>
 * @return array BSON オブジェクトを復元したものを返します。
 */
function bson_decode ($bson) {}

// End of mongo v.1.3.1
?>
