<?php

// Start of ldap v.

/**
 * LDAP サーバーへ接続する
 * @link http://www.php.net/manual/ja/function.ldap-connect.php
 * @param hostname string[optional] <p>
 * OpenLDAP 2.x.x を使用している場合、ホスト名の代わりに URL を指定する
 * ことが可能です。SSL と組み合わせて LDAP を使用するには、SSL
 * サポートを指定して OpenLDAP 2.x.x をコンパイルし、PHP の configure で
 * SSL を指定し、このパラメータを ldaps://hostname/ とします。
 * </p>
 * @param port int[optional] <p>
 * 接続するポート。URL を用いる場合は使用しません。
 * </p>
 * @return resource 成功した場合に正の LDAP リンク ID 、エラーの場合に FALSE
 * を返します。OpenLDAP 2.x.x を使用している場合は、
 * ldap_connect は常に resource
 * を返しますが、実際には接続せずにパラメータの初期化だけを行います。
 * 実際に接続するのは次に ldap_* 関数がコールされた際で、これは
 * 通常は ldap_bind です。
 * </p>
 * <p>
 * 引数が指定されない場合、既に開かれているリンクのリンク ID を返します。
 */
function ldap_connect ($hostname = null, $port = null) {}

/**
 * <function>ldap_unbind</function> のエイリアス
 * @link http://www.php.net/manual/ja/function.ldap-close.php
 * @param link_identifier
 */
function ldap_close ($link_identifier) {}

/**
 * LDAP ディレクトリにバインドする
 * @link http://www.php.net/manual/ja/function.ldap-bind.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param bind_rdn string[optional] <p>
 * </p>
 * @param bind_password string[optional] <p>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_bind ($link_identifier, $bind_rdn = null, $bind_password = null) {}

/**
 * SASL を使用して LDAP ディレクトリにバインドする
 * @link http://www.php.net/manual/ja/function.ldap-sasl-bind.php
 * @param link resource 
 * @param binddn string[optional] 
 * @param password string[optional] 
 * @param sasl_mech string[optional] 
 * @param sasl_realm string[optional] 
 * @param sasl_authc_id string[optional] 
 * @param sasl_authz_id string[optional] 
 * @param props string[optional] 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_sasl_bind ($link, $binddn = null, $password = null, $sasl_mech = null, $sasl_realm = null, $sasl_authc_id = null, $sasl_authz_id = null, $props = null) {}

/**
 * LDAP ディレクトリへのバインドを解除する
 * @link http://www.php.net/manual/ja/function.ldap-unbind.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_unbind ($link_identifier) {}

/**
 * エントリを読み込む
 * @link http://www.php.net/manual/ja/function.ldap-read.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param base_dn string <p>
 * ディレクトリのベース DN。
 * </p>
 * @param filter string <p>
 * 空のフィルタは指定できません。
 * このエントリに関する全ての情報を完全に取得したい場合は、
 * objectClass=* というフィルタを使用してください。
 * ディレクトリサーバーで使用されるエントリの型が分かっている場合、
 * objectClass=inetOrgPerson
 * のように適切なフィルタを使用することができます。
 * </p>
 * @param attributes array[optional] <p>
 * 必要な属性を、
 * array("mail", "sn", "cn") のような通常の PHP 文字列配列で保持します。
 * "dn" は要求された属性の型によらず常に返されることに注意してください。
 * </p>
 * <p>
 * このパラメータを使用すると、デフォルトの動作よりもかなり効率的になります
 * (デフォルトでは、すべての属性とその値を返します)。
 * したがって、これを使用することを推奨します。
 * </p>
 * @param attrsonly int[optional] <p>
 * 属性の型のみを取得したい場合は 1 を設定します。
 * 属性の型および値の両方を取得したい場合は 0
 * を設定します (これがデフォルトの挙動です)。
 * </p>
 * @param sizelimit int[optional] <p>
 * 取得するエントリ数の制限を設定します。
 * 0 は無制限であることを表します。
 * </p>
 * <p>
 * このパラメータは、サーバー側で事前に設定されている
 * sizelimit を上書きすることはできません。それ以下の値を指定することはできます。
 * </p>
 * <p>
 * ディレクトリサーバーのホストによっては、
 * 事前に設定された数以上のエントリを返さないようになっているものもあります。
 * この場合、サーバーでは、それが結果セットのすべてではないことを通知します。
 * このパラメータでエントリ数を制限した場合にも、同じことが起こります。
 * </p>
 * @param timelimit int[optional] <p>
 * 検索に要する最大秒数を設定します。
 * これを 0 にすると無制限であることを表します。
 * </p>
 * <p>
 * このパラメータは、サーバー側で事前に設定されている
 * timelimit を上書きすることはできません。それ以下の値を指定することはできます。
 * </p>
 * @param deref int[optional] <p>
 * 検索時のエイリアスの扱いについて指定します。
 * 以下のいずれかとなります。
 * LDAP_DEREF_NEVER - (デフォルト)
 * エイリアスは参照されません。
 * @return resource 検索結果 ID を返します。エラーの場合は、FALSE を返します。
 */
function ldap_read ($link_identifier, $base_dn, $filter, array $attributes = null, $attrsonly = null, $sizelimit = null, $timelimit = null, $deref = null) {}

/**
 * 単一階層の検索を行う
 * @link http://www.php.net/manual/ja/function.ldap-list.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param base_dn string <p>
 * ディレクトリのベース DN。
 * </p>
 * @param filter string <p>
 * </p>
 * @param attributes array[optional] <p>
 * 必要な属性を、
 * array("mail", "sn", "cn") のような通常の PHP 文字列配列で保持します。
 * "dn" は要求された属性の型によらず常に返されることに注意してください。
 * </p>
 * <p>
 * このパラメータを使用すると、デフォルトの動作よりもかなり効率的になります
 * (デフォルトでは、すべての属性とその値を返します)。
 * したがって、これを使用することを推奨します。
 * </p>
 * @param attrsonly int[optional] <p>
 * 属性の型のみを取得したい場合は 1 を設定します。
 * 属性の型および値の両方を取得したい場合は 0
 * を設定します (これがデフォルトの挙動です)。
 * </p>
 * @param sizelimit int[optional] <p>
 * 取得するエントリ数の制限を設定します。
 * 0 は無制限であることを表します。
 * </p>
 * <p>
 * このパラメータは、サーバー側で事前に設定されている
 * sizelimit を上書きすることはできません。それ以下の値を指定することはできます。
 * </p>
 * <p>
 * ディレクトリサーバーのホストによっては、
 * 事前に設定された数以上のエントリを返さないようになっているものもあります。
 * この場合、サーバーでは、それが結果セットのすべてではないことを通知します。
 * このパラメータでエントリ数を制限した場合にも、同じことが起こります。
 * </p>
 * @param timelimit int[optional] <p>
 * 検索に要する最大秒数を設定します。
 * これを 0 にすると無制限であることを表します。
 * </p>
 * <p>
 * このパラメータは、サーバー側で事前に設定されている
 * timelimit を上書きすることはできません。それ以下の値を指定することはできます。
 * </p>
 * @param deref int[optional] <p>
 * 検索時のエイリアスの扱いについて指定します。
 * 以下のいずれかとなります。
 * LDAP_DEREF_NEVER - (デフォルト)
 * エイリアスは参照されません。
 * @return resource 検索結果 ID を返します。エラーの場合は、FALSE を返します。
 */
function ldap_list ($link_identifier, $base_dn, $filter, array $attributes = null, $attrsonly = null, $sizelimit = null, $timelimit = null, $deref = null) {}

/**
 * LDAP ツリーを探索する
 * @link http://www.php.net/manual/ja/function.ldap-search.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param base_dn string <p>
 * ディレクトリのベース DN。
 * </p>
 * @param filter string <p>
 * 検索フィルタは、LDAP ドキュメントに記述されたフォーマットの論理
 * 演算子を用いて、簡単なものまたは高度なものとすることができます
 * (フィルタに関する詳細な情報については、
 * Netscape Directory SDK
 * を参照ください)。
 * </p>
 * @param attributes array[optional] <p>
 * 必要な属性を、
 * array("mail", "sn", "cn") のような通常の PHP 文字列配列で保持します。
 * "dn" は要求された属性の型によらず常に返されることに注意してください。
 * </p>
 * <p>
 * このパラメータを使用すると、デフォルトの動作よりもかなり効率的になります
 * (デフォルトでは、すべての属性とその値を返します)。
 * したがって、これを使用することを推奨します。
 * </p>
 * @param attrsonly int[optional] <p>
 * 属性の型のみを取得したい場合は 1 を設定します。
 * 属性の型および値の両方を取得したい場合は 0
 * を設定します (これがデフォルトの挙動です)。
 * </p>
 * @param sizelimit int[optional] <p>
 * 取得するエントリ数の制限を設定します。
 * 0 は無制限であることを表します。
 * </p>
 * <p>
 * このパラメータは、サーバー側で事前に設定されている
 * sizelimit を上書きすることはできません。それ以下の値を指定することはできます。
 * </p>
 * <p>
 * ディレクトリサーバーのホストによっては、
 * 事前に設定された数以上のエントリを返さないようになっているものもあります。
 * この場合、サーバーでは、それが結果セットのすべてではないことを通知します。
 * このパラメータでエントリ数を制限した場合にも、同じことが起こります。
 * </p>
 * @param timelimit int[optional] <p>
 * 検索に要する最大秒数を設定します。
 * これを 0 にすると無制限であることを表します。
 * </p>
 * <p>
 * このパラメータは、サーバー側で事前に設定されている
 * timelimit を上書きすることはできません。それ以下の値を指定することはできます。
 * </p>
 * @param deref int[optional] <p>
 * 検索時のエイリアスの扱いについて指定します。
 * 以下のいずれかとなります。
 * LDAP_DEREF_NEVER - (デフォルト)
 * エイリアスは参照されません。
 * @return resource 検索結果 ID を返します。エラーの場合は、FALSE を返します。
 */
function ldap_search ($link_identifier, $base_dn, $filter, array $attributes = null, $attrsonly = null, $sizelimit = null, $timelimit = null, $deref = null) {}

/**
 * 結果メモリを開放する
 * @link http://www.php.net/manual/ja/function.ldap-free-result.php
 * @param result_identifier resource <p>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_free_result ($result_identifier) {}

/**
 * 検索結果のエントリ数を数える
 * @link http://www.php.net/manual/ja/function.ldap-count-entries.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param result_identifier resource <p>
 * 内部の LDAP 結果。
 * </p>
 * @return int 結果のエントリ数を返します。エラーの場合は FALSE を返します。
 */
function ldap_count_entries ($link_identifier, $result_identifier) {}

/**
 * 最初の結果 ID を返す
 * @link http://www.php.net/manual/ja/function.ldap-first-entry.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param result_identifier resource <p>
 * </p>
 * @return resource 成功時に最初のエントリに関する結果エントリ ID、エラーの場合に FALSE
 * を返します。
 */
function ldap_first_entry ($link_identifier, $result_identifier) {}

/**
 * 次の結果エントリを得る
 * @link http://www.php.net/manual/ja/function.ldap-next-entry.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param result_entry_identifier resource <p>
 * </p>
 * @return resource ldap_first_entry によりエントリが読み始められた
 * 結果において次のエントリに関するエントリID を返します。
 * これ以上結果のエントリがない場合は、FALSEを返します。
 */
function ldap_next_entry ($link_identifier, $result_entry_identifier) {}

/**
 * 全ての結果エントリを得る
 * @link http://www.php.net/manual/ja/function.ldap-get-entries.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param result_identifier resource <p>
 * </p>
 * @return array 成功時に完全な結果情報を多次元配列で返します。エラーの場合に FALSE
 * を返します。
 * </p>
 * <p>
 * 配列の構造は次のようになります。
 * 属性インデックスは、小文字に変換されます
 * (属性は大文字小文字を区別しませんが、配列インデックスとして使用する時は別です)。
 */
function ldap_get_entries ($link_identifier, $result_identifier) {}

/**
 * 最初の属性を返す
 * @link http://www.php.net/manual/ja/function.ldap-first-attribute.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param result_entry_identifier resource <p>
 * </p>
 * @return string 成功した場合にエントリの最初の属性、エラーの場合に FALSE を返します。
 */
function ldap_first_attribute ($link_identifier, $result_entry_identifier) {}

/**
 * 結果における次の属性を得る
 * @link http://www.php.net/manual/ja/function.ldap-next-attribute.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param result_entry_identifier resource <p>
 * </p>
 * @return string 成功した場合、エントリにおける次の属性を返します。エラー時に FALSE を返します。
 */
function ldap_next_attribute ($link_identifier, $result_entry_identifier) {}

/**
 * 検索結果エントリから属性を得る
 * @link http://www.php.net/manual/ja/function.ldap-get-attributes.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param result_entry_identifier resource <p>
 * </p>
 * @return array 成功時に完全なエントリ情報を多次元配列で返します。エラーの場合、
 * FALSE を返します。
 */
function ldap_get_attributes ($link_identifier, $result_entry_identifier) {}

/**
 * 結果エントリから全ての値を得る
 * @link http://www.php.net/manual/ja/function.ldap-get-values.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param result_entry_identifier resource <p>
 * </p>
 * @param attribute string <p>
 * </p>
 * @return array 成功した場合、指定した属性に関する値を配列を返します。エラーの場合は
 * FALSE を返します。値の数を調べるには、結果の配列の
 * "count" という要素を確認します。個々の値にアクセスするには、
 * 整数値のインデックスを指定して配列にアクセスします。
 * 最初のインデックスは 0 となります。
 * </p>
 * <p>
 * LDAP では、ある属性に関して複数のエントリを持つことが可能です。
 * このため、たとえば一人の人間のディレクトリエントリに多数の
 * 電子メールアドレスがあったとしても、それらをすべて
 * "mail" という属性で管理することができます。
 * return_value["count"] = 属性の値の数
 * return_value[0] = 属性の最初の値
 * return_value[i] = 属性の i 番目の値
 */
function ldap_get_values ($link_identifier, $result_entry_identifier, $attribute) {}

/**
 * 結果エントリから全てのバイナリ値を得る
 * @link http://www.php.net/manual/ja/function.ldap-get-values-len.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param result_entry_identifier resource <p>
 * </p>
 * @param attribute string <p>
 * </p>
 * @return array 成功時に属性の値を配列で返し、エラー時に FALSE を返します。
 * 個々の値は、配列インデックスによりアクセスします。最初のインデックスは、0 です。
 * 値の数は、結果の配列の "count" という要素で知ることができます。
 */
function ldap_get_values_len ($link_identifier, $result_entry_identifier, $attribute) {}

/**
 * 結果エントリから DN を得る
 * @link http://www.php.net/manual/ja/function.ldap-get-dn.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param result_entry_identifier resource <p>
 * </p>
 * @return string 結果エントリの DN を返します。エラーの場合、FALSEを返します。
 */
function ldap_get_dn ($link_identifier, $result_entry_identifier) {}

/**
 * DN を構成要素ごとに分割する
 * @link http://www.php.net/manual/ja/function.ldap-explode-dn.php
 * @param dn string <p>
 * LDAP エンティティの識別名。
 * </p>
 * @param with_attrib int <p>
 * RDN が値のみを返すのか、
 * あるいは、属性を同時に返すのかを指定するために使用します。
 * 属性を有する RDN (属性=値 フォーマットで) を得るためには
 * with_attrib を 0 とし、
 * 値のみを得るためには 1 に設定します。
 * </p>
 * @return array すべての DN 要素を配列で返します。
 * この配列の最初の要素のキーは count で、
 * これは返される値の数を表します。次の要素は、DN の数値添字配列となります。
 */
function ldap_explode_dn ($dn, $with_attrib) {}

/**
 * DN をユーザーに分かりやすい名前のフォーマットに変換する
 * @link http://www.php.net/manual/ja/function.ldap-dn2ufn.php
 * @param dn string <p>
 * LDAP エンティティの識別名。
 * </p>
 * @return string ユーザーにわかりやすい形式の名前を返します。
 */
function ldap_dn2ufn ($dn) {}

/**
 * LDAP ディレクトリにエントリを付加する
 * @link http://www.php.net/manual/ja/function.ldap-add.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param dn string <p>
 * LDAP エンティティの識別名。
 * </p>
 * @param entry array <p>
 * そのエントリに関する情報を表す配列。
 * エントリの値は、個々の属性によりインデックスが作成されています。
 * ある属性に関して複数の値がある場合は、0 から始まる整数で
 * 添字が作成されます。
 * ]]>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_add ($link_identifier, $dn, array $entry) {}

/**
 * ディレクトリからエントリを削除する
 * @link http://www.php.net/manual/ja/function.ldap-delete.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param dn string <p>
 * LDAP エンティティの識別名。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_delete ($link_identifier, $dn) {}

/**
 * LDAP エントリを修正する
 * @link http://www.php.net/manual/ja/function.ldap-modify.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param dn string <p>
 * LDAP エンティティの識別名。
 * </p>
 * @param entry array <p>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_modify ($link_identifier, $dn, array $entry) {}

/**
 * 現在の属性に属性を追加する
 * @link http://www.php.net/manual/ja/function.ldap-mod-add.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param dn string <p>
 * LDAP エンティティの識別名。
 * </p>
 * @param entry array <p>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_mod_add ($link_identifier, $dn, array $entry) {}

/**
 * 属性を新規の値に置換する
 * @link http://www.php.net/manual/ja/function.ldap-mod-replace.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param dn string <p>
 * LDAP エンティティの識別名。
 * </p>
 * @param entry array <p>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_mod_replace ($link_identifier, $dn, array $entry) {}

/**
 * 現在の属性から属性を削除する
 * @link http://www.php.net/manual/ja/function.ldap-mod-del.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param dn string <p>
 * LDAP エンティティの識別名。
 * </p>
 * @param entry array <p>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_mod_del ($link_identifier, $dn, array $entry) {}

/**
 * 直近の LDAP コマンドの LDAP エラー番号を返す
 * @link http://www.php.net/manual/ja/function.ldap-errno.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @return int このリンクに関する直近の LDAP コマンドの LDAP エラー番号を返します。
 */
function ldap_errno ($link_identifier) {}

/**
 * LDAP のエラー番号をエラーメッセージ文字列に変換する
 * @link http://www.php.net/manual/ja/function.ldap-err2str.php
 * @param errno int <p>
 * エラー番号。
 * </p>
 * @return string エラーメッセージを表す文字列を返します。
 */
function ldap_err2str ($errno) {}

/**
 * 直近の LDAP コマンドの LDAP エラーメッセージを返す
 * @link http://www.php.net/manual/ja/function.ldap-error.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @return string エラーメッセージ文字列を返します。
 */
function ldap_error ($link_identifier) {}

/**
 * 指定した DN のエントリで見付かった属性の値を比較する
 * @link http://www.php.net/manual/ja/function.ldap-compare.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param dn string <p>
 * LDAP エンティティの識別名。
 * </p>
 * @param attribute string <p>
 * 属性の名前。
 * </p>
 * @param value string <p>
 * 比較する値。
 * </p>
 * @return mixed value がマッチする場合に TRUE、その他の場合に
 * FALSE、エラーの場合に -1 を返します。
 */
function ldap_compare ($link_identifier, $dn, $attribute, $value) {}

/**
 * LDAP 結果エントリをソートする
 * @link http://www.php.net/manual/ja/function.ldap-sort.php
 * @param link resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param result resource <p>
 * ldap_search が返す検索結果 ID。
 * </p>
 * @param sortfilter string <p>
 * ソートのキーとして使う属性。
 * </p>
 * @return bool 
 */
function ldap_sort ($link, $result, $sortfilter) {}

/**
 * エントリ名を修正する
 * @link http://www.php.net/manual/ja/function.ldap-rename.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param dn string <p>
 * LDAP エンティティの識別名。
 * </p>
 * @param newrdn string <p>
 * 新しい RDN。
 * </p>
 * @param newparent string <p>
 * 新しい親エントリ。
 * </p>
 * @param deleteoldrdn bool <p>
 * TRUE の場合は古い RDN 値を削除します。それ以外の場合は古い RDN
 * 値がそのエントリの non-distinguished 値として残されます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_rename ($link_identifier, $dn, $newrdn, $newparent, $deleteoldrdn) {}

/**
 * 指定したオプションの現在の値を得る
 * @link http://www.php.net/manual/ja/function.ldap-get-option.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param option int <p>
 * パラメータ option は以下のいずれかとなります。
 * <tr valign="top">
 * <td>オプション</td>
 * <td>型</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_DEREF</td>
 * <td>integer</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_SIZELIMIT</td>
 * <td>integer</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_TIMELIMIT</td>
 * <td>integer</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_NETWORK_TIMEOUT</td>
 * <td>integer</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_PROTOCOL_VERSION</td>
 * <td>integer</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_ERROR_NUMBER</td>
 * <td>integer</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_REFERRALS</td>
 * <td>bool</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_RESTART</td>
 * <td>bool</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_HOST_NAME</td>
 * <td>string</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_ERROR_STRING</td>
 * <td>string</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_MATCHED_DN</td>
 * <td>string</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_SERVER_CONTROLS</td>
 * <td>array</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_CLIENT_CONTROLS</td>
 * <td>array</td>
 * </tr>
 * </p>
 * @param retval mixed <p>
 * これが、オプションの値として設定されます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_get_option ($link_identifier, $option, &$retval) {}

/**
 * 指定したオプションの値を設定する
 * @link http://www.php.net/manual/ja/function.ldap-set-option.php
 * @param link_identifier resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param option int <p>
 * パラメータ option は以下のいずれかとなります。
 * <tr valign="top">
 * <td>オプション</td>
 * <td>型</td>
 * <td>～以降で使用可能</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_DEREF</td>
 * <td>integer</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_SIZELIMIT</td>
 * <td>integer</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_TIMELIMIT</td>
 * <td>integer</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_NETWORK_TIMEOUT</td>
 * <td>integer</td>
 * <td>PHP 5.3.0</td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_PROTOCOL_VERSION</td>
 * <td>integer</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_ERROR_NUMBER</td>
 * <td>integer</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_REFERRALS</td>
 * <td>bool</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_RESTART</td>
 * <td>bool</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_HOST_NAME</td>
 * <td>string</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_ERROR_STRING</td>
 * <td>string</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_MATCHED_DN</td>
 * <td>string</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_SERVER_CONTROLS</td>
 * <td>array</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>LDAP_OPT_CLIENT_CONTROLS</td>
 * <td>array</td>
 * <td></td>
 * </tr>
 * </p>
 * <p>
 * LDAP_OPT_SERVER_CONTROLS および
 * LDAP_OPT_CLIENT_CONTROLS 
 * はコントロールのリストを必要とします。
 * これは、値がコントロールの配列である必要があることです。
 * コントロールは、そのコントロールの ID
 * である oid、オプションの
 * value、オプションのフラグ
 * criticality からなります。PHP において、
 * コントロールはキーが oid で値が文字列、
 * 二つのオプションの要素からなる配列で指定されます。オプションの要素は、
 * キーが value で値が文字列、そしてキーが
 * iscritical で値が論理値となります。
 * iscritical を省略した場合のデフォルトは
 * FALSE です。詳細は draft-ietf-ldapext-ldap-c-api-xx.txt
 * を参照ください。また以下の二番目の例も参照ください。
 * </p>
 * @param newval mixed <p>
 * 指定したオプション option の新しい値。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_set_option ($link_identifier, $option, $newval) {}

/**
 * 最初のリファレンスを返す
 * @link http://www.php.net/manual/ja/function.ldap-first-reference.php
 * @param link resource 
 * @param result resource 
 * @return resource 
 */
function ldap_first_reference ($link, $result) {}

/**
 * 次のリファレンスを得る
 * @link http://www.php.net/manual/ja/function.ldap-next-reference.php
 * @param link resource 
 * @param entry resource 
 * @return resource 
 */
function ldap_next_reference ($link, $entry) {}

/**
 * 参照エントリから情報を展開する
 * @link http://www.php.net/manual/ja/function.ldap-parse-reference.php
 * @param link resource 
 * @param entry resource 
 * @param referrals array 
 * @return bool 
 */
function ldap_parse_reference ($link, $entry, array &$referrals) {}

/**
 * 結果から情報を展開する
 * @link http://www.php.net/manual/ja/function.ldap-parse-result.php
 * @param link resource 
 * @param result resource 
 * @param errcode int 
 * @param matcheddn string[optional] 
 * @param errmsg string[optional] 
 * @param referrals array[optional] 
 * @return bool 
 */
function ldap_parse_result ($link, $result, &$errcode, &$matcheddn = null, &$errmsg = null, array &$referrals = null) {}

/**
 * TLS を開始する
 * @link http://www.php.net/manual/ja/function.ldap-start-tls.php
 * @param link resource 
 * @return bool 
 */
function ldap_start_tls ($link) {}

/**
 * LDAP ページネーション制御情報を送信する
 * @link http://www.php.net/manual/ja/function.ldap-control-paged-result.php
 * @param link resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param pagesize int <p>
 * ページあたりのエントリ数。
 * </p>
 * @param iscritical bool[optional] <p>
 * ページネーションを必須にするかどうか。
 * true にすると、もしサーバーがページネーションに対応していなければ
 * 検索結果を返しません。
 * </p>
 * @param cookie string[optional] <p>
 * サーバーから送られる opaque structure
 * (ldap_control_paged_result_response)。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_control_paged_result ($link, $pagesize, $iscritical = null, $cookie = null) {}

/**
 * LDAP ページネーションクッキーを取得する
 * @link http://www.php.net/manual/ja/function.ldap-control-paged-result-response.php
 * @param link resource <p>
 * ldap_connect が返す LDAP リンク ID。
 * </p>
 * @param result resource <p>
 * </p>
 * @param cookie string[optional] <p>
 * サーバーから送られる opaque structure。
 * </p>
 * @param estimated int[optional] <p>
 * 取得するエントリ数の予測。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function ldap_control_paged_result_response ($link, $result, &$cookie = null, &$estimated = null) {}

define ('LDAP_DEREF_NEVER', 0);
define ('LDAP_DEREF_SEARCHING', 1);
define ('LDAP_DEREF_FINDING', 2);
define ('LDAP_DEREF_ALWAYS', 3);

/**
 * サーバーでエイリアスをたどるときの、別の規則を指定します。
 * @link http://www.php.net/manual/ja/ldap.constants.php
 */
define ('LDAP_OPT_DEREF', 2);

/**
 * <p>
 * 検索操作で返すことができるエントリの最大数を指定します。
 * </p>
 * 実際のサイズ制限は、サーバー側で設定されている最大エントリ数にも影響を受けます。
 * これらふたつの設定のうち小さい方が実際のサイズ制限となります。
 * @link http://www.php.net/manual/ja/ldap.constants.php
 */
define ('LDAP_OPT_SIZELIMIT', 3);

/**
 * 検索結果を待ち続ける秒数を指定します。
 * 実際の時間制限は、サーバー側で設定されている最大時間にも影響を受けます。
 * これらふたつの設定のうち小さい方が実際の時間制限となります。
 * @link http://www.php.net/manual/ja/ldap.constants.php
 */
define ('LDAP_OPT_TIMELIMIT', 4);

/**
 * ldap_set_option 用のオプションで、
 * ネットワークのタイムアウトを設定します
 * (PHP 5.3.0 以降で利用可能です)。
 * @link http://www.php.net/manual/ja/ldap.constants.php
 */
define ('LDAP_OPT_NETWORK_TIMEOUT', 20485);

/**
 * 使用する LDAP プロトコルのバージョン (V2 あるいは V3) を指定します。
 * @link http://www.php.net/manual/ja/ldap.constants.php
 */
define ('LDAP_OPT_PROTOCOL_VERSION', 17);
define ('LDAP_OPT_ERROR_NUMBER', 49);

/**
 * LDAP サーバーから返される参照を自動的にたどるかどうかを指定します。
 * @link http://www.php.net/manual/ja/ldap.constants.php
 */
define ('LDAP_OPT_REFERRALS', 8);
define ('LDAP_OPT_RESTART', 9);
define ('LDAP_OPT_HOST_NAME', 48);
define ('LDAP_OPT_ERROR_STRING', 50);
define ('LDAP_OPT_MATCHED_DN', 51);

/**
 * リクエストごとに送信するサーバーコントロールのデフォルトリストを指定します。
 * @link http://www.php.net/manual/ja/ldap.constants.php
 */
define ('LDAP_OPT_SERVER_CONTROLS', 18);

/**
 * リクエストごとに処理するクライアントコントロールのデフォルトリストを指定します。
 * @link http://www.php.net/manual/ja/ldap.constants.php
 */
define ('LDAP_OPT_CLIENT_CONTROLS', 19);

/**
 * デバッグトレース用のビットレベルを指定します。
 * @link http://www.php.net/manual/ja/ldap.constants.php
 */
define ('LDAP_OPT_DEBUG_LEVEL', 20481);
define ('LDAP_OPT_X_SASL_MECH', 24832);
define ('LDAP_OPT_X_SASL_REALM', 24833);
define ('LDAP_OPT_X_SASL_AUTHCID', 24834);
define ('LDAP_OPT_X_SASL_AUTHZID', 24835);

// End of ldap v.
?>
