<?php

// Start of bcmath v.

/**
 * 2つの任意精度の数値を加算する
 * @link http://www.php.net/manual/ja/function.bcadd.php
 * @param left_operand string <p>
 * 左オペランドを表す文字列。
 * </p>
 * @param right_operand string <p>
 * 右オペランドを表す文字列。
 * </p>
 * @param scale int[optional] 
 * @return string 二つの数の和を文字列で返します。
 */
function bcadd ($left_operand, $right_operand, $scale = null) {}

/**
 * 任意精度数値の減算を行う
 * @link http://www.php.net/manual/ja/function.bcsub.php
 * @param left_operand string <p>
 * 左オペランドを表す文字列。
 * </p>
 * @param right_operand string <p>
 * 右オペランドを表す文字列。
 * </p>
 * @param scale int[optional] 
 * @return string 減算の結果を文字列で返します。
 */
function bcsub ($left_operand, $right_operand, $scale = null) {}

/**
 * 2つの任意精度数値の乗算を行う
 * @link http://www.php.net/manual/ja/function.bcmul.php
 * @param left_operand string <p>
 * 左オペランドを表す文字列。
 * </p>
 * @param right_operand string <p>
 * 右オペランドを表す文字列。
 * </p>
 * @param scale int[optional] 
 * @return string 結果を文字列で返します。
 */
function bcmul ($left_operand, $right_operand, $scale = null) {}

/**
 * 2つの任意精度数値で除算を行う
 * @link http://www.php.net/manual/ja/function.bcdiv.php
 * @param left_operand string <p>
 * 左オペランドを表す文字列。
 * </p>
 * @param right_operand string <p>
 * 右オペランドを表す文字列。
 * </p>
 * @param scale int[optional] 
 * @return string 除算結果を文字列で返します。
 * right_operand が 0
 * の場合は NULL を返します。
 */
function bcdiv ($left_operand, $right_operand, $scale = null) {}

/**
 * 2 つの任意精度数値の剰余を取得する
 * @link http://www.php.net/manual/ja/function.bcmod.php
 * @param left_operand string <p>
 * 左オペランドを表す文字列。
 * </p>
 * @param modulus string <p>
 * 法を表す文字列。
 * </p>
 * @return string 剰余を文字列で返します。
 * modulus が 0 の場合は NULL を返します。
 */
function bcmod ($left_operand, $modulus) {}

/**
 * 任意精度数値をべき乗する
 * @link http://www.php.net/manual/ja/function.bcpow.php
 * @param left_operand string <p>
 * 左オペランドを表す文字列。
 * </p>
 * @param right_operand string <p>
 * 右オペランドを表す文字列。
 * </p>
 * @param scale int[optional] 
 * @return string 結果を文字列で返します。
 */
function bcpow ($left_operand, $right_operand, $scale = null) {}

/**
 * 任意精度数値の平方根を取得する
 * @link http://www.php.net/manual/ja/function.bcsqrt.php
 * @param operand string <p>
 * オペランドを表す文字列。
 * </p>
 * @param scale int[optional] 
 * @return string 平方根を文字列で返します。
 * operand が負の場合は NULL を返します。
 */
function bcsqrt ($operand, $scale = null) {}

/**
 * すべての BC 演算関数におけるデフォルトのスケールを設定する
 * @link http://www.php.net/manual/ja/function.bcscale.php
 * @param scale int <p>
 * スケール。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function bcscale ($scale) {}

/**
 * 2 つの任意精度数値を比較する
 * @link http://www.php.net/manual/ja/function.bccomp.php
 * @param left_operand string <p>
 * 左オペランドを表す文字列。
 * </p>
 * @param right_operand string <p>
 * 右オペランドを表す文字列。
 * </p>
 * @param scale int[optional] <p>
 * オプションの scale パラメータで、
 * 小数点以下の桁数を指定します。ここまでを使用して比較を行います。
 * </p>
 * @return int ふたつのオペランドが等しければ 0、
 * left_operand が right_operand
 * より大きければ返り値は 1、小さければ -1 を返します。
 */
function bccomp ($left_operand, $right_operand, $scale = null) {}

/**
 * 任意精度数値のべき乗の、指定した数値による剰余
 * @link http://www.php.net/manual/ja/function.bcpowmod.php
 * @param left_operand string <p>
 * 左オペランドを表す文字列。
 * </p>
 * @param right_operand string <p>
 * 右オペランドを表す文字列。
 * </p>
 * @param modulus string <p>
 * 法を表す文字列。
 * </p>
 * @param scale int[optional] 
 * @return string 結果を文字列で返します。modulus
 * が 0 の場合は NULL を返します。
 */
function bcpowmod ($left_operand, $right_operand, $modulus, $scale = null) {}

// End of bcmath v.
?>
