<?php

// Start of ereg v.

/**
 * 正規表現によるマッチングを行う
 * @link http://www.php.net/manual/ja/function.ereg.php
 * @param pattern string <p>
 * 大文字小文字を区別する正規表現。
 * </p>
 * @param string string <p>
 * 入力文字列。
 * </p>
 * @param regs array[optional] <p>
 * pattern の括弧でくくられた部分文字列に
 * マッチし、かつこの関数が 3 番目の引数 regs を
 * 指定してコールされた場合、マッチした部分が配列 regs
 * に格納されます。
 * </p>
 * <p>
 * $regs[1] は最初の左括弧が始まる部分文字列を保持、
 * $regs[2] は二番目の左括弧が始まる部分文字列を保持、
 * といったようになっています。$regs[0] は
 * マッチした文字列全体のコピーを保持しています。
 * </p>
 * @return int string の中で pattern
 * がマッチした場合にはマッチした文字列の長さを返し、マッチしなかった場合
 * またはエラーとなった場合は FALSE を返します。
 * </p>
 * <p>
 * オプションのパラメータ regs が渡されなかったり
 * マッチした文字列の長さが 0 だったりした場合は、この関数は 1 を返します。
 */
function ereg ($pattern, $string, array &$regs = null) {}

/**
 * 正規表現による置換を行う
 * @link http://www.php.net/manual/ja/function.ereg-replace.php
 * @param pattern string <p>
 * POSIX 拡張正規表現。
 * </p>
 * @param replacement string <p>
 * pattern の中に括弧でくくられた部分
 * 文字列が含まれている場合、replacement
 * の中に \数字
 * のような部分文字列を埋め込むこともできます。この部分は、
 * 「数字」番目の括弧でくくられた部分文字列にマッチする文字列に
 * 置き換えられます。また、\0 は文字列全体を
 * 指します。9 個までの部分文字列を使うことができます。括弧は
 * 入れ子になっていても構いません。この場合は開き括弧 '(' が
 * 最大 9 個まで使用可能です。
 * </p>
 * @param string string <p>
 * 入力文字列。
 * </p>
 * @return string 置換後の文字列を返します。
 * マッチしなかった場合は、元の文字列をそのまま返します。
 */
function ereg_replace ($pattern, $replacement, $string) {}

/**
 * 大文字小文字を区別せずに正規表現によるマッチングを行う
 * @link http://www.php.net/manual/ja/function.eregi.php
 * @param pattern string <p>
 * 大文字小文字を区別しない正規表現。
 * </p>
 * @param string string <p>
 * 入力文字列。
 * </p>
 * @param regs array[optional] <p>
 * pattern の括弧でくくられた部分文字列に
 * マッチし、かつこの関数が 3 番目の引数 regs を
 * 指定してコールされた場合、マッチした部分が配列 regs
 * に格納されます。
 * </p>
 * <p>
 * $regs[1] は最初の左括弧が始まる部分文字列を保持、
 * $regs[2] は二番目の左括弧が始まる部分文字列を保持、
 * といったようになっています。$regs[0] は
 * マッチした文字列全体のコピーを保持しています。
 * </p>
 * @return int string の中で pattern
 * がマッチした場合にはマッチした文字列の長さを返し、マッチしなかった場合
 * またはエラーとなった場合は FALSE を返します。
 * </p>
 * <p>
 * オプションのパラメータ regs が渡されなかったり
 * マッチした文字列の長さが 0 だったりした場合は、この関数は 1 を返します。
 */
function eregi ($pattern, $string, array &$regs = null) {}

/**
 * 大文字小文字を区別せずに正規表現による置換を行う
 * @link http://www.php.net/manual/ja/function.eregi-replace.php
 * @param pattern string <p>
 * POSIX 拡張正規表現。
 * </p>
 * @param replacement string <p>
 * pattern の中に括弧でくくられた部分
 * 文字列が含まれている場合、replacement
 * の中に \数字
 * のような部分文字列を埋め込むこともできます。この部分は、
 * 「数字」番目の括弧でくくられた部分文字列にマッチする文字列に
 * 置き換えられます。また、\0 は文字列全体を
 * 指します。9 個までの部分文字列を使うことができます。括弧は
 * 入れ子になっていても構いません。この場合は開き括弧 '(' が
 * 最大 9 個まで使用可能です。
 * </p>
 * @param string string <p>
 * 入力文字列。
 * </p>
 * @return string 置換後の文字列を返します。
 * マッチしなかった場合は、元の文字列をそのまま返します。
 */
function eregi_replace ($pattern, $replacement, $string) {}

/**
 * 正規表現により文字列を分割し、配列に格納する
 * @link http://www.php.net/manual/ja/function.split.php
 * @param pattern string <p>
 * 大文字小文字を区別する正規表現。
 * </p>
 * <p>
 * 正規表現で特殊文字とみなされる文字を分割したい場合、それらを
 * まずエスケープする必要があります。split
 * (または他の正規表現関数に関して)の動作が何か変であると感じたならば、
 * PHP 配布ファイルの
 * regex/ サブディレクトリにあるファイル
 * regex.7 を読んでください。このファイルは
 * man ページ形式となっており、読むには
 * man /usr/local/src/regex/regex.7 のようにします。
 * </p>
 * @param string string <p>
 * 入力文字列。
 * </p>
 * @param limit int[optional] <p>
 * limit が指定された場合、返される配列には
 * 最大 limit の要素が含まれます。この場合、
 * 最後の要素には string の残りの部分が全て
 * 入っています。
 * </p>
 * @return array 文字列の配列を返します。配列の各要素は、大文字小文字を区別する正規表現
 * pattern により区切られた
 * string 中の部分文字列です。
 * </p>
 * <p>
 * pattern が n 回
 * 現れる場合、返される配列には、
 * n+1 個のアイテムが
 * 含まれます。例えば、pattern が現れない場合、
 * 1 個の要素のみを有する配列が返されます。もちろん、これは
 * エラーを生じた場合、split は
 * FALSE を返します。
 */
function split ($pattern, $string, $limit = null) {}

/**
 * 大文字小文字を区別しない正規表現により文字列を分割し、配列に格納する
 * @link http://www.php.net/manual/ja/function.spliti.php
 * @param pattern string <p>
 * 大文字小文字を区別しない正規表現。
 * </p>
 * <p>
 * 正規表現で特殊文字とみなされる文字を分割したい場合、それらを
 * まずエスケープする必要があります。spliti
 * (または他の正規表現関数に関して)の動作が何か変であると感じたならば、
 * PHP 配布ファイルの
 * regex/ サブディレクトリにあるファイル
 * regex.7 を読んでください。このファイルは
 * man ページ形式となっており、読むには
 * man /usr/local/src/regex/regex.7 のようにします。
 * </p>
 * @param string string <p>
 * 入力文字列。
 * </p>
 * @param limit int[optional] <p>
 * limit が指定された場合、返される配列には
 * 最大 limit の要素が含まれます。この場合、
 * 最後の要素には string の残りの部分が全て
 * 入っています。
 * </p>
 * @return array 文字列の配列を返します。配列の各要素は、大文字小文字を区別する正規表現
 * pattern により区切られた
 * string 中の部分文字列です。
 * </p>
 * <p>
 * pattern が n 回
 * 現れる場合、返される配列には、
 * n+1 個のアイテムが
 * 含まれます。例えば、pattern が現れない場合、
 * 1 個の要素のみを有する配列が返されます。もちろん、これは
 * string が空の場合でも有効です。
 * エラーを生じた場合、spliti は
 * FALSE を返します。
 */
function spliti ($pattern, $string, $limit = null) {}

/**
 * 大文字小文字を区別しないマッチングのための正規表現を作成する
 * @link http://www.php.net/manual/ja/function.sql-regcase.php
 * @param string string <p>
 * 入力文字列。
 * </p>
 * @return string 大文字小文字を区別せず stringにマッチする、
 * 有効な正規表現式を返します。この表現式は、string
 * の中の個々のアルファベットを '[]' 表現に変換したものです。
 * この '[]' 表現は、大文字と小文字がそれぞれ含まれます。
 * アルファベット以外の文字の場合は、元々の文字がそのまま残ります。
 */
function sql_regcase ($string) {}

// End of ereg v.
?>
