<?php

// Start of hash v.1.0

/**
 * ハッシュ値 (メッセージダイジェスト) を生成する
 * @link http://www.php.net/manual/ja/function.hash.php
 * @param algo string <p>
 * 選択したアルゴリズムの名前 (すなわち "md5"、"sha256"、"haval160,4" など…)。
 * </p>
 * @param data string <p>
 * ハッシュするメッセージ。
 * </p>
 * @param raw_output bool[optional] <p>
 * TRUE を設定すると、生のバイナリデータを出力します。
 * FALSE の場合は小文字の 16 進数値となります。
 * </p>
 * @return string raw_output が true に設定されていない場合は、
 * メッセージダイジェストの計算結果を小文字の 16 進数値形式の文字列で
 * 返します。もし true に設定されていた場合は、メッセージダイジェストが
 * そのままのバイナリ形式で返されます。
 */
function hash ($algo, $data, $raw_output = null) {}

/**
 * ファイルの内容から、ハッシュ値を生成する
 * @link http://www.php.net/manual/ja/function.hash-file.php
 * @param algo string <p>
 * 選択したアルゴリズムの名前 (すなわち "md5"、"sha256"、"haval160,4" など…)。
 * </p>
 * @param filename string <p>
 * ハッシュ対象となるファイルの位置を示す URL。
 * fopen ラッパーをサポートしています。
 * </p>
 * @param raw_output bool[optional] <p>
 * TRUE を設定すると、生のバイナリデータを出力します。
 * FALSE の場合は小文字の 16 進数値となります。
 * </p>
 * @return string raw_output が true に設定されていない場合は、
 * メッセージダイジェストの計算結果を小文字の 16 進数値形式の文字列で
 * 返します。もし true に設定されていた場合は、メッセージダイジェストが
 * そのままのバイナリ形式で返されます。
 */
function hash_file ($algo, $filename, $raw_output = null) {}

/**
 * HMAC 方式を使用してハッシュ値を生成する
 * @link http://www.php.net/manual/ja/function.hash-hmac.php
 * @param algo string <p>
 * 選択したアルゴリズムの名前 (すなわち "md5"、"sha256"、"haval160,4" など…)。
 * サポートするアルゴリズムの一覧は hash_algos を参照ください。
 * </p>
 * @param data string <p>
 * ハッシュするメッセージ。
 * </p>
 * @param key string <p>
 * HMAC 方式でのメッセージダイジェストを生成するために使用する
 * 共有の秘密鍵。
 * </p>
 * @param raw_output bool[optional] <p>
 * TRUE を設定すると、生のバイナリデータを出力します。
 * FALSE の場合は小文字の 16 進数値となります。
 * </p>
 * @return string raw_output が true に設定されていない場合は、
 * メッセージダイジェストの計算結果を小文字の 16 進数値形式の文字列で
 * 返します。もし true に設定されていた場合は、メッセージダイジェストが
 * そのままのバイナリ形式で返されます。
 */
function hash_hmac ($algo, $data, $key, $raw_output = null) {}

/**
 * HMAC 方式を使用して、指定されたファイルの内容からハッシュ値を生成する
 * @link http://www.php.net/manual/ja/function.hash-hmac-file.php
 * @param algo string <p>
 * 選択したアルゴリズムの名前 (すなわち "md5"、"sha256"、"haval160,4" など…)。
 * サポートするアルゴリズムの一覧は hash_algos を参照ください。
 * </p>
 * @param filename string <p>
 * ハッシュ対象となるファイルの位置を示す URL。
 * fopen ラッパーをサポートしています。
 * </p>
 * @param key string <p>
 * HMAC 方式でのメッセージダイジェストを生成するために使用する
 * 共有の秘密鍵。
 * </p>
 * @param raw_output bool[optional] <p>
 * TRUE を設定すると、生のバイナリデータを出力します。
 * FALSE の場合は小文字の 16 進数値となります。
 * </p>
 * @return string raw_output が true に設定されていない場合は、
 * メッセージダイジェストの計算結果を小文字の 16 進数値形式の文字列で
 * 返します。もし true に設定されていた場合は、メッセージダイジェストが
 * そのままのバイナリ形式で返されます。
 */
function hash_hmac_file ($algo, $filename, $key, $raw_output = null) {}

/**
 * 段階的なハッシュコンテキストを初期化する
 * @link http://www.php.net/manual/ja/function.hash-init.php
 * @param algo string <p>
 * 選択したアルゴリズムの名前 (すなわち "md5"、"sha256"、"haval160,4" など…)。
 * </p>
 * @param options int[optional] <p>
 * ハッシュ生成の際に使用するオプションで、現在は、ただひとつ
 * HASH_HMAC のみをサポートしています。これが
 * 指定された場合、key を
 * 必ず指定しなければなりません。
 * </p>
 * @param key string[optional] <p>
 * options に HASH_HMAC
 * が指定された場合に、HMAC 形式のハッシュで使用される共有の秘密鍵を
 * 設定する必要があります。
 * </p>
 * @return resource hash_update、
 * hash_update_stream、hash_update_file
 * および hash_final で使用するハッシュコンテキストリソースを
 * 返します。
 */
function hash_init ($algo, $options = null, $key = null) {}

/**
 * アクティブなハッシュコンテキストにデータを投入する
 * @link http://www.php.net/manual/ja/function.hash-update.php
 * @param context resource <p>
 * hash_init が返すハッシュコンテキスト。
 * </p>
 * @param data string <p>
 * ハッシュダイジェストに含めるメッセージ。
 * </p>
 * @return bool TRUE を返します。
 */
function hash_update ($context, $data) {}

/**
 * アクティブなハッシュコンテキストに、オープンしているストリームから
   データを投入する
 * @link http://www.php.net/manual/ja/function.hash-update-stream.php
 * @param context resource <p>
 * hash_init が返すハッシュコンテキスト。
 * </p>
 * @param handle resource <p>
 * ストリーム作成用の関数が返す、オープンしているファイルハンドル。
 * </p>
 * @param length int[optional] <p>
 * handle からハッシュコンテキストにコピーする
 * 最大文字数。
 * </p>
 * @return int handle からハッシュコンテキストに追加された
 * 実際のバイト数を返します。
 */
function hash_update_stream ($context, $handle, $length = null) {}

/**
 * アクティブなハッシュコンテキストに、ファイルから
   データを投入する
 * @link http://www.php.net/manual/ja/function.hash-update-file.php
 * @param context resource <p>
 * stream_context_create が返す
 * ストリームコンテキスト。
 * </p>
 * @param filename string <p>
 * ハッシュ対象となるファイルの位置を示す URL。
 * fopen ラッパーをサポートしています。
 * </p>
 * @param context resource[optional] 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function hash_update_file ($context, $filename, $context = null) {}

/**
 * 段階的なハッシュ処理を終了し、出来上がったダイジェストを返す
 * @link http://www.php.net/manual/ja/function.hash-final.php
 * @param context resource <p>
 * hash_init が返すハッシュコンテキスト。
 * </p>
 * @param raw_output bool[optional] <p>
 * TRUE を設定すると、生のバイナリデータを出力します。
 * FALSE の場合は小文字の 16 進数値となります。
 * </p>
 * @return string raw_output が true に設定されていない場合は、
 * メッセージダイジェストの計算結果を小文字の 16 進数値形式の文字列で
 * 返します。もし true に設定されていた場合は、メッセージダイジェストが
 * そのままのバイナリ形式で返されます。
 */
function hash_final ($context, $raw_output = null) {}

/**
 * ハッシュコンテキストをコピーする
 * @link http://www.php.net/manual/ja/function.hash-copy.php
 * @param context resource <p>
 * hash_init が返すハッシュコンテキスト。
 * </p>
 * @return resource ハッシュコンテキストリソースのコピーを返します。
 */
function hash_copy ($context) {}

/**
 * 登録されているハッシュアルゴリズムの一覧を返す
 * @link http://www.php.net/manual/ja/function.hash-algos.php
 * @return array サポートされているハッシュアルゴリズムの一覧を、数値添字の
 * 配列として返します。
 */
function hash_algos () {}

/**
 * キーを生成する
 * @link http://www.php.net/manual/ja/function.mhash-keygen-s2k.php
 * @param hash int <p>
 * キーの作成に使用するハッシュ ID。MHASH_ハッシュ名
 * 定数のいずれかを指定します。
 * </p>
 * @param password string <p>
 * ユーザーが指定したパスワード。
 * </p>
 * @param salt string <p>
 * 異なったキーを生成するため、キーを生成するたびに、
 * 十分にランダムな異なる値となる必要があります。キーを調べる際に
 * salt を知っている必要があるため、キーを salt に付加するというのは
 * 良い発想です。salt は 8 バイト固定長で、これより少ない場合はゼロで
 * 埋められます。
 * </p>
 * @param bytes int <p>
 * キーの長さをバイト数で指定します。
 * </p>
 * @return string 生成されたキーを表す文字列、あるいはエラー時に FALSE を返します。
 */
function mhash_keygen_s2k ($hash, $password, $salt, $bytes) {}

/**
 * 指定したハッシュのブロックサイズを得る
 * @link http://www.php.net/manual/ja/function.mhash-get-block-size.php
 * @param hash int <p>
 * ハッシュ ID。MHASH_ハッシュ名
 * 定数のいずれかを指定します。
 * </p>
 * @return int サイズをバイト数で返します。hash
 * が存在しない場合は FALSE を返します。
 */
function mhash_get_block_size ($hash) {}

/**
 * 指定したハッシュの名前を得る
 * @link http://www.php.net/manual/ja/function.mhash-get-hash-name.php
 * @param hash int <p>
 * ハッシュ ID。MHASH_ハッシュ名
 * 定数のいずれかを指定します。
 * </p>
 * @return string ハッシュの名前を返します。そのハッシュが存在しない場合は、FALSE
 * を返します。
 */
function mhash_get_hash_name ($hash) {}

/**
 * 利用可能なハッシュ ID の最大値を得る
 * @link http://www.php.net/manual/ja/function.mhash-count.php
 * @return int 利用可能なハッシュ ID の最大値を返します。
 * ハッシュは、0 からこのハッシュ ID までの数字となります。
 */
function mhash_count () {}

/**
 * ハッシュ値を計算する
 * @link http://www.php.net/manual/ja/function.mhash.php
 * @param hash int <p>
 * ハッシュ ID。MHASH_ハッシュ名
 * 定数のいずれかを指定します。
 * </p>
 * @param data string <p>
 * ユーザーが入力した文字列。
 * </p>
 * @param key string[optional] <p>
 * 指定した場合は、この関数は結果の HMAC を返します。
 * HMAC は、メッセージ認証時のキーに基づくハッシュ、
 * あるいは指定したキーに基づく単なるメッセージダイジェストです。
 * mhash でサポートしている全てのアルゴリズムが HMAC
 * モードで使用できるわけではありません。
 * </p>
 * @return string 結果のハッシュ (あるいはダイジェストとも言います)
 * あるいは HMAC を表す文字列を返します。
 * エラー時は FALSE を返します。
 */
function mhash ($hash, $data, $key = null) {}


/**
 * hash_init のオプションのフラグです。
 * 現在のハッシュコンテキストに対して HMAC digest-keying
 * アルゴリズムが適用されることを示します。
 * @link http://www.php.net/manual/ja/hash.constants.php
 */
define ('HASH_HMAC', 1);
define ('MHASH_CRC32', 0);
define ('MHASH_MD5', 1);
define ('MHASH_SHA1', 2);
define ('MHASH_HAVAL256', 3);
define ('MHASH_RIPEMD160', 5);
define ('MHASH_TIGER', 7);
define ('MHASH_GOST', 8);
define ('MHASH_CRC32B', 9);
define ('MHASH_HAVAL224', 10);
define ('MHASH_HAVAL192', 11);
define ('MHASH_HAVAL160', 12);
define ('MHASH_HAVAL128', 13);
define ('MHASH_TIGER128', 14);
define ('MHASH_TIGER160', 15);
define ('MHASH_MD4', 16);
define ('MHASH_SHA256', 17);
define ('MHASH_ADLER32', 18);
define ('MHASH_SHA224', 19);
define ('MHASH_SHA512', 20);
define ('MHASH_SHA384', 21);
define ('MHASH_WHIRLPOOL', 22);
define ('MHASH_RIPEMD128', 23);
define ('MHASH_RIPEMD256', 24);
define ('MHASH_RIPEMD320', 25);
define ('MHASH_SNEFRU256', 27);
define ('MHASH_MD2', 28);

// End of hash v.1.0
?>
