<?php

// Start of libxml v.

class LibXMLError  {
}

/**
 * 次のlibxmlドキュメントの読込／書きこみのためにストリームコンテキストを設定する
 * @link http://www.php.net/manual/ja/function.libxml-set-streams-context.php
 * @param streams_context resource <p>
 * ストリームコンテキストリソース(
 * stream_context_createで作成)
 * </p>
 * @return void 値を返しません。
 */
function libxml_set_streams_context ($streams_context) {}

/**
 * libxmlエラーを無効にし、ユーザーが必要に応じてエラー情報を取得できるようにする
 * @link http://www.php.net/manual/ja/function.libxml-use-internal-errors.php
 * @param use_errors bool[optional] <p>
 * ユーザーによるエラー処理を有効 (TRUE) または無効 (FALSE) にする。
 * 無効にすると、既に存在する libxml のエラーもすべてクリアします。
 * </p>
 * @return bool この関数は、
 * use_errorsの前の値を返します。
 */
function libxml_use_internal_errors ($use_errors = null) {}

/**
 * libxmlから直近のエラーを取得する
 * @link http://www.php.net/manual/ja/function.libxml-get-last-error.php
 * @return LibXMLError エラーがバッファにある場合にLibXMLErrorオブジェクト、
 * それ以外の場合に FALSE を返します。
 */
function libxml_get_last_error () {}

/**
 * libxmlエラーハンドラをクリアする
 * @link http://www.php.net/manual/ja/function.libxml-clear-errors.php
 * @return void 値を返しません。
 */
function libxml_clear_errors () {}

/**
 * エラー配列を取得する
 * @link http://www.php.net/manual/ja/function.libxml-get-errors.php
 * @return array エラーがバッファにある場合に LibXMLError オブジェクトの配列、
 * それ以外の場合に空の配列を返します。
 */
function libxml_get_errors () {}

/**
 * 外部エンティティの読み込み機能を無効にする
 * @link http://www.php.net/manual/ja/function.libxml-disable-entity-loader.php
 * @param disable bool[optional] <p>
 * libxml を使用する拡張モジュール
 * (、
 * および ) で、外部エンティティの読み込み機能を
 * 無効 (TRUE) あるいは有効 (FALSE) にします。
 * </p>
 * @return bool 変更前の値を返します。
 */
function libxml_disable_entity_loader ($disable = null) {}


/**
 * 20605 や 20617 のような libxml のバージョン
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_VERSION', 20708);

/**
 * 2.6.5または2.6.17のようなlibxmlのバージョン
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_DOTTED_VERSION', "2.7.8");
define ('LIBXML_LOADED_VERSION', 20708);

/**
 * エンティティを置換
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_NOENT', 2);

/**
 * 外部サブセットをロードする
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_DTDLOAD', 4);

/**
 * デフォルトのDTD属性
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_DTDATTR', 8);

/**
 * DTDで検証する
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_DTDVALID', 16);

/**
 * エラー出力を抑制
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_NOERROR', 32);

/**
 * 警告出力を抑制する
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_NOWARNING', 64);

/**
 * 空白のノードを削除
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_NOBLANKS', 256);

/**
 * XInclude 置換を実装する
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_XINCLUDE', 1024);

/**
 * 冗長な名前空間宣言を削除する
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_NSCLEAN', 8192);

/**
 * CDATA をテキストノードとしてマージ
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_NOCDATA', 16384);

/**
 * ドキュメントロード時にネットワークアクセスを無効にする
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_NONET', 2048);

/**
 * 小さなノードを割り当てるように最適化する。アプリケーションの
 * コードを変更することなしにスピードアップさせることができる
 * <p>
 * Libxml &gt;= 2.6.21 でのみ有効
 * </p>
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_COMPACT', 65536);

/**
 * ドキュメントの保存時に XML 宣言を削除する
 * <p>
 * Libxml &gt;= 2.6.21 でのみ有効
 * </p>
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_NOXMLDECL', 2);

/**
 * パーサでハードコーディングされたすべての制限を緩和するための
 * XML_PARSE_HUGE フラグを設定する。
 * これは、ドキュメントやエンティティの再帰の最大数や
 * テキストノードのサイズなどの制限に影響する。
 * <p>
 * Libxml &gt;= 2.7.0 (PHP &gt;= 5.3.2 あるいは PHP &gt;= 5.2.12) でのみ有効
 * </p>
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_PARSEHUGE', 524288);

/**
 * 空タグを拡張する（例 &lt;br/&gt; を
 * &lt;br&gt;&lt;/br&gt; にする）
 * <p>
 * このオプションは、現在
 * および
 * 関数でのみ有効です。
 * </p>
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_NOEMPTYTAG', 4);

/**
 * エラーなし
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_ERR_NONE', 0);

/**
 * 単純な警告
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_ERR_WARNING', 1);

/**
 * 復帰可能なエラー
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_ERR_ERROR', 2);

/**
 * 致命的なエラー
 * @link http://www.php.net/manual/ja/libxml.constants.php
 */
define ('LIBXML_ERR_FATAL', 3);

// End of libxml v.
?>
