<?php

// Start of xmlrpc v.0.51

/**
 * PHP の値に関する XML を生成する
 * @link http://www.php.net/manual/ja/function.xmlrpc-encode.php
 * @param value mixed 
 * @return string 
 */
function xmlrpc_encode ($value) {}

/**
 * XML をネイティブな PHP 型にデコードする
 * @link http://www.php.net/manual/ja/function.xmlrpc-decode.php
 * @param xml string <p>
 * XMLRPC メソッドが返す XML レスポンス。
 * </p>
 * @param encoding string[optional] <p>
 * iconv がサポートする入力エンコーディング。
 * </p>
 * @return mixed XMLRPC メソッドのレスポンスをもとに作成した、
 * 配列あるいは整数、文字列、boolean 値を返します。
 */
function xmlrpc_decode ($xml, $encoding = null) {}

/**
 * XML をネイティブなPHP 型にデコードする
 * @link http://www.php.net/manual/ja/function.xmlrpc-decode-request.php
 * @param xml string 
 * @param method string 
 * @param encoding string[optional] 
 * @return mixed 
 */
function xmlrpc_decode_request ($xml, &$method, $encoding = null) {}

/**
 * メソッドリクエスト用の XML を生成する
 * @link http://www.php.net/manual/ja/function.xmlrpc-encode-request.php
 * @param method string <p>
 * コールするメソッドの名前。
 * </p>
 * @param params mixed <p>
 * メソッドのシグネチャに対応したパラメータ。
 * </p>
 * @param output_options array[optional] <p>
 * 出力オプションを指定する配列。以下の内容が指定できます
 * (強調してあるものがデフォルトです)。
 * <p>output_type: php, xml</p>
 * @return string リクエストを表す XML 文字列を返します。
 */
function xmlrpc_encode_request ($method, $params, array $output_options = null) {}

/**
 * PHP の値に関する xmlrpc 型を取得する
 * @link http://www.php.net/manual/ja/function.xmlrpc-get-type.php
 * @param value mixed <p>
 * PHP の値。
 * </p>
 * @return string XML-RPC の型を返します。
 */
function xmlrpc_get_type ($value) {}

/**
 * PHP 文字列型用に xmlrpc 型、base64 または datetime を設定する
 * @link http://www.php.net/manual/ja/function.xmlrpc-set-type.php
 * @param value string <p>
 * 型を設定する値。
 * </p>
 * @param type string <p>
 * 'base64' あるいは 'datetime'。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * 成功した場合、value はオブジェクト型に変換されます。
 */
function xmlrpc_set_type (&$value, $type) {}

/**
 * 配列の値が XMLRPC の失敗であるかどうかを調べる
 * @link http://www.php.net/manual/ja/function.xmlrpc-is-fault.php
 * @param arg array <p>
 * xmlrpc_decode が返す配列。
 * </p>
 * @return bool 引数が失敗を表す場合に TRUE、それ以外の場合に FALSE を返します。
 * 失敗の内容は $arg["faultString"]、失敗のコードは
 * $arg["faultCode"] に格納されます。
 */
function xmlrpc_is_fault (array $arg) {}

/**
 * xmlrpc サーバーを作成する
 * @link http://www.php.net/manual/ja/function.xmlrpc-server-create.php
 * @return resource 
 */
function xmlrpc_server_create () {}

/**
 * サーバーリソースを破棄する
 * @link http://www.php.net/manual/ja/function.xmlrpc-server-destroy.php
 * @param server resource 
 * @return int 
 */
function xmlrpc_server_destroy ($server) {}

/**
 * メソッド名が一致するメソッドリソースに PHP 関数を登録する
 * @link http://www.php.net/manual/ja/function.xmlrpc-server-register-method.php
 * @param server resource 
 * @param method_name string 
 * @param function string 
 * @return bool 
 */
function xmlrpc_server_register_method ($server, $method_name, $function) {}

/**
 * XML リクエストをパースし、メソッドをコールする
 * @link http://www.php.net/manual/ja/function.xmlrpc-server-call-method.php
 * @param server resource 
 * @param xml string 
 * @param user_data mixed 
 * @param output_options array[optional] 
 * @return string 
 */
function xmlrpc_server_call_method ($server, $xml, $user_data, array $output_options = null) {}

/**
 * XML を、メソッド説明のリストにデコードする
 * @link http://www.php.net/manual/ja/function.xmlrpc-parse-method-descriptions.php
 * @param xml string 
 * @return array 
 */
function xmlrpc_parse_method_descriptions ($xml) {}

/**
 * introspection ドキュメントを追加する
 * @link http://www.php.net/manual/ja/function.xmlrpc-server-add-introspection-data.php
 * @param server resource 
 * @param desc array 
 * @return int 
 */
function xmlrpc_server_add_introspection_data ($server, array $desc) {}

/**
 * ドキュメントを生成する PHP 関数を登録する
 * @link http://www.php.net/manual/ja/function.xmlrpc-server-register-introspection-callback.php
 * @param server resource 
 * @param function string 
 * @return bool 
 */
function xmlrpc_server_register_introspection_callback ($server, $function) {}

// End of xmlrpc v.0.51
?>
