<?php

/**
 * 実行時に PHP 拡張モジュールをロードする
 * @link http://www.php.net/manual/ja/function.dl.php
 * @param library string <p>
 * このパラメータに指定できるのは拡張モジュールの
 * ファイル名だけであり、それはプラットフォームに依存します。
 * 例えば、Unix プラットフォームでは
 * sockets 拡張モジュール
 * (共有モジュールとしてコンパイルされていれば。デフォルトでは有りません!)
 * は sockets.so と呼ばれていますし、一方 Windows
 * プラットフォームでは php_sockets.dll と呼ばれます。
 * </p>
 * <p>
 * 拡張モジュールを読み込むディレクトリは、プラットフォームによって異なります。
 * </p>
 * <p>
 * Windows - php.ini に明記されていない場合、デフォルトでは
 * 拡張モジュールは c:\php4\extensions\ (PHP 4)
 * あるいは C:\php5\ (PHP 5) からロードされます。
 * </p>
 * <p>
 * Unix - php.ini に明記されていない場合、デフォルトでは
 * 以下に依存します。
 * PHP をビルドする際に --enable-debug を指定しているか否か
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。 
 * 拡張モジュールのロード機能が無効だったり、あるいは
 * 無効化されている(enable_dl でオフにされているか
 * または php.ini で セーフモード が有効になっている)場合は、
 * E_ERROR を発行して実行は停止されます。
 * 指定されたライブラリをロードできず dl が
 * 失敗した場合、FALSE に加えて E_WARNING メッセージが
 * 発行されます。
 */
function dl ($library) {}


/**
 * ファイルのフルパスとファイル名。インクルードされるファイルの
 * 中で使用された場合、インクルードされるファイルの名前が返されます。
 * PHP 4.0.2 以降では __FILE__
 * は常に絶対パスで、シンボリックリンクは解決されます。
 * それより前のバージョンでは、場合によっては相対パスが返されることもあります。
 * @link http://www.php.net/manual/ja/language.constants.php
 */
define ('__FILE__', null);

/**
 * ファイル上の現在の行番号。
 * @link http://www.php.net/manual/ja/language.constants.php
 */
define ('__LINE__', null);

/**
 * クラス名（PHP4.3.0で追加されました）。
 * PHP 5以降、この定数は宣言時のクラス名(ケース依存)を返します。
 * PHP 4では、この値は常に小文字で返されました。
 * クラス名には、そのクラスが宣言されている名前空間も含みます
 * (例 Foo\Bar)。
 * PHP 5.4 以降では、__CLASS__ がトレイトでも使えることに注意しましょう。トレイトのメソッド内で
 * __CLASS__ を使うと、そのトレイトを use しているクラスの名前を返します。
 * @link http://www.php.net/manual/ja/language.constants.php
 */
define ('__CLASS__', null);

/**
 * 関数名（PHP4.3.0で追加されました）。
 * PHP 5以降、この定数は宣言時の関数名(ケース依存)を返します。
 * PHP 4では、この値は常に小文字で返されました。
 * @link http://www.php.net/manual/ja/language.constants.php
 */
define ('__FUNCTION__', null);

/**
 * クラスのメソッド名（PHP5.0.0で追加されました）。
 * メソッド名は宣言時と同じ(ケース依存)を返します。
 * @link http://www.php.net/manual/ja/language.constants.php
 */
define ('__METHOD__', null);

/**
 * そのファイルの存在するディレクトリ。include の中で使用すると、
 * インクルードされるファイルの存在するディレクトリを返します。
 * つまり、これは dirname(__FILE__) と同じ意味です。
 * ルートディレクトリである場合を除き、ディレクトリ名の末尾にスラッシュはつきません
 * (PHP 5.3.0 で追加されました)。
 * @link http://www.php.net/manual/ja/language.constants.php
 */
define ('__DIR__', null);

/**
 * 現在の名前空間の名前 (大文字小文字を区別します)。
 * この定数はコンパイル時に定義されます (PHP 5.3.0 で追加されました)。
 * @link http://www.php.net/manual/ja/language.constants.php
 */
define ('__NAMESPACE__', null);
?>
