<?php

// Start of curl v.

/**
 * cURL セッションを初期化する
 * @link http://www.php.net/manual/ja/function.curl-init.php
 * @param url string[optional] <p>
 * urlを指定した場合、オプション
 * CURLOPT_URL がそのパラメータの値に設定されます。関数
 * curl_setopt により、
 * この値をマニュアルで設定することも可能です。
 * </p>
 * <p>
 * open_basedir
 * が設定されている場合、cURL で
 * file プロトコルは使えなくなります。
 * </p>
 * @return resource 成功した場合に cURL ハンドル、エラー時に FALSE を返します。
 */
function curl_init ($url = null) {}

/**
 * cURL ハンドルを、その設定も含めてコピーする
 * @link http://www.php.net/manual/ja/function.curl-copy-handle.php
 * @param ch resource <p>curl_init
 * が返す cURL ハンドル。</p>
 * @return resource 新しい cURL ハンドルを返します。
 */
function curl_copy_handle ($ch) {}

/**
 * cURL のバージョンを返す
 * @link http://www.php.net/manual/ja/function.curl-version.php
 * @param age int[optional] <p>
 * </p>
 * @return array 以下の要素からなる連想配列を返します。
 * <tr valign="top">
 * <td>インデックス</td>
 * <td>値の説明</td>
 * </tr>
 * <tr valign="top">
 * <td>version_number</td>
 * <td>cURL の 24 ビットのバージョン番号</td>
 * </tr>
 * <tr valign="top">
 * <td>version</td>
 * <td>cURL バージョン番号を表す文字列</td>
 * </tr>
 * <tr valign="top">
 * <td>ssl_version_number</td>
 * <td>OpenSSL の 24 ビットのバージョン番号</td>
 * </tr>
 * <tr valign="top">
 * <td>ssl_version</td>
 * <td>OpenSSL バージョン番号を表す文字列</td>
 * </tr>
 * <tr valign="top">
 * <td>libz_version</td>
 * <td>zlib バージョンを表す文字列</td>
 * </tr>
 * <tr valign="top">
 * <td>host</td>
 * <td>cURL をビルドしたホストについての情報</td>
 * </tr>
 * <tr valign="top">
 * <td>age</td>
 * <td></td>
 * </tr>
 * <tr valign="top">
 * <td>features</td>
 * <td>定数 CURL_VERSION_XXX のビットマスク</td>
 * </tr>
 * <tr valign="top">
 * <td>protocols</td>
 * <td>cURL がサポートするプロトコル名の配列</td>
 * </tr>
 */
function curl_version ($age = null) {}

/**
 * cURL 転送用オプションを設定する
 * @link http://www.php.net/manual/ja/function.curl-setopt.php
 * @param ch resource <p>curl_init
 * が返す cURL ハンドル。</p>
 * @param option int <p>
 * 設定したい CURLOPT_XXX オプション。
 * </p>
 * @param value mixed <p>
 * option に設定する値。
 * </p>
 * <p>
 * value には、
 * option の以下の値に関して
 * bool 値を指定する必要があります。
 * <tr valign="top">
 * オプション</td>
 * value への設定値</td>
 * 注記</td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_AUTOREFERER</td>
 * TRUE を設定すると、Location: によるリダイレクトを
 * たどる際には自動的に Referer: フィールドをリクエストに
 * 追加します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_BINARYTRANSFER</td>
 * TRUE を設定すると、CURLOPT_RETURNTRANSFER
 * が使用された場合に出力結果を何も加工せずに返します。
 * </td>
 * PHP 5.1.3 以降では、このオプションは何の効果もありません。
 * CURLOPT_RETURNTRANSFER を使ったときには
 * 常に出力をそのまま返すようになりました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_COOKIESESSION</td>
 * TRUE を設定すると、クッキーの "セッション" を新しく開始します。
 * 以前のセッションで読み込まれていた "セッションクッキー" は無視するよう、
 * libcurl に指示します。デフォルトでは、それがセッションクッキーであるか
 * どうかにかかわらず libcurl はすべてのクッキーを読み込んで保存します。
 * セッションクッキーとは、有効期限が指定されておらず "セッション" の間のみ
 * 有効であるクッキーのことです。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_CERTINFO</td>
 * TRUE を設定すると、セキュアな転送時に SSL 証明書の情報を
 * STDERR に出力します。
 * </td>
 * cURL 7.19.1 で追加されました。
 * PHP 5.3.2 以降で使用可能です。これを使うには、CURLOPT_VERBOSE
 * を on にしておかなければなりません。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_CRLF</td>
 * TRUE を設定すると、転送時に Unix 形式の改行を CRLF 形式に変換します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_DNS_USE_GLOBAL_CACHE</td>
 * TRUE を設定すると、グローバル DNS キャッシュを利用します。
 * このオプションはスレッドセーフではありません。また、デフォルトで
 * 有効になっています。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_FAILONERROR</td>
 * TRUE を設定すると、HTTP で 400 以上のコードが返ってきた際に
 * 処理失敗と判断し、何もしません。デフォルトでは、コードの値を無視して
 * ページの内容を取得します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_FILETIME</td>
 * TRUE を設定すると、ドキュメントの更新日時を取得しようと試みます。
 * この値を取得するには、curl_getinfo で
 * CURLINFO_FILETIME オプションを用います。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_FOLLOWLOCATION</td>
 * TRUE を設定すると、サーバーが HTTP ヘッダの一部として送ってくる
 * "Location: " ヘッダの内容をたどります
 * （これは再帰的に行われます。CURLOPT_MAXREDIRS
 * が指定されていない限り、送ってくる "Location: "
 * ヘッダの内容をずっとたどり続けることに注意しましょう）。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_FORBID_REUSE</td>
 * TRUE を設定すると、処理が終了した際に明示的に接続を切断します。
 * 接続を再利用しません。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_FRESH_CONNECT</td>
 * TRUE を設定すると、キャッシュされている接続を利用せずに
 * 新しい接続を確立します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_FTP_USE_EPRT</td>
 * TRUE を設定すると、FTP のダウンロードに EPRT（および LPRT）
 * を利用します。FALSE の場合は EPRT・LPRT を無効にして PORT
 * を利用します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_FTP_USE_EPSV</td>
 * TRUE を設定すると、FTP 転送の際にまず EPSV コマンドの利用を
 * 試みます。失敗した場合は PASV を利用します。FALSE を設定すると、
 * EPSV を無効にします。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_FTP_CREATE_MISSING_DIRS</td>
 * TRUE を設定すると、FTP の操作中にパスが存在しなかったときに
 * ディレクトリを作成します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_FTPAPPEND</td>
 * TRUE を設定すると、リモートファイルを上書きせずに追記します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_FTPASCII</td>
 * CURLOPT_TRANSFERTEXT のエイリアスです。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_FTPLISTONLY</td>
 * TRUE を設定すると、FTP でディレクトリ名のみ表示します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_HEADER</td>
 * TRUE を設定すると、ヘッダの内容も出力します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLINFO_HEADER_OUT</td>
 * TRUE を設定すると、リクエスト文字列を追跡します。
 * </td>
 * PHP 5.1.3 以降で使用可能です。プレフィックスが CURLINFO_
 * となっているのは意図的なものです。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_HTTPGET</td>
 * TRUE を設定すると、HTTP のリクエスト形式を GET に戻します。
 * GET はデフォルト設定なので、リクエスト形式が変更されている
 * 場合にのみ必要となります。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_HTTPPROXYTUNNEL</td>
 * TRUE にすると、指定された HTTP プロキシを介してトンネルします。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_MUTE</td>
 * TRUE を設定すると、cURL 関数に関連する出力を完全に抑えます。
 * </td>
 * cURL 7.15.5 で削除されました (かわりに CURLOPT_RETURNTRANSFER が使えます)
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_NETRC</td>
 * TRUE を設定すると、リモートサイトと接続を確立する際に用いる
 * ユーザー名やパスワードを、~/.netrc から取得します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_NOBODY</td>
 * TRUE を設定すると、出力から本文を削除します。
 * リクエストメソッドは HEAD となります。これを FALSE
 * に変更してもリクエストメソッドは GET には変わりません。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_NOPROGRESS</td>
 * TRUE を設定すると、cURL 転送の進捗状況表示を無効にします。
 * <p>
 * PHP は、このオプションを自動的に TRUE に設定します。
 * これを変更するのは、デバッグ時のみにすべきです。
 * </p>
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_NOSIGNAL</td>
 * TRUE を設定すると、cURL 関数が PHP プロセスに送信するシグナルを
 * 無視します。マルチスレッド SAPI ではデフォルトで on となっており、
 * そのためタイムアウトオプションもまだ利用されています。
 * </td>
 * cURL 7.10 で追加されました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_POST</td>
 * TRUE を設定すると、HTTP POST を行います。POST は、
 * application/x-www-form-urlencoded 形式で
 * 行われます。これは一般的な HTML のフォームと同じ形式です。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_PUT</td>
 * TRUE を設定すると、HTTP PUT を行います。PUT するファイルは
 * CURLOPT_INFILE および
 * CURLOPT_INFILESIZE
 * で指定されている必要があります。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_RETURNTRANSFER</td>
 * TRUE を設定すると、curl_exec の返り値を
 * 文字列で返します。通常はデータを直接出力します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSL_VERIFYPEER</td>
 * FALSE を設定すると、cURL はサーバー証明書の検証を行いません。
 * 別の証明書を CURLOPT_CAINFO オプションで
 * 指定するか、CURLOPT_CAPATH オプションで
 * 証明ディレクトリを指定します。
 * </td>
 * cURL 7.10 以降、デフォルト値は TRUE です。また、
 * cURL 7.10 以降、デフォルトでインストールされています。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_TRANSFERTEXT</td>
 * TRUE を設定すると、FTP 転送を ASCII モードで行います。
 * LDAP の場合は、データを HTML ではなくプレーンテキストで取得します。
 * Windows システムでは STDOUT
 * に対してバイナリモードを設定しないでください。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_UNRESTRICTED_AUTH</td>
 * TRUE を設定すると、（CURLOPT_FOLLOWLOCATION
 * を利用して）場所をたどっていく際にユーザー名とパスワードを送信し続けます。
 * これは、たとえホスト名が変わっても続けられます。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_UPLOAD</td>
 * TRUE を設定すると、アップロードの準備をします。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_VERBOSE</td>
 * TRUE を設定すると、詳細な情報を出力します。情報は
 * STDERR か、または
 * CURLOPT_STDERR
 * で指定したファイルに出力されます。
 * </td>
 * </td>
 * </tr>
 * </p>
 * <p>
 * value には、
 * option の以下の値に関して
 * 整数値を指定する必要があります。
 * <tr valign="top">
 * <td>オプション</td>
 * <td>value への設定値</td>
 * <td>注記</td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_BUFFERSIZE</td>
 * 1 回の読み込みに用いるバッファのサイズ。しかしながら、必ず
 * このバッファいっぱいまで読み込まれることを保証するものではありません。
 * </td>
 * cURL 7.10 で追加されました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_CLOSEPOLICY</td>
 * CURLCLOSEPOLICY_LEAST_RECENTLY_USED あるいは
 * CURLCLOSEPOLICY_OLDEST です。
 * 他にも 3 つの CURLCLOSEPOLICY_ 定数が存在しますが、
 * cURL はそれらをまだサポートしていません。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_CONNECTTIMEOUT</td>
 * 接続の試行を待ち続ける秒数。0 は永遠に待ち続けることを意味します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_CONNECTTIMEOUT_MS</td>
 * 接続の試行を待ち続けるミリ秒数。0 は永遠に待ち続けることを意味します。
 * システムの標準の名前解決を使うように libcurl をビルドしている場合は、
 * 接続のタイムアウトは秒単位の精度となり、最小のタイムアウトは 1 秒となります。
 * </td>
 * cURL 7.16.2 で追加されました。PHP 5.2.3 以降で使用可能です。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_DNS_CACHE_TIMEOUT</td>
 * DNS エントリをメモリ内に保持し続ける秒数。デフォルトでは
 * 120（2 分）に設定されています。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_FTPSSLAUTH</td>
 * （使用可能な場合の）FTP 認証方法。
 * CURLFTPAUTH_SSL（まず SSL を試す）、
 * CURLFTPAUTH_TLS（まず TLS を試す）あるいは
 * CURLFTPAUTH_DEFAULT（cURL が決める）のいずれかです。
 * </td>
 * cURL 7.12.2 で追加されました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_HTTP_VERSION</td>
 * CURL_HTTP_VERSION_NONE (デフォルト。
 * 使用するバージョンを決めるのは cURL にまかせる)、
 * CURL_HTTP_VERSION_1_0 (HTTP/1.0 を使用する)、
 * あるいは CURL_HTTP_VERSION_1_1 (HTTP/1.1 を使用する)
 * のいずれかです。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_HTTPAUTH</td>
 * <p>
 * 使用する HTTP 認証方法。以下の中から選びます。
 * CURLAUTH_BASIC、
 * CURLAUTH_DIGEST、
 * CURLAUTH_GSSNEGOTIATE、
 * CURLAUTH_NTLM、
 * CURLAUTH_ANY および
 * CURLAUTH_ANYSAFE。
 * </p>
 * <p>
 * 2 つ以上の方法を組み合わせるには、ビット演算子 |（or）
 * を使用します。このような場合、cURL はサーバーがサポートしている方法を
 * 問い合わせたうえで最適な方法を選択します。
 * </p>
 * <p>
 * CURLAUTH_ANY は
 * CURLAUTH_BASIC | CURLAUTH_DIGEST | CURLAUTH_GSSNEGOTIATE | CURLAUTH_NTLM
 * のエイリアスです。
 * </p>
 * <p>
 * CURLAUTH_ANYSAFE は
 * CURLAUTH_DIGEST | CURLAUTH_GSSNEGOTIATE | CURLAUTH_NTLM
 * のエイリアスです。
 * </p>
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_INFILESIZE</td>
 * ファイルをリモートサイトにアップロードする際のファイルサイズ。
 * このオプションを指定しても、libcurl がそれ以上のデータを送信するのは止められないことに注意しましょう。
 * 実際に何が送信されるのかは
 * CURLOPT_READFUNCTION に依存します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_LOW_SPEED_LIMIT</td>
 * 1 秒あたりのバイト数で、転送速度がこれより遅い期間が
 * CURLOPT_LOW_SPEED_TIME 秒以上続いた場合に
 * PHP は転送を終了します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_LOW_SPEED_TIME</td>
 * 転送速度が CURLOPT_LOW_SPEED_LIMIT
 * より遅い期間がどれだけ続いた場合に転送を異常終了させるかを、
 * 秒単位で指定します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_MAXCONNECTS</td>
 * 許可される持続的接続の最大数。もしこの値に達した場合、
 * どの接続を閉じるのかを CURLOPT_CLOSEPOLICY
 * によって決定します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_MAXREDIRS</td>
 * HTTP のリダイレクト先を追いかける最大値。
 * CURLOPT_FOLLOWLOCATION とあわせて使用します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_PORT</td>
 * 接続先のポート番号。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_PROTOCOLS</td>
 * <p>
 * CURLPROTO_* の値のビットマスク。使用すると、
 * 転送時に libcurl がどのプロトコルを使用するのかに制約を加えます。
 * さまざまなプロトコルに対応するよう libcurl をビルドしていた場合でも、
 * これによって特定の転送プロトコルのみを使用するように制限することができます。
 * デフォルトでは、libcurl がサポートしているすべてのプロトコルの使用を許可します。
 * CURLOPT_REDIR_PROTOCOLS も参照ください。
 * </p>
 * <p>
 * 使用できるプロトコルオプションは次のとおりです。
 * CURLPROTO_HTTP,
 * CURLPROTO_HTTPS,
 * CURLPROTO_FTP,
 * CURLPROTO_FTPS,
 * CURLPROTO_SCP,
 * CURLPROTO_SFTP,
 * CURLPROTO_TELNET,
 * CURLPROTO_LDAP,
 * CURLPROTO_LDAPS,
 * CURLPROTO_DICT,
 * CURLPROTO_FILE,
 * CURLPROTO_TFTP,
 * CURLPROTO_ALL
 * </p>
 * </td>
 * cURL 7.19.4 で追加されました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_PROXYAUTH</td>
 * プロキシ接続に使用する HTTP 認証の方法。
 * CURLOPT_HTTPAUTH で説明したのと同じオプションを
 * 指定可能です。プロキシ認証でサポートされているのは、今のところ
 * CURLAUTH_BASIC および
 * CURLAUTH_NTLM のみです。
 * </td>
 * cURL 7.10.7 で追加されました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_PROXYPORT</td>
 * プロキシ接続のポート番号。このポート番号は、
 * CURLOPT_PROXY で指定することも可能です。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_PROXYTYPE</td>
 * CURLPROXY_HTTP（デフォルト）あるいは
 * CURLPROXY_SOCKS5。
 * </td>
 * cURL 7.10 で追加されました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_REDIR_PROTOCOLS</td>
 * CURLPROTO_* の値のビットマスク。使用すると、
 * CURLOPT_FOLLOWLOCATION が有効な場合のリダイレクト時の転送に
 * libcurl がどのプロトコルを使用するのかに制約を加えます。これによって、
 * リダイレクト時に特定の転送プロトコルのみを使用するように制限することができます。
 * デフォルトでは、libcurl がサポートしているすべてのプロトコルのうち
 * FILE と SCP 以外のすべての使用を許可します。この挙動は 7.19.4
 * より前のバージョンとは異なります。7.19.4 より前のバージョンでは、
 * サポートするすべてのプロトコルを無条件に許可していました。
 * プロトコル定数の値は CURLOPT_PROTOCOLS を参照ください。
 * </td>
 * cURL 7.19.4 で追加されました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_RESUME_FROM</td>
 * 転送を途中から再開する場合のバイトオフセット。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSL_VERIFYHOST</td>
 * 1 は SSL ピア証明書に一般名が存在するかどうかを調べます。
 * 2 はそれに加え、その名前がホスト名と一致することを検証します。
 * 本番環境では、このオプションの値は常に
 * 2 (デフォルト値) にしておかなければなりません。
 * </td>
 * 値 1 は、cURL 7.28.1 以降では使えなくなりました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSLVERSION</td>
 * 使用する SSL のバージョン（2 あるいは 3）。デフォルトでは
 * PHP が自動的に判断しますが、これを手動で設定する必要がある場合もあります。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_TIMECONDITION</td>
 * CURLOPT_TIMEVALUE の扱いを決定します。
 * CURLOPT_TIMEVALUE で指定した時刻以降に
 * 変更されたページのみを返す場合は
 * CURL_TIMECOND_IFMODSINCE を使用します。
 * CURLOPT_HEADER が TRUE だと仮定すると、
 * ページが変更されていない場合は
 * "304 Not Modified" ヘッダが返されます。
 * CURL_TIMECOND_IFUNMODSINCE は反対の意味です。
 * デフォルトは CURL_TIMECOND_IFMODSINCE
 * です。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_TIMEOUT</td>
 * cURL 関数の実行にかけられる時間の最大値。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_TIMEOUT_MS</td>
 * cURL 関数の実行にかけられる最大のミリ秒数。
 * システムの標準の名前解決を使うように libcurl をビルドしている場合は、
 * 接続のタイムアウトは秒単位の精度となり、最小のタイムアウトは 1 秒となります。
 * </td>
 * cURL 7.16.2 で追加されました。PHP 5.2.3 以降で使用可能です。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_TIMEVALUE</td>
 * 1970 年 1 月 1 日からの経過秒数。この値は
 * CURLOPT_TIMECONDITION で使用されます。デフォルトでは
 * CURL_TIMECOND_IFMODSINCE が設定されます。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_MAX_RECV_SPEED_LARGE</td>
 * ダウンロード速度 (単位は「バイト/秒」) の転送中累加平均がこの値を超えると、
 * 転送を一時停止して、平均速度がこのパラメータの値以下に落ちるまで待ちます。
 * デフォルトは無制限です。
 * </td>
 * cURL 7.15.5 で追加されました。PHP 5.4.0 以降で使用可能です。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_MAX_SEND_SPEED_LARGE</td>
 * アップロード速度 (単位は「バイト/秒」) の転送中累加平均がこの値を超えると、
 * 転送を一時停止して、平均速度がこのパラメータの値以下に落ちるまで待ちます。
 * デフォルトは無制限です。
 * </td>
 * cURL 7.15.5 で追加されました。PHP 5.4.0 以降で使用可能です。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSH_AUTH_TYPES</td>
 * CURLSSH_AUTH_PUBLICKEY, 
 * CURLSSH_AUTH_PASSWORD, 
 * CURLSSH_AUTH_HOST, 
 * CURLSSH_AUTH_KEYBOARD
 * のビットマスク。
 * CURLSSH_AUTH_ANY にすると libcurl がいずれかひとつを選択します。
 * </td>
 * cURL 7.16.1 で追加されました。
 * </td>
 * </tr>
 * </p>
 * <p>
 * value は、
 * option パラメータの
 * 以下の値に関して文字列である必要があります。
 * <tr valign="top">
 * <td>オプション</td>
 * <td>value への設定値</td>
 * <td>注記</td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_CAINFO</td>
 * 接続先を検証するための証明書を保持するファイル名。
 * これは CURLOPT_SSL_VERIFYPEER を使用する場合に
 * のみ意味を持ちます。
 * </td>
 * 絶対パスで指定しなければなりません。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_CAPATH</td>
 * 複数の証明書ファイルを保持するディレクトリ。このオプションは
 * CURLOPT_SSL_VERIFYPEER とともに使用します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_COOKIE</td>
 * HTTP リクエストにおける
 * "Cookie: " ヘッダの内容。
 * クッキーが複数ある場合は、セミコロンとスペースで区切られる
 * (例 "fruit=apple; colour=red")
 * ことに注意しましょう。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_COOKIEFILE</td>
 * クッキーのデータを保持するファイルの名前。クッキーファイルは、
 * Netscape フォーマットあるいは
 * HTTP ヘッダを単純にファイルにダンプしたものが使用可能です。
 * 名前が空文字列の場合はクッキーを読み込みませんが、クッキーの処理は有効なままです。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_COOKIEJAR</td>
 * ハンドルを閉じる際 (curl_close のコール後など) に、
 * すべての内部クッキーを保存するファイルの名前。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_CUSTOMREQUEST</td>
 * HTTP リクエストで
 * "GET" あるいは "HEAD" 以外に
 * 使用するカスタムメソッド。これが有用なのは、"DELETE"
 * やその他のあまり知られていない HTTP リクエストを実行する場合です。
 * 使用可能な値は "GET"、
 * "POST"、"CONNECT" などです。
 * HTTP リクエストの内容をすべて指定するわけではありません。つまり、
 * "GET /index.html HTTP/1.0\r\n\r\n" のような
 * 記述は間違いだということです。
 * <p>
 * 使用しようとしているメソッドをサーバーがサポートしていることを
 * 確かめるまで、これを使用しないでください。
 * </p>
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_EGDSOCKET</td>
 * CURLOPT_RANDOM_FILE と似ていますが、
 * Entropy Gathering Daemon ソケットを使用してファイル名を生成する点が
 * 違います。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_ENCODING</td>
 * "Accept-Encoding: " ヘッダの内容。
 * これにより、応答のデコードを可能にします。サポートされる
 * エンコーディングは "identity"、
 * "deflate" および "gzip"
 * です。もし空文字列 "" が指定された場合、
 * サポートされるエンコーディングをすべて含むヘッダが送信されます。
 * </td>
 * cURL 7.10 で追加されました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_FTPPORT</td>
 * FTP で "POST" を使用するための IP アドレスを取得する際に使用される値。
 * "POST" は、リモートサーバーに対してこちらが指定した IP アドレスに
 * 接続するよう指示します。この値に設定できる内容は IP アドレス、ホスト名、
 * ネットワークインターフェイス名（Unix）、あるいは単に '-' を指定する
 * ことでシステムのデフォルト IP アドレスを指定します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_INTERFACE</td>
 * 使用するネットワークインターフェイスの名前。
 * インターフェイス名、IP アドレスあるいはホスト名が指定可能です。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_KEYPASSWD</td>
 * CURLOPT_SSLKEY
 * あるいは CURLOPT_SSH_PRIVATE_KEYFILE 秘密鍵を使うときに必須となるパスワード。
 * </td>
 * cURL 7.16.1 で追加されました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_KRB4LEVEL</td>
 * KRB4（Kerberos 4）セキュリティレベル。以下の値のいずれか
 * （セキュリティの低い順です）が指定可能です。
 * "clear"、
 * "safe"、
 * "confidential"、
 * "private"。
 * 文字列がこれらのどれでもなかった場合は、
 * "private" が使用されます。このオプションを NULL
 * にすると KRB4 セキュリティを無効にします。現時点では、KRB4
 * セキュリティは FTP 転送にのみ使用可能です。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_POSTFIELDS</td>
 * HTTP "POST" で送信するすべてのデータ。
 * ファイルを送信するには、ファイル名の先頭に @
 * をつけてフルパスを指定します。ファイルタイプを明示的に指定するには、ファイル名の後に
 * ';type=mimetype' 形式で続けます。
 * このパラメータは
 * 'para1=val1&amp;para2=val2&amp;...'
 * のように url エンコードされた文字列形式で渡すこともできますし、
 * フィールド名をキー、データを値とする配列で渡すこともできます。
 * value が配列の場合、
 * Content-Type ヘッダには
 * multipart/form-data を設定します。
 * PHP 5.2.0 以降、このオプションに
 * @ プレフィックスつきでファイルを渡したときは
 * value が配列でなければならなくなりました。
 * PHP 5.5.0 以降、@ プレフィックスは非推奨になりました。
 * また、ファイルを CURLFile で送信できるようになりました。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_PROXY</td>
 * リクエストを経由させる HTTP プロキシ。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_PROXYUSERPWD</td>
 * プロキシに接続するためのユーザー名とパスワード。
 * "[username]:[password]" 形式で指定します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_RANDOM_FILE</td>
 * 使用するファイル名を、SSL の乱数生成器を使用して作成します。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_RANGE</td>
 * 取得するデータの範囲を
 * "X-Y" 形式で指定します。X あるいは Y は省略可能です。
 * HTTP 転送では、いくつかの範囲をカンマで区切った
 * "X-Y,N-M" のような形式もサポートしています。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_REFERER</td>
 * HTTP リクエストで使用される "Referer: "
 * ヘッダの内容。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSH_HOST_PUBLIC_KEY_MD5</td>
 * 32 桁の十六進文字列。この文字列は、リモートホストの公開鍵の MD5 チェックサムでなければなりません。
 * md5sum がマッチしない限り、libcurl はホストとの接続を拒否します。
 * このオプションは、SCP および SFTP でのみ有効です。
 * </td>
 * cURL 7.17.1 で追加されました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSH_PUBLIC_KEYFILE</td>
 * 公開鍵のファイル名。指定しなかった場合、libcurl はデフォルトの場所を探します。デフォルトは、
 * 環境変数 HOME が設定されていれば $HOME/.ssh/id_dsa.pub、設定されていなければ
 * カレントディレクトリの "id_dsa.pub" です。
 * </td>
 * cURL 7.16.1 で追加されました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSH_PRIVATE_KEYFILE</td>
 * 秘密鍵のファイル名。指定しなかった場合、libcurl はデフォルトの場所を探します。デフォルトは、
 * 環境変数 HOME が設定されていれば $HOME/.ssh/id_dsa、設定されていなければ
 * カレントディレクトリの "id_dsa" です。
 * ファイルがパスワードで保護されている場合は、パスワードを
 * CURLOPT_KEYPASSWD に設定します。
 * </td>
 * cURL 7.16.1 で追加されました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSL_CIPHER_LIST</td>
 * SSL で使用する暗号のリスト。例えば
 * RC4-SHA および TLSv1 が
 * 使用可能です。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSLCERT</td>
 * PEM フォーマットの証明書を含むファイルの名前。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSLCERTPASSWD</td>
 * CURLOPT_SSLCERT
 * 証明書を使用する際に必要なパスワード。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSLCERTTYPE</td>
 * 証明書の形式。サポートされるフォーマットは
 * "PEM"（デフォルト）、"DER"
 * および "ENG" です。
 * </td>
 * cURL 7.9.3 で追加されました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSLENGINE</td>
 * CURLOPT_SSLKEY で指定した SSL 秘密鍵の
 * 暗号化エンジンの ID 。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSLENGINE_DEFAULT</td>
 * 非対称暗号化で使用する暗号化エンジンの ID 。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSLKEY</td>
 * SSL 秘密鍵を含むファイルの名前。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSLKEYPASSWD</td>
 * CURLOPT_SSLKEY で指定した SSL 秘密鍵を
 * 使用するために必要なパスワード。
 * <p>
 * このオプションには重要なパスワードが含まれます。PHP スクリプトを
 * 安全な状態におくことを忘れないでください。
 * </p>
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_SSLKEYTYPE</td>
 * CURLOPT_SSLKEY で指定した SSL 秘密鍵の
 * 形式。サポートされる型は以下のとおりです。
 * "PEM"（デフォルト）、"DER"
 * および "ENG" 。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_URL</td>
 * 取得する URL 。curl_init でセッションを
 * 初期化する際に指定することも可能です。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_USERAGENT</td>
 * HTTP リクエストで使用される "User-Agent: "
 * ヘッダの内容。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_USERPWD</td>
 * 接続に使用するユーザー名とパスワード。
 * "[username]:[password]" 形式で指定します。
 * </td>
 * </td>
 * </tr>
 * </p>
 * <p>
 * value には、
 * option の以下の値に関して
 * 配列を指定する必要があります。
 * <tr valign="top">
 * <td>オプション</td>
 * <td>value への設定値</td>
 * <td>注記</td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_HTTP200ALIASES</td>
 * エラーではなく正常な応答として扱われる、HTTP 200 レスポンスの配列。
 * </td>
 * cURL 7.10.3 で追加されました。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_HTTPHEADER</td>
 * 設定する HTTP ヘッダフィールドの配列。
 * array('Content-type: text/plain', 'Content-length: 100')
 * 形式。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_POSTQUOTE</td>
 * FTP リクエストの実行後に、サーバー上で実行する FTP コマンドの配列。
 * </td>
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_QUOTE</td>
 * FTP リクエストの前にサーバー上で実行する FTP コマンドの配列。
 * </td>
 * </td>
 * </tr>
 * </p>
 * <p>
 * value はストリームリソース（例えば
 * fopen が作成するもの）であり、以下の
 * option パラメータに設定します。
 * <tr valign="top">
 * <td>オプション</td>
 * <td>value に設定する内容</td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_FILE</td>
 * 転送内容が書き込まれるファイル。デフォルトは STDOUT
 * （ブラウザウィンドウ）。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_INFILE</td>
 * アップロード時に転送内容を読み込むファイル。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_STDERR</td>
 * STDERR の代わりにエラーを出力する場所。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_WRITEHEADER</td>
 * 転送のヘッダ部分が書き込まれるファイル。
 * </td>
 * </tr>
 * </p>
 * <p>
 * value には、
 * option の以下の値に関して
 * 有効な関数あるいはクロージャの名前を指定する必要があります。
 * <tr valign="top">
 * <td>オプション</td>
 * <td>value への設定値</td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_HEADERFUNCTION</td>
 * 二つのパラメータをとるコールバック。
 * 最初のパラメータは CURL リソースで、2 番目は書き込む
 * ヘッダデータの文字列です。このコールバック関数を使用するにあたり、
 * ヘッダデータを書き込む処理を実装するのはあなたの役目となります。
 * 書き込んだデータのバイト数を返します。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_PASSWDFUNCTION</td>
 * 三つのパラメータをとるコールバック。
 * 最初のパラメータは CURL リソースで、2 番目はパスワード
 * プロンプトの文字列、そして 3 番目はパスワードの最大長です。
 * 入力されたパスワードを文字列で返します。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_PROGRESSFUNCTION</td>
 * 三つのパラメータをとるコールバック。
 * 最初のパラメータは CURL リソースで、2 番目はファイル記述子リソース、
 * そして 3 番目は長さです。データを文字列で返します。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_READFUNCTION</td>
 * 三つのパラメータをとるコールバック。
 * 最初のパラメータは CURL リソースで、2 番目は
 * CURLOPT_INFILE で cURL に渡したストリームリソース、
 * そして最後が読み込むデータの最大量です。
 * コールバックは、要求したデータ量以下の長さの文字列を返さなければなりません。
 * 一般的には、渡されたストリームリソースから読み込んだデータを返します。
 * EOF を伝えるには空文字列を返さなければなりません。
 * </td>
 * </tr>
 * <tr valign="top">
 * CURLOPT_WRITEFUNCTION</td>
 * 二つのパラメータをとるコールバック。
 * 最初のパラメータは CURL リソースで、2 番目は書き込む
 * データの文字列です。データの保存には、
 * このコールバック関数を使わなければなりません。
 * 書き込んだデータの正確なバイト数を返す必要があります。
 * 返さなければ、エラーで転送が異常終了します。
 * </td>
 * </tr>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function curl_setopt ($ch, $option, $value) {}

/**
 * CURL 転送用の複数のオプションを設定する
 * @link http://www.php.net/manual/ja/function.curl-setopt-array.php
 * @param ch resource <p>curl_init
 * が返す cURL ハンドル。</p>
 * @param options array <p>
 * 設定するオプションとその値を指定した配列。キーとして使用できるのは、
 * 有効な curl_setopt 定数か、
 * その定数に対応する整数値だけです。
 * </p>
 * @return bool すべてのオプションがうまく設定できた場合に TRUE を返します。
 * うまく設定できないオプションがあった時点で即時に FALSE
 * が返され、options
 * 配列に含まれるそれ以降のオプションは無視されます。
 */
function curl_setopt_array ($ch, array $options) {}

/**
 * cURL セッションを実行する
 * @link http://www.php.net/manual/ja/function.curl-exec.php
 * @param ch resource <p>curl_init
 * が返す cURL ハンドル。</p>
 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。 しかし、オプション CURLOPT_RETURNTRANSFER
 * が設定されていると、
 * 成功した場合に取得結果、失敗した場合に FALSE を返します。
 */
function curl_exec ($ch) {}

/**
 * 指定した伝送に関する情報を得る
 * @link http://www.php.net/manual/ja/function.curl-getinfo.php
 * @param ch resource <p>curl_init
 * が返す cURL ハンドル。</p>
 * @param opt int[optional] <p>
 * これは、以下のいずれかの定数となります。
 * CURLINFO_EFFECTIVE_URL - 直近の有効な URL
 * @return mixed opt を指定した場合は、その値を文字列で返します。
 * それ以外の場合は、以下の要素をもつ連想配列を返します
 * (それぞれの要素が opt に対応します)。
 * 失敗した場合は FALSE を返します。
 * "url"
 * "content_type"
 * "http_code"
 * "header_size"
 * "request_size"
 * "filetime"
 * "ssl_verify_result"
 * "redirect_count"
 * "total_time"
 * "namelookup_time"
 * "connect_time"
 * "pretransfer_time"
 * "size_upload"
 * "size_download"
 * "speed_download"
 * "speed_upload"
 * "download_content_length"
 * "upload_content_length"
 * "starttransfer_time"
 * "redirect_time"
 * "certinfo"
 * "request_header" (これが設定されるのは、事前に curl_setopt
 * をコールしたときに CURLINFO_HEADER_OUT を設定した場合のみです)
 */
function curl_getinfo ($ch, $opt = null) {}

/**
 * 現在のセッションに関する直近のエラー文字列を返す
 * @link http://www.php.net/manual/ja/function.curl-error.php
 * @param ch resource <p>curl_init
 * が返す cURL ハンドル。</p>
 * @return string エラーメッセージ、あるいはエラーが発生しなかった場合は ''
 * (空文字) を返します。
 */
function curl_error ($ch) {}

/**
 * 直近のエラー番号を返す
 * @link http://www.php.net/manual/ja/function.curl-errno.php
 * @param ch resource <p>curl_init
 * が返す cURL ハンドル。</p>
 * @return int エラー番号を返します。エラーが発生しない場合、
 * 0 (ゼロ) を返します。
 */
function curl_errno ($ch) {}

/**
 * cURL セッションを閉じる
 * @link http://www.php.net/manual/ja/function.curl-close.php
 * @param ch resource <p>curl_init
 * が返す cURL ハンドル。</p>
 * @return void 値を返しません。
 */
function curl_close ($ch) {}

/**
 * 新規 cURL マルチハンドルを返す
 * @link http://www.php.net/manual/ja/function.curl-multi-init.php
 * @return resource 成功した場合に cURL マルチハンドルリソース、失敗した場合に FALSE を返します。
 */
function curl_multi_init () {}

/**
 * cURL マルチハンドルに、通常の cURL ハンドルを追加する
 * @link http://www.php.net/manual/ja/function.curl-multi-add-handle.php
 * @param mh resource <p>curl_multi_init
 * が返す cURL マルチハンドル。</p>
 * @param ch resource <p>curl_init
 * が返す cURL ハンドル。</p>
 * @return int 成功した場合に 0、あるいはエラーコード
 * CURLM_XXX のいずれかを返します。
 */
function curl_multi_add_handle ($mh, $ch) {}

/**
 * cURL ハンドルのセットからマルチハンドルを削除する
 * @link http://www.php.net/manual/ja/function.curl-multi-remove-handle.php
 * @param mh resource <p>curl_multi_init
 * が返す cURL マルチハンドル。</p>
 * @param ch resource <p>curl_init
 * が返す cURL ハンドル。</p>
 * @return int 成功した場合に 0、失敗した場合にエラーコード CURLM_XXX のいずれかを返します。
 * codes.
 */
function curl_multi_remove_handle ($mh, $ch) {}

/**
 * curl_multi 接続のアクティビティを待つ
 * @link http://www.php.net/manual/ja/function.curl-multi-select.php
 * @param mh resource <p>curl_multi_init
 * が返す cURL マルチハンドル。</p>
 * @param timeout float[optional] <p>
 * レスポンスを待つ秒数。
 * </p>
 * @return int 成功した場合は、記述子セットに含まれる記述子の数を返します。
 * select に失敗した場合は -1 を返し、それ以外の失敗時は
 * (select システムコールから) タイムアウトします。
 */
function curl_multi_select ($mh, $timeout = null) {}

/**
 * 現在の cURL ハンドルから、サブ接続を実行する
 * @link http://www.php.net/manual/ja/function.curl-multi-exec.php
 * @param mh resource <p>curl_multi_init
 * が返す cURL マルチハンドル。</p>
 * @param still_running int <p>
 * 処理が実行中かどうかを表すフラグへの参照。
 * </p>
 * @return int cURL 定義済み定数 で定義された
 * cURL コードを返します。
 * </p>
 * <p>
 * これは、マルチスタック全体に関するエラーのみを返します。この関数が
 * CURLM_OK を返したとしても、各転送で個別にエラーが発生している可能性があります。
 */
function curl_multi_exec ($mh, &$still_running) {}

/**
 * <constant>CURLOPT_RETURNTRANSFER</constant> が設定されている場合に、cURL ハンドルの内容を返す
 * @link http://www.php.net/manual/ja/function.curl-multi-getcontent.php
 * @param ch resource <p>curl_init
 * が返す cURL ハンドル。</p>
 * @return string CURLOPT_RETURNTRANSFER が設定されている場合に、
 * cURL ハンドルの内容を返します。
 */
function curl_multi_getcontent ($ch) {}

/**
 * 現在の転送についての情報を表示する
 * @link http://www.php.net/manual/ja/function.curl-multi-info-read.php
 * @param mh resource <p>curl_multi_init
 * が返す cURL マルチハンドル。</p>
 * @param msgs_in_queue int[optional] <p>
 * まだキューの中に残っているメッセージの数。
 * </p>
 * @return array 成功した場合にメッセージの連想配列、失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * <table>
 * 配列の内容
 * <tr valign="top">
 * <td>キー</td>
 * <td>値</td>
 * </tr>
 * <tr valign="top">
 * <td>msg</td>
 * <td>定数 CURLMSG_DONE。その他の返り値は現在は存在しません。</td>
 * </tr>
 * <tr valign="top">
 * <td>result</td>
 * <td>定数 CURLE_* のいずれか。すべて OK なら
 * CURLE_OK が返ります。</td>
 * </tr>
 * <tr valign="top">
 * <td>handle</td>
 * <td>curl が扱うハンドルの型を表すリソース。</td>
 * </tr>
 * </table>
 */
function curl_multi_info_read ($mh, &$msgs_in_queue = null) {}

/**
 * cURL ハンドルのセットを閉じる
 * @link http://www.php.net/manual/ja/function.curl-multi-close.php
 * @param mh resource <p>curl_multi_init
 * が返す cURL マルチハンドル。</p>
 * @return void 値を返しません。
 */
function curl_multi_close ($mh) {}

define ('CURLOPT_IPRESOLVE', 113);
define ('CURL_IPRESOLVE_WHATEVER', 0);
define ('CURL_IPRESOLVE_V4', 1);
define ('CURL_IPRESOLVE_V6', 2);
define ('CURLOPT_DNS_USE_GLOBAL_CACHE', 91);
define ('CURLOPT_DNS_CACHE_TIMEOUT', 92);
define ('CURLOPT_PORT', 3);
define ('CURLOPT_FILE', 10001);
define ('CURLOPT_READDATA', 10009);
define ('CURLOPT_INFILE', 10009);
define ('CURLOPT_INFILESIZE', 14);
define ('CURLOPT_URL', 10002);
define ('CURLOPT_PROXY', 10004);
define ('CURLOPT_VERBOSE', 41);
define ('CURLOPT_HEADER', 42);
define ('CURLOPT_HTTPHEADER', 10023);
define ('CURLOPT_NOPROGRESS', 43);

/**
 * PHP 5.3.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLOPT_PROGRESSFUNCTION', 20056);
define ('CURLOPT_NOBODY', 44);
define ('CURLOPT_FAILONERROR', 45);
define ('CURLOPT_UPLOAD', 46);
define ('CURLOPT_POST', 47);
define ('CURLOPT_FTPLISTONLY', 48);
define ('CURLOPT_FTPAPPEND', 50);
define ('CURLOPT_NETRC', 51);

/**
 * open_basedir あるいは
 * safe_mode が有効な場合は、
 * この定数は使用できません。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLOPT_FOLLOWLOCATION', 52);
define ('CURLOPT_PUT', 54);
define ('CURLOPT_USERPWD', 10005);
define ('CURLOPT_PROXYUSERPWD', 10006);
define ('CURLOPT_RANGE', 10007);
define ('CURLOPT_TIMEOUT', 13);
define ('CURLOPT_TIMEOUT_MS', 155);
define ('CURLOPT_POSTFIELDS', 10015);
define ('CURLOPT_REFERER', 10016);
define ('CURLOPT_USERAGENT', 10018);
define ('CURLOPT_FTPPORT', 10017);
define ('CURLOPT_FTP_USE_EPSV', 85);
define ('CURLOPT_LOW_SPEED_LIMIT', 19);
define ('CURLOPT_LOW_SPEED_TIME', 20);
define ('CURLOPT_RESUME_FROM', 21);
define ('CURLOPT_COOKIE', 10022);

/**
 * PHP 5.1.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLOPT_COOKIESESSION', 96);

/**
 * PHP 5.1.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLOPT_AUTOREFERER', 58);
define ('CURLOPT_SSLCERT', 10025);
define ('CURLOPT_SSLCERTPASSWD', 10026);
define ('CURLOPT_WRITEHEADER', 10029);
define ('CURLOPT_SSL_VERIFYHOST', 81);
define ('CURLOPT_COOKIEFILE', 10031);
define ('CURLOPT_SSLVERSION', 32);
define ('CURLOPT_TIMECONDITION', 33);
define ('CURLOPT_TIMEVALUE', 34);
define ('CURLOPT_CUSTOMREQUEST', 10036);
define ('CURLOPT_STDERR', 10037);
define ('CURLOPT_TRANSFERTEXT', 53);
define ('CURLOPT_RETURNTRANSFER', 19913);
define ('CURLOPT_QUOTE', 10028);
define ('CURLOPT_POSTQUOTE', 10039);
define ('CURLOPT_INTERFACE', 10062);
define ('CURLOPT_KRB4LEVEL', 10063);
define ('CURLOPT_HTTPPROXYTUNNEL', 61);
define ('CURLOPT_FILETIME', 69);
define ('CURLOPT_WRITEFUNCTION', 20011);
define ('CURLOPT_READFUNCTION', 20012);
define ('CURLOPT_HEADERFUNCTION', 20079);
define ('CURLOPT_MAXREDIRS', 68);
define ('CURLOPT_MAXCONNECTS', 71);
define ('CURLOPT_CLOSEPOLICY', 72);
define ('CURLOPT_FRESH_CONNECT', 74);
define ('CURLOPT_FORBID_REUSE', 75);
define ('CURLOPT_RANDOM_FILE', 10076);
define ('CURLOPT_EGDSOCKET', 10077);
define ('CURLOPT_CONNECTTIMEOUT', 78);
define ('CURLOPT_CONNECTTIMEOUT_MS', 156);
define ('CURLOPT_SSL_VERIFYPEER', 64);
define ('CURLOPT_CAINFO', 10065);
define ('CURLOPT_CAPATH', 10097);
define ('CURLOPT_COOKIEJAR', 10082);
define ('CURLOPT_SSL_CIPHER_LIST', 10083);
define ('CURLOPT_BINARYTRANSFER', 19914);
define ('CURLOPT_NOSIGNAL', 99);
define ('CURLOPT_PROXYTYPE', 101);
define ('CURLOPT_BUFFERSIZE', 98);
define ('CURLOPT_HTTPGET', 80);
define ('CURLOPT_HTTP_VERSION', 84);
define ('CURLOPT_SSLKEY', 10087);
define ('CURLOPT_SSLKEYTYPE', 10088);
define ('CURLOPT_SSLKEYPASSWD', 10026);
define ('CURLOPT_SSLENGINE', 10089);
define ('CURLOPT_SSLENGINE_DEFAULT', 90);
define ('CURLOPT_SSLCERTTYPE', 10086);
define ('CURLOPT_CRLF', 27);
define ('CURLOPT_ENCODING', 10102);
define ('CURLOPT_PROXYPORT', 59);
define ('CURLOPT_UNRESTRICTED_AUTH', 105);
define ('CURLOPT_FTP_USE_EPRT', 106);

/**
 * PHP 5.2.1 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLOPT_TCP_NODELAY', 121);
define ('CURLOPT_HTTP200ALIASES', 10104);
define ('CURL_TIMECOND_IFMODSINCE', 1);
define ('CURL_TIMECOND_IFUNMODSINCE', 2);
define ('CURL_TIMECOND_LASTMOD', 3);

/**
 * PHP 5.4.0 および cURL 7.15.5 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLOPT_MAX_RECV_SPEED_LARGE', 30146);

/**
 * PHP 5.4.0 および cURL 7.15.5 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLOPT_MAX_SEND_SPEED_LARGE', 30145);
define ('CURLOPT_HTTPAUTH', 107);
define ('CURLAUTH_BASIC', 1);
define ('CURLAUTH_DIGEST', 2);
define ('CURLAUTH_GSSNEGOTIATE', 4);
define ('CURLAUTH_NTLM', 8);
define ('CURLAUTH_ANY', -17);
define ('CURLAUTH_ANYSAFE', -18);
define ('CURLOPT_PROXYAUTH', 111);
define ('CURLOPT_FTP_CREATE_MISSING_DIRS', 110);

/**
 * PHP 5.2.4 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLOPT_PRIVATE', 10103);
define ('CURLCLOSEPOLICY_LEAST_RECENTLY_USED', 2);
define ('CURLCLOSEPOLICY_LEAST_TRAFFIC', 3);
define ('CURLCLOSEPOLICY_SLOWEST', 4);
define ('CURLCLOSEPOLICY_CALLBACK', 5);
define ('CURLCLOSEPOLICY_OLDEST', 1);
define ('CURLINFO_EFFECTIVE_URL', 1048577);
define ('CURLINFO_HTTP_CODE', 2097154);
define ('CURLINFO_HEADER_SIZE', 2097163);
define ('CURLINFO_REQUEST_SIZE', 2097164);
define ('CURLINFO_TOTAL_TIME', 3145731);
define ('CURLINFO_NAMELOOKUP_TIME', 3145732);
define ('CURLINFO_CONNECT_TIME', 3145733);
define ('CURLINFO_PRETRANSFER_TIME', 3145734);
define ('CURLINFO_SIZE_UPLOAD', 3145735);
define ('CURLINFO_SIZE_DOWNLOAD', 3145736);
define ('CURLINFO_SPEED_DOWNLOAD', 3145737);
define ('CURLINFO_SPEED_UPLOAD', 3145738);
define ('CURLINFO_FILETIME', 2097166);
define ('CURLINFO_SSL_VERIFYRESULT', 2097165);
define ('CURLINFO_CONTENT_LENGTH_DOWNLOAD', 3145743);
define ('CURLINFO_CONTENT_LENGTH_UPLOAD', 3145744);
define ('CURLINFO_STARTTRANSFER_TIME', 3145745);
define ('CURLINFO_CONTENT_TYPE', 1048594);
define ('CURLINFO_REDIRECT_TIME', 3145747);
define ('CURLINFO_REDIRECT_COUNT', 2097172);

/**
 * PHP 5.1.3 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLINFO_HEADER_OUT', 2);

/**
 * PHP 5.2.4 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLINFO_PRIVATE', 1048597);
define ('CURLINFO_CERTINFO', 4194338);
define ('CURLINFO_REDIRECT_URL', 1048607);
define ('CURL_VERSION_IPV6', 1);
define ('CURL_VERSION_KERBEROS4', 2);
define ('CURL_VERSION_SSL', 4);
define ('CURL_VERSION_LIBZ', 8);
define ('CURLVERSION_NOW', 3);
define ('CURLE_OK', 0);
define ('CURLE_UNSUPPORTED_PROTOCOL', 1);
define ('CURLE_FAILED_INIT', 2);
define ('CURLE_URL_MALFORMAT', 3);
define ('CURLE_URL_MALFORMAT_USER', 4);
define ('CURLE_COULDNT_RESOLVE_PROXY', 5);
define ('CURLE_COULDNT_RESOLVE_HOST', 6);
define ('CURLE_COULDNT_CONNECT', 7);
define ('CURLE_FTP_WEIRD_SERVER_REPLY', 8);
define ('CURLE_FTP_ACCESS_DENIED', 9);
define ('CURLE_FTP_USER_PASSWORD_INCORRECT', 10);
define ('CURLE_FTP_WEIRD_PASS_REPLY', 11);
define ('CURLE_FTP_WEIRD_USER_REPLY', 12);
define ('CURLE_FTP_WEIRD_PASV_REPLY', 13);
define ('CURLE_FTP_WEIRD_227_FORMAT', 14);
define ('CURLE_FTP_CANT_GET_HOST', 15);
define ('CURLE_FTP_CANT_RECONNECT', 16);
define ('CURLE_FTP_COULDNT_SET_BINARY', 17);
define ('CURLE_PARTIAL_FILE', 18);
define ('CURLE_FTP_COULDNT_RETR_FILE', 19);
define ('CURLE_FTP_WRITE_ERROR', 20);
define ('CURLE_FTP_QUOTE_ERROR', 21);
define ('CURLE_HTTP_NOT_FOUND', 22);
define ('CURLE_WRITE_ERROR', 23);
define ('CURLE_MALFORMAT_USER', 24);
define ('CURLE_FTP_COULDNT_STOR_FILE', 25);
define ('CURLE_READ_ERROR', 26);
define ('CURLE_OUT_OF_MEMORY', 27);
define ('CURLE_OPERATION_TIMEOUTED', 28);
define ('CURLE_FTP_COULDNT_SET_ASCII', 29);
define ('CURLE_FTP_PORT_FAILED', 30);
define ('CURLE_FTP_COULDNT_USE_REST', 31);
define ('CURLE_FTP_COULDNT_GET_SIZE', 32);
define ('CURLE_HTTP_RANGE_ERROR', 33);
define ('CURLE_HTTP_POST_ERROR', 34);
define ('CURLE_SSL_CONNECT_ERROR', 35);
define ('CURLE_FTP_BAD_DOWNLOAD_RESUME', 36);
define ('CURLE_FILE_COULDNT_READ_FILE', 37);
define ('CURLE_LDAP_CANNOT_BIND', 38);
define ('CURLE_LDAP_SEARCH_FAILED', 39);
define ('CURLE_LIBRARY_NOT_FOUND', 40);
define ('CURLE_FUNCTION_NOT_FOUND', 41);
define ('CURLE_ABORTED_BY_CALLBACK', 42);
define ('CURLE_BAD_FUNCTION_ARGUMENT', 43);
define ('CURLE_BAD_CALLING_ORDER', 44);
define ('CURLE_HTTP_PORT_FAILED', 45);
define ('CURLE_BAD_PASSWORD_ENTERED', 46);
define ('CURLE_TOO_MANY_REDIRECTS', 47);
define ('CURLE_UNKNOWN_TELNET_OPTION', 48);
define ('CURLE_TELNET_OPTION_SYNTAX', 49);
define ('CURLE_OBSOLETE', 50);
define ('CURLE_SSL_PEER_CERTIFICATE', 51);
define ('CURLE_GOT_NOTHING', 52);
define ('CURLE_SSL_ENGINE_NOTFOUND', 53);
define ('CURLE_SSL_ENGINE_SETFAILED', 54);
define ('CURLE_SEND_ERROR', 55);
define ('CURLE_RECV_ERROR', 56);
define ('CURLE_SHARE_IN_USE', 57);
define ('CURLE_SSL_CERTPROBLEM', 58);
define ('CURLE_SSL_CIPHER', 59);
define ('CURLE_SSL_CACERT', 60);
define ('CURLE_BAD_CONTENT_ENCODING', 61);
define ('CURLE_LDAP_INVALID_URL', 62);
define ('CURLE_FILESIZE_EXCEEDED', 63);
define ('CURLE_FTP_SSL_FAILED', 64);
define ('CURLPROXY_HTTP', 0);
define ('CURLPROXY_SOCKS4', 4);
define ('CURLPROXY_SOCKS5', 5);
define ('CURL_NETRC_OPTIONAL', 1);
define ('CURL_NETRC_IGNORED', 0);
define ('CURL_NETRC_REQUIRED', 2);
define ('CURL_HTTP_VERSION_NONE', 0);
define ('CURL_HTTP_VERSION_1_0', 1);
define ('CURL_HTTP_VERSION_1_1', 2);
define ('CURLM_CALL_MULTI_PERFORM', -1);
define ('CURLM_OK', 0);
define ('CURLM_BAD_HANDLE', 1);
define ('CURLM_BAD_EASY_HANDLE', 2);
define ('CURLM_OUT_OF_MEMORY', 3);
define ('CURLM_INTERNAL_ERROR', 4);
define ('CURLMSG_DONE', 1);

/**
 * PHP 5.1.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLOPT_FTPSSLAUTH', 129);

/**
 * PHP 5.1.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLFTPAUTH_DEFAULT', 0);

/**
 * PHP 5.1.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLFTPAUTH_SSL', 1);

/**
 * PHP 5.1.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLFTPAUTH_TLS', 2);

/**
 * PHP 5.2.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLOPT_FTP_SSL', 119);

/**
 * PHP 5.2.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLFTPSSL_NONE', 0);

/**
 * PHP 5.2.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLFTPSSL_TRY', 1);

/**
 * PHP 5.2.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLFTPSSL_CONTROL', 2);

/**
 * PHP 5.2.0 以降で使用可能です。
 * @link http://www.php.net/manual/ja/curl.constants.php
 */
define ('CURLFTPSSL_ALL', 3);
define ('CURLOPT_CERTINFO', 172);
define ('CURLOPT_POSTREDIR', 161);
define ('CURLSSH_AUTH_NONE', 0);
define ('CURLSSH_AUTH_PUBLICKEY', 1);
define ('CURLSSH_AUTH_PASSWORD', 2);
define ('CURLSSH_AUTH_HOST', 4);
define ('CURLSSH_AUTH_KEYBOARD', 8);
define ('CURLSSH_AUTH_DEFAULT', -1);
define ('CURLOPT_SSH_AUTH_TYPES', 151);
define ('CURLOPT_KEYPASSWD', 10026);
define ('CURLOPT_SSH_PUBLIC_KEYFILE', 10152);
define ('CURLOPT_SSH_PRIVATE_KEYFILE', 10153);
define ('CURLOPT_SSH_HOST_PUBLIC_KEY_MD5', 10162);
define ('CURLE_SSH', 79);
define ('CURLOPT_REDIR_PROTOCOLS', 182);
define ('CURLOPT_PROTOCOLS', 181);
define ('CURLPROTO_HTTP', 1);
define ('CURLPROTO_HTTPS', 2);
define ('CURLPROTO_FTP', 4);
define ('CURLPROTO_FTPS', 8);
define ('CURLPROTO_SCP', 16);
define ('CURLPROTO_SFTP', 32);
define ('CURLPROTO_TELNET', 64);
define ('CURLPROTO_LDAP', 128);
define ('CURLPROTO_LDAPS', 256);
define ('CURLPROTO_DICT', 512);
define ('CURLPROTO_FILE', 1024);
define ('CURLPROTO_TFTP', 2048);
define ('CURLPROTO_ALL', -1);
define ('CURLOPT_FTP_FILEMETHOD', 138);
define ('CURLOPT_FTP_SKIP_PASV_IP', 137);
define ('CURLFTPMETHOD_MULTICWD', 1);
define ('CURLFTPMETHOD_NOCWD', 2);
define ('CURLFTPMETHOD_SINGLECWD', 3);

// End of curl v.
?>
