<?php

// Start of ibm_db2 v.1.9.4

/**
 * データベースへの接続を返す
 * @link http://www.php.net/manual/ja/function.db2-connect.php
 * @param database string <p>
 * データベースへのカタログ接続の場合には、database
 * は DB2 クライアントカタログ内でのデータベースエイリアスを表します。
 * </p>
 * <p>
 * データベースへの非カタログ接続の場合には、
 * database は以下のような形式の接続文字列を表します。
 * DATABASE=database;HOSTNAME=hostname;PORT=port;PROTOCOL=TCPIP;UID=username;PWD=password;
 * それぞれのパラメータは以下の内容を表します。
 * database
 * <p>
 * データベースの名前。
 * </p>
 * @param username string <p>
 * データベースに接続するユーザー名。
 * </p>
 * <p>
 * カタログでない接続の場合は、NULL あるいは空の文字列を渡す必要があります。
 * </p>
 * @param password string <p>
 * データベースに接続するパスワード。
 * </p>
 * <p>
 * カタログでない接続の場合は、NULL あるいは空の文字列を渡す必要があります。
 * </p>
 * @param options array[optional] <p>
 * 接続の振る舞いを指定する接続オプションの連想配列。
 * 使用可能なキーは以下のとおりです。
 * autocommit
 * <p>
 * DB2_AUTOCOMMIT_ON を渡すと、
 * この接続ハンドルで自動コミットを有効にします。
 * </p>
 * <p>
 * DB2_AUTOCOMMIT_OFF を渡すと、
 * この接続ハンドルで自動コミットを無効にします。
 * </p>
 * @return resource 接続に成功した場合は接続ハンドルリソースを返します。
 * 接続に失敗した場合は、db2_connect
 * は FALSE を返します。
 */
function db2_connect ($database, $username, $password, array $options = null) {}

/**
 * トランザクションをコミットする
 * @link http://www.php.net/manual/ja/function.db2-commit.php
 * @param connection resource <p>
 * db2_connect あるいは db2_pconnect
 * が返した有効なデータベース接続リソース。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function db2_commit ($connection) {}

/**
 * データベースへの持続的接続を返す
 * @link http://www.php.net/manual/ja/function.db2-pconnect.php
 * @param database string <p>
 * DB2 クライアントカタログ内のデータベースエイリアス。
 * </p>
 * @param username string <p>
 * データベースに接続するユーザー名。
 * </p>
 * @param password string <p>
 * データベースに接続するパスワード。
 * </p>
 * @param options array[optional] <p>
 * 接続の振る舞いを指定する接続オプションの連想配列。
 * 使用可能なキーは以下のとおりです。
 * autocommit
 * <p>
 * DB2_AUTOCOMMIT_ON を渡すと、
 * この接続ハンドルで自動コミットを有効にします。
 * </p>
 * <p>
 * DB2_AUTOCOMMIT_OFF を渡すと、
 * この接続ハンドルで自動コミットを無効にします。
 * </p>
 * @return resource 接続に成功した場合は接続ハンドルリソースを返します。
 * パラメータ database、username
 * および password に完全に一致する接続が
 * 既に存在した場合、db2_pconnect
 * はそれを再利用します。接続に失敗した場合は
 * db2_pconnect は FALSE を返します。
 */
function db2_pconnect ($database, $username, $password, array $options = null) {}

/**
 * データベース接続の AUTOCOMMIT の状態を取得または設定する
 * @link http://www.php.net/manual/ja/function.db2-autocommit.php
 * @param connection resource <p>
 * db2_connect あるいは db2_pconnect
 * が返した有効なデータベース接続リソース。
 * </p>
 * @param value bool[optional] <p>
 * 以下の定数のいずれか。
 * DB2_AUTOCOMMIT_OFF
 * <p>
 * AUTOCOMMIT を無効にします。
 * </p>
 * @return mixed db2_autocommit に
 * connection パラメータのみを渡した場合、
 * 指定した接続の AUTOCOMMIT の状態を整数値で返します。
 * 0 の場合は無効、1 の場合は有効です。
 * </p>
 * <p>
 * db2_autocommit に
 * connection および
 * autocommit の両方のパラメータを渡した場合、
 * 指定した接続の AUTOCOMMIT を対応する状態に設定します。
 * 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function db2_autocommit ($connection, $value = null) {}

/**
 * PHP 変数を SQL 文のパラメータにバインドする
 * @link http://www.php.net/manual/ja/function.db2-bind-param.php
 * @param stmt resource <p>
 * db2_prepare が返すプリペアドステートメント。
 * </p>
 * @param parameter_number int 
 * @param variable_name string 
 * @param parameter_type int[optional] 
 * @param data_type int[optional] 
 * @param precision int[optional] <p>
 * 変数をデータベースにバインドする際の精度を指定します。
 * このパラメータは、ストアドプロシージャから
 * XML 出力の値を取得する際にも使用します。
 * 非負の値を指定すると、それがデータベースから取得する
 * XML データの最大サイズとなります。
 * このパラメータを使用しない場合は、
 * ストアドプロシージャから XML 出力を取得する際の最大サイズを
 * デフォルトの 1MB とみなします。
 * </p>
 * @param scale int[optional] <p>
 * 変数をデータベースにバインドする際の位取りを指定します。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function db2_bind_param ($stmt, $parameter_number, $variable_name, $parameter_type = null, $data_type = null, $precision = null, $scale = null) {}

/**
 * データベース接続を閉じる
 * @link http://www.php.net/manual/ja/function.db2-close.php
 * @param connection resource <p>
 * アクティブな DB2 クライアント接続を指定します。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function db2_close ($connection) {}

/**
 * テーブルのカラムおよび関連する権限情報を含む結果セットを返す
 * @link http://www.php.net/manual/ja/function.db2-column-privileges.php
 * @param connection resource <p>
 * IBM DB2、Cloudscape あるいは Apache Derby データベースへの有効な接続。
 * </p>
 * @param qualifier string[optional] <p>
 * OS/390 あるいは z/OS サーバー上で稼動している DB2 データベースの修飾子。
 * その他のデータベースの場合には NULL あるいは空の文字列を渡します。
 * </p>
 * @param schema string[optional] <p>
 * テーブルを含むスキーマ。すべてのスキーマに一致させるには、
 * NULL あるいは空の文字列を渡します。
 * </p>
 * @param table_name string[optional] 
 * @param column_name string[optional] 
 * @return resource 指定したパラメータに一致するカラムの権限情報を含むステートメントリソースを返します。
 * 行の内容は、以下のカラムで構成されています。
 * <tr valign="top">
 * <td>カラム名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_CAT</td>
 * <td>
 * カタログの名前。テーブルがカタログを保持していない場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_SCHEM</td>
 * <td>スキーマの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_NAME</td>
 * <td>テーブルあるいはビューの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>COLUMN_NAME</td>
 * <td>カラムの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>GRANTOR</td>
 * <td>その権限を与えたユーザーの認証 ID。</td>
 * </tr>
 * <tr valign="top">
 * <td>GRANTEE</td>
 * <td>その権限を与えられたユーザーの認証 ID。</td>
 * </tr>
 * <tr valign="top">
 * <td>PRIVILEGE</td>
 * <td>カラムの権限。</td>
 * </tr>
 * <tr valign="top">
 * <td>IS_GRANTABLE</td>
 * <td>GRANTEE が、この権限を他のユーザーに与えることができるかどうか。</td>
 * </tr>
 */
function db2_column_privileges ($connection, $qualifier = null, $schema = null, $table_name = null, $column_name = null) {}

function db2_columnprivileges () {}

/**
 * テーブルのカラムおよび関連するメタデータを含む結果セットを返す
 * @link http://www.php.net/manual/ja/function.db2-columns.php
 * @param connection resource <p>
 * IBM DB2、Cloudscape あるいは Apache Derby データベースへの有効な接続。
 * </p>
 * @param qualifier string[optional] <p>
 * OS/390 あるいは z/OS サーバー上で稼動している DB2 データベースの修飾子。
 * その他のデータベースの場合には NULL あるいは空の文字列を渡します。
 * </p>
 * @param schema string[optional] <p>
 * テーブルを含むスキーマ。すべてのスキーマに一致させるには、
 * '%' を渡します。
 * </p>
 * @param table_name string[optional] 
 * @param column_name string[optional] 
 * @return resource 指定したパラメータに一致するカラムの情報を含む結果セットの
 * ステートメントリソースを返します。
 * 行の内容は、以下のカラムで構成されています。
 * <tr valign="top">
 * <td>カラム名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_CAT</td>
 * <td>
 * カタログの名前。テーブルがカタログを保持していない場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_SCHEM</td>
 * <td>スキーマの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_NAME</td>
 * <td>テーブルあるいはビューの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>COLUMN_NAME</td>
 * <td>カラムの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>DATA_TYPE</td>
 * <td>カラムの SQL データ型を整数値で表したもの。</td>
 * </tr>
 * <tr valign="top">
 * <td>TYPE_NAME</td>
 * <td>カラムのデータ型を文字列で表したもの。</td>
 * </tr>
 * <tr valign="top">
 * <td>COLUMN_SIZE</td>
 * <td>カラムのサイズを表す整数値。</td>
 * </tr>
 * <tr valign="top">
 * <td>BUFFER_LENGTH</td>
 * <td>
 * このカラムのデータを保存するために必要な最大のバイト数。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>DECIMAL_DIGITS</td>
 * <td>
 * カラムの位取り。位取りが適用できない場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>NUM_PREC_RADIX</td>
 * <td>
 * 10 (正確な数値データ型を表す)、
 * 2 (概数データ型を表す)、
 * あるいは NULL (基数が適用できないデータ型を表す)
 * のいずれか。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>NULLABLE</td>
 * <td>カラムが null 値をとることができるかどうかを表す整数値。</td>
 * </tr>
 * <tr valign="top">
 * <td>REMARKS</td>
 * <td>カラムの説明。</td>
 * </tr>
 * <tr valign="top">
 * <td>COLUMN_DEF</td>
 * <td>カラムのデフォルト値。</td>
 * </tr>
 * <tr valign="top">
 * <td>SQL_DATA_TYPE</td>
 * <td>カラムのサイズを表す整数値。</td>
 * </tr>
 * <tr valign="top">
 * <td>SQL_DATETIME_SUB</td>
 * <td>
 * datetime 型のコードを表す整数値、
 * あるいはこれが適用できない SQL データ型である場合に NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>CHAR_OCTET_LENGTH</td>
 * <td>
 * 文字型のカラムにおける最大のオクテット数。
 * シングルバイト文字セットのデータの場合、これは COLUMN_SIZE
 * に一致します。文字型でないカラムの場合は NULL となります。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ORDINAL_POSITION</td>
 * <td>テーブル内でのカラムの位置を表す、1 から始まるインデックス。</td>
 * </tr>
 * <tr valign="top">
 * <td>IS_NULLABLE</td>
 * <td>
 * カラムが null 値をとることができるかどうかを表す文字列。
 * 'YES' の場合は null 値をとることができ、
 * 'NO' の場合はできません。
 * </td>
 * </tr>
 */
function db2_columns ($connection, $qualifier = null, $schema = null, $table_name = null, $column_name = null) {}

/**
 * テーブルの外部キーを含む結果セットを返す
 * @link http://www.php.net/manual/ja/function.db2-foreign-keys.php
 * @param connection resource <p>
 * IBM DB2、Cloudscape あるいは Apache Derby データベースへの有効な接続。
 * </p>
 * @param qualifier string <p>
 * OS/390 あるいは z/OS サーバー上で稼動している DB2 データベースの修飾子。
 * その他のデータベースの場合には NULL あるいは空の文字列を渡します。
 * </p>
 * @param schema string <p>
 * テーブルを含むスキーマ。schema
 * が NULL の場合は、db2_foreign_keys
 * 現在の接続のスキーマに一致します。
 * </p>
 * @param table_name string 
 * @return resource 指定したテーブルの外部キーを含む結果セットのステートメントリソースを返します。
 * 結果セットは、以下のカラムで構成されています。
 * <tr valign="top">
 * <td>カラム名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>PKTABLE_CAT</td>
 * <td>
 * 主キーを含むテーブルのカタログの名前。
 * テーブルがカタログを保持していない場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>PKTABLE_SCHEM</td>
 * <td>
 * 主キーを含むテーブルのスキーマの名前。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>PKTABLE_NAME</td>
 * <td>主キーを含むテーブルの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>PKCOLUMN_NAME</td>
 * <td>主キーを含むカラムの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>FKTABLE_CAT</td>
 * <td>
 * 外部キーを含むテーブルのカタログの名前。
 * テーブルがカタログを保持していない場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>FKTABLE_SCHEM</td>
 * <td>
 * 外部キーを含むテーブルのスキーマの名前。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>FKTABLE_NAME</td>
 * <td>外部キーを含むテーブルの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>FKCOLUMN_NAME</td>
 * <td>外部キーを含むカラムの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>KEY_SEQ</td>
 * <td>1 から始まる数字で表した、キー内のカラムの位置。</td>
 * </tr>
 * <tr valign="top">
 * <td>UPDATE_RULE</td>
 * <td>
 * SQL で UPDATE 操作を行った際に外部キーに適用される動作を表す整数値。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>DELETE_RULE</td>
 * <td>
 * SQL で DELETE 操作を行った際に外部キーに適用される動作を表す整数値。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>FK_NAME</td>
 * <td>外部キーの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>PK_NAME</td>
 * <td>主キーの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>DEFERRABILITY</td>
 * <td>
 * 外部キーの遅延度を表す整数値。
 * SQL_INITIALLY_DEFERRED、SQL_INITIALLY_IMMEDIATE あるいは
 * SQL_NOT_DEFERRABLE のいずれか。
 * </td>
 * </tr>
 */
function db2_foreign_keys ($connection, $qualifier, $schema, $table_name) {}

function db2_foreignkeys () {}

/**
 * テーブルの主キーを含む結果セットを返す
 * @link http://www.php.net/manual/ja/function.db2-primary-keys.php
 * @param connection resource <p>
 * IBM DB2、Cloudscape あるいは Apache Derby データベースへの有効な接続。
 * </p>
 * @param qualifier string <p>
 * OS/390 あるいは z/OS サーバー上で稼動している DB2 データベースの修飾子。
 * その他のデータベースの場合には NULL あるいは空の文字列を渡します。
 * </p>
 * @param schema string <p>
 * テーブルを含むスキーマ。schema
 * が NULL の場合、db2_primary_keys
 * は現在の接続のスキーマを使用します。
 * </p>
 * @param table_name string 
 * @return resource 指定したテーブルの主キーを含む結果セットのステートメントリソースを返します。
 * 結果セットは、以下のカラムで構成されています。
 * <tr valign="top">
 * <td>カラム名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_CAT</td>
 * <td>
 * 主キーを含むテーブルのカタログの名前。
 * テーブルがカタログを保持していない場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_SCHEM</td>
 * <td>
 * 主キーを含むテーブルのスキーマの名前。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_NAME</td>
 * <td>主キーを含むテーブルの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>COLUMN_NAME</td>
 * <td>主キーを含むカラムの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>KEY_SEQ</td>
 * <td>1 から始まる数字で表した、キー内のカラムの位置。</td>
 * </tr>
 * <tr valign="top">
 * <td>PK_NAME</td>
 * <td>主キーの名前。</td>
 * </tr>
 */
function db2_primary_keys ($connection, $qualifier, $schema, $table_name) {}

function db2_primarykeys () {}

/**
 * ストアドプロシージャのパラメータを含む結果セットを返す
 * @link http://www.php.net/manual/ja/function.db2-procedure-columns.php
 * @param connection resource <p>
 * IBM DB2、Cloudscape あるいは Apache Derby データベースへの有効な接続。
 * </p>
 * @param qualifier string <p>
 * OS/390 あるいは z/OS サーバー上で稼動している DB2 データベースの修飾子。
 * その他のデータベースの場合には NULL あるいは空の文字列を渡します。
 * </p>
 * @param schema string <p>
 * プロシージャを含むスキーマ。このパラメータでは、ワイルドカードとして
 * _ および %
 * を含む検索パターンを使用可能です。
 * </p>
 * @param procedure string <p>
 * プロシージャの名前。このパラメータでは、ワイルドカードとして
 * _ および %
 * を含む検索パターンを使用可能です。
 * </p>
 * @param parameter string <p>
 * パラメータの名前。このパラメータでは、ワイルドカードとして
 * _ および %
 * を含む検索パターンを使用可能です。
 * このパラメータが NULL の場合、指定したストアドプロシージャの
 * すべてのパラメータが返されます。
 * </p>
 * @return resource 指定したパラメータに一致するストアドプロシージャのパラメータ情報を含む結果セットの
 * ステートメントリソースを返します。
 * 行の内容は、以下のカラムで構成されています。
 * <tr valign="top">
 * <td>カラム名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>PROCEDURE_CAT</td>
 * <td>
 * プロシージャを含むカタログ。テーブルがカタログを保持していない場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>PROCEDURE_SCHEM</td>
 * <td>ストアドプロシージャを含むスキーマの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>PROCEDURE_NAME</td>
 * <td>プロシージャの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>COLUMN_NAME</td>
 * <td>パラメータの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>COLUMN_TYPE</td>
 * <td>
 * <p>
 * パラメータの型を表す整数値。
 * <tr valign="top">
 * <td>返される値</td>
 * <td>パラメータの型</td>
 * </tr>
 * <tr valign="top">
 * <td>1 (SQL_PARAM_INPUT)</td>
 * <td>入力 (IN) パラメータ。</td>
 * </tr>
 * <tr valign="top">
 * <td>2 (SQL_PARAM_INPUT_OUTPUT)</td>
 * <td>入力/出力 (INOUT) パラメータ。</td>
 * </tr>
 * <tr valign="top">
 * <td>3 (SQL_PARAM_OUTPUT)</td>
 * <td>出力 (OUT) パラメータ。</td>
 * </tr>
 * </p>
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>DATA_TYPE</td>
 * <td>
 * パラメータの SQL データ型を表す整数値。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>TYPE_NAME</td>
 * <td>パラメータのデータ型を表す文字列。</td>
 * </tr>
 * <tr valign="top">
 * <td>COLUMN_SIZE</td>
 * <td>パラメータのサイズを表す整数値。</td>
 * </tr>
 * <tr valign="top">
 * <td>BUFFER_LENGTH</td>
 * <td>
 * このパラメータのデータを保存するために必要な最大バイト数。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>DECIMAL_DIGITS</td>
 * <td>
 * パラメータの位取り。位取りが適用できない場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>NUM_PREC_RADIX</td>
 * <td>
 * 10 (正確な数値データ型を表す)、
 * 2 (概数データ型を表す)、
 * あるいは NULL (基数が適用できないデータ型を表す)
 * のいずれか。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>NULLABLE</td>
 * <td>パラメータが null 値をとることができるかどうかを表す整数値。</td>
 * </tr>
 * <tr valign="top">
 * <td>REMARKS</td>
 * <td>パラメータの説明。</td>
 * </tr>
 * <tr valign="top">
 * <td>COLUMN_DEF</td>
 * <td>パラメータのデフォルト値。</td>
 * </tr>
 * <tr valign="top">
 * <td>SQL_DATA_TYPE</td>
 * <td>パラメータのサイズを表す整数値。</td>
 * </tr>
 * <tr valign="top">
 * <td>SQL_DATETIME_SUB</td>
 * <td>
 * datetime 型のコードを表す整数値、
 * あるいはこれが適用できない SQL データ型である場合に NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>CHAR_OCTET_LENGTH</td>
 * <td>
 * 文字型のパラメータにおける最大のオクテット数。
 * シングルバイト文字セットのデータの場合、これは COLUMN_SIZE
 * に一致します。文字型でないカラムの場合は NULL となります。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ORDINAL_POSITION</td>
 * <td>CALL 文の中でのパラメータの位置を表す、1 から始まるインデックス。</td>
 * </tr>
 * <tr valign="top">
 * <td>IS_NULLABLE</td>
 * <td>
 * パラメータが null 値をとることができるかどうかを表す文字列。
 * 'YES' の場合は null 値をとることができ、
 * 'NO' の場合はできません。
 * </td>
 * </tr>
 */
function db2_procedure_columns ($connection, $qualifier, $schema, $procedure, $parameter) {}

function db2_procedurecolumns () {}

/**
 * データベース内に登録されているストアドプロシージャの一覧を含む結果セットを返す
 * @link http://www.php.net/manual/ja/function.db2-procedures.php
 * @param connection resource <p>
 * IBM DB2、Cloudscape あるいは Apache Derby データベースへの有効な接続。
 * </p>
 * @param qualifier string <p>
 * OS/390 あるいは z/OS サーバー上で稼動している DB2 データベースの修飾子。
 * その他のデータベースの場合には NULL あるいは空の文字列を渡します。
 * </p>
 * @param schema string <p>
 * プロシージャを含むスキーマ。このパラメータでは、ワイルドカードとして
 * _ および %
 * を含む検索パターンを使用可能です。
 * </p>
 * @param procedure string <p>
 * プロシージャの名前。このパラメータでは、ワイルドカードとして
 * _ および %
 * を含む検索パターンを使用可能です。
 * </p>
 * @return resource 指定したパラメータに一致するストアドプロシージャの情報を含む結果セットの
 * ステートメントリソースを返します。
 * 行の内容は、以下のカラムで構成されています。
 * <tr valign="top">
 * <td>カラム名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>PROCEDURE_CAT</td>
 * <td>
 * プロシージャを含むカタログ。テーブルがカタログを保持していない場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>PROCEDURE_SCHEM</td>
 * <td>ストアドプロシージャを含むスキーマの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>PROCEDURE_NAME</td>
 * <td>プロシージャの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>NUM_INPUT_PARAMS</td>
 * <td>ストアドプロシージャの入力 (IN) パラメータの数。</td>
 * </tr>
 * <tr valign="top">
 * <td>NUM_OUTPUT_PARAMS</td>
 * <td>ストアドプロシージャの出力 (OUT) パラメータの数。</td>
 * </tr>
 * <tr valign="top">
 * <td>NUM_RESULT_SETS</td>
 * <td>ストアドプロシージャが返す結果セットの数。</td>
 * </tr>
 * <tr valign="top">
 * <td>REMARKS</td>
 * <td>ストアドプロシージャのコメント。</td>
 * </tr>
 * <tr valign="top">
 * <td>PROCEDURE_TYPE</td>
 * <td>
 * 常に 1 を返します。これは、
 * ストアドプロシージャが返り値を返さないことを意味します。
 * </td>
 * </tr>
 */
function db2_procedures ($connection, $qualifier, $schema, $procedure) {}

/**
 * テーブルのユニーク行 ID カラムを含む結果セットを返す
 * @link http://www.php.net/manual/ja/function.db2-special-columns.php
 * @param connection resource <p>
 * IBM DB2、Cloudscape あるいは Apache Derby データベースへの有効な接続。
 * </p>
 * @param qualifier string <p>
 * OS/390 あるいは z/OS サーバー上で稼動している DB2 データベースの修飾子。
 * その他のデータベースの場合には NULL あるいは空の文字列を渡します。
 * </p>
 * @param schema string <p>
 * テーブルを含むスキーマ。
 * </p>
 * @param table_name string <p>
 * テーブルの名前。
 * </p>
 * @param scope int <p>
 * ユニーク行 ID の有効期間の最小値を表す整数値。
 * 以下の値のいずれかとなります。
 * <tr valign="top">
 * <td>整数値</td>
 * <td>SQL 定数</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>0</td>
 * <td>SQL_SCOPE_CURROW</td>
 * <td>行 ID は、カーソルがその行にある場合にのみ有効です。</td>
 * </tr>
 * <tr valign="top">
 * <td>1</td>
 * <td>SQL_SCOPE_TRANSACTION</td>
 * <td>行 ID は、そのトランザクションの間のみ有効です。</td>
 * </tr>
 * <tr valign="top">
 * <td>2</td>
 * <td>SQL_SCOPE_SESSION</td>
 * <td>行 ID は、その接続の間のみ有効です。</td>
 * </tr>
 * </p>
 * @return resource テーブルのユニーク行 ID 情報を含む結果セットの
 * ステートメントリソースを返します。
 * 行の内容は、以下のカラムで構成されています。
 * <tr valign="top">
 * <td>カラム名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>SCOPE</td>
 * <td>
 * <p>
 * <tr valign="top">
 * <td>整数値</td>
 * <td>SQL 定数</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>0</td>
 * <td>SQL_SCOPE_CURROW</td>
 * <td>行 ID は、カーソルがその行にある場合にのみ有効です。</td>
 * </tr>
 * <tr valign="top">
 * <td>1</td>
 * <td>SQL_SCOPE_TRANSACTION</td>
 * <td>行 ID は、そのトランザクションの間のみ有効です。</td>
 * </tr>
 * <tr valign="top">
 * <td>2</td>
 * <td>SQL_SCOPE_SESSION</td>
 * <td>行 ID は、その接続の間のみ有効です。</td>
 * </tr>
 * </p>
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>COLUMN_NAME</td>
 * <td>ユニークカラムの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>DATA_TYPE</td>
 * <td>カラムの SQL データ型。</td>
 * </tr>
 * <tr valign="top">
 * <td>TYPE_NAME</td>
 * <td>カラムの SQL データ型を文字列で表したもの。</td>
 * </tr>
 * <tr valign="top">
 * <td>COLUMN_SIZE</td>
 * <td>カラムのサイズを表す整数値。</td>
 * </tr>
 * <tr valign="top">
 * <td>BUFFER_LENGTH</td>
 * <td>
 * このカラムのデータを保存するために必要な最大のバイト数。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>DECIMAL_DIGITS</td>
 * <td>
 * カラムの位取り。位取りが適用できない場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>NUM_PREC_RADIX</td>
 * <td>
 * 10 (正確な数値データ型を表す)、
 * 2 (概数データ型を表す)、
 * あるいは NULL (基数が適用できないデータ型を表す)
 * のいずれか。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>PSEUDO_COLUMN</td>
 * <td>常に 1 を返します。</td>
 * </tr>
 */
function db2_special_columns ($connection, $qualifier, $schema, $table_name, $scope) {}

function db2_specialcolumns () {}

/**
 * インデックスの情報およびテーブルの統計情報を含む結果セットを返す
 * @link http://www.php.net/manual/ja/function.db2-statistics.php
 * @param connection resource <p>
 * IBM DB2、Cloudscape あるいは Apache Derby データベースへの有効な接続。
 * </p>
 * @param qualifier string <p>
 * OS/390 あるいは z/OS サーバー上で稼動している DB2 データベースの修飾子。
 * その他のデータベースの場合には NULL あるいは空の文字列を渡します。
 * </p>
 * @param schema string <p>
 * 対象となるテーブルを含むスキーマ。
 * このパラメータを NULL にすると、現在のユーザーのスキーマについての
 * 統計およびインデックスが返されます。
 * </p>
 * @param table_name string <p>
 * テーブルの名前。
 * </p>
 * @param unique bool <p>
 * 返されるインデックスの型を表す整数値。
 * 0
 * <p>
 * テーブルのユニークインデックスについての情報のみを返します。
 * </p>
 * @return resource 指定したパラメータに一致するテーブルの統計およびインデックスを含む
 * ステートメントリソースを返します。
 * 行の内容は、以下のカラムで構成されています。
 * <tr valign="top">
 * <td>カラム名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_CAT</td>
 * <td>
 * テーブルを含むカタログの名前。テーブルがカタログを保持していない場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_SCHEM</td>
 * <td>テーブルを含むスキーマの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_NAME</td>
 * <td>テーブルの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>NON_UNIQUE</td>
 * <td>
 * <p>
 * インデックスが一意でなければならないかどうか、
 * あるいはその行がテーブルの統計情報であるかどうかを表す整数値。
 * <tr valign="top">
 * <td>返り値</td>
 * <td>パラメータの型</td>
 * </tr>
 * <tr valign="top">
 * <td>0 (SQL_FALSE)</td>
 * <td>インデックスは、重複した値をとることができます。</td>
 * </tr>
 * <tr valign="top">
 * <td>1 (SQL_TRUE)</td>
 * <td>インデックスは、一意でなければなりません。</td>
 * </tr>
 * <tr valign="top">
 * <td>NULL</td>
 * <td>この行は、テーブル自身についての統計情報です。</td>
 * </tr>
 * </p>
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>INDEX_QUALIFIER</td>
 * <td>
 * インデックスの資格を満たすため、INDEX_NAME
 * の先頭に付加しなければならない修飾子を表す文字列。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>INDEX_NAME</td>
 * <td>インデックスの名前を表す文字列。</td>
 * </tr>
 * <tr valign="top">
 * <td>TYPE</td>
 * <td>
 * <p>
 * 結果セットのこの行に含まれる情報の型を表す整数値。
 * <tr valign="top">
 * <td>返り値</td>
 * <td>パラメータの型</td>
 * </tr>
 * <tr valign="top">
 * <td>0 (SQL_TABLE_STAT)</td>
 * <td>この行は、テーブル自身の統計情報を含みます。</td>
 * </tr>
 * <tr valign="top">
 * <td>1 (SQL_INDEX_CLUSTERED)</td>
 * <td>この行は、クラスタ化インデックスについての情報を含みます。</td>
 * </tr>
 * <tr valign="top">
 * <td>2 (SQL_INDEX_HASH)</td>
 * <td>この行は、ハッシュインデックスについての情報を含みます。</td>
 * </tr>
 * <tr valign="top">
 * <td>3 (SQL_INDEX_OTHER)</td>
 * <td>
 * この行は、クラスタ化もハッシュも行われていない
 * インデックスについての情報を含みます。
 * </td>
 * </tr>
 * </p>
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ORDINAL_POSITION</td>
 * <td>
 * インデックス内の、1 から始まるカラムの位置。
 * その行がテーブル自身についての統計情報を含んでいる場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>COLUMN_NAME</td>
 * <td>
 * インデックス内のカラムの名前。
 * その行がテーブル自身についての統計情報を含んでいる場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>ASC_OR_DESC</td>
 * <td>
 * カラムの並び順が昇順の場合は A、
 * 降順の場合は D、
 * その行がテーブル自身についての統計情報を含んでいる場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>CARDINALITY</td>
 * <td>
 * <p>
 * その行がインデックスの情報を含んでいる場合、このカラムには
 * インデックス内の一意な値の数を表す整数値が含まれます。
 * </p>
 * <p>
 * その行がテーブル自身についての情報を含んでいる場合、
 * このカラムにはテーブルの行数を表す整数値が含まれます。
 * </p>
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>PAGES</td>
 * <td>
 * <p>
 * その行がインデックスの情報を含んでいる場合、このカラムには
 * インデックスを保存するために使用しているページ数を表す整数値が含まれます。
 * </p>
 * <p>
 * その行がテーブル自身についての情報を含んでいる場合、このカラムには
 * テーブルを保存するために使用しているページ数を表す整数値が含まれます。
 * </p>
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>FILTER_CONDITION</td>
 * <td>常に NULL。</td>
 * </tr>
 */
function db2_statistics ($connection, $qualifier, $schema, $table_name, $unique) {}

/**
 * データベース内のテーブルおよび関連する権限情報を含む結果セットを返す
 * @link http://www.php.net/manual/ja/function.db2-table-privileges.php
 * @param connection resource <p>
 * IBM DB2、Cloudscape あるいは Apache Derby データベースへの有効な接続。
 * </p>
 * @param qualifier string[optional] <p>
 * OS/390 あるいは z/OS サーバー上で稼動している DB2 データベースの修飾子。
 * その他のデータベースの場合には NULL あるいは空の文字列を渡します。
 * </p>
 * @param schema string[optional] <p>
 * テーブルを含むスキーマ。このパラメータには、ワイルドカードとして
 * _ および %
 * を含む検索パターンを指定することができます。
 * </p>
 * @param table_name string[optional] <p>
 * テーブルの名前。このパラメータには、ワイルドカードとして
 * _ および %
 * を含む検索パターンを指定することができます。
 * </p>
 * @return resource 指定したパラメータに一致するテーブルの権限情報を含むステートメントリソースを返します。
 * 行の内容は、以下のカラムで構成されています。
 * <tr valign="top">
 * <td>カラム名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_CAT</td>
 * <td>
 * テーブルを含むカタログの名前。テーブルがカタログを保持していない場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_SCHEM</td>
 * <td>テーブルを含むスキーマの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_NAME</td>
 * <td>テーブルの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>GRANTOR</td>
 * <td>その権限を与えたユーザーの認証 ID。</td>
 * </tr>
 * <tr valign="top">
 * <td>GRANTEE</td>
 * <td>その権限を与えられたユーザーの認証 ID。</td>
 * </tr>
 * <tr valign="top">
 * <td>PRIVILEGE</td>
 * <td>
 * 与えられた権限。ALTER、
 * CONTROL、DELETE、INDEX、INSERT、REFERENCES、SELECT あるいは UPDATE
 * のいずれかです。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>IS_GRANTABLE</td>
 * <td>
 * grantee が、この権限を他のユーザーに与えることができるかどうかを、
 * 文字列 "YES" あるいは "NO" で表す。
 * </td>
 * </tr>
 */
function db2_table_privileges ($connection, $qualifier = null, $schema = null, $table_name = null) {}

function db2_tableprivileges () {}

/**
 * データベース内のテーブルおよび関連するメタデータを含む結果セットを返す
 * @link http://www.php.net/manual/ja/function.db2-tables.php
 * @param connection resource <p>
 * IBM DB2、Cloudscape あるいは Apache Derby データベースへの有効な接続。
 * </p>
 * @param qualifier string[optional] <p>
 * OS/390 あるいは z/OS サーバー上で稼動している DB2 データベースの修飾子。
 * その他のデータベースの場合には NULL あるいは空の文字列を渡します。
 * </p>
 * @param schema string[optional] <p>
 * テーブルを含むスキーマ。このパラメータでは、ワイルドカードとして
 * _ および %
 * を含む検索パターンを使用可能です。
 * </p>
 * @param table_name string[optional] 
 * @param table_type string[optional] 
 * @return resource 指定したパラメータに一致するテーブルの情報を含む結果セットのリソースを返します。
 * 行の内容は、以下のカラムで構成されています。
 * <tr valign="top">
 * <td>カラム名</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_CAT</td>
 * <td>
 * テーブルを含むカタログ。テーブルがカタログを保持していない場合は NULL。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_SCHEM</td>
 * <td>テーブルを含むスキーマの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_NAME</td>
 * <td>テーブルの名前。</td>
 * </tr>
 * <tr valign="top">
 * <td>TABLE_TYPE</td>
 * <td>テーブルの型識別子。</td>
 * </tr>
 * <tr valign="top">
 * <td>REMARKS</td>
 * <td>テーブルの説明。</td>
 * </tr>
 */
function db2_tables ($connection, $qualifier = null, $schema = null, $table_name = null, $table_type = null) {}

/**
 * SQL 文を直接実行する
 * @link http://www.php.net/manual/ja/function.db2-exec.php
 * @param connection resource <p>
 * db2_connect あるいは db2_pconnect
 * が返した有効なデータベース接続リソース。
 * </p>
 * @param statement string <p>
 * SQL 文。パラメータマーカを含めることはできません。
 * </p>
 * @param options array[optional] <p>
 * 文のオプションを含む連想配列。
 * データベースサーバーがその機能をサポートしている場合に、
 * このパラメータを使用してスクロール可能なカーソルの使用を
 * 要求することができます。
 * </p>
 * <p>
 * オプションについての説明は
 * db2_set_option を参照ください。
 * </p>
 * @return resource SQL 文の実行に成功した場合にステートメントリソース、
 * SQL 文の実行に失敗した場合に FALSE を返します。
 */
function db2_exec ($connection, $statement, array $options = null) {}

/**
 * 実行する SQL 文を準備する
 * @link http://www.php.net/manual/ja/function.db2-prepare.php
 * @param connection resource <p>
 * db2_connect あるいは db2_pconnect
 * が返した有効なデータベース接続リソース。
 * </p>
 * @param statement string <p>
 * ひとつ以上のパラメータマーカを含む SQL 文。
 * </p>
 * @param options array[optional] <p>
 * 文のオプションを含む連想配列。
 * データベースサーバーがその機能をサポートしている場合に、
 * このパラメータを使用してスクロール可能なカーソルの使用を
 * 要求することができます。
 * </p>
 * <p>
 * オプションについての説明は
 * db2_set_option を参照ください。
 * </p>
 * @return resource SQL 文のパースに成功し、データベースサーバー内で正しく準備された場合に
 * ステートメントリソースを返します。データベースサーバーがエラーを返した場合に
 * FALSE を返します。返されたエラーの詳細を調べるには、
 * db2_stmt_error あるいは db2_stmt_errormsg
 * をコールします。
 */
function db2_prepare ($connection, $statement, array $options = null) {}

/**
 * プリペアドステートメントを実行する
 * @link http://www.php.net/manual/ja/function.db2-execute.php
 * @param stmt resource <p>
 * db2_prepare が返すプリペアドステートメント。
 * </p>
 * @param parameters array[optional] <p>
 * プリペアドステートメント内に含まれるパラメータマーカに対応する、
 * 入力パラメータの配列。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function db2_execute ($stmt, array $parameters = null) {}

function db2_execute_many () {}

/**
 * 直近の SQL 文のエラーメッセージを含む文字列を返す
 * @link http://www.php.net/manual/ja/function.db2-stmt-errormsg.php
 * @param stmt resource[optional] <p>
 * 有効なステートメントリソース。
 * </p>
 * @return string SQL 文の発行により直近に発生したエラーを表す
 * エラーメッセージおよび SQLSTATE を返します。
 */
function db2_stmt_errormsg ($stmt = null) {}

/**
 * 直近の接続エラーメッセージおよび SQLCODE を返す
 * @link http://www.php.net/manual/ja/function.db2-conn-errormsg.php
 * @param connection resource[optional] <p>
 * 当初は成功したものの、その後に無効になった接続に
 * 関連付けられた接続リソース。
 * </p>
 * @return string 失敗した接続試行の結果を表すエラーメッセージおよび SQLSTATE を返します。
 * 直近の接続試行に関連するエラーがない場合には、
 * db2_conn_errormsg はn空の文字列を返します。
 */
function db2_conn_errormsg ($connection = null) {}

/**
 * 直近の接続から返された SQLSTATE を含む文字列を返す
 * @link http://www.php.net/manual/ja/function.db2-conn-error.php
 * @param connection resource[optional] <p>
 * 当初は成功したものの、その後に無効になった接続に
 * 関連付けられた接続リソース。
 * </p>
 * @return string 失敗した接続試行の結果を表す SQLSTATE を返します。
 * 直近の接続試行に関連するエラーがない場合には空の文字列を返します。
 */
function db2_conn_error ($connection = null) {}

/**
 * SQL 文が返す SQLSTATE を含む文字列を返す
 * @link http://www.php.net/manual/ja/function.db2-stmt-error.php
 * @param stmt resource[optional] <p>
 * 有効なステートメントリソース。
 * </p>
 * @return string SQLSTATE を含む文字列を返します。
 */
function db2_stmt_error ($stmt = null) {}

/**
 * ストアドプロシージャから、次の結果セットを要求する
 * @link http://www.php.net/manual/ja/function.db2-next-result.php
 * @param stmt resource <p>
 * db2_exec あるいは
 * db2_execute から返されるプリペアドステートメント。
 * </p>
 * @return resource ストアドプロシージャが別の結果セットを返している場合には
 * 次の結果セットを含む新しいステートメントリソース、
 * 別の結果セットを返していない場合には FALSE を返します。
 */
function db2_next_result ($stmt) {}

/**
 * 結果セットに含まれるフィールドの数を返す
 * @link http://www.php.net/manual/ja/function.db2-num-fields.php
 * @param stmt resource <p>
 * 結果セットを含む有効なステートメントリソース。
 * </p>
 * @return int 指定したステートメントリソースに関連付けられた結果セット内の
 * フィールドの数を表す整数値を返します。ステートメントリソースが
 * 不正な値の場合には FALSE を返します。
 */
function db2_num_fields ($stmt) {}

/**
 * SQL 文によって変更された行の数を返す
 * @link http://www.php.net/manual/ja/function.db2-num-rows.php
 * @param stmt resource <p>
 * 結果セットを含む有効な stmt リソース。
 * </p>
 * @return int 指定したステートメントハンドルによって発行された、
 * 直近の SQL 文によって変更された行の数を返します。
 */
function db2_num_rows ($stmt) {}

/**
 * 結果セット内のカラムの名前を返す
 * @link http://www.php.net/manual/ja/function.db2-field-name.php
 * @param stmt resource <p>
 * 結果セットを含むステートメントリソースを指定します。
 * </p>
 * @param column mixed <p>
 * 結果セット内のカラムを指定します。0 から始まるインデックス、
 * あるいはカラム名を表す文字列のいずれかが使用可能です。
 * </p>
 * @return string 指定したカラムの名前を含む文字列を返します。
 * 結果セット内にそのカラムが存在しない場合には、
 * db2_field_name は FALSE を返します。
 */
function db2_field_name ($stmt, $column) {}

/**
 * カラムを表示するために必要な最大のバイト数を返す
 * @link http://www.php.net/manual/ja/function.db2-field-display-size.php
 * @param stmt resource <p>
 * 結果セットを含むステートメントリソースを指定します。
 * </p>
 * @param column mixed <p>
 * 結果セット内のカラムを指定します。0 から始まるインデックス、
 * あるいはカラム名を表す文字列のいずれかが使用可能です。
 * </p>
 * @return int 指定したカラムを表示するために必要な最大バイト数を表す整数値を返します。
 * 結果セット内にそのカラムが存在しない場合には、
 * db2_field_display_size は FALSE を返します。
 */
function db2_field_display_size ($stmt, $column) {}

/**
 * 結果セット内の指定したカラムの位置を返す
 * @link http://www.php.net/manual/ja/function.db2-field-num.php
 * @param stmt resource <p>
 * 結果セットを含むステートメントリソースを指定します。
 * </p>
 * @param column mixed <p>
 * 結果セット内のカラムを指定します。0 から始まるインデックス、
 * あるいはカラム名を表す文字列のいずれかが使用可能です。
 * </p>
 * @return int 結果セット内でのカラムの位置を、0 から始まる整数値で返します。
 * 結果セット内にそのカラムが存在しない場合には、
 * db2_field_num は FALSE を返します。
 */
function db2_field_num ($stmt, $column) {}

/**
 * 結果セット内の指定したカラムの精度を返す
 * @link http://www.php.net/manual/ja/function.db2-field-precision.php
 * @param stmt resource <p>
 * 結果セットを含むステートメントリソースを指定します。
 * </p>
 * @param column mixed <p>
 * 結果セット内のカラムを指定します。0 から始まるインデックス、
 * あるいはカラム名を表す文字列のいずれかが使用可能です。
 * </p>
 * @return int 指定したカラムの精度を表す整数値を返します。
 * 結果セット内にそのカラムが存在しない場合には、
 * db2_field_precision は FALSE を返します。
 */
function db2_field_precision ($stmt, $column) {}

/**
 * 結果セット内の指定したカラムの位取りを返す
 * @link http://www.php.net/manual/ja/function.db2-field-scale.php
 * @param stmt resource <p>
 * 結果セットを含むステートメントリソースを指定します。
 * </p>
 * @param column mixed <p>
 * 結果セット内のカラムを指定します。0 から始まるインデックス、
 * あるいはカラム名を表す文字列のいずれかが使用可能です。
 * </p>
 * @return int 指定したカラムの位取りを整数値で返します。
 * 結果セット内にそのカラムが存在しない場合には、
 * db2_field_scale は FALSE を返します。
 */
function db2_field_scale ($stmt, $column) {}

/**
 * 結果セット内の指定したカラムのデータ型を返す
 * @link http://www.php.net/manual/ja/function.db2-field-type.php
 * @param stmt resource <p>
 * 結果セットを含むステートメントリソースを指定します。
 * </p>
 * @param column mixed <p>
 * 結果セット内のカラムを指定します。0 から始まるインデックス、
 * あるいはカラム名を表す文字列のいずれかが使用可能です。
 * </p>
 * @return string 指定したカラムに定義されているデータ型を表す文字列を返します。
 * 結果セット内にそのカラムが存在しない場合には、
 * db2_field_type は FALSE を返します。
 */
function db2_field_type ($stmt, $column) {}

/**
 * 結果セット内の指定したカラムの現在値の幅を返す
 * @link http://www.php.net/manual/ja/function.db2-field-width.php
 * @param stmt resource <p>
 * 結果セットを含むステートメントリソースを指定します。
 * </p>
 * @param column mixed <p>
 * 結果セット内のカラムを指定します。0 から始まるインデックス、
 * あるいはカラム名を表す文字列のいずれかが使用可能です。
 * </p>
 * @return int 結果セット内の文字型あるいはバイナリデータ型のカラムについて、
 * その幅を整数値で返します。
 * 結果セット内にそのカラムが存在しない場合には、
 * db2_field_width は FALSE を返します。
 */
function db2_field_width ($stmt, $column) {}

/**
 * ステートメントリソースが使用しているカーソルの型を返す
 * @link http://www.php.net/manual/ja/function.db2-cursor-type.php
 * @param stmt resource <p>
 * 有効なステートメントリソース。
 * </p>
 * @return int ステートメントリソースが前進のみのカーソルを使用している場合に
 * DB2_FORWARD_ONLY、スクロール可能なカーソルを
 * 使用している場合に DB2_SCROLLABLE を返します。
 */
function db2_cursor_type ($stmt) {}

/**
 * トランザクションをロールバックする
 * @link http://www.php.net/manual/ja/function.db2-rollback.php
 * @param connection resource <p>
 * db2_connect あるいは db2_pconnect
 * が返した有効なデータベース接続リソース。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function db2_rollback ($connection) {}

/**
 * 指定されたステートメントリソースに関連付けられたリソースを開放する
 * @link http://www.php.net/manual/ja/function.db2-free-stmt.php
 * @param stmt resource <p>
 * 有効なステートメントリソース。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function db2_free_stmt ($stmt) {}

/**
 * 結果セットの行からひとつのカラムを返す
 * @link http://www.php.net/manual/ja/function.db2-result.php
 * @param stmt resource <p>
 * 有効な stmt リソース。
 * </p>
 * @param column mixed <p>
 * 結果セット内のカラムの位置を表す 0 から始まるインデックス、
 * あるいはカラム名を表す文字列。
 * </p>
 * @return mixed 指定したフィールドが結果セットに存在する場合にそのフィールドの値を返します。
 * フィールドが存在しない場合には NULL を返し、警告を発生させます。
 */
function db2_result ($stmt, $column) {}

/**
 * 結果セットポインタを次の行あるいは要求された行に設定する
 * @link http://www.php.net/manual/ja/function.db2-fetch-row.php
 * @param stmt resource <p>
 * 有効な stmt リソース。
 * </p>
 * @param row_number int[optional] <p>
 * スクロール可能なカーソルの場合に、結果セットの行番号を指定します。
 * 行番号は 1 から始まります。
 * </p>
 * @return bool 結果セットに指定した行が存在する場合に TRUE、存在しない場合に
 * FALSE を返します。
 */
function db2_fetch_row ($stmt, $row_number = null) {}

/**
 * 結果セット内の行を表す、カラム名をインデックスとする配列を返す
 * @link http://www.php.net/manual/ja/function.db2-fetch-assoc.php
 * @param stmt resource <p>
 * 結果セットを含む有効な stmt リソース。
 * </p>
 * @param row_number int[optional] <p>
 * 結果セット内の 1 から始まる行番号を指定します。
 * 結果セットで前進のみのカーソルを使用している場合にこのパラメータを渡すと、
 * PHP の警告が発生します。
 * </p>
 * @return array 結果セットの次の行あるいは要求した行のデータを表す、
 * カラム名をインデックスとした連想配列を返します。
 * 結果セットに行がもうない場合、あるいは
 * row_number
 * で指定された行が結果セットに存在しない場合に FALSE を返します。
 */
function db2_fetch_assoc ($stmt, $row_number = null) {}

/**
 * 結果セット内の行を表す、カラム位置をインデックスとする配列を返す
 * @link http://www.php.net/manual/ja/function.db2-fetch-array.php
 * @param stmt resource <p>
 * 結果セットを含む有効な stmt リソース。
 * </p>
 * @param row_number int[optional] <p>
 * 結果セット内の 1 から始まる行番号を指定します。
 * 結果セットで前進のみのカーソルを使用している場合にこのパラメータを渡すと、
 * PHP の警告が発生します。
 * </p>
 * @return array 結果セットの次の行あるいは要求した行のデータを表す配列を返します。
 * 配列の 0 から始まるインデックスが、カラムの位置を表します。
 * 結果セットに行がもうない場合、あるいは
 * row_number
 * で指定された行が結果セットに存在しない場合に FALSE を返します。
 */
function db2_fetch_array ($stmt, $row_number = null) {}

/**
 * 結果セット内の行を表す、
   カラム位置およびカラム名の両方をインデックスとする配列を返す
 * @link http://www.php.net/manual/ja/function.db2-fetch-both.php
 * @param stmt resource <p>
 * 結果セットを含む有効な stmt リソース。
 * </p>
 * @param row_number int[optional] <p>
 * 結果セット内の 1 から始まる行番号を指定します。
 * 結果セットで前進のみのカーソルを使用している場合にこのパラメータを渡すと、
 * PHP の警告が発生します。
 * </p>
 * @return array 結果セットの次の行あるいは要求した行のデータを表す、
 * カラム名および (0 から始まる) カラム番号の両方をインデックスとした連想配列を返します。
 * 結果セットに行がもうない場合、あるいは
 * row_number
 * で指定された行が結果セットに存在しない場合に FALSE を返します。
 */
function db2_fetch_both ($stmt, $row_number = null) {}

/**
 * 結果セットに関連付けられたリソースを開放する
 * @link http://www.php.net/manual/ja/function.db2-free-result.php
 * @param stmt resource <p>
 * 有効なステートメントリソース。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function db2_free_result ($stmt) {}

/**
 * 接続リソースあるいはステートメントリソースのオプションを設定する
 * @link http://www.php.net/manual/ja/function.db2-set-option.php
 * @param resource resource <p>
 * db2_prepare が返す有効なステートメントリソースか、
 * あるいは db2_connect や
 * db2_pconnect が返す有効な接続リソース。
 * </p>
 * @param options array <p>
 * ステートメントあるいは接続のオプションを含む連想配列。
 * このパラメータは、自動コミットの値を変更したりカーソルの型を
 * (スクロール可能、あるいは前進のみに) 変更したり、結果セットに表示されるカラム名を
 * (小文字、大文字、あるいは元のままに) 設定したりする際に使用します。
 * autocommit
 * <p>
 * DB2_AUTOCOMMIT_ON を渡すと、
 * 指定した接続リソースの自動コミットをオンにします。
 * </p>
 * <p>
 * DB2_AUTOCOMMIT_OFF を渡すと、
 * 指定した接続リソースの自動コミットをオフにします。
 * </p>
 * @param type int <p>
 * この関数に渡すリソースの型を、整数値で指定します。
 * リソースの型とこの値は必ず一致していなければなりません。
 * </p>
 * <p>
 * 1 は、
 * 接続リソースがこの関数に渡されることを表します。
 * </p>
 * <p>
 * 1 以外の整数を指定すると、
 * ステートメントリソースがこの関数に渡されることを表します。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function db2_set_option ($resource, array $options, $type) {}

function db2_setoption () {}

/**
 * 結果セット内の行を表す、カラムをプロパティとするオブジェクトを返す
 * @link http://www.php.net/manual/ja/function.db2-fetch-object.php
 * @param stmt resource <p>
 * 結果セットを含む有効な stmt リソース。
 * </p>
 * @param row_number int[optional] <p>
 * 結果セット内の 1 から始まる行番号を指定します。
 * 結果セットで前進のみのカーソルを使用している場合にこのパラメータを渡すと、
 * PHP の警告が発生します。
 * </p>
 * @return object 結果セット内の行を表すオブジェクトを返します。
 * オブジェクトのプロパティが、結果セット内のカラム名に対応します。
 * </p>
 * <p>
 * IBM DB2、Cloudscape および Apache Derby データベースサーバーは、
 * 通常はカラム名を大文字として扱います。そのため、
 * オブジェクトのプロパティも同じようになります。
 * </p>
 * <p>
 * SELECT 文の中でスカラ関数をコールすることでカラムの値を変更している場合、
 * データベースサーバーは、そのカラムの名前としてカラム番号を返します。
 * もし何らかの意味のある名前をオブジェクトのプロパティとして使用したいのなら、
 * AS 句を使用して結果セット内のカラムに名前を割り当てる必要があります。
 * </p>
 * <p>
 * 行が取得されなかった場合は FALSE を返します。
 */
function db2_fetch_object ($stmt, $row_number = null) {}

/**
 * DB2 データベースサーバーの情報をプロパティに保持するオブジェクトを返す
 * @link http://www.php.net/manual/ja/function.db2-server-info.php
 * @param connection resource <p>
 * アクティブな DB2 クライアント接続を指定します。
 * </p>
 * @return object 成功した場合にオブジェクト、失敗した場合に FALSE を返します。
 */
function db2_server_info ($connection) {}

/**
 * DB2 データベースクライアントの情報をプロパティに保持するオブジェクトを返す
 * @link http://www.php.net/manual/ja/function.db2-client-info.php
 * @param connection resource <p>
 * アクティブな DB2 クライアント接続を指定します。
 * </p>
 * @return object 成功した場合にオブジェクト、失敗した場合に FALSE を返します。
 */
function db2_client_info ($connection) {}

/**
 * 特定の文字をエスケープする
 * @link http://www.php.net/manual/ja/function.db2-escape-string.php
 * @param string_literal string <p>
 * 変更すべき特殊文字を含む文字列。
 * \x00、
 * \n、\r、\、
 * '、" および \x1a
 * について、その前にバックスラッシュを追加します。
 * </p>
 * @return string string_literal の中の上で挙げた文字について、
 * その前にバックスラッシュを追加した文字列を返します。
 */
function db2_escape_string ($string_literal) {}

/**
 * LOB ファイルから、ユーザーが定義したサイズの内容を取得する
 * @link http://www.php.net/manual/ja/function.db2-lob-read.php
 * @param stmt resource <p>
 * LOB データを含む有効な stmt リソース。
 * </p>
 * @param colnum int <p>
 * stmt リソースの結果セット内の、有効なカラム番号。
 * </p>
 * @param length int <p>
 * stmt リソースから取得する LOB データのサイズ。
 * </p>
 * @return string 指定したサイズのデータを返します。データが取得できない場合は
 * FALSE を返します。
 */
function db2_lob_read ($stmt, $colnum, $length) {}

/**
 * ステートメントリソースあるいは接続リソースからオプションの値を取得する
 * @link http://www.php.net/manual/ja/function.db2-get-option.php
 * @param resource resource <p>
 * db2_prepare が返す有効なステートメントリソース、
 * あるいは
 * db2_connect や
 * db2_pconnect が返す有効な接続リソース。
 * </p>
 * @param option string <p>
 * ステートメントや接続の、有効なオプション。
 * 以下の新しいオプションが、ibm_db2 バージョン 1.6.0 以降で使用可能です。
 * これらは、有用な情報を提供します。これらの情報は、
 * db2_get_option によって取得します。
 * <p>
 * 以前のバージョンの ibm_db2 では、これらの新しいオプションはサポートしていません。
 * </p>
 * <p>
 * 各オプションの値を設定する際、
 * サーバーによっては指定したすべての内容を処理できないことがあります。
 * その場合、値が切り詰められます。
 * </p>
 * <p>
 * 指定したオプションが正しく変換されてホストシステムに送信されることを確実にするには、
 * A から Z までの文字と 0 から 9 までの数字、そしてアンダースコア
 * (_) とピリオド (.) のみを使用するようにします。
 * </p>
 * userid
 * <p>
 * SQL_ATTR_INFO_USERID -
 * ヌル終端の文字列へのポインタで、DB2 接続の際にホストデータベースサーバーに送信する
 * クライアントのユーザー ID として使用します。
 * <p>
 * z/OS および OS/390 サーバー版の DB2 は 16 文字までの長さをサポートしています。
 * このユーザー ID を、認証時に使用するユーザー ID と混同しないでください。
 * これは識別のためだけに使用するものであり、認証には用いられません。
 * </p>
 * </p>
 * @return string 成功した場合に接続属性の現在の設定内容、
 * 失敗した場合に FALSE を返します。
 */
function db2_get_option ($resource, $option) {}

function db2_getoption () {}

/**
 * この接続上で最後に成功した insert クエリが自動生成した ID を返す
 * @link http://www.php.net/manual/ja/function.db2-last-insert-id.php
 * @param resource resource <p>
 * db2_connect あるいは db2_pconnect
 * が返す接続リソース。
 * このパラメータにはステートメントリソースや結果セットリソースを指定することはできません。
 * </p>
 * @return string この接続上で最後に成功した insert クエリが自動生成した ID を返します。
 */
function db2_last_insert_id ($resource) {}


/**
 * バイナリデータをそのままの形式で返します。デフォルトのモードです。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_BINARY', 1);

/**
 * バイナリデータを十六進表現にエンコードし、ASCII 文字列として返します。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_CONVERT', 2);

/**
 * バイナリデータを NULL 値に変換します。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_PASSTHRU', 3);

/**
 * ステートメントのリソースとして、スクロール可能なカーソルを指定します。
 * このモードでは結果セット内の行へのランダムアクセスが可能となりますが、
 * 現在は IBM DB2 Universal Database でしかサポートされていません。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_SCROLLABLE', 1);

/**
 * ステートメントのリソースとして、前進のみ可能なカーソルを指定します。
 * これはデフォルトのカーソル型であり、
 * すべてのデータベースサーバーでサポートされています。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_FORWARD_ONLY', 0);

/**
 * PHP 変数を、ストアドプロシージャの IN パラメータとしてバインドします。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_PARAM_IN', 1);

/**
 * PHP 変数を、ストアドプロシージャの OUT パラメータとしてバインドします。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_PARAM_OUT', 4);

/**
 * PHP 変数を、ストアドプロシージャの INOUT パラメータとしてバインドします。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_PARAM_INOUT', 2);

/**
 * カラムを直接ファイルにバインドし、そのデータを読み込みます。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_PARAM_FILE', 11);
define ('DB2_TRUSTED_CONTEXT_ENABLE', 2561);

/**
 * 自動コミットを有効にします。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_AUTOCOMMIT_ON', 1);

/**
 * 自動コミットを無効にします。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_AUTOCOMMIT_OFF', 0);
define ('DB2_ROWCOUNT_PREFETCH_ON', 1);
define ('DB2_ROWCOUNT_PREFETCH_OFF', 0);

/**
 * 指定したステートメントリソースについて、遅延プリペアを有効にします。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_DEFERRED_PREPARE_ON', 1);

/**
 * 指定したステートメントリソースについて、遅延プリペアを無効にします。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_DEFERRED_PREPARE_OFF', 0);

/**
 * 変数を、データ型 DOUBLE、FLOAT あるいは REAL にバインドします。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_DOUBLE', 8);

/**
 * 変数を、データ型 SMALLINT、INTEGER あるいは BIGINT にバインドします。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_LONG', 4);

/**
 * 変数を、データ型 CHAR あるいは VARCHAR にバインドします。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_CHAR', 1);
define ('DB2_XML', -370);

/**
 * カラム名の大文字小文字を変換せずに返します。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_CASE_NATURAL', 0);

/**
 * カラム名を小文字に変換して返します。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_CASE_LOWER', 1);

/**
 * カラム名を大文字に変換して返します。
 * @link http://www.php.net/manual/ja/ibm-db2.constants.php
 */
define ('DB2_CASE_UPPER', 2);

// End of ibm_db2 v.1.9.4
?>
