<?php

// Start of mcrypt v.

/**
 * 非推奨: ECB モードでデータを暗号化/復号する
 * @link http://www.php.net/manual/ja/function.mcrypt-ecb.php
 * @param cipher int 
 * @param key string 
 * @param data string 
 * @param mode int 
 * @return string 
 */
function mcrypt_ecb ($cipher, $key, $data, $mode) {}

/**
 * CBC モードでデータを暗号化/復号する
 * @link http://www.php.net/manual/ja/function.mcrypt-cbc.php
 * @param cipher int 
 * @param key string 
 * @param data string 
 * @param mode int 
 * @param iv string[optional] 
 * @return string 
 */
function mcrypt_cbc ($cipher, $key, $data, $mode, $iv = null) {}

/**
 * CFB モードでデータを暗号化/復号する
 * @link http://www.php.net/manual/ja/function.mcrypt-cfb.php
 * @param cipher int 
 * @param key string 
 * @param data string 
 * @param mode int 
 * @param iv string 
 * @return string 
 */
function mcrypt_cfb ($cipher, $key, $data, $mode, $iv) {}

/**
 * OFB モードでデータを暗号化/復号する
 * @link http://www.php.net/manual/ja/function.mcrypt-ofb.php
 * @param cipher int 
 * @param key string 
 * @param data string 
 * @param mode int 
 * @param iv string 
 * @return string 
 */
function mcrypt_ofb ($cipher, $key, $data, $mode, $iv) {}

/**
 * 指定した暗号のキーの長さを得る
 * @link http://www.php.net/manual/ja/function.mcrypt-get-key-size.php
 * @param cipher int MCRYPT_暗号名 定数のいずれか、
 * あるいはアルゴリズム名をあらわす文字列。</p>
 * @return int そのアルゴリズムでサポートする最長のキーサイズをバイト数で返します。
 * 失敗した場合に FALSE を返します.
 */
function mcrypt_get_key_size ($cipher) {}

/**
 * 指定した暗号のブロックサイズを得る
 * @link http://www.php.net/manual/ja/function.mcrypt-get-block-size.php
 * @param cipher int MCRYPT_暗号名 定数のいずれか、
 * あるいはアルゴリズム名をあらわす文字列。</p>
 * @return int ブロックサイズを整数値で返します。
 */
function mcrypt_get_block_size ($cipher) {}

/**
 * 指定した暗号の名前を得る
 * @link http://www.php.net/manual/ja/function.mcrypt-get-cipher-name.php
 * @param cipher int MCRYPT_暗号名 定数のいずれか、
 * あるいはアルゴリズム名をあらわす文字列。</p>
 * @return string 暗号の名前、あるいは暗号が存在しない場合に FALSE を返します。
 */
function mcrypt_get_cipher_name ($cipher) {}

/**
 * 乱数ソースから初期化ベクトル(IV)を生成する
 * @link http://www.php.net/manual/ja/function.mcrypt-create-iv.php
 * @param size int <p>
 * IV のサイズ。
 * </p>
 * @param source int[optional] <p>
 * IV のソース。
 * MCRYPT_RAND (システムの乱数生成器)、
 * MCRYPT_DEV_RANDOM (/dev/random
 * からデータを読む)および MCRYPT_DEV_URANDOM
 * (/dev/urandom からデータを読む) を指定できます。
 * 5.3.0 より前は、 Windows でサポートされているのは MCRYPT_RAND
 * のみでした。
 * </p>
 * <p>
 * MCRYPT_RAND を使用する場合、乱数生成器を初期化するために、
 * 必ず mcrypt_create_iv の前に srand
 * をコールしてください。rand のように、自動的に
 * 初期化されるわけではありません。
 * </p>
 * @return string 初期化ベクトル、あるいはエラー時に FALSE を返します。
 */
function mcrypt_create_iv ($size, $source = null) {}

/**
 * サポートされる全ての暗号を配列として取得する
 * @link http://www.php.net/manual/ja/function.mcrypt-list-algorithms.php
 * @param lib_dir string[optional] <p>
 * すべてのアルゴリズムが存在するディレクトリを指定します。
 * 指定しない場合は、php.ini の
 * mcrypt.algorithms_dir ディレクティブを使用します。
 * </p>
 * @return array サポートするすべてのアルゴリズムを配列で返します。
 */
function mcrypt_list_algorithms ($lib_dir = null) {}

/**
 * サポートされる全てのモードの配列を取得する
 * @link http://www.php.net/manual/ja/function.mcrypt-list-modes.php
 * @param lib_dir string[optional] <p>
 * すべてのモードが存在するディレクトリを指定します。
 * 指定しない場合は、
 * php.ini ディレクティブ mcrypt.modes_dir を使用します。
 * </p>
 * @return array サポートするすべてのモードを配列で返します。
 */
function mcrypt_list_modes ($lib_dir = null) {}

/**
 * 指定した暗号/モードの組み合わせに属する IV の大きさを返す
 * @link http://www.php.net/manual/ja/function.mcrypt-get-iv-size.php
 * @param cipher string MCRYPT_暗号名 定数のいずれか、
 * あるいはアルゴリズム名をあらわす文字列。</p>
 * @param mode string 定数 MCRYPT_MODE_モード名、あるいは文字列
 * "ecb", "cbc", "cfb", "ofb", "nofb" ,"stream" のいずれか。</p>
 * <p>
 * ECB モードでは IV は要求されないため、IV は無視されます。
 * 暗号化と復号の際には、同じ IV(開始位置)を必要とします。さもないと
 * 暗号化処理は失敗します。
 * </p>
 * @return int 初期化ベクトル(IV)の大きさをバイト数で返します。
 * エラーの際には FALSE を返します。IV
 * が指定した暗号/モードで無視される場合には、ゼロを返します。
 */
function mcrypt_get_iv_size ($cipher, $mode) {}

/**
 * 指定したパラメータでプレーンテキストを暗号化する
 * @link http://www.php.net/manual/ja/function.mcrypt-encrypt.php
 * @param cipher string MCRYPT_暗号名 定数のいずれか、
 * あるいはアルゴリズム名をあらわす文字列。</p>
 * @param key string <p>
 * データを暗号化する際のキー。必要なキー長よりも小さい場合には、
 * '\0' で埋められます。キーにはASCII
 * 文字列を使わない方が良いです。
 * </p>
 * <p>
 * 文字列からキーを生成するにはmhash関数を使用することを推奨します。
 * </p>
 * @param data string <p>
 * 指定した cipher および mode で暗号化するデータ。
 * データの大きさが n * blocksize でない場合、データは、
 * '\0'で埋められます。
 * </p>
 * <p>
 * 返される暗号化されたテキストは、data
 * で指定したデータの大きさよりも大きくなる可能性があります。
 * </p>
 * @param mode string 定数 MCRYPT_MODE_モード名、あるいは文字列
 * "ecb", "cbc", "cfb", "ofb", "nofb" ,"stream" のいずれか。</p>
 * @param iv string[optional] CBC, CFB, OFB モードおよび
 * STREAM モードのいくつかのアルゴリズムの初期化の際に使用されます。
 * アルゴリズムで必要とする IV を指定しない場合、この関数は警告を発生し、
 * すべてのバイトを "&mcrypt.parameter.iv;" に設定した IV を使用します。</p>
 * @return string 暗号化されたデータを文字列で返します。
 */
function mcrypt_encrypt ($cipher, $key, $data, $mode, $iv = null) {}

/**
 * 指定したパラメータで暗号化されたテキストを復号する
 * @link http://www.php.net/manual/ja/function.mcrypt-decrypt.php
 * @param cipher string MCRYPT_暗号名 定数のいずれか、
 * あるいはアルゴリズム名をあらわす文字列。</p>
 * @param key string <p>
 * データを暗号化する際のキー。
 * 必要なキー長よりも短い場合には、'\0' で埋められます。
 * </p>
 * @param data string <p>
 * このデータが、指定した cipher および mode で復号されます。
 * データの大きさが n * blocksize でない場合、データは、
 * '\0' で埋められます。
 * </p>
 * @param mode string 定数 MCRYPT_MODE_モード名、あるいは文字列
 * "ecb", "cbc", "cfb", "ofb", "nofb" ,"stream" のいずれか。</p>
 * @param iv string[optional] CBC, CFB, OFB モードおよび
 * STREAM モードのいくつかのアルゴリズムの初期化の際に使用されます。
 * アルゴリズムで必要とする IV を指定しない場合、この関数は警告を発生し、
 * すべてのバイトを "&mcrypt.parameter.iv;" に設定した IV を使用します。</p>
 * @return string 復号されたデータを文字列で返します。
 */
function mcrypt_decrypt ($cipher, $key, $data, $mode, $iv = null) {}

/**
 * 使用するアルゴリズムおよびモードのモジュールをオープンする
 * @link http://www.php.net/manual/ja/function.mcrypt-module-open.php
 * @param algorithm string MCRYPT_暗号名 定数のいずれか、
 * あるいはアルゴリズム名をあらわす文字列。</p>
 * @param algorithm_directory string <p>
 * 暗号化モジュールの位置を指定する際には
 * algorithm_directory を使います。
 * ディレクトリ名を指定した場合には、これが使用されます。
 * これらの一つに空の文字列("")を指定した場合、php.ini ディレクティブ
 * mcrypt.algorithms_dir に設定された値を使います。
 * これらが設定されていない場合、libmcrypt をコンパイルした際の
 * デフォルトのディレクトリ (通常は/usr/local/lib/libmcrypt)
 * を使います。
 * </p>
 * @param mode string 定数 MCRYPT_MODE_モード名、あるいは文字列
 * "ecb", "cbc", "cfb", "ofb", "nofb" ,"stream" のいずれか。</p>
 * @param mode_directory string <p>
 * 暗号化モジュールの位置を指定する際には
 * mode_directory を使います。
 * ディレクトリ名を指定した場合には、これが使用されます。
 * これらの一つに空の文字列("")を指定した場合、php.ini ディレクティブ
 * mcrypt.modes_dir に設定された値を使います。
 * これらが設定されていない場合、libmcrypt をコンパイルした際の
 * デフォルトのディレクトリ (通常は/usr/local/lib/libmcrypt)
 * を使います。
 * </p>
 * @return resource 通常は暗号化記述子を返します。エラー時は FALSE を返します。
 */
function mcrypt_module_open ($algorithm, $algorithm_directory, $mode, $mode_directory) {}

/**
 * 暗号化に必要な全てのバッファを初期化する
 * @link http://www.php.net/manual/ja/function.mcrypt-generic-init.php
 * @param td resource <p>
 * 暗号化記述子。
 * </p>
 * @param key string <p>
 * キーの最大長は、mcrypt_enc_get_key_size を
 * コールした際に得られるキー長であり、この値より小さな値は全て有効です。
 * </p>
 * @param iv string <p>
 * IV は通常そのアルゴリズムのブロック長と同じ大きさですが、
 * mcrypt_enc_get_iv_size をコールする
 * ことにより、その大きさを得る必要があります。IV は ECB では
 * 無視されます。IV は CFB、CBC、STREAM、nOFB では必須です。
 * IV はランダムで一意である必要があります(しかし、秘密ではある必要は
 * ありません)。暗号化と復号で同じ IV を使用する必要があります。
 * IV を使用したくない場合にはゼロに設定しますが、これは推奨されません。
 * </p>
 * @return int この関数は、エラー時に負の値を返します。キー長が不正な場合に
 * -3、メモリの確保に問題があった場合に -4、そしてそれ以外の返り値は
 * その他のエラーとなります。エラーが警告を発生させた場合、それが
 * 表示されます。間違ったパラメータが渡された場合には FALSE
 * が返されます。
 */
function mcrypt_generic_init ($td, $key, $iv) {}

/**
 * データを暗号化する
 * @link http://www.php.net/manual/ja/function.mcrypt-generic.php
 * @param td resource <p>
 * 暗号化記述子。
 * </p>
 * <p>
 * この関数をコールする前には、常にキーと IV を用いて
 * mcrypt_generic_init で暗号化ハンドルを
 * 初期化しておくべきです。暗号化が終了したら、
 * mcrypt_generic_deinit をコールして
 * 暗号化バッファを開放すべきです。使用例は
 * mcrypt_module_open を参照ください。
 * </p>
 * @param data string <p>
 * 暗号化するデータ。
 * </p>
 * @return string 暗号化したデータを返します。
 */
function mcrypt_generic ($td, $data) {}

/**
 * データを復号する
 * @link http://www.php.net/manual/ja/function.mdecrypt-generic.php
 * @param td resource <p>
 * mcrypt_module_open が返す暗号化記述子。
 * </p>
 * @param data string <p>
 * 暗号化されたデータ。
 * </p>
 * @return string 
 */
function mdecrypt_generic ($td, $data) {}

/**
 * 暗号処理を終了する
 * @link http://www.php.net/manual/ja/function.mcrypt-generic-end.php
 * @param td resource 
 * @return bool 
 */
function mcrypt_generic_end ($td) {}

/**
 * 暗号化モジュールを終了する
 * @link http://www.php.net/manual/ja/function.mcrypt-generic-deinit.php
 * @param td resource <p>
 * 暗号化記述子。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function mcrypt_generic_deinit ($td) {}

/**
 * オープンしたモジュールのセルフテストを実行する
 * @link http://www.php.net/manual/ja/function.mcrypt-enc-self-test.php
 * @param td resource <p>
 * 暗号化記述子。
 * </p>
 * @return int セルフテストが成功した場合は FALSE
 * を返します。エラーの場合は TRUE を返します。
 */
function mcrypt_enc_self_test ($td) {}

/**
 * オープンされたモードの暗号がブロックモードで動作するかどうかを調べる
 * @link http://www.php.net/manual/ja/function.mcrypt-enc-is-block-algorithm-mode.php
 * @param td resource <p>
 * 暗号化記述子。
 * </p>
 * @return bool モードがブロックアルゴリズムを使用している場合に TRUE、
 * その他の場合に FALSE を返します。
 */
function mcrypt_enc_is_block_algorithm_mode ($td) {}

/**
 * オープンされたモードの暗号がブロックアルゴリズムであるかどうかを調べる
 * @link http://www.php.net/manual/ja/function.mcrypt-enc-is-block-algorithm.php
 * @param td resource <p>
 * 暗号化記述子。
 * </p>
 * @return bool アルゴリズムがブロックアルゴリズムである場合に TRUE、
 * ストリームアルゴリズムである場合に FALSE を返します。
 */
function mcrypt_enc_is_block_algorithm ($td) {}

/**
 * オープンされたモードがブロック出力を行うかどうかを調べる
 * @link http://www.php.net/manual/ja/function.mcrypt-enc-is-block-mode.php
 * @param td resource <p>
 * 暗号化記述子。
 * </p>
 * @return bool バイトブロックを出力するモードの場合に TRUE、
 * バイト出力を行うモードの場合に FALSE を返します。
 */
function mcrypt_enc_is_block_mode ($td) {}

/**
 * オープンされたアルゴリズムのブロックサイズを返す
 * @link http://www.php.net/manual/ja/function.mcrypt-enc-get-block-size.php
 * @param td resource <p>
 * 暗号化記述子。
 * </p>
 * @return int 指定したアルゴリズムのブロック長をバイト単位で返します。
 */
function mcrypt_enc_get_block_size ($td) {}

/**
 * オープンされたモードでサポートされる最大キー長を返す
 * @link http://www.php.net/manual/ja/function.mcrypt-enc-get-key-size.php
 * @param td resource <p>
 * 暗号化記述子。
 * </p>
 * @return int そのアルゴリズムでサポートされる最大キー長をバイト単位で返します。
 */
function mcrypt_enc_get_key_size ($td) {}

/**
 * オープンされたアルゴリズムでサポートされるキー長を配列にして返す
 * @link http://www.php.net/manual/ja/function.mcrypt-enc-get-supported-key-sizes.php
 * @param td resource <p>
 * 暗号化記述子。
 * </p>
 * @return array 暗号化記述子で指定したアルゴリズムでサポートされるキー長を配列と
 * して返します。返された配列が空の場合、1 と
 * mcrypt_enc_get_key_size の値の間のすべての
 * キー長がアルゴリズムでサポートされます。
 */
function mcrypt_enc_get_supported_key_sizes ($td) {}

/**
 * オープンされたアルゴリズムの IV の大きさを返す
 * @link http://www.php.net/manual/ja/function.mcrypt-enc-get-iv-size.php
 * @param td resource <p>
 * 暗号化記述子。
 * </p>
 * @return int この関数は、暗号化記述子で指定したアルゴリズムの iv の大きさを
 * バイト単位で返します。
 * この関数が '0' を返す場合、IV は
 * そのアルゴリズムでは無視されます。
 */
function mcrypt_enc_get_iv_size ($td) {}

/**
 * オープンされたアルゴリズムの名前を返す
 * @link http://www.php.net/manual/ja/function.mcrypt-enc-get-algorithms-name.php
 * @param td resource <p>
 * 暗号化記述子。
 * </p>
 * @return string オープンしたアルゴリズムの名前を文字列で返します。
 */
function mcrypt_enc_get_algorithms_name ($td) {}

/**
 * オープンされたモードの名前を返す
 * @link http://www.php.net/manual/ja/function.mcrypt-enc-get-modes-name.php
 * @param td resource <p>
 * 暗号化記述子。
 * </p>
 * @return string 名前を表す文字列を返します。
 */
function mcrypt_enc_get_modes_name ($td) {}

/**
 * 指定したモジュールのセルフテストを実行する
 * @link http://www.php.net/manual/ja/function.mcrypt-module-self-test.php
 * @param algorithm string MCRYPT_暗号名 定数のいずれか、
 * あるいはアルゴリズム名をあらわす文字列。</p>
 * @param lib_dir string[optional] <p>
 * オプションのパラメータ lib_dir により、
 * システム上での algorithm モジュールの位置を指定することが可能です。
 * </p>
 * @return bool この関数は、セルフテストが成功した場合 TRUE、失敗した場合に FALSE
 * を返します。
 */
function mcrypt_module_self_test ($algorithm, $lib_dir = null) {}

/**
 * 指定したモジュールがブロックアルゴリズムであるかどうかを返す
 * @link http://www.php.net/manual/ja/function.mcrypt-module-is-block-algorithm-mode.php
 * @param mode string <p>
 * 調べたいモード。
 * </p>
 * @param lib_dir string[optional] <p>
 * オプションのパラメータ lib_dir により、
 * システム上での mode モジュールの位置を指定することが可能です。
 * </p>
 * @return bool この関数は、mode がブロックアルゴリズムを使用する場合に TRUE、
 * その他の場合に FALSE を返します。(例: stream の場合に FALSE、
 * cbc、cfb、ofb の場合に TRUE)
 */
function mcrypt_module_is_block_algorithm_mode ($mode, $lib_dir = null) {}

/**
 * 指定したアルゴリズムがブロックアルゴリズムであるかを調べる
 * @link http://www.php.net/manual/ja/function.mcrypt-module-is-block-algorithm.php
 * @param algorithm string <p>
 * 調べたいアルゴリズム。
 * </p>
 * @param lib_dir string[optional] <p>
 * オプションのパラメータ lib_dir により、
 * システム上での algorithm モジュールの位置を指定することが可能です。
 * </p>
 * @return bool この関数は、指定したアルゴリズムがブロックアルゴリズムの場合に
 * TRUE、ストリームアルゴリズムの場合に FALSE を返します。
 */
function mcrypt_module_is_block_algorithm ($algorithm, $lib_dir = null) {}

/**
 * 指定したモードがブロック出力を行うかどうかを返す
 * @link http://www.php.net/manual/ja/function.mcrypt-module-is-block-mode.php
 * @param mode string 定数 MCRYPT_MODE_モード名、あるいは文字列
 * "ecb", "cbc", "cfb", "ofb", "nofb" ,"stream" のいずれか。</p>
 * @param lib_dir string[optional] <p>
 * オプションのパラメータ
 * lib_dir により、システム上での mode モジュールの
 * 位置を指定することが可能です。
 * </p>
 * @return bool この関数は、ブロック出力を行うモードの場合に TRUE、バイトのみを
 * 出力する場合に FALSE を返します(例: cbc と ecb の場合に TRUE、
 * cfb と streamの場合に FALSE)。
 */
function mcrypt_module_is_block_mode ($mode, $lib_dir = null) {}

/**
 * 指定したアルゴリズムのブロック長を返す
 * @link http://www.php.net/manual/ja/function.mcrypt-module-get-algo-block-size.php
 * @param algorithm string <p>
 * アルゴリズム名。
 * </p>
 * @param lib_dir string[optional] <p>
 * オプションのパラメータで、
 * システム上でのモードモジュールの位置を指定することが可能です。
 * </p>
 * @return int 指定したアルゴリズムでサポートされるブロック長をバイト単位で返します。
 */
function mcrypt_module_get_algo_block_size ($algorithm, $lib_dir = null) {}

/**
 * オープンされたモードでサポートされる最大キー長を返す
 * @link http://www.php.net/manual/ja/function.mcrypt-module-get-algo-key-size.php
 * @param algorithm string <p>
 * アルゴリズム名。
 * </p>
 * @param lib_dir string[optional] <p>
 * オプションのパラメータで、
 * システム上でのモードモジュールの位置を指定することが可能です。
 * </p>
 * @return int この関数は、指定したアルゴリズムでサポートされる最大キー長をバイト単位で返します。
 */
function mcrypt_module_get_algo_key_size ($algorithm, $lib_dir = null) {}

/**
 * オープンされたアルゴリズムでサポートされるキーのサイズを配列として返す
 * @link http://www.php.net/manual/ja/function.mcrypt-module-get-supported-key-sizes.php
 * @param algorithm string <p>
 * 使用するアルゴリズム。
 * </p>
 * @param lib_dir string[optional] <p>
 * オプションのパラメータ lib_dir により、
 * システムでアルゴリズムモジュールがある場所を指定することが可能です。
 * </p>
 * @return array 指定したアルゴリズムでサポートするキーサイズの配列を返します。
 * 空の配列を返した場合は、そのアルゴリズムでは 1 から
 * mcrypt_module_get_algo_key_size
 * までのすべてのキーサイズをサポートすることになります。
 */
function mcrypt_module_get_supported_key_sizes ($algorithm, $lib_dir = null) {}

/**
 * mcrypt モジュールを閉じる
 * @link http://www.php.net/manual/ja/function.mcrypt-module-close.php
 * @param td resource <p>
 * 暗号化記述子。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function mcrypt_module_close ($td) {}

define ('MCRYPT_ENCRYPT', 0);
define ('MCRYPT_DECRYPT', 1);
define ('MCRYPT_DEV_RANDOM', 0);
define ('MCRYPT_DEV_URANDOM', 1);
define ('MCRYPT_RAND', 2);
define ('MCRYPT_3DES', "tripledes");
define ('MCRYPT_ARCFOUR_IV', "arcfour-iv");
define ('MCRYPT_ARCFOUR', "arcfour");
define ('MCRYPT_BLOWFISH', "blowfish");
define ('MCRYPT_BLOWFISH_COMPAT', "blowfish-compat");
define ('MCRYPT_CAST_128', "cast-128");
define ('MCRYPT_CAST_256', "cast-256");
define ('MCRYPT_CRYPT', "crypt");
define ('MCRYPT_DES', "des");
define ('MCRYPT_ENIGNA', "crypt");
define ('MCRYPT_GOST', "gost");
define ('MCRYPT_LOKI97', "loki97");
define ('MCRYPT_PANAMA', "panama");
define ('MCRYPT_RC2', "rc2");
define ('MCRYPT_RIJNDAEL_128', "rijndael-128");
define ('MCRYPT_RIJNDAEL_192', "rijndael-192");
define ('MCRYPT_RIJNDAEL_256', "rijndael-256");
define ('MCRYPT_SAFER64', "safer-sk64");
define ('MCRYPT_SAFER128', "safer-sk128");
define ('MCRYPT_SAFERPLUS', "saferplus");
define ('MCRYPT_SERPENT', "serpent");
define ('MCRYPT_THREEWAY', "threeway");
define ('MCRYPT_TRIPLEDES', "tripledes");
define ('MCRYPT_TWOFISH', "twofish");
define ('MCRYPT_WAKE', "wake");
define ('MCRYPT_XTEA', "xtea");
define ('MCRYPT_IDEA', "idea");
define ('MCRYPT_MARS', "mars");
define ('MCRYPT_RC6', "rc6");
define ('MCRYPT_SKIPJACK', "skipjack");
define ('MCRYPT_MODE_CBC', "cbc");
define ('MCRYPT_MODE_CFB', "cfb");
define ('MCRYPT_MODE_ECB', "ecb");
define ('MCRYPT_MODE_NOFB', "nofb");
define ('MCRYPT_MODE_OFB', "ofb");
define ('MCRYPT_MODE_STREAM', "stream");

// End of mcrypt v.
?>
