<?php

// Start of enchant v.1.1.0

/**
 * 要求を満たすブローカーオブジェクトを作成する
 * @link http://www.php.net/manual/ja/function.enchant-broker-init.php
 * @return resource 成功した場合にブローカーリソース、それ以外の場合に FALSE を返します。
 */
function enchant_broker_init () {}

/**
 * ブローカーリソースおよびその辞書を開放する
 * @link http://www.php.net/manual/ja/function.enchant-broker-free.php
 * @param broker resource <p>
 * ブローカーリソース。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function enchant_broker_free ($broker) {}

/**
 * ブローカーの直近のエラーを返す
 * @link http://www.php.net/manual/ja/function.enchant-broker-get-error.php
 * @param broker resource <p>
 * ブローカーリソース。
 * </p>
 * @return string エラーが見つかった場合にメッセージ文字列、それ以外の場合に FALSE
 * を返します。
 */
function enchant_broker_get_error ($broker) {}

/**
 * @param broker
 * @param name
 * @param value
 */
function enchant_broker_set_dict_path ($broker, $name, $value) {}

/**
 * @param broker
 * @param name
 */
function enchant_broker_get_dict_path ($broker, $name) {}

/**
 * 使用可能な辞書の一覧を返す
 * @link http://www.php.net/manual/ja/function.enchant-broker-list-dicts.php
 * @param broker resource <p>
 * ブローカーリソース。
 * </p>
 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function enchant_broker_list_dicts ($broker) {}

/**
 * タグを使用して新しい辞書を作成する
 * @link http://www.php.net/manual/ja/function.enchant-broker-request-dict.php
 * @param broker resource <p>
 * ブローカーリソース。
 * </p>
 * @param tag string <p>
 * ロケールを表すタグ。例えば en_US、de_DE など。
 * </p>
 * @return resource 成功した場合に辞書リソース、失敗した場合に FALSE を返します。
 */
function enchant_broker_request_dict ($broker, $tag) {}

/**
 * PWL ファイルを使用して辞書を作成する
 * @link http://www.php.net/manual/ja/function.enchant-broker-request-pwl-dict.php
 * @param broker resource <p>
 * ブローカーリソース。
 * </p>
 * @param filename string <p>
 * PWL ファイルへのパス。
 * </p>
 * @return resource 成功した場合に辞書リソース、失敗した場合に FALSE を返します。
 */
function enchant_broker_request_pwl_dict ($broker, $filename) {}

/**
 * 辞書リソースを開放する
 * @link http://www.php.net/manual/ja/function.enchant-broker-free-dict.php
 * @param dict resource <p>
 * 辞書リソース。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function enchant_broker_free_dict ($dict) {}

/**
 * 辞書が存在するかどうかを調べる。空でないタグを使用する
 * @link http://www.php.net/manual/ja/function.enchant-broker-dict-exists.php
 * @param broker resource <p>
 * ブローカーリソース。
 * </p>
 * @param tag string <p>
 * 空でない、LOCALE 形式のタグ。例: us_US、ch_DE など。
 * </p>
 * @return bool タグが存在する場合に TRUE、存在しない場合に FALSE を返します。
 */
function enchant_broker_dict_exists ($broker, $tag) {}

/**
 * その言語で使用する辞書の優先順位を宣言する
 * @link http://www.php.net/manual/ja/function.enchant-broker-set-ordering.php
 * @param broker resource <p>
 * ブローカーリソース。
 * </p>
 * @param tag string <p>
 * 言語タグ。"*" を使用すると、あらゆる言語についての
 * デフォルトの順位を宣言します。
 * 明示的に順位を指定しなかった言語についてはこれが使用されます。
 * </p>
 * @param ordering string <p>
 * プロバイダ名をカンマ区切りでつないだリスト。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function enchant_broker_set_ordering ($broker, $tag, $ordering) {}

/**
 * Enchant プロバイダを列挙する
 * @link http://www.php.net/manual/ja/function.enchant-broker-describe.php
 * @param broker resource <p>
 * ブローカーリソース。
 * </p>
 * @return array 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function enchant_broker_describe ($broker) {}

/**
 * 単語のスペルが正しいかどうかを調べる
 * @link http://www.php.net/manual/ja/function.enchant-dict-check.php
 * @param dict resource <p>
 * 辞書リソース。
 * </p>
 * @param word string <p>
 * 調べる単語。
 * </p>
 * @return bool 単語のスペルが正しい場合に TRUE、
 * そうでない場合に FALSE を返します。
 */
function enchant_dict_check ($dict, $word) {}

/**
 * 修正候補となる値の一覧を返す
 * @link http://www.php.net/manual/ja/function.enchant-dict-suggest.php
 * @param dict resource <p>
 * 辞書リソース。
 * </p>
 * @param word string <p>
 * 修正候補を調べる単語。
 * </p>
 * @return array 単語のスペルが間違っている場合に、修正候補の配列を返します。
 */
function enchant_dict_suggest ($dict, $word) {}

/**
 * パーソナル単語リストに単語を追加する
 * @link http://www.php.net/manual/ja/function.enchant-dict-add-to-personal.php
 * @param dict resource <p>
 * 辞書リソース。
 * </p>
 * @param word string <p>
 * 追加する単語。
 * </p>
 * @return void 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function enchant_dict_add_to_personal ($dict, $word) {}

/**
 * '単語' を、このスペルチェックセッションに追加する
 * @link http://www.php.net/manual/ja/function.enchant-dict-add-to-session.php
 * @param dict resource <p>
 * 辞書リソース。
 * </p>
 * @param word string <p>
 * 追加する単語。
 * </p>
 * @return void 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function enchant_dict_add_to_session ($dict, $word) {}

/**
 * このスペリングセッションに '単語' が存在するかどうかを調べる
 * @link http://www.php.net/manual/ja/function.enchant-dict-is-in-session.php
 * @param dict resource <p>
 * 辞書リソース。
 * </p>
 * @param word string <p>
 * 探す単語。
 * </p>
 * @return bool 単語が存在する場合に TRUE、それ以外の場合に FALSE を返します。
 */
function enchant_dict_is_in_session ($dict, $word) {}

/**
 * 単語の修正候補を追加する
 * @link http://www.php.net/manual/ja/function.enchant-dict-store-replacement.php
 * @param dict resource <p>
 * 辞書リソース。
 * </p>
 * @param mis string <p>
 * 修正する単語。
 * </p>
 * @param cor string <p>
 * 正しい単語。
 * </p>
 * @return void 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function enchant_dict_store_replacement ($dict, $mis, $cor) {}

/**
 * 現在のスペリングセッションの直近のエラーを返す
 * @link http://www.php.net/manual/ja/function.enchant-dict-get-error.php
 * @param dict resource <p>
 * 辞書リソース。
 * </p>
 * @return string エラーメッセージを表す文字列、あるいはエラーが発生していない場合に
 * FALSE を返します。
 */
function enchant_dict_get_error ($dict) {}

/**
 * 個々の辞書について説明する
 * @link http://www.php.net/manual/ja/function.enchant-dict-describe.php
 * @param dict resource <p>
 * 辞書リソース。
 * </p>
 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function enchant_dict_describe ($dict) {}

/**
 * 単語のスペルが正しいかどうかを調べ、修正候補を提供する
 * @link http://www.php.net/manual/ja/function.enchant-dict-quick-check.php
 * @param dict resource <p>
 * 辞書リソース。
 * </p>
 * @param word string <p>
 * 調べる単語。
 * </p>
 * @param suggestions array[optional] <p>
 * 単語のスペルが間違っている場合に、
 * この変数の中に修正候補の配列が格納されます。
 * </p>
 * @return bool 単語のスペルが正しい場合に TRUE、
 * そうでない場合に FALSE を返します。
 */
function enchant_dict_quick_check ($dict, $word, array &$suggestions = null) {}

define ('ENCHANT_MYSPELL', 1);
define ('ENCHANT_ISPELL', 2);

// End of enchant v.1.1.0
?>
