<?php

// Start of mbstring v.

/**
 * 文字列に対してケースフォルディングを行う
 * @link http://www.php.net/manual/ja/function.mb-convert-case.php
 * @param str string <p>
 * 変換される文字列。
 * </p>
 * @param mode int <p>
 * 変換モード。
 * MB_CASE_UPPER、
 * MB_CASE_LOWER あるいは
 * MB_CASE_TITLE のいずれかです。
 * </p>
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @return string mode
 * で指定された方法で string
 * に対してケースフォルディングを行った結果を返します。
 */
function mb_convert_case ($str, $mode, $encoding = null) {}

/**
 * 文字列を大文字にする
 * @link http://www.php.net/manual/ja/function.mb-strtoupper.php
 * @param str string <p>
 * 大文字に変換したい文字列。
 * </p>
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @return string str のすべてのアルファベットを大文字にしたものを返します。
 */
function mb_strtoupper ($str, $encoding = null) {}

/**
 * 文字列を小文字にする
 * @link http://www.php.net/manual/ja/function.mb-strtolower.php
 * @param str string <p>
 * 小文字にしたい文字列。
 * </p>
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @return string str のすべてのアルファベットを小文字にしたものを返します。
 */
function mb_strtolower ($str, $encoding = null) {}

/**
 * 現在の言語を設定あるいは取得する
 * @link http://www.php.net/manual/ja/function.mb-language.php
 * @param language string[optional] <p>
 * e-mail メッセージのエンコーディングとして使用します。有効な言語は、"Japanese",
 * "ja","English","en", "uni" (UTF-8) です。
 * mb_send_mail は、e-mail
 * をエンコードする際にこの設定を使用します。
 * </p>
 * <p> 
 * 言語とその設定は、Japanese の場合は ISO-2022-JP/Base64、uni の場合は
 * UTF-8/Base64、English の場合は ISO-8859-1/quoted printable です。
 * </p>
 * @return mixed language が設定され、
 * language が有効な場合、TRUEが返されます。
 * そうでない場合、FALSEが返されます。
 * language が省略された場合、
 * 言語の名前が文字列として返されます。事前に言語が設定されていない場合、
 * FALSE が返されます。
 */
function mb_language ($language = null) {}

/**
 * 内部文字エンコーディングを設定あるいは取得する
 * @link http://www.php.net/manual/ja/function.mb-internal-encoding.php
 * @param encoding string[optional] <p>
 * encoding は、HTTP 入力文字エンコーディング変換、
 * HTTP 出力文字エンコーディング変換および
 * mbstring モジュールの文字列関数においてデフォルトの文字エンコーディングとして使用されます。
 * マルチバイト正規表現用のエンコーディングは、ここで扱う内部文字エンコーディングとは別であることに注意してください。
 * </p>
 * @return mixed encoding が設定された場合、
 * 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * このとき、マルチバイト正規表現用のエンコーディングは変更されません。
 * encoding が省略された場合、
 * 現在の内部文字エンコーディング名を返します。
 */
function mb_internal_encoding ($encoding = null) {}

/**
 * HTTP 入力文字エンコーディングを検出する
 * @link http://www.php.net/manual/ja/function.mb-http-input.php
 * @param type string[optional] <p>
 * HTTP 入力の型を表す文字列を入力してください。
 * GET の場合は "G"、POST の場合は "P"、
 * COOKIE の場合は "C"、文字列の場合は "S" 、
 * リストの場合は "L" 、リスト全体（array を返す）
 * の場合は "I" です。 type が省略された場合、
 * 直近に処理された入力型が返されます。
 * </p>
 * @return mixed type の文字エンコーディング名を返します。
 * mb_http_input
 * が指定した HTTP 入力の処理を行っていない場合、FALSE を返します。
 */
function mb_http_input ($type = null) {}

/**
 * HTTP 出力文字エンコーディングを設定あるいは取得する
 * @link http://www.php.net/manual/ja/function.mb-http-output.php
 * @param encoding string[optional] <p>
 * encoding が設定された場合、
 * mb_http_output は
 * HTTP 出力文字エンコーディングを
 * encodingに設定します。
 * </p>
 * <p>
 * encoding が省略された場合、
 * mb_http_output
 * は現在の HTTP 出力文字エンコーディングを返します。
 * </p>
 * @return mixed encoding が省略された場合、
 * mb_http_output
 * は現在の HTTP 出力文字エンコーディングを返します。それ以外の場合、
 * 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function mb_http_output ($encoding = null) {}

/**
 * 文字エンコーディング検出順序を設定あるいは取得する
 * @link http://www.php.net/manual/ja/function.mb-detect-order.php
 * @param encoding_list mixed[optional] <p>
 * encoding_list は、
 * 配列またはカンマ区切りの文字エンコーディングのリストです。サポートされる文字エンコーディングを参照ください。
 * </p>
 * <p>
 * encoding_list が省略された場合は、
 * 現在の文字エンコーディング検出順を配列で返します。
 * </p>
 * <p>
 * この設定は、mb_detect_encoding および
 * mb_send_mail に影響します。
 * </p>
 * <p>
 * mbstring が現在実装しているのは、
 * 以下のエンコーディングを検出するフィルタです。
 * 以下のエンコーディングにおいて無効なバイトシーケンスがあった場合、
 * エンコーディング検出は失敗します。
 * </p>
 * UTF-8, UTF-7,
 * ASCII,
 * EUC-JP,SJIS,
 * eucJP-win, SJIS-win,
 * JIS, ISO-2022-JP 
 * <p>
 * ISO-8859-*の場合、mbstring
 * は常に ISO-8859-* として検出します。
 * </p>
 * <p>
 * UTF-16, UTF-32,
 * UCS2, UCS4 の場合、
 * エンコーディング検出は常に失敗します。
 * </p>
 * <p>
 * 無意味な順番の例
 * </p>
 * @return mixed 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function mb_detect_order ($encoding_list = null) {}

/**
 * 置換文字を設定あるいは取得する
 * @link http://www.php.net/manual/ja/function.mb-substitute-character.php
 * @param substrchar mixed[optional] <p>
 * Unicode 値の整数または文字列を以下のように指定します。
 * "none" : 出力しない
 * @return mixed substchar が設定された場合、成功時に
 * TRUE、そうでない場合に
 * FALSE を返します。
 * substchar が設定されない場合、Unicode 値または
 * "none" あるいは "long"
 * を返します。
 */
function mb_substitute_character ($substrchar = null) {}

/**
 * GET/POST/COOKIE データをパースし、グローバル変数を設定する
 * @link http://www.php.net/manual/ja/function.mb-parse-str.php
 * @param encoded_string string <p>
 * URL エンコードされたデータ。
 * </p>
 * @param result array[optional] <p>
 * デコードされ、文字エンコーディング変換された文字列が含まれます。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function mb_parse_str ($encoded_string, array &$result = null) {}

/**
 * 出力バッファ内で文字エンコーディングを変換するコールバック関数
 * @link http://www.php.net/manual/ja/function.mb-output-handler.php
 * @param contents string <p>
 * 出力バッファの中身。
 * </p>
 * @param status int <p>
 * 出力バッファの状態。
 * </p>
 * @return string 変換後の文字列を返します。
 */
function mb_output_handler ($contents, $status) {}

/**
 * MIME 文字設定を文字列で得る
 * @link http://www.php.net/manual/ja/function.mb-preferred-mime-name.php
 * @param encoding string <p>
 * 調べるエンコーディング。
 * </p>
 * @return string 文字エンコーディング encoding 用の
 * MIME charset 文字列を返します。
 */
function mb_preferred_mime_name ($encoding) {}

/**
 * 文字列の長さを得る
 * @link http://www.php.net/manual/ja/function.mb-strlen.php
 * @param str string <p>
 * 長さを調べたい文字列。
 * </p>
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @return int 文字エンコーディング
 * encoding の文字列
 * str の文字数を返します。
 * マルチバイト文字の一文字は1個として数えられます。
 */
function mb_strlen ($str, $encoding = null) {}

/**
 * 文字列の中に指定した文字列が最初に現れる位置を見つける
 * @link http://www.php.net/manual/ja/function.mb-strpos.php
 * @param haystack string <p>
 * 調べたい文字列。
 * </p>
 * @param needle string <p>
 * haystack の中から探す文字列。
 * strpos とは違い、
 * 数値を指定しても文字コードの値と見なされることはありません。
 * </p>
 * @param offset int[optional] <p>
 * 検索オフセット。
 * 指定されない場合は、0 が使用されます。
 * </p>
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @return int 文字列 haystack の中で
 * needle が最初に現れる位置を数字で返します。
 * needle が見付からなかった場合、FALSE
 * を返します。
 */
function mb_strpos ($haystack, $needle, $offset = null, $encoding = null) {}

/**
 * 文字列の中に指定した文字列が最後に現れる位置を見つける
 * @link http://www.php.net/manual/ja/function.mb-strrpos.php
 * @param haystack string <p>
 * needle が最後に登場する場所を調べたい文字列。
 * </p>
 * @param needle string <p>
 * haystack の中で見つけたい文字列。
 * </p>
 * @param offset int[optional] 指定すると、文字列中の任意の文字位置から検索を開始することができます。
 * 負の値を指定すると、文字の終端より前の任意の位置で検索を終了します。
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @return int 文字列 haystack の中で
 * needle が最後に現れる位置を数字で返します。
 * needle が見付からなかった場合、FALSE
 * を返します。
 */
function mb_strrpos ($haystack, $needle, $offset = null, $encoding = null) {}

/**
 * 大文字小文字を区別せず、
   文字列の中で指定した文字列が最初に現れる位置を探す
 * @link http://www.php.net/manual/ja/function.mb-stripos.php
 * @param haystack string <p>
 * needle が最初に現れる位置を見つける文字列。
 * </p>
 * @param needle string <p>
 * haystack の中で探す文字列。
 * </p>
 * @param offset int[optional] <p>
 * haystack の中で、検索を開始する位置。
 * </p>
 * @param encoding string[optional] <p>
 * 使用する文字エンコーディング名。
 * 省略した場合は内部文字エンコーディングが用いられます。
 * </p>
 * @return int needle が haystack
 * の中で最初に現れる位置を返します。needle
 * が見つからない場合は FALSE を返します。
 */
function mb_stripos ($haystack, $needle, $offset = null, $encoding = null) {}

/**
 * 大文字小文字を区別せず、
   文字列の中で指定した文字列が最後に現れる位置を探す
 * @link http://www.php.net/manual/ja/function.mb-strripos.php
 * @param haystack string <p>
 * needle が最後に現れる位置を見つける文字列。
 * </p>
 * @param needle string <p>
 * haystack の中で探す文字列。
 * </p>
 * @param offset int[optional] <p>
 * haystack の中で、検索を開始する位置。
 * </p>
 * @param encoding string[optional] <p>
 * 使用する文字エンコーディング名。
 * 省略した場合は内部文字エンコーディングが用いられます。
 * </p>
 * @return int needle が haystack
 * の中で最後に現れる位置を返します。needle
 * が見つからない場合は FALSE を返します。
 */
function mb_strripos ($haystack, $needle, $offset = null, $encoding = null) {}

/**
 * 文字列の中で、指定した文字列が最初に現れる位置を見つける
 * @link http://www.php.net/manual/ja/function.mb-strstr.php
 * @param haystack string <p>
 * needle が最初に現れる位置を見つける文字列。
 * </p>
 * @param needle string <p>
 * haystack の中で探す文字列。
 * </p>
 * @param before_needle bool[optional] <p>
 * この関数が haystack のどの部分を返すのかを指定します。
 * TRUE の場合は、haystack の先頭から
 * needle が最初に現れる位置までを返します (needle を含めません)。
 * FALSE の場合は、needle が最初に現れる位置から
 * haystack の最後までを返します (needle を含めます)。
 * </p>
 * @param encoding string[optional] <p>
 * 使用する文字エンコーディング名。
 * 省略した場合は内部文字エンコーディングが用いられます。
 * </p>
 * @return string haystack の部分文字列を返します。
 * needle が見つからない場合は FALSE を返します。
 */
function mb_strstr ($haystack, $needle, $before_needle = null, $encoding = null) {}

/**
 * 別の文字列の中で、ある文字が最後に現れる場所を見つける
 * @link http://www.php.net/manual/ja/function.mb-strrchr.php
 * @param haystack string <p>
 * needle が最後に現れる位置を探す文字列。
 * </p>
 * @param needle string <p>
 * haystack の中で探す文字列。
 * </p>
 * @param part bool[optional] <p>
 * この関数が haystack のどの部分を返すのかを指定します。
 * TRUE の場合は、haystack の先頭から
 * needle が最後に現れる位置までを返します。
 * FALSE の場合は、needle が最後に現れる位置から
 * haystack の最後までを返します。
 * </p>
 * @param encoding string[optional] <p>
 * 使用する文字エンコーディングの名前。
 * 省略した場合は内部文字エンコーディングを使用します。
 * </p>
 * @return string haystack の部分文字列を返します。
 * needle が見つからない場合は FALSE を返します。
 */
function mb_strrchr ($haystack, $needle, $part = null, $encoding = null) {}

/**
 * 大文字小文字を区別せず、
   文字列の中で指定した文字列が最初に現れる位置を探す
 * @link http://www.php.net/manual/ja/function.mb-stristr.php
 * @param haystack string <p>
 * needle が最初に現れる位置を見つける文字列。
 * </p>
 * @param needle string <p>
 * haystack の中で探す文字列。
 * </p>
 * @param before_needle bool[optional] <p>
 * この関数が haystack のどの部分を返すのかを指定します。
 * TRUE の場合は、haystack の先頭から
 * needle が最初に現れる位置までを返します (needle を含めません)。
 * FALSE の場合は、needle が最初に現れる位置から
 * haystack の最後までを返します (needle を含めます)。
 * </p>
 * @param encoding string[optional] <p>
 * 使用する文字エンコーディング名。
 * 省略した場合は内部文字エンコーディングが用いられます。
 * </p>
 * @return string haystack の部分文字列を返します。
 * needle が見つからない場合は FALSE を返します。
 */
function mb_stristr ($haystack, $needle, $before_needle = null, $encoding = null) {}

/**
 * 大文字小文字を区別せず、
   別の文字列の中である文字が最後に現れる場所を探す
 * @link http://www.php.net/manual/ja/function.mb-strrichr.php
 * @param haystack string <p>
 * needle が最後に現れる位置を探す文字列。
 * </p>
 * @param needle string <p>
 * haystack の中で探す文字列。
 * </p>
 * @param part bool[optional] <p>
 * この関数が haystack のどの部分を返すのかを指定します。
 * TRUE の場合は、haystack の先頭から
 * needle が最後に現れる位置までを返します。
 * FALSE の場合は、needle が最後に現れる位置から
 * haystack の最後までを返します。
 * </p>
 * @param encoding string[optional] <p>
 * 使用する文字エンコーディングの名前。
 * 省略した場合は内部文字エンコーディングを使用します。
 * </p>
 * @return string haystack の部分文字列を返します。
 * needle が見つからない場合は FALSE を返します。
 */
function mb_strrichr ($haystack, $needle, $part = null, $encoding = null) {}

/**
 * 部分文字列の出現回数を数える
 * @link http://www.php.net/manual/ja/function.mb-substr-count.php
 * @param haystack string <p>
 * 調べたい文字列。
 * </p>
 * @param needle string <p>
 * 見つける文字列。
 * </p>
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @return int 文字列
 * haystack の中での部分文字列
 * needle の出現回数を返します。
 */
function mb_substr_count ($haystack, $needle, $encoding = null) {}

/**
 * 文字列の一部を得る
 * @link http://www.php.net/manual/ja/function.mb-substr.php
 * @param str string <p>
 * 部分文字列を取り出したい文字列。
 * </p>
 * @param start int <p>
 * str の中から最初に取り出す文字の位置。
 * </p>
 * @param length int[optional] <p>
 * str の中から取り出す最大文字数。
 * </p>
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @return string mb_substr は、start
 * および length パラメータで指定した
 * str の一部を返します。
 */
function mb_substr ($str, $start, $length = null, $encoding = null) {}

/**
 * 文字列の一部を得る
 * @link http://www.php.net/manual/ja/function.mb-strcut.php
 * @param str string <p>
 * 取り出しの対象となる文字列。
 * </p>
 * @param start int <p>
 * バイト単位での開始位置。
 * </p>
 * @param length int[optional] <p>
 * バイト単位での長さ。
 * </p>
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @return string mb_strcut は、
 * start および
 * length パラメータで指定した
 * str の一部を返します。
 */
function mb_strcut ($str, $start, $length = null, $encoding = null) {}

/**
 * 文字列の幅を返す
 * @link http://www.php.net/manual/ja/function.mb-strwidth.php
 * @param str string <p>
 * 幅を取得したい文字列。
 * </p>
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @return int 文字列 str の幅を返します。
 */
function mb_strwidth ($str, $encoding = null) {}

/**
 * 指定した幅で文字列を丸める
 * @link http://www.php.net/manual/ja/function.mb-strimwidth.php
 * @param str string <p>
 * 丸めたい文字列。
 * </p>
 * @param start int <p>
 * 開始位置のオフセット。文字列の始めからの文字数 (最初の文字は 0) です。
 * </p>
 * @param width int <p>
 * 丸める幅。
 * </p>
 * @param trimmarker string[optional] <p>
 * 丸めた後にその文字列の最後に追加される文字列。
 * </p>
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @return string 丸められた文字列を返します。
 * trimmarker が設定された場合、
 * trimmarker が丸められた文字列に追加されます。
 */
function mb_strimwidth ($str, $start, $width, $trimmarker = null, $encoding = null) {}

/**
 * 文字エンコーディングを変換する
 * @link http://www.php.net/manual/ja/function.mb-convert-encoding.php
 * @param str string <p>
 * 変換する文字列。
 * </p>
 * @param to_encoding string <p>
 * str の変換後の文字エンコーディング。
 * </p>
 * @param from_encoding mixed[optional] <p>
 * 変換前の文字エンコーディング名を指定します。
 * これは、配列またはカンマ区切りの文字列とすることが可能です。
 * from_encoding
 * を指定しなかった場合は、内部文字エンコーディングを使用します。
 * </p>
 * <p>
 * サポートされる文字エンコーディングを参照ください。
 * </p>
 * @return string 変換後の文字列を返します。
 */
function mb_convert_encoding ($str, $to_encoding, $from_encoding = null) {}

/**
 * 文字エンコーディングを検出する
 * @link http://www.php.net/manual/ja/function.mb-detect-encoding.php
 * @param str string <p>
 * 検出する文字列。
 * </p>
 * @param encoding_list mixed[optional] <p>
 * encoding_list は文字エンコーディングのリストで、
 * エンコーディング検出の順番を配列またはカンマ区切りのリストで指定します。
 * </p>
 * <p>
 * encoding_list が省略された場合、
 * detect_order が使用されます。
 * </p>
 * @param strict bool[optional] <p>
 * strict は、
 * 厳格なエンコーディング検出を行うかどうかを指定します。
 * デフォルトは FALSE です。
 * </p>
 * @return string 検出した文字エンコーディングを返します。
 * 指定した文字列からエンコーディングを検出できなかった場合は FALSE を返します。
 */
function mb_detect_encoding ($str, $encoding_list = null, $strict = null) {}

/**
 * サポートするすべてのエンコーディングの配列を返す
 * @link http://www.php.net/manual/ja/function.mb-list-encodings.php
 * @return array 数値添字の配列を返します。
 */
function mb_list_encodings () {}

/**
 * 既知のエンコーディング・タイプのエイリアスを取得
 * @link http://www.php.net/manual/ja/function.mb-encoding-aliases.php
 * @param encoding string <p>
 * エイリアスに関してチェックするエンコーディングタイプ。
 * </p>
 * @return array 成功した場合、数値で索引がつけられたエンコーディング・エイリアスの配列を返し、
 * 失敗した場合に FALSE を返します
 */
function mb_encoding_aliases ($encoding) {}

/**
 * カナを("全角かな"、"半角かな"等に)変換する
 * @link http://www.php.net/manual/ja/function.mb-convert-kana.php
 * @param str string <p>
 * 変換される文字列。
 * </p>
 * @param option string[optional] <p>
 * 変換オプション。
 * </p>
 * <p>
 * 以下のオプションを組み合わせて指定します。
 * <table>
 * 使用可能な変換オプション
 * <tr valign="top">
 * <td>オプション</td>
 * <td>意味</td>
 * </tr>
 * <tr valign="top">
 * <td>r</td>
 * <td>
 * 「全角」英字を「半角」に変換します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>R</td>
 * <td>
 * 「半角」英字を「全角」に変換します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>n</td>
 * <td>
 * 「全角」数字を「半角」に変換します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>N</td>
 * <td>
 * 「半角」数字を「全角」に変換します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>a</td>
 * <td>
 * 「全角」英数字を「半角」に変換します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>A</td>
 * <td>
 * 「半角」英数字を「全角」に変換します
 * （"a", "A" オプションに含まれる文字は、U+0022, U+0027, U+005C,
 * U+007Eを除く U+0021 - U+007E の範囲です）。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>s</td>
 * <td>
 * 「全角」スペースを「半角」に変換します（U+3000 -> U+0020）。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>S</td>
 * <td>
 * 「半角」スペースを「全角」に変換します（U+0020 -> U+3000）。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>k</td>
 * <td>
 * 「全角カタカナ」を「半角カタカナ」に変換します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>K</td>
 * <td>
 * 「半角カタカナ」を「全角カタカナ」に変換します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>h</td>
 * <td>
 * 「全角ひらがな」を「半角カタカナ」に変換します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>H</td>
 * <td>
 * 「半角カタカナ」を「全角ひらがな」に変換します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>c</td>
 * <td>
 * 「全角カタカナ」を「全角ひらがな」に変換します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>C</td>
 * <td>
 * 「全角ひらがな」を「全角カタカナ」に変換します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>V</td>
 * <td>
 * 濁点付きの文字を一文字に変換します。"K", "H" と共に使用します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @return string 変換後の文字列を返します。
 */
function mb_convert_kana ($str, $option = null, $encoding = null) {}

/**
 * MIMEヘッダの文字列をエンコードする
 * @link http://www.php.net/manual/ja/function.mb-encode-mimeheader.php
 * @param str string <p>
 * エンコードする文字列。
 * </p>
 * @param charset string[optional] <p>
 * charset は、str
 * の文字セット名です。デフォルトは、現在の NLS 設定
 * (mbstring.language) によって決まります。
 * mb_internal_encoding を同じエンコーディングに設定しておかなければなりません。
 * </p>
 * @param transfer_encoding string[optional] <p>
 * transfer_encoding は MIME エンコーディングの
 * 方式を指定します。"B" (Base64) または
 * "Q" (Quoted-Printable) のどちらかでなければなりません。
 * デフォルトは "B" です。
 * </p>
 * @param linefeed string[optional] <p>
 * linefeed は EOL (行末) のマーカで、
 * mb_encode_mimeheader が行を折りたたむ
 * (RFC 用語で、
 * ある一定より長い行を複数行に分割することを言います。
 * 分割する長さは、現在 74 文字に固定されています) 際に利用します。
 * デフォルトは "\r\n" (CRLF) です。
 * </p>
 * @param indent int[optional] <p>
 * 最初の行の字下げ (ヘッダで
 * str の前におく文字数)。
 * </p>
 * @return string 文字列を ASCII 表現に変換したものを返します。
 */
function mb_encode_mimeheader ($str, $charset = null, $transfer_encoding = null, $linefeed = null, $indent = null) {}

/**
 * MIME ヘッダフィールドの文字列をデコードする
 * @link http://www.php.net/manual/ja/function.mb-decode-mimeheader.php
 * @param str string <p>
 * デコードする文字列。
 * </p>
 * @return string 内部文字エンコーディングでデコードされた文字列を返します。
 */
function mb_decode_mimeheader ($str) {}

/**
 * 変数の文字コードを変換する
 * @link http://www.php.net/manual/ja/function.mb-convert-variables.php
 * @param to_encoding string <p>
 * 文字列の変換後のエンコーディング。
 * </p>
 * @param from_encoding mixed <p>
 * from_encoding には配列またはカンマ区切りの文字列を指定し、
 * from-coding からエンコーディングの検出を試みます。
 * from_encoding
 * が省略された場合、detect_order を使用します。
 * </p>
 * @param vars mixed <p>
 * vars(3番目以降の引数)は、変換する変数への
 * リファレンスです。文字列、配列、オブジェクトを指定することが可能です。
 * mb_convert_variables は全てのパラメータが
 * 同じエンコーディングを有することを仮定します。
 * </p>
 * @param _ mixed[optional] 
 * @return string 成功時に変換前の文字エンコーディングを返し、失敗した場合に FALSE を返します。
 */
function mb_convert_variables ($to_encoding, $from_encoding, &$vars, &$_ = null) {}

/**
 * 文字を HTML 数値エンティティにエンコードする
 * @link http://www.php.net/manual/ja/function.mb-encode-numericentity.php
 * @param str string <p>
 * エンコードする文字列。
 * </p>
 * @param convmap array <p>
 * convmap は、変換するコード領域を指定する配列です。
 * </p>
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @param is_hex bool[optional] <p>
 * </p>
 * @return string 変換後の文字列を返します。
 */
function mb_encode_numericentity ($str, array $convmap, $encoding = null, $is_hex = null) {}

/**
 * HTML 数値エンティティを文字にデコードする
 * @link http://www.php.net/manual/ja/function.mb-decode-numericentity.php
 * @param str string <p>
 * デコードする文字列。
 * </p>
 * @param convmap array <p>
 * convmap
 * は変換するコード領域を指定する配列です。
 * </p>
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @return string 変換された文字列を返します。
 */
function mb_decode_numericentity ($str, array $convmap, $encoding = null) {}

/**
 * エンコード変換を行ってメールを送信する
 * @link http://www.php.net/manual/ja/function.mb-send-mail.php
 * @param to string <p>
 * 送信先のメールアドレス。
 * 各アドレスをカンマで区切ると、複数の宛先を
 * to に指定できます。
 * このパラメータは、自動的にはエンコードされません。
 * </p>
 * @param subject string <p>
 * メールの件名。
 * </p>
 * @param message string <p>
 * メールの本文。
 * </p>
 * @param additional_headers string[optional] <p>
 * additional_headers は、
 * ヘッダの最後に挿入されます。これは通常、ヘッダを追加する際に使用されます。
 * 改行 ("\n") で区切ることにより複数のヘッダを指定可能です。
 * </p>
 * @param additional_parameter string[optional] <p>
 * additional_parameter は、MTA へ渡す
 * コマンドライン引数です。sendmail を利用する際に正しい Return-Path
 * を設定するためなどに利用すると便利です。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function mb_send_mail ($to, $subject, $message, $additional_headers = null, $additional_parameter = null) {}

/**
 * mbstring の内部設定値を取得する
 * @link http://www.php.net/manual/ja/function.mb-get-info.php
 * @param type string[optional] <p>
 * type が指定されない場合または "all"
 * が指定された場合、"internal_encoding", "http_output", "http_input",
 * "func_overload", "mail_charset", "mail_header_encoding",
 * "mail_body_encoding" の設定値を有する連想配列が返されます。
 * </p>
 * <p>
 * type に "http_output",
 * "http_input", "internal_encoding", "func_overload" が指定された場合、
 * 指定された設定パラメータが返されます。
 * </p>
 * @return mixed type が指定されていない場合は型情報を含む配列、
 * それ以外の場合は指定した type の値を返します。
 */
function mb_get_info ($type = null) {}

/**
 * 文字列が、指定したエンコーディングで有効なものかどうかを調べる
 * @link http://www.php.net/manual/ja/function.mb-check-encoding.php
 * @param var string[optional] <p>
 * 調べるバイトストリーム。省略した場合は、
 * リクエスト開始時からのすべての入力が対象となります。
 * </p>
 * @param encoding string[optional] <p>
 * 期待するエンコーディング。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function mb_check_encoding ($var = null, $encoding = null) {}

/**
 * 現在のマルチバイト正規表現用のエンコーディングを取得または設定する
 * @link http://www.php.net/manual/ja/function.mb-regex-encoding.php
 * @param encoding string[optional] encoding 
 * パラメータには文字エンコーディングを指定します。省略した場合は、
 * 内部文字エンコーディングを使用します。</p>
 * @return mixed 
 */
function mb_regex_encoding ($encoding = null) {}

/**
 * マルチバイト正規表現関数のデフォルトオプションを取得または設定する
 * @link http://www.php.net/manual/ja/function.mb-regex-set-options.php
 * @param options string[optional] <p>
 * 設定するオプション。文字列で設定し、各文字がオプションを表します。
 * モードを設定する際には、モード文字は最後に指定しなければなりません。
 * オプションは複数指定できますが、モードはひとつしか指定できません。
 * </p>
 * <table>
 * Regex のオプション
 * <tr valign="top">
 * <td>オプション</td>
 * <td>意味</td>
 * </tr>
 * <tr valign="top">
 * <td>i</td>
 * <td>曖昧なマッチをオンにする</td>
 * </tr>
 * <tr valign="top">
 * <td>x</td>
 * <td>拡張パターン形式を有効にする</td>
 * </tr>
 * <tr valign="top">
 * <td>m</td>
 * <td>'.' が改行にマッチする</td>
 * </tr>
 * <tr valign="top">
 * <td>s</td>
 * <td>'^' -> '\A', '$' -> '\Z'</td>
 * </tr>
 * <tr valign="top">
 * <td>p</td>
 * <td>m と s を両方指定するのと同じ</td>
 * </tr>
 * <tr valign="top">
 * <td>l</td>
 * <td>最も長くマッチするものを探す</td>
 * </tr>
 * <tr valign="top">
 * <td>n</td>
 * <td>空のマッチを無視する</td>
 * </tr>
 * <tr valign="top">
 * <td>e</td>
 * <td>結果のコードを eval する</td>
 * </tr>
 * </table>
 * <table>
 * Regex 構文モード
 * <tr valign="top">
 * <td>モード</td>
 * <td>意味</td>
 * </tr>
 * <tr valign="top">
 * <td>j</td>
 * <td>Java (Sun java.util.regex)</td>
 * </tr>
 * <tr valign="top">
 * <td>u</td>
 * <td>GNU regex</td>
 * </tr>
 * <tr valign="top">
 * <td>g</td>
 * <td>grep</td>
 * </tr>
 * <tr valign="top">
 * <td>c</td>
 * <td>Emacs</td>
 * </tr>
 * <tr valign="top">
 * <td>r</td>
 * <td>Ruby</td>
 * </tr>
 * <tr valign="top">
 * <td>z</td>
 * <td>Perl</td>
 * </tr>
 * <tr valign="top">
 * <td>b</td>
 * <td>POSIX Basic regex</td>
 * </tr>
 * <tr valign="top">
 * <td>d</td>
 * <td>POSIX Extended regex</td>
 * </tr>
 * </table>
 * @return string 以前設定されていたオプション文字列を返します。
 * options を省略した場合は、
 * 現在設定されているオプションを返します。
 */
function mb_regex_set_options ($options = null) {}

/**
 * マルチバイト文字列に正規表現マッチを行う
 * @link http://www.php.net/manual/ja/function.mb-ereg.php
 * @param pattern string <p>
 * 検索パターン。
 * </p>
 * @param string string <p>
 * 検索文字列。
 * </p>
 * @param regs array[optional] <p>
 * マッチした string の部分文字列。
 * </p>
 * @return int 
 */
function mb_ereg ($pattern, $string, array $regs = null) {}

/**
 * マルチバイト文字列に大文字小文字を区別しない正規表現マッチを行う
 * @link http://www.php.net/manual/ja/function.mb-eregi.php
 * @param pattern string <p>
 * 正規表現パターン。
 * </p>
 * @param string string <p>
 * 検索対象の文字列。
 * </p>
 * @param regs array[optional] <p>
 * マッチした string の部分文字列を格納します。
 * </p>
 * @return int 
 */
function mb_eregi ($pattern, $string, array $regs = null) {}

/**
 * マルチバイト文字列に正規表現による置換を行う
 * @link http://www.php.net/manual/ja/function.mb-ereg-replace.php
 * @param pattern string <p>
 * 正規表現パターン。
 * </p>
 * <p>
 * マルチバイト文字を pattern
 * で使用することができます。
 * </p>
 * @param replacement string <p>
 * 置換文字列。
 * </p>
 * @param string string <p>
 * 調べたい文字列。
 * </p>
 * @param option string[optional] option
 * パラメータで、マッチングの動作を変更可能です。
 * i を指定した場合、大文字・小文字が
 * 区別されなくなります。
 * x を指定した場合、空白が無視されます。
 * m を指定した場合、マルチラインモードとなり、
 * 改行文字も "." に含まれるようになります。
 * p を指定した場合、POSIX モードとなり、
 * 改行も通常文字とみなされるようになります。
 * e を指定した場合、文字列 replacement
 * がPHPの式として評価されます。
 * @return string 成功した場合に結果の文字列、エラー時に FALSE を返します。
 */
function mb_ereg_replace ($pattern, $replacement, $string, $option = null) {}

/**
 * マルチバイト文字列に大文字小文字を区別せずに正規表現による置換を行う
 * @link http://www.php.net/manual/ja/function.mb-eregi-replace.php
 * @param pattern string <p>
 * 正規表現パターン。マルチバイト文字を使用できます。
 * 大文字小文字は区別しません。
 * </p>
 * @param replace string <p>
 * 置換する文字列。
 * </p>
 * @param string string <p>
 * 検索対象となる文字列。
 * </p>
 * @param option string[optional] option 
 * の意味は、mb_ereg_replace の場合と同じです。
 * @return string 結果の文字列、あるいはエラー時に FALSE を返します。
 */
function mb_eregi_replace ($pattern, $replace, $string, $option = null) {}

/**
 * マルチバイト文字列にコールバック関数を用いた正規表現による置換を行う
 * @link http://www.php.net/manual/ja/function.mb-ereg-replace-callback.php
 * @param pattern string <p>
 * 正規表現パターン。
 * </p>
 * <p>
 * patternではマルチバイト文字列を使用可能です。
 * </p>
 * @param callback callable <p>
 * コールバック関数で、
 * subject文字列で一致した要素を配列で
 * 指定してコールされます。
 * このコールバック関数は、置換した文字列を返す必要があります。
 * </p>
 * <p>
 * しばしば、
 * mb_ereg_replace_callbackの
 * callback関数が必要となるのは一度だけである
 * 場合があります。
 * この場合、
 * mb_ereg_replace_callbackをコールする際の
 * コールバックに
 * 匿名関数 (
 * PHP 5.3.0以降)またはcreate_functionを
 * 使用することができます。
 * このようにすることで、
 * コールに関する全ての情報を一つの場所に集約し、
 * 他のどこでも使用されないコールバック関数の名前を
 * 関数の名前空間にばらまかないですみます。
 * </p>
 * @param string string <p>
 * チェックされるstring。
 * </p>
 * @param option string[optional] <p>
 * option
 * パラメータにより検索条件を指定できます。このパラメータに 
 * iが指定された場合、 大文字/小文字が無視されます。
 * x が指定された場合、
 * 空白文字が無視されます。
 * mが指定された場合、
 * 検索はマルチラインモードで行われ、改行文字が'.'に含まれるようになります。
 * p が指定された場合、 POSIXモードで検索が
 * 行われ、 改行文字は通常の文字とみなされます。
 * eは
 * mb_ereg_replace_callbackでは使用できないことに
 * 注意してください。
 * </p>
 * @return string 成功した際に string、 そうでない場合はエラー時に FALSE を
 * 返します。
 */
function mb_ereg_replace_callback ($pattern, $callback, $string, $option = null) {}

/**
 * マルチバイト文字列を正規表現により分割する
 * @link http://www.php.net/manual/ja/function.mb-split.php
 * @param pattern string <p>
 * 正規表現パターン。
 * </p>
 * @param string string <p>
 * 分割する文字列。
 * </p>
 * @param limit int[optional] オプションの引数 limit を指定した場合は、
 * 最大 limit 個の要素に分割されます。
 * @return array 結果を配列で返します。
 */
function mb_split ($pattern, $string, $limit = null) {}

/**
 * マルチバイト文字列が正規表現に一致するか調べる
 * @link http://www.php.net/manual/ja/function.mb-ereg-match.php
 * @param pattern string <p>
 * 正規表現パターン。
 * </p>
 * @param string string <p>
 * 評価する文字列。
 * </p>
 * @param option string[optional] <p>
 * </p>
 * @return bool 
 */
function mb_ereg_match ($pattern, $string, $option = null) {}

/**
 * 指定したマルチバイト文字列が正規表現に一致するか調べる
 * @link http://www.php.net/manual/ja/function.mb-ereg-search.php
 * @param pattern string[optional] <p>
 * 検索パターン。
 * </p>
 * @param option string[optional] <p>
 * 検索オプション。
 * </p>
 * @return bool 
 */
function mb_ereg_search ($pattern = null, $option = null) {}

/**
 * 指定したマルチバイト文字列が正規表現に一致する部分の位置と長さを返す
 * @link http://www.php.net/manual/ja/function.mb-ereg-search-pos.php
 * @param pattern string[optional] <p>
 * 検索パターン。
 * </p>
 * @param option string[optional] <p>
 * 検索オプション。
 * </p>
 * @return array 
 */
function mb_ereg_search_pos ($pattern = null, $option = null) {}

/**
 * 指定したマルチバイト文字列が正規表現に一致する部分を取得する
 * @link http://www.php.net/manual/ja/function.mb-ereg-search-regs.php
 * @param pattern string[optional] <p>
 * 検索パターン。
 * </p>
 * @param option string[optional] <p>
 * 検索オプション。
 * </p>
 * @return array 
 */
function mb_ereg_search_regs ($pattern = null, $option = null) {}

/**
 * マルチバイト正規表現検索用の文字列と正規表現を設定する
 * @link http://www.php.net/manual/ja/function.mb-ereg-search-init.php
 * @param string string <p>
 * 検索文字列。
 * </p>
 * @param pattern string[optional] <p>
 * 検索パターン。
 * </p>
 * @param option string[optional] <p>
 * 検索オプション。
 * </p>
 * @return bool 
 */
function mb_ereg_search_init ($string, $pattern = null, $option = null) {}

/**
 * マルチバイト文字列が正規表現に一致する部分があるか調べる
 * @link http://www.php.net/manual/ja/function.mb-ereg-search-getregs.php
 * @return array 
 */
function mb_ereg_search_getregs () {}

/**
 * 次の正規表現検索を開始する位置を取得する
 * @link http://www.php.net/manual/ja/function.mb-ereg-search-getpos.php
 * @return int 
 */
function mb_ereg_search_getpos () {}

/**
 * 次の正規表現検索を開始する位置を設定する
 * @link http://www.php.net/manual/ja/function.mb-ereg-search-setpos.php
 * @param position int <p>
 * 設定する位置。
 * </p>
 * @return bool 
 */
function mb_ereg_search_setpos ($position) {}

/**
 * @param encoding[optional]
 */
function mbregex_encoding ($encoding) {}

/**
 * @param pattern
 * @param string
 * @param registers[optional]
 */
function mbereg ($pattern, $string, &$registers) {}

/**
 * @param pattern
 * @param string
 * @param registers[optional]
 */
function mberegi ($pattern, $string, &$registers) {}

/**
 * @param pattern
 * @param replacement
 * @param string
 * @param option[optional]
 */
function mbereg_replace ($pattern, $replacement, $string, $option) {}

/**
 * @param pattern
 * @param replacement
 * @param string
 */
function mberegi_replace ($pattern, $replacement, $string) {}

/**
 * @param pattern
 * @param string
 * @param limit[optional]
 */
function mbsplit ($pattern, $string, $limit) {}

/**
 * @param pattern
 * @param string
 * @param option[optional]
 */
function mbereg_match ($pattern, $string, $option) {}

/**
 * @param pattern[optional]
 * @param option[optional]
 */
function mbereg_search ($pattern, $option) {}

/**
 * @param pattern[optional]
 * @param option[optional]
 */
function mbereg_search_pos ($pattern, $option) {}

/**
 * @param pattern[optional]
 * @param option[optional]
 */
function mbereg_search_regs ($pattern, $option) {}

/**
 * @param string
 * @param pattern[optional]
 * @param option[optional]
 */
function mbereg_search_init ($string, $pattern, $option) {}

function mbereg_search_getregs () {}

function mbereg_search_getpos () {}

/**
 * @param position
 */
function mbereg_search_setpos ($position) {}

define ('MB_OVERLOAD_MAIL', 1);
define ('MB_OVERLOAD_STRING', 2);
define ('MB_OVERLOAD_REGEX', 4);
define ('MB_CASE_UPPER', 0);
define ('MB_CASE_LOWER', 1);
define ('MB_CASE_TITLE', 2);

// End of mbstring v.
?>
