<?php

// Start of shmop v.

/**
 * 共有メモリブロックを作成またはオープンする
 * @link http://www.php.net/manual/ja/function.shmop-open.php
 * @param key int <p>
 * 共有メモリブロックのシステム ID であり、10 進数または
 * 16 進数で指定することが可能です。
 * </p>
 * @param flags string <p>
 * フラグに設定できる内容は、次のとおりです。
 * "a" アクセス用(shmat に SHM_RDONLY を設定する)
 * 既存の共有メモリセグメントを読み込み専用でオープンする必要がある場合に
 * このフラグを使用してください。
 * @param mode int <p>
 * 共有メモリセグメントに設定したい
 * 許可属性で、ファイルに関する許可属性と同様なものです。許可属性は、
 * 例えば 0644 のような 8 進数形式で渡す必要があります。
 * </p>
 * @param size int <p>
 * 作成したい共有メモリブロックの大きさをバイト数で指定します。
 * </p>
 * @return int 成功した場合は、shmop_open は
 * 作成した共有メモリセグメントにアクセスするために使用する ID を返します。
 * 失敗した場合に FALSE を返します。
 */
function shmop_open ($key, $flags, $mode, $size) {}

/**
 * 共有メモリブロックからデータを読み込む
 * @link http://www.php.net/manual/ja/function.shmop-read.php
 * @param shmid int <p>
 * shmop_open
 * が作成した共有メモリブロックの識別子。
 * </p>
 * @param start int <p>
 * 読み込みを開始する位置。
 * </p>
 * @param count int <p>
 * 読み込むバイト数。
 * </p>
 * @return string データを返します。失敗した場合に FALSE を返します。
 */
function shmop_read ($shmid, $start, $count) {}

/**
 * 共有メモリブロックを閉じる
 * @link http://www.php.net/manual/ja/function.shmop-close.php
 * @param shmid int <p>
 * shmop_open
 * が作成した共有メモリブロックの識別子。
 * </p>
 * @return void 値を返しません。
 */
function shmop_close ($shmid) {}

/**
 * 共有メモリブロックの大きさを得る
 * @link http://www.php.net/manual/ja/function.shmop-size.php
 * @param shmid int <p>
 * shmop_open
 * が作成した共有メモリブロックの識別子。
 * </p>
 * @return int 共有メモリブロックが占有するバイト数を表す整数を返します。
 */
function shmop_size ($shmid) {}

/**
 * 共有メモリブロックにデータを書き込む
 * @link http://www.php.net/manual/ja/function.shmop-write.php
 * @param shmid int <p>
 * shmop_open
 * が作成した共有メモリブロックの識別子。
 * </p>
 * @param data string <p>
 * 共有メモリブロックに書き込む文字列。
 * </p>
 * @param offset int <p>
 * 共有メモリセグメント内でデータを書き込み始める位置。
 * </p>
 * @return int 書き込んだ data の大きさ、あるいは失敗した場合に
 * FALSE を返します。
 */
function shmop_write ($shmid, $data, $offset) {}

/**
 * 共有メモリブロックを削除する
 * @link http://www.php.net/manual/ja/function.shmop-delete.php
 * @param shmid int <p>
 * shmop_open
 * が作成した共有メモリブロックの識別子。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function shmop_delete ($shmid) {}

// End of shmop v.
?>
