<?php

// Start of sockets v.

/**
 * 与えられたソケットの配列に対し、指定した有効時間で select() システムコールを実行する
 * @link http://www.php.net/manual/ja/function.socket-select.php
 * @param read array <p>
 * 配列 read に挙げられたソケットでは、
 * 文字が読み込み可能になっているかどうか（厳密に言うと、読み込みが
 * ブロックされていないかどうか - 実際には、ソケット記述子はファイルの
 * 終端でも有効です。そのような場合、socket_read
 * は長さゼロの文字列を返します）を監視します。
 * </p>
 * @param write array <p>
 * 配列 write に挙げられたソケットでは、
 * 書き込みがブロックされていないかどうかを監視します。
 * </p>
 * @param except array <p>
 * 配列 except に挙げられたソケットでは、
 * 例外を監視します。
 * </p>
 * @param tv_sec int <p>
 * tv_sec および tv_usec
 * は、ともにタイムアウトを指定するパラメータです。
 * タイムアウトは、socket_select
 * が結果を返すまでの経過時間の最大値です。
 * tv_sec はゼロにすることも可能で、そうすると
 * socket_select は結果をすぐに返します。
 * これはポーリングをする際に有用です。tv_sec
 * に NULL（タイムアウトしない）を指定すると、
 * socket_select は無期限にブロックします。
 * </p>
 * @param tv_usec int[optional] <p>
 * </p>
 * @return int 成功した場合は、socket_select は配列内で
 * 変化のあったソケットリソースの数を返します。もし何かがおこる前に
 * タイムアウト時間が経過した場合は、ゼロを返すことになります。
 * エラー時には FALSE が返されます。エラーコードは
 * socket_last_error で取得可能です。
 * </p>
 * <p>
 * エラーかどうかを調べる際には、必ず === 演算子を
 * 使用するようにしましょう。socket_select は
 * 0 を返す場合もあり、このような場合に ==
 * を用いて比較すると、エラーと判定されてしまいます。
 * socket_select の返す結果を知る
 * ]]>
 */
function socket_select (array &$read, array &$write, array &$except, $tv_sec, $tv_usec = null) {}

/**
 * ソケット（通信時の終端）を作成する
 * @link http://www.php.net/manual/ja/function.socket-create.php
 * @param domain int <p>
 * パラメータ domain には、
 * ソケットが利用するプロトコルファミリーを指定します。
 * </p>
 * <table>
 * 指定可能なアドレス/プロトコルファミリーの一覧
 * <tr valign="top">
 * <td>ドメイン</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>AF_INET</td>
 * <td>
 * IPv4 インターネットプロトコル。
 * このプロトコルファミリーに属するプロトコルとしてよく知られているのは、
 * TCP や UDP です。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>AF_INET6</td>
 * <td>
 * IPv6 インターネットプロトコル。TCP と UDP
 * が、このプロトコルファミリーで一般的なプロトコルです。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>AF_UNIX</td>
 * <td>
 * ローカルでのコミュニケーションに用いられるプロトコルファミリーです。
 * 高い効率と低いオーバーヘッドを誇るため、IPC (プロセス間通信)
 * でよく使われます。
 * </td>
 * </tr>
 * </table>
 * @param type int <p>
 * type パラメータは、
 * ソケットが利用する通信方式を指定します。
 * </p>
 * <table>
 * 利用できるソケットのタイプ
 * <tr valign="top">
 * <td>タイプ</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>SOCK_STREAM</td>
 * <td>
 * このタイプでは、時系列的、高信頼性、全二重、接続型のバイトストリームが利用できます。
 * 帯域外のデータ転送メカニズムがサポートされている場合もあります。
 * TCP プロトコルは、このソケットタイプに基づきます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SOCK_DGRAM</td>
 * <td>
 * このタイプでは、データグラム(非接続型で、信頼性の高くない
 * 固定バイト長のメッセージ) がサポートされます。
 * UDP プロトコルは、このソケットタイプに基づきます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SOCK_SEQPACKET</td>
 * <td>
 * このタイプでは、時系列的な、信頼性のある、
 * 双方向の接続指向型の固定長データグラム転送が利用できます。
 * パケットを消費する側は、一つのパケット全部を一度の
 * read コールで読み込む必要があります。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SOCK_RAW</td>
 * <td>
 * このタイプでは、素のネットワークプロトコルを操作できます。
 * この特殊なソケットを使って、どのタイプのプロトコルでもユーザーの手で構築することができます。
 * よくある使い方として、(ping のような) ICMP リクエストの作成があります。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SOCK_RDM</td>
 * <td>
 * このタイプでは、信頼に足る、非時系列的なデータグラム転送が利用できます。
 * ほとんどのオペレーティングシステムでは実装されていないでしょう。
 * </td>
 * </tr>
 * </table>
 * @param protocol int <p>
 * protocol は、ソケット上の通信で使われる
 * domain で指定されたファミリーに属するプロトコルを指定します。
 * 正しい値は、getprotobyname
 * を使うことで取得できます。利用したいプロトコルが、TCP または UDP
 * の場合は、定数 SOL_TCP と
 * SOL_UDP を指定することもできます。
 * </p>
 * <table>
 * 一般的なプロトコルの一覧
 * <tr valign="top">
 * <td>名称</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>icmp</td>
 * <td>
 * Internet Control Message Protocol は、主にゲートウェイやホストが、
 * データグラム通信におけるエラーを報告するのに使われます。
 * "ping" コマンド (最近のほとんどのオペーレーティングシステムに
 * 搭載されています) が ICMP アプリケーションの一例です。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>udp</td>
 * <td>
 * User Datagram Protocol は、非接続指向の、信頼性の高くない、
 * 固定のレコード長を用いるプロトコルです。このような側面のおかげで、
 * UDP はプロトコルとして最小限のオーバーへッドしか要求しません。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>tcp</td>
 * <td>
 * Transmission Control Protocol は、信頼性の高い、接続指向かつ
 * ストリーム指向の全二重通信プロトコルです。TCP は、
 * すべてのパケットが、送信された順序で(時系列的に)受信されることを
 * 保証します。もし、何らかの理由でパケットが通信中に失われた場合、
 * TCP では、送信先から通知があるまで、パケットが再送信されるように
 * なっています。信頼性とパフォーマンス上の理由から、TCP の実装は、
 * 下層にあるデータグラム通信レイヤーのオクテット幅を
 * 適当な長さに決定します。このため、TCP アプリケーションは、
 * レコードの全部が一度に転送されない場合も考慮しなければなりません。
 * </td>
 * </tr>
 * </table>
 * @return resource socket_create は、
 * 成功時にソケットリソース、失敗時に FALSE を返します。
 * 実際のエラーコードは、socket_last_error を
 * コールすることにより取得できます。このエラーコードをさらに
 * socket_strerrorに渡すことにより、
 * エラーの内容を文字列で取得することが可能です。
 */
function socket_create ($domain, $type, $protocol) {}

/**
 * 接続を受けつけるためにポートにソケットをオープンする
 * @link http://www.php.net/manual/ja/function.socket-create-listen.php
 * @param port int <p>
 * すべてのインターフェイスで待ち受けるポート。
 * </p>
 * @param backlog int[optional] <p>
 * backlog パラメータは、
 * 接続の順番待ちのキューをどれだけの長さまで保持するかを定義します。
 * SOMAXCONN を
 * backlog パラメータに渡します。詳細な情報は
 * socket_listen を参照ください。
 * </p>
 * @return resource socket_create_listen は、
 * 成功した場合に新規ソケットリソースを、エラー時に FALSE を返します。エラーコードは
 * socket_last_error で取得可能です。このコードを
 * socket_strerror に渡すと、エラーの詳細が文字列で取得可能です。
 */
function socket_create_listen ($port, $backlog = null) {}

/**
 * 区別できないソケットの組を作成し、配列に保存する
 * @link http://www.php.net/manual/ja/function.socket-create-pair.php
 * @param domain int <p>
 * domain は、ソケットで使用するプロトコルの種類を指定します。
 * 完全な一覧は socket_create を参照ください。
 * </p>
 * @param type int <p>
 * type では、ソケットが使用する通信の形式を選択します。
 * 完全な一覧は socket_create を参照ください。
 * </p>
 * @param protocol int <p>
 * protocol は、指定した domain
 * の中の特定のプロトコルを指定します。これは、返されるソケットとの通信に使用されます。
 * 使用可能な値の名前は getprotobyname
 * で取得可能です。もし要求されるプロトコルが TCP あるいは UDP の場合、
 * 対応する定数 SOL_TCP および SOL_UDP
 * も使用可能です。
 * </p>
 * <p>
 * サポートするプロトコルの完全な一覧は socket_create を参照ください。
 * </p>
 * @param fd array <p>
 * 2 つのソケットリソースが格納される配列への参照。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function socket_create_pair ($domain, $type, $protocol, array &$fd) {}

/**
 * ソケットへの接続を許可する
 * @link http://www.php.net/manual/ja/function.socket-accept.php
 * @param socket resource <p>
 * socket_create で作成したソケットリソース。
 * </p>
 * @return resource 成功した場合に新規ソケットリソースを、エラー時に FALSE を返します。
 * 実際のエラーコードは、socket_last_error を
 * コールすることで取得可能です。このコードを
 * socket_strerror に渡すことで、
 * エラーの内容を文字列で取得することが可能です。
 */
function socket_accept ($socket) {}

/**
 * ソケットリソースを非ブロックモードに設定する
 * @link http://www.php.net/manual/ja/function.socket-set-nonblock.php
 * @param socket resource <p>
 * socket_create あるいは socket_accept
 * で作成したソケットリソース。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function socket_set_nonblock ($socket) {}

/**
 * ソケットリソースをブロックモードに設定する
 * @link http://www.php.net/manual/ja/function.socket-set-block.php
 * @param socket resource <p>
 * socket_create あるいは socket_accept
 * で作成したソケットリソース。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function socket_set_block ($socket) {}

/**
 * ソケット上で接続待ち(listen)する
 * @link http://www.php.net/manual/ja/function.socket-listen.php
 * @param socket resource <p>
 * socket_create で作成したソケットリソース。
 * </p>
 * @param backlog int[optional] <p>
 * 最大 backlog 個の接続を処理用の
 * キューで待ち受けることが可能です。もし待ちうけ用のキューが
 * いっぱいになった場合、クライアントでは ECONNREFUSED
 * の通知とともにエラーが発生します。あるいは、もし基盤となるプロトコルが
 * リクエストの再送をサポートしている場合、再試行が成功するまで
 * リクエストは無視されます。
 * </p>
 * <p>
 * backlog パラメータに指定できる値の最大値は
 * プラットフォームに大きく依存します。Linux では、最大値は
 * SOMAXCONN に切り詰められます。win32 では、
 * もし SOMAXCONN を渡した場合、backlog の
 * 最大値を適切な値に設定する責任はサービスの
 * 提供側が負います。
 * このプラットフォームでは、実際の backlog の値を見つける標準的な
 * 手段が提供されていません。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。 エラーコードは socket_last_error
 * で取得可能で、このコードを
 * socket_strerror に指定することにより
 * エラーの内容を文字列として取得可能です。
 */
function socket_listen ($socket, $backlog = null) {}

/**
 * ソケットリソースを閉じる
 * @link http://www.php.net/manual/ja/function.socket-close.php
 * @param socket resource <p>
 * socket_create あるいは socket_accept
 * で作成したソケットリソース。
 * </p>
 * @return void 値を返しません。
 */
function socket_close ($socket) {}

/**
 * ソケットに書き込む
 * @link http://www.php.net/manual/ja/function.socket-write.php
 * @param socket resource <p>
 * </p>
 * @param buffer string <p>
 * 書き込まれるバッファ。
 * </p>
 * @param length int[optional] <p>
 * オプションのパラメータ length で、
 * ソケットに書き込むバイト数を指定することが可能です。
 * この値がバッファの長さより大きい場合、自動的にバッファのサイズに切り詰められます。
 * </p>
 * @return int ソケットへの書き込みに成功したデータのバイト数を返します。失敗した場合に FALSE を返します。
 * エラーコードは socket_last_error
 * を用いて取得することができ、この値を socket_strerror
 * に渡すことでエラー情報を文字列で取得可能です。
 * </p>
 * <p>
 * socket_write がゼロを返すことも十分ありえます。
 * これは、書き込むデータが存在しなかったことを意味します。
 * エラーをチェックするために FALSE かどうかを調べる際には、必ず
 * === 演算子を使用しましょう。
 */
function socket_write ($socket, $buffer, $length = null) {}

/**
 * ソケットから最大バイト長まで読みこむ
 * @link http://www.php.net/manual/ja/function.socket-read.php
 * @param socket resource <p>
 * socket_create あるいは socket_accept
 * で作成したソケットリソース。
 * </p>
 * @param length int <p>
 * 読み込まれる最大バイト長は、length パラメータで
 * 指定します。
 * 読み込みを終了するために
 * &#92;r、&#92;n、
 * &#92;0 を使用することが可能です
 * (これは、以下に示す type に依存します)。
 * </p>
 * @param type int[optional] <p>
 * オプションのパラメータ type は、名前のある定数です。
 * PHP_BINARY_READ (デフォルト) -
 * システムの recv() 関数を
 * 使用します。バイナリデータ読み込みに関して安全です。
 * @return string socket_read は、成功時に文字列としてデータを返し、
 * エラー時 (リモートホストが接続をクローズした場合を含みます)
 * に FALSE を返します。
 * エラーコードは socket_last_error で取得可能であり、
 * このコードは、エラー文字列を取得するために
 * socket_strerror に渡すことができます。
 * </p>
 * <p>
 * socket_read は、読み込むデータがもう存在しない
 * 場合に長さゼロの文字列("")を返します。
 */
function socket_read ($socket, $length, $type = null) {}

/**
 * 指定したソケットのローカル側に問い合わせ、その型に応じてホスト/ポート、あるいは Unix ファイルシステムのパスを返す
 * @link http://www.php.net/manual/ja/function.socket-getsockname.php
 * @param socket resource <p>
 * socket_create あるいは socket_accept
 * で作成したソケットリソース。
 * </p>
 * @param addr string <p>
 * 指定されたソケットの型が AF_INET あるいは
 * AF_INET6 であった場合、socket_getsockname
 * はローカルの IP アドレス を適切な書式（例:
 * 127.0.0.1 あるいは fe80::1）に
 * したものを address パラメータに、そしてもし
 * オプションの port パラメータが指定されていれば
 * そこにポートを格納します。
 * </p>
 * <p>
 * 指定されたソケットの型が AF_UNIX であった場合、
 * socket_getpeername は Unix ファイルシステムのパス
 * （例: /var/run/daemon.sock）を
 * address パラメータに格納します。
 * </p>
 * @param port int[optional] <p>
 * 指定した場合は、関連付けるポートを保持します。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。 socket_getsockname は、
 * ソケットの型が AF_INET、
 * AF_INET6 あるいは AF_UNIX
 * のいずれでもない場合にも FALSE を返します。この場合には、
 * 直近のソケットエラーコードは更新されません。
 */
function socket_getsockname ($socket, &$addr, &$port = null) {}

/**
 * 指定したソケットのリモート側に問い合わせ、その型に応じてホスト/ポート、あるいは Unix ファイルシステムのパスを返す
 * @link http://www.php.net/manual/ja/function.socket-getpeername.php
 * @param socket resource <p>
 * socket_create あるいは socket_accept
 * で作成したソケットリソース。
 * </p>
 * @param address string <p>
 * 指定されたソケットの型が AF_INET あるいは
 * AF_INET6 であった場合、socket_getpeername
 * はピア（リモート）の IP アドレス を適切な書式（例:
 * 127.0.0.1 あるいは fe80::1）に
 * したものを address パラメータに、そしてもし
 * オプションの port パラメータが指定されていれば
 * そこにポートを格納します。
 * </p>
 * <p>
 * 指定されたソケットの型が AF_UNIX であった場合、
 * socket_getpeername は Unix ファイルシステムの
 * パス（例: /var/run/daemon.sock）を
 * address パラメータに格納します。
 * </p>
 * @param port int[optional] <p>
 * 指定した場合は、
 * address に関連付けるポートを保持します。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。 socket_getpeername は、
 * ソケットの型が AF_INET、
 * AF_INET6 あるいは AF_UNIX
 * のいずれでもない場合にも FALSE を返します。この場合には、
 * 直近のソケットエラーコードは更新されません。
 */
function socket_getpeername ($socket, &$address, &$port = null) {}

/**
 * ソケット上の接続を初期化する
 * @link http://www.php.net/manual/ja/function.socket-connect.php
 * @param socket resource <p>
 * </p>
 * @param address string <p>
 * パラメータ address には、
 * socket の種類が AF_INET の場合はドット区切り表記の
 * IPv4 アドレス (例: 127.0.0.1)、
 * IPv6 サポートが有効で socket の種類が
 * AF_INET6 の場合は
 * IPv6 アドレス (例: ::1)、
 * AF_UNIX の場合は Unix ドメインソケットのパス名を指定します。
 * </p>
 * @param port int[optional] <p>
 * パラメータ port は
 * AF_INET ソケット
 * あるいは AF_INET6 に接続する場合にのみ必須となり、
 * 接続するリモートホストのポートを指定します。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。 エラーコードは、
 * socket_last_error により取得できます。
 * このコードを socket_strerror に渡すことにより、
 * エラー内容を表すテキストを得ることができます。
 * </p>
 * <p>
 * ソケットが非ブロッキングモードの場合、この関数は
 * FALSE を返し、エラー
 * Operation now in progress を発生させます。
 */
function socket_connect ($socket, $address, $port = null) {}

/**
 * ソケットエラーの内容を文字列として返す
 * @link http://www.php.net/manual/ja/function.socket-strerror.php
 * @param errno int <p>
 * ソケットのエラー番号。たいていは
 * socket_last_error が返したものとなるでしょう。
 * </p>
 * @return string errno パラメータに対応するエラーメッセージを返します。
 */
function socket_strerror ($errno) {}

/**
 * ソケットに名前をバインドする
 * @link http://www.php.net/manual/ja/function.socket-bind.php
 * @param socket resource <p>
 * socket_create で作成した有効なソケット記述子。
 * </p>
 * @param address string <p>
 * ソケットの種類が AF_INET の場合、
 * address はドットで 4 つに区切られた表記
 * （例: 127.0.0.1）の IP アドレス。
 * </p>
 * <p>
 * ソケットの種類が AF_UNIX の場合、
 * address は Unix ドメインソケット
 * （例: /tmp/my.sock）。
 * </p>
 * @param port int[optional] <p>
 * パラメータ port は
 * AF_INET ソケットにバインドする場合にのみ使用され、
 * 接続するリモートホストのポートを指定します。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 * </p>
 * <p>
 * エラーコードは socket_last_error により取得できます。
 * このコードを socket_strerror に渡すことにより、
 * エラー内容を表すテキストを得ることができます。
 */
function socket_bind ($socket, $address, $port = null) {}

/**
 * 接続したソケットからデータを受信する
 * @link http://www.php.net/manual/ja/function.socket-recv.php
 * @param socket resource <p>
 * socket は、事前に
 * socket_create() で作成したソケットリソースでなければなりません。
 * </p>
 * @param buf string <p>
 * 受信したデータが、
 * buf で指定した変数に格納されます。
 * エラーが発生したり接続がリセットされたりデータが存在しなかったりした場合は、
 * buf には NULL が設定されます。
 * </p>
 * @param len int <p>
 * 最大 len バイトまでをリモートホストから取得します。
 * </p>
 * @param flags int <p>
 * flags の値は、次のフラグを論理 OR
 * (|) 演算子で組み合わせたものとなります。
 * </p>
 * <table>
 * flags のとりうる値
 * <tr valign="top">
 * <td>フラグ</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>MSG_OOB</td>
 * <td>
 * out-of-band を処理します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MSG_PEEK</td>
 * <td>
 * 受信キューの先頭からデータを取得し、受信したデータをキューから削除しません。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MSG_WAITALL</td>
 * <td>
 * 最低 len バイト受信するまでブロックします。
 * しかし、シグナルを受け取ったりリモートホストが接続を切断したりした場合は、
 * この関数が返すデータがそれより少なくなる可能性があります。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MSG_DONTWAIT</td>
 * <td>
 * このフラグを設定すると、正常にブロックされている状態でも関数が結果を返します。
 * </td>
 * </tr>
 * </table>
 * @return int socket_recv は、受信したバイト数を返します。
 * エラーが発生した場合は FALSE を返します。
 * 実際のエラーコードを取得するには
 * socket_last_error をコールします。
 * このエラーコードを socket_strerror
 * に渡すと、エラーに関する説明テキストを取得することができます。
 */
function socket_recv ($socket, &$buf, $len, $flags) {}

/**
 * 接続したソケットにデータを送信する
 * @link http://www.php.net/manual/ja/function.socket-send.php
 * @param socket resource <p>
 * socket_create あるいは socket_accept
 * が作成したソケットリソース。
 * </p>
 * @param buf string <p>
 * リモートホストに送信するデータを含むバッファ。
 * </p>
 * @param len int <p>
 * buf からリモートホストに送信するバイト数。
 * </p>
 * @param flags int <p>
 * flags の値は、以下のフラグの任意の組み合わせを
 * 論理 OR 演算子 (|) で連結したものとなります。
 * <table>
 * flags がとりうる値
 * <tr valign="top">
 * <td>MSG_OOB</td>
 * <td>
 * OOB（out-of-band: 帯域外）データを送信します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MSG_EOR</td>
 * <td>
 * レコードにマークをつけます。
 * レコードでデータがそろいます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MSG_EOF</td>
 * <td>
 * ソケットの送信側を閉じ、そのことを知らせる通知を送信データの最後に付加します。
 * トランザクションでデータがそろいます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MSG_DONTROUTE</td>
 * <td>
 * ルータを使用せず、直接つながっているインターフェイスのみを使用します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @return int socket_send は、送信したバイト数あるいはエラー時に FALSE を返します。
 */
function socket_send ($socket, $buf, $len, $flags) {}

/**
 * 接続しているかどうかによらず、ソケットからデータを受信する
 * @link http://www.php.net/manual/ja/function.socket-recvfrom.php
 * @param socket resource <p>
 * socket には、
 * socket_create() で作成したソケットリソースを指定します。
 * </p>
 * @param buf string <p>
 * 受信したデータが
 * buf に格納されます。
 * </p>
 * @param len int <p>
 * 最大 len バイトまでのデータをリモートホストから取得します。
 * </p>
 * @param flags int <p>
 * flags の値は、以下のフラグの任意の組み合わせを
 * 論理 OR 演算子 (|) で連結したものとなります。
 * </p>
 * <table>
 * flags に使用できる値
 * <tr valign="top">
 * <td>フラグ</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>MSG_OOB</td>
 * <td>
 * 帯域外 (out-of-band) のデータを処理する。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MSG_PEEK</td>
 * <td>
 * 受信キューの先頭にあるデータを受信し、
 * そのデータをそのままキューに残しておく。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MSG_WAITALL</td>
 * <td>
 * 少なくとも len バイト受信するまではブロックする。
 * しかし、もし何らかのシグナルを受信したりリモートホストとの接続が切断された場合は
 * これより少ないバイト数を返す可能性がある。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MSG_DONTWAIT</td>
 * <td>
 * 通常はブロックする場面であってもそのまま return する。
 * </td>
 * </tr>
 * </table>
 * @param name string <p>
 * AF_UNIX 型のソケットの場合は、
 * name はファイルへのパスとなります。
 * それ以外の場合は、未接続のソケットの場合には
 * name はリモートホストの IP アドレスとなります。
 * 接続済みソケットの場合は NULL となります。
 * </p>
 * @param port int[optional] <p>
 * この引数は AF_INET 型あるいは
 * AF_INET6 型のソケットに対してのみ適用され、
 * データを受信するリモートホストのポートを指定します。
 * 接続済みソケットの場合は
 * port は NULL となります。
 * </p>
 * @return int socket_recvfrom は、受信したバイト数を返します。
 * あるいはエラー時には FALSE を返します。
 * エラーコードを取得するには socket_last_error
 * をコールします。取得したエラーコードを
 * socket_strerror に渡すと、
 * そのエラーについての説明を得ることができます。
 */
function socket_recvfrom ($socket, &$buf, $len, $flags, &$name, &$port = null) {}

/**
 * 接続しているかどうかによらずソケットにメッセージを送信する
 * @link http://www.php.net/manual/ja/function.socket-sendto.php
 * @param socket resource <p>
 * socket_create で作成したソケットリソース。
 * </p>
 * @param buf string <p>
 * 送信するデータが、buf から取り出されます。
 * </p>
 * @param len int <p>
 * buf から
 * len バイト分のデータが送信されます。
 * </p>
 * @param flags int <p>
 * flags の値は、以下のフラグの任意の組み合わせを
 * 論理 OR 演算子 (|) で連結したものとなります。
 * <table>
 * flags がとりうる値
 * <tr valign="top">
 * <td>MSG_OOB</td>
 * <td>
 * OOB（out-of-band: 帯域外）データを送信します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MSG_EOR</td>
 * <td>
 * レコードにマークをつけます。
 * レコードでデータがそろいます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MSG_EOF</td>
 * <td>
 * ソケットの送信側を閉じ、そのことを知らせる通知を送信データの最後に付加します。
 * トランザクションでデータがそろいます。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MSG_DONTROUTE</td>
 * <td>
 * ルータを使用せず、直接つながっているインターフェイスのみを使用します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param addr string <p>
 * リモートホストの IP アドレス。
 * </p>
 * @param port int[optional] <p>
 * port は、
 * データの送信先となるリモートホストのポート番号です。
 * </p>
 * @return int socket_sendto は、リモートホストに送信したバイト数を返します。
 * エラーが発生した場合は FALSE を返します。
 */
function socket_sendto ($socket, $buf, $len, $flags, $addr, $port = null) {}

/**
 * ソケットのオプションを取得する
 * @link http://www.php.net/manual/ja/function.socket-get-option.php
 * @param socket resource <p>
 * socket_create あるいは socket_accept
 * で作成したソケットリソース。
 * </p>
 * @param level int <p>
 * level パラメータは、オプションのプロトコルレベルを指定します。
 * 例えば、オプションをソケットレベルで取得するには
 * level パラメータに SOL_SOCKET を指定します。
 * TCP のようなそれ以外のレベルの場合、そのレベルのプロトコル番号を指定します。
 * プロトコル番号は getprotobyname
 * 関数を使用して取得可能です。
 * </p>
 * @param optname int <table>
 * 使用可能なソケットオプション
 * <tr valign="top">
 * <td>オプション</td>
 * <td>説明</td>
 * <td>型</td>
 * </tr>
 * <tr valign="top">
 * <td>SO_DEBUG</td>
 * <td>
 * デバッグ情報を記録するかどうかを報告します。
 * </td>
 * <td>
 * int
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SO_BROADCAST</td>
 * <td>
 * ブロードキャストメッセージの送信がサポートされているかどうかを報告します。
 * </td>
 * <td>
 * int
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SO_REUSEADDR</td>
 * <td>
 * ローカルアドレスが再使用可能するかどうかを報告します。
 * </td>
 * <td>
 * int
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SO_KEEPALIVE</td>
 * <td>
 * 定期的なメッセージの送信によって接続がアクティブになっているかどうかを報告します。
 * もしソケットがこれらのメッセージに応答できなかった場合、
 * 接続は崩壊し、ソケットへの書き込みを行うと SIGPIPE シグナルを受け取ります。
 * </td>
 * <td>
 * int
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SO_LINGER</td>
 * <td>
 * <p>
 * データがまだ残っているうちに socket_close
 * をコールした場合に、socket を残存させるかどうかを報告します。
 * デフォルトでは、ソケットが閉じられる際には未送信のデータをすべて送信しようとします。
 * 接続ベースのソケットでは、
 * socket_close は接続先がデータを認識するまで閉じるのを待ちます。
 * </p>
 * <p>
 * l_onoff が非ゼロで
 * l_linger がゼロの場合は、
 * その時点で未送信のデータはすべて破棄されます。
 * 接続ベースのソケットの場合、接続先には RST (リセット)
 * を送信します。
 * </p>
 * <p>
 * 一方 l_onoff が非ゼロで
 * l_linger も非ゼロの場合は、
 * socket_close は
 * 全データを送信し終えるか l_linger
 * で指定した時間が経過するまで処理をブロックします。
 * ソケットが非ブロックモードの場合は、
 * socket_close は失敗してエラーを返します。
 * </p>
 * </td>
 * <td>
 * array。配列に含まれるキーは
 * l_onoff および
 * l_linger のふたつ。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SO_OOBINLINE</td>
 * <td>
 * socket
 * が帯域外のデータをインラインに残し続けるかを報告します。
 * </td>
 * <td>
 * int
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SO_SNDBUF</td>
 * <td>
 * 送信バッファのサイズを報告します。
 * </td>
 * <td>
 * int
 * </td> 
 * </tr>
 * <tr valign="top">
 * <td>SO_RCVBUF</td>
 * <td>
 * 受信バッファのサイズを報告します。
 * </td>
 * <td>
 * int
 * </td> 
 * </tr>
 * <tr valign="top">
 * <td>SO_ERROR</td>
 * <td>
 * エラーステータスに関する情報を報告し、それをクリアします。
 * </td>
 * <td>
 * int (socket_set_option で設定することはできません)
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SO_TYPE</td>
 * <td>
 * socket の型 (たとえば SOCK_STREAM) を報告します。
 * </td>
 * <td>
 * int (socket_set_option で設定することはできません)
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SO_DONTROUTE</td>
 * <td>
 * 送信メッセージがルータを越えるかどうかを報告します。
 * </td>
 * <td>
 * int
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SO_RCVLOWAT</td>
 * <td>
 * socket の入力操作を行う際の最小バイト数を報告します。
 * </td>
 * <td>
 * int
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SO_RCVTIMEO</td>
 * <td>
 * 入力操作のタイムアウト値を報告します。
 * </td>
 * <td>
 * array。配列に含まれるキーはふたつ。
 * sec はタイムアウトの秒単位の部分で、
 * usec はタイムアウトのマイクロ秒位の部分。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SO_SNDTIMEO</td>
 * <td>
 * 出力関数がフロー制御のためにブロックするタイムアウト値を報告します。
 * </td>
 * <td>
 * array。配列に含まれるキーはふたつ。
 * sec はタイムアウトの秒単位の部分で、
 * usec はタイムアウトのマイクロ秒位の部分。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>SO_SNDLOWAT</td>
 * <td>
 * socket
 * の出力操作を行う際の最小バイト数を報告します。
 * </td>
 * <td>
 * int
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>TCP_NODELAY</td>
 * <td>
 * Nagle TCP アルゴリズムが無効になっているかどうかを報告します。
 * </td>
 * <td>
 * int
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MCAST_JOIN_GROUP</td>
 * <td>
 * マルチキャストグループに参加します (PHP 5.4 で追加)。
 * </td>
 * <td>
 * 二つのキー "group" と "interface"
 * を含む配列。"group" には IPv4 あるいは IPv6
 * のマルチキャストアドレスを文字列で指定します。
 * "interface" には、インターフェイス番号 (整数値)
 * あるいは "eth0" などのインターフェイス名 (文字列) を指定します。
 * 0 を指定すると、ルーティングテーブルを使ってインターフェイスを選択します
 * (socket_set_option でのみ利用可能)。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MCAST_LEAVE_GROUP</td>
 * <td>
 * マルチキャストグループから離れます (PHP 5.4 で追加)。
 * </td>
 * <td>
 * 配列。詳細は MCAST_JOIN_GROUP を参照ください
 * (socket_set_option でのみ利用可能)。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MCAST_BLOCK_SOURCE</td>
 * <td>
 * 特定のソースから、そのマルチキャストグループにやってくるパケットをブロックします。
 * そのマルチキャストグループに事前に参加しておく必要があります
 * (PHP 5.4 で追加)。
 * </td>
 * <td>
 * MCAST_JOIN_GROUP と同じキーを含み、さらに追加でもうひとつのキーを含む配列。
 * 追加のキーは source で、
 * ブロック対象となるソースの IPv4 アドレスあるいは IPv6 アドレスを文字列で指定します
 * (socket_set_option でのみ利用可能)。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MCAST_UNBLOCK_SOURCE</td>
 * <td>
 * 特定のソースから、そのマルチキャストグループにやってくるパケットのブロックを解除 (そして、受信を再開) します。
 * そのマルチキャストグループに事前に参加しておく必要があります
 * (PHP 5.4 で追加)。
 * </td>
 * <td>
 * MCAST_BLOCK_SOURCE と同じ形式の配列
 * (socket_set_option でのみ利用可能)。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MCAST_JOIN_SOURCE_GROUP</td>
 * <td>
 * 特定の値にマッチするソースアドレスからそのマルチキャストグループにやってきたパケットを受信します
 * (PHP 5.4 で追加)。
 * </td>
 * <td>
 * MCAST_BLOCK_SOURCE と同じ形式の配列
 * (socket_set_option でのみ利用可能)。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>MCAST_LEAVE_SOURCE_GROUP</td>
 * <td>
 * 特定の値にマッチするソースアドレスからそのマルチキャストグループにやってきたパケットの受信を停止します
 * (PHP 5.4 で追加)。
 * </td>
 * <td>
 * MCAST_BLOCK_SOURCE と同じ形式の配列
 * (socket_set_option でのみ利用可能)。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>IP_MULTICAST_IF</td>
 * <td>
 * IPv4 マルチキャストパケットの送信インターフェイス
 * (PHP 5.4 で追加)。
 * </td>
 * <td>
 * インターフェイス番号を表す整数値か、インターフェイス名を表す
 * eth0 のような文字列。
 * 0 を指定すると、ルーティングテーブルを使ってインターフェイスを選択します。
 * socket_get_option 関数の返り値は、インターフェイスのインデックスとなります。
 * 注意すべき点は、C の API とは違ってこのオプションには IP アドレスを渡せないということです。
 * そのため、
 * IP_MULTICAST_IF と
 * IPV6_MULTICAST_IF のインターフェイスの相違はなくなります。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>IPV6_MULTICAST_IF</td>
 * <td>
 * IPv6 マルチキャストパケットの送信インターフェイス
 * (PHP 5.4 で追加)。
 * </td>
 * <td>
 * IP_MULTICAST_IF と同じ。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>IP_MULTICAST_LOOP</td>
 * <td>
 * IPv4 パケットのマルチキャストループバックポリシー。
 * このソケットが送信したマルチキャストパケットが、
 * このソケットが使う送信インターフェイス上の同一マルチキャストグループに属する
 * 同一ホスト上の受信者にも届くかどうかを示します。
 * これはデフォルトの動作です
 * (PHP 5.4 で追加)。
 * </td>
 * <td>
 * 整数値 (0 あるいは
 * 1)。socket_set_option
 * では任意の値を受け付けますが、通常の PHP のルールに従ってそれを
 * boolean 値に変換します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>IPV6_MULTICAST_LOOP</td>
 * <td>
 * IP_MULTICAST_LOOP の IPv6 版
 * (PHP 5.4 で追加)。
 * </td>
 * <td>
 * 整数値。IP_MULTICAST_LOOP を参照ください。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>IP_MULTICAST_TTL</td>
 * <td>
 * IPv4 送信パケットの有効期間。0 (このインターフェイスから離れない)
 * から 255 までの値を指定しなければなりません。デフォルトは
 * 1 (ローカルネットワークにだけ到達する) です
 * (PHP 5.4 で追加)。
 * </td>
 * <td>
 * 0 から 255 までの整数値。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>IPV6_MULTICAST_HOPS</td>
 * <td>
 * IP_MULTICAST_TTL の IPv6 版。
 * 値として -1 を指定することもでき、これはデフォルトのルートを使うことを意味します
 * (PHP 5.4 で追加)。
 * </td>
 * <td>
 * -1 から 255 までの整数値。
 * </td>
 * </tr>
 * </table>
 * @return mixed 指定したオプションの値、あるいはエラー時に FALSE を返します。
 */
function socket_get_option ($socket, $level, $optname) {}

/**
 * ソケットのオプションを設定する
 * @link http://www.php.net/manual/ja/function.socket-set-option.php
 * @param socket resource <p>
 * socket_create あるいは socket_accept
 * で作成したソケットリソース。
 * </p>
 * @param level int <p>
 * level パラメータは、オプションのプロトコルレベルを指定します。
 * 例えば、オプションをソケットレベルで取得するには
 * level パラメータに SOL_SOCKET を指定します。
 * TCP のようなそれ以外のレベルの場合、そのレベルのプロトコル番号を指定します。
 * プロトコル番号は getprotobyname
 * 関数を使用して取得可能です。
 * </p>
 * @param optname int <p>
 * 使用可能なソケットオプションは socket_get_option
 * 関数と同じです。
 * </p>
 * @param optval mixed <p>
 * オプションの値。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function socket_set_option ($socket, $level, $optname, $optval) {}

/**
 * 受信、送信、または送受信用のソケットをシャットダウンする
 * @link http://www.php.net/manual/ja/function.socket-shutdown.php
 * @param socket resource <p>
 * socket_create で作成したソケットリソース。
 * </p>
 * @param how int[optional] <p>
 * how の値は以下のうちのひとつです。
 * <table>
 * how のとりうる値
 * <tr valign="top">
 * <td>0</td>
 * <td>
 * ソケットの読み込みを停止します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>1</td>
 * <td>
 * ソケットの書き込みを停止します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>2</td>
 * <td>
 * ソケットの読み込み・書き込みを停止します。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function socket_shutdown ($socket, $how = null) {}

/**
 * ソケットの直近のエラーを返す
 * @link http://www.php.net/manual/ja/function.socket-last-error.php
 * @param socket resource[optional] <p>
 * socket_create で作成したソケットリソース。
 * </p>
 * @return int この関数は、ソケットのエラーコードを返します。
 */
function socket_last_error ($socket = null) {}

/**
 * ソケットのエラーまたは直近のエラーコードをクリアする
 * @link http://www.php.net/manual/ja/function.socket-clear-error.php
 * @param socket resource[optional] <p>
 * socket_create で作成したソケットリソース。
 * </p>
 * @return void 値を返しません。
 */
function socket_clear_error ($socket = null) {}

/**
 * ストリームをインポートする
 * @link http://www.php.net/manual/ja/function.socket-import-stream.php
 * @param stream resource <p>
 * インポートするストリームリソース。
 * </p>
 * @return resource FALSE を返します。失敗した場合は NULL を返します。
 */
function socket_import_stream ($stream) {}

/**
 * @param socket
 * @param level
 * @param optname
 */
function socket_getopt ($socket, $level, $optname) {}

/**
 * @param socket
 * @param level
 * @param optname
 * @param optval
 */
function socket_setopt ($socket, $level, $optname, $optval) {}

define ('AF_UNIX', 1);
define ('AF_INET', 2);

/**
 * IPv6 サポートつきでコンパイルした場合にのみ使用可能です。
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('AF_INET6', 23);
define ('SOCK_STREAM', 1);
define ('SOCK_DGRAM', 2);
define ('SOCK_RAW', 3);
define ('SOCK_SEQPACKET', 5);
define ('SOCK_RDM', 4);
define ('MSG_OOB', 1);
define ('MSG_WAITALL', 0);
define ('MSG_PEEK', 2);
define ('MSG_DONTROUTE', 4);
define ('SO_DEBUG', 1);
define ('SO_REUSEADDR', 4);
define ('SO_KEEPALIVE', 8);
define ('SO_DONTROUTE', 16);
define ('SO_LINGER', 128);
define ('SO_BROADCAST', 32);
define ('SO_OOBINLINE', 256);
define ('SO_SNDBUF', 4097);
define ('SO_RCVBUF', 4098);
define ('SO_SNDLOWAT', 4099);
define ('SO_RCVLOWAT', 4100);
define ('SO_SNDTIMEO', 4101);
define ('SO_RCVTIMEO', 4102);
define ('SO_TYPE', 4104);
define ('SO_ERROR', 4103);
define ('SOL_SOCKET', 65535);
define ('SOMAXCONN', 2147483647);

/**
 * Nagle TCP アルゴリズムを無効にするために使用します。
 * PHP 5.2.7 で追加されました。
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('TCP_NODELAY', 1);
define ('PHP_NORMAL_READ', 1);
define ('PHP_BINARY_READ', 2);
define ('MCAST_JOIN_GROUP', 12);
define ('MCAST_LEAVE_GROUP', 13);
define ('MCAST_BLOCK_SOURCE', 17);
define ('MCAST_UNBLOCK_SOURCE', 18);
define ('MCAST_JOIN_SOURCE_GROUP', 15);
define ('MCAST_LEAVE_SOURCE_GROUP', 16);
define ('IP_MULTICAST_IF', 9);
define ('IP_MULTICAST_TTL', 10);
define ('IP_MULTICAST_LOOP', 11);
define ('IPV6_MULTICAST_IF', 9);
define ('IPV6_MULTICAST_HOPS', 10);
define ('IPV6_MULTICAST_LOOP', 11);

/**
 * Interrupted system call.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EINTR', 10004);

/**
 * Bad file number.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EBADF', 10009);

/**
 * Permission denied.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EACCES', 10013);

/**
 * Bad address.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EFAULT', 10014);

/**
 * Invalid argument.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EINVAL', 10022);

/**
 * Too many open files.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EMFILE', 10024);

/**
 * Operation would block.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EWOULDBLOCK', 10035);

/**
 * Operation now in progress.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EINPROGRESS', 10036);

/**
 * Operation already in progress.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EALREADY', 10037);

/**
 * Socket operation on non-socket.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ENOTSOCK', 10038);

/**
 * Destination address required.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EDESTADDRREQ', 10039);

/**
 * Message too long.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EMSGSIZE', 10040);

/**
 * Protocol wrong type for socket.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EPROTOTYPE', 10041);
define ('SOCKET_ENOPROTOOPT', 10042);

/**
 * Protocol not supported.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EPROTONOSUPPORT', 10043);

/**
 * Socket type not supported.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ESOCKTNOSUPPORT', 10044);

/**
 * Operation not supported on transport endpoint.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EOPNOTSUPP', 10045);

/**
 * Protocol family not supported.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EPFNOSUPPORT', 10046);

/**
 * Address family not supported by protocol.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EAFNOSUPPORT', 10047);
define ('SOCKET_EADDRINUSE', 10048);

/**
 * Cannot assign requested address.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EADDRNOTAVAIL', 10049);

/**
 * Network is down.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ENETDOWN', 10050);

/**
 * Network is unreachable.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ENETUNREACH', 10051);

/**
 * Network dropped connection because of reset.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ENETRESET', 10052);

/**
 * Software caused connection abort.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ECONNABORTED', 10053);

/**
 * Connection reset by peer.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ECONNRESET', 10054);

/**
 * No buffer space available.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ENOBUFS', 10055);

/**
 * Transport endpoint is already connected.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EISCONN', 10056);

/**
 * Transport endpoint is not connected.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ENOTCONN', 10057);

/**
 * Cannot send after transport endpoint shutdown.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ESHUTDOWN', 10058);

/**
 * Too many references: cannot splice.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ETOOMANYREFS', 10059);

/**
 * Connection timed out.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ETIMEDOUT', 10060);

/**
 * Connection refused.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ECONNREFUSED', 10061);

/**
 * Too many symbolic links encountered.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ELOOP', 10062);

/**
 * File name too long.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ENAMETOOLONG', 10063);

/**
 * Host is down.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EHOSTDOWN', 10064);

/**
 * No route to host.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EHOSTUNREACH', 10065);

/**
 * Directory not empty.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_ENOTEMPTY', 10066);
define ('SOCKET_EPROCLIM', 10067);

/**
 * Too many users.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EUSERS', 10068);

/**
 * Quota exceeded.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EDQUOT', 10069);
define ('SOCKET_ESTALE', 10070);

/**
 * Object is remote.
 * @link http://www.php.net/manual/ja/sockets.constants.php
 */
define ('SOCKET_EREMOTE', 10071);
define ('SOCKET_EDISCON', 10101);
define ('SOCKET_SYSNOTREADY', 10091);
define ('SOCKET_VERNOTSUPPORTED', 10092);
define ('SOCKET_NOTINITIALISED', 10093);
define ('SOCKET_HOST_NOT_FOUND', 11001);
define ('SOCKET_TRY_AGAIN', 11002);
define ('SOCKET_NO_RECOVERY', 11003);
define ('SOCKET_NO_DATA', 11004);
define ('SOCKET_NO_ADDRESS', 11004);
define ('IPPROTO_IP', 0);
define ('IPPROTO_IPV6', 41);
define ('SOL_TCP', 6);
define ('SOL_UDP', 17);

// End of sockets v.
?>
