<?php

// Start of wddx v.

/**
 * 単一の値を WDDX パケットにシリアライズする
 * @link http://www.php.net/manual/ja/function.wddx-serialize-value.php
 * @param var mixed <p>
 * シリアライズする値。
 * </p>
 * @param comment string[optional] <p>
 * オプションのコメント文字列。これはヘッダ内で用いられます。
 * </p>
 * @return string WDDX パケット、あるいはエラー時に FALSE を返します。
 */
function wddx_serialize_value ($var, $comment = null) {}

/**
 * 変数を WDDX パケットにシリアライズする
 * @link http://www.php.net/manual/ja/function.wddx-serialize-vars.php
 * @param var_name mixed <p>
 * 変数名を表す文字列、あるいは配列。
 * 配列の中身は、変数名を表す文字列あるいは別の配列などとなります。
 * </p>
 * @param _ mixed[optional] 
 * @return string WDDX パケット、あるいはエラー時に FALSE を返します。
 */
function wddx_serialize_vars ($var_name, $_ = null) {}

/**
 * 新規の WDDX パケットを内部の構造体を用いて開始する
 * @link http://www.php.net/manual/ja/function.wddx-packet-start.php
 * @param comment string[optional] <p>
 * オプションのコメント文字列。
 * </p>
 * @return resource 後で他の関数で使用するためのパケット ID、あるいはエラー時に FALSE を返します。
 */
function wddx_packet_start ($comment = null) {}

/**
 * 指定した ID の WDDX パケットを終了する
 * @link http://www.php.net/manual/ja/function.wddx-packet-end.php
 * @param packet_id resource <p>
 * wddx_packet_start が返す WDDX パケット。
 * </p>
 * @return string WDDX パケットを含む文字列を返します。
 */
function wddx_packet_end ($packet_id) {}

/**
 * 指定した ID の WDDX パケットに変数を追加する
 * @link http://www.php.net/manual/ja/function.wddx-add-vars.php
 * @param packet_id resource <p>
 * wddx_packet_start が返す WDDX パケット。
 * </p>
 * @param var_name mixed <p>
 * 変数名を表す文字列、あるいは配列。
 * 配列の中身は、変数名を表す文字列あるいは別の配列などとなります。
 * </p>
 * @param _ mixed[optional] 
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function wddx_add_vars ($packet_id, $var_name, $_ = null) {}

/**
 * WDDX パケットをデシリアライズする
 * @link http://www.php.net/manual/ja/function.wddx-deserialize.php
 * @param packet string <p>
 * WDDX パケット。文字列あるいはストリームで指定します。
 * </p>
 * @return mixed デシリアライズした値を返します。値は文字列か数値、あるいは配列のいずれかとなります。
 * 構造体は連想配列に変換されることに注意しましょう。
 */
function wddx_deserialize ($packet) {}

// End of wddx v.
?>
