<?php

// Start of calendar v.

/**
 * ユリウス積算日をグレゴリウス日に変換する
 * @link http://www.php.net/manual/ja/function.jdtogregorian.php
 * @param julianday int <p>
 * ユリウス積算日を表す整数値。
 * </p>
 * @return string グレゴリウス暦の日付を "月/日/年" 形式の文字列で返します。
 */
function jdtogregorian ($julianday) {}

/**
 * グレゴリウス日をユリウス積算日に変換する
 * @link http://www.php.net/manual/ja/function.gregoriantojd.php
 * @param month int <p>
 * 月を表す、1 (January) から 12 (December) までの数字。
 * </p>
 * @param day int <p>
 * 日を表す、1 から 31 までの数字。
 * </p>
 * @param year int <p>
 * 年を表す、-4714 から 9999 までの数字。
 * </p>
 * @return int 指定したグレゴリウス日をユリウス積算日になおした結果を返します。
 */
function gregoriantojd ($month, $day, $year) {}

/**
 * ユリウス積算日をユリウス暦に変換する
 * @link http://www.php.net/manual/ja/function.jdtojulian.php
 * @param julianday int <p>
 * ユリウス積算日を表す整数値。
 * </p>
 * @return string ユリウス暦の日付を "月/日/年" 形式の文字列で返します。
 */
function jdtojulian ($julianday) {}

/**
 * ユリウス暦をユリウス積算日に変換する
 * @link http://www.php.net/manual/ja/function.juliantojd.php
 * @param month int <p>
 * 月を表す、1 (for January) から 12 (for December) までの数値。
 * </p>
 * @param day int <p>
 * 日を表す、1 から 31 までの数値。
 * </p>
 * @param year int <p>
 * 年を表す、-4713 から 9999 までの数値。
 * </p>
 * @return int 指定したユリウス暦の日付に対応するユリウス積算日を返します。
 */
function juliantojd ($month, $day, $year) {}

/**
 * ユリウス積算日をユダヤ暦に変換する
 * @link http://www.php.net/manual/ja/function.jdtojewish.php
 * @param juliandaycount int 
 * @param hebrew bool[optional] <p>
 * パラメータ hebrew が TRUE に設定されている場合、
 * ヘブライ語の文字列形式での出力のために fl
 * が使用されます。
 * </p>
 * @param fl int[optional] <p>
 * 使用可能なフォーマットは
 * CAL_JEWISH_ADD_ALAFIM_GERESH、
 * CAL_JEWISH_ADD_ALAFIM および
 * CAL_JEWISH_ADD_GERESHAYIM です。
 * </p>
 * @return string ユダヤ暦の日付を "月/日/年" 形式の文字列で返します。
 */
function jdtojewish ($juliandaycount, $hebrew = null, $fl = null) {}

/**
 * ユダヤ暦の日付けをユリウス積算日に変換する
 * @link http://www.php.net/manual/ja/function.jewishtojd.php
 * @param month int <p>
 * 月を表す、1 から 13 までの数値。
 * </p>
 * @param day int <p>
 * 日を表す、1 から 30 までの数値。
 * </p>
 * @param year int <p>
 * 年を表す、1 から 9999 までの数値。
 * </p>
 * @return int 指定したユダヤ暦の日付に対応するユリウス積算日を返します。
 */
function jewishtojd ($month, $day, $year) {}

/**
 * ユリウス積算日をフランス革命暦(共和暦)に変換する
 * @link http://www.php.net/manual/ja/function.jdtofrench.php
 * @param juliandaycount int 
 * @return string フランス革命暦の日付を "月/日/年" 形式の文字列で返します。
 */
function jdtofrench ($juliandaycount) {}

/**
 * フランス革命暦をユリウス積算日に変換する
 * @link http://www.php.net/manual/ja/function.frenchtojd.php
 * @param month int <p>
 * 月を表す、1 (VendĂŠmiaire) から 13 (各年の最後の 5-6 日)
 * までの数字。
 * </p>
 * @param day int <p>
 * 日を表す、1 から 30 までの数字。
 * </p>
 * @param year int <p>
 * 年を表す、1 から 14 までの数字。
 * </p>
 * @return int フランス革命暦の日付をユリウス積算日になおした結果を整数値で返します。
 */
function frenchtojd ($month, $day, $year) {}

/**
 * 曜日を返す
 * @link http://www.php.net/manual/ja/function.jddayofweek.php
 * @param julianday int <p>
 * ユリウス積算日を表す整数値。
 * </p>
 * @param mode int[optional] <table>
 * 暦の曜日モード
 * <tr valign="top">
 * <td>モード</td>
 * <td>意味</td>
 * </tr>
 * <tr valign="top">
 * <td>0 (デフォルト)</td>
 * <td>
 * 整数で曜日番号 (0=Sunday, 1=Monday, 等)を返します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>1</td> 
 * <td>
 * 曜日(英グレゴリウス)を含む文字列を返します。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>2</td> 
 * <td>
 * 曜日の省略形(英グレゴリウス)を含む文字列を返します。
 * </td>
 * </tr>
 * </table>
 * @return mixed グレゴリウス暦の曜日を表す数値あるいは文字列を返します。
 */
function jddayofweek ($julianday, $mode = null) {}

/**
 * 月の名前を返す
 * @link http://www.php.net/manual/ja/function.jdmonthname.php
 * @param julianday int 
 * @param mode int 
 * @return string 指定したユリウス積算日と calendar
 * にもとづく月名を返します。
 */
function jdmonthname ($julianday, $mode) {}

/**
 * 指定した年における復活祭の真夜中のUnix時を得る
 * @link http://www.php.net/manual/ja/function.easter-date.php
 * @param year int[optional] <p>
 * 1970 から 2037 までの年。
 * </p>
 * @return int 復活祭の日を Unix タイムスタンプで返します。
 */
function easter_date ($year = null) {}

/**
 * 指定した年において、3 月 21 日から復活祭までの日数を得る
 * @link http://www.php.net/manual/ja/function.easter-days.php
 * @param year int[optional] <p>
 * 正の数値で表した年。
 * </p>
 * @param method int[optional] <p>
 * CAL_EASTER_ROMAN に設定すると
 * 1582 年から 1752 年までの復活祭の日付をグレゴリオ暦にもとづいて
 * 計算します。それ以外に使用可能な定数については カレンダー定数を参照ください。
 * </p>
 * @return int 指定した年 year において、3 月 21 日から復活祭までの日数を返します。
 */
function easter_days ($year = null, $method = null) {}

/**
 * Unix タイムスタンプをユリウス歴に変換する
 * @link http://www.php.net/manual/ja/function.unixtojd.php
 * @param timestamp int[optional] <p>
 * 変換したい Unix タイムスタンプ。
 * </p>
 * @return int ユリウス積算日を表す整数値を返します。
 */
function unixtojd ($timestamp = null) {}

/**
 * ユリウス歴を Unix タイムスタンプに変換する
 * @link http://www.php.net/manual/ja/function.jdtounix.php
 * @param jday int <p>
 * 2440588 から 2465342 までのユリウス積算日。
 * </p>
 * @return int 指定したユリウス積算日の開始時の Unix タイムスタンプを返します。
 */
function jdtounix ($jday) {}

/**
 * サポートされるカレンダーからユリウス積算日に変換する
 * @link http://www.php.net/manual/ja/function.cal-to-jd.php
 * @param calendar int <p>
 * 変換元のカレンダー。
 * CAL_GREGORIAN、
 * CAL_JULIAN、
 * CAL_JEWISH あるいは
 * CAL_FRENCH のいずれか。
 * </p>
 * @param month int <p>
 * 月を表す数値。有効な範囲は
 * calendar に依存します。
 * </p>
 * @param day int <p>
 * 日を表す数値。有効な範囲は
 * calendar に依存します。
 * </p>
 * @param year int <p>
 * 年を表す数値。有効な範囲は
 * calendar に依存します。
 * </p>
 * @return int ユリウス積算日を返します。
 */
function cal_to_jd ($calendar, $month, $day, $year) {}

/**
 * ユリウス積算日からサポートされるカレンダーに変換する
 * @link http://www.php.net/manual/ja/function.cal-from-jd.php
 * @param jd int <p>
 * ユリウス日を表す整数値。
 * </p>
 * @param calendar int <p>
 * 変換するカレンダー。
 * </p>
 * @return array カレンダーの情報を含む配列を返します。この配列には、
 * 年、月、日、週、曜日名、月名、"月/日/年" 形式の文字列
 * などが含まれます。
 */
function cal_from_jd ($jd, $calendar) {}

/**
 * 指定した年とカレンダーについて、月の日数を返す
 * @link http://www.php.net/manual/ja/function.cal-days-in-month.php
 * @param calendar int <p>
 * 計算に使用するカレンダー。
 * </p>
 * @param month int <p>
 * 選択したカレンダーにおける月。
 * </p>
 * @param year int <p>
 * 選択したカレンダーにおける年。
 * </p>
 * @return int 指定したカレンダーの、その月の日数を返します。
 */
function cal_days_in_month ($calendar, $month, $year) {}

/**
 * 特定のカレンダーに関する情報を返す
 * @link http://www.php.net/manual/ja/function.cal-info.php
 * @param calendar int[optional] <p>
 * 情報を返したいカレンダー。指定しなかった場合は、
 * すべてのカレンダーに関する情報を返します。
 * </p>
 * @return array 
 */
function cal_info ($calendar = null) {}

define ('CAL_GREGORIAN', 0);
define ('CAL_JULIAN', 1);
define ('CAL_JEWISH', 2);
define ('CAL_FRENCH', 3);
define ('CAL_NUM_CALS', 4);
define ('CAL_DOW_DAYNO', 0);
define ('CAL_DOW_SHORT', 1);
define ('CAL_DOW_LONG', 2);
define ('CAL_MONTH_GREGORIAN_SHORT', 0);
define ('CAL_MONTH_GREGORIAN_LONG', 1);
define ('CAL_MONTH_JULIAN_SHORT', 2);
define ('CAL_MONTH_JULIAN_LONG', 3);
define ('CAL_MONTH_JEWISH', 4);
define ('CAL_MONTH_FRENCH', 5);
define ('CAL_EASTER_DEFAULT', 0);
define ('CAL_EASTER_ROMAN', 1);
define ('CAL_EASTER_ALWAYS_GREGORIAN', 2);
define ('CAL_EASTER_ALWAYS_JULIAN', 3);
define ('CAL_JEWISH_ADD_ALAFIM_GERESH', 2);
define ('CAL_JEWISH_ADD_ALAFIM', 4);
define ('CAL_JEWISH_ADD_GERESHAYIM', 8);

// End of calendar v.
?>
