<?php

// Start of xml v.

/**
 * XML パーサを作成する
 * @link http://www.php.net/manual/ja/function.xml-parser-create.php
 * @param encoding string[optional] <p>
 * PHP 4 では、オプションの encoding で入出力の
 * エンコーディングを指定します。PHP 5 以降では入力のエンコーディングは
 * 自動判定されるので、encoding パラメータは
 * 出力のエンコーディングのみを指定することになります。PHP 4 では、
 * デフォルトの出力エンコーディングは入力の文字セットと同じです。
 * もし空の文字列が渡された場合、先頭の 3 あるいは 4 バイトの内容をもとに
 * パーサがエンコーディングの判別を試みます。PHP 5.0.0 および 5.0.1
 * ではデフォルトの出力文字セットは ISO-8859-1 で、PHP 5.0.2 以降では
 * UTF-8 です。サポートされるエンコーディングは
 * ISO-8859-1、UTF-8 および
 * US-ASCII です。
 * </p>
 * @return resource 新しい XML パーサのリソースハンドルを返します。
 */
function xml_parser_create ($encoding = null) {}

/**
 * 名前空間をサポートした XML パーサを生成する
 * @link http://www.php.net/manual/ja/function.xml-parser-create-ns.php
 * @param encoding string[optional] <p>
 * PHP 4 では、オプションの encoding で入出力の
 * エンコーディングを指定します。PHP 5 以降では入力のエンコーディングは
 * 自動判定されるので、encoding パラメータは
 * 出力のエンコーディングのみを指定することになります。PHP 4 では、
 * デフォルトの出力エンコーディングは入力の文字セットと同じです。
 * もし空の文字列が渡された場合、先頭の 3 あるいは 4 バイトの内容をもとに
 * パーサがエンコーディングの判別を試みます。PHP 5.0.0 および 5.0.1
 * ではデフォルトの出力文字セットは ISO-8859-1 で、PHP 5.0.2 以降では
 * UTF-8 です。サポートされるエンコーディングは
 * ISO-8859-1、UTF-8 および
 * US-ASCII です。
 * </p>
 * @param separator string[optional] <p>
 * 名前空間を含めたタグパラメータをハンドラ関数に渡す際には、
 * 名前空間名とタグ名を文字列 separator
 * でつなげたものが使用されます。
 * </p>
 * @return resource 新しい XML パーサのリソースハンドルを返します。
 */
function xml_parser_create_ns ($encoding = null, $separator = null) {}

/**
 * オブジェクト内部で XML パーサを使用する
 * @link http://www.php.net/manual/ja/function.xml-set-object.php
 * @param parser resource <p>
 * オブジェクト内部で使う XML パーサへの参照。
 * </p>
 * @param object object <p>
 * XML パーサを使うオブジェクト。
 * </p>
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function xml_set_object ($parser, &$object) {}

/**
 * 開始要素および終了要素のハンドラを設定する
 * @link http://www.php.net/manual/ja/function.xml-set-element-handler.php
 * @param parser resource <p>
 * 開始要素および終了要素のハンドラ関数を設定する XML パーサへの参照。
 * </p>
 * @param start_element_handler callable <p>
 * start_element_handler という名前の関数は、
 * 次の 3 つのパラメータをとる必要があります。
 * start_element_handler
 * resourceparser
 * stringname
 * arrayattribs
 * parser 
 * 最初のパラメータである parser は、
 * ハンドラをコールする XML パーサへのリファレンスです。
 * @param end_element_handler callable <p>
 * end_element_handlerという名前の関数は、
 * 2 つのパラメータをとる必要があります。
 * end_element_handler
 * resourceparser
 * stringname
 * parser 
 * 最初のパラメータである parser は、
 * ハンドラをコールする XML パーサへのリファレンスです。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function xml_set_element_handler ($parser, $start_element_handler, $end_element_handler) {}

/**
 * 文字データハンドラを設定する
 * @link http://www.php.net/manual/ja/function.xml-set-character-data-handler.php
 * @param parser resource <p>
 * 文字データハンドラ関数を設定する XML パーサへの参照。
 * </p>
 * @param handler callable <p>
 * handler は、parser に関して
 * xml_parse がコールされた際に必要な関数の名前を有する文字列です。
 * </p>
 * <p>
 * handler という名前の関数は、次の 2 つのパラメータをとります。
 * handler
 * resourceparser
 * stringdata
 * parser
 * 最初のパラメータである parser は、
 * ハンドラをコールする XML パーサへのリファレンスです。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function xml_set_character_data_handler ($parser, $handler) {}

/**
 * 処理命令 (PI) 用ハンドラを設定する
 * @link http://www.php.net/manual/ja/function.xml-set-processing-instruction-handler.php
 * @param parser resource <p>
 * 処理命令 (PI) ハンドラ関数を設定する XML パーサへの参照。
 * </p>
 * @param handler callable <p>
 * handler は、
 * parser に関して
 * xml_parse がコールされた際に必要な関数の名前を有する文字列です。
 * </p>
 * <p>
 * handler という名前の関数は、
 * 次の 3 つのパラメータを引数とする必要があります。
 * handler
 * resourceparser
 * stringtarget
 * stringdata
 * parser
 * 最初のパラメータ、parser は
 * ハンドラをコールする XML パーサへのリファレンスです。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function xml_set_processing_instruction_handler ($parser, $handler) {}

/**
 * デフォルトのハンドラを設定する
 * @link http://www.php.net/manual/ja/function.xml-set-default-handler.php
 * @param parser resource <p>
 * デフォルトのハンドラ関数を設定する XML パーサへの参照。
 * </p>
 * @param handler callable <p>
 * handler は、
 * parser に関して xml_parse 
 * がコールされた際に必要な関数の名前を有する文字列です。
 * </p>
 * <p>
 * handler という名前の関数は、
 * 次の 2 つのパラメータをとる必要があります。
 * handler
 * resourceparser
 * stringdata
 * parser
 * 最初のパラメータである parser は、
 * ハンドラをコールした XML パーサへのリファレンスです。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function xml_set_default_handler ($parser, $handler) {}

/**
 * 処理されないエンティティ宣言用ハンドラを設定する
 * @link http://www.php.net/manual/ja/function.xml-set-unparsed-entity-decl-handler.php
 * @param parser resource <p>
 * 処理されないエンティティ宣言用ハンドラ関数を設定する XML パーサへの参照。
 * </p>
 * @param handler callable <p>
 * handlerは、
 * parser に関して xml_parse 
 * がコールされた際に必要な関数の名前を有する文字列です。
 * </p>
 * <p>
 * handler という名前の関数は次のような
 * 6 つのパラメータをとる必要があります。
 * handler
 * resourceparser
 * stringentity_name
 * stringbase
 * stringsystem_id
 * stringpublic_id
 * stringnotation_name
 * parser
 * 最初のパラメータ、parser は
 * ハンドラをコールする XML パーサへのリファレンスです。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function xml_set_unparsed_entity_decl_handler ($parser, $handler) {}

/**
 * 表記法宣言ハンドラを設定する
 * @link http://www.php.net/manual/ja/function.xml-set-notation-decl-handler.php
 * @param parser resource <p>
 * 表記法宣言ハンドラ関数を設定する XML パーサへの参照。
 * </p>
 * @param handler callable <p>
 * handler は、
 * parser に関して xml_parse 
 * がコールされた際に必要な関数の名前を有する文字列です。
 * </p>
 * <p>
 * handler という名前の関数は、5つのパラメータをとる必要があります。
 * handler
 * resourceparser
 * stringnotation_name
 * stringbase
 * stringsystem_id
 * stringpublic_id
 * parser
 * 最初のパラメータ、parser は
 * ハンドラをコールする XML パーサへのリファレンスです。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function xml_set_notation_decl_handler ($parser, $handler) {}

/**
 * 外部エンティティリファレンスハンドラを設定する
 * @link http://www.php.net/manual/ja/function.xml-set-external-entity-ref-handler.php
 * @param parser resource <p>
 * 外部エンティティリファレンスハンドラ関数を設定する XML パーサへの参照。
 * </p>
 * @param handler callable <p>
 * handler は、
 * parser に関して xml_parse 
 * がコールされた際に必要な関数の名前を有する文字列です。
 * </p>
 * <p>
 * handler という名前の関数は 5 つのパラメータをとり、
 * 整数値を返す必要があります。ハンドラから返された値が FALSE の場合
 * (これは値が返されない場合に相当します)、XML パーサは処理を中断し、
 * xml_get_error_code は
 * XML_ERROR_EXTERNAL_ENTITY_HANDLING
 * を返します。
 * handler
 * resourceparser
 * stringopen_entity_names
 * stringbase
 * stringsystem_id
 * stringpublic_id
 * parser
 * 最初のパラメータ、parser は
 * ハンドラをコールする XML パーサへのリファレンスです。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function xml_set_external_entity_ref_handler ($parser, $handler) {}

/**
 * 名前空間開始ハンドラを設定する
 * @link http://www.php.net/manual/ja/function.xml-set-start-namespace-decl-handler.php
 * @param parser resource <p>
 * XML パーサへの参照。
 * </p>
 * @param handler callable <p>
 * handler には、関数名を文字列で指定します。
 * これは、parser に対して
 * xml_parse がコールされたときに存在しなければなりません。
 * </p>
 * <p>
 * handler で指定した関数は、
 * 3 つのパラメータを受け取って整数値を返すものでなければなりません。
 * 返り値が FALSE (何も値を返さなかったときもこれにあてはまります)
 * の場合、XML パーサはパースを停止し、
 * xml_get_error_code は
 * XML_ERROR_EXTERNAL_ENTITY_HANDLING を返します。
 * handler
 * resourceparser
 * stringprefix
 * stringuri
 * parser
 * 最初のパラメータ parser
 * は、ハンドラをコールした XML パーサへの参照です。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function xml_set_start_namespace_decl_handler ($parser, $handler) {}

/**
 * 名前空間終了ハンドラを設定する
 * @link http://www.php.net/manual/ja/function.xml-set-end-namespace-decl-handler.php
 * @param parser resource <p>
 * XML パーサへの参照。
 * </p>
 * @param handler callable <p>
 * handler には、関数名を文字列で指定します。
 * これは、parser に対して
 * xml_parse がコールされたときに存在しなければなりません。
 * </p>
 * <p>
 * handler で指定した関数は、
 * 2 つのパラメータを受け取って整数値を返すものでなければなりません。
 * 返り値が FALSE (何も値を返さなかったときもこれにあてはまります)
 * の場合、XML パーサはパースを停止し、
 * xml_get_error_code は
 * XML_ERROR_EXTERNAL_ENTITY_HANDLING を返します。
 * handler
 * resourceparser
 * stringprefix
 * parser
 * 最初のパラメータ parser
 * は、ハンドラをコールした XML パーサへの参照です。
 * @return bool 成功した場合に TRUE を、失敗した場合に FALSE を返します。
 */
function xml_set_end_namespace_decl_handler ($parser, $handler) {}

/**
 * XML ドキュメントの処理を開始する
 * @link http://www.php.net/manual/ja/function.xml-parse.php
 * @param parser resource <p>
 * 使用する XML パーサへのリファレンス。
 * </p>
 * @param data string <p>
 * 処理するデータ。ドキュメントは、
 * is_final パラメータが設定され、
 * 最後のデータが処理され TRUE になるまで、新規のデータに関して
 * 複数回 xml_parse をコールすることにより、
 * 部分毎で処理することが可能です。
 * </p>
 * @param is_final bool[optional] <p>
 * TRUE が設定された場合、data は
 * この処理の間に送られた最後のデータということになります。
 * </p>
 * @return int 成功した場合に 1、失敗した場合に 0 を返します。
 * </p>
 * <p>
 * 処理が成功しなかった場合、エラー情報を
 * xml_get_error_code,
 * xml_error_string,
 * xml_get_current_line_number,
 * xml_get_current_column_number および
 * xml_get_current_byte_index
 * により取得可能です。
 * </p>
 * <p>
 * エンティティのエラーが報告されるのは、ドキュメントの最後
 * つまり is_final が TRUE に設定されている場合です。
 */
function xml_parse ($parser, $data, $is_final = null) {}

/**
 * 配列構造体に XML データを処理する
 * @link http://www.php.net/manual/ja/function.xml-parse-into-struct.php
 * @param parser resource <p>
 * XML パーサへの参照。
 * </p>
 * @param data string <p>
 * XML データを含む文字列。
 * </p>
 * @param values array <p>
 * XML データの値を含む配列。
 * </p>
 * @param index array[optional] <p>
 * $values 内の適切な値の場所をさすポインタの配列。
 * </p>
 * @return int xml_parse_into_struct は失敗した場合に 0、
 * 成功した場合に 1 を返します。これは FALSE および TRUE とは
 * 異なるものですので、=== のような演算子を使用する場合は注意しましょう。
 */
function xml_parse_into_struct ($parser, $data, array &$values, array &$index = null) {}

/**
 * XML パーサのエラーコードを得る
 * @link http://www.php.net/manual/ja/function.xml-get-error-code.php
 * @param parser resource <p>
 * エラーコードを得る XML パーサへのリファレンス。
 * </p>
 * @return int この関数は、parser が有効なパーサを参照していない
 * 場合に FALSE を返します。その他の場合、
 * エラーコードセクション に
 * 一覧が示されたエラーコードを返します。
 */
function xml_get_error_code ($parser) {}

/**
 * XML パーサのエラー文字列を得る
 * @link http://www.php.net/manual/ja/function.xml-error-string.php
 * @param code int <p>
 * xml_get_error_code からのエラーコード。
 * </p>
 * @return string エラーコード code の説明を有する文字列を
 * 返します。説明がない場合には FALSE を返します。
 */
function xml_error_string ($code) {}

/**
 * XML パーサのカレントの行番号を得る
 * @link http://www.php.net/manual/ja/function.xml-get-current-line-number.php
 * @param parser resource <p>
 * 行番号を得る XML パーサへのリファレンス。
 * </p>
 * @return int この関数は、parser が有効なパーサでない場合に
 * FALSE、それ以外の場合にデータバッファの中で
 * 現在パーサが処理中の行番号を返します。
 */
function xml_get_current_line_number ($parser) {}

/**
 * XML パーサのカレントのカラム番号を取得する
 * @link http://www.php.net/manual/ja/function.xml-get-current-column-number.php
 * @param parser resource <p>
 * カラム番号を得る XML パーサへのリファレンス。
 * </p>
 * @return int この関数は、parser が有効なパーサでない場合に
 * FALSE を返します。それ以外の場合は、現在のパーサの
 * (xml_get_current_line_number で取得した)
 * 現在の行のカラムを返します。
 */
function xml_get_current_column_number ($parser) {}

/**
 * XML パーサのカレントのバイトインデックスを得る
 * @link http://www.php.net/manual/ja/function.xml-get-current-byte-index.php
 * @param parser resource <p>
 * バイトインデックスを得る XML パーサへのリファレンス。
 * </p>
 * @return int この関数は、parser が有効なパーサを参照しない場合に
 * FALSE、そうでない場合に
 * データバッファにおいてパーサが現在処理中のバイトインデックス
 * (先頭が 0) を返します。
 */
function xml_get_current_byte_index ($parser) {}

/**
 * XML パーサを解放する
 * @link http://www.php.net/manual/ja/function.xml-parser-free.php
 * @param parser resource 解放したい XML パーサへのリファレンス。
 * @return bool この関数は、parser が有効なパーサを
 * 参照しない場合に FALSE、それ以外の場合にパーサを解放し、TRUE を返します。
 */
function xml_parser_free ($parser) {}

/**
 * XML パーサのオプションを設定する
 * @link http://www.php.net/manual/ja/function.xml-parser-set-option.php
 * @param parser resource <p>
 * オプションを設定する XML パーサへのリファレンス。
 * </p>
 * @param option int <p>
 * 設定するオプション。以下を参照してください。
 * </p>
 * <p>
 * 次のオプションが利用可能です。
 * <table>
 * XML パーサオプション
 * <tr valign="top">
 * <td>オプション定数</td>
 * <td>データ型</td>
 * <td>説明</td>
 * </tr>
 * <tr valign="top">
 * <td>XML_OPTION_CASE_FOLDING</td>
 * <td>integer</td>
 * <td>
 * XMLパーサの大文字変換
 * を有効にするかどうかを制御する。デフォルトで有効。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>XML_OPTION_SKIP_TAGSTART</td>
 * <td>integer</td> 
 * <td>
 * タグ名の最初の何文字を読み飛ばすかどうかを設定する。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>XML_OPTION_SKIP_WHITE</td>
 * <td>integer</td> 
 * <td>
 * 空白文字からなる値を読み飛ばすかどうかを設定する。
 * </td>
 * </tr>
 * <tr valign="top">
 * <td>XML_OPTION_TARGET_ENCODING</td>
 * <td>string</td> 
 * <td>
 * XML パーサについてどの ターゲット
 * エンコーディング を使用するかを設定する。デフォルトでは、
 * xml_parser_create により使用されたソース
 * エンコーディングと同じエンコーディングが設定されます。
 * サポートされるターゲットエンコーディングは、
 * ISO-8859-1, US-ASCII,
 * UTF-8 です。
 * </td>
 * </tr>
 * </table>
 * </p>
 * @param value mixed <p>
 * そのオプションの新しい設定値。
 * </p>
 * @return bool この関数は、parser が有効なパーサを参照しないか、
 * オプションが設定出来なかった場合に FALSE を返します。
 * それ以外の場合、そのオプションが設定され、TRUE が返されます。
 */
function xml_parser_set_option ($parser, $option, $value) {}

/**
 * XML パーサからオプションを得る
 * @link http://www.php.net/manual/ja/function.xml-parser-get-option.php
 * @param parser resource オプションを取得する XML パーサへのリファレンス。
 * @param option int 取得するオプション。XML_OPTION_CASE_FOLDING
 * あるいは XML_OPTION_TARGET_ENCODING が使用可能です。
 * 詳細は xml_parser_set_option を参照ください。
 * @return mixed この関数は、parser が有効なパーサを参照しないか、
 * option が不正な形式の場合に FALSE を返します
 * (同時に E_WARNING を生成します)。
 * それ以外の場合、そのオプションの値が返されます。
 */
function xml_parser_get_option ($parser, $option) {}

/**
 * ISO-8859-1 文字列を UTF-8 にエンコードする
 * @link http://www.php.net/manual/ja/function.utf8-encode.php
 * @param data string <p>
 * ISO-8859-1 形式の文字列。
 * </p>
 * @return string data を UTF-8 に変換した結果を返します。
 */
function utf8_encode ($data) {}

/**
 * UTF-8 エンコードされた ISO-8859-1 文字列をシングルバイトの ISO-8859-1 に変換する
 * @link http://www.php.net/manual/ja/function.utf8-decode.php
 * @param data string <p>
 * UTF-8 エンコードされた文字列。
 * </p>
 * @return string data を ISO-8859-1 に変換した結果を返します。
 */
function utf8_decode ($data) {}

define ('XML_ERROR_NONE', 0);
define ('XML_ERROR_NO_MEMORY', 1);
define ('XML_ERROR_SYNTAX', 2);
define ('XML_ERROR_NO_ELEMENTS', 3);
define ('XML_ERROR_INVALID_TOKEN', 4);
define ('XML_ERROR_UNCLOSED_TOKEN', 5);
define ('XML_ERROR_PARTIAL_CHAR', 6);
define ('XML_ERROR_TAG_MISMATCH', 7);
define ('XML_ERROR_DUPLICATE_ATTRIBUTE', 8);
define ('XML_ERROR_JUNK_AFTER_DOC_ELEMENT', 9);
define ('XML_ERROR_PARAM_ENTITY_REF', 10);
define ('XML_ERROR_UNDEFINED_ENTITY', 11);
define ('XML_ERROR_RECURSIVE_ENTITY_REF', 12);
define ('XML_ERROR_ASYNC_ENTITY', 13);
define ('XML_ERROR_BAD_CHAR_REF', 14);
define ('XML_ERROR_BINARY_ENTITY_REF', 15);
define ('XML_ERROR_ATTRIBUTE_EXTERNAL_ENTITY_REF', 16);
define ('XML_ERROR_MISPLACED_XML_PI', 17);
define ('XML_ERROR_UNKNOWN_ENCODING', 18);
define ('XML_ERROR_INCORRECT_ENCODING', 19);
define ('XML_ERROR_UNCLOSED_CDATA_SECTION', 20);
define ('XML_ERROR_EXTERNAL_ENTITY_HANDLING', 21);
define ('XML_OPTION_CASE_FOLDING', 1);
define ('XML_OPTION_TARGET_ENCODING', 2);
define ('XML_OPTION_SKIP_TAGSTART', 3);
define ('XML_OPTION_SKIP_WHITE', 4);

/**
 * SAX の実装方式を保持します。
 * libxml あるいは expat となります。
 * @link http://www.php.net/manual/ja/xml.constants.php
 */
define ('XML_SAX_IMPL', "libxml");

// End of xml v.
?>
