package jp.sourceforge.pdt_tools.variables;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.text.ITextSelection;

@SuppressWarnings("restriction")
public class SelectedLineStartVariableResolver implements
		IDynamicVariableResolver {

	public String resolveValue(IDynamicVariable variable, String argument)
			throws CoreException {
		if (DebugUIPlugin.getStandardDisplay().getThread()
				.equals(Thread.currentThread())) {
			return getStartLine();
		} else {
			final String[] text = new String[1];
			DebugUIPlugin.getStandardDisplay().syncExec(new Runnable() {
				public void run() {
					text[0] = getStartLine();
				}
			});
			return text[0];
		}
	}

	protected String getStartLine() {
		ITextSelection selection = SelectedLineUtil.getTextSelection();
		if (selection != null) {
			int startLine = ((ITextSelection) selection).getStartLine();
			if (startLine >= 0) {
				return Integer.toString(startLine + 1);
			}
		}
		return "";
	}

}
