//
// MsysTerm launcher
//
// Copyright (c) 2013      Minato Hamano
// Copyright (c) 2007-2011 TeraTerm Project
//   http://ttssh2.sourceforge.jp/
//
// [How to compile]
// Msys:
//  # mingw32-gcc -o msyslaunch msyslaunch.c
//

#include <tchar.h>
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>


#define Section _T("Tera Term")
LPCTSTR FName = _T("TERATERM.INI");


//
// Connect to local msys
//
void OnMsysConnection(LPCTSTR MsysDirectory, LPCTSTR cmdline)
{
    TCHAR file[MAX_PATH];
    TCHAR c, *envptr, *envbuff;
    int envbufflen;
    LPCTSTR exename = _T("msysterm.exe");
    TCHAR cmd[1024];
    STARTUPINFO si;
    PROCESS_INFORMATION pi;

    envptr = getenv(_T("PATH"));
    if (strstr(envptr, _T("msys\\1.0\\bin")) != NULL) {
        goto found_path;
    }

    _snprintf(file, MAX_PATH, _T("%s\\bin"), MsysDirectory);
    if (GetFileAttributes(file) == -1) { // open error
        for (c = _T('C') ; c <= _T('Z') ; c++) {
            file[0] = c;
            if (GetFileAttributes(file) != -1) { // open success
                goto found_dll;
            }
        }
        MessageBox(NULL, _T("Can't find Msys directory."), _T("ERROR"), MB_OK | MB_ICONWARNING);
        return;
    }
found_dll:;
    if (envptr != NULL) {
        envbufflen = strlen(file) + strlen(envptr) + 7; // _T("PATH=")(5) + _T(";")(1) + NUL(1)
        if ((envbuff=malloc(envbufflen)) == NULL) {
            MessageBox(NULL, _T("Can't allocate memory."), _T("ERROR"), MB_OK | MB_ICONWARNING);
            return;
        }
        _snprintf(envbuff, envbufflen, _T("PATH=%s;%s"), file, envptr);
    } else {
        envbufflen = strlen(file) + strlen(envptr) + 6; // _T("PATH=")(5) + NUL(1)
        if ((envbuff=malloc(envbufflen)) == NULL) {
            MessageBox(NULL, _T("Can't allocate memory."), _T("ERROR"), MB_OK | MB_ICONWARNING);
            return;
        }
        _snprintf(envbuff, envbufflen, _T("PATH=%s"), file);
    }
    _putenv(envbuff);
    if (envbuff) {
        free(envbuff);
        envbuff = NULL;
    }

found_path:;
    memset(&si, 0, sizeof(si));
    GetStartupInfo(&si);
    memset(&pi, 0, sizeof(pi));

    strcpy(cmd, exename);
    strcat(cmd, _T(" "));
    strncat(cmd, cmdline, sizeof(cmd)-strlen(cmd)-1);
    if (CreateProcess(
            NULL,
            cmd,
            NULL, NULL, FALSE, CREATE_NO_WINDOW,
            NULL, NULL,
            &si, &pi) == 0) {
        MessageBox(NULL, _T("Can't execute MsysTerm."), _T("ERROR"), MB_OK | MB_ICONWARNING);
    }
}


int main(int argc, char** argv)
{
    TCHAR Temp[MAX_PATH], MsysDir[MAX_PATH], Cmdline[MAX_PATH];
    TCHAR *bs;
    int i;
    BOOL d_opt=FALSE;

    if (GetModuleFileName(NULL, Temp, sizeof(Temp)) > 0 &&
       (bs = strrchr(Temp, _T('\\'))) != NULL) {
        *bs = 0;
        _chdir(Temp);
        _snprintf(bs, sizeof(Temp) + Temp - bs, _T("\\%s"), FName);
    }
    else {
        _snprintf(Temp, sizeof(Temp), _T(".\\"), FName);
    }

    // Msys install path
    GetPrivateProfileString(Section, _T("MsysDirectory"), _T("C:\\MinGW\\msys\\1.0"),
              MsysDir, sizeof(MsysDir), Temp);

    Cmdline[0] = 0;
    for (i=1; i<argc; i++) {
        if (i != 1) {
            strncat(Cmdline, _T(" "), sizeof(Cmdline) - strlen(Cmdline) - 1);
        }
        if (d_opt && strncmp(_T("\"\\\\"), argv[i], 3) == 0) {
            argv[i][1] = _T('/');
            argv[i][2] = _T('/');
        }
        strncat(Cmdline, argv[i], sizeof(Cmdline) - strlen(Cmdline) - 1);
        if (strcmp(argv[i], _T("-d")) == 0) {
            d_opt = TRUE;
        }
        else {
            d_opt = FALSE;
        }
    }

    OnMsysConnection(MsysDir, Cmdline);

    return 0;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    int i, argc, length, result;
    LPTSTR argv[256];
    LPWSTR *lpwszArgs = NULL;

    lpwszArgs = CommandLineToArgvW(GetCommandLineW(), &argc);
    for (i=0; i<argc; i++) {
        length = WideCharToMultiByte(CP_ACP, 0, lpwszArgs[i], -1,
            NULL, 0, NULL, NULL);
        argv[i] = (LPTSTR) HeapAlloc(GetProcessHeap(), 0, length + 1);
        WideCharToMultiByte(CP_ACP, 0, lpwszArgs[i], -1,
            argv[i], length + 1, NULL, NULL);
    }

    result = main(argc, argv);

    for (i=0; i<argc; i++) {
        HeapFree(GetProcessHeap(), 0, argv[i]);
    }
    LocalFree(LocalHandle(lpwszArgs));

    return result;
}
