#include "stdafx.h"

#include "rectangle.h"

namespace MG {

void Rectangle::Offset(int16_t x, int16_t y)
{
	this->x += x;
	this->x += y;
}

// static
Rectangle Rectangle::Offset(const Rectangle& r, int16_t x, int16_t y)
{
	Rectangle ret = r;
	ret.Offset(x, y);
	return ret;
}

bool Rectangle::Contains(int16_t x, int16_t y) const
{
	return
		1
		&& Left() <= x
		&& x < Right()
		&& Top() <= y
		&& y < Bottom()
	;
}

bool Rectangle::Contains(const Rectangle& r) const
{
	return true;
}

void Rectangle::Intersect(const Rectangle& r)
{
	int16_t left = std::max<int16_t>(Left(), r.Left());
	int16_t right = std::min<int16_t>(Right(), r.Right());
	
	int16_t top = std::max<int16_t>(Top(), r.Top());
	int16_t bottom = std::min<int16_t>(Bottom(), r.Bottom());
	
	x = left;
	w = std::max<int16_t>(0, right-left);
	
	y = top;
	h = std::max<int16_t>(0, bottom-top);
}

// static
Rectangle Rectangle::Intersect(const Rectangle& r1, const Rectangle& r2)
{
	Rectangle ret = r1;
	ret.Intersect(r2);
	return ret;
}

void Rectangle::Union(int16_t x, int16_t y)
{
	this->x = std::min<int16_t>(this->x, x);
	this->y = std::min<int16_t>(this->y, y);
	this->w = std::max<int16_t>(this->w, x - this->x + 1);
	this->h = std::max<int16_t>(this->h, y - this->y + 1);
}

void Rectangle::Union(const Rectangle& r)
{
}

// static
Rectangle Rectangle::Union(const Rectangle& r, int16_t x, int16_t y)
{
	Rectangle ret = r;
	ret.Union(x, y);
	return ret;
}

// static
Rectangle Rectangle::Union(const Rectangle& r1, const Rectangle& r2)
{
	Rectangle ret = r1;
	ret.Union(r2);
	return ret;
}

} // namespace MG

