<?php
class RegistCardController extends AppController {
	var $uses = array('VGroupedData', 'User', 'Course');
	var $helpers = array('Javascript');

	function index() {
		if (isset($_POST['submit'])) {
			$this->_submit();
		} else {
			$this->_init();
		}
		$courses = $this->Course->courselist();
		$this->set('courses', $courses);
	}

	function _init() {
		$unregistedcard = array();
		
		$allcards = $this->VGroupedData->alllist();
		$allusers = $this->User->allusers();
		foreach ($allcards as $card) {
			$id = array_search($card, $allusers);
			if ($id == false) {
				list($idm, $pmm) = explode('-', $card);
				array_push($unregistedcard, array('idm' => $idm, 'pmm' => $pmm));
			}
		}
		$ncard = count($unregistedcard);
		$this->set('ncard', $ncard);
		if ($ncard >= 1) {
			$item = current($unregistedcard);
			$_POST['idm'] = $item['idm'];
			$_POST['pmm'] = $item['pmm'];
		}
	}

	function _submit() {
		$this->set('ncard', '');

		$data = $_POST;
		$data['course'] = $this->Course->id($data['course']);

		if ($this->User->save($data)) {
			$_POST = array();
			$this->_init();
		}
	}
}
?>

