﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: IWebBrowserCtrl.cs
// Author: bis5
//
///////////////////////////////////////////////////////////////////////////////

namespace Bis5Products.SharpWebBrowser {
    /// <summary>SharpWebBRowserが利用するWebBrowserControllerモジュールに必要な機能を実装します。</summary>
    public interface IWebBrowserCtrl : System.IDisposable, ISWBModules {
        /// <summary>WebBrowserコントロールを生成します。</summary>
        /// <returns><see cref="IWebBrowserControl"/>を実装したWebBrowserkコントロール</returns>
        IWebBrowserControl CreateControl();
        /// <summary>WebBrowserコントロールを廃棄し、管理対象から除外します。</summary>
        /// <param name="wb">廃棄するWebBrowserコントロール</param>
        void RemoveControl(IWebBrowserControl wb);
        /// <summary>WebBrowserControllerに本体フォームを登録し、WebBrowserコントロールで発生するイベントの用意をします。</summary>
        /// <param name="main"><see cref="Bis5Products.SharoWebBrowser.MainForm"/></param>
        /// <param name="tb"><see cref="Bis5Products.SharpWebBrowser.ToolStripSpringTextBox"/></param>
        /// <param name="tc"><see cref="System.Windows.Forms.TabControl"/></param>
        /// <param name="st"><see cref="System.Windows.Forms.ToolStripStatusLabel"/></param>
        /// <param name="pg"><see cref="System.Windows.Forms.ToolStripProgressBar"/></param>
        void RegisterMainForm(System.Windows.Forms.Form main, 
                              ToolStripSpringTextBox tb,
                              System.Windows.Forms.TabControl tc,
                              System.Windows.Forms.ToolStripStatusLabel st,
                              System.Windows.Forms.ToolStripProgressBar pg);
    }
}