﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of LanguageManager.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
// LanguageManager is one of modules for SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: LanguageManager.cs
// Author: bis5
// Module: LanguageManager
//
///////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using System.IO;

namespace Bis5Products.SharpWebBrowser {
    public class LanguageManager : ILangMgr {
        private string apppath;
        private string fname;
        private SerializableDictionary<string, string> conf = new SerializableDictionary<string, string>();
        private ConfigurationManager cm;

        private bool _registeredprop = false;

        internal string[] lnlist;

        public LanguageManager() { }
        public LanguageManager(string path, string langcode) {
            apppath = path + "\\Language\\";
            fname = langcode + ".config";
            Load();
        }

        public LanguageManager(string path, ConfigurationManager cmgr) {
            cm = cmgr;
            apppath = path + "\\Language\\";
            fname = cm.GetStr("Language") + ".config";
            lnlist = Directory.GetFiles(apppath);
            Load();
        }

        public void RegistProperty2CMgr() {
            if (!_registeredprop)
                cm.AddPropertySheet((ISWBPropertySheet)new LmgrProp(cm, this));
        }

        internal bool ChangeLang() {
            if (cm == null) return false;
            fname = cm.GetStr("Language") + ".config";
            try {
                conf.Clear();
                Load();
                ApplyLang();
                return true;
            } catch (IOException) {
                System.Windows.Forms.MessageBox.Show("Language file could NOT open!", "SharpWebBrowser - LanguageManager",
                    System.Windows.Forms.MessageBoxButtons.OK, System.Windows.Forms.MessageBoxIcon.Error);
                return false;
            } catch (XmlException) {
                System.Windows.Forms.MessageBox.Show("Language file format is invalid!", "SharpWebBrowser - LanguageManager",
                    System.Windows.Forms.MessageBoxButtons.OK, System.Windows.Forms.MessageBoxIcon.Error);
                return false;
            } catch (Exception ex) {
                throw ex;
            }
        }

        List<LmgrAppender> appendDelList = new List<LmgrAppender>();
        private void ApplyLang() {
            foreach (LmgrAppender ev in appendDelList) {
                ev();
            }
        }

        public void AppendDelegate(LmgrAppender ev) {
            appendDelList.Add(ev);
        }

        /// <param name="doInit">trueの時、追加されたイベントを呼び出します。</param>
        public void AppendDelegate(LmgrAppender ev, bool doInit) {
            AppendDelegate(ev);
            if (doInit) ev();
        }

        internal string[] GetConfFiles() {
            return lnlist;
        }

        internal void Load() {
            StreamReader sreader = new StreamReader(apppath + fname, Encoding.UTF8);
            var xreader = XmlReader.Create(sreader);

            conf.ReadXml(xreader);
        }

        public string Get(string code) {
            try { return conf[code]; } catch (Exception) { return code; }
        }

        /// <summary>
        /// 互換性維持のためのメソッド(~v5.0.1)
        /// </summary>
        /// <param name="code"></param>
        /// <returns></returns>
        [System.Obsolete("互換性維持のためのメソッド(~v5.0.1)", false)]
        public string GetValue(string code) {
            return this.Get(code);
        }

        public string[] GetVersion() {
            var asm = System.Reflection.Assembly.GetExecutingAssembly();
            return new string[]{
                asm.ManifestModule.Name.Replace(".dll","\0"),
                asm.GetName().Version.ToString(),
                "bis5",
                asm.ManifestModule.Name
            };
        }
    }
}