﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of PluginManager.
///////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2009-2010 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
// PluginManager is one of modules for SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licene (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: IPluginHost.cs
// Author: bis5
// Module: PluginManager
//
///////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Bis5Products.SharpWebBrowser {
    public interface IPluginHost {
        /// <summary>
        /// 新しいタブで指定したURLを開く
        /// </summary>
        /// <param name="url">新しいタブで開くページのURL</param>
        void NavigateInNewTab(string url);
        /// <summary>
        /// Coreで利用しているConfigurationManagerから設定値を取得する
        /// </summary>
        /// <param name="key">取得する設定値のキー</param>
        /// <returns>設定値</returns>
        object GetConfVal(string key);
        /// <summary>
        /// Coreで利用しているConfigurationManagerに設定を追加する
        /// </summary>
        /// <param name="key">追加する設定値のキー</param>
        /// <param name="value">設定値</param>
        /// <remarks>
        /// 1,すでにキーが存在している場合、例外が発生する。
        /// 2,設定値はToString()メソッドで取得した文字列で永続化される。
        /// </remarks>
        /// <returns>追加に成功した場合のみtrue</returns>
        bool AddConfVal(string key, object value);
        /// <summary>
        /// Coreで利用しているConfigurationManagerの設定値を変更する
        /// </summary>
        /// <param name="key">変更する設定値のキー</param>
        /// <param name="value">設定値</param>
        /// <remarks>
        /// 1,存在しないキーが指定された場合、KeyNotFoundExceptionをスロー
        /// 2,設定値はToString()メソッドで取得した文字列で永続化される
        /// </remarks>
        /// <returns>変更に成功した場合のみtrue</returns>
        bool SetConfVal(string key, object value);
        /// <summary>
        /// 
        /// </summary>
        /// <param name="filename">Languageフォルダに格納されている言語定義ファイルの名前(拡張子の直前まで)</param>
        /// <returns>指定したファイルからの情報を格納したLanguageManager</returns>
        ILangMgr GetNewLanguageManager(string filename);

        /// <summary>
        /// 設定ダイアログに固有の設定ページを追加する
        /// </summary>
        /// <param name="propsheet">SWB_GlobalのISWBPropertyPanelを実装したControl継承オブジェクト</param>
        void AddConfiguration(ISWBPropertySheet propsheet);
    }
}
