/*
 * Decompiled with CFR 0.152.
 */
package org.ammlab.android.akbrobotadk;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.ToggleButton;
import com.android.future.usb.UsbAccessory;
import com.android.future.usb.UsbManager;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class AKBrobotADKActivity
extends Activity
implements View.OnClickListener,
Runnable {
    private static final String TAG = "AKBrobotADK";
    private static final String ACTION_USB_PERMISSION = "org.ammlab.android.app.akbrobotadk.action.USB_PERMISSION";
    private PendingIntent mPermissionIntent;
    private boolean mPermissionRequestPending;
    private UsbManager mUsbManager;
    private UsbAccessory mAccessory;
    ParcelFileDescriptor mFileDescriptor = null;
    FileInputStream mInputStream = null;
    FileOutputStream mOutputStream = null;
    private ToggleButton mToggleButton1;
    private ToggleButton mToggleButton2;
    private SeekBar mSeekBar1;
    private SeekBar mSeekBar2;
    private SeekBar mSeekBar3;
    private TextView mText1;
    private TextView mText2;
    private TextView mText3;
    private TextView mInValue;
    private EditText mEditOutput;
    private Spinner mSpinner1;
    private Spinner mSpinner2;
    private Spinner mSpinner3;
    private Spinner mSpinner4;
    private Button mButtonConfig;
    private Button mButtonDin;
    private Button mButtonAin;
    private Button mButtonDout;
    private Button mButtonAout;
    private byte[] mRecvBuff = new byte[4];
    private static final int MESSAGE_INPUTVAL = 1;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            UsbAccessory accessory;
            String action = intent.getAction();
            if (AKBrobotADKActivity.ACTION_USB_PERMISSION.equals(action)) {
                6 var4_4 = this;
                synchronized (var4_4) {
                    UsbAccessory accessory2 = UsbManager.getAccessory((Intent)intent);
                    if (intent.getBooleanExtra("permission", false)) {
                        AKBrobotADKActivity.this.openAccessory(accessory2);
                    } else {
                        Log.d((String)AKBrobotADKActivity.TAG, (String)("permission denied for accessory " + accessory2));
                    }
                    AKBrobotADKActivity.this.mPermissionRequestPending = false;
                }
            } else if ("android.hardware.usb.action.USB_ACCESSORY_DETACHED".equals(action) && (accessory = UsbManager.getAccessory((Intent)intent)) != null && accessory.equals((Object)AKBrobotADKActivity.this.mAccessory)) {
                AKBrobotADKActivity.this.closeAccessory();
            }
        }
    };
    private Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int val = 0;
                    7 var3_3 = this;
                    synchronized (var3_3) {
                        val = AKBrobotADKActivity.this.mRecvBuff[2] & 0xFF;
                        val = val * 256 + (AKBrobotADKActivity.this.mRecvBuff[3] & 0xFF);
                    }
                    AKBrobotADKActivity.this.mInValue.setText((CharSequence)String.valueOf(val));
                }
            }
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mUsbManager = UsbManager.getInstance((Context)this);
        this.mPermissionIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_USB_PERMISSION);
        filter.addAction("android.hardware.usb.action.USB_ACCESSORY_DETACHED");
        this.registerReceiver(this.mUsbReceiver, filter);
        if (this.getLastNonConfigurationInstance() != null) {
            this.mAccessory = (UsbAccessory)this.getLastNonConfigurationInstance();
            this.openAccessory(this.mAccessory);
        }
        this.setContentView(2130903040);
        this.mToggleButton1 = (ToggleButton)this.findViewById(2131165197);
        this.mToggleButton2 = (ToggleButton)this.findViewById(0x7F07000F);
        this.mSeekBar1 = (SeekBar)this.findViewById(2131165186);
        this.mSeekBar2 = (SeekBar)this.findViewById(2131165190);
        this.mSeekBar3 = (SeekBar)this.findViewById(2131165194);
        this.mSeekBar1.setProgress(50);
        this.mSeekBar2.setProgress(50);
        this.mSeekBar3.setProgress(50);
        this.mText1 = (TextView)this.findViewById(2131165187);
        this.mText2 = (TextView)this.findViewById(0x7F070007);
        this.mText3 = (TextView)this.findViewById(2131165195);
        this.mInValue = (TextView)this.findViewById(2131165209);
        this.mEditOutput = (EditText)this.findViewById(2131165215);
        this.mSpinner1 = (Spinner)this.findViewById(2131165203);
        this.mSpinner2 = (Spinner)this.findViewById(2131165204);
        this.mSpinner3 = (Spinner)this.findViewById(2131165208);
        this.mSpinner4 = (Spinner)this.findViewById(2131165214);
        this.mButtonConfig = (Button)this.findViewById(2131165205);
        this.mButtonDin = (Button)this.findViewById(2131165210);
        this.mButtonAin = (Button)this.findViewById(2131165211);
        this.mButtonDout = (Button)this.findViewById(2131165216);
        this.mButtonAout = (Button)this.findViewById(2131165217);
        this.mButtonConfig.setOnClickListener((View.OnClickListener)this);
        this.mButtonDin.setOnClickListener((View.OnClickListener)this);
        this.mButtonAin.setOnClickListener((View.OnClickListener)this);
        this.mButtonDout.setOnClickListener((View.OnClickListener)this);
        this.mButtonAout.setOnClickListener((View.OnClickListener)this);
        this.mSeekBar1.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                int value = 0;
                byte direction = 0;
                if (progress > 45 && progress < 55) {
                    value = 0;
                } else if (progress > 50) {
                    value = (progress - 50) * 255 / 50;
                    direction = 0;
                } else {
                    value = (50 - progress) * 255 / 50;
                    direction = 1;
                }
                AKBrobotADKActivity.this.mText1.setText((CharSequence)String.format("%d", value));
                AKBrobotADKActivity.this.sendCommand((byte)3, (byte)0, direction, (byte)value);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                AKBrobotADKActivity.this.mSeekBar1.setProgress(50);
                AKBrobotADKActivity.this.sendCommand((byte)3, (byte)0, (byte)0, (byte)0);
            }
        });
        this.mSeekBar2.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                int value = 0;
                byte direction = 0;
                if (progress > 45 && progress < 55) {
                    value = 0;
                } else if (progress > 50) {
                    value = (progress - 50) * 255 / 50;
                    direction = 0;
                } else {
                    value = (50 - progress) * 255 / 50;
                    direction = 1;
                }
                AKBrobotADKActivity.this.mText2.setText((CharSequence)String.format("%d", value));
                AKBrobotADKActivity.this.sendCommand((byte)3, (byte)1, direction, (byte)value);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                AKBrobotADKActivity.this.mSeekBar2.setProgress(50);
                AKBrobotADKActivity.this.sendCommand((byte)3, (byte)1, (byte)0, (byte)0);
            }
        });
        this.mSeekBar3.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                int value = 180 * progress / 100;
                AKBrobotADKActivity.this.mText3.setText((CharSequence)String.format("%d", value));
                Log.d((String)AKBrobotADKActivity.TAG, (String)("Servo0:" + value + "," + (byte)value));
                AKBrobotADKActivity.this.sendCommand((byte)5, (byte)0, (byte)0, (byte)value);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                AKBrobotADKActivity.this.mSeekBar3.setProgress(50);
                AKBrobotADKActivity.this.sendCommand((byte)5, (byte)0, (byte)0, (byte)90);
            }
        });
        this.mToggleButton1.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                AKBrobotADKActivity.this.sendCommand((byte)4, (byte)0, (byte)0, (byte)(isChecked ? 1 : 0));
            }
        });
        this.mToggleButton2.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                AKBrobotADKActivity.this.sendCommand((byte)4, (byte)1, (byte)0, (byte)(isChecked ? 1 : 0));
            }
        });
        this.enableControls(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume() {
        UsbAccessory accessory;
        super.onResume();
        if (this.mInputStream != null && this.mOutputStream != null) {
            return;
        }
        UsbAccessory[] accessories = this.mUsbManager.getAccessoryList();
        UsbAccessory usbAccessory = accessory = accessories == null ? null : accessories[0];
        if (accessory != null) {
            if (this.mUsbManager.hasPermission(accessory)) {
                this.openAccessory(accessory);
            } else {
                BroadcastReceiver broadcastReceiver = this.mUsbReceiver;
                synchronized (broadcastReceiver) {
                    if (!this.mPermissionRequestPending) {
                        this.mUsbManager.requestPermission(accessory, this.mPermissionIntent);
                        this.mPermissionRequestPending = true;
                    }
                }
            }
        } else {
            Log.d((String)TAG, (String)"mAccessory is null");
        }
    }

    public void onPause() {
        super.onPause();
        this.closeAccessory();
    }

    public void onDestroy() {
        this.unregisterReceiver(this.mUsbReceiver);
        super.onDestroy();
    }

    private void openAccessory(UsbAccessory accessory) {
        this.mFileDescriptor = this.mUsbManager.openAccessory(accessory);
        if (this.mFileDescriptor != null) {
            this.mAccessory = accessory;
            FileDescriptor fd = this.mFileDescriptor.getFileDescriptor();
            this.mInputStream = new FileInputStream(fd);
            this.mOutputStream = new FileOutputStream(fd);
            Thread thread = new Thread(null, this, "DemoKit");
            thread.start();
            this.enableControls(true);
            Log.d((String)TAG, (String)"accessory opened");
        } else {
            Log.d((String)TAG, (String)"accessory open fail");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAccessory() {
        this.enableControls(false);
        try {
            if (this.mFileDescriptor != null) {
                this.mInputStream.close();
                this.mOutputStream.close();
                this.mFileDescriptor.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.mFileDescriptor = null;
            this.mAccessory = null;
            this.mInputStream = null;
            this.mOutputStream = null;
            Log.d((String)TAG, (String)"accessory closed");
        }
    }

    public void onClick(View view) {
        if (view == this.mButtonConfig) {
            long port = this.mSpinner1.getSelectedItemId();
            long mode = this.mSpinner2.getSelectedItemId();
            byte p = this.getPort(port, 256L);
            Log.d((String)TAG, (String)("Primitive:" + port + "," + p + "," + mode));
            this.sendCommand((byte)0, p, (byte)0, (byte)mode);
        } else if (view == this.mButtonDout) {
            long port = this.mSpinner4.getSelectedItemId();
            String value = this.mEditOutput.getText().toString();
            byte p = this.getPort(port, 0L);
            if (value != null && value.length() > 0) {
                byte v = (byte)Integer.valueOf(value).intValue();
                Log.d((String)TAG, (String)("DigitalOut:" + port + "," + p + "," + v));
                this.sendCommand((byte)1, p, (byte)0, v);
            }
        } else if (view == this.mButtonAout) {
            long port = this.mSpinner4.getSelectedItemId();
            String value = this.mEditOutput.getText().toString();
            byte p = this.getPort(port, 1L);
            if (value != null && value.length() > 0) {
                byte v = (byte)Integer.valueOf(value).intValue();
                Log.d((String)TAG, (String)("AnalogOut:" + port + "," + p + "," + v));
                this.sendCommand((byte)1, p, (byte)0, v);
            }
        } else if (view == this.mButtonDin) {
            long port = this.mSpinner3.getSelectedItemId();
            byte p = this.getPort(port, 2L);
            this.sendCommand((byte)2, p, (byte)0, (byte)0);
            Log.d((String)TAG, (String)("DigitalIn:" + port + "," + p));
        } else if (view == this.mButtonAin) {
            long port = this.mSpinner3.getSelectedItemId();
            byte p = this.getPort(port, 3L);
            this.sendCommand((byte)2, p, (byte)0, (byte)0);
            Log.d((String)TAG, (String)("AnalogIn:" + port + "," + p));
        } else {
            Log.d((String)TAG, (String)("Ignore click:" + view.toString()));
        }
    }

    private byte getPort(long port, long type) {
        byte ConfigPort = -1;
        long limitDigtal = 6L;
        if (type == 0L || type == 2L || type == 256L) {
            ConfigPort = port > limitDigtal ? (byte)(port - limitDigtal - 1L + 64L) : (byte)((byte)port);
        } else if (type == 1L) {
            ConfigPort = (byte)(port + 128L);
        } else if (port > limitDigtal) {
            ConfigPort = (byte)(port - limitDigtal - 1L + 128L);
        }
        return ConfigPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int ret = 0;
        byte[] buffer = new byte[16384];
        Log.d((String)TAG, (String)"Thread started.");
        while (this.mInputStream != null) {
            try {
                ret = this.mInputStream.read(buffer);
            }
            catch (IOException e) {
                break;
            }
            if (ret > 0) {
                Log.d((String)TAG, (String)(ret + " bytes message received."));
            }
            int i = 0;
            block9: while (i < ret) {
                int len = ret - i;
                switch (buffer[i]) {
                    case 2: {
                        if (len < 4) continue block9;
                        Message m = Message.obtain((Handler)this.mHandler, (int)1);
                        AKBrobotADKActivity aKBrobotADKActivity = this;
                        synchronized (aKBrobotADKActivity) {
                            this.mRecvBuff[0] = buffer[0];
                            this.mRecvBuff[1] = buffer[1];
                            this.mRecvBuff[2] = buffer[2];
                            this.mRecvBuff[3] = buffer[3];
                        }
                        Log.d((String)TAG, (String)("data received:" + buffer[0] + "," + buffer[1] + "," + buffer[2] + "," + buffer[3]));
                        this.mHandler.sendMessage(m);
                        i += 4;
                        continue block9;
                    }
                }
                Log.d((String)TAG, (String)("unknown msg: " + buffer[i]));
                i = len;
            }
        }
        Log.d((String)TAG, (String)"Thread end.");
    }

    public void sendCommand(byte command1, byte command2, byte value1, byte value2) {
        byte[] buffer = new byte[]{command1, command2, value1, value2};
        if (this.mOutputStream != null) {
            try {
                this.mOutputStream.write(buffer);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"write failed", (Throwable)e);
            }
        }
    }

    private void enableControls(boolean enable) {
        Resources res = this.getResources();
        String titleString = res.getString(2131034112);
        if (enable) {
            this.setTitle(titleString + " - connected");
        } else {
            this.setTitle(titleString + " - not connected");
        }
    }
}

