// Welcome to SVG Virtual Map Animator by Capsia Tech

/* Written by:
Desirée Schembri
Niccolò Celoro
Riccardo Riccio
Simon Tomsič*/

window.onload = setSizes;
function setSizes() {
	function sizing() {
		var height = window.innerHeight,
		width = window.innerWidth,
		svg_block = document.getElementById("svg");
		svg_block.style.width = width + "px";
		svg_block.style.height = height + "px";
	}
	sizing();
	res = initSVG();
	function runRes() {
		res();
		sizing();
	}
	$(window).resize(runRes);
}

function initSVG() { // Snap.SVG.JS needs to be started on load
// Starting Snap SVG, basic objects and variables. To change discs positions use posArr.
// Global setup
	document.getElementById("overlay").style.visibility = "hidden";
	window.nowFull = -1;
	var height = window.innerHeight,
	width = window.innerWidth,
	fontSize = parseFloat(getComputedStyle(document.body).fontSize)*0.6,
	dates = [2012, 2015, 2016, 2018, 2019],
	posArr = [],

	s = Snap("#svg"), // set element to draw in
// Start drawing
	dateLine = s.line(0, height*0.9, width, height*0.9),
	discs = s.group(), // group of all circles
	nums = s.group();

	for (i = 1; i <= dates.length; i++ ) {
		posArr.push([0.1*i, 0.9]);
	}

	function SVGsizes() {
		height = window.innerHeight;
		width = window.innerWidth;
		dateLine.attr({
			x2: width,
			y1: height * 0.9,
			y2: height * 0.9
		});
		for (i = 0; i < posArr.length; i++) {
			discs[i].attr({
				cx: width*posArr[i][0],
				cy: height*posArr[i][1]
			});
			nums[i].attr({
				x: (width*posArr[i][0])-32,
				y: (height*posArr[i][1])+60
			});
		}
	}
	//console.log(initSVG.SVGsizes);
// Setting default styles for rectangle and discs
	discs.attr({
		fill: "#ffffff",
		stroke: "#222",
		strokeWidth: 8
	});
	dateLine.attr({
		stroke: "#222",
		strokeWidth: 27
	});
	nums.attr({
		fontSize: "1.8em",
		fontWeight: "bold",
		fill: "#fff",
		stroke: "#222",
		strokeWidth: 2
//		pointerEvents: "none"
	});
// Initialize circles
	for (i = 0; i < posArr.length; i++) {
		discs.add(s.circle(width*posArr[i][0], height*posArr[i][1], 25)); // Create and add circles to discs.
		nums.add(s.text((width*posArr[i][0])-32, (height*posArr[i][1])+60, dates[i]));
		discs[i].click( function() {
			if (window.nowFull == -1) {
				for ( i = 0; i < posArr.length; i++ ) {
					if (discs[i].id == this.id) {
						window.nowFull = i;
					}
				}
				nums.attr({visibility: "hidden"});
				discs.attr({visibility: "hidden"}); // Hide discs to prevent ovelay viewing
				this.attr({visibility: "visible"}); // Hide discs to prevent ovelay viewing
				this.animate({r: window.innerWidth, cy: (window.innerHeight / 2) , cx: (window.innerWidth / 2), strokeWidth: 50}, 1000); //Move circle
				document.getElementById("overlay").style.visibility = "";
			} else {
				discs[window.nowFull].animate({r: 25, cy: window.innerHeight*posArr[window.nowFull][1], cx: window.innerWidth*posArr[window.nowFull][0], strokeWidth: 5}, 1000); //Return circle to original position
				discs[window.nowFull].attr({visibility: ""});
				nums.attr({visibility: ""});
				discs.attr({visibility: ""}); // Unhide circles
				document.getElementById("overlay").style.visibility = "hidden"; 
				window.nowFull = -1;
			}
		});
	}
	return SVGsizes;
}
