package common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class AccountGroup {

	private String tableName;

	public AccountGroup() {
		this.tableName = "account_group";
	}

	ArrayList<ArrayList<String>> select(ArrayList<String> params, String query) {

		Environment env = Environment.getEnvironment();

		String driver = env.getParam("driver");
		String url = env.getParam("url");
		String user = env.getParam("user");
		String pass = env.getParam("pass");

		DBAccessWrapper db = new DBAccessWrapper(driver, url, user, pass);

		ArrayList<ArrayList<String>> results;
		results = db.select(params, tableName, query);
		return results;
	}

	String create(ArrayList<String> attributes, ArrayList<String> values) {

		Map<String, String> params = new HashMap<String, String>();

		for( int ii = 0; ii < attributes.size(); ++ii ) {
			params.put(attributes.get(ii), values.get(ii));
		}

		Environment env = Environment.getEnvironment();

		String driver = env.getParam("driver");
		String url = env.getParam("url");
		String user = env.getParam("user");
		String pass = env.getParam("pass");

		DBAccessWrapper db = new DBAccessWrapper(driver, url, user, pass);

		String result;
		result = db.insert(params, tableName);
		return result;
	}

	int delete(String query) {

		Environment env = Environment.getEnvironment();

		String driver = env.getParam("driver");
		String url = env.getParam("url");
		String user = env.getParam("user");
		String pass = env.getParam("pass");

		DBAccessWrapper db = new DBAccessWrapper(driver, url, user, pass);

		int result;
		result = db.delete(tableName, query);
		return result;
	}
}
