/**
 *
 */
package common;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Properties;

/**
 * @author user
 *
 */
public class Environment {

	static Environment env = null;
	ArrayList<String> pathList = null;
	Properties properties;

	private Environment() {
		pathList = new ArrayList<String>();
	}

	public static Environment getEnvironment() {
		if ( env == null ) {
			env = new Environment();
		}
		return env;
	}

	public int init(String path) {

		FileInputStream fis = null;
		InputStreamReader isr = null;

		try {

			if ( pathList.indexOf(path) < 0 ) {
				fis = new FileInputStream(path);
				isr = new InputStreamReader(fis, Charset.defaultCharset());
				properties = new Properties();
				properties.load(isr);
			}

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				if (isr != null) {
					isr.close();
				}
				if (fis != null) {
					fis.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

		pathList.add(path);

		return 0;
	}

	public String getParam(String key) {
		return properties.getProperty(key);
	}
}
