/**
 *
 */
package control;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import system.ClassPerson;
import system.Person;

import common.DBAccessWrapper;
import common.Environment;

/**
 *
 * @author 無糖ブラック
 *
 */
public class Chokomaro extends HttpServlet {

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		String contentType = "text/html; charset=UTF-8";
		response.setContentType(contentType);

		String envPath = getServletContext().getRealPath("/conf/env.ini");
		Environment env = Environment.getEnvironment();
		env.init(envPath);

		HttpSession session = null;
		String in_application = "";
		String in_userid = "";

		String setup = env.getParam("setup");
		if ( setup.equals("on")) {
			session = request.getSession(true);

			in_userid = "admin";
			in_application = "maintenance";

			session.setAttribute("setup", setup);
			session.setAttribute("userid", in_userid);
			session.setAttribute("application", in_application);
		}
		else {
			in_application = request.getParameter("application");

			session = request.getSession(false);

			if ( session == null ) {
				in_application = "login";
			}
			else {
				session.setAttribute("setup", setup);

				in_userid = (String)session.getAttribute("userid");
				if ( in_userid == null || in_userid.isEmpty() ) {
					session.invalidate();
					session = null;
					in_application = "login";
				}
				else if ( in_application != null && in_application.equals("logout") ) {
					session.invalidate();
					session = null;
					in_application = "login";
				}
				else if ( in_application == null ) {
					in_application = "home";
				}
				else {
					session.setAttribute("application", in_application);
				}
			}
		}

		//遷移先パス設定
		String path = "";
		path = "./jsp/" + in_application + ".jsp";

		RequestDispatcher rd = request.getRequestDispatcher(path);
		rd.forward(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		String contentType = "text/html; charset=UTF-8";
		response.setContentType(contentType);

		HttpSession session = request.getSession(false);
		if ( session == null ) {
			return;
		}

		String envPath = getServletContext().getRealPath("/conf/env.ini");
		Environment env = Environment.getEnvironment();
		env.init(envPath);
		DBAccessWrapper db = new DBAccessWrapper(env);

		String in_userid = request.getParameter("userid");
		String in_password = request.getParameter("password");


		String condition = "";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();

		if ( in_password.isEmpty() ) {
			condition = "person_number = ? and password is null";
			conditionTypes.add("string");
			conditionValues.add(in_userid);
		}
		else {
			condition = "person_number = ? and password = ?";
			conditionTypes.add("string");
			conditionTypes.add("string");
			conditionValues.add(in_userid);
			conditionValues.add(in_password);
		}

		String path = "";
		try {
			db.connect();
			ArrayList<Person> persons;
			ClassPerson clsPerson = new ClassPerson(db);
			persons = clsPerson.select(condition, conditionTypes, conditionValues);
			db.close();
			if ( persons.size() > 0 ) {
				path = "./jsp/home.jsp";
				session.setAttribute("userid", in_userid);
			}
			else {
				path = "./jsp/login.jsp";
			}
		} catch (SQLException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}

		RequestDispatcher rd = request.getRequestDispatcher(path);
		rd.forward(request, response);
	}
}
