/**
 *
 */
package control;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import system.ClassColumnMaster;
import system.ColumnMaster;
import system.ColumnSetting;

import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import common.DBAccessWrapper;
import common.DecoratedEntity;
import common.Environment;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ColumnManager extends HttpServlet {

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		String characterEncoding = "UTF-8";
		request.setCharacterEncoding(characterEncoding);

		String contentType = "text/html; charset=UTF-8";
		response.setContentType(contentType);

		String envPath = getServletContext().getRealPath("/conf/env.ini");
		Environment env = Environment.getEnvironment();
		env.init(envPath);
		DBAccessWrapper db = new DBAccessWrapper(env);

		HttpSession session = request.getSession(false);
		String in_tableid = request.getParameter("tableid");
		if(in_tableid == null) {
			return;
		}
		String in_userid = (String)session.getAttribute("userid");
		if(in_userid == null) {
			return;
		}

		try {

			String conditionMaster = "";
			String conditionSetting = "";
			ArrayList<String> conditionTypes = new ArrayList<String>();
			ArrayList<Object> conditionValues = new ArrayList<Object>();

			conditionMaster = "self.TABLE_ID = ?";
			conditionSetting = "self.USER_NUMBER = ?";
			conditionTypes.add("string");
			conditionTypes.add("string");
			conditionValues.add(in_tableid);
			conditionValues.add(in_userid);

			db.connect();
			ClassColumnMaster clsColumnMaster = new ClassColumnMaster(db);
			ArrayList<DecoratedEntity> objects = clsColumnMaster.selectWithColumnSetting(conditionMaster, conditionSetting, conditionTypes, conditionValues);
			db.close();

			// XML作成
			DocumentBuilder documentBuilder = null;
			documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document document = documentBuilder.newDocument();

			Element elem_rows = document.createElement("rows");
			document.appendChild(elem_rows);

			Iterator<DecoratedEntity> itr = objects.iterator();
			while (itr.hasNext()) {
				DecoratedEntity decoratedEntity = itr.next();

				ColumnMaster columnMaster = (ColumnMaster) decoratedEntity.originator;
				ColumnSetting columnSetting = (ColumnSetting) decoratedEntity.decorator;

				String nodeText = "";
				Element elem_row = null;
				Element elem_cell = null;

				elem_row = document.createElement("row");
				elem_row.setAttribute("id", columnMaster.identification());
				elem_rows.appendChild(elem_row);

				// 列名
				nodeText = columnMaster.getProperties("COLUMN_ID");
				elem_cell = document.createElement("COLUMN_ID");
				elem_cell.appendChild(document.createTextNode(nodeText));
				elem_row.appendChild(elem_cell);

				// 列表示名
				nodeText = columnMaster.getProperties("COLUMN_VIEW_NAME");
				elem_cell = document.createElement("COLUMN_VIEW_NAME");
				elem_cell.appendChild(document.createTextNode(nodeText));
				elem_row.appendChild(elem_cell);

				// 列幅
				nodeText = columnSetting.getProperties("WITDH");
				elem_cell = document.createElement("WITDH");
				elem_cell.appendChild(document.createTextNode(nodeText));
				elem_row.appendChild(elem_cell);
			}

			// XML出力
			TransformerFactory tf = TransformerFactoryImpl.newInstance();
			tf.setAttribute(TransformerFactoryImpl.INDENT_NUMBER, "2");

			Transformer transformer = tf.newTransformer();
			transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			transformer.setOutputProperty(OutputKeys.METHOD, "xml");

			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer);

			DOMSource source = new DOMSource(document);
			transformer.transform(source, result);

			response.getWriter().println(writer.toString());

		} catch (SQLException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (ParserConfigurationException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (TransformerConfigurationException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (TransformerException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
	}
}
