package model;

import java.sql.SQLException;
import java.util.ArrayList;

import common.DBAccessWrapper;
import common.Entity;

/**
 *
 * @author 無糖ブラック
 *
 */
public class Account extends Entity {

	/**
	 *
	 * @param db
	 * @param keys
	 * @param values
	 */
	public Account(DBAccessWrapper db, ArrayList<String> keys, ArrayList<String> values) {
		super(db, keys,values);
	}

	/**
	 *
	 * @return
	 */
	public String number() {
		return properties.get("ACCOUNT_NUMBER");
	}

	/**
	 *
	 * @param number
	 */
	public void number(String number) {
		properties.put("ACCOUNT_NUMBER", number);
	}

	/**
	 *
	 * @param account
	 * @param userid
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public AccountStructure appendChild(Account account, String userid) throws SQLException, ClassNotFoundException {

		//構成検索
		ClassAccountStructure clsAccountStructure = new ClassAccountStructure(m_db);

		String identification = super.identification();
		long structOrder = clsAccountStructure.getMaxStructOrder(identification);
		++structOrder;

		ArrayList<String> insertParams = new ArrayList<String>();
		ArrayList<String> insertTypes = new ArrayList<String>();
		ArrayList<Object> insertValues = new ArrayList<Object>();

		insertParams.clear();
		insertParams.add("UPPER_IDENTIFICATION");
		insertParams.add("LOWER_IDENTIFICATION");
		insertParams.add("STRUCT_ORDER");
		insertParams.add("CREATE_PERSON");
		insertParams.add("MODIFY_PERSON");

		insertTypes.clear();
		insertTypes.add("int");
		insertTypes.add("int");
		insertTypes.add("int");
		insertTypes.add("string");
		insertTypes.add("string");

		insertValues.clear();
		insertValues.add(identification);
		insertValues.add(account.identification());
		insertValues.add(structOrder);
		insertValues.add(userid);
		insertValues.add(userid);

		return clsAccountStructure.create(insertParams, insertTypes, insertValues);
	}
}
