package model;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassAccount extends ClassModelObject {

	/**
	 *
	 */
	public ClassAccount() {
		this.m_tableName = "ACCOUNT";
	}

	/**
	 *
	 * @param db
	 */
	public ClassAccount(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "ACCOUNT";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<Account> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("ACCOUNT_NUMBER");
		selectParams.add("NAME");
		selectParams.add("AMOUNT");
		selectParams.add("CONSUMPTION_TAX_RATE");
		selectParams.add("ACCOUNT_TYPE");
		selectParams.add("DEBIT_CREDIT_TYPE");
		selectParams.add("BP_TYPE");
		selectParams.add("DEPARTMENT_NUMBER");
		selectParams.add("DISPLAY");
		selectParams.add("SYSTEM_FLAG");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<Account> objects = new ArrayList<Account>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			Account object = new Account(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}

	/**
	 *
	 * @param insertParams
	 * @param insertTypes
	 * @param insertValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public Account create(ArrayList<String> insertParams, ArrayList<String> insertTypes, ArrayList<Object> insertValues) throws SQLException, ClassNotFoundException {
		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.add("IDENTIFICATION");

		ArrayList<ArrayList<String>> rows = super.insert(insertParams, insertTypes, insertValues, selectParams);

		String identificaton = rows.get(0).get(0);
		String condition = "identification = ?";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();
		conditionTypes.add("int");
		conditionValues.add(identificaton);

		ArrayList<Account> accounts;
		accounts = select(condition, conditionTypes, conditionValues);

		return accounts.get(0);
	}

	/**
	 *
	 * @return
	 * @throws SQLException
	 */
	public int truncate() throws SQLException {
		int result = 0;

		//勘定科目構成テーブル初期化
		ClassAccountStructure clsAccountStructure = new ClassAccountStructure(m_db);
		result = clsAccountStructure.truncate();
		if ( result < 0 ) {
			return result;
		}

		//勘定科目品目関連テーブル初期化
		ClassAccountPart clsAccountPart = new ClassAccountPart(m_db);
		result = clsAccountPart.truncate();
		if ( result < 0 ) {
			return result;
		}

		result = super.truncate();
		return result;
	}
}
