package model;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassAccountStructure  extends ClassModelObject {

	/**
	 *
	 */
	public ClassAccountStructure() {
		this.m_tableName = "ACCOUNT_STRUCTURE";
	}

	/**
	 *
	 * @param db
	 */
	public ClassAccountStructure(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "ACCOUNT_STRUCTURE";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<AccountStructure> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("UPPER_IDENTIFICATION");
		selectParams.add("LOWER_IDENTIFICATION");
		selectParams.add("STRUCT_ORDER");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<AccountStructure> objects = new ArrayList<AccountStructure>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			AccountStructure object = new AccountStructure(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}

	/**
	 *
	 * @param upper_identification
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public long getMaxStructOrder(String upper_identification) throws SQLException, ClassNotFoundException {

		String condition = "";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();

		condition = "UPPER_IDENTIFICATION = ?";
		conditionTypes.add("int");
		conditionValues.add(upper_identification);

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("MAX(STRUCT_ORDER) AS STRUCT_ORDER");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<AccountStructure> objects = new ArrayList<AccountStructure>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			AccountStructure account = new AccountStructure(m_db, selectParams, row);
			objects.add(account);
		}

		long lngStructOrder = 0;
		String strStructOrder = rows.get(0).get(0);
		if ( strStructOrder != null ) {
			lngStructOrder = Integer.parseInt(strStructOrder);
		}

		return lngStructOrder;
	}

	/**
	 *
	 * @param insertParams
	 * @param insertTypes
	 * @param insertValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public AccountStructure create(ArrayList<String> insertParams, ArrayList<String> insertTypes, ArrayList<Object> insertValues) throws SQLException, ClassNotFoundException {
		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.add("IDENTIFICATION");

		ArrayList<ArrayList<String>> rows = super.insert(insertParams, insertTypes, insertValues, selectParams);

		String identificaton = rows.get(0).get(0);
		String condition = "identification = ?";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();
		conditionTypes.add("int");
		conditionValues.add(identificaton);

		ArrayList<AccountStructure> objects;
		objects = select(condition, conditionTypes, conditionValues);
		return objects.get(0);
	}
}
