package model;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassJournal extends ClassModelObject{

	/**
	 *
	 */
	public ClassJournal() {
		this.m_tableName = "JOURNAL";
	}

	/**
	 *
	 * @param db
	 */
	public ClassJournal(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "JOURNAL";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<Journal> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("DEALING_IDENTIFICATION");
		selectParams.add("DEALING_DATE");
		selectParams.add("LIFECYCLE_STATE");
		selectParams.add("PRICE");
		selectParams.add("QUANTITY");
		selectParams.add("AMOUNT");
		selectParams.add("DISCOUNT");
		selectParams.add("PART_NUMBER");
		selectParams.add("STRUCT_ORDER");
		selectParams.add("TEMPLATE_FLAG");
		selectParams.add("DEPARTMENT_NUMBER");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<Journal> objects = new ArrayList<Journal>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			Journal object = new Journal(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}
}
