package model;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassJournalDetails extends ClassModelObject{

	/**
	 *
	 */
	public ClassJournalDetails() {
		this.m_tableName = "JOURNAL_DETAILS";
	}

	/**
	 *
	 * @param db
	 */
	public ClassJournalDetails(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "JOURNAL_DETAILS";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<JournalDetails> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("SUPER_IDENTIFICATION");
		selectParams.add("LIFECYCLE_STATE");
		selectParams.add("BUDGET_NUMBER");
		selectParams.add("AMOUNT");
		selectParams.add("DEBIT_CREDIT_TYPE");
		selectParams.add("STRUCT_ORDER");
		selectParams.add("TEMPLATE_FLAG");
		selectParams.add("DEPARTMENT_NUMBER");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<JournalDetails> objects = new ArrayList<JournalDetails>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			JournalDetails object = new JournalDetails(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}
}
