package model;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassPart extends ClassModelObject{

	/**
	 *
	 */
	public ClassPart() {
		this.m_tableName = "PART";
	}

	/**
	 *
	 * @param db
	 */
	public ClassPart(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "PART";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<Part> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("PART_NUMBER");
		selectParams.add("NAME");
		selectParams.add("TRADE_NAME");
		selectParams.add("LIFECYCLE_STATE");
		selectParams.add("UNIT");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<Part> objects = new ArrayList<Part>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			Part object = new Part(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}
}
