package model;

import java.sql.SQLException;
import java.util.ArrayList;

import common.ClassModelObject;
import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ClassPartVersion extends ClassModelObject{

	/**
	 *
	 */
	public ClassPartVersion() {
		this.m_tableName = "PART_VERSION";
	}

	/**
	 *
	 * @param db
	 */
	public ClassPartVersion(DBAccessWrapper db) {
		super(db);
		this.m_tableName = "PART_VERSION";
	}

	/**
	 *
	 * @param condition
	 * @param conditionTypes
	 * @param conditionValues
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public ArrayList<PartVersion> select(String condition, ArrayList<String> conditionTypes, ArrayList<Object> conditionValues) throws SQLException, ClassNotFoundException {

		ArrayList<String> selectParams = new ArrayList<String>();
		selectParams.clear();
		selectParams.add("IDENTIFICATION");
		selectParams.add("LEFT_IDENTIFICATION");
		selectParams.add("RIGHT_IDENTIFICATION");
		selectParams.add("CREATE_DATE");
		selectParams.add("CREATE_PERSON");
		selectParams.add("MODIFY_DATE");
		selectParams.add("MODIFY_PERSON");

		ArrayList<ArrayList<String>> rows = super.select(selectParams, condition, conditionTypes, conditionValues);
		ArrayList<PartVersion> objects = new ArrayList<PartVersion>();
		for (int ii = 0; ii < rows.size(); ++ii) {
			ArrayList<String> row = rows.get(ii);
			PartVersion object = new PartVersion(m_db, selectParams, row);
			objects.add(object);
		}

		return objects;
	}
}
